# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PullThroughCacheRuleArgs', 'PullThroughCacheRule']

@pulumi.input_type
class PullThroughCacheRuleArgs:
    def __init__(__self__, *,
                 ecr_repository_prefix: pulumi.Input[_builtins.str],
                 upstream_registry_url: pulumi.Input[_builtins.str],
                 credential_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 upstream_repository_prefix: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PullThroughCacheRule resource.
        :param pulumi.Input[_builtins.str] ecr_repository_prefix: The repository name prefix to use when caching images from the source registry. Use `ROOT` as the prefix to apply a template to all repositories in your registry that don't have an associated pull through cache rule.
        :param pulumi.Input[_builtins.str] upstream_registry_url: The registry URL of the upstream registry to use as the source.
        :param pulumi.Input[_builtins.str] credential_arn: ARN of the Secret which will be used to authenticate against the registry.
        :param pulumi.Input[_builtins.str] custom_role_arn: The ARN of the IAM role associated with the pull through cache rule. Must be specified if the upstream registry is a cross-account ECR private registry. See [AWS Document - Setting up permissions for cross-account ECR to ECR PTC](https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache-private.html).
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] upstream_repository_prefix: The upstream repository prefix associated with the pull through cache rule. Used if the upstream registry is an ECR private registry. If not specified, it's set to `ROOT`, which allows matching with any upstream repository. See [AWS Document - Customizing repository prefixes for ECR to ECR pull through cache](https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache-private-wildcards.html).
        """
        pulumi.set(__self__, "ecr_repository_prefix", ecr_repository_prefix)
        pulumi.set(__self__, "upstream_registry_url", upstream_registry_url)
        if credential_arn is not None:
            pulumi.set(__self__, "credential_arn", credential_arn)
        if custom_role_arn is not None:
            pulumi.set(__self__, "custom_role_arn", custom_role_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if upstream_repository_prefix is not None:
            pulumi.set(__self__, "upstream_repository_prefix", upstream_repository_prefix)

    @_builtins.property
    @pulumi.getter(name="ecrRepositoryPrefix")
    def ecr_repository_prefix(self) -> pulumi.Input[_builtins.str]:
        """
        The repository name prefix to use when caching images from the source registry. Use `ROOT` as the prefix to apply a template to all repositories in your registry that don't have an associated pull through cache rule.
        """
        return pulumi.get(self, "ecr_repository_prefix")

    @ecr_repository_prefix.setter
    def ecr_repository_prefix(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ecr_repository_prefix", value)

    @_builtins.property
    @pulumi.getter(name="upstreamRegistryUrl")
    def upstream_registry_url(self) -> pulumi.Input[_builtins.str]:
        """
        The registry URL of the upstream registry to use as the source.
        """
        return pulumi.get(self, "upstream_registry_url")

    @upstream_registry_url.setter
    def upstream_registry_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "upstream_registry_url", value)

    @_builtins.property
    @pulumi.getter(name="credentialArn")
    def credential_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Secret which will be used to authenticate against the registry.
        """
        return pulumi.get(self, "credential_arn")

    @credential_arn.setter
    def credential_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credential_arn", value)

    @_builtins.property
    @pulumi.getter(name="customRoleArn")
    def custom_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the IAM role associated with the pull through cache rule. Must be specified if the upstream registry is a cross-account ECR private registry. See [AWS Document - Setting up permissions for cross-account ECR to ECR PTC](https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache-private.html).
        """
        return pulumi.get(self, "custom_role_arn")

    @custom_role_arn.setter
    def custom_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_role_arn", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="upstreamRepositoryPrefix")
    def upstream_repository_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The upstream repository prefix associated with the pull through cache rule. Used if the upstream registry is an ECR private registry. If not specified, it's set to `ROOT`, which allows matching with any upstream repository. See [AWS Document - Customizing repository prefixes for ECR to ECR pull through cache](https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache-private-wildcards.html).
        """
        return pulumi.get(self, "upstream_repository_prefix")

    @upstream_repository_prefix.setter
    def upstream_repository_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upstream_repository_prefix", value)


@pulumi.input_type
class _PullThroughCacheRuleState:
    def __init__(__self__, *,
                 credential_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 ecr_repository_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 registry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 upstream_registry_url: Optional[pulumi.Input[_builtins.str]] = None,
                 upstream_repository_prefix: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PullThroughCacheRule resources.
        :param pulumi.Input[_builtins.str] credential_arn: ARN of the Secret which will be used to authenticate against the registry.
        :param pulumi.Input[_builtins.str] custom_role_arn: The ARN of the IAM role associated with the pull through cache rule. Must be specified if the upstream registry is a cross-account ECR private registry. See [AWS Document - Setting up permissions for cross-account ECR to ECR PTC](https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache-private.html).
        :param pulumi.Input[_builtins.str] ecr_repository_prefix: The repository name prefix to use when caching images from the source registry. Use `ROOT` as the prefix to apply a template to all repositories in your registry that don't have an associated pull through cache rule.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] registry_id: The registry ID where the repository was created.
        :param pulumi.Input[_builtins.str] upstream_registry_url: The registry URL of the upstream registry to use as the source.
        :param pulumi.Input[_builtins.str] upstream_repository_prefix: The upstream repository prefix associated with the pull through cache rule. Used if the upstream registry is an ECR private registry. If not specified, it's set to `ROOT`, which allows matching with any upstream repository. See [AWS Document - Customizing repository prefixes for ECR to ECR pull through cache](https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache-private-wildcards.html).
        """
        if credential_arn is not None:
            pulumi.set(__self__, "credential_arn", credential_arn)
        if custom_role_arn is not None:
            pulumi.set(__self__, "custom_role_arn", custom_role_arn)
        if ecr_repository_prefix is not None:
            pulumi.set(__self__, "ecr_repository_prefix", ecr_repository_prefix)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if registry_id is not None:
            pulumi.set(__self__, "registry_id", registry_id)
        if upstream_registry_url is not None:
            pulumi.set(__self__, "upstream_registry_url", upstream_registry_url)
        if upstream_repository_prefix is not None:
            pulumi.set(__self__, "upstream_repository_prefix", upstream_repository_prefix)

    @_builtins.property
    @pulumi.getter(name="credentialArn")
    def credential_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Secret which will be used to authenticate against the registry.
        """
        return pulumi.get(self, "credential_arn")

    @credential_arn.setter
    def credential_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credential_arn", value)

    @_builtins.property
    @pulumi.getter(name="customRoleArn")
    def custom_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the IAM role associated with the pull through cache rule. Must be specified if the upstream registry is a cross-account ECR private registry. See [AWS Document - Setting up permissions for cross-account ECR to ECR PTC](https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache-private.html).
        """
        return pulumi.get(self, "custom_role_arn")

    @custom_role_arn.setter
    def custom_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="ecrRepositoryPrefix")
    def ecr_repository_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The repository name prefix to use when caching images from the source registry. Use `ROOT` as the prefix to apply a template to all repositories in your registry that don't have an associated pull through cache rule.
        """
        return pulumi.get(self, "ecr_repository_prefix")

    @ecr_repository_prefix.setter
    def ecr_repository_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ecr_repository_prefix", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The registry ID where the repository was created.
        """
        return pulumi.get(self, "registry_id")

    @registry_id.setter
    def registry_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "registry_id", value)

    @_builtins.property
    @pulumi.getter(name="upstreamRegistryUrl")
    def upstream_registry_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The registry URL of the upstream registry to use as the source.
        """
        return pulumi.get(self, "upstream_registry_url")

    @upstream_registry_url.setter
    def upstream_registry_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upstream_registry_url", value)

    @_builtins.property
    @pulumi.getter(name="upstreamRepositoryPrefix")
    def upstream_repository_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The upstream repository prefix associated with the pull through cache rule. Used if the upstream registry is an ECR private registry. If not specified, it's set to `ROOT`, which allows matching with any upstream repository. See [AWS Document - Customizing repository prefixes for ECR to ECR pull through cache](https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache-private-wildcards.html).
        """
        return pulumi.get(self, "upstream_repository_prefix")

    @upstream_repository_prefix.setter
    def upstream_repository_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upstream_repository_prefix", value)


@pulumi.type_token("aws:ecr/pullThroughCacheRule:PullThroughCacheRule")
class PullThroughCacheRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credential_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 ecr_repository_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 upstream_registry_url: Optional[pulumi.Input[_builtins.str]] = None,
                 upstream_repository_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an Elastic Container Registry Pull Through Cache Rule.

        More information about pull through cache rules, including the set of supported
        upstream repositories, see [Using pull through cache rules](https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ecr.PullThroughCacheRule("example",
            ecr_repository_prefix="ecr-public",
            upstream_registry_url="public.ecr.aws",
            credential_arn="arn:aws:secretsmanager:us-east-1:123456789:secret:ecr-pullthroughcache/ecrpublic")
        ```

        ## Import

        Using `pulumi import`, import a pull-through cache rule using the `ecr_repository_prefix`. For example:

        ```sh
        $ pulumi import aws:ecr/pullThroughCacheRule:PullThroughCacheRule example ecr-public
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] credential_arn: ARN of the Secret which will be used to authenticate against the registry.
        :param pulumi.Input[_builtins.str] custom_role_arn: The ARN of the IAM role associated with the pull through cache rule. Must be specified if the upstream registry is a cross-account ECR private registry. See [AWS Document - Setting up permissions for cross-account ECR to ECR PTC](https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache-private.html).
        :param pulumi.Input[_builtins.str] ecr_repository_prefix: The repository name prefix to use when caching images from the source registry. Use `ROOT` as the prefix to apply a template to all repositories in your registry that don't have an associated pull through cache rule.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] upstream_registry_url: The registry URL of the upstream registry to use as the source.
        :param pulumi.Input[_builtins.str] upstream_repository_prefix: The upstream repository prefix associated with the pull through cache rule. Used if the upstream registry is an ECR private registry. If not specified, it's set to `ROOT`, which allows matching with any upstream repository. See [AWS Document - Customizing repository prefixes for ECR to ECR pull through cache](https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache-private-wildcards.html).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PullThroughCacheRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Elastic Container Registry Pull Through Cache Rule.

        More information about pull through cache rules, including the set of supported
        upstream repositories, see [Using pull through cache rules](https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ecr.PullThroughCacheRule("example",
            ecr_repository_prefix="ecr-public",
            upstream_registry_url="public.ecr.aws",
            credential_arn="arn:aws:secretsmanager:us-east-1:123456789:secret:ecr-pullthroughcache/ecrpublic")
        ```

        ## Import

        Using `pulumi import`, import a pull-through cache rule using the `ecr_repository_prefix`. For example:

        ```sh
        $ pulumi import aws:ecr/pullThroughCacheRule:PullThroughCacheRule example ecr-public
        ```

        :param str resource_name: The name of the resource.
        :param PullThroughCacheRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PullThroughCacheRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credential_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 ecr_repository_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 upstream_registry_url: Optional[pulumi.Input[_builtins.str]] = None,
                 upstream_repository_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PullThroughCacheRuleArgs.__new__(PullThroughCacheRuleArgs)

            __props__.__dict__["credential_arn"] = credential_arn
            __props__.__dict__["custom_role_arn"] = custom_role_arn
            if ecr_repository_prefix is None and not opts.urn:
                raise TypeError("Missing required property 'ecr_repository_prefix'")
            __props__.__dict__["ecr_repository_prefix"] = ecr_repository_prefix
            __props__.__dict__["region"] = region
            if upstream_registry_url is None and not opts.urn:
                raise TypeError("Missing required property 'upstream_registry_url'")
            __props__.__dict__["upstream_registry_url"] = upstream_registry_url
            __props__.__dict__["upstream_repository_prefix"] = upstream_repository_prefix
            __props__.__dict__["registry_id"] = None
        super(PullThroughCacheRule, __self__).__init__(
            'aws:ecr/pullThroughCacheRule:PullThroughCacheRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            credential_arn: Optional[pulumi.Input[_builtins.str]] = None,
            custom_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            ecr_repository_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            registry_id: Optional[pulumi.Input[_builtins.str]] = None,
            upstream_registry_url: Optional[pulumi.Input[_builtins.str]] = None,
            upstream_repository_prefix: Optional[pulumi.Input[_builtins.str]] = None) -> 'PullThroughCacheRule':
        """
        Get an existing PullThroughCacheRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] credential_arn: ARN of the Secret which will be used to authenticate against the registry.
        :param pulumi.Input[_builtins.str] custom_role_arn: The ARN of the IAM role associated with the pull through cache rule. Must be specified if the upstream registry is a cross-account ECR private registry. See [AWS Document - Setting up permissions for cross-account ECR to ECR PTC](https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache-private.html).
        :param pulumi.Input[_builtins.str] ecr_repository_prefix: The repository name prefix to use when caching images from the source registry. Use `ROOT` as the prefix to apply a template to all repositories in your registry that don't have an associated pull through cache rule.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] registry_id: The registry ID where the repository was created.
        :param pulumi.Input[_builtins.str] upstream_registry_url: The registry URL of the upstream registry to use as the source.
        :param pulumi.Input[_builtins.str] upstream_repository_prefix: The upstream repository prefix associated with the pull through cache rule. Used if the upstream registry is an ECR private registry. If not specified, it's set to `ROOT`, which allows matching with any upstream repository. See [AWS Document - Customizing repository prefixes for ECR to ECR pull through cache](https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache-private-wildcards.html).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PullThroughCacheRuleState.__new__(_PullThroughCacheRuleState)

        __props__.__dict__["credential_arn"] = credential_arn
        __props__.__dict__["custom_role_arn"] = custom_role_arn
        __props__.__dict__["ecr_repository_prefix"] = ecr_repository_prefix
        __props__.__dict__["region"] = region
        __props__.__dict__["registry_id"] = registry_id
        __props__.__dict__["upstream_registry_url"] = upstream_registry_url
        __props__.__dict__["upstream_repository_prefix"] = upstream_repository_prefix
        return PullThroughCacheRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="credentialArn")
    def credential_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ARN of the Secret which will be used to authenticate against the registry.
        """
        return pulumi.get(self, "credential_arn")

    @_builtins.property
    @pulumi.getter(name="customRoleArn")
    def custom_role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ARN of the IAM role associated with the pull through cache rule. Must be specified if the upstream registry is a cross-account ECR private registry. See [AWS Document - Setting up permissions for cross-account ECR to ECR PTC](https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache-private.html).
        """
        return pulumi.get(self, "custom_role_arn")

    @_builtins.property
    @pulumi.getter(name="ecrRepositoryPrefix")
    def ecr_repository_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        The repository name prefix to use when caching images from the source registry. Use `ROOT` as the prefix to apply a template to all repositories in your registry that don't have an associated pull through cache rule.
        """
        return pulumi.get(self, "ecr_repository_prefix")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> pulumi.Output[_builtins.str]:
        """
        The registry ID where the repository was created.
        """
        return pulumi.get(self, "registry_id")

    @_builtins.property
    @pulumi.getter(name="upstreamRegistryUrl")
    def upstream_registry_url(self) -> pulumi.Output[_builtins.str]:
        """
        The registry URL of the upstream registry to use as the source.
        """
        return pulumi.get(self, "upstream_registry_url")

    @_builtins.property
    @pulumi.getter(name="upstreamRepositoryPrefix")
    def upstream_repository_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The upstream repository prefix associated with the pull through cache rule. Used if the upstream registry is an ECR private registry. If not specified, it's set to `ROOT`, which allows matching with any upstream repository. See [AWS Document - Customizing repository prefixes for ECR to ECR pull through cache](https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache-private-wildcards.html).
        """
        return pulumi.get(self, "upstream_repository_prefix")

