# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTaskDefinitionResult',
    'AwaitableGetTaskDefinitionResult',
    'get_task_definition',
    'get_task_definition_output',
]

@pulumi.output_type
class GetTaskDefinitionResult:
    """
    A collection of values returned by getTaskDefinition.
    """
    def __init__(__self__, arn=None, arn_without_revision=None, container_definitions=None, cpu=None, enable_fault_injection=None, ephemeral_storages=None, execution_role_arn=None, family=None, id=None, ipc_mode=None, memory=None, network_mode=None, pid_mode=None, placement_constraints=None, proxy_configurations=None, region=None, requires_compatibilities=None, revision=None, runtime_platforms=None, status=None, task_definition=None, task_role_arn=None, volumes=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if arn_without_revision and not isinstance(arn_without_revision, str):
            raise TypeError("Expected argument 'arn_without_revision' to be a str")
        pulumi.set(__self__, "arn_without_revision", arn_without_revision)
        if container_definitions and not isinstance(container_definitions, str):
            raise TypeError("Expected argument 'container_definitions' to be a str")
        pulumi.set(__self__, "container_definitions", container_definitions)
        if cpu and not isinstance(cpu, str):
            raise TypeError("Expected argument 'cpu' to be a str")
        pulumi.set(__self__, "cpu", cpu)
        if enable_fault_injection and not isinstance(enable_fault_injection, bool):
            raise TypeError("Expected argument 'enable_fault_injection' to be a bool")
        pulumi.set(__self__, "enable_fault_injection", enable_fault_injection)
        if ephemeral_storages and not isinstance(ephemeral_storages, list):
            raise TypeError("Expected argument 'ephemeral_storages' to be a list")
        pulumi.set(__self__, "ephemeral_storages", ephemeral_storages)
        if execution_role_arn and not isinstance(execution_role_arn, str):
            raise TypeError("Expected argument 'execution_role_arn' to be a str")
        pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if family and not isinstance(family, str):
            raise TypeError("Expected argument 'family' to be a str")
        pulumi.set(__self__, "family", family)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipc_mode and not isinstance(ipc_mode, str):
            raise TypeError("Expected argument 'ipc_mode' to be a str")
        pulumi.set(__self__, "ipc_mode", ipc_mode)
        if memory and not isinstance(memory, str):
            raise TypeError("Expected argument 'memory' to be a str")
        pulumi.set(__self__, "memory", memory)
        if network_mode and not isinstance(network_mode, str):
            raise TypeError("Expected argument 'network_mode' to be a str")
        pulumi.set(__self__, "network_mode", network_mode)
        if pid_mode and not isinstance(pid_mode, str):
            raise TypeError("Expected argument 'pid_mode' to be a str")
        pulumi.set(__self__, "pid_mode", pid_mode)
        if placement_constraints and not isinstance(placement_constraints, list):
            raise TypeError("Expected argument 'placement_constraints' to be a list")
        pulumi.set(__self__, "placement_constraints", placement_constraints)
        if proxy_configurations and not isinstance(proxy_configurations, list):
            raise TypeError("Expected argument 'proxy_configurations' to be a list")
        pulumi.set(__self__, "proxy_configurations", proxy_configurations)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if requires_compatibilities and not isinstance(requires_compatibilities, list):
            raise TypeError("Expected argument 'requires_compatibilities' to be a list")
        pulumi.set(__self__, "requires_compatibilities", requires_compatibilities)
        if revision and not isinstance(revision, int):
            raise TypeError("Expected argument 'revision' to be a int")
        pulumi.set(__self__, "revision", revision)
        if runtime_platforms and not isinstance(runtime_platforms, list):
            raise TypeError("Expected argument 'runtime_platforms' to be a list")
        pulumi.set(__self__, "runtime_platforms", runtime_platforms)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if task_definition and not isinstance(task_definition, str):
            raise TypeError("Expected argument 'task_definition' to be a str")
        pulumi.set(__self__, "task_definition", task_definition)
        if task_role_arn and not isinstance(task_role_arn, str):
            raise TypeError("Expected argument 'task_role_arn' to be a str")
        pulumi.set(__self__, "task_role_arn", task_role_arn)
        if volumes and not isinstance(volumes, list):
            raise TypeError("Expected argument 'volumes' to be a list")
        pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the task definition.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="arnWithoutRevision")
    def arn_without_revision(self) -> _builtins.str:
        """
        ARN of the Task Definition with the trailing `revision` removed. This may be useful for situations where the latest task definition is always desired. If a revision isn't specified, the latest ACTIVE revision is used. See the [AWS documentation](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_StartTask.html#ECS-StartTask-request-taskDefinition) for details.
        """
        return pulumi.get(self, "arn_without_revision")

    @_builtins.property
    @pulumi.getter(name="containerDefinitions")
    def container_definitions(self) -> _builtins.str:
        """
        A list of valid [container definitions](http://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html) provided as a single valid JSON document. Please note that you should only provide values that are part of the container definition document. For a detailed description of what parameters are available, see the [Task Definition Parameters](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html) section from the official [Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide).
        """
        return pulumi.get(self, "container_definitions")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.str:
        """
        Number of cpu units used by the task. If the `requires_compatibilities` is `FARGATE` this field is required.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="enableFaultInjection")
    def enable_fault_injection(self) -> _builtins.bool:
        """
        Enables fault injection and allows for fault injection requests to be accepted from the task's containers. Default is `false`.
        """
        return pulumi.get(self, "enable_fault_injection")

    @_builtins.property
    @pulumi.getter(name="ephemeralStorages")
    def ephemeral_storages(self) -> Sequence['outputs.GetTaskDefinitionEphemeralStorageResult']:
        """
        The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate. See Ephemeral Storage.
        """
        return pulumi.get(self, "ephemeral_storages")

    @_builtins.property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> _builtins.str:
        """
        ARN of the task execution role that the Amazon ECS container agent and the Docker daemon can assume.
        """
        return pulumi.get(self, "execution_role_arn")

    @_builtins.property
    @pulumi.getter
    def family(self) -> _builtins.str:
        """
        A unique name for your task definition.
        The following arguments are optional:
        """
        return pulumi.get(self, "family")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipcMode")
    def ipc_mode(self) -> _builtins.str:
        """
        IPC resource namespace to be used for the containers in the task The valid values are `host`, `task`, and `none`.
        """
        return pulumi.get(self, "ipc_mode")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> _builtins.str:
        """
        Amount (in MiB) of memory used by the task. If the `requires_compatibilities` is `FARGATE` this field is required.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter(name="networkMode")
    def network_mode(self) -> _builtins.str:
        """
        Docker networking mode to use for the containers in the task. Valid values are `none`, `bridge`, `awsvpc`, and `host`.
        """
        return pulumi.get(self, "network_mode")

    @_builtins.property
    @pulumi.getter(name="pidMode")
    def pid_mode(self) -> _builtins.str:
        """
        Process namespace to use for the containers in the task. The valid values are `host` and `task`.
        """
        return pulumi.get(self, "pid_mode")

    @_builtins.property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> Sequence['outputs.GetTaskDefinitionPlacementConstraintResult']:
        """
        Configuration block for rules that are taken into consideration during task placement. Maximum number of `placement_constraints` is `10`. Detailed below.
        """
        return pulumi.get(self, "placement_constraints")

    @_builtins.property
    @pulumi.getter(name="proxyConfigurations")
    def proxy_configurations(self) -> Sequence['outputs.GetTaskDefinitionProxyConfigurationResult']:
        """
        Configuration block for the App Mesh proxy. Detailed below.
        """
        return pulumi.get(self, "proxy_configurations")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="requiresCompatibilities")
    def requires_compatibilities(self) -> Sequence[_builtins.str]:
        """
        Set of launch types required by the task. The valid values are `EC2` and `FARGATE`.
        """
        return pulumi.get(self, "requires_compatibilities")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> _builtins.int:
        """
        Revision of the task in a particular family.
        """
        return pulumi.get(self, "revision")

    @_builtins.property
    @pulumi.getter(name="runtimePlatforms")
    def runtime_platforms(self) -> Sequence['outputs.GetTaskDefinitionRuntimePlatformResult']:
        """
        Configuration block for runtime_platform that containers in your task may use.
        """
        return pulumi.get(self, "runtime_platforms")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the task definition.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="taskDefinition")
    def task_definition(self) -> _builtins.str:
        return pulumi.get(self, "task_definition")

    @_builtins.property
    @pulumi.getter(name="taskRoleArn")
    def task_role_arn(self) -> _builtins.str:
        """
        ARN of IAM role that allows your Amazon ECS container task to make calls to other AWS services.
        """
        return pulumi.get(self, "task_role_arn")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GetTaskDefinitionVolumeResult']:
        """
        Configuration block for volumes that containers in your task may use. Detailed below.
        """
        return pulumi.get(self, "volumes")


class AwaitableGetTaskDefinitionResult(GetTaskDefinitionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTaskDefinitionResult(
            arn=self.arn,
            arn_without_revision=self.arn_without_revision,
            container_definitions=self.container_definitions,
            cpu=self.cpu,
            enable_fault_injection=self.enable_fault_injection,
            ephemeral_storages=self.ephemeral_storages,
            execution_role_arn=self.execution_role_arn,
            family=self.family,
            id=self.id,
            ipc_mode=self.ipc_mode,
            memory=self.memory,
            network_mode=self.network_mode,
            pid_mode=self.pid_mode,
            placement_constraints=self.placement_constraints,
            proxy_configurations=self.proxy_configurations,
            region=self.region,
            requires_compatibilities=self.requires_compatibilities,
            revision=self.revision,
            runtime_platforms=self.runtime_platforms,
            status=self.status,
            task_definition=self.task_definition,
            task_role_arn=self.task_role_arn,
            volumes=self.volumes)


def get_task_definition(region: Optional[_builtins.str] = None,
                        task_definition: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTaskDefinitionResult:
    """
    The ECS task definition data source allows access to details of
    a specific AWS ECS task definition.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    mongo_task_definition = aws.ecs.TaskDefinition("mongo",
        family="mongodb",
        container_definitions=\"\"\"[
      {
        "cpu": 128,
        "environment": [{
          "name": "SECRET",
          "value": "KEY"
        }],
        "essential": true,
        "image": "mongo:latest",
        "memory": 128,
        "memoryReservation": 64,
        "name": "mongodb"
      }
    ]
    \"\"\")
    # Simply specify the family to find the latest ACTIVE revision in that family.
    mongo = aws.ecs.get_task_definition_output(task_definition=mongo_task_definition.family)
    foo = aws.ecs.Cluster("foo", name="foo")
    mongo_service = aws.ecs.Service("mongo",
        name="mongo",
        cluster=foo.id,
        desired_count=2,
        task_definition=mongo.arn)
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str task_definition: Family for the latest ACTIVE revision, family and revision (family:revision) for a specific revision in the family, the ARN of the task definition to access to.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['taskDefinition'] = task_definition
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ecs/getTaskDefinition:getTaskDefinition', __args__, opts=opts, typ=GetTaskDefinitionResult).value

    return AwaitableGetTaskDefinitionResult(
        arn=pulumi.get(__ret__, 'arn'),
        arn_without_revision=pulumi.get(__ret__, 'arn_without_revision'),
        container_definitions=pulumi.get(__ret__, 'container_definitions'),
        cpu=pulumi.get(__ret__, 'cpu'),
        enable_fault_injection=pulumi.get(__ret__, 'enable_fault_injection'),
        ephemeral_storages=pulumi.get(__ret__, 'ephemeral_storages'),
        execution_role_arn=pulumi.get(__ret__, 'execution_role_arn'),
        family=pulumi.get(__ret__, 'family'),
        id=pulumi.get(__ret__, 'id'),
        ipc_mode=pulumi.get(__ret__, 'ipc_mode'),
        memory=pulumi.get(__ret__, 'memory'),
        network_mode=pulumi.get(__ret__, 'network_mode'),
        pid_mode=pulumi.get(__ret__, 'pid_mode'),
        placement_constraints=pulumi.get(__ret__, 'placement_constraints'),
        proxy_configurations=pulumi.get(__ret__, 'proxy_configurations'),
        region=pulumi.get(__ret__, 'region'),
        requires_compatibilities=pulumi.get(__ret__, 'requires_compatibilities'),
        revision=pulumi.get(__ret__, 'revision'),
        runtime_platforms=pulumi.get(__ret__, 'runtime_platforms'),
        status=pulumi.get(__ret__, 'status'),
        task_definition=pulumi.get(__ret__, 'task_definition'),
        task_role_arn=pulumi.get(__ret__, 'task_role_arn'),
        volumes=pulumi.get(__ret__, 'volumes'))
def get_task_definition_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               task_definition: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTaskDefinitionResult]:
    """
    The ECS task definition data source allows access to details of
    a specific AWS ECS task definition.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    mongo_task_definition = aws.ecs.TaskDefinition("mongo",
        family="mongodb",
        container_definitions=\"\"\"[
      {
        "cpu": 128,
        "environment": [{
          "name": "SECRET",
          "value": "KEY"
        }],
        "essential": true,
        "image": "mongo:latest",
        "memory": 128,
        "memoryReservation": 64,
        "name": "mongodb"
      }
    ]
    \"\"\")
    # Simply specify the family to find the latest ACTIVE revision in that family.
    mongo = aws.ecs.get_task_definition_output(task_definition=mongo_task_definition.family)
    foo = aws.ecs.Cluster("foo", name="foo")
    mongo_service = aws.ecs.Service("mongo",
        name="mongo",
        cluster=foo.id,
        desired_count=2,
        task_definition=mongo.arn)
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str task_definition: Family for the latest ACTIVE revision, family and revision (family:revision) for a specific revision in the family, the ARN of the task definition to access to.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['taskDefinition'] = task_definition
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ecs/getTaskDefinition:getTaskDefinition', __args__, opts=opts, typ=GetTaskDefinitionResult)
    return __ret__.apply(lambda __response__: GetTaskDefinitionResult(
        arn=pulumi.get(__response__, 'arn'),
        arn_without_revision=pulumi.get(__response__, 'arn_without_revision'),
        container_definitions=pulumi.get(__response__, 'container_definitions'),
        cpu=pulumi.get(__response__, 'cpu'),
        enable_fault_injection=pulumi.get(__response__, 'enable_fault_injection'),
        ephemeral_storages=pulumi.get(__response__, 'ephemeral_storages'),
        execution_role_arn=pulumi.get(__response__, 'execution_role_arn'),
        family=pulumi.get(__response__, 'family'),
        id=pulumi.get(__response__, 'id'),
        ipc_mode=pulumi.get(__response__, 'ipc_mode'),
        memory=pulumi.get(__response__, 'memory'),
        network_mode=pulumi.get(__response__, 'network_mode'),
        pid_mode=pulumi.get(__response__, 'pid_mode'),
        placement_constraints=pulumi.get(__response__, 'placement_constraints'),
        proxy_configurations=pulumi.get(__response__, 'proxy_configurations'),
        region=pulumi.get(__response__, 'region'),
        requires_compatibilities=pulumi.get(__response__, 'requires_compatibilities'),
        revision=pulumi.get(__response__, 'revision'),
        runtime_platforms=pulumi.get(__response__, 'runtime_platforms'),
        status=pulumi.get(__response__, 'status'),
        task_definition=pulumi.get(__response__, 'task_definition'),
        task_role_arn=pulumi.get(__response__, 'task_role_arn'),
        volumes=pulumi.get(__response__, 'volumes')))
