# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['StudioArgs', 'Studio']

@pulumi.input_type
class StudioArgs:
    def __init__(__self__, *,
                 auth_mode: pulumi.Input[_builtins.str],
                 default_s3_location: pulumi.Input[_builtins.str],
                 engine_security_group_id: pulumi.Input[_builtins.str],
                 service_role: pulumi.Input[_builtins.str],
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 vpc_id: pulumi.Input[_builtins.str],
                 workspace_security_group_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 idp_auth_url: Optional[pulumi.Input[_builtins.str]] = None,
                 idp_relay_state_parameter_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_role: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Studio resource.
        :param pulumi.Input[_builtins.str] auth_mode: Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO. Valid values are `SSO` or `IAM`.
        :param pulumi.Input[_builtins.str] default_s3_location: The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
        :param pulumi.Input[_builtins.str] engine_security_group_id: The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by `vpc_id`.
        :param pulumi.Input[_builtins.str] service_role: The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to interoperate with other Amazon Web Services services.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_ids: A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by `vpc_id`. Studio users can create a Workspace in any of the specified subnets.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.
        :param pulumi.Input[_builtins.str] workspace_security_group_id: The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound network traffic to resources in the Engine security group, and it must be in the same VPC specified by `vpc_id`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] description: A detailed description of the Amazon EMR Studio.
        :param pulumi.Input[_builtins.str] encryption_key_arn: The AWS KMS key identifier (ARN) used to encrypt Amazon EMR Studio workspace and notebook files when backed up to Amazon S3.
        :param pulumi.Input[_builtins.str] idp_auth_url: The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.
        :param pulumi.Input[_builtins.str] idp_relay_state_parameter_name: The name that your identity provider (IdP) uses for its RelayState parameter. For example, RelayState or TargetSource. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The RelayState parameter differs by IdP.
        :param pulumi.Input[_builtins.str] name: A descriptive name for the Amazon EMR Studio.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] user_role: The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a User Role when you use Amazon Web Services SSO authentication. The permissions attached to the User Role can be scoped down for each user or group using session policies.
        """
        pulumi.set(__self__, "auth_mode", auth_mode)
        pulumi.set(__self__, "default_s3_location", default_s3_location)
        pulumi.set(__self__, "engine_security_group_id", engine_security_group_id)
        pulumi.set(__self__, "service_role", service_role)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "workspace_security_group_id", workspace_security_group_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_key_arn is not None:
            pulumi.set(__self__, "encryption_key_arn", encryption_key_arn)
        if idp_auth_url is not None:
            pulumi.set(__self__, "idp_auth_url", idp_auth_url)
        if idp_relay_state_parameter_name is not None:
            pulumi.set(__self__, "idp_relay_state_parameter_name", idp_relay_state_parameter_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_role is not None:
            pulumi.set(__self__, "user_role", user_role)

    @_builtins.property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO. Valid values are `SSO` or `IAM`.
        """
        return pulumi.get(self, "auth_mode")

    @auth_mode.setter
    def auth_mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "auth_mode", value)

    @_builtins.property
    @pulumi.getter(name="defaultS3Location")
    def default_s3_location(self) -> pulumi.Input[_builtins.str]:
        """
        The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
        """
        return pulumi.get(self, "default_s3_location")

    @default_s3_location.setter
    def default_s3_location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "default_s3_location", value)

    @_builtins.property
    @pulumi.getter(name="engineSecurityGroupId")
    def engine_security_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by `vpc_id`.
        """
        return pulumi.get(self, "engine_security_group_id")

    @engine_security_group_id.setter
    def engine_security_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "engine_security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> pulumi.Input[_builtins.str]:
        """
        The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to interoperate with other Amazon Web Services services.
        """
        return pulumi.get(self, "service_role")

    @service_role.setter
    def service_role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_role", value)

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by `vpc_id`. Studio users can create a Workspace in any of the specified subnets.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "subnet_ids", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="workspaceSecurityGroupId")
    def workspace_security_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound network traffic to resources in the Engine security group, and it must be in the same VPC specified by `vpc_id`.

        The following arguments are optional:
        """
        return pulumi.get(self, "workspace_security_group_id")

    @workspace_security_group_id.setter
    def workspace_security_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_security_group_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A detailed description of the Amazon EMR Studio.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="encryptionKeyArn")
    def encryption_key_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS KMS key identifier (ARN) used to encrypt Amazon EMR Studio workspace and notebook files when backed up to Amazon S3.
        """
        return pulumi.get(self, "encryption_key_arn")

    @encryption_key_arn.setter
    def encryption_key_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_key_arn", value)

    @_builtins.property
    @pulumi.getter(name="idpAuthUrl")
    def idp_auth_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.
        """
        return pulumi.get(self, "idp_auth_url")

    @idp_auth_url.setter
    def idp_auth_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "idp_auth_url", value)

    @_builtins.property
    @pulumi.getter(name="idpRelayStateParameterName")
    def idp_relay_state_parameter_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name that your identity provider (IdP) uses for its RelayState parameter. For example, RelayState or TargetSource. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The RelayState parameter differs by IdP.
        """
        return pulumi.get(self, "idp_relay_state_parameter_name")

    @idp_relay_state_parameter_name.setter
    def idp_relay_state_parameter_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "idp_relay_state_parameter_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A descriptive name for the Amazon EMR Studio.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userRole")
    def user_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a User Role when you use Amazon Web Services SSO authentication. The permissions attached to the User Role can be scoped down for each user or group using session policies.
        """
        return pulumi.get(self, "user_role")

    @user_role.setter
    def user_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_role", value)


@pulumi.input_type
class _StudioState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 default_s3_location: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 idp_auth_url: Optional[pulumi.Input[_builtins.str]] = None,
                 idp_relay_state_parameter_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_role: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 user_role: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_security_group_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Studio resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the studio.
        :param pulumi.Input[_builtins.str] auth_mode: Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO. Valid values are `SSO` or `IAM`.
        :param pulumi.Input[_builtins.str] default_s3_location: The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
        :param pulumi.Input[_builtins.str] description: A detailed description of the Amazon EMR Studio.
        :param pulumi.Input[_builtins.str] encryption_key_arn: The AWS KMS key identifier (ARN) used to encrypt Amazon EMR Studio workspace and notebook files when backed up to Amazon S3.
        :param pulumi.Input[_builtins.str] engine_security_group_id: The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by `vpc_id`.
        :param pulumi.Input[_builtins.str] idp_auth_url: The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.
        :param pulumi.Input[_builtins.str] idp_relay_state_parameter_name: The name that your identity provider (IdP) uses for its RelayState parameter. For example, RelayState or TargetSource. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The RelayState parameter differs by IdP.
        :param pulumi.Input[_builtins.str] name: A descriptive name for the Amazon EMR Studio.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] service_role: The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to interoperate with other Amazon Web Services services.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_ids: A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by `vpc_id`. Studio users can create a Workspace in any of the specified subnets.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] url: The unique access URL of the Amazon EMR Studio.
        :param pulumi.Input[_builtins.str] user_role: The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a User Role when you use Amazon Web Services SSO authentication. The permissions attached to the User Role can be scoped down for each user or group using session policies.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.
        :param pulumi.Input[_builtins.str] workspace_security_group_id: The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound network traffic to resources in the Engine security group, and it must be in the same VPC specified by `vpc_id`.
               
               The following arguments are optional:
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auth_mode is not None:
            pulumi.set(__self__, "auth_mode", auth_mode)
        if default_s3_location is not None:
            pulumi.set(__self__, "default_s3_location", default_s3_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_key_arn is not None:
            pulumi.set(__self__, "encryption_key_arn", encryption_key_arn)
        if engine_security_group_id is not None:
            pulumi.set(__self__, "engine_security_group_id", engine_security_group_id)
        if idp_auth_url is not None:
            pulumi.set(__self__, "idp_auth_url", idp_auth_url)
        if idp_relay_state_parameter_name is not None:
            pulumi.set(__self__, "idp_relay_state_parameter_name", idp_relay_state_parameter_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_role is not None:
            pulumi.set(__self__, "service_role", service_role)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if user_role is not None:
            pulumi.set(__self__, "user_role", user_role)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if workspace_security_group_id is not None:
            pulumi.set(__self__, "workspace_security_group_id", workspace_security_group_id)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the studio.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO. Valid values are `SSO` or `IAM`.
        """
        return pulumi.get(self, "auth_mode")

    @auth_mode.setter
    def auth_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_mode", value)

    @_builtins.property
    @pulumi.getter(name="defaultS3Location")
    def default_s3_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
        """
        return pulumi.get(self, "default_s3_location")

    @default_s3_location.setter
    def default_s3_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_s3_location", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A detailed description of the Amazon EMR Studio.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="encryptionKeyArn")
    def encryption_key_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS KMS key identifier (ARN) used to encrypt Amazon EMR Studio workspace and notebook files when backed up to Amazon S3.
        """
        return pulumi.get(self, "encryption_key_arn")

    @encryption_key_arn.setter
    def encryption_key_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_key_arn", value)

    @_builtins.property
    @pulumi.getter(name="engineSecurityGroupId")
    def engine_security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by `vpc_id`.
        """
        return pulumi.get(self, "engine_security_group_id")

    @engine_security_group_id.setter
    def engine_security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="idpAuthUrl")
    def idp_auth_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.
        """
        return pulumi.get(self, "idp_auth_url")

    @idp_auth_url.setter
    def idp_auth_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "idp_auth_url", value)

    @_builtins.property
    @pulumi.getter(name="idpRelayStateParameterName")
    def idp_relay_state_parameter_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name that your identity provider (IdP) uses for its RelayState parameter. For example, RelayState or TargetSource. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The RelayState parameter differs by IdP.
        """
        return pulumi.get(self, "idp_relay_state_parameter_name")

    @idp_relay_state_parameter_name.setter
    def idp_relay_state_parameter_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "idp_relay_state_parameter_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A descriptive name for the Amazon EMR Studio.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to interoperate with other Amazon Web Services services.
        """
        return pulumi.get(self, "service_role")

    @service_role.setter
    def service_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_role", value)

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by `vpc_id`. Studio users can create a Workspace in any of the specified subnets.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique access URL of the Amazon EMR Studio.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="userRole")
    def user_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a User Role when you use Amazon Web Services SSO authentication. The permissions attached to the User Role can be scoped down for each user or group using session policies.
        """
        return pulumi.get(self, "user_role")

    @user_role.setter
    def user_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_role", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="workspaceSecurityGroupId")
    def workspace_security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound network traffic to resources in the Engine security group, and it must be in the same VPC specified by `vpc_id`.

        The following arguments are optional:
        """
        return pulumi.get(self, "workspace_security_group_id")

    @workspace_security_group_id.setter
    def workspace_security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_security_group_id", value)


@pulumi.type_token("aws:emr/studio:Studio")
class Studio(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 default_s3_location: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 idp_auth_url: Optional[pulumi.Input[_builtins.str]] = None,
                 idp_relay_state_parameter_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_role: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_role: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an Elastic MapReduce Studio.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.emr.Studio("example",
            auth_mode="SSO",
            default_s3_location=f"s3://{test['bucket']}/test",
            engine_security_group_id=test_aws_security_group["id"],
            name="example",
            service_role=test_aws_iam_role["arn"],
            subnet_ids=[test_aws_subnet["id"]],
            user_role=test_aws_iam_role["arn"],
            vpc_id=test_aws_vpc["id"],
            workspace_security_group_id=test_aws_security_group["id"])
        ```

        ## Import

        Using `pulumi import`, import EMR studios using the `id`. For example:

        ```sh
        $ pulumi import aws:emr/studio:Studio studio es-123456ABCDEF
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auth_mode: Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO. Valid values are `SSO` or `IAM`.
        :param pulumi.Input[_builtins.str] default_s3_location: The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
        :param pulumi.Input[_builtins.str] description: A detailed description of the Amazon EMR Studio.
        :param pulumi.Input[_builtins.str] encryption_key_arn: The AWS KMS key identifier (ARN) used to encrypt Amazon EMR Studio workspace and notebook files when backed up to Amazon S3.
        :param pulumi.Input[_builtins.str] engine_security_group_id: The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by `vpc_id`.
        :param pulumi.Input[_builtins.str] idp_auth_url: The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.
        :param pulumi.Input[_builtins.str] idp_relay_state_parameter_name: The name that your identity provider (IdP) uses for its RelayState parameter. For example, RelayState or TargetSource. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The RelayState parameter differs by IdP.
        :param pulumi.Input[_builtins.str] name: A descriptive name for the Amazon EMR Studio.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] service_role: The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to interoperate with other Amazon Web Services services.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_ids: A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by `vpc_id`. Studio users can create a Workspace in any of the specified subnets.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] user_role: The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a User Role when you use Amazon Web Services SSO authentication. The permissions attached to the User Role can be scoped down for each user or group using session policies.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.
        :param pulumi.Input[_builtins.str] workspace_security_group_id: The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound network traffic to resources in the Engine security group, and it must be in the same VPC specified by `vpc_id`.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StudioArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Elastic MapReduce Studio.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.emr.Studio("example",
            auth_mode="SSO",
            default_s3_location=f"s3://{test['bucket']}/test",
            engine_security_group_id=test_aws_security_group["id"],
            name="example",
            service_role=test_aws_iam_role["arn"],
            subnet_ids=[test_aws_subnet["id"]],
            user_role=test_aws_iam_role["arn"],
            vpc_id=test_aws_vpc["id"],
            workspace_security_group_id=test_aws_security_group["id"])
        ```

        ## Import

        Using `pulumi import`, import EMR studios using the `id`. For example:

        ```sh
        $ pulumi import aws:emr/studio:Studio studio es-123456ABCDEF
        ```

        :param str resource_name: The name of the resource.
        :param StudioArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StudioArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 default_s3_location: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 idp_auth_url: Optional[pulumi.Input[_builtins.str]] = None,
                 idp_relay_state_parameter_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_role: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_role: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StudioArgs.__new__(StudioArgs)

            if auth_mode is None and not opts.urn:
                raise TypeError("Missing required property 'auth_mode'")
            __props__.__dict__["auth_mode"] = auth_mode
            if default_s3_location is None and not opts.urn:
                raise TypeError("Missing required property 'default_s3_location'")
            __props__.__dict__["default_s3_location"] = default_s3_location
            __props__.__dict__["description"] = description
            __props__.__dict__["encryption_key_arn"] = encryption_key_arn
            if engine_security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'engine_security_group_id'")
            __props__.__dict__["engine_security_group_id"] = engine_security_group_id
            __props__.__dict__["idp_auth_url"] = idp_auth_url
            __props__.__dict__["idp_relay_state_parameter_name"] = idp_relay_state_parameter_name
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if service_role is None and not opts.urn:
                raise TypeError("Missing required property 'service_role'")
            __props__.__dict__["service_role"] = service_role
            if subnet_ids is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_ids'")
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_role"] = user_role
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if workspace_security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_security_group_id'")
            __props__.__dict__["workspace_security_group_id"] = workspace_security_group_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["url"] = None
        super(Studio, __self__).__init__(
            'aws:emr/studio:Studio',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            auth_mode: Optional[pulumi.Input[_builtins.str]] = None,
            default_s3_location: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
            engine_security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            idp_auth_url: Optional[pulumi.Input[_builtins.str]] = None,
            idp_relay_state_parameter_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            service_role: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            user_role: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_security_group_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Studio':
        """
        Get an existing Studio resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the studio.
        :param pulumi.Input[_builtins.str] auth_mode: Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO. Valid values are `SSO` or `IAM`.
        :param pulumi.Input[_builtins.str] default_s3_location: The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
        :param pulumi.Input[_builtins.str] description: A detailed description of the Amazon EMR Studio.
        :param pulumi.Input[_builtins.str] encryption_key_arn: The AWS KMS key identifier (ARN) used to encrypt Amazon EMR Studio workspace and notebook files when backed up to Amazon S3.
        :param pulumi.Input[_builtins.str] engine_security_group_id: The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by `vpc_id`.
        :param pulumi.Input[_builtins.str] idp_auth_url: The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.
        :param pulumi.Input[_builtins.str] idp_relay_state_parameter_name: The name that your identity provider (IdP) uses for its RelayState parameter. For example, RelayState or TargetSource. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The RelayState parameter differs by IdP.
        :param pulumi.Input[_builtins.str] name: A descriptive name for the Amazon EMR Studio.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] service_role: The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to interoperate with other Amazon Web Services services.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_ids: A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by `vpc_id`. Studio users can create a Workspace in any of the specified subnets.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] url: The unique access URL of the Amazon EMR Studio.
        :param pulumi.Input[_builtins.str] user_role: The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a User Role when you use Amazon Web Services SSO authentication. The permissions attached to the User Role can be scoped down for each user or group using session policies.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.
        :param pulumi.Input[_builtins.str] workspace_security_group_id: The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound network traffic to resources in the Engine security group, and it must be in the same VPC specified by `vpc_id`.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StudioState.__new__(_StudioState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["auth_mode"] = auth_mode
        __props__.__dict__["default_s3_location"] = default_s3_location
        __props__.__dict__["description"] = description
        __props__.__dict__["encryption_key_arn"] = encryption_key_arn
        __props__.__dict__["engine_security_group_id"] = engine_security_group_id
        __props__.__dict__["idp_auth_url"] = idp_auth_url
        __props__.__dict__["idp_relay_state_parameter_name"] = idp_relay_state_parameter_name
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["service_role"] = service_role
        __props__.__dict__["subnet_ids"] = subnet_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["url"] = url
        __props__.__dict__["user_role"] = user_role
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["workspace_security_group_id"] = workspace_security_group_id
        return Studio(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the studio.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO. Valid values are `SSO` or `IAM`.
        """
        return pulumi.get(self, "auth_mode")

    @_builtins.property
    @pulumi.getter(name="defaultS3Location")
    def default_s3_location(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
        """
        return pulumi.get(self, "default_s3_location")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A detailed description of the Amazon EMR Studio.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="encryptionKeyArn")
    def encryption_key_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The AWS KMS key identifier (ARN) used to encrypt Amazon EMR Studio workspace and notebook files when backed up to Amazon S3.
        """
        return pulumi.get(self, "encryption_key_arn")

    @_builtins.property
    @pulumi.getter(name="engineSecurityGroupId")
    def engine_security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by `vpc_id`.
        """
        return pulumi.get(self, "engine_security_group_id")

    @_builtins.property
    @pulumi.getter(name="idpAuthUrl")
    def idp_auth_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.
        """
        return pulumi.get(self, "idp_auth_url")

    @_builtins.property
    @pulumi.getter(name="idpRelayStateParameterName")
    def idp_relay_state_parameter_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name that your identity provider (IdP) uses for its RelayState parameter. For example, RelayState or TargetSource. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The RelayState parameter differs by IdP.
        """
        return pulumi.get(self, "idp_relay_state_parameter_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A descriptive name for the Amazon EMR Studio.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> pulumi.Output[_builtins.str]:
        """
        The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to interoperate with other Amazon Web Services services.
        """
        return pulumi.get(self, "service_role")

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by `vpc_id`. Studio users can create a Workspace in any of the specified subnets.
        """
        return pulumi.get(self, "subnet_ids")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        The unique access URL of the Amazon EMR Studio.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="userRole")
    def user_role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a User Role when you use Amazon Web Services SSO authentication. The permissions attached to the User Role can be scoped down for each user or group using session policies.
        """
        return pulumi.get(self, "user_role")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="workspaceSecurityGroupId")
    def workspace_security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound network traffic to resources in the Engine security group, and it must be in the same VPC specified by `vpc_id`.

        The following arguments are optional:
        """
        return pulumi.get(self, "workspace_security_group_id")

