# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KxDataviewArgs', 'KxDataview']

@pulumi.input_type
class KxDataviewArgs:
    def __init__(__self__, *,
                 auto_update: pulumi.Input[_builtins.bool],
                 az_mode: pulumi.Input[_builtins.str],
                 database_name: pulumi.Input[_builtins.str],
                 environment_id: pulumi.Input[_builtins.str],
                 availability_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 changeset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 read_write: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 segment_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['KxDataviewSegmentConfigurationArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a KxDataview resource.
        :param pulumi.Input[_builtins.bool] auto_update: The option to specify whether you want to apply all the future additions and corrections automatically to the dataview, when you ingest new changesets. The default value is false.
        :param pulumi.Input[_builtins.str] az_mode: The number of availability zones you want to assign per cluster. This can be one of the following:
               * `SINGLE` - Assigns one availability zone per cluster.
               * `MULTI` - Assigns all the availability zones per cluster.
        :param pulumi.Input[_builtins.str] database_name: The name of the database where you want to create a dataview.
        :param pulumi.Input[_builtins.str] environment_id: Unique identifier for the KX environment.
        :param pulumi.Input[_builtins.str] availability_zone_id: The identifier of the availability zones. If attaching a volume, the volume must be in the same availability zone as the dataview that you are attaching to.
        :param pulumi.Input[_builtins.str] changeset_id: A unique identifier of the changeset of the database that you want to use to ingest data.
        :param pulumi.Input[_builtins.str] description: A description for the dataview.
        :param pulumi.Input[_builtins.str] name: A unique identifier for the dataview.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.bool] read_write: The option to specify whether you want to make the dataview writable to perform database maintenance. The following are some considerations related to writable dataviews.
               * You cannot create partial writable dataviews. When you create writeable dataviews you must provide the entire database path. You cannot perform updates on a writeable dataview. Hence, `auto_update` must be set as `false` if `read_write` is `true` for a dataview.
               * You must also use a unique volume for creating a writeable dataview. So, if you choose a volume that is already in use by another dataview, the dataview creation fails.
               * Once you create a dataview as writeable, you cannot change it to read-only. So, you cannot update the `read_write` parameter later.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['KxDataviewSegmentConfigurationArgs']]] segment_configurations: The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment. See segment_configurations below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "auto_update", auto_update)
        pulumi.set(__self__, "az_mode", az_mode)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "environment_id", environment_id)
        if availability_zone_id is not None:
            pulumi.set(__self__, "availability_zone_id", availability_zone_id)
        if changeset_id is not None:
            pulumi.set(__self__, "changeset_id", changeset_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_write is not None:
            pulumi.set(__self__, "read_write", read_write)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if segment_configurations is not None:
            pulumi.set(__self__, "segment_configurations", segment_configurations)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="autoUpdate")
    def auto_update(self) -> pulumi.Input[_builtins.bool]:
        """
        The option to specify whether you want to apply all the future additions and corrections automatically to the dataview, when you ingest new changesets. The default value is false.
        """
        return pulumi.get(self, "auto_update")

    @auto_update.setter
    def auto_update(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "auto_update", value)

    @_builtins.property
    @pulumi.getter(name="azMode")
    def az_mode(self) -> pulumi.Input[_builtins.str]:
        """
        The number of availability zones you want to assign per cluster. This can be one of the following:
        * `SINGLE` - Assigns one availability zone per cluster.
        * `MULTI` - Assigns all the availability zones per cluster.
        """
        return pulumi.get(self, "az_mode")

    @az_mode.setter
    def az_mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "az_mode", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the database where you want to create a dataview.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier for the KX environment.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "environment_id", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the availability zones. If attaching a volume, the volume must be in the same availability zone as the dataview that you are attaching to.
        """
        return pulumi.get(self, "availability_zone_id")

    @availability_zone_id.setter
    def availability_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="changesetId")
    def changeset_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique identifier of the changeset of the database that you want to use to ingest data.
        """
        return pulumi.get(self, "changeset_id")

    @changeset_id.setter
    def changeset_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "changeset_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for the dataview.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique identifier for the dataview.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="readWrite")
    def read_write(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The option to specify whether you want to make the dataview writable to perform database maintenance. The following are some considerations related to writable dataviews.
        * You cannot create partial writable dataviews. When you create writeable dataviews you must provide the entire database path. You cannot perform updates on a writeable dataview. Hence, `auto_update` must be set as `false` if `read_write` is `true` for a dataview.
        * You must also use a unique volume for creating a writeable dataview. So, if you choose a volume that is already in use by another dataview, the dataview creation fails.
        * Once you create a dataview as writeable, you cannot change it to read-only. So, you cannot update the `read_write` parameter later.
        """
        return pulumi.get(self, "read_write")

    @read_write.setter
    def read_write(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "read_write", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="segmentConfigurations")
    def segment_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KxDataviewSegmentConfigurationArgs']]]]:
        """
        The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment. See segment_configurations below.
        """
        return pulumi.get(self, "segment_configurations")

    @segment_configurations.setter
    def segment_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KxDataviewSegmentConfigurationArgs']]]]):
        pulumi.set(self, "segment_configurations", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _KxDataviewState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 az_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 changeset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 last_modified_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 read_write: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 segment_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['KxDataviewSegmentConfigurationArgs']]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering KxDataview resources.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) identifier of the KX dataview.
        :param pulumi.Input[_builtins.bool] auto_update: The option to specify whether you want to apply all the future additions and corrections automatically to the dataview, when you ingest new changesets. The default value is false.
        :param pulumi.Input[_builtins.str] availability_zone_id: The identifier of the availability zones. If attaching a volume, the volume must be in the same availability zone as the dataview that you are attaching to.
        :param pulumi.Input[_builtins.str] az_mode: The number of availability zones you want to assign per cluster. This can be one of the following:
               * `SINGLE` - Assigns one availability zone per cluster.
               * `MULTI` - Assigns all the availability zones per cluster.
        :param pulumi.Input[_builtins.str] changeset_id: A unique identifier of the changeset of the database that you want to use to ingest data.
        :param pulumi.Input[_builtins.str] created_timestamp: Timestamp at which the dataview was created in FinSpace. Value determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
        :param pulumi.Input[_builtins.str] database_name: The name of the database where you want to create a dataview.
        :param pulumi.Input[_builtins.str] description: A description for the dataview.
        :param pulumi.Input[_builtins.str] environment_id: Unique identifier for the KX environment.
        :param pulumi.Input[_builtins.str] last_modified_timestamp: The last time that the dataview was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
        :param pulumi.Input[_builtins.str] name: A unique identifier for the dataview.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.bool] read_write: The option to specify whether you want to make the dataview writable to perform database maintenance. The following are some considerations related to writable dataviews.
               * You cannot create partial writable dataviews. When you create writeable dataviews you must provide the entire database path. You cannot perform updates on a writeable dataview. Hence, `auto_update` must be set as `false` if `read_write` is `true` for a dataview.
               * You must also use a unique volume for creating a writeable dataview. So, if you choose a volume that is already in use by another dataview, the dataview creation fails.
               * Once you create a dataview as writeable, you cannot change it to read-only. So, you cannot update the `read_write` parameter later.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['KxDataviewSegmentConfigurationArgs']]] segment_configurations: The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment. See segment_configurations below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auto_update is not None:
            pulumi.set(__self__, "auto_update", auto_update)
        if availability_zone_id is not None:
            pulumi.set(__self__, "availability_zone_id", availability_zone_id)
        if az_mode is not None:
            pulumi.set(__self__, "az_mode", az_mode)
        if changeset_id is not None:
            pulumi.set(__self__, "changeset_id", changeset_id)
        if created_timestamp is not None:
            pulumi.set(__self__, "created_timestamp", created_timestamp)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if last_modified_timestamp is not None:
            pulumi.set(__self__, "last_modified_timestamp", last_modified_timestamp)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_write is not None:
            pulumi.set(__self__, "read_write", read_write)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if segment_configurations is not None:
            pulumi.set(__self__, "segment_configurations", segment_configurations)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) identifier of the KX dataview.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="autoUpdate")
    def auto_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The option to specify whether you want to apply all the future additions and corrections automatically to the dataview, when you ingest new changesets. The default value is false.
        """
        return pulumi.get(self, "auto_update")

    @auto_update.setter
    def auto_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_update", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the availability zones. If attaching a volume, the volume must be in the same availability zone as the dataview that you are attaching to.
        """
        return pulumi.get(self, "availability_zone_id")

    @availability_zone_id.setter
    def availability_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="azMode")
    def az_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The number of availability zones you want to assign per cluster. This can be one of the following:
        * `SINGLE` - Assigns one availability zone per cluster.
        * `MULTI` - Assigns all the availability zones per cluster.
        """
        return pulumi.get(self, "az_mode")

    @az_mode.setter
    def az_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "az_mode", value)

    @_builtins.property
    @pulumi.getter(name="changesetId")
    def changeset_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique identifier of the changeset of the database that you want to use to ingest data.
        """
        return pulumi.get(self, "changeset_id")

    @changeset_id.setter
    def changeset_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "changeset_id", value)

    @_builtins.property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp at which the dataview was created in FinSpace. Value determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
        """
        return pulumi.get(self, "created_timestamp")

    @created_timestamp.setter
    def created_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the database where you want to create a dataview.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for the dataview.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier for the KX environment.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment_id", value)

    @_builtins.property
    @pulumi.getter(name="lastModifiedTimestamp")
    def last_modified_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last time that the dataview was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
        """
        return pulumi.get(self, "last_modified_timestamp")

    @last_modified_timestamp.setter
    def last_modified_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modified_timestamp", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique identifier for the dataview.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="readWrite")
    def read_write(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The option to specify whether you want to make the dataview writable to perform database maintenance. The following are some considerations related to writable dataviews.
        * You cannot create partial writable dataviews. When you create writeable dataviews you must provide the entire database path. You cannot perform updates on a writeable dataview. Hence, `auto_update` must be set as `false` if `read_write` is `true` for a dataview.
        * You must also use a unique volume for creating a writeable dataview. So, if you choose a volume that is already in use by another dataview, the dataview creation fails.
        * Once you create a dataview as writeable, you cannot change it to read-only. So, you cannot update the `read_write` parameter later.
        """
        return pulumi.get(self, "read_write")

    @read_write.setter
    def read_write(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "read_write", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="segmentConfigurations")
    def segment_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KxDataviewSegmentConfigurationArgs']]]]:
        """
        The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment. See segment_configurations below.
        """
        return pulumi.get(self, "segment_configurations")

    @segment_configurations.setter
    def segment_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KxDataviewSegmentConfigurationArgs']]]]):
        pulumi.set(self, "segment_configurations", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:finspace/kxDataview:KxDataview")
class KxDataview(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 az_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 changeset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 read_write: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 segment_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KxDataviewSegmentConfigurationArgs', 'KxDataviewSegmentConfigurationArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for managing an AWS FinSpace Kx Dataview.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.finspace.KxDataview("example",
            name="my-tf-kx-dataview",
            environment_id=example_aws_finspace_kx_environment["id"],
            database_name=example_aws_finspace_kx_database["name"],
            availability_zone_id="use1-az2",
            description="Terraform managed Kx Dataview",
            az_mode="SINGLE",
            auto_update=True,
            segment_configurations=[{
                "volume_name": example_aws_finspace_kx_volume["name"],
                "db_paths": ["/*"],
            }])
        ```

        ## Import

        Using `pulumi import`, import an AWS FinSpace Kx Cluster using the `id` (environment ID and cluster name, comma-delimited). For example:

        ```sh
        $ pulumi import aws:finspace/kxDataview:KxDataview example n3ceo7wqxoxcti5tujqwzs,my-tf-kx-database,my-tf-kx-dataview
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_update: The option to specify whether you want to apply all the future additions and corrections automatically to the dataview, when you ingest new changesets. The default value is false.
        :param pulumi.Input[_builtins.str] availability_zone_id: The identifier of the availability zones. If attaching a volume, the volume must be in the same availability zone as the dataview that you are attaching to.
        :param pulumi.Input[_builtins.str] az_mode: The number of availability zones you want to assign per cluster. This can be one of the following:
               * `SINGLE` - Assigns one availability zone per cluster.
               * `MULTI` - Assigns all the availability zones per cluster.
        :param pulumi.Input[_builtins.str] changeset_id: A unique identifier of the changeset of the database that you want to use to ingest data.
        :param pulumi.Input[_builtins.str] database_name: The name of the database where you want to create a dataview.
        :param pulumi.Input[_builtins.str] description: A description for the dataview.
        :param pulumi.Input[_builtins.str] environment_id: Unique identifier for the KX environment.
        :param pulumi.Input[_builtins.str] name: A unique identifier for the dataview.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.bool] read_write: The option to specify whether you want to make the dataview writable to perform database maintenance. The following are some considerations related to writable dataviews.
               * You cannot create partial writable dataviews. When you create writeable dataviews you must provide the entire database path. You cannot perform updates on a writeable dataview. Hence, `auto_update` must be set as `false` if `read_write` is `true` for a dataview.
               * You must also use a unique volume for creating a writeable dataview. So, if you choose a volume that is already in use by another dataview, the dataview creation fails.
               * Once you create a dataview as writeable, you cannot change it to read-only. So, you cannot update the `read_write` parameter later.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KxDataviewSegmentConfigurationArgs', 'KxDataviewSegmentConfigurationArgsDict']]]] segment_configurations: The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment. See segment_configurations below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KxDataviewArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS FinSpace Kx Dataview.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.finspace.KxDataview("example",
            name="my-tf-kx-dataview",
            environment_id=example_aws_finspace_kx_environment["id"],
            database_name=example_aws_finspace_kx_database["name"],
            availability_zone_id="use1-az2",
            description="Terraform managed Kx Dataview",
            az_mode="SINGLE",
            auto_update=True,
            segment_configurations=[{
                "volume_name": example_aws_finspace_kx_volume["name"],
                "db_paths": ["/*"],
            }])
        ```

        ## Import

        Using `pulumi import`, import an AWS FinSpace Kx Cluster using the `id` (environment ID and cluster name, comma-delimited). For example:

        ```sh
        $ pulumi import aws:finspace/kxDataview:KxDataview example n3ceo7wqxoxcti5tujqwzs,my-tf-kx-database,my-tf-kx-dataview
        ```

        :param str resource_name: The name of the resource.
        :param KxDataviewArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KxDataviewArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 az_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 changeset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 read_write: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 segment_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KxDataviewSegmentConfigurationArgs', 'KxDataviewSegmentConfigurationArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KxDataviewArgs.__new__(KxDataviewArgs)

            if auto_update is None and not opts.urn:
                raise TypeError("Missing required property 'auto_update'")
            __props__.__dict__["auto_update"] = auto_update
            __props__.__dict__["availability_zone_id"] = availability_zone_id
            if az_mode is None and not opts.urn:
                raise TypeError("Missing required property 'az_mode'")
            __props__.__dict__["az_mode"] = az_mode
            __props__.__dict__["changeset_id"] = changeset_id
            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["description"] = description
            if environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'environment_id'")
            __props__.__dict__["environment_id"] = environment_id
            __props__.__dict__["name"] = name
            __props__.__dict__["read_write"] = read_write
            __props__.__dict__["region"] = region
            __props__.__dict__["segment_configurations"] = segment_configurations
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_timestamp"] = None
            __props__.__dict__["last_modified_timestamp"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
        super(KxDataview, __self__).__init__(
            'aws:finspace/kxDataview:KxDataview',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            auto_update: Optional[pulumi.Input[_builtins.bool]] = None,
            availability_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            az_mode: Optional[pulumi.Input[_builtins.str]] = None,
            changeset_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            environment_id: Optional[pulumi.Input[_builtins.str]] = None,
            last_modified_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            read_write: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            segment_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KxDataviewSegmentConfigurationArgs', 'KxDataviewSegmentConfigurationArgsDict']]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'KxDataview':
        """
        Get an existing KxDataview resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) identifier of the KX dataview.
        :param pulumi.Input[_builtins.bool] auto_update: The option to specify whether you want to apply all the future additions and corrections automatically to the dataview, when you ingest new changesets. The default value is false.
        :param pulumi.Input[_builtins.str] availability_zone_id: The identifier of the availability zones. If attaching a volume, the volume must be in the same availability zone as the dataview that you are attaching to.
        :param pulumi.Input[_builtins.str] az_mode: The number of availability zones you want to assign per cluster. This can be one of the following:
               * `SINGLE` - Assigns one availability zone per cluster.
               * `MULTI` - Assigns all the availability zones per cluster.
        :param pulumi.Input[_builtins.str] changeset_id: A unique identifier of the changeset of the database that you want to use to ingest data.
        :param pulumi.Input[_builtins.str] created_timestamp: Timestamp at which the dataview was created in FinSpace. Value determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
        :param pulumi.Input[_builtins.str] database_name: The name of the database where you want to create a dataview.
        :param pulumi.Input[_builtins.str] description: A description for the dataview.
        :param pulumi.Input[_builtins.str] environment_id: Unique identifier for the KX environment.
        :param pulumi.Input[_builtins.str] last_modified_timestamp: The last time that the dataview was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
        :param pulumi.Input[_builtins.str] name: A unique identifier for the dataview.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.bool] read_write: The option to specify whether you want to make the dataview writable to perform database maintenance. The following are some considerations related to writable dataviews.
               * You cannot create partial writable dataviews. When you create writeable dataviews you must provide the entire database path. You cannot perform updates on a writeable dataview. Hence, `auto_update` must be set as `false` if `read_write` is `true` for a dataview.
               * You must also use a unique volume for creating a writeable dataview. So, if you choose a volume that is already in use by another dataview, the dataview creation fails.
               * Once you create a dataview as writeable, you cannot change it to read-only. So, you cannot update the `read_write` parameter later.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KxDataviewSegmentConfigurationArgs', 'KxDataviewSegmentConfigurationArgsDict']]]] segment_configurations: The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment. See segment_configurations below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KxDataviewState.__new__(_KxDataviewState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["auto_update"] = auto_update
        __props__.__dict__["availability_zone_id"] = availability_zone_id
        __props__.__dict__["az_mode"] = az_mode
        __props__.__dict__["changeset_id"] = changeset_id
        __props__.__dict__["created_timestamp"] = created_timestamp
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["description"] = description
        __props__.__dict__["environment_id"] = environment_id
        __props__.__dict__["last_modified_timestamp"] = last_modified_timestamp
        __props__.__dict__["name"] = name
        __props__.__dict__["read_write"] = read_write
        __props__.__dict__["region"] = region
        __props__.__dict__["segment_configurations"] = segment_configurations
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return KxDataview(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        Amazon Resource Name (ARN) identifier of the KX dataview.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="autoUpdate")
    def auto_update(self) -> pulumi.Output[_builtins.bool]:
        """
        The option to specify whether you want to apply all the future additions and corrections automatically to the dataview, when you ingest new changesets. The default value is false.
        """
        return pulumi.get(self, "auto_update")

    @_builtins.property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The identifier of the availability zones. If attaching a volume, the volume must be in the same availability zone as the dataview that you are attaching to.
        """
        return pulumi.get(self, "availability_zone_id")

    @_builtins.property
    @pulumi.getter(name="azMode")
    def az_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The number of availability zones you want to assign per cluster. This can be one of the following:
        * `SINGLE` - Assigns one availability zone per cluster.
        * `MULTI` - Assigns all the availability zones per cluster.
        """
        return pulumi.get(self, "az_mode")

    @_builtins.property
    @pulumi.getter(name="changesetId")
    def changeset_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A unique identifier of the changeset of the database that you want to use to ingest data.
        """
        return pulumi.get(self, "changeset_id")

    @_builtins.property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp at which the dataview was created in FinSpace. Value determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
        """
        return pulumi.get(self, "created_timestamp")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the database where you want to create a dataview.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description for the dataview.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier for the KX environment.
        """
        return pulumi.get(self, "environment_id")

    @_builtins.property
    @pulumi.getter(name="lastModifiedTimestamp")
    def last_modified_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        The last time that the dataview was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
        """
        return pulumi.get(self, "last_modified_timestamp")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A unique identifier for the dataview.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="readWrite")
    def read_write(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The option to specify whether you want to make the dataview writable to perform database maintenance. The following are some considerations related to writable dataviews.
        * You cannot create partial writable dataviews. When you create writeable dataviews you must provide the entire database path. You cannot perform updates on a writeable dataview. Hence, `auto_update` must be set as `false` if `read_write` is `true` for a dataview.
        * You must also use a unique volume for creating a writeable dataview. So, if you choose a volume that is already in use by another dataview, the dataview creation fails.
        * Once you create a dataview as writeable, you cannot change it to read-only. So, you cannot update the `read_write` parameter later.
        """
        return pulumi.get(self, "read_write")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="segmentConfigurations")
    def segment_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.KxDataviewSegmentConfiguration']]]:
        """
        The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment. See segment_configurations below.
        """
        return pulumi.get(self, "segment_configurations")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

