# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetExperimentTemplatesResult',
    'AwaitableGetExperimentTemplatesResult',
    'get_experiment_templates',
    'get_experiment_templates_output',
]

@pulumi.output_type
class GetExperimentTemplatesResult:
    """
    A collection of values returned by getExperimentTemplates.
    """
    def __init__(__self__, id=None, ids=None, region=None, tags=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        List of all the experiment template ids found.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "tags")


class AwaitableGetExperimentTemplatesResult(GetExperimentTemplatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExperimentTemplatesResult(
            id=self.id,
            ids=self.ids,
            region=self.region,
            tags=self.tags)


def get_experiment_templates(region: Optional[_builtins.str] = None,
                             tags: Optional[Mapping[str, _builtins.str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExperimentTemplatesResult:
    """
    This resource can be useful for getting back a set of FIS experiment template IDs.

    ## Example Usage

    The following shows outputting a list of all FIS experiment template IDs

    ```python
    import pulumi
    import pulumi_aws as aws

    all = aws.fis.get_experiment_templates()
    pulumi.export("all", all.ids)
    ```

    The following shows filtering FIS experiment templates by tag

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.fis.get_experiment_templates(tags={
        "Name": "example",
        "Tier": "1",
    })
    example_get_policy_document = aws.iam.get_policy_document(statements=[{
        "sid": "StartFISExperiment",
        "effect": "Allow",
        "actions": ["fis:StartExperiment"],
        "resources": [
            f"arn:aws:fis:*:*:experiment-template/{example.ids[0]}",
            "arn:aws:fis:*:*:experiment/*",
        ],
    }])
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Map of tags, each pair of which must exactly match
           a pair on the desired experiment templates.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:fis/getExperimentTemplates:getExperimentTemplates', __args__, opts=opts, typ=GetExperimentTemplatesResult).value

    return AwaitableGetExperimentTemplatesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'))
def get_experiment_templates_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExperimentTemplatesResult]:
    """
    This resource can be useful for getting back a set of FIS experiment template IDs.

    ## Example Usage

    The following shows outputting a list of all FIS experiment template IDs

    ```python
    import pulumi
    import pulumi_aws as aws

    all = aws.fis.get_experiment_templates()
    pulumi.export("all", all.ids)
    ```

    The following shows filtering FIS experiment templates by tag

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.fis.get_experiment_templates(tags={
        "Name": "example",
        "Tier": "1",
    })
    example_get_policy_document = aws.iam.get_policy_document(statements=[{
        "sid": "StartFISExperiment",
        "effect": "Allow",
        "actions": ["fis:StartExperiment"],
        "resources": [
            f"arn:aws:fis:*:*:experiment-template/{example.ids[0]}",
            "arn:aws:fis:*:*:experiment/*",
        ],
    }])
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Map of tags, each pair of which must exactly match
           a pair on the desired experiment templates.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:fis/getExperimentTemplates:getExperimentTemplates', __args__, opts=opts, typ=GetExperimentTemplatesResult)
    return __ret__.apply(lambda __response__: GetExperimentTemplatesResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags')))
