# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PolicyArgs', 'Policy']

@pulumi.input_type
class PolicyArgs:
    def __init__(__self__, *,
                 exclude_resource_tags: pulumi.Input[_builtins.bool],
                 security_service_policy_data: pulumi.Input['PolicySecurityServicePolicyDataArgs'],
                 delete_all_policy_resources: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_unused_fm_managed_resources: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_map: Optional[pulumi.Input['PolicyExcludeMapArgs']] = None,
                 include_map: Optional[pulumi.Input['PolicyIncludeMapArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 remediation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_set_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_tag_logical_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Policy resource.
        :param pulumi.Input[_builtins.bool] exclude_resource_tags: A boolean value, if true the tags that are specified in the `resource_tags` are not protected by this policy. If set to false and resource_tags are populated, resources that contain tags will be protected by this policy.
        :param pulumi.Input['PolicySecurityServicePolicyDataArgs'] security_service_policy_data: The objects to include in Security Service Policy Data. See the `security_service_policy_data` block.
        :param pulumi.Input[_builtins.bool] delete_all_policy_resources: If true, the request will also perform a clean-up process. Defaults to `true`. More information can be found here [AWS Firewall Manager delete policy](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_DeletePolicy.html)
        :param pulumi.Input[_builtins.bool] delete_unused_fm_managed_resources: If true, Firewall Manager will automatically remove protections from resources that leave the policy scope. Defaults to `false`. More information can be found here [AWS Firewall Manager policy contents](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html)
        :param pulumi.Input[_builtins.str] description: The description of the AWS Network Firewall firewall policy.
        :param pulumi.Input['PolicyExcludeMapArgs'] exclude_map: A map of lists of accounts and OU's to exclude from the policy. See the `exclude_map` block.
        :param pulumi.Input['PolicyIncludeMapArgs'] include_map: A map of lists of accounts and OU's to include in the policy. See the `include_map` block.
        :param pulumi.Input[_builtins.str] name: The friendly name of the AWS Firewall Manager Policy.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] remediation_enabled: A boolean value, indicates if the policy should automatically applied to resources that already exist in the account.
        :param pulumi.Input[_builtins.str] resource_tag_logical_operator: Controls how multiple resource tags are combined: with AND, so that a resource must have all tags to be included or excluded, or OR, so that a resource must have at least one tag. The valid values are `AND` and `OR`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] resource_tags: A map of resource tags, that if present will filter protections on resources based on the exclude_resource_tags.
        :param pulumi.Input[_builtins.str] resource_type: A resource type to protect. Conflicts with `resource_type_list`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_type_lists: A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values. Lists with only one element are not supported, instead use `resource_type`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
        """
        pulumi.set(__self__, "exclude_resource_tags", exclude_resource_tags)
        pulumi.set(__self__, "security_service_policy_data", security_service_policy_data)
        if delete_all_policy_resources is not None:
            pulumi.set(__self__, "delete_all_policy_resources", delete_all_policy_resources)
        if delete_unused_fm_managed_resources is not None:
            pulumi.set(__self__, "delete_unused_fm_managed_resources", delete_unused_fm_managed_resources)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exclude_map is not None:
            pulumi.set(__self__, "exclude_map", exclude_map)
        if include_map is not None:
            pulumi.set(__self__, "include_map", include_map)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if remediation_enabled is not None:
            pulumi.set(__self__, "remediation_enabled", remediation_enabled)
        if resource_set_ids is not None:
            pulumi.set(__self__, "resource_set_ids", resource_set_ids)
        if resource_tag_logical_operator is not None:
            pulumi.set(__self__, "resource_tag_logical_operator", resource_tag_logical_operator)
        if resource_tags is not None:
            pulumi.set(__self__, "resource_tags", resource_tags)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if resource_type_lists is not None:
            pulumi.set(__self__, "resource_type_lists", resource_type_lists)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="excludeResourceTags")
    def exclude_resource_tags(self) -> pulumi.Input[_builtins.bool]:
        """
        A boolean value, if true the tags that are specified in the `resource_tags` are not protected by this policy. If set to false and resource_tags are populated, resources that contain tags will be protected by this policy.
        """
        return pulumi.get(self, "exclude_resource_tags")

    @exclude_resource_tags.setter
    def exclude_resource_tags(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "exclude_resource_tags", value)

    @_builtins.property
    @pulumi.getter(name="securityServicePolicyData")
    def security_service_policy_data(self) -> pulumi.Input['PolicySecurityServicePolicyDataArgs']:
        """
        The objects to include in Security Service Policy Data. See the `security_service_policy_data` block.
        """
        return pulumi.get(self, "security_service_policy_data")

    @security_service_policy_data.setter
    def security_service_policy_data(self, value: pulumi.Input['PolicySecurityServicePolicyDataArgs']):
        pulumi.set(self, "security_service_policy_data", value)

    @_builtins.property
    @pulumi.getter(name="deleteAllPolicyResources")
    def delete_all_policy_resources(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the request will also perform a clean-up process. Defaults to `true`. More information can be found here [AWS Firewall Manager delete policy](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_DeletePolicy.html)
        """
        return pulumi.get(self, "delete_all_policy_resources")

    @delete_all_policy_resources.setter
    def delete_all_policy_resources(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_all_policy_resources", value)

    @_builtins.property
    @pulumi.getter(name="deleteUnusedFmManagedResources")
    def delete_unused_fm_managed_resources(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, Firewall Manager will automatically remove protections from resources that leave the policy scope. Defaults to `false`. More information can be found here [AWS Firewall Manager policy contents](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html)
        """
        return pulumi.get(self, "delete_unused_fm_managed_resources")

    @delete_unused_fm_managed_resources.setter
    def delete_unused_fm_managed_resources(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_unused_fm_managed_resources", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the AWS Network Firewall firewall policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="excludeMap")
    def exclude_map(self) -> Optional[pulumi.Input['PolicyExcludeMapArgs']]:
        """
        A map of lists of accounts and OU's to exclude from the policy. See the `exclude_map` block.
        """
        return pulumi.get(self, "exclude_map")

    @exclude_map.setter
    def exclude_map(self, value: Optional[pulumi.Input['PolicyExcludeMapArgs']]):
        pulumi.set(self, "exclude_map", value)

    @_builtins.property
    @pulumi.getter(name="includeMap")
    def include_map(self) -> Optional[pulumi.Input['PolicyIncludeMapArgs']]:
        """
        A map of lists of accounts and OU's to include in the policy. See the `include_map` block.
        """
        return pulumi.get(self, "include_map")

    @include_map.setter
    def include_map(self, value: Optional[pulumi.Input['PolicyIncludeMapArgs']]):
        pulumi.set(self, "include_map", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The friendly name of the AWS Firewall Manager Policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="remediationEnabled")
    def remediation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean value, indicates if the policy should automatically applied to resources that already exist in the account.
        """
        return pulumi.get(self, "remediation_enabled")

    @remediation_enabled.setter
    def remediation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "remediation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceSetIds")
    def resource_set_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "resource_set_ids")

    @resource_set_ids.setter
    def resource_set_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_set_ids", value)

    @_builtins.property
    @pulumi.getter(name="resourceTagLogicalOperator")
    def resource_tag_logical_operator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls how multiple resource tags are combined: with AND, so that a resource must have all tags to be included or excluded, or OR, so that a resource must have at least one tag. The valid values are `AND` and `OR`.
        """
        return pulumi.get(self, "resource_tag_logical_operator")

    @resource_tag_logical_operator.setter
    def resource_tag_logical_operator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_tag_logical_operator", value)

    @_builtins.property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of resource tags, that if present will filter protections on resources based on the exclude_resource_tags.
        """
        return pulumi.get(self, "resource_tags")

    @resource_tags.setter
    def resource_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_tags", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A resource type to protect. Conflicts with `resource_type_list`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceTypeLists")
    def resource_type_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values. Lists with only one element are not supported, instead use `resource_type`.
        """
        return pulumi.get(self, "resource_type_lists")

    @resource_type_lists.setter
    def resource_type_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_type_lists", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _PolicyState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_all_policy_resources: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_unused_fm_managed_resources: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_map: Optional[pulumi.Input['PolicyExcludeMapArgs']] = None,
                 exclude_resource_tags: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_map: Optional[pulumi.Input['PolicyIncludeMapArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_update_token: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 remediation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_set_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_tag_logical_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_service_policy_data: Optional[pulumi.Input['PolicySecurityServicePolicyDataArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Policy resources.
        :param pulumi.Input[_builtins.bool] delete_all_policy_resources: If true, the request will also perform a clean-up process. Defaults to `true`. More information can be found here [AWS Firewall Manager delete policy](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_DeletePolicy.html)
        :param pulumi.Input[_builtins.bool] delete_unused_fm_managed_resources: If true, Firewall Manager will automatically remove protections from resources that leave the policy scope. Defaults to `false`. More information can be found here [AWS Firewall Manager policy contents](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html)
        :param pulumi.Input[_builtins.str] description: The description of the AWS Network Firewall firewall policy.
        :param pulumi.Input['PolicyExcludeMapArgs'] exclude_map: A map of lists of accounts and OU's to exclude from the policy. See the `exclude_map` block.
        :param pulumi.Input[_builtins.bool] exclude_resource_tags: A boolean value, if true the tags that are specified in the `resource_tags` are not protected by this policy. If set to false and resource_tags are populated, resources that contain tags will be protected by this policy.
        :param pulumi.Input['PolicyIncludeMapArgs'] include_map: A map of lists of accounts and OU's to include in the policy. See the `include_map` block.
        :param pulumi.Input[_builtins.str] name: The friendly name of the AWS Firewall Manager Policy.
        :param pulumi.Input[_builtins.str] policy_update_token: A unique identifier for each update to the policy.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] remediation_enabled: A boolean value, indicates if the policy should automatically applied to resources that already exist in the account.
        :param pulumi.Input[_builtins.str] resource_tag_logical_operator: Controls how multiple resource tags are combined: with AND, so that a resource must have all tags to be included or excluded, or OR, so that a resource must have at least one tag. The valid values are `AND` and `OR`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] resource_tags: A map of resource tags, that if present will filter protections on resources based on the exclude_resource_tags.
        :param pulumi.Input[_builtins.str] resource_type: A resource type to protect. Conflicts with `resource_type_list`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_type_lists: A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values. Lists with only one element are not supported, instead use `resource_type`.
        :param pulumi.Input['PolicySecurityServicePolicyDataArgs'] security_service_policy_data: The objects to include in Security Service Policy Data. See the `security_service_policy_data` block.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if delete_all_policy_resources is not None:
            pulumi.set(__self__, "delete_all_policy_resources", delete_all_policy_resources)
        if delete_unused_fm_managed_resources is not None:
            pulumi.set(__self__, "delete_unused_fm_managed_resources", delete_unused_fm_managed_resources)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exclude_map is not None:
            pulumi.set(__self__, "exclude_map", exclude_map)
        if exclude_resource_tags is not None:
            pulumi.set(__self__, "exclude_resource_tags", exclude_resource_tags)
        if include_map is not None:
            pulumi.set(__self__, "include_map", include_map)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_update_token is not None:
            pulumi.set(__self__, "policy_update_token", policy_update_token)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if remediation_enabled is not None:
            pulumi.set(__self__, "remediation_enabled", remediation_enabled)
        if resource_set_ids is not None:
            pulumi.set(__self__, "resource_set_ids", resource_set_ids)
        if resource_tag_logical_operator is not None:
            pulumi.set(__self__, "resource_tag_logical_operator", resource_tag_logical_operator)
        if resource_tags is not None:
            pulumi.set(__self__, "resource_tags", resource_tags)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if resource_type_lists is not None:
            pulumi.set(__self__, "resource_type_lists", resource_type_lists)
        if security_service_policy_data is not None:
            pulumi.set(__self__, "security_service_policy_data", security_service_policy_data)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="deleteAllPolicyResources")
    def delete_all_policy_resources(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the request will also perform a clean-up process. Defaults to `true`. More information can be found here [AWS Firewall Manager delete policy](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_DeletePolicy.html)
        """
        return pulumi.get(self, "delete_all_policy_resources")

    @delete_all_policy_resources.setter
    def delete_all_policy_resources(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_all_policy_resources", value)

    @_builtins.property
    @pulumi.getter(name="deleteUnusedFmManagedResources")
    def delete_unused_fm_managed_resources(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, Firewall Manager will automatically remove protections from resources that leave the policy scope. Defaults to `false`. More information can be found here [AWS Firewall Manager policy contents](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html)
        """
        return pulumi.get(self, "delete_unused_fm_managed_resources")

    @delete_unused_fm_managed_resources.setter
    def delete_unused_fm_managed_resources(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_unused_fm_managed_resources", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the AWS Network Firewall firewall policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="excludeMap")
    def exclude_map(self) -> Optional[pulumi.Input['PolicyExcludeMapArgs']]:
        """
        A map of lists of accounts and OU's to exclude from the policy. See the `exclude_map` block.
        """
        return pulumi.get(self, "exclude_map")

    @exclude_map.setter
    def exclude_map(self, value: Optional[pulumi.Input['PolicyExcludeMapArgs']]):
        pulumi.set(self, "exclude_map", value)

    @_builtins.property
    @pulumi.getter(name="excludeResourceTags")
    def exclude_resource_tags(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean value, if true the tags that are specified in the `resource_tags` are not protected by this policy. If set to false and resource_tags are populated, resources that contain tags will be protected by this policy.
        """
        return pulumi.get(self, "exclude_resource_tags")

    @exclude_resource_tags.setter
    def exclude_resource_tags(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exclude_resource_tags", value)

    @_builtins.property
    @pulumi.getter(name="includeMap")
    def include_map(self) -> Optional[pulumi.Input['PolicyIncludeMapArgs']]:
        """
        A map of lists of accounts and OU's to include in the policy. See the `include_map` block.
        """
        return pulumi.get(self, "include_map")

    @include_map.setter
    def include_map(self, value: Optional[pulumi.Input['PolicyIncludeMapArgs']]):
        pulumi.set(self, "include_map", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The friendly name of the AWS Firewall Manager Policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="policyUpdateToken")
    def policy_update_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique identifier for each update to the policy.
        """
        return pulumi.get(self, "policy_update_token")

    @policy_update_token.setter
    def policy_update_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_update_token", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="remediationEnabled")
    def remediation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean value, indicates if the policy should automatically applied to resources that already exist in the account.
        """
        return pulumi.get(self, "remediation_enabled")

    @remediation_enabled.setter
    def remediation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "remediation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceSetIds")
    def resource_set_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "resource_set_ids")

    @resource_set_ids.setter
    def resource_set_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_set_ids", value)

    @_builtins.property
    @pulumi.getter(name="resourceTagLogicalOperator")
    def resource_tag_logical_operator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls how multiple resource tags are combined: with AND, so that a resource must have all tags to be included or excluded, or OR, so that a resource must have at least one tag. The valid values are `AND` and `OR`.
        """
        return pulumi.get(self, "resource_tag_logical_operator")

    @resource_tag_logical_operator.setter
    def resource_tag_logical_operator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_tag_logical_operator", value)

    @_builtins.property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of resource tags, that if present will filter protections on resources based on the exclude_resource_tags.
        """
        return pulumi.get(self, "resource_tags")

    @resource_tags.setter
    def resource_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_tags", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A resource type to protect. Conflicts with `resource_type_list`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceTypeLists")
    def resource_type_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values. Lists with only one element are not supported, instead use `resource_type`.
        """
        return pulumi.get(self, "resource_type_lists")

    @resource_type_lists.setter
    def resource_type_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_type_lists", value)

    @_builtins.property
    @pulumi.getter(name="securityServicePolicyData")
    def security_service_policy_data(self) -> Optional[pulumi.Input['PolicySecurityServicePolicyDataArgs']]:
        """
        The objects to include in Security Service Policy Data. See the `security_service_policy_data` block.
        """
        return pulumi.get(self, "security_service_policy_data")

    @security_service_policy_data.setter
    def security_service_policy_data(self, value: Optional[pulumi.Input['PolicySecurityServicePolicyDataArgs']]):
        pulumi.set(self, "security_service_policy_data", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:fms/policy:Policy")
class Policy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_all_policy_resources: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_unused_fm_managed_resources: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_map: Optional[pulumi.Input[Union['PolicyExcludeMapArgs', 'PolicyExcludeMapArgsDict']]] = None,
                 exclude_resource_tags: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_map: Optional[pulumi.Input[Union['PolicyIncludeMapArgs', 'PolicyIncludeMapArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 remediation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_set_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_tag_logical_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_service_policy_data: Optional[pulumi.Input[Union['PolicySecurityServicePolicyDataArgs', 'PolicySecurityServicePolicyDataArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a resource to create an AWS Firewall Manager policy. You need to be using AWS organizations and have enabled the Firewall Manager administrator account.

        > **NOTE:** Due to limitations with testing, we provide it as best effort. If you find it useful, and have the ability to help test or notice issues, consider reaching out to us on GitHub.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example_rule_group = aws.wafregional.RuleGroup("example",
            metric_name="WAFRuleGroupExample",
            name="WAF-Rule-Group-Example")
        example = aws.fms.Policy("example",
            name="FMS-Policy-Example",
            exclude_resource_tags=False,
            remediation_enabled=False,
            resource_type="AWS::ElasticLoadBalancingV2::LoadBalancer",
            security_service_policy_data={
                "type": "WAF",
                "managed_service_data": pulumi.Output.json_dumps({
                    "type": "WAF",
                    "ruleGroups": [{
                        "id": example_rule_group.id,
                        "overrideAction": {
                            "type": "COUNT",
                        },
                    }],
                    "defaultAction": {
                        "type": "BLOCK",
                    },
                    "overrideCustomerWebACLAssociation": False,
                }),
            },
            tags={
                "Name": "example-fms-policy",
            })
        ```

        ## Import

        Using `pulumi import`, import Firewall Manager policies using the policy ID. For example:

        ```sh
        $ pulumi import aws:fms/policy:Policy example 5be49585-a7e3-4c49-dde1-a179fe4a619a
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] delete_all_policy_resources: If true, the request will also perform a clean-up process. Defaults to `true`. More information can be found here [AWS Firewall Manager delete policy](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_DeletePolicy.html)
        :param pulumi.Input[_builtins.bool] delete_unused_fm_managed_resources: If true, Firewall Manager will automatically remove protections from resources that leave the policy scope. Defaults to `false`. More information can be found here [AWS Firewall Manager policy contents](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html)
        :param pulumi.Input[_builtins.str] description: The description of the AWS Network Firewall firewall policy.
        :param pulumi.Input[Union['PolicyExcludeMapArgs', 'PolicyExcludeMapArgsDict']] exclude_map: A map of lists of accounts and OU's to exclude from the policy. See the `exclude_map` block.
        :param pulumi.Input[_builtins.bool] exclude_resource_tags: A boolean value, if true the tags that are specified in the `resource_tags` are not protected by this policy. If set to false and resource_tags are populated, resources that contain tags will be protected by this policy.
        :param pulumi.Input[Union['PolicyIncludeMapArgs', 'PolicyIncludeMapArgsDict']] include_map: A map of lists of accounts and OU's to include in the policy. See the `include_map` block.
        :param pulumi.Input[_builtins.str] name: The friendly name of the AWS Firewall Manager Policy.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] remediation_enabled: A boolean value, indicates if the policy should automatically applied to resources that already exist in the account.
        :param pulumi.Input[_builtins.str] resource_tag_logical_operator: Controls how multiple resource tags are combined: with AND, so that a resource must have all tags to be included or excluded, or OR, so that a resource must have at least one tag. The valid values are `AND` and `OR`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] resource_tags: A map of resource tags, that if present will filter protections on resources based on the exclude_resource_tags.
        :param pulumi.Input[_builtins.str] resource_type: A resource type to protect. Conflicts with `resource_type_list`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_type_lists: A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values. Lists with only one element are not supported, instead use `resource_type`.
        :param pulumi.Input[Union['PolicySecurityServicePolicyDataArgs', 'PolicySecurityServicePolicyDataArgsDict']] security_service_policy_data: The objects to include in Security Service Policy Data. See the `security_service_policy_data` block.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to create an AWS Firewall Manager policy. You need to be using AWS organizations and have enabled the Firewall Manager administrator account.

        > **NOTE:** Due to limitations with testing, we provide it as best effort. If you find it useful, and have the ability to help test or notice issues, consider reaching out to us on GitHub.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example_rule_group = aws.wafregional.RuleGroup("example",
            metric_name="WAFRuleGroupExample",
            name="WAF-Rule-Group-Example")
        example = aws.fms.Policy("example",
            name="FMS-Policy-Example",
            exclude_resource_tags=False,
            remediation_enabled=False,
            resource_type="AWS::ElasticLoadBalancingV2::LoadBalancer",
            security_service_policy_data={
                "type": "WAF",
                "managed_service_data": pulumi.Output.json_dumps({
                    "type": "WAF",
                    "ruleGroups": [{
                        "id": example_rule_group.id,
                        "overrideAction": {
                            "type": "COUNT",
                        },
                    }],
                    "defaultAction": {
                        "type": "BLOCK",
                    },
                    "overrideCustomerWebACLAssociation": False,
                }),
            },
            tags={
                "Name": "example-fms-policy",
            })
        ```

        ## Import

        Using `pulumi import`, import Firewall Manager policies using the policy ID. For example:

        ```sh
        $ pulumi import aws:fms/policy:Policy example 5be49585-a7e3-4c49-dde1-a179fe4a619a
        ```

        :param str resource_name: The name of the resource.
        :param PolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_all_policy_resources: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_unused_fm_managed_resources: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_map: Optional[pulumi.Input[Union['PolicyExcludeMapArgs', 'PolicyExcludeMapArgsDict']]] = None,
                 exclude_resource_tags: Optional[pulumi.Input[_builtins.bool]] = None,
                 include_map: Optional[pulumi.Input[Union['PolicyIncludeMapArgs', 'PolicyIncludeMapArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 remediation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_set_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_tag_logical_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_service_policy_data: Optional[pulumi.Input[Union['PolicySecurityServicePolicyDataArgs', 'PolicySecurityServicePolicyDataArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyArgs.__new__(PolicyArgs)

            __props__.__dict__["delete_all_policy_resources"] = delete_all_policy_resources
            __props__.__dict__["delete_unused_fm_managed_resources"] = delete_unused_fm_managed_resources
            __props__.__dict__["description"] = description
            __props__.__dict__["exclude_map"] = exclude_map
            if exclude_resource_tags is None and not opts.urn:
                raise TypeError("Missing required property 'exclude_resource_tags'")
            __props__.__dict__["exclude_resource_tags"] = exclude_resource_tags
            __props__.__dict__["include_map"] = include_map
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["remediation_enabled"] = remediation_enabled
            __props__.__dict__["resource_set_ids"] = resource_set_ids
            __props__.__dict__["resource_tag_logical_operator"] = resource_tag_logical_operator
            __props__.__dict__["resource_tags"] = resource_tags
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["resource_type_lists"] = resource_type_lists
            if security_service_policy_data is None and not opts.urn:
                raise TypeError("Missing required property 'security_service_policy_data'")
            __props__.__dict__["security_service_policy_data"] = security_service_policy_data
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["policy_update_token"] = None
            __props__.__dict__["tags_all"] = None
        super(Policy, __self__).__init__(
            'aws:fms/policy:Policy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            delete_all_policy_resources: Optional[pulumi.Input[_builtins.bool]] = None,
            delete_unused_fm_managed_resources: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            exclude_map: Optional[pulumi.Input[Union['PolicyExcludeMapArgs', 'PolicyExcludeMapArgsDict']]] = None,
            exclude_resource_tags: Optional[pulumi.Input[_builtins.bool]] = None,
            include_map: Optional[pulumi.Input[Union['PolicyIncludeMapArgs', 'PolicyIncludeMapArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            policy_update_token: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            remediation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_set_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            resource_tag_logical_operator: Optional[pulumi.Input[_builtins.str]] = None,
            resource_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            resource_type_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            security_service_policy_data: Optional[pulumi.Input[Union['PolicySecurityServicePolicyDataArgs', 'PolicySecurityServicePolicyDataArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Policy':
        """
        Get an existing Policy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] delete_all_policy_resources: If true, the request will also perform a clean-up process. Defaults to `true`. More information can be found here [AWS Firewall Manager delete policy](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_DeletePolicy.html)
        :param pulumi.Input[_builtins.bool] delete_unused_fm_managed_resources: If true, Firewall Manager will automatically remove protections from resources that leave the policy scope. Defaults to `false`. More information can be found here [AWS Firewall Manager policy contents](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html)
        :param pulumi.Input[_builtins.str] description: The description of the AWS Network Firewall firewall policy.
        :param pulumi.Input[Union['PolicyExcludeMapArgs', 'PolicyExcludeMapArgsDict']] exclude_map: A map of lists of accounts and OU's to exclude from the policy. See the `exclude_map` block.
        :param pulumi.Input[_builtins.bool] exclude_resource_tags: A boolean value, if true the tags that are specified in the `resource_tags` are not protected by this policy. If set to false and resource_tags are populated, resources that contain tags will be protected by this policy.
        :param pulumi.Input[Union['PolicyIncludeMapArgs', 'PolicyIncludeMapArgsDict']] include_map: A map of lists of accounts and OU's to include in the policy. See the `include_map` block.
        :param pulumi.Input[_builtins.str] name: The friendly name of the AWS Firewall Manager Policy.
        :param pulumi.Input[_builtins.str] policy_update_token: A unique identifier for each update to the policy.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] remediation_enabled: A boolean value, indicates if the policy should automatically applied to resources that already exist in the account.
        :param pulumi.Input[_builtins.str] resource_tag_logical_operator: Controls how multiple resource tags are combined: with AND, so that a resource must have all tags to be included or excluded, or OR, so that a resource must have at least one tag. The valid values are `AND` and `OR`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] resource_tags: A map of resource tags, that if present will filter protections on resources based on the exclude_resource_tags.
        :param pulumi.Input[_builtins.str] resource_type: A resource type to protect. Conflicts with `resource_type_list`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_type_lists: A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values. Lists with only one element are not supported, instead use `resource_type`.
        :param pulumi.Input[Union['PolicySecurityServicePolicyDataArgs', 'PolicySecurityServicePolicyDataArgsDict']] security_service_policy_data: The objects to include in Security Service Policy Data. See the `security_service_policy_data` block.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyState.__new__(_PolicyState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["delete_all_policy_resources"] = delete_all_policy_resources
        __props__.__dict__["delete_unused_fm_managed_resources"] = delete_unused_fm_managed_resources
        __props__.__dict__["description"] = description
        __props__.__dict__["exclude_map"] = exclude_map
        __props__.__dict__["exclude_resource_tags"] = exclude_resource_tags
        __props__.__dict__["include_map"] = include_map
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_update_token"] = policy_update_token
        __props__.__dict__["region"] = region
        __props__.__dict__["remediation_enabled"] = remediation_enabled
        __props__.__dict__["resource_set_ids"] = resource_set_ids
        __props__.__dict__["resource_tag_logical_operator"] = resource_tag_logical_operator
        __props__.__dict__["resource_tags"] = resource_tags
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["resource_type_lists"] = resource_type_lists
        __props__.__dict__["security_service_policy_data"] = security_service_policy_data
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return Policy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="deleteAllPolicyResources")
    def delete_all_policy_resources(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, the request will also perform a clean-up process. Defaults to `true`. More information can be found here [AWS Firewall Manager delete policy](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_DeletePolicy.html)
        """
        return pulumi.get(self, "delete_all_policy_resources")

    @_builtins.property
    @pulumi.getter(name="deleteUnusedFmManagedResources")
    def delete_unused_fm_managed_resources(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, Firewall Manager will automatically remove protections from resources that leave the policy scope. Defaults to `false`. More information can be found here [AWS Firewall Manager policy contents](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html)
        """
        return pulumi.get(self, "delete_unused_fm_managed_resources")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the AWS Network Firewall firewall policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="excludeMap")
    def exclude_map(self) -> pulumi.Output[Optional['outputs.PolicyExcludeMap']]:
        """
        A map of lists of accounts and OU's to exclude from the policy. See the `exclude_map` block.
        """
        return pulumi.get(self, "exclude_map")

    @_builtins.property
    @pulumi.getter(name="excludeResourceTags")
    def exclude_resource_tags(self) -> pulumi.Output[_builtins.bool]:
        """
        A boolean value, if true the tags that are specified in the `resource_tags` are not protected by this policy. If set to false and resource_tags are populated, resources that contain tags will be protected by this policy.
        """
        return pulumi.get(self, "exclude_resource_tags")

    @_builtins.property
    @pulumi.getter(name="includeMap")
    def include_map(self) -> pulumi.Output[Optional['outputs.PolicyIncludeMap']]:
        """
        A map of lists of accounts and OU's to include in the policy. See the `include_map` block.
        """
        return pulumi.get(self, "include_map")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The friendly name of the AWS Firewall Manager Policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="policyUpdateToken")
    def policy_update_token(self) -> pulumi.Output[_builtins.str]:
        """
        A unique identifier for each update to the policy.
        """
        return pulumi.get(self, "policy_update_token")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="remediationEnabled")
    def remediation_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A boolean value, indicates if the policy should automatically applied to resources that already exist in the account.
        """
        return pulumi.get(self, "remediation_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceSetIds")
    def resource_set_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "resource_set_ids")

    @_builtins.property
    @pulumi.getter(name="resourceTagLogicalOperator")
    def resource_tag_logical_operator(self) -> pulumi.Output[_builtins.str]:
        """
        Controls how multiple resource tags are combined: with AND, so that a resource must have all tags to be included or excluded, or OR, so that a resource must have at least one tag. The valid values are `AND` and `OR`.
        """
        return pulumi.get(self, "resource_tag_logical_operator")

    @_builtins.property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of resource tags, that if present will filter protections on resources based on the exclude_resource_tags.
        """
        return pulumi.get(self, "resource_tags")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[_builtins.str]:
        """
        A resource type to protect. Conflicts with `resource_type_list`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter(name="resourceTypeLists")
    def resource_type_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values. Lists with only one element are not supported, instead use `resource_type`.
        """
        return pulumi.get(self, "resource_type_lists")

    @_builtins.property
    @pulumi.getter(name="securityServicePolicyData")
    def security_service_policy_data(self) -> pulumi.Output['outputs.PolicySecurityServicePolicyData']:
        """
        The objects to include in Security Service Policy Data. See the `security_service_policy_data` block.
        """
        return pulumi.get(self, "security_service_policy_data")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

