# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FleetArgs', 'Fleet']

@pulumi.input_type
class FleetArgs:
    def __init__(__self__, *,
                 ec2_instance_type: pulumi.Input[_builtins.str],
                 build_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_configuration: Optional[pulumi.Input['FleetCertificateConfigurationArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ec2_inbound_permissions: Optional[pulumi.Input[Sequence[pulumi.Input['FleetEc2InboundPermissionArgs']]]] = None,
                 fleet_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_game_session_protection_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_creation_limit_policy: Optional[pulumi.Input['FleetResourceCreationLimitPolicyArgs']] = None,
                 runtime_configuration: Optional[pulumi.Input['FleetRuntimeConfigurationArgs']] = None,
                 script_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Fleet resource.
        :param pulumi.Input[_builtins.str] ec2_instance_type: Name of an EC2 instance typeE.g., `t2.micro`
        :param pulumi.Input[_builtins.str] build_id: ID of the GameLift Build to be deployed on the fleet. Conflicts with `script_id`.
        :param pulumi.Input['FleetCertificateConfigurationArgs'] certificate_configuration: Prompts GameLift to generate a TLS/SSL certificate for the fleet. See certificate_configuration.
        :param pulumi.Input[_builtins.str] description: Human-readable description of the fleet.
        :param pulumi.Input[Sequence[pulumi.Input['FleetEc2InboundPermissionArgs']]] ec2_inbound_permissions: Range of IP addresses and port settings that permit inbound traffic to access server processes running on the fleet. See below.
        :param pulumi.Input[_builtins.str] fleet_type: Type of fleet. This value must be `ON_DEMAND` or `SPOT`. Defaults to `ON_DEMAND`.
        :param pulumi.Input[_builtins.str] instance_role_arn: ARN of an IAM role that instances in the fleet can assume.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] metric_groups: List of names of metric groups to add this fleet to. A metric group tracks metrics across all fleets in the group. Defaults to `default`.
        :param pulumi.Input[_builtins.str] name: The name of the fleet.
        :param pulumi.Input[_builtins.str] new_game_session_protection_policy: Game session protection policy to apply to all instances in this fleetE.g., `FullProtection`. Defaults to `NoProtection`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['FleetResourceCreationLimitPolicyArgs'] resource_creation_limit_policy: Policy that limits the number of game sessions an individual player can create over a span of time for this fleet. See below.
        :param pulumi.Input['FleetRuntimeConfigurationArgs'] runtime_configuration: Instructions for launching server processes on each instance in the fleet. See below.
        :param pulumi.Input[_builtins.str] script_id: ID of the GameLift Script to be deployed on the fleet. Conflicts with `build_id`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "ec2_instance_type", ec2_instance_type)
        if build_id is not None:
            pulumi.set(__self__, "build_id", build_id)
        if certificate_configuration is not None:
            pulumi.set(__self__, "certificate_configuration", certificate_configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ec2_inbound_permissions is not None:
            pulumi.set(__self__, "ec2_inbound_permissions", ec2_inbound_permissions)
        if fleet_type is not None:
            pulumi.set(__self__, "fleet_type", fleet_type)
        if instance_role_arn is not None:
            pulumi.set(__self__, "instance_role_arn", instance_role_arn)
        if metric_groups is not None:
            pulumi.set(__self__, "metric_groups", metric_groups)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_game_session_protection_policy is not None:
            pulumi.set(__self__, "new_game_session_protection_policy", new_game_session_protection_policy)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_creation_limit_policy is not None:
            pulumi.set(__self__, "resource_creation_limit_policy", resource_creation_limit_policy)
        if runtime_configuration is not None:
            pulumi.set(__self__, "runtime_configuration", runtime_configuration)
        if script_id is not None:
            pulumi.set(__self__, "script_id", script_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="ec2InstanceType")
    def ec2_instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        Name of an EC2 instance typeE.g., `t2.micro`
        """
        return pulumi.get(self, "ec2_instance_type")

    @ec2_instance_type.setter
    def ec2_instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ec2_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="buildId")
    def build_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the GameLift Build to be deployed on the fleet. Conflicts with `script_id`.
        """
        return pulumi.get(self, "build_id")

    @build_id.setter
    def build_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "build_id", value)

    @_builtins.property
    @pulumi.getter(name="certificateConfiguration")
    def certificate_configuration(self) -> Optional[pulumi.Input['FleetCertificateConfigurationArgs']]:
        """
        Prompts GameLift to generate a TLS/SSL certificate for the fleet. See certificate_configuration.
        """
        return pulumi.get(self, "certificate_configuration")

    @certificate_configuration.setter
    def certificate_configuration(self, value: Optional[pulumi.Input['FleetCertificateConfigurationArgs']]):
        pulumi.set(self, "certificate_configuration", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable description of the fleet.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="ec2InboundPermissions")
    def ec2_inbound_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FleetEc2InboundPermissionArgs']]]]:
        """
        Range of IP addresses and port settings that permit inbound traffic to access server processes running on the fleet. See below.
        """
        return pulumi.get(self, "ec2_inbound_permissions")

    @ec2_inbound_permissions.setter
    def ec2_inbound_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FleetEc2InboundPermissionArgs']]]]):
        pulumi.set(self, "ec2_inbound_permissions", value)

    @_builtins.property
    @pulumi.getter(name="fleetType")
    def fleet_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of fleet. This value must be `ON_DEMAND` or `SPOT`. Defaults to `ON_DEMAND`.
        """
        return pulumi.get(self, "fleet_type")

    @fleet_type.setter
    def fleet_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fleet_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceRoleArn")
    def instance_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of an IAM role that instances in the fleet can assume.
        """
        return pulumi.get(self, "instance_role_arn")

    @instance_role_arn.setter
    def instance_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="metricGroups")
    def metric_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of names of metric groups to add this fleet to. A metric group tracks metrics across all fleets in the group. Defaults to `default`.
        """
        return pulumi.get(self, "metric_groups")

    @metric_groups.setter
    def metric_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metric_groups", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the fleet.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="newGameSessionProtectionPolicy")
    def new_game_session_protection_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Game session protection policy to apply to all instances in this fleetE.g., `FullProtection`. Defaults to `NoProtection`.
        """
        return pulumi.get(self, "new_game_session_protection_policy")

    @new_game_session_protection_policy.setter
    def new_game_session_protection_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "new_game_session_protection_policy", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceCreationLimitPolicy")
    def resource_creation_limit_policy(self) -> Optional[pulumi.Input['FleetResourceCreationLimitPolicyArgs']]:
        """
        Policy that limits the number of game sessions an individual player can create over a span of time for this fleet. See below.
        """
        return pulumi.get(self, "resource_creation_limit_policy")

    @resource_creation_limit_policy.setter
    def resource_creation_limit_policy(self, value: Optional[pulumi.Input['FleetResourceCreationLimitPolicyArgs']]):
        pulumi.set(self, "resource_creation_limit_policy", value)

    @_builtins.property
    @pulumi.getter(name="runtimeConfiguration")
    def runtime_configuration(self) -> Optional[pulumi.Input['FleetRuntimeConfigurationArgs']]:
        """
        Instructions for launching server processes on each instance in the fleet. See below.
        """
        return pulumi.get(self, "runtime_configuration")

    @runtime_configuration.setter
    def runtime_configuration(self, value: Optional[pulumi.Input['FleetRuntimeConfigurationArgs']]):
        pulumi.set(self, "runtime_configuration", value)

    @_builtins.property
    @pulumi.getter(name="scriptId")
    def script_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the GameLift Script to be deployed on the fleet. Conflicts with `build_id`.
        """
        return pulumi.get(self, "script_id")

    @script_id.setter
    def script_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _FleetState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 build_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 build_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_configuration: Optional[pulumi.Input['FleetCertificateConfigurationArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ec2_inbound_permissions: Optional[pulumi.Input[Sequence[pulumi.Input['FleetEc2InboundPermissionArgs']]]] = None,
                 ec2_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 fleet_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 log_paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 metric_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_game_session_protection_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 operating_system: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_creation_limit_policy: Optional[pulumi.Input['FleetResourceCreationLimitPolicyArgs']] = None,
                 runtime_configuration: Optional[pulumi.Input['FleetRuntimeConfigurationArgs']] = None,
                 script_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 script_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Fleet resources.
        :param pulumi.Input[_builtins.str] arn: Fleet ARN.
        :param pulumi.Input[_builtins.str] build_arn: Build ARN.
        :param pulumi.Input[_builtins.str] build_id: ID of the GameLift Build to be deployed on the fleet. Conflicts with `script_id`.
        :param pulumi.Input['FleetCertificateConfigurationArgs'] certificate_configuration: Prompts GameLift to generate a TLS/SSL certificate for the fleet. See certificate_configuration.
        :param pulumi.Input[_builtins.str] description: Human-readable description of the fleet.
        :param pulumi.Input[Sequence[pulumi.Input['FleetEc2InboundPermissionArgs']]] ec2_inbound_permissions: Range of IP addresses and port settings that permit inbound traffic to access server processes running on the fleet. See below.
        :param pulumi.Input[_builtins.str] ec2_instance_type: Name of an EC2 instance typeE.g., `t2.micro`
        :param pulumi.Input[_builtins.str] fleet_type: Type of fleet. This value must be `ON_DEMAND` or `SPOT`. Defaults to `ON_DEMAND`.
        :param pulumi.Input[_builtins.str] instance_role_arn: ARN of an IAM role that instances in the fleet can assume.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] metric_groups: List of names of metric groups to add this fleet to. A metric group tracks metrics across all fleets in the group. Defaults to `default`.
        :param pulumi.Input[_builtins.str] name: The name of the fleet.
        :param pulumi.Input[_builtins.str] new_game_session_protection_policy: Game session protection policy to apply to all instances in this fleetE.g., `FullProtection`. Defaults to `NoProtection`.
        :param pulumi.Input[_builtins.str] operating_system: Operating system of the fleet's computing resources.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['FleetResourceCreationLimitPolicyArgs'] resource_creation_limit_policy: Policy that limits the number of game sessions an individual player can create over a span of time for this fleet. See below.
        :param pulumi.Input['FleetRuntimeConfigurationArgs'] runtime_configuration: Instructions for launching server processes on each instance in the fleet. See below.
        :param pulumi.Input[_builtins.str] script_arn: Script ARN.
        :param pulumi.Input[_builtins.str] script_id: ID of the GameLift Script to be deployed on the fleet. Conflicts with `build_id`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if build_arn is not None:
            pulumi.set(__self__, "build_arn", build_arn)
        if build_id is not None:
            pulumi.set(__self__, "build_id", build_id)
        if certificate_configuration is not None:
            pulumi.set(__self__, "certificate_configuration", certificate_configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ec2_inbound_permissions is not None:
            pulumi.set(__self__, "ec2_inbound_permissions", ec2_inbound_permissions)
        if ec2_instance_type is not None:
            pulumi.set(__self__, "ec2_instance_type", ec2_instance_type)
        if fleet_type is not None:
            pulumi.set(__self__, "fleet_type", fleet_type)
        if instance_role_arn is not None:
            pulumi.set(__self__, "instance_role_arn", instance_role_arn)
        if log_paths is not None:
            pulumi.set(__self__, "log_paths", log_paths)
        if metric_groups is not None:
            pulumi.set(__self__, "metric_groups", metric_groups)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_game_session_protection_policy is not None:
            pulumi.set(__self__, "new_game_session_protection_policy", new_game_session_protection_policy)
        if operating_system is not None:
            pulumi.set(__self__, "operating_system", operating_system)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_creation_limit_policy is not None:
            pulumi.set(__self__, "resource_creation_limit_policy", resource_creation_limit_policy)
        if runtime_configuration is not None:
            pulumi.set(__self__, "runtime_configuration", runtime_configuration)
        if script_arn is not None:
            pulumi.set(__self__, "script_arn", script_arn)
        if script_id is not None:
            pulumi.set(__self__, "script_id", script_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fleet ARN.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="buildArn")
    def build_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Build ARN.
        """
        return pulumi.get(self, "build_arn")

    @build_arn.setter
    def build_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "build_arn", value)

    @_builtins.property
    @pulumi.getter(name="buildId")
    def build_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the GameLift Build to be deployed on the fleet. Conflicts with `script_id`.
        """
        return pulumi.get(self, "build_id")

    @build_id.setter
    def build_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "build_id", value)

    @_builtins.property
    @pulumi.getter(name="certificateConfiguration")
    def certificate_configuration(self) -> Optional[pulumi.Input['FleetCertificateConfigurationArgs']]:
        """
        Prompts GameLift to generate a TLS/SSL certificate for the fleet. See certificate_configuration.
        """
        return pulumi.get(self, "certificate_configuration")

    @certificate_configuration.setter
    def certificate_configuration(self, value: Optional[pulumi.Input['FleetCertificateConfigurationArgs']]):
        pulumi.set(self, "certificate_configuration", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable description of the fleet.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="ec2InboundPermissions")
    def ec2_inbound_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FleetEc2InboundPermissionArgs']]]]:
        """
        Range of IP addresses and port settings that permit inbound traffic to access server processes running on the fleet. See below.
        """
        return pulumi.get(self, "ec2_inbound_permissions")

    @ec2_inbound_permissions.setter
    def ec2_inbound_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FleetEc2InboundPermissionArgs']]]]):
        pulumi.set(self, "ec2_inbound_permissions", value)

    @_builtins.property
    @pulumi.getter(name="ec2InstanceType")
    def ec2_instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of an EC2 instance typeE.g., `t2.micro`
        """
        return pulumi.get(self, "ec2_instance_type")

    @ec2_instance_type.setter
    def ec2_instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ec2_instance_type", value)

    @_builtins.property
    @pulumi.getter(name="fleetType")
    def fleet_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of fleet. This value must be `ON_DEMAND` or `SPOT`. Defaults to `ON_DEMAND`.
        """
        return pulumi.get(self, "fleet_type")

    @fleet_type.setter
    def fleet_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fleet_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceRoleArn")
    def instance_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of an IAM role that instances in the fleet can assume.
        """
        return pulumi.get(self, "instance_role_arn")

    @instance_role_arn.setter
    def instance_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="logPaths")
    def log_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "log_paths")

    @log_paths.setter
    def log_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "log_paths", value)

    @_builtins.property
    @pulumi.getter(name="metricGroups")
    def metric_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of names of metric groups to add this fleet to. A metric group tracks metrics across all fleets in the group. Defaults to `default`.
        """
        return pulumi.get(self, "metric_groups")

    @metric_groups.setter
    def metric_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metric_groups", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the fleet.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="newGameSessionProtectionPolicy")
    def new_game_session_protection_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Game session protection policy to apply to all instances in this fleetE.g., `FullProtection`. Defaults to `NoProtection`.
        """
        return pulumi.get(self, "new_game_session_protection_policy")

    @new_game_session_protection_policy.setter
    def new_game_session_protection_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "new_game_session_protection_policy", value)

    @_builtins.property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Operating system of the fleet's computing resources.
        """
        return pulumi.get(self, "operating_system")

    @operating_system.setter
    def operating_system(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operating_system", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceCreationLimitPolicy")
    def resource_creation_limit_policy(self) -> Optional[pulumi.Input['FleetResourceCreationLimitPolicyArgs']]:
        """
        Policy that limits the number of game sessions an individual player can create over a span of time for this fleet. See below.
        """
        return pulumi.get(self, "resource_creation_limit_policy")

    @resource_creation_limit_policy.setter
    def resource_creation_limit_policy(self, value: Optional[pulumi.Input['FleetResourceCreationLimitPolicyArgs']]):
        pulumi.set(self, "resource_creation_limit_policy", value)

    @_builtins.property
    @pulumi.getter(name="runtimeConfiguration")
    def runtime_configuration(self) -> Optional[pulumi.Input['FleetRuntimeConfigurationArgs']]:
        """
        Instructions for launching server processes on each instance in the fleet. See below.
        """
        return pulumi.get(self, "runtime_configuration")

    @runtime_configuration.setter
    def runtime_configuration(self, value: Optional[pulumi.Input['FleetRuntimeConfigurationArgs']]):
        pulumi.set(self, "runtime_configuration", value)

    @_builtins.property
    @pulumi.getter(name="scriptArn")
    def script_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Script ARN.
        """
        return pulumi.get(self, "script_arn")

    @script_arn.setter
    def script_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script_arn", value)

    @_builtins.property
    @pulumi.getter(name="scriptId")
    def script_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the GameLift Script to be deployed on the fleet. Conflicts with `build_id`.
        """
        return pulumi.get(self, "script_id")

    @script_id.setter
    def script_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:gamelift/fleet:Fleet")
class Fleet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 build_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_configuration: Optional[pulumi.Input[Union['FleetCertificateConfigurationArgs', 'FleetCertificateConfigurationArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ec2_inbound_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetEc2InboundPermissionArgs', 'FleetEc2InboundPermissionArgsDict']]]]] = None,
                 ec2_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 fleet_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_game_session_protection_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_creation_limit_policy: Optional[pulumi.Input[Union['FleetResourceCreationLimitPolicyArgs', 'FleetResourceCreationLimitPolicyArgsDict']]] = None,
                 runtime_configuration: Optional[pulumi.Input[Union['FleetRuntimeConfigurationArgs', 'FleetRuntimeConfigurationArgsDict']]] = None,
                 script_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a GameLift Fleet resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.gamelift.Fleet("example",
            build_id=example_aws_gamelift_build["id"],
            ec2_instance_type="t2.micro",
            fleet_type="ON_DEMAND",
            name="example-fleet-name",
            runtime_configuration={
                "server_processes": [{
                    "concurrent_executions": 1,
                    "launch_path": "C:\\\\game\\\\GomokuServer.exe",
                }],
            })
        ```

        ## Import

        Using `pulumi import`, import GameLift Fleets using the ID. For example:

        ```sh
        $ pulumi import aws:gamelift/fleet:Fleet example <fleet-id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] build_id: ID of the GameLift Build to be deployed on the fleet. Conflicts with `script_id`.
        :param pulumi.Input[Union['FleetCertificateConfigurationArgs', 'FleetCertificateConfigurationArgsDict']] certificate_configuration: Prompts GameLift to generate a TLS/SSL certificate for the fleet. See certificate_configuration.
        :param pulumi.Input[_builtins.str] description: Human-readable description of the fleet.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FleetEc2InboundPermissionArgs', 'FleetEc2InboundPermissionArgsDict']]]] ec2_inbound_permissions: Range of IP addresses and port settings that permit inbound traffic to access server processes running on the fleet. See below.
        :param pulumi.Input[_builtins.str] ec2_instance_type: Name of an EC2 instance typeE.g., `t2.micro`
        :param pulumi.Input[_builtins.str] fleet_type: Type of fleet. This value must be `ON_DEMAND` or `SPOT`. Defaults to `ON_DEMAND`.
        :param pulumi.Input[_builtins.str] instance_role_arn: ARN of an IAM role that instances in the fleet can assume.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] metric_groups: List of names of metric groups to add this fleet to. A metric group tracks metrics across all fleets in the group. Defaults to `default`.
        :param pulumi.Input[_builtins.str] name: The name of the fleet.
        :param pulumi.Input[_builtins.str] new_game_session_protection_policy: Game session protection policy to apply to all instances in this fleetE.g., `FullProtection`. Defaults to `NoProtection`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['FleetResourceCreationLimitPolicyArgs', 'FleetResourceCreationLimitPolicyArgsDict']] resource_creation_limit_policy: Policy that limits the number of game sessions an individual player can create over a span of time for this fleet. See below.
        :param pulumi.Input[Union['FleetRuntimeConfigurationArgs', 'FleetRuntimeConfigurationArgsDict']] runtime_configuration: Instructions for launching server processes on each instance in the fleet. See below.
        :param pulumi.Input[_builtins.str] script_id: ID of the GameLift Script to be deployed on the fleet. Conflicts with `build_id`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FleetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a GameLift Fleet resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.gamelift.Fleet("example",
            build_id=example_aws_gamelift_build["id"],
            ec2_instance_type="t2.micro",
            fleet_type="ON_DEMAND",
            name="example-fleet-name",
            runtime_configuration={
                "server_processes": [{
                    "concurrent_executions": 1,
                    "launch_path": "C:\\\\game\\\\GomokuServer.exe",
                }],
            })
        ```

        ## Import

        Using `pulumi import`, import GameLift Fleets using the ID. For example:

        ```sh
        $ pulumi import aws:gamelift/fleet:Fleet example <fleet-id>
        ```

        :param str resource_name: The name of the resource.
        :param FleetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FleetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 build_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_configuration: Optional[pulumi.Input[Union['FleetCertificateConfigurationArgs', 'FleetCertificateConfigurationArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ec2_inbound_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetEc2InboundPermissionArgs', 'FleetEc2InboundPermissionArgsDict']]]]] = None,
                 ec2_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 fleet_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_game_session_protection_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_creation_limit_policy: Optional[pulumi.Input[Union['FleetResourceCreationLimitPolicyArgs', 'FleetResourceCreationLimitPolicyArgsDict']]] = None,
                 runtime_configuration: Optional[pulumi.Input[Union['FleetRuntimeConfigurationArgs', 'FleetRuntimeConfigurationArgsDict']]] = None,
                 script_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FleetArgs.__new__(FleetArgs)

            __props__.__dict__["build_id"] = build_id
            __props__.__dict__["certificate_configuration"] = certificate_configuration
            __props__.__dict__["description"] = description
            __props__.__dict__["ec2_inbound_permissions"] = ec2_inbound_permissions
            if ec2_instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'ec2_instance_type'")
            __props__.__dict__["ec2_instance_type"] = ec2_instance_type
            __props__.__dict__["fleet_type"] = fleet_type
            __props__.__dict__["instance_role_arn"] = instance_role_arn
            __props__.__dict__["metric_groups"] = metric_groups
            __props__.__dict__["name"] = name
            __props__.__dict__["new_game_session_protection_policy"] = new_game_session_protection_policy
            __props__.__dict__["region"] = region
            __props__.__dict__["resource_creation_limit_policy"] = resource_creation_limit_policy
            __props__.__dict__["runtime_configuration"] = runtime_configuration
            __props__.__dict__["script_id"] = script_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["build_arn"] = None
            __props__.__dict__["log_paths"] = None
            __props__.__dict__["operating_system"] = None
            __props__.__dict__["script_arn"] = None
            __props__.__dict__["tags_all"] = None
        super(Fleet, __self__).__init__(
            'aws:gamelift/fleet:Fleet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            build_arn: Optional[pulumi.Input[_builtins.str]] = None,
            build_id: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_configuration: Optional[pulumi.Input[Union['FleetCertificateConfigurationArgs', 'FleetCertificateConfigurationArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            ec2_inbound_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetEc2InboundPermissionArgs', 'FleetEc2InboundPermissionArgsDict']]]]] = None,
            ec2_instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            fleet_type: Optional[pulumi.Input[_builtins.str]] = None,
            instance_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            log_paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            metric_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            new_game_session_protection_policy: Optional[pulumi.Input[_builtins.str]] = None,
            operating_system: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resource_creation_limit_policy: Optional[pulumi.Input[Union['FleetResourceCreationLimitPolicyArgs', 'FleetResourceCreationLimitPolicyArgsDict']]] = None,
            runtime_configuration: Optional[pulumi.Input[Union['FleetRuntimeConfigurationArgs', 'FleetRuntimeConfigurationArgsDict']]] = None,
            script_arn: Optional[pulumi.Input[_builtins.str]] = None,
            script_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Fleet':
        """
        Get an existing Fleet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: Fleet ARN.
        :param pulumi.Input[_builtins.str] build_arn: Build ARN.
        :param pulumi.Input[_builtins.str] build_id: ID of the GameLift Build to be deployed on the fleet. Conflicts with `script_id`.
        :param pulumi.Input[Union['FleetCertificateConfigurationArgs', 'FleetCertificateConfigurationArgsDict']] certificate_configuration: Prompts GameLift to generate a TLS/SSL certificate for the fleet. See certificate_configuration.
        :param pulumi.Input[_builtins.str] description: Human-readable description of the fleet.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FleetEc2InboundPermissionArgs', 'FleetEc2InboundPermissionArgsDict']]]] ec2_inbound_permissions: Range of IP addresses and port settings that permit inbound traffic to access server processes running on the fleet. See below.
        :param pulumi.Input[_builtins.str] ec2_instance_type: Name of an EC2 instance typeE.g., `t2.micro`
        :param pulumi.Input[_builtins.str] fleet_type: Type of fleet. This value must be `ON_DEMAND` or `SPOT`. Defaults to `ON_DEMAND`.
        :param pulumi.Input[_builtins.str] instance_role_arn: ARN of an IAM role that instances in the fleet can assume.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] metric_groups: List of names of metric groups to add this fleet to. A metric group tracks metrics across all fleets in the group. Defaults to `default`.
        :param pulumi.Input[_builtins.str] name: The name of the fleet.
        :param pulumi.Input[_builtins.str] new_game_session_protection_policy: Game session protection policy to apply to all instances in this fleetE.g., `FullProtection`. Defaults to `NoProtection`.
        :param pulumi.Input[_builtins.str] operating_system: Operating system of the fleet's computing resources.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['FleetResourceCreationLimitPolicyArgs', 'FleetResourceCreationLimitPolicyArgsDict']] resource_creation_limit_policy: Policy that limits the number of game sessions an individual player can create over a span of time for this fleet. See below.
        :param pulumi.Input[Union['FleetRuntimeConfigurationArgs', 'FleetRuntimeConfigurationArgsDict']] runtime_configuration: Instructions for launching server processes on each instance in the fleet. See below.
        :param pulumi.Input[_builtins.str] script_arn: Script ARN.
        :param pulumi.Input[_builtins.str] script_id: ID of the GameLift Script to be deployed on the fleet. Conflicts with `build_id`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FleetState.__new__(_FleetState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["build_arn"] = build_arn
        __props__.__dict__["build_id"] = build_id
        __props__.__dict__["certificate_configuration"] = certificate_configuration
        __props__.__dict__["description"] = description
        __props__.__dict__["ec2_inbound_permissions"] = ec2_inbound_permissions
        __props__.__dict__["ec2_instance_type"] = ec2_instance_type
        __props__.__dict__["fleet_type"] = fleet_type
        __props__.__dict__["instance_role_arn"] = instance_role_arn
        __props__.__dict__["log_paths"] = log_paths
        __props__.__dict__["metric_groups"] = metric_groups
        __props__.__dict__["name"] = name
        __props__.__dict__["new_game_session_protection_policy"] = new_game_session_protection_policy
        __props__.__dict__["operating_system"] = operating_system
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_creation_limit_policy"] = resource_creation_limit_policy
        __props__.__dict__["runtime_configuration"] = runtime_configuration
        __props__.__dict__["script_arn"] = script_arn
        __props__.__dict__["script_id"] = script_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return Fleet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        Fleet ARN.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="buildArn")
    def build_arn(self) -> pulumi.Output[_builtins.str]:
        """
        Build ARN.
        """
        return pulumi.get(self, "build_arn")

    @_builtins.property
    @pulumi.getter(name="buildId")
    def build_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the GameLift Build to be deployed on the fleet. Conflicts with `script_id`.
        """
        return pulumi.get(self, "build_id")

    @_builtins.property
    @pulumi.getter(name="certificateConfiguration")
    def certificate_configuration(self) -> pulumi.Output['outputs.FleetCertificateConfiguration']:
        """
        Prompts GameLift to generate a TLS/SSL certificate for the fleet. See certificate_configuration.
        """
        return pulumi.get(self, "certificate_configuration")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Human-readable description of the fleet.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="ec2InboundPermissions")
    def ec2_inbound_permissions(self) -> pulumi.Output[Sequence['outputs.FleetEc2InboundPermission']]:
        """
        Range of IP addresses and port settings that permit inbound traffic to access server processes running on the fleet. See below.
        """
        return pulumi.get(self, "ec2_inbound_permissions")

    @_builtins.property
    @pulumi.getter(name="ec2InstanceType")
    def ec2_instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        Name of an EC2 instance typeE.g., `t2.micro`
        """
        return pulumi.get(self, "ec2_instance_type")

    @_builtins.property
    @pulumi.getter(name="fleetType")
    def fleet_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Type of fleet. This value must be `ON_DEMAND` or `SPOT`. Defaults to `ON_DEMAND`.
        """
        return pulumi.get(self, "fleet_type")

    @_builtins.property
    @pulumi.getter(name="instanceRoleArn")
    def instance_role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ARN of an IAM role that instances in the fleet can assume.
        """
        return pulumi.get(self, "instance_role_arn")

    @_builtins.property
    @pulumi.getter(name="logPaths")
    def log_paths(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "log_paths")

    @_builtins.property
    @pulumi.getter(name="metricGroups")
    def metric_groups(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of names of metric groups to add this fleet to. A metric group tracks metrics across all fleets in the group. Defaults to `default`.
        """
        return pulumi.get(self, "metric_groups")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the fleet.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="newGameSessionProtectionPolicy")
    def new_game_session_protection_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Game session protection policy to apply to all instances in this fleetE.g., `FullProtection`. Defaults to `NoProtection`.
        """
        return pulumi.get(self, "new_game_session_protection_policy")

    @_builtins.property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> pulumi.Output[_builtins.str]:
        """
        Operating system of the fleet's computing resources.
        """
        return pulumi.get(self, "operating_system")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceCreationLimitPolicy")
    def resource_creation_limit_policy(self) -> pulumi.Output[Optional['outputs.FleetResourceCreationLimitPolicy']]:
        """
        Policy that limits the number of game sessions an individual player can create over a span of time for this fleet. See below.
        """
        return pulumi.get(self, "resource_creation_limit_policy")

    @_builtins.property
    @pulumi.getter(name="runtimeConfiguration")
    def runtime_configuration(self) -> pulumi.Output[Optional['outputs.FleetRuntimeConfiguration']]:
        """
        Instructions for launching server processes on each instance in the fleet. See below.
        """
        return pulumi.get(self, "runtime_configuration")

    @_builtins.property
    @pulumi.getter(name="scriptArn")
    def script_arn(self) -> pulumi.Output[_builtins.str]:
        """
        Script ARN.
        """
        return pulumi.get(self, "script_arn")

    @_builtins.property
    @pulumi.getter(name="scriptId")
    def script_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the GameLift Script to be deployed on the fleet. Conflicts with `build_id`.
        """
        return pulumi.get(self, "script_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

