# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CatalogTableArgs', 'CatalogTable']

@pulumi.input_type
class CatalogTableArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[_builtins.str],
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 open_table_format_input: Optional[pulumi.Input['CatalogTableOpenTableFormatInputArgs']] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 partition_indices: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionIndexArgs']]]] = None,
                 partition_keys: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionKeyArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retention: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_descriptor: Optional[pulumi.Input['CatalogTableStorageDescriptorArgs']] = None,
                 table_type: Optional[pulumi.Input[_builtins.str]] = None,
                 target_table: Optional[pulumi.Input['CatalogTableTargetTableArgs']] = None,
                 view_expanded_text: Optional[pulumi.Input[_builtins.str]] = None,
                 view_original_text: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CatalogTable resource.
        :param pulumi.Input[_builtins.str] database_name: Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] catalog_id: ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
        :param pulumi.Input[_builtins.str] description: Description of the table.
        :param pulumi.Input[_builtins.str] name: Name of the table. For Hive compatibility, this must be entirely lowercase.
        :param pulumi.Input['CatalogTableOpenTableFormatInputArgs'] open_table_format_input: Configuration block for open table formats. See `open_table_format_input` below.
        :param pulumi.Input[_builtins.str] owner: Owner of the table.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: Properties associated with this table, as a list of key-value pairs.
        :param pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionIndexArgs']]] partition_indices: Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
        :param pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionKeyArgs']]] partition_keys: Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] retention: Retention time for this table.
        :param pulumi.Input['CatalogTableStorageDescriptorArgs'] storage_descriptor: Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
        :param pulumi.Input[_builtins.str] table_type: Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
        :param pulumi.Input['CatalogTableTargetTableArgs'] target_table: Configuration block of a target table for resource linking. See `target_table` below.
        :param pulumi.Input[_builtins.str] view_expanded_text: If the table is a view, the expanded text of the view; otherwise null.
        :param pulumi.Input[_builtins.str] view_original_text: If the table is a view, the original text of the view; otherwise null.
        """
        pulumi.set(__self__, "database_name", database_name)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if open_table_format_input is not None:
            pulumi.set(__self__, "open_table_format_input", open_table_format_input)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if partition_indices is not None:
            pulumi.set(__self__, "partition_indices", partition_indices)
        if partition_keys is not None:
            pulumi.set(__self__, "partition_keys", partition_keys)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if storage_descriptor is not None:
            pulumi.set(__self__, "storage_descriptor", storage_descriptor)
        if table_type is not None:
            pulumi.set(__self__, "table_type", table_type)
        if target_table is not None:
            pulumi.set(__self__, "target_table", target_table)
        if view_expanded_text is not None:
            pulumi.set(__self__, "view_expanded_text", view_expanded_text)
        if view_original_text is not None:
            pulumi.set(__self__, "view_original_text", view_original_text)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.

        The following arguments are optional:
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "catalog_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the table.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the table. For Hive compatibility, this must be entirely lowercase.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="openTableFormatInput")
    def open_table_format_input(self) -> Optional[pulumi.Input['CatalogTableOpenTableFormatInputArgs']]:
        """
        Configuration block for open table formats. See `open_table_format_input` below.
        """
        return pulumi.get(self, "open_table_format_input")

    @open_table_format_input.setter
    def open_table_format_input(self, value: Optional[pulumi.Input['CatalogTableOpenTableFormatInputArgs']]):
        pulumi.set(self, "open_table_format_input", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Owner of the table.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Properties associated with this table, as a list of key-value pairs.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="partitionIndices")
    def partition_indices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionIndexArgs']]]]:
        """
        Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
        """
        return pulumi.get(self, "partition_indices")

    @partition_indices.setter
    def partition_indices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionIndexArgs']]]]):
        pulumi.set(self, "partition_indices", value)

    @_builtins.property
    @pulumi.getter(name="partitionKeys")
    def partition_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionKeyArgs']]]]:
        """
        Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
        """
        return pulumi.get(self, "partition_keys")

    @partition_keys.setter
    def partition_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionKeyArgs']]]]):
        pulumi.set(self, "partition_keys", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def retention(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Retention time for this table.
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention", value)

    @_builtins.property
    @pulumi.getter(name="storageDescriptor")
    def storage_descriptor(self) -> Optional[pulumi.Input['CatalogTableStorageDescriptorArgs']]:
        """
        Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
        """
        return pulumi.get(self, "storage_descriptor")

    @storage_descriptor.setter
    def storage_descriptor(self, value: Optional[pulumi.Input['CatalogTableStorageDescriptorArgs']]):
        pulumi.set(self, "storage_descriptor", value)

    @_builtins.property
    @pulumi.getter(name="tableType")
    def table_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
        """
        return pulumi.get(self, "table_type")

    @table_type.setter
    def table_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_type", value)

    @_builtins.property
    @pulumi.getter(name="targetTable")
    def target_table(self) -> Optional[pulumi.Input['CatalogTableTargetTableArgs']]:
        """
        Configuration block of a target table for resource linking. See `target_table` below.
        """
        return pulumi.get(self, "target_table")

    @target_table.setter
    def target_table(self, value: Optional[pulumi.Input['CatalogTableTargetTableArgs']]):
        pulumi.set(self, "target_table", value)

    @_builtins.property
    @pulumi.getter(name="viewExpandedText")
    def view_expanded_text(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If the table is a view, the expanded text of the view; otherwise null.
        """
        return pulumi.get(self, "view_expanded_text")

    @view_expanded_text.setter
    def view_expanded_text(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "view_expanded_text", value)

    @_builtins.property
    @pulumi.getter(name="viewOriginalText")
    def view_original_text(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If the table is a view, the original text of the view; otherwise null.
        """
        return pulumi.get(self, "view_original_text")

    @view_original_text.setter
    def view_original_text(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "view_original_text", value)


@pulumi.input_type
class _CatalogTableState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 open_table_format_input: Optional[pulumi.Input['CatalogTableOpenTableFormatInputArgs']] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 partition_indices: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionIndexArgs']]]] = None,
                 partition_keys: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionKeyArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retention: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_descriptor: Optional[pulumi.Input['CatalogTableStorageDescriptorArgs']] = None,
                 table_type: Optional[pulumi.Input[_builtins.str]] = None,
                 target_table: Optional[pulumi.Input['CatalogTableTargetTableArgs']] = None,
                 view_expanded_text: Optional[pulumi.Input[_builtins.str]] = None,
                 view_original_text: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CatalogTable resources.
        :param pulumi.Input[_builtins.str] arn: The ARN of the Glue Table.
        :param pulumi.Input[_builtins.str] catalog_id: ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
        :param pulumi.Input[_builtins.str] database_name: Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] description: Description of the table.
        :param pulumi.Input[_builtins.str] name: Name of the table. For Hive compatibility, this must be entirely lowercase.
        :param pulumi.Input['CatalogTableOpenTableFormatInputArgs'] open_table_format_input: Configuration block for open table formats. See `open_table_format_input` below.
        :param pulumi.Input[_builtins.str] owner: Owner of the table.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: Properties associated with this table, as a list of key-value pairs.
        :param pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionIndexArgs']]] partition_indices: Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
        :param pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionKeyArgs']]] partition_keys: Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] retention: Retention time for this table.
        :param pulumi.Input['CatalogTableStorageDescriptorArgs'] storage_descriptor: Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
        :param pulumi.Input[_builtins.str] table_type: Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
        :param pulumi.Input['CatalogTableTargetTableArgs'] target_table: Configuration block of a target table for resource linking. See `target_table` below.
        :param pulumi.Input[_builtins.str] view_expanded_text: If the table is a view, the expanded text of the view; otherwise null.
        :param pulumi.Input[_builtins.str] view_original_text: If the table is a view, the original text of the view; otherwise null.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if open_table_format_input is not None:
            pulumi.set(__self__, "open_table_format_input", open_table_format_input)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if partition_indices is not None:
            pulumi.set(__self__, "partition_indices", partition_indices)
        if partition_keys is not None:
            pulumi.set(__self__, "partition_keys", partition_keys)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if storage_descriptor is not None:
            pulumi.set(__self__, "storage_descriptor", storage_descriptor)
        if table_type is not None:
            pulumi.set(__self__, "table_type", table_type)
        if target_table is not None:
            pulumi.set(__self__, "target_table", target_table)
        if view_expanded_text is not None:
            pulumi.set(__self__, "view_expanded_text", view_expanded_text)
        if view_original_text is not None:
            pulumi.set(__self__, "view_original_text", view_original_text)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the Glue Table.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "catalog_id", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.

        The following arguments are optional:
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the table.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the table. For Hive compatibility, this must be entirely lowercase.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="openTableFormatInput")
    def open_table_format_input(self) -> Optional[pulumi.Input['CatalogTableOpenTableFormatInputArgs']]:
        """
        Configuration block for open table formats. See `open_table_format_input` below.
        """
        return pulumi.get(self, "open_table_format_input")

    @open_table_format_input.setter
    def open_table_format_input(self, value: Optional[pulumi.Input['CatalogTableOpenTableFormatInputArgs']]):
        pulumi.set(self, "open_table_format_input", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Owner of the table.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Properties associated with this table, as a list of key-value pairs.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="partitionIndices")
    def partition_indices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionIndexArgs']]]]:
        """
        Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
        """
        return pulumi.get(self, "partition_indices")

    @partition_indices.setter
    def partition_indices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionIndexArgs']]]]):
        pulumi.set(self, "partition_indices", value)

    @_builtins.property
    @pulumi.getter(name="partitionKeys")
    def partition_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionKeyArgs']]]]:
        """
        Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
        """
        return pulumi.get(self, "partition_keys")

    @partition_keys.setter
    def partition_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogTablePartitionKeyArgs']]]]):
        pulumi.set(self, "partition_keys", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def retention(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Retention time for this table.
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention", value)

    @_builtins.property
    @pulumi.getter(name="storageDescriptor")
    def storage_descriptor(self) -> Optional[pulumi.Input['CatalogTableStorageDescriptorArgs']]:
        """
        Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
        """
        return pulumi.get(self, "storage_descriptor")

    @storage_descriptor.setter
    def storage_descriptor(self, value: Optional[pulumi.Input['CatalogTableStorageDescriptorArgs']]):
        pulumi.set(self, "storage_descriptor", value)

    @_builtins.property
    @pulumi.getter(name="tableType")
    def table_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
        """
        return pulumi.get(self, "table_type")

    @table_type.setter
    def table_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_type", value)

    @_builtins.property
    @pulumi.getter(name="targetTable")
    def target_table(self) -> Optional[pulumi.Input['CatalogTableTargetTableArgs']]:
        """
        Configuration block of a target table for resource linking. See `target_table` below.
        """
        return pulumi.get(self, "target_table")

    @target_table.setter
    def target_table(self, value: Optional[pulumi.Input['CatalogTableTargetTableArgs']]):
        pulumi.set(self, "target_table", value)

    @_builtins.property
    @pulumi.getter(name="viewExpandedText")
    def view_expanded_text(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If the table is a view, the expanded text of the view; otherwise null.
        """
        return pulumi.get(self, "view_expanded_text")

    @view_expanded_text.setter
    def view_expanded_text(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "view_expanded_text", value)

    @_builtins.property
    @pulumi.getter(name="viewOriginalText")
    def view_original_text(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If the table is a view, the original text of the view; otherwise null.
        """
        return pulumi.get(self, "view_original_text")

    @view_original_text.setter
    def view_original_text(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "view_original_text", value)


@pulumi.type_token("aws:glue/catalogTable:CatalogTable")
class CatalogTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 open_table_format_input: Optional[pulumi.Input[Union['CatalogTableOpenTableFormatInputArgs', 'CatalogTableOpenTableFormatInputArgsDict']]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 partition_indices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CatalogTablePartitionIndexArgs', 'CatalogTablePartitionIndexArgsDict']]]]] = None,
                 partition_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CatalogTablePartitionKeyArgs', 'CatalogTablePartitionKeyArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retention: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_descriptor: Optional[pulumi.Input[Union['CatalogTableStorageDescriptorArgs', 'CatalogTableStorageDescriptorArgsDict']]] = None,
                 table_type: Optional[pulumi.Input[_builtins.str]] = None,
                 target_table: Optional[pulumi.Input[Union['CatalogTableTargetTableArgs', 'CatalogTableTargetTableArgsDict']]] = None,
                 view_expanded_text: Optional[pulumi.Input[_builtins.str]] = None,
                 view_original_text: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Glue Catalog Table Resource. You can refer to the [Glue Developer Guide](http://docs.aws.amazon.com/glue/latest/dg/populate-data-catalog.html) for a full explanation of the Glue Data Catalog functionality.

        ## Example Usage

        ### Basic Table

        ```python
        import pulumi
        import pulumi_aws as aws

        aws_glue_catalog_table = aws.glue.CatalogTable("aws_glue_catalog_table",
            name="MyCatalogTable",
            database_name="MyCatalogDatabase")
        ```

        ### Parquet Table for Athena

        ```python
        import pulumi
        import pulumi_aws as aws

        aws_glue_catalog_table = aws.glue.CatalogTable("aws_glue_catalog_table",
            name="MyCatalogTable",
            database_name="MyCatalogDatabase",
            table_type="EXTERNAL_TABLE",
            parameters={
                "EXTERNAL": "TRUE",
                "parquet.compression": "SNAPPY",
            },
            storage_descriptor={
                "location": "s3://my-bucket/event-streams/my-stream",
                "input_format": "org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat",
                "output_format": "org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat",
                "ser_de_info": {
                    "name": "my-stream",
                    "serialization_library": "org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe",
                    "parameters": {
                        "serialization.format": "1",
                    },
                },
                "columns": [
                    {
                        "name": "my_string",
                        "type": "string",
                    },
                    {
                        "name": "my_double",
                        "type": "double",
                    },
                    {
                        "name": "my_date",
                        "type": "date",
                        "comment": "",
                    },
                    {
                        "name": "my_bigint",
                        "type": "bigint",
                        "comment": "",
                    },
                    {
                        "name": "my_struct",
                        "type": "struct<my_nested_string:string>",
                        "comment": "",
                    },
                ],
            })
        ```

        ## Import

        Using `pulumi import`, import Glue Tables using the catalog ID (usually AWS account ID), database name, and table name. For example:

        ```sh
        $ pulumi import aws:glue/catalogTable:CatalogTable MyTable 123456789012:MyDatabase:MyTable
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] catalog_id: ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
        :param pulumi.Input[_builtins.str] database_name: Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] description: Description of the table.
        :param pulumi.Input[_builtins.str] name: Name of the table. For Hive compatibility, this must be entirely lowercase.
        :param pulumi.Input[Union['CatalogTableOpenTableFormatInputArgs', 'CatalogTableOpenTableFormatInputArgsDict']] open_table_format_input: Configuration block for open table formats. See `open_table_format_input` below.
        :param pulumi.Input[_builtins.str] owner: Owner of the table.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: Properties associated with this table, as a list of key-value pairs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CatalogTablePartitionIndexArgs', 'CatalogTablePartitionIndexArgsDict']]]] partition_indices: Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CatalogTablePartitionKeyArgs', 'CatalogTablePartitionKeyArgsDict']]]] partition_keys: Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] retention: Retention time for this table.
        :param pulumi.Input[Union['CatalogTableStorageDescriptorArgs', 'CatalogTableStorageDescriptorArgsDict']] storage_descriptor: Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
        :param pulumi.Input[_builtins.str] table_type: Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
        :param pulumi.Input[Union['CatalogTableTargetTableArgs', 'CatalogTableTargetTableArgsDict']] target_table: Configuration block of a target table for resource linking. See `target_table` below.
        :param pulumi.Input[_builtins.str] view_expanded_text: If the table is a view, the expanded text of the view; otherwise null.
        :param pulumi.Input[_builtins.str] view_original_text: If the table is a view, the original text of the view; otherwise null.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CatalogTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Glue Catalog Table Resource. You can refer to the [Glue Developer Guide](http://docs.aws.amazon.com/glue/latest/dg/populate-data-catalog.html) for a full explanation of the Glue Data Catalog functionality.

        ## Example Usage

        ### Basic Table

        ```python
        import pulumi
        import pulumi_aws as aws

        aws_glue_catalog_table = aws.glue.CatalogTable("aws_glue_catalog_table",
            name="MyCatalogTable",
            database_name="MyCatalogDatabase")
        ```

        ### Parquet Table for Athena

        ```python
        import pulumi
        import pulumi_aws as aws

        aws_glue_catalog_table = aws.glue.CatalogTable("aws_glue_catalog_table",
            name="MyCatalogTable",
            database_name="MyCatalogDatabase",
            table_type="EXTERNAL_TABLE",
            parameters={
                "EXTERNAL": "TRUE",
                "parquet.compression": "SNAPPY",
            },
            storage_descriptor={
                "location": "s3://my-bucket/event-streams/my-stream",
                "input_format": "org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat",
                "output_format": "org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat",
                "ser_de_info": {
                    "name": "my-stream",
                    "serialization_library": "org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe",
                    "parameters": {
                        "serialization.format": "1",
                    },
                },
                "columns": [
                    {
                        "name": "my_string",
                        "type": "string",
                    },
                    {
                        "name": "my_double",
                        "type": "double",
                    },
                    {
                        "name": "my_date",
                        "type": "date",
                        "comment": "",
                    },
                    {
                        "name": "my_bigint",
                        "type": "bigint",
                        "comment": "",
                    },
                    {
                        "name": "my_struct",
                        "type": "struct<my_nested_string:string>",
                        "comment": "",
                    },
                ],
            })
        ```

        ## Import

        Using `pulumi import`, import Glue Tables using the catalog ID (usually AWS account ID), database name, and table name. For example:

        ```sh
        $ pulumi import aws:glue/catalogTable:CatalogTable MyTable 123456789012:MyDatabase:MyTable
        ```

        :param str resource_name: The name of the resource.
        :param CatalogTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CatalogTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 open_table_format_input: Optional[pulumi.Input[Union['CatalogTableOpenTableFormatInputArgs', 'CatalogTableOpenTableFormatInputArgsDict']]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 partition_indices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CatalogTablePartitionIndexArgs', 'CatalogTablePartitionIndexArgsDict']]]]] = None,
                 partition_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CatalogTablePartitionKeyArgs', 'CatalogTablePartitionKeyArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retention: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_descriptor: Optional[pulumi.Input[Union['CatalogTableStorageDescriptorArgs', 'CatalogTableStorageDescriptorArgsDict']]] = None,
                 table_type: Optional[pulumi.Input[_builtins.str]] = None,
                 target_table: Optional[pulumi.Input[Union['CatalogTableTargetTableArgs', 'CatalogTableTargetTableArgsDict']]] = None,
                 view_expanded_text: Optional[pulumi.Input[_builtins.str]] = None,
                 view_original_text: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CatalogTableArgs.__new__(CatalogTableArgs)

            __props__.__dict__["catalog_id"] = catalog_id
            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["open_table_format_input"] = open_table_format_input
            __props__.__dict__["owner"] = owner
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["partition_indices"] = partition_indices
            __props__.__dict__["partition_keys"] = partition_keys
            __props__.__dict__["region"] = region
            __props__.__dict__["retention"] = retention
            __props__.__dict__["storage_descriptor"] = storage_descriptor
            __props__.__dict__["table_type"] = table_type
            __props__.__dict__["target_table"] = target_table
            __props__.__dict__["view_expanded_text"] = view_expanded_text
            __props__.__dict__["view_original_text"] = view_original_text
            __props__.__dict__["arn"] = None
        super(CatalogTable, __self__).__init__(
            'aws:glue/catalogTable:CatalogTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            open_table_format_input: Optional[pulumi.Input[Union['CatalogTableOpenTableFormatInputArgs', 'CatalogTableOpenTableFormatInputArgsDict']]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            partition_indices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CatalogTablePartitionIndexArgs', 'CatalogTablePartitionIndexArgsDict']]]]] = None,
            partition_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CatalogTablePartitionKeyArgs', 'CatalogTablePartitionKeyArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            retention: Optional[pulumi.Input[_builtins.int]] = None,
            storage_descriptor: Optional[pulumi.Input[Union['CatalogTableStorageDescriptorArgs', 'CatalogTableStorageDescriptorArgsDict']]] = None,
            table_type: Optional[pulumi.Input[_builtins.str]] = None,
            target_table: Optional[pulumi.Input[Union['CatalogTableTargetTableArgs', 'CatalogTableTargetTableArgsDict']]] = None,
            view_expanded_text: Optional[pulumi.Input[_builtins.str]] = None,
            view_original_text: Optional[pulumi.Input[_builtins.str]] = None) -> 'CatalogTable':
        """
        Get an existing CatalogTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The ARN of the Glue Table.
        :param pulumi.Input[_builtins.str] catalog_id: ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
        :param pulumi.Input[_builtins.str] database_name: Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] description: Description of the table.
        :param pulumi.Input[_builtins.str] name: Name of the table. For Hive compatibility, this must be entirely lowercase.
        :param pulumi.Input[Union['CatalogTableOpenTableFormatInputArgs', 'CatalogTableOpenTableFormatInputArgsDict']] open_table_format_input: Configuration block for open table formats. See `open_table_format_input` below.
        :param pulumi.Input[_builtins.str] owner: Owner of the table.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: Properties associated with this table, as a list of key-value pairs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CatalogTablePartitionIndexArgs', 'CatalogTablePartitionIndexArgsDict']]]] partition_indices: Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CatalogTablePartitionKeyArgs', 'CatalogTablePartitionKeyArgsDict']]]] partition_keys: Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] retention: Retention time for this table.
        :param pulumi.Input[Union['CatalogTableStorageDescriptorArgs', 'CatalogTableStorageDescriptorArgsDict']] storage_descriptor: Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
        :param pulumi.Input[_builtins.str] table_type: Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
        :param pulumi.Input[Union['CatalogTableTargetTableArgs', 'CatalogTableTargetTableArgsDict']] target_table: Configuration block of a target table for resource linking. See `target_table` below.
        :param pulumi.Input[_builtins.str] view_expanded_text: If the table is a view, the expanded text of the view; otherwise null.
        :param pulumi.Input[_builtins.str] view_original_text: If the table is a view, the original text of the view; otherwise null.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CatalogTableState.__new__(_CatalogTableState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["catalog_id"] = catalog_id
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["open_table_format_input"] = open_table_format_input
        __props__.__dict__["owner"] = owner
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["partition_indices"] = partition_indices
        __props__.__dict__["partition_keys"] = partition_keys
        __props__.__dict__["region"] = region
        __props__.__dict__["retention"] = retention
        __props__.__dict__["storage_descriptor"] = storage_descriptor
        __props__.__dict__["table_type"] = table_type
        __props__.__dict__["target_table"] = target_table
        __props__.__dict__["view_expanded_text"] = view_expanded_text
        __props__.__dict__["view_original_text"] = view_original_text
        return CatalogTable(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the Glue Table.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the Glue Catalog and database to create the table in. If omitted, this defaults to the AWS Account ID plus the database name.
        """
        return pulumi.get(self, "catalog_id")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the metadata database where the table metadata resides. For Hive compatibility, this must be all lowercase.

        The following arguments are optional:
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the table.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the table. For Hive compatibility, this must be entirely lowercase.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="openTableFormatInput")
    def open_table_format_input(self) -> pulumi.Output[Optional['outputs.CatalogTableOpenTableFormatInput']]:
        """
        Configuration block for open table formats. See `open_table_format_input` below.
        """
        return pulumi.get(self, "open_table_format_input")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Owner of the table.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Properties associated with this table, as a list of key-value pairs.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="partitionIndices")
    def partition_indices(self) -> pulumi.Output[Sequence['outputs.CatalogTablePartitionIndex']]:
        """
        Configuration block for a maximum of 3 partition indexes. See `partition_index` below.
        """
        return pulumi.get(self, "partition_indices")

    @_builtins.property
    @pulumi.getter(name="partitionKeys")
    def partition_keys(self) -> pulumi.Output[Optional[Sequence['outputs.CatalogTablePartitionKey']]]:
        """
        Configuration block of columns by which the table is partitioned. Only primitive types are supported as partition keys. See `partition_keys` below.
        """
        return pulumi.get(self, "partition_keys")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def retention(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Retention time for this table.
        """
        return pulumi.get(self, "retention")

    @_builtins.property
    @pulumi.getter(name="storageDescriptor")
    def storage_descriptor(self) -> pulumi.Output[Optional['outputs.CatalogTableStorageDescriptor']]:
        """
        Configuration block for information about the physical storage of this table. For more information, refer to the [Glue Developer Guide](https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-StorageDescriptor). See `storage_descriptor` below.
        """
        return pulumi.get(self, "storage_descriptor")

    @_builtins.property
    @pulumi.getter(name="tableType")
    def table_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.). While optional, some Athena DDL queries such as `ALTER TABLE` and `SHOW CREATE TABLE` will fail if this argument is empty.
        """
        return pulumi.get(self, "table_type")

    @_builtins.property
    @pulumi.getter(name="targetTable")
    def target_table(self) -> pulumi.Output[Optional['outputs.CatalogTableTargetTable']]:
        """
        Configuration block of a target table for resource linking. See `target_table` below.
        """
        return pulumi.get(self, "target_table")

    @_builtins.property
    @pulumi.getter(name="viewExpandedText")
    def view_expanded_text(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If the table is a view, the expanded text of the view; otherwise null.
        """
        return pulumi.get(self, "view_expanded_text")

    @_builtins.property
    @pulumi.getter(name="viewOriginalText")
    def view_original_text(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If the table is a view, the original text of the view; otherwise null.
        """
        return pulumi.get(self, "view_original_text")

