# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'WorkspaceNetworkAccessControl',
    'WorkspaceVpcConfiguration',
]

@pulumi.output_type
class WorkspaceNetworkAccessControl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "prefixListIds":
            suggest = "prefix_list_ids"
        elif key == "vpceIds":
            suggest = "vpce_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceNetworkAccessControl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceNetworkAccessControl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceNetworkAccessControl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 prefix_list_ids: Sequence[_builtins.str],
                 vpce_ids: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] prefix_list_ids: An array of prefix list IDs.
        :param Sequence[_builtins.str] vpce_ids: An array of Amazon VPC endpoint IDs for the workspace. The only VPC endpoints that can be specified here are interface VPC endpoints for Grafana workspaces (using the com.amazonaws.[region].grafana-workspace service endpoint). Other VPC endpoints will be ignored.
        """
        pulumi.set(__self__, "prefix_list_ids", prefix_list_ids)
        pulumi.set(__self__, "vpce_ids", vpce_ids)

    @_builtins.property
    @pulumi.getter(name="prefixListIds")
    def prefix_list_ids(self) -> Sequence[_builtins.str]:
        """
        An array of prefix list IDs.
        """
        return pulumi.get(self, "prefix_list_ids")

    @_builtins.property
    @pulumi.getter(name="vpceIds")
    def vpce_ids(self) -> Sequence[_builtins.str]:
        """
        An array of Amazon VPC endpoint IDs for the workspace. The only VPC endpoints that can be specified here are interface VPC endpoints for Grafana workspaces (using the com.amazonaws.[region].grafana-workspace service endpoint). Other VPC endpoints will be ignored.
        """
        return pulumi.get(self, "vpce_ids")


@pulumi.output_type
class WorkspaceVpcConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "subnetIds":
            suggest = "subnet_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceVpcConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceVpcConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceVpcConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Sequence[_builtins.str],
                 subnet_ids: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] security_group_ids: The list of Amazon EC2 security group IDs attached to the Amazon VPC for your Grafana workspace to connect.
        :param Sequence[_builtins.str] subnet_ids: The list of Amazon EC2 subnet IDs created in the Amazon VPC for your Grafana workspace to connect.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnet_ids", subnet_ids)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[_builtins.str]:
        """
        The list of Amazon EC2 security group IDs attached to the Amazon VPC for your Grafana workspace to connect.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[_builtins.str]:
        """
        The list of Amazon EC2 subnet IDs created in the Amazon VPC for your Grafana workspace to connect.
        """
        return pulumi.get(self, "subnet_ids")


