# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MalwareProtectionPlanArgs', 'MalwareProtectionPlan']

@pulumi.input_type
class MalwareProtectionPlanArgs:
    def __init__(__self__, *,
                 role: pulumi.Input[_builtins.str],
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['MalwareProtectionPlanActionArgs']]]] = None,
                 protected_resource: Optional[pulumi.Input['MalwareProtectionPlanProtectedResourceArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a MalwareProtectionPlan resource.
        :param pulumi.Input[_builtins.str] role: ARN of IAM role that includes the permissions required to scan and add tags to the associated protected resource.
        :param pulumi.Input[Sequence[pulumi.Input['MalwareProtectionPlanActionArgs']]] actions: Information about whether the tags will be added to the S3 object after scanning. See `actions` below.
        :param pulumi.Input['MalwareProtectionPlanProtectedResourceArgs'] protected_resource: Information about the protected resource that is associated with the created Malware Protection plan. Presently, S3Bucket is the only supported protected resource. See `protected_resource` below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "role", role)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if protected_resource is not None:
            pulumi.set(__self__, "protected_resource", protected_resource)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Input[_builtins.str]:
        """
        ARN of IAM role that includes the permissions required to scan and add tags to the associated protected resource.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MalwareProtectionPlanActionArgs']]]]:
        """
        Information about whether the tags will be added to the S3 object after scanning. See `actions` below.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MalwareProtectionPlanActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter(name="protectedResource")
    def protected_resource(self) -> Optional[pulumi.Input['MalwareProtectionPlanProtectedResourceArgs']]:
        """
        Information about the protected resource that is associated with the created Malware Protection plan. Presently, S3Bucket is the only supported protected resource. See `protected_resource` below.
        """
        return pulumi.get(self, "protected_resource")

    @protected_resource.setter
    def protected_resource(self, value: Optional[pulumi.Input['MalwareProtectionPlanProtectedResourceArgs']]):
        pulumi.set(self, "protected_resource", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _MalwareProtectionPlanState:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['MalwareProtectionPlanActionArgs']]]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_resource: Optional[pulumi.Input['MalwareProtectionPlanProtectedResourceArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering MalwareProtectionPlan resources.
        :param pulumi.Input[Sequence[pulumi.Input['MalwareProtectionPlanActionArgs']]] actions: Information about whether the tags will be added to the S3 object after scanning. See `actions` below.
        :param pulumi.Input[_builtins.str] arn: The ARN of the GuardDuty malware protection plan
        :param pulumi.Input[_builtins.str] created_at: The timestamp when the Malware Protection plan resource was created.
        :param pulumi.Input['MalwareProtectionPlanProtectedResourceArgs'] protected_resource: Information about the protected resource that is associated with the created Malware Protection plan. Presently, S3Bucket is the only supported protected resource. See `protected_resource` below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role: ARN of IAM role that includes the permissions required to scan and add tags to the associated protected resource.
        :param pulumi.Input[_builtins.str] status: The GuardDuty malware protection plan status. Valid values are `ACTIVE`, `WARNING`, and `ERROR`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if protected_resource is not None:
            pulumi.set(__self__, "protected_resource", protected_resource)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MalwareProtectionPlanActionArgs']]]]:
        """
        Information about whether the tags will be added to the S3 object after scanning. See `actions` below.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MalwareProtectionPlanActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the GuardDuty malware protection plan
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the Malware Protection plan resource was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="protectedResource")
    def protected_resource(self) -> Optional[pulumi.Input['MalwareProtectionPlanProtectedResourceArgs']]:
        """
        Information about the protected resource that is associated with the created Malware Protection plan. Presently, S3Bucket is the only supported protected resource. See `protected_resource` below.
        """
        return pulumi.get(self, "protected_resource")

    @protected_resource.setter
    def protected_resource(self, value: Optional[pulumi.Input['MalwareProtectionPlanProtectedResourceArgs']]):
        pulumi.set(self, "protected_resource", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of IAM role that includes the permissions required to scan and add tags to the associated protected resource.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GuardDuty malware protection plan status. Valid values are `ACTIVE`, `WARNING`, and `ERROR`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:guardduty/malwareProtectionPlan:MalwareProtectionPlan")
class MalwareProtectionPlan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MalwareProtectionPlanActionArgs', 'MalwareProtectionPlanActionArgsDict']]]]] = None,
                 protected_resource: Optional[pulumi.Input[Union['MalwareProtectionPlanProtectedResourceArgs', 'MalwareProtectionPlanProtectedResourceArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a resource to manage a GuardDuty malware protection plan.

        ## Example Usage

        ## Import

        Using `pulumi import`, import GuardDuty malware protection plans using their IDs. For example:

        ```sh
        $ pulumi import aws:guardduty/malwareProtectionPlan:MalwareProtectionPlan example 1234567890abcdef0123
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MalwareProtectionPlanActionArgs', 'MalwareProtectionPlanActionArgsDict']]]] actions: Information about whether the tags will be added to the S3 object after scanning. See `actions` below.
        :param pulumi.Input[Union['MalwareProtectionPlanProtectedResourceArgs', 'MalwareProtectionPlanProtectedResourceArgsDict']] protected_resource: Information about the protected resource that is associated with the created Malware Protection plan. Presently, S3Bucket is the only supported protected resource. See `protected_resource` below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role: ARN of IAM role that includes the permissions required to scan and add tags to the associated protected resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MalwareProtectionPlanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage a GuardDuty malware protection plan.

        ## Example Usage

        ## Import

        Using `pulumi import`, import GuardDuty malware protection plans using their IDs. For example:

        ```sh
        $ pulumi import aws:guardduty/malwareProtectionPlan:MalwareProtectionPlan example 1234567890abcdef0123
        ```

        :param str resource_name: The name of the resource.
        :param MalwareProtectionPlanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MalwareProtectionPlanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MalwareProtectionPlanActionArgs', 'MalwareProtectionPlanActionArgsDict']]]]] = None,
                 protected_resource: Optional[pulumi.Input[Union['MalwareProtectionPlanProtectedResourceArgs', 'MalwareProtectionPlanProtectedResourceArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MalwareProtectionPlanArgs.__new__(MalwareProtectionPlanArgs)

            __props__.__dict__["actions"] = actions
            __props__.__dict__["protected_resource"] = protected_resource
            __props__.__dict__["region"] = region
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
        super(MalwareProtectionPlan, __self__).__init__(
            'aws:guardduty/malwareProtectionPlan:MalwareProtectionPlan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MalwareProtectionPlanActionArgs', 'MalwareProtectionPlanActionArgsDict']]]]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            protected_resource: Optional[pulumi.Input[Union['MalwareProtectionPlanProtectedResourceArgs', 'MalwareProtectionPlanProtectedResourceArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'MalwareProtectionPlan':
        """
        Get an existing MalwareProtectionPlan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MalwareProtectionPlanActionArgs', 'MalwareProtectionPlanActionArgsDict']]]] actions: Information about whether the tags will be added to the S3 object after scanning. See `actions` below.
        :param pulumi.Input[_builtins.str] arn: The ARN of the GuardDuty malware protection plan
        :param pulumi.Input[_builtins.str] created_at: The timestamp when the Malware Protection plan resource was created.
        :param pulumi.Input[Union['MalwareProtectionPlanProtectedResourceArgs', 'MalwareProtectionPlanProtectedResourceArgsDict']] protected_resource: Information about the protected resource that is associated with the created Malware Protection plan. Presently, S3Bucket is the only supported protected resource. See `protected_resource` below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role: ARN of IAM role that includes the permissions required to scan and add tags to the associated protected resource.
        :param pulumi.Input[_builtins.str] status: The GuardDuty malware protection plan status. Valid values are `ACTIVE`, `WARNING`, and `ERROR`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MalwareProtectionPlanState.__new__(_MalwareProtectionPlanState)

        __props__.__dict__["actions"] = actions
        __props__.__dict__["arn"] = arn
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["protected_resource"] = protected_resource
        __props__.__dict__["region"] = region
        __props__.__dict__["role"] = role
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return MalwareProtectionPlan(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Sequence['outputs.MalwareProtectionPlanAction']]:
        """
        Information about whether the tags will be added to the S3 object after scanning. See `actions` below.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the GuardDuty malware protection plan
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the Malware Protection plan resource was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="protectedResource")
    def protected_resource(self) -> pulumi.Output[Optional['outputs.MalwareProtectionPlanProtectedResource']]:
        """
        Information about the protected resource that is associated with the created Malware Protection plan. Presently, S3Bucket is the only supported protected resource. See `protected_resource` below.
        """
        return pulumi.get(self, "protected_resource")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of IAM role that includes the permissions required to scan and add tags to the associated protected resource.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The GuardDuty malware protection plan status. Valid values are `ACTIVE`, `WARNING`, and `ERROR`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "tags_all")

