# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MemberArgs', 'Member']

@pulumi.input_type
class MemberArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 detector_id: pulumi.Input[_builtins.str],
                 email: pulumi.Input[_builtins.str],
                 disable_email_notification: Optional[pulumi.Input[_builtins.bool]] = None,
                 invitation_message: Optional[pulumi.Input[_builtins.str]] = None,
                 invite: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Member resource.
        :param pulumi.Input[_builtins.str] account_id: AWS account ID for member account.
        :param pulumi.Input[_builtins.str] detector_id: The detector ID of the GuardDuty account where you want to create member accounts.
        :param pulumi.Input[_builtins.str] email: Email address for member account.
        :param pulumi.Input[_builtins.bool] disable_email_notification: Boolean whether an email notification is sent to the accounts. Defaults to `false`.
        :param pulumi.Input[_builtins.str] invitation_message: Message for invitation.
        :param pulumi.Input[_builtins.bool] invite: Boolean whether to invite the account to GuardDuty as a member. Defaults to `false`. To detect if an invitation needs to be (re-)sent, the this provider state value is `true` based on a `relationship_status` of `Disabled`, `Enabled`, `Invited`, or `EmailVerificationInProgress`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "detector_id", detector_id)
        pulumi.set(__self__, "email", email)
        if disable_email_notification is not None:
            pulumi.set(__self__, "disable_email_notification", disable_email_notification)
        if invitation_message is not None:
            pulumi.set(__self__, "invitation_message", invitation_message)
        if invite is not None:
            pulumi.set(__self__, "invite", invite)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        AWS account ID for member account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="detectorId")
    def detector_id(self) -> pulumi.Input[_builtins.str]:
        """
        The detector ID of the GuardDuty account where you want to create member accounts.
        """
        return pulumi.get(self, "detector_id")

    @detector_id.setter
    def detector_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "detector_id", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Input[_builtins.str]:
        """
        Email address for member account.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="disableEmailNotification")
    def disable_email_notification(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean whether an email notification is sent to the accounts. Defaults to `false`.
        """
        return pulumi.get(self, "disable_email_notification")

    @disable_email_notification.setter
    def disable_email_notification(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_email_notification", value)

    @_builtins.property
    @pulumi.getter(name="invitationMessage")
    def invitation_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Message for invitation.
        """
        return pulumi.get(self, "invitation_message")

    @invitation_message.setter
    def invitation_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "invitation_message", value)

    @_builtins.property
    @pulumi.getter
    def invite(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean whether to invite the account to GuardDuty as a member. Defaults to `false`. To detect if an invitation needs to be (re-)sent, the this provider state value is `true` based on a `relationship_status` of `Disabled`, `Enabled`, `Invited`, or `EmailVerificationInProgress`.
        """
        return pulumi.get(self, "invite")

    @invite.setter
    def invite(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "invite", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _MemberState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 detector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_email_notification: Optional[pulumi.Input[_builtins.bool]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 invitation_message: Optional[pulumi.Input[_builtins.str]] = None,
                 invite: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 relationship_status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Member resources.
        :param pulumi.Input[_builtins.str] account_id: AWS account ID for member account.
        :param pulumi.Input[_builtins.str] detector_id: The detector ID of the GuardDuty account where you want to create member accounts.
        :param pulumi.Input[_builtins.bool] disable_email_notification: Boolean whether an email notification is sent to the accounts. Defaults to `false`.
        :param pulumi.Input[_builtins.str] email: Email address for member account.
        :param pulumi.Input[_builtins.str] invitation_message: Message for invitation.
        :param pulumi.Input[_builtins.bool] invite: Boolean whether to invite the account to GuardDuty as a member. Defaults to `false`. To detect if an invitation needs to be (re-)sent, the this provider state value is `true` based on a `relationship_status` of `Disabled`, `Enabled`, `Invited`, or `EmailVerificationInProgress`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] relationship_status: The status of the relationship between the member account and its primary account. More information can be found in [Amazon GuardDuty API Reference](https://docs.aws.amazon.com/guardduty/latest/ug/get-members.html).
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if detector_id is not None:
            pulumi.set(__self__, "detector_id", detector_id)
        if disable_email_notification is not None:
            pulumi.set(__self__, "disable_email_notification", disable_email_notification)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if invitation_message is not None:
            pulumi.set(__self__, "invitation_message", invitation_message)
        if invite is not None:
            pulumi.set(__self__, "invite", invite)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if relationship_status is not None:
            pulumi.set(__self__, "relationship_status", relationship_status)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS account ID for member account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="detectorId")
    def detector_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The detector ID of the GuardDuty account where you want to create member accounts.
        """
        return pulumi.get(self, "detector_id")

    @detector_id.setter
    def detector_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "detector_id", value)

    @_builtins.property
    @pulumi.getter(name="disableEmailNotification")
    def disable_email_notification(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean whether an email notification is sent to the accounts. Defaults to `false`.
        """
        return pulumi.get(self, "disable_email_notification")

    @disable_email_notification.setter
    def disable_email_notification(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_email_notification", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email address for member account.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="invitationMessage")
    def invitation_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Message for invitation.
        """
        return pulumi.get(self, "invitation_message")

    @invitation_message.setter
    def invitation_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "invitation_message", value)

    @_builtins.property
    @pulumi.getter
    def invite(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean whether to invite the account to GuardDuty as a member. Defaults to `false`. To detect if an invitation needs to be (re-)sent, the this provider state value is `true` based on a `relationship_status` of `Disabled`, `Enabled`, `Invited`, or `EmailVerificationInProgress`.
        """
        return pulumi.get(self, "invite")

    @invite.setter
    def invite(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "invite", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="relationshipStatus")
    def relationship_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the relationship between the member account and its primary account. More information can be found in [Amazon GuardDuty API Reference](https://docs.aws.amazon.com/guardduty/latest/ug/get-members.html).
        """
        return pulumi.get(self, "relationship_status")

    @relationship_status.setter
    def relationship_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "relationship_status", value)


@pulumi.type_token("aws:guardduty/member:Member")
class Member(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 detector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_email_notification: Optional[pulumi.Input[_builtins.bool]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 invitation_message: Optional[pulumi.Input[_builtins.str]] = None,
                 invite: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to manage a GuardDuty member. To accept invitations in member accounts, see the `guardduty.InviteAccepter` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        primary = aws.guardduty.Detector("primary", enable=True)
        member = aws.guardduty.Detector("member", enable=True)
        member_member = aws.guardduty.Member("member",
            account_id=member.account_id,
            detector_id=primary.id,
            email="required@example.com",
            invite=True,
            invitation_message="please accept guardduty invitation")
        ```

        ## Import

        Using `pulumi import`, import GuardDuty members using the primary GuardDuty detector ID and member AWS account ID. For example:

        ```sh
        $ pulumi import aws:guardduty/member:Member MyMember 00b00fd5aecc0ab60a708659477e9617:123456789012
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: AWS account ID for member account.
        :param pulumi.Input[_builtins.str] detector_id: The detector ID of the GuardDuty account where you want to create member accounts.
        :param pulumi.Input[_builtins.bool] disable_email_notification: Boolean whether an email notification is sent to the accounts. Defaults to `false`.
        :param pulumi.Input[_builtins.str] email: Email address for member account.
        :param pulumi.Input[_builtins.str] invitation_message: Message for invitation.
        :param pulumi.Input[_builtins.bool] invite: Boolean whether to invite the account to GuardDuty as a member. Defaults to `false`. To detect if an invitation needs to be (re-)sent, the this provider state value is `true` based on a `relationship_status` of `Disabled`, `Enabled`, `Invited`, or `EmailVerificationInProgress`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MemberArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage a GuardDuty member. To accept invitations in member accounts, see the `guardduty.InviteAccepter` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        primary = aws.guardduty.Detector("primary", enable=True)
        member = aws.guardduty.Detector("member", enable=True)
        member_member = aws.guardduty.Member("member",
            account_id=member.account_id,
            detector_id=primary.id,
            email="required@example.com",
            invite=True,
            invitation_message="please accept guardduty invitation")
        ```

        ## Import

        Using `pulumi import`, import GuardDuty members using the primary GuardDuty detector ID and member AWS account ID. For example:

        ```sh
        $ pulumi import aws:guardduty/member:Member MyMember 00b00fd5aecc0ab60a708659477e9617:123456789012
        ```

        :param str resource_name: The name of the resource.
        :param MemberArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MemberArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 detector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_email_notification: Optional[pulumi.Input[_builtins.bool]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 invitation_message: Optional[pulumi.Input[_builtins.str]] = None,
                 invite: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MemberArgs.__new__(MemberArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if detector_id is None and not opts.urn:
                raise TypeError("Missing required property 'detector_id'")
            __props__.__dict__["detector_id"] = detector_id
            __props__.__dict__["disable_email_notification"] = disable_email_notification
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["invitation_message"] = invitation_message
            __props__.__dict__["invite"] = invite
            __props__.__dict__["region"] = region
            __props__.__dict__["relationship_status"] = None
        super(Member, __self__).__init__(
            'aws:guardduty/member:Member',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            detector_id: Optional[pulumi.Input[_builtins.str]] = None,
            disable_email_notification: Optional[pulumi.Input[_builtins.bool]] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            invitation_message: Optional[pulumi.Input[_builtins.str]] = None,
            invite: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            relationship_status: Optional[pulumi.Input[_builtins.str]] = None) -> 'Member':
        """
        Get an existing Member resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: AWS account ID for member account.
        :param pulumi.Input[_builtins.str] detector_id: The detector ID of the GuardDuty account where you want to create member accounts.
        :param pulumi.Input[_builtins.bool] disable_email_notification: Boolean whether an email notification is sent to the accounts. Defaults to `false`.
        :param pulumi.Input[_builtins.str] email: Email address for member account.
        :param pulumi.Input[_builtins.str] invitation_message: Message for invitation.
        :param pulumi.Input[_builtins.bool] invite: Boolean whether to invite the account to GuardDuty as a member. Defaults to `false`. To detect if an invitation needs to be (re-)sent, the this provider state value is `true` based on a `relationship_status` of `Disabled`, `Enabled`, `Invited`, or `EmailVerificationInProgress`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] relationship_status: The status of the relationship between the member account and its primary account. More information can be found in [Amazon GuardDuty API Reference](https://docs.aws.amazon.com/guardduty/latest/ug/get-members.html).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MemberState.__new__(_MemberState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["detector_id"] = detector_id
        __props__.__dict__["disable_email_notification"] = disable_email_notification
        __props__.__dict__["email"] = email
        __props__.__dict__["invitation_message"] = invitation_message
        __props__.__dict__["invite"] = invite
        __props__.__dict__["region"] = region
        __props__.__dict__["relationship_status"] = relationship_status
        return Member(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        AWS account ID for member account.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="detectorId")
    def detector_id(self) -> pulumi.Output[_builtins.str]:
        """
        The detector ID of the GuardDuty account where you want to create member accounts.
        """
        return pulumi.get(self, "detector_id")

    @_builtins.property
    @pulumi.getter(name="disableEmailNotification")
    def disable_email_notification(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean whether an email notification is sent to the accounts. Defaults to `false`.
        """
        return pulumi.get(self, "disable_email_notification")

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[_builtins.str]:
        """
        Email address for member account.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="invitationMessage")
    def invitation_message(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Message for invitation.
        """
        return pulumi.get(self, "invitation_message")

    @_builtins.property
    @pulumi.getter
    def invite(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean whether to invite the account to GuardDuty as a member. Defaults to `false`. To detect if an invitation needs to be (re-)sent, the this provider state value is `true` based on a `relationship_status` of `Disabled`, `Enabled`, `Invited`, or `EmailVerificationInProgress`.
        """
        return pulumi.get(self, "invite")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="relationshipStatus")
    def relationship_status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the relationship between the member account and its primary account. More information can be found in [Amazon GuardDuty API Reference](https://docs.aws.amazon.com/guardduty/latest/ug/get-members.html).
        """
        return pulumi.get(self, "relationship_status")

