# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServiceSpecificCredentialArgs', 'ServiceSpecificCredential']

@pulumi.input_type
class ServiceSpecificCredentialArgs:
    def __init__(__self__, *,
                 service_name: pulumi.Input[_builtins.str],
                 user_name: pulumi.Input[_builtins.str],
                 credential_age_days: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ServiceSpecificCredential resource.
        :param pulumi.Input[_builtins.str] service_name: The name of the AWS service that is to be associated with the credentials. The service you specify here is the only service that can be accessed using these credentials. Supported services are `codecommit.amazonaws.com`, `bedrock.amazonaws.com`, and `cassandra.amazonaws.com`.
        :param pulumi.Input[_builtins.str] user_name: The name of the IAM user that is to be associated with the credentials. The new service-specific credentials have the same permissions as the associated user except that they can be used only to access the specified service.
        :param pulumi.Input[_builtins.int] credential_age_days: The number of days until the service specific credential expires. This field is only valid for Bedrock API keys and must be between 1 and 36600 (approximately 100 years). When not specified, the credential will not expire.
        :param pulumi.Input[_builtins.str] status: The status to be assigned to the service-specific credential. Valid values are `Active`, `Inactive`, and `Expired`. Default value is `Active`. Note that `Expired` is only used for read operations and cannot be set manually.
        """
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "user_name", user_name)
        if credential_age_days is not None:
            pulumi.set(__self__, "credential_age_days", credential_age_days)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the AWS service that is to be associated with the credentials. The service you specify here is the only service that can be accessed using these credentials. Supported services are `codecommit.amazonaws.com`, `bedrock.amazonaws.com`, and `cassandra.amazonaws.com`.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the IAM user that is to be associated with the credentials. The new service-specific credentials have the same permissions as the associated user except that they can be used only to access the specified service.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_name", value)

    @_builtins.property
    @pulumi.getter(name="credentialAgeDays")
    def credential_age_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of days until the service specific credential expires. This field is only valid for Bedrock API keys and must be between 1 and 36600 (approximately 100 years). When not specified, the credential will not expire.
        """
        return pulumi.get(self, "credential_age_days")

    @credential_age_days.setter
    def credential_age_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "credential_age_days", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status to be assigned to the service-specific credential. Valid values are `Active`, `Inactive`, and `Expired`. Default value is `Active`. Note that `Expired` is only used for read operations and cannot be set manually.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _ServiceSpecificCredentialState:
    def __init__(__self__, *,
                 create_date: Optional[pulumi.Input[_builtins.str]] = None,
                 credential_age_days: Optional[pulumi.Input[_builtins.int]] = None,
                 expiration_date: Optional[pulumi.Input[_builtins.str]] = None,
                 service_credential_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 service_credential_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_password: Optional[pulumi.Input[_builtins.str]] = None,
                 service_specific_credential_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceSpecificCredential resources.
        :param pulumi.Input[_builtins.str] create_date: The date and time, in RFC3339 format, when the service-specific credential was created.
        :param pulumi.Input[_builtins.int] credential_age_days: The number of days until the service specific credential expires. This field is only valid for Bedrock API keys and must be between 1 and 36600 (approximately 100 years). When not specified, the credential will not expire.
        :param pulumi.Input[_builtins.str] expiration_date: The date and time, in RFC3339 format, when the service specific credential expires. This field is only present for Bedrock API keys that were created with an expiration period.
        :param pulumi.Input[_builtins.str] service_credential_alias: For Bedrock API keys, this is the public portion of the credential that includes the IAM user name and a suffix containing version and creation information.
        :param pulumi.Input[_builtins.str] service_credential_secret: For Bedrock API keys, this is the secret portion of the credential that should be used to authenticate API calls. This value is only available when the credential is created.
        :param pulumi.Input[_builtins.str] service_name: The name of the AWS service that is to be associated with the credentials. The service you specify here is the only service that can be accessed using these credentials. Supported services are `codecommit.amazonaws.com`, `bedrock.amazonaws.com`, and `cassandra.amazonaws.com`.
        :param pulumi.Input[_builtins.str] service_password: The generated password for the service-specific credential. This value is only available when the credential is created.
        :param pulumi.Input[_builtins.str] service_specific_credential_id: The unique identifier for the service-specific credential.
        :param pulumi.Input[_builtins.str] service_user_name: The generated user name for the service-specific credential. This value is generated by combining the IAM user's name combined with the ID number of the AWS account, as in `jane-at-123456789012`, for example.
        :param pulumi.Input[_builtins.str] status: The status to be assigned to the service-specific credential. Valid values are `Active`, `Inactive`, and `Expired`. Default value is `Active`. Note that `Expired` is only used for read operations and cannot be set manually.
        :param pulumi.Input[_builtins.str] user_name: The name of the IAM user that is to be associated with the credentials. The new service-specific credentials have the same permissions as the associated user except that they can be used only to access the specified service.
        """
        if create_date is not None:
            pulumi.set(__self__, "create_date", create_date)
        if credential_age_days is not None:
            pulumi.set(__self__, "credential_age_days", credential_age_days)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if service_credential_alias is not None:
            pulumi.set(__self__, "service_credential_alias", service_credential_alias)
        if service_credential_secret is not None:
            pulumi.set(__self__, "service_credential_secret", service_credential_secret)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if service_password is not None:
            pulumi.set(__self__, "service_password", service_password)
        if service_specific_credential_id is not None:
            pulumi.set(__self__, "service_specific_credential_id", service_specific_credential_id)
        if service_user_name is not None:
            pulumi.set(__self__, "service_user_name", service_user_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="createDate")
    def create_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time, in RFC3339 format, when the service-specific credential was created.
        """
        return pulumi.get(self, "create_date")

    @create_date.setter
    def create_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_date", value)

    @_builtins.property
    @pulumi.getter(name="credentialAgeDays")
    def credential_age_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of days until the service specific credential expires. This field is only valid for Bedrock API keys and must be between 1 and 36600 (approximately 100 years). When not specified, the credential will not expire.
        """
        return pulumi.get(self, "credential_age_days")

    @credential_age_days.setter
    def credential_age_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "credential_age_days", value)

    @_builtins.property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time, in RFC3339 format, when the service specific credential expires. This field is only present for Bedrock API keys that were created with an expiration period.
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expiration_date", value)

    @_builtins.property
    @pulumi.getter(name="serviceCredentialAlias")
    def service_credential_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For Bedrock API keys, this is the public portion of the credential that includes the IAM user name and a suffix containing version and creation information.
        """
        return pulumi.get(self, "service_credential_alias")

    @service_credential_alias.setter
    def service_credential_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_credential_alias", value)

    @_builtins.property
    @pulumi.getter(name="serviceCredentialSecret")
    def service_credential_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For Bedrock API keys, this is the secret portion of the credential that should be used to authenticate API calls. This value is only available when the credential is created.
        """
        return pulumi.get(self, "service_credential_secret")

    @service_credential_secret.setter
    def service_credential_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_credential_secret", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the AWS service that is to be associated with the credentials. The service you specify here is the only service that can be accessed using these credentials. Supported services are `codecommit.amazonaws.com`, `bedrock.amazonaws.com`, and `cassandra.amazonaws.com`.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="servicePassword")
    def service_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The generated password for the service-specific credential. This value is only available when the credential is created.
        """
        return pulumi.get(self, "service_password")

    @service_password.setter
    def service_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_password", value)

    @_builtins.property
    @pulumi.getter(name="serviceSpecificCredentialId")
    def service_specific_credential_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier for the service-specific credential.
        """
        return pulumi.get(self, "service_specific_credential_id")

    @service_specific_credential_id.setter
    def service_specific_credential_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_specific_credential_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceUserName")
    def service_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The generated user name for the service-specific credential. This value is generated by combining the IAM user's name combined with the ID number of the AWS account, as in `jane-at-123456789012`, for example.
        """
        return pulumi.get(self, "service_user_name")

    @service_user_name.setter
    def service_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_user_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status to be assigned to the service-specific credential. Valid values are `Active`, `Inactive`, and `Expired`. Default value is `Active`. Note that `Expired` is only used for read operations and cannot be set manually.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IAM user that is to be associated with the credentials. The new service-specific credentials have the same permissions as the associated user except that they can be used only to access the specified service.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)


@pulumi.type_token("aws:iam/serviceSpecificCredential:ServiceSpecificCredential")
class ServiceSpecificCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credential_age_days: Optional[pulumi.Input[_builtins.int]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an IAM Service Specific Credential.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.iam.User("example", name="example")
        example_service_specific_credential = aws.iam.ServiceSpecificCredential("example",
            service_name="codecommit.amazonaws.com",
            user_name=example.name)
        ```

        ### Bedrock API Key with Expiration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.iam.User("example", name="example")
        bedrock = aws.iam.ServiceSpecificCredential("bedrock",
            service_name="bedrock.amazonaws.com",
            user_name=example.name,
            credential_age_days=30)
        ```

        ## Import

        Using `pulumi import`, import IAM Service Specific Credentials using the `service_name:user_name:service_specific_credential_id`. For example:

        ```sh
        $ pulumi import aws:iam/serviceSpecificCredential:ServiceSpecificCredential default `codecommit.amazonaws.com:example:some-id`
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] credential_age_days: The number of days until the service specific credential expires. This field is only valid for Bedrock API keys and must be between 1 and 36600 (approximately 100 years). When not specified, the credential will not expire.
        :param pulumi.Input[_builtins.str] service_name: The name of the AWS service that is to be associated with the credentials. The service you specify here is the only service that can be accessed using these credentials. Supported services are `codecommit.amazonaws.com`, `bedrock.amazonaws.com`, and `cassandra.amazonaws.com`.
        :param pulumi.Input[_builtins.str] status: The status to be assigned to the service-specific credential. Valid values are `Active`, `Inactive`, and `Expired`. Default value is `Active`. Note that `Expired` is only used for read operations and cannot be set manually.
        :param pulumi.Input[_builtins.str] user_name: The name of the IAM user that is to be associated with the credentials. The new service-specific credentials have the same permissions as the associated user except that they can be used only to access the specified service.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceSpecificCredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an IAM Service Specific Credential.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.iam.User("example", name="example")
        example_service_specific_credential = aws.iam.ServiceSpecificCredential("example",
            service_name="codecommit.amazonaws.com",
            user_name=example.name)
        ```

        ### Bedrock API Key with Expiration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.iam.User("example", name="example")
        bedrock = aws.iam.ServiceSpecificCredential("bedrock",
            service_name="bedrock.amazonaws.com",
            user_name=example.name,
            credential_age_days=30)
        ```

        ## Import

        Using `pulumi import`, import IAM Service Specific Credentials using the `service_name:user_name:service_specific_credential_id`. For example:

        ```sh
        $ pulumi import aws:iam/serviceSpecificCredential:ServiceSpecificCredential default `codecommit.amazonaws.com:example:some-id`
        ```

        :param str resource_name: The name of the resource.
        :param ServiceSpecificCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceSpecificCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credential_age_days: Optional[pulumi.Input[_builtins.int]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceSpecificCredentialArgs.__new__(ServiceSpecificCredentialArgs)

            __props__.__dict__["credential_age_days"] = credential_age_days
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["status"] = status
            if user_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_name'")
            __props__.__dict__["user_name"] = user_name
            __props__.__dict__["create_date"] = None
            __props__.__dict__["expiration_date"] = None
            __props__.__dict__["service_credential_alias"] = None
            __props__.__dict__["service_credential_secret"] = None
            __props__.__dict__["service_password"] = None
            __props__.__dict__["service_specific_credential_id"] = None
            __props__.__dict__["service_user_name"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["serviceCredentialSecret", "servicePassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ServiceSpecificCredential, __self__).__init__(
            'aws:iam/serviceSpecificCredential:ServiceSpecificCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_date: Optional[pulumi.Input[_builtins.str]] = None,
            credential_age_days: Optional[pulumi.Input[_builtins.int]] = None,
            expiration_date: Optional[pulumi.Input[_builtins.str]] = None,
            service_credential_alias: Optional[pulumi.Input[_builtins.str]] = None,
            service_credential_secret: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            service_password: Optional[pulumi.Input[_builtins.str]] = None,
            service_specific_credential_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_user_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            user_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServiceSpecificCredential':
        """
        Get an existing ServiceSpecificCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_date: The date and time, in RFC3339 format, when the service-specific credential was created.
        :param pulumi.Input[_builtins.int] credential_age_days: The number of days until the service specific credential expires. This field is only valid for Bedrock API keys and must be between 1 and 36600 (approximately 100 years). When not specified, the credential will not expire.
        :param pulumi.Input[_builtins.str] expiration_date: The date and time, in RFC3339 format, when the service specific credential expires. This field is only present for Bedrock API keys that were created with an expiration period.
        :param pulumi.Input[_builtins.str] service_credential_alias: For Bedrock API keys, this is the public portion of the credential that includes the IAM user name and a suffix containing version and creation information.
        :param pulumi.Input[_builtins.str] service_credential_secret: For Bedrock API keys, this is the secret portion of the credential that should be used to authenticate API calls. This value is only available when the credential is created.
        :param pulumi.Input[_builtins.str] service_name: The name of the AWS service that is to be associated with the credentials. The service you specify here is the only service that can be accessed using these credentials. Supported services are `codecommit.amazonaws.com`, `bedrock.amazonaws.com`, and `cassandra.amazonaws.com`.
        :param pulumi.Input[_builtins.str] service_password: The generated password for the service-specific credential. This value is only available when the credential is created.
        :param pulumi.Input[_builtins.str] service_specific_credential_id: The unique identifier for the service-specific credential.
        :param pulumi.Input[_builtins.str] service_user_name: The generated user name for the service-specific credential. This value is generated by combining the IAM user's name combined with the ID number of the AWS account, as in `jane-at-123456789012`, for example.
        :param pulumi.Input[_builtins.str] status: The status to be assigned to the service-specific credential. Valid values are `Active`, `Inactive`, and `Expired`. Default value is `Active`. Note that `Expired` is only used for read operations and cannot be set manually.
        :param pulumi.Input[_builtins.str] user_name: The name of the IAM user that is to be associated with the credentials. The new service-specific credentials have the same permissions as the associated user except that they can be used only to access the specified service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceSpecificCredentialState.__new__(_ServiceSpecificCredentialState)

        __props__.__dict__["create_date"] = create_date
        __props__.__dict__["credential_age_days"] = credential_age_days
        __props__.__dict__["expiration_date"] = expiration_date
        __props__.__dict__["service_credential_alias"] = service_credential_alias
        __props__.__dict__["service_credential_secret"] = service_credential_secret
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["service_password"] = service_password
        __props__.__dict__["service_specific_credential_id"] = service_specific_credential_id
        __props__.__dict__["service_user_name"] = service_user_name
        __props__.__dict__["status"] = status
        __props__.__dict__["user_name"] = user_name
        return ServiceSpecificCredential(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createDate")
    def create_date(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time, in RFC3339 format, when the service-specific credential was created.
        """
        return pulumi.get(self, "create_date")

    @_builtins.property
    @pulumi.getter(name="credentialAgeDays")
    def credential_age_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of days until the service specific credential expires. This field is only valid for Bedrock API keys and must be between 1 and 36600 (approximately 100 years). When not specified, the credential will not expire.
        """
        return pulumi.get(self, "credential_age_days")

    @_builtins.property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time, in RFC3339 format, when the service specific credential expires. This field is only present for Bedrock API keys that were created with an expiration period.
        """
        return pulumi.get(self, "expiration_date")

    @_builtins.property
    @pulumi.getter(name="serviceCredentialAlias")
    def service_credential_alias(self) -> pulumi.Output[_builtins.str]:
        """
        For Bedrock API keys, this is the public portion of the credential that includes the IAM user name and a suffix containing version and creation information.
        """
        return pulumi.get(self, "service_credential_alias")

    @_builtins.property
    @pulumi.getter(name="serviceCredentialSecret")
    def service_credential_secret(self) -> pulumi.Output[_builtins.str]:
        """
        For Bedrock API keys, this is the secret portion of the credential that should be used to authenticate API calls. This value is only available when the credential is created.
        """
        return pulumi.get(self, "service_credential_secret")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the AWS service that is to be associated with the credentials. The service you specify here is the only service that can be accessed using these credentials. Supported services are `codecommit.amazonaws.com`, `bedrock.amazonaws.com`, and `cassandra.amazonaws.com`.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="servicePassword")
    def service_password(self) -> pulumi.Output[_builtins.str]:
        """
        The generated password for the service-specific credential. This value is only available when the credential is created.
        """
        return pulumi.get(self, "service_password")

    @_builtins.property
    @pulumi.getter(name="serviceSpecificCredentialId")
    def service_specific_credential_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier for the service-specific credential.
        """
        return pulumi.get(self, "service_specific_credential_id")

    @_builtins.property
    @pulumi.getter(name="serviceUserName")
    def service_user_name(self) -> pulumi.Output[_builtins.str]:
        """
        The generated user name for the service-specific credential. This value is generated by combining the IAM user's name combined with the ID number of the AWS account, as in `jane-at-123456789012`, for example.
        """
        return pulumi.get(self, "service_user_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The status to be assigned to the service-specific credential. Valid values are `Active`, `Inactive`, and `Expired`. Default value is `Active`. Note that `Expired` is only used for read operations and cannot be set manually.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the IAM user that is to be associated with the credentials. The new service-specific credentials have the same permissions as the associated user except that they can be used only to access the specified service.
        """
        return pulumi.get(self, "user_name")

