# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CustomKeyStoreArgs', 'CustomKeyStore']

@pulumi.input_type
class CustomKeyStoreArgs:
    def __init__(__self__, *,
                 custom_key_store_name: pulumi.Input[_builtins.str],
                 cloud_hsm_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_key_store_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_store_password: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_anchor_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 xks_proxy_authentication_credential: Optional[pulumi.Input['CustomKeyStoreXksProxyAuthenticationCredentialArgs']] = None,
                 xks_proxy_connectivity: Optional[pulumi.Input[_builtins.str]] = None,
                 xks_proxy_uri_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 xks_proxy_uri_path: Optional[pulumi.Input[_builtins.str]] = None,
                 xks_proxy_vpc_endpoint_service_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CustomKeyStore resource.
        :param pulumi.Input[_builtins.str] custom_key_store_name: Unique name for Custom Key Store.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] custom_key_store_type: Specifies the type of key store to create. Valid values are `AWS_CLOUDHSM` and `EXTERNAL_KEY_STORE`. If omitted, AWS will default the value to `AWS_CLOUDHSM`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "custom_key_store_name", custom_key_store_name)
        if cloud_hsm_cluster_id is not None:
            pulumi.set(__self__, "cloud_hsm_cluster_id", cloud_hsm_cluster_id)
        if custom_key_store_type is not None:
            pulumi.set(__self__, "custom_key_store_type", custom_key_store_type)
        if key_store_password is not None:
            pulumi.set(__self__, "key_store_password", key_store_password)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if trust_anchor_certificate is not None:
            pulumi.set(__self__, "trust_anchor_certificate", trust_anchor_certificate)
        if xks_proxy_authentication_credential is not None:
            pulumi.set(__self__, "xks_proxy_authentication_credential", xks_proxy_authentication_credential)
        if xks_proxy_connectivity is not None:
            pulumi.set(__self__, "xks_proxy_connectivity", xks_proxy_connectivity)
        if xks_proxy_uri_endpoint is not None:
            pulumi.set(__self__, "xks_proxy_uri_endpoint", xks_proxy_uri_endpoint)
        if xks_proxy_uri_path is not None:
            pulumi.set(__self__, "xks_proxy_uri_path", xks_proxy_uri_path)
        if xks_proxy_vpc_endpoint_service_name is not None:
            pulumi.set(__self__, "xks_proxy_vpc_endpoint_service_name", xks_proxy_vpc_endpoint_service_name)

    @_builtins.property
    @pulumi.getter(name="customKeyStoreName")
    def custom_key_store_name(self) -> pulumi.Input[_builtins.str]:
        """
        Unique name for Custom Key Store.

        The following arguments are optional:
        """
        return pulumi.get(self, "custom_key_store_name")

    @custom_key_store_name.setter
    def custom_key_store_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "custom_key_store_name", value)

    @_builtins.property
    @pulumi.getter(name="cloudHsmClusterId")
    def cloud_hsm_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cloud_hsm_cluster_id")

    @cloud_hsm_cluster_id.setter
    def cloud_hsm_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_hsm_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="customKeyStoreType")
    def custom_key_store_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of key store to create. Valid values are `AWS_CLOUDHSM` and `EXTERNAL_KEY_STORE`. If omitted, AWS will default the value to `AWS_CLOUDHSM`.
        """
        return pulumi.get(self, "custom_key_store_type")

    @custom_key_store_type.setter
    def custom_key_store_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_key_store_type", value)

    @_builtins.property
    @pulumi.getter(name="keyStorePassword")
    def key_store_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "key_store_password")

    @key_store_password.setter
    def key_store_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_store_password", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="trustAnchorCertificate")
    def trust_anchor_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "trust_anchor_certificate")

    @trust_anchor_certificate.setter
    def trust_anchor_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trust_anchor_certificate", value)

    @_builtins.property
    @pulumi.getter(name="xksProxyAuthenticationCredential")
    def xks_proxy_authentication_credential(self) -> Optional[pulumi.Input['CustomKeyStoreXksProxyAuthenticationCredentialArgs']]:
        return pulumi.get(self, "xks_proxy_authentication_credential")

    @xks_proxy_authentication_credential.setter
    def xks_proxy_authentication_credential(self, value: Optional[pulumi.Input['CustomKeyStoreXksProxyAuthenticationCredentialArgs']]):
        pulumi.set(self, "xks_proxy_authentication_credential", value)

    @_builtins.property
    @pulumi.getter(name="xksProxyConnectivity")
    def xks_proxy_connectivity(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "xks_proxy_connectivity")

    @xks_proxy_connectivity.setter
    def xks_proxy_connectivity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xks_proxy_connectivity", value)

    @_builtins.property
    @pulumi.getter(name="xksProxyUriEndpoint")
    def xks_proxy_uri_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "xks_proxy_uri_endpoint")

    @xks_proxy_uri_endpoint.setter
    def xks_proxy_uri_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xks_proxy_uri_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="xksProxyUriPath")
    def xks_proxy_uri_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "xks_proxy_uri_path")

    @xks_proxy_uri_path.setter
    def xks_proxy_uri_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xks_proxy_uri_path", value)

    @_builtins.property
    @pulumi.getter(name="xksProxyVpcEndpointServiceName")
    def xks_proxy_vpc_endpoint_service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "xks_proxy_vpc_endpoint_service_name")

    @xks_proxy_vpc_endpoint_service_name.setter
    def xks_proxy_vpc_endpoint_service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xks_proxy_vpc_endpoint_service_name", value)


@pulumi.input_type
class _CustomKeyStoreState:
    def __init__(__self__, *,
                 cloud_hsm_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_key_store_name: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_key_store_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_store_password: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_anchor_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 xks_proxy_authentication_credential: Optional[pulumi.Input['CustomKeyStoreXksProxyAuthenticationCredentialArgs']] = None,
                 xks_proxy_connectivity: Optional[pulumi.Input[_builtins.str]] = None,
                 xks_proxy_uri_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 xks_proxy_uri_path: Optional[pulumi.Input[_builtins.str]] = None,
                 xks_proxy_vpc_endpoint_service_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CustomKeyStore resources.
        :param pulumi.Input[_builtins.str] custom_key_store_name: Unique name for Custom Key Store.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] custom_key_store_type: Specifies the type of key store to create. Valid values are `AWS_CLOUDHSM` and `EXTERNAL_KEY_STORE`. If omitted, AWS will default the value to `AWS_CLOUDHSM`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if cloud_hsm_cluster_id is not None:
            pulumi.set(__self__, "cloud_hsm_cluster_id", cloud_hsm_cluster_id)
        if custom_key_store_name is not None:
            pulumi.set(__self__, "custom_key_store_name", custom_key_store_name)
        if custom_key_store_type is not None:
            pulumi.set(__self__, "custom_key_store_type", custom_key_store_type)
        if key_store_password is not None:
            pulumi.set(__self__, "key_store_password", key_store_password)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if trust_anchor_certificate is not None:
            pulumi.set(__self__, "trust_anchor_certificate", trust_anchor_certificate)
        if xks_proxy_authentication_credential is not None:
            pulumi.set(__self__, "xks_proxy_authentication_credential", xks_proxy_authentication_credential)
        if xks_proxy_connectivity is not None:
            pulumi.set(__self__, "xks_proxy_connectivity", xks_proxy_connectivity)
        if xks_proxy_uri_endpoint is not None:
            pulumi.set(__self__, "xks_proxy_uri_endpoint", xks_proxy_uri_endpoint)
        if xks_proxy_uri_path is not None:
            pulumi.set(__self__, "xks_proxy_uri_path", xks_proxy_uri_path)
        if xks_proxy_vpc_endpoint_service_name is not None:
            pulumi.set(__self__, "xks_proxy_vpc_endpoint_service_name", xks_proxy_vpc_endpoint_service_name)

    @_builtins.property
    @pulumi.getter(name="cloudHsmClusterId")
    def cloud_hsm_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cloud_hsm_cluster_id")

    @cloud_hsm_cluster_id.setter
    def cloud_hsm_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_hsm_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="customKeyStoreName")
    def custom_key_store_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique name for Custom Key Store.

        The following arguments are optional:
        """
        return pulumi.get(self, "custom_key_store_name")

    @custom_key_store_name.setter
    def custom_key_store_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_key_store_name", value)

    @_builtins.property
    @pulumi.getter(name="customKeyStoreType")
    def custom_key_store_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of key store to create. Valid values are `AWS_CLOUDHSM` and `EXTERNAL_KEY_STORE`. If omitted, AWS will default the value to `AWS_CLOUDHSM`.
        """
        return pulumi.get(self, "custom_key_store_type")

    @custom_key_store_type.setter
    def custom_key_store_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_key_store_type", value)

    @_builtins.property
    @pulumi.getter(name="keyStorePassword")
    def key_store_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "key_store_password")

    @key_store_password.setter
    def key_store_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_store_password", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="trustAnchorCertificate")
    def trust_anchor_certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "trust_anchor_certificate")

    @trust_anchor_certificate.setter
    def trust_anchor_certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trust_anchor_certificate", value)

    @_builtins.property
    @pulumi.getter(name="xksProxyAuthenticationCredential")
    def xks_proxy_authentication_credential(self) -> Optional[pulumi.Input['CustomKeyStoreXksProxyAuthenticationCredentialArgs']]:
        return pulumi.get(self, "xks_proxy_authentication_credential")

    @xks_proxy_authentication_credential.setter
    def xks_proxy_authentication_credential(self, value: Optional[pulumi.Input['CustomKeyStoreXksProxyAuthenticationCredentialArgs']]):
        pulumi.set(self, "xks_proxy_authentication_credential", value)

    @_builtins.property
    @pulumi.getter(name="xksProxyConnectivity")
    def xks_proxy_connectivity(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "xks_proxy_connectivity")

    @xks_proxy_connectivity.setter
    def xks_proxy_connectivity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xks_proxy_connectivity", value)

    @_builtins.property
    @pulumi.getter(name="xksProxyUriEndpoint")
    def xks_proxy_uri_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "xks_proxy_uri_endpoint")

    @xks_proxy_uri_endpoint.setter
    def xks_proxy_uri_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xks_proxy_uri_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="xksProxyUriPath")
    def xks_proxy_uri_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "xks_proxy_uri_path")

    @xks_proxy_uri_path.setter
    def xks_proxy_uri_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xks_proxy_uri_path", value)

    @_builtins.property
    @pulumi.getter(name="xksProxyVpcEndpointServiceName")
    def xks_proxy_vpc_endpoint_service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "xks_proxy_vpc_endpoint_service_name")

    @xks_proxy_vpc_endpoint_service_name.setter
    def xks_proxy_vpc_endpoint_service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xks_proxy_vpc_endpoint_service_name", value)


@pulumi.type_token("aws:kms/customKeyStore:CustomKeyStore")
class CustomKeyStore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_hsm_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_key_store_name: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_key_store_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_store_password: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_anchor_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 xks_proxy_authentication_credential: Optional[pulumi.Input[Union['CustomKeyStoreXksProxyAuthenticationCredentialArgs', 'CustomKeyStoreXksProxyAuthenticationCredentialArgsDict']]] = None,
                 xks_proxy_connectivity: Optional[pulumi.Input[_builtins.str]] = None,
                 xks_proxy_uri_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 xks_proxy_uri_path: Optional[pulumi.Input[_builtins.str]] = None,
                 xks_proxy_vpc_endpoint_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS KMS (Key Management) Custom Key Store.

        ## Example Usage

        ### CloudHSM

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        test = aws.kms.CustomKeyStore("test",
            cloud_hsm_cluster_id=cloud_hsm_cluster_id,
            custom_key_store_name="kms-custom-key-store-test",
            key_store_password="noplaintextpasswords1",
            trust_anchor_certificate=std.file(input="anchor-certificate.crt").result)
        ```

        ### External Key Store (VPC)

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.CustomKeyStore("example",
            custom_key_store_name="example-vpc-xks",
            custom_key_store_type="EXTERNAL_KEY_STORE",
            xks_proxy_authentication_credential={
                "access_key_id": ephemeral_access_key_id,
                "raw_secret_access_key": ephemeral_secret_access_key,
            },
            xks_proxy_connectivity="VPC_ENDPOINT_SERVICE",
            xks_proxy_uri_endpoint="https://myproxy-private.xks.example.com",
            xks_proxy_uri_path="/kms/xks/v1",
            xks_proxy_vpc_endpoint_service_name="com.amazonaws.vpce.us-east-1.vpce-svc-example")
        ```

        ### External Key Store (Public)

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.CustomKeyStore("example",
            custom_key_store_name="example-public-xks",
            custom_key_store_type="EXTERNAL_KEY_STORE",
            xks_proxy_authentication_credential={
                "access_key_id": ephemeral_access_key_id,
                "raw_secret_access_key": ephemeral_secret_access_key,
            },
            xks_proxy_connectivity="PUBLIC_ENDPOINT",
            xks_proxy_uri_endpoint="https://myproxy.xks.example.com",
            xks_proxy_uri_path="/kms/xks/v1")
        ```

        ## Import

        Using `pulumi import`, import KMS (Key Management) Custom Key Store using the `id`. For example:

        ```sh
        $ pulumi import aws:kms/customKeyStore:CustomKeyStore example cks-5ebd4ef395a96288e
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_key_store_name: Unique name for Custom Key Store.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] custom_key_store_type: Specifies the type of key store to create. Valid values are `AWS_CLOUDHSM` and `EXTERNAL_KEY_STORE`. If omitted, AWS will default the value to `AWS_CLOUDHSM`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomKeyStoreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS KMS (Key Management) Custom Key Store.

        ## Example Usage

        ### CloudHSM

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        test = aws.kms.CustomKeyStore("test",
            cloud_hsm_cluster_id=cloud_hsm_cluster_id,
            custom_key_store_name="kms-custom-key-store-test",
            key_store_password="noplaintextpasswords1",
            trust_anchor_certificate=std.file(input="anchor-certificate.crt").result)
        ```

        ### External Key Store (VPC)

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.CustomKeyStore("example",
            custom_key_store_name="example-vpc-xks",
            custom_key_store_type="EXTERNAL_KEY_STORE",
            xks_proxy_authentication_credential={
                "access_key_id": ephemeral_access_key_id,
                "raw_secret_access_key": ephemeral_secret_access_key,
            },
            xks_proxy_connectivity="VPC_ENDPOINT_SERVICE",
            xks_proxy_uri_endpoint="https://myproxy-private.xks.example.com",
            xks_proxy_uri_path="/kms/xks/v1",
            xks_proxy_vpc_endpoint_service_name="com.amazonaws.vpce.us-east-1.vpce-svc-example")
        ```

        ### External Key Store (Public)

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.CustomKeyStore("example",
            custom_key_store_name="example-public-xks",
            custom_key_store_type="EXTERNAL_KEY_STORE",
            xks_proxy_authentication_credential={
                "access_key_id": ephemeral_access_key_id,
                "raw_secret_access_key": ephemeral_secret_access_key,
            },
            xks_proxy_connectivity="PUBLIC_ENDPOINT",
            xks_proxy_uri_endpoint="https://myproxy.xks.example.com",
            xks_proxy_uri_path="/kms/xks/v1")
        ```

        ## Import

        Using `pulumi import`, import KMS (Key Management) Custom Key Store using the `id`. For example:

        ```sh
        $ pulumi import aws:kms/customKeyStore:CustomKeyStore example cks-5ebd4ef395a96288e
        ```

        :param str resource_name: The name of the resource.
        :param CustomKeyStoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomKeyStoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_hsm_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_key_store_name: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_key_store_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_store_password: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_anchor_certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 xks_proxy_authentication_credential: Optional[pulumi.Input[Union['CustomKeyStoreXksProxyAuthenticationCredentialArgs', 'CustomKeyStoreXksProxyAuthenticationCredentialArgsDict']]] = None,
                 xks_proxy_connectivity: Optional[pulumi.Input[_builtins.str]] = None,
                 xks_proxy_uri_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 xks_proxy_uri_path: Optional[pulumi.Input[_builtins.str]] = None,
                 xks_proxy_vpc_endpoint_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomKeyStoreArgs.__new__(CustomKeyStoreArgs)

            __props__.__dict__["cloud_hsm_cluster_id"] = cloud_hsm_cluster_id
            if custom_key_store_name is None and not opts.urn:
                raise TypeError("Missing required property 'custom_key_store_name'")
            __props__.__dict__["custom_key_store_name"] = custom_key_store_name
            __props__.__dict__["custom_key_store_type"] = custom_key_store_type
            __props__.__dict__["key_store_password"] = key_store_password
            __props__.__dict__["region"] = region
            __props__.__dict__["trust_anchor_certificate"] = trust_anchor_certificate
            __props__.__dict__["xks_proxy_authentication_credential"] = xks_proxy_authentication_credential
            __props__.__dict__["xks_proxy_connectivity"] = xks_proxy_connectivity
            __props__.__dict__["xks_proxy_uri_endpoint"] = xks_proxy_uri_endpoint
            __props__.__dict__["xks_proxy_uri_path"] = xks_proxy_uri_path
            __props__.__dict__["xks_proxy_vpc_endpoint_service_name"] = xks_proxy_vpc_endpoint_service_name
        super(CustomKeyStore, __self__).__init__(
            'aws:kms/customKeyStore:CustomKeyStore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_hsm_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            custom_key_store_name: Optional[pulumi.Input[_builtins.str]] = None,
            custom_key_store_type: Optional[pulumi.Input[_builtins.str]] = None,
            key_store_password: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            trust_anchor_certificate: Optional[pulumi.Input[_builtins.str]] = None,
            xks_proxy_authentication_credential: Optional[pulumi.Input[Union['CustomKeyStoreXksProxyAuthenticationCredentialArgs', 'CustomKeyStoreXksProxyAuthenticationCredentialArgsDict']]] = None,
            xks_proxy_connectivity: Optional[pulumi.Input[_builtins.str]] = None,
            xks_proxy_uri_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            xks_proxy_uri_path: Optional[pulumi.Input[_builtins.str]] = None,
            xks_proxy_vpc_endpoint_service_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'CustomKeyStore':
        """
        Get an existing CustomKeyStore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_key_store_name: Unique name for Custom Key Store.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] custom_key_store_type: Specifies the type of key store to create. Valid values are `AWS_CLOUDHSM` and `EXTERNAL_KEY_STORE`. If omitted, AWS will default the value to `AWS_CLOUDHSM`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomKeyStoreState.__new__(_CustomKeyStoreState)

        __props__.__dict__["cloud_hsm_cluster_id"] = cloud_hsm_cluster_id
        __props__.__dict__["custom_key_store_name"] = custom_key_store_name
        __props__.__dict__["custom_key_store_type"] = custom_key_store_type
        __props__.__dict__["key_store_password"] = key_store_password
        __props__.__dict__["region"] = region
        __props__.__dict__["trust_anchor_certificate"] = trust_anchor_certificate
        __props__.__dict__["xks_proxy_authentication_credential"] = xks_proxy_authentication_credential
        __props__.__dict__["xks_proxy_connectivity"] = xks_proxy_connectivity
        __props__.__dict__["xks_proxy_uri_endpoint"] = xks_proxy_uri_endpoint
        __props__.__dict__["xks_proxy_uri_path"] = xks_proxy_uri_path
        __props__.__dict__["xks_proxy_vpc_endpoint_service_name"] = xks_proxy_vpc_endpoint_service_name
        return CustomKeyStore(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cloudHsmClusterId")
    def cloud_hsm_cluster_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "cloud_hsm_cluster_id")

    @_builtins.property
    @pulumi.getter(name="customKeyStoreName")
    def custom_key_store_name(self) -> pulumi.Output[_builtins.str]:
        """
        Unique name for Custom Key Store.

        The following arguments are optional:
        """
        return pulumi.get(self, "custom_key_store_name")

    @_builtins.property
    @pulumi.getter(name="customKeyStoreType")
    def custom_key_store_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the type of key store to create. Valid values are `AWS_CLOUDHSM` and `EXTERNAL_KEY_STORE`. If omitted, AWS will default the value to `AWS_CLOUDHSM`.
        """
        return pulumi.get(self, "custom_key_store_type")

    @_builtins.property
    @pulumi.getter(name="keyStorePassword")
    def key_store_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "key_store_password")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="trustAnchorCertificate")
    def trust_anchor_certificate(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "trust_anchor_certificate")

    @_builtins.property
    @pulumi.getter(name="xksProxyAuthenticationCredential")
    def xks_proxy_authentication_credential(self) -> pulumi.Output[Optional['outputs.CustomKeyStoreXksProxyAuthenticationCredential']]:
        return pulumi.get(self, "xks_proxy_authentication_credential")

    @_builtins.property
    @pulumi.getter(name="xksProxyConnectivity")
    def xks_proxy_connectivity(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "xks_proxy_connectivity")

    @_builtins.property
    @pulumi.getter(name="xksProxyUriEndpoint")
    def xks_proxy_uri_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "xks_proxy_uri_endpoint")

    @_builtins.property
    @pulumi.getter(name="xksProxyUriPath")
    def xks_proxy_uri_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "xks_proxy_uri_path")

    @_builtins.property
    @pulumi.getter(name="xksProxyVpcEndpointServiceName")
    def xks_proxy_vpc_endpoint_service_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "xks_proxy_vpc_endpoint_service_name")

