# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PermissionsArgs', 'Permissions']

@pulumi.input_type
class PermissionsArgs:
    def __init__(__self__, *,
                 permissions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 principal: pulumi.Input[_builtins.str],
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 catalog_resource: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_cells_filter: Optional[pulumi.Input['PermissionsDataCellsFilterArgs']] = None,
                 data_location: Optional[pulumi.Input['PermissionsDataLocationArgs']] = None,
                 database: Optional[pulumi.Input['PermissionsDatabaseArgs']] = None,
                 lf_tag: Optional[pulumi.Input['PermissionsLfTagArgs']] = None,
                 lf_tag_policy: Optional[pulumi.Input['PermissionsLfTagPolicyArgs']] = None,
                 permissions_with_grant_options: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 table: Optional[pulumi.Input['PermissionsTableArgs']] = None,
                 table_with_columns: Optional[pulumi.Input['PermissionsTableWithColumnsArgs']] = None):
        """
        The set of arguments for constructing a Permissions resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permissions: List of permissions granted to the principal. Valid values may include `ALL`, `ALTER`, `ASSOCIATE`, `CREATE_DATABASE`, `CREATE_TABLE`, `DATA_LOCATION_ACCESS`, `DELETE`, `DESCRIBE`, `DROP`, `INSERT`, and `SELECT`. For details on each permission, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
        :param pulumi.Input[_builtins.str] principal: Principal to be granted the permissions on the resource. Supported principals include `IAM_ALLOWED_PRINCIPALS` (see Default Behavior and `IAMAllowedPrincipals` above), IAM roles, users, groups, Federated Users, SAML groups and users, QuickSight groups, OUs, and organizations as well as AWS account IDs for cross-account permissions. For more information, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
               
               > **NOTE:** We highly recommend that the `principal` _NOT_ be a Lake Formation administrator (granted using `lakeformation.DataLakeSettings`). The entity (e.g., IAM role) running the deployment will most likely need to be a Lake Formation administrator. As such, the entity will have implicit permissions and does not need permissions granted through this resource.
               
               One of the following is required:
        :param pulumi.Input[_builtins.str] catalog_id: Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
        :param pulumi.Input[_builtins.bool] catalog_resource: Whether the permissions are to be granted for the Data Catalog. Defaults to `false`.
        :param pulumi.Input['PermissionsDataCellsFilterArgs'] data_cells_filter: Configuration block for a data cells filter resource. Detailed below.
        :param pulumi.Input['PermissionsDataLocationArgs'] data_location: Configuration block for a data location resource. Detailed below.
        :param pulumi.Input['PermissionsDatabaseArgs'] database: Configuration block for a database resource. Detailed below.
        :param pulumi.Input['PermissionsLfTagArgs'] lf_tag: Configuration block for an LF-tag resource. Detailed below.
        :param pulumi.Input['PermissionsLfTagPolicyArgs'] lf_tag_policy: Configuration block for an LF-tag policy resource. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permissions_with_grant_options: Subset of `permissions` which the principal can pass.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['PermissionsTableArgs'] table: Configuration block for a table resource. Detailed below.
        :param pulumi.Input['PermissionsTableWithColumnsArgs'] table_with_columns: Configuration block for a table with columns resource. Detailed below.
               
               The following arguments are optional:
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "principal", principal)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if catalog_resource is not None:
            pulumi.set(__self__, "catalog_resource", catalog_resource)
        if data_cells_filter is not None:
            pulumi.set(__self__, "data_cells_filter", data_cells_filter)
        if data_location is not None:
            pulumi.set(__self__, "data_location", data_location)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if lf_tag is not None:
            pulumi.set(__self__, "lf_tag", lf_tag)
        if lf_tag_policy is not None:
            pulumi.set(__self__, "lf_tag_policy", lf_tag_policy)
        if permissions_with_grant_options is not None:
            pulumi.set(__self__, "permissions_with_grant_options", permissions_with_grant_options)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if table_with_columns is not None:
            pulumi.set(__self__, "table_with_columns", table_with_columns)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of permissions granted to the principal. Valid values may include `ALL`, `ALTER`, `ASSOCIATE`, `CREATE_DATABASE`, `CREATE_TABLE`, `DATA_LOCATION_ACCESS`, `DELETE`, `DESCRIBE`, `DROP`, `INSERT`, and `SELECT`. For details on each permission, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter
    def principal(self) -> pulumi.Input[_builtins.str]:
        """
        Principal to be granted the permissions on the resource. Supported principals include `IAM_ALLOWED_PRINCIPALS` (see Default Behavior and `IAMAllowedPrincipals` above), IAM roles, users, groups, Federated Users, SAML groups and users, QuickSight groups, OUs, and organizations as well as AWS account IDs for cross-account permissions. For more information, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).

        > **NOTE:** We highly recommend that the `principal` _NOT_ be a Lake Formation administrator (granted using `lakeformation.DataLakeSettings`). The entity (e.g., IAM role) running the deployment will most likely need to be a Lake Formation administrator. As such, the entity will have implicit permissions and does not need permissions granted through this resource.

        One of the following is required:
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "principal", value)

    @_builtins.property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "catalog_id", value)

    @_builtins.property
    @pulumi.getter(name="catalogResource")
    def catalog_resource(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the permissions are to be granted for the Data Catalog. Defaults to `false`.
        """
        return pulumi.get(self, "catalog_resource")

    @catalog_resource.setter
    def catalog_resource(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "catalog_resource", value)

    @_builtins.property
    @pulumi.getter(name="dataCellsFilter")
    def data_cells_filter(self) -> Optional[pulumi.Input['PermissionsDataCellsFilterArgs']]:
        """
        Configuration block for a data cells filter resource. Detailed below.
        """
        return pulumi.get(self, "data_cells_filter")

    @data_cells_filter.setter
    def data_cells_filter(self, value: Optional[pulumi.Input['PermissionsDataCellsFilterArgs']]):
        pulumi.set(self, "data_cells_filter", value)

    @_builtins.property
    @pulumi.getter(name="dataLocation")
    def data_location(self) -> Optional[pulumi.Input['PermissionsDataLocationArgs']]:
        """
        Configuration block for a data location resource. Detailed below.
        """
        return pulumi.get(self, "data_location")

    @data_location.setter
    def data_location(self, value: Optional[pulumi.Input['PermissionsDataLocationArgs']]):
        pulumi.set(self, "data_location", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input['PermissionsDatabaseArgs']]:
        """
        Configuration block for a database resource. Detailed below.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input['PermissionsDatabaseArgs']]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="lfTag")
    def lf_tag(self) -> Optional[pulumi.Input['PermissionsLfTagArgs']]:
        """
        Configuration block for an LF-tag resource. Detailed below.
        """
        return pulumi.get(self, "lf_tag")

    @lf_tag.setter
    def lf_tag(self, value: Optional[pulumi.Input['PermissionsLfTagArgs']]):
        pulumi.set(self, "lf_tag", value)

    @_builtins.property
    @pulumi.getter(name="lfTagPolicy")
    def lf_tag_policy(self) -> Optional[pulumi.Input['PermissionsLfTagPolicyArgs']]:
        """
        Configuration block for an LF-tag policy resource. Detailed below.
        """
        return pulumi.get(self, "lf_tag_policy")

    @lf_tag_policy.setter
    def lf_tag_policy(self, value: Optional[pulumi.Input['PermissionsLfTagPolicyArgs']]):
        pulumi.set(self, "lf_tag_policy", value)

    @_builtins.property
    @pulumi.getter(name="permissionsWithGrantOptions")
    def permissions_with_grant_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Subset of `permissions` which the principal can pass.
        """
        return pulumi.get(self, "permissions_with_grant_options")

    @permissions_with_grant_options.setter
    def permissions_with_grant_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "permissions_with_grant_options", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input['PermissionsTableArgs']]:
        """
        Configuration block for a table resource. Detailed below.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input['PermissionsTableArgs']]):
        pulumi.set(self, "table", value)

    @_builtins.property
    @pulumi.getter(name="tableWithColumns")
    def table_with_columns(self) -> Optional[pulumi.Input['PermissionsTableWithColumnsArgs']]:
        """
        Configuration block for a table with columns resource. Detailed below.

        The following arguments are optional:
        """
        return pulumi.get(self, "table_with_columns")

    @table_with_columns.setter
    def table_with_columns(self, value: Optional[pulumi.Input['PermissionsTableWithColumnsArgs']]):
        pulumi.set(self, "table_with_columns", value)


@pulumi.input_type
class _PermissionsState:
    def __init__(__self__, *,
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 catalog_resource: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_cells_filter: Optional[pulumi.Input['PermissionsDataCellsFilterArgs']] = None,
                 data_location: Optional[pulumi.Input['PermissionsDataLocationArgs']] = None,
                 database: Optional[pulumi.Input['PermissionsDatabaseArgs']] = None,
                 lf_tag: Optional[pulumi.Input['PermissionsLfTagArgs']] = None,
                 lf_tag_policy: Optional[pulumi.Input['PermissionsLfTagPolicyArgs']] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 permissions_with_grant_options: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 table: Optional[pulumi.Input['PermissionsTableArgs']] = None,
                 table_with_columns: Optional[pulumi.Input['PermissionsTableWithColumnsArgs']] = None):
        """
        Input properties used for looking up and filtering Permissions resources.
        :param pulumi.Input[_builtins.str] catalog_id: Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
        :param pulumi.Input[_builtins.bool] catalog_resource: Whether the permissions are to be granted for the Data Catalog. Defaults to `false`.
        :param pulumi.Input['PermissionsDataCellsFilterArgs'] data_cells_filter: Configuration block for a data cells filter resource. Detailed below.
        :param pulumi.Input['PermissionsDataLocationArgs'] data_location: Configuration block for a data location resource. Detailed below.
        :param pulumi.Input['PermissionsDatabaseArgs'] database: Configuration block for a database resource. Detailed below.
        :param pulumi.Input['PermissionsLfTagArgs'] lf_tag: Configuration block for an LF-tag resource. Detailed below.
        :param pulumi.Input['PermissionsLfTagPolicyArgs'] lf_tag_policy: Configuration block for an LF-tag policy resource. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permissions: List of permissions granted to the principal. Valid values may include `ALL`, `ALTER`, `ASSOCIATE`, `CREATE_DATABASE`, `CREATE_TABLE`, `DATA_LOCATION_ACCESS`, `DELETE`, `DESCRIBE`, `DROP`, `INSERT`, and `SELECT`. For details on each permission, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permissions_with_grant_options: Subset of `permissions` which the principal can pass.
        :param pulumi.Input[_builtins.str] principal: Principal to be granted the permissions on the resource. Supported principals include `IAM_ALLOWED_PRINCIPALS` (see Default Behavior and `IAMAllowedPrincipals` above), IAM roles, users, groups, Federated Users, SAML groups and users, QuickSight groups, OUs, and organizations as well as AWS account IDs for cross-account permissions. For more information, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
               
               > **NOTE:** We highly recommend that the `principal` _NOT_ be a Lake Formation administrator (granted using `lakeformation.DataLakeSettings`). The entity (e.g., IAM role) running the deployment will most likely need to be a Lake Formation administrator. As such, the entity will have implicit permissions and does not need permissions granted through this resource.
               
               One of the following is required:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['PermissionsTableArgs'] table: Configuration block for a table resource. Detailed below.
        :param pulumi.Input['PermissionsTableWithColumnsArgs'] table_with_columns: Configuration block for a table with columns resource. Detailed below.
               
               The following arguments are optional:
        """
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if catalog_resource is not None:
            pulumi.set(__self__, "catalog_resource", catalog_resource)
        if data_cells_filter is not None:
            pulumi.set(__self__, "data_cells_filter", data_cells_filter)
        if data_location is not None:
            pulumi.set(__self__, "data_location", data_location)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if lf_tag is not None:
            pulumi.set(__self__, "lf_tag", lf_tag)
        if lf_tag_policy is not None:
            pulumi.set(__self__, "lf_tag_policy", lf_tag_policy)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if permissions_with_grant_options is not None:
            pulumi.set(__self__, "permissions_with_grant_options", permissions_with_grant_options)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if table is not None:
            pulumi.set(__self__, "table", table)
        if table_with_columns is not None:
            pulumi.set(__self__, "table_with_columns", table_with_columns)

    @_builtins.property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "catalog_id", value)

    @_builtins.property
    @pulumi.getter(name="catalogResource")
    def catalog_resource(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the permissions are to be granted for the Data Catalog. Defaults to `false`.
        """
        return pulumi.get(self, "catalog_resource")

    @catalog_resource.setter
    def catalog_resource(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "catalog_resource", value)

    @_builtins.property
    @pulumi.getter(name="dataCellsFilter")
    def data_cells_filter(self) -> Optional[pulumi.Input['PermissionsDataCellsFilterArgs']]:
        """
        Configuration block for a data cells filter resource. Detailed below.
        """
        return pulumi.get(self, "data_cells_filter")

    @data_cells_filter.setter
    def data_cells_filter(self, value: Optional[pulumi.Input['PermissionsDataCellsFilterArgs']]):
        pulumi.set(self, "data_cells_filter", value)

    @_builtins.property
    @pulumi.getter(name="dataLocation")
    def data_location(self) -> Optional[pulumi.Input['PermissionsDataLocationArgs']]:
        """
        Configuration block for a data location resource. Detailed below.
        """
        return pulumi.get(self, "data_location")

    @data_location.setter
    def data_location(self, value: Optional[pulumi.Input['PermissionsDataLocationArgs']]):
        pulumi.set(self, "data_location", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input['PermissionsDatabaseArgs']]:
        """
        Configuration block for a database resource. Detailed below.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input['PermissionsDatabaseArgs']]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter(name="lfTag")
    def lf_tag(self) -> Optional[pulumi.Input['PermissionsLfTagArgs']]:
        """
        Configuration block for an LF-tag resource. Detailed below.
        """
        return pulumi.get(self, "lf_tag")

    @lf_tag.setter
    def lf_tag(self, value: Optional[pulumi.Input['PermissionsLfTagArgs']]):
        pulumi.set(self, "lf_tag", value)

    @_builtins.property
    @pulumi.getter(name="lfTagPolicy")
    def lf_tag_policy(self) -> Optional[pulumi.Input['PermissionsLfTagPolicyArgs']]:
        """
        Configuration block for an LF-tag policy resource. Detailed below.
        """
        return pulumi.get(self, "lf_tag_policy")

    @lf_tag_policy.setter
    def lf_tag_policy(self, value: Optional[pulumi.Input['PermissionsLfTagPolicyArgs']]):
        pulumi.set(self, "lf_tag_policy", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of permissions granted to the principal. Valid values may include `ALL`, `ALTER`, `ASSOCIATE`, `CREATE_DATABASE`, `CREATE_TABLE`, `DATA_LOCATION_ACCESS`, `DELETE`, `DESCRIBE`, `DROP`, `INSERT`, and `SELECT`. For details on each permission, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter(name="permissionsWithGrantOptions")
    def permissions_with_grant_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Subset of `permissions` which the principal can pass.
        """
        return pulumi.get(self, "permissions_with_grant_options")

    @permissions_with_grant_options.setter
    def permissions_with_grant_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "permissions_with_grant_options", value)

    @_builtins.property
    @pulumi.getter
    def principal(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Principal to be granted the permissions on the resource. Supported principals include `IAM_ALLOWED_PRINCIPALS` (see Default Behavior and `IAMAllowedPrincipals` above), IAM roles, users, groups, Federated Users, SAML groups and users, QuickSight groups, OUs, and organizations as well as AWS account IDs for cross-account permissions. For more information, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).

        > **NOTE:** We highly recommend that the `principal` _NOT_ be a Lake Formation administrator (granted using `lakeformation.DataLakeSettings`). The entity (e.g., IAM role) running the deployment will most likely need to be a Lake Formation administrator. As such, the entity will have implicit permissions and does not need permissions granted through this resource.

        One of the following is required:
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input['PermissionsTableArgs']]:
        """
        Configuration block for a table resource. Detailed below.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input['PermissionsTableArgs']]):
        pulumi.set(self, "table", value)

    @_builtins.property
    @pulumi.getter(name="tableWithColumns")
    def table_with_columns(self) -> Optional[pulumi.Input['PermissionsTableWithColumnsArgs']]:
        """
        Configuration block for a table with columns resource. Detailed below.

        The following arguments are optional:
        """
        return pulumi.get(self, "table_with_columns")

    @table_with_columns.setter
    def table_with_columns(self, value: Optional[pulumi.Input['PermissionsTableWithColumnsArgs']]):
        pulumi.set(self, "table_with_columns", value)


@pulumi.type_token("aws:lakeformation/permissions:Permissions")
class Permissions(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 catalog_resource: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_cells_filter: Optional[pulumi.Input[Union['PermissionsDataCellsFilterArgs', 'PermissionsDataCellsFilterArgsDict']]] = None,
                 data_location: Optional[pulumi.Input[Union['PermissionsDataLocationArgs', 'PermissionsDataLocationArgsDict']]] = None,
                 database: Optional[pulumi.Input[Union['PermissionsDatabaseArgs', 'PermissionsDatabaseArgsDict']]] = None,
                 lf_tag: Optional[pulumi.Input[Union['PermissionsLfTagArgs', 'PermissionsLfTagArgsDict']]] = None,
                 lf_tag_policy: Optional[pulumi.Input[Union['PermissionsLfTagPolicyArgs', 'PermissionsLfTagPolicyArgsDict']]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 permissions_with_grant_options: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 table: Optional[pulumi.Input[Union['PermissionsTableArgs', 'PermissionsTableArgsDict']]] = None,
                 table_with_columns: Optional[pulumi.Input[Union['PermissionsTableWithColumnsArgs', 'PermissionsTableWithColumnsArgsDict']]] = None,
                 __props__=None):
        """
        Grants permissions to the principal to access metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3. Permissions are granted to a principal, in a Data Catalog, relative to a Lake Formation resource, which includes the Data Catalog, databases, tables, LF-tags, and LF-tag policies. For more information, see [Security and Access Control to Metadata and Data in Lake Formation](https://docs.aws.amazon.com/lake-formation/latest/dg/security-data-access.html).

        !> **WARNING:** Lake Formation permissions are not in effect by default within AWS. Using this resource will not secure your data and will result in errors if you do not change the security settings for existing resources and the default security settings for new resources. See Default Behavior and `IAMAllowedPrincipals` for additional details.

        > **NOTE:** In general, the `principal` should _NOT_ be a Lake Formation administrator or the entity (e.g., IAM role) that is running the deployment. Administrators have implicit permissions. These should be managed by granting or not granting administrator rights using `lakeformation.DataLakeSettings`, _not_ with this resource.

        ## Default Behavior and `IAMAllowedPrincipals`

        **_Lake Formation permissions are not in effect by default within AWS._** `IAMAllowedPrincipals` (i.e., `IAM_ALLOWED_PRINCIPALS`) conflicts with individual Lake Formation permissions (i.e., non-`IAMAllowedPrincipals` permissions), will cause unexpected behavior, and may result in errors.

        When using Lake Formation, choose ONE of the following options as they are mutually exclusive:

        1. Use this resource (`lakeformation.Permissions`), change the default security settings using `lakeformation.DataLakeSettings`, and remove existing `IAMAllowedPrincipals` permissions
        2. Use `IAMAllowedPrincipals` without `lakeformation.Permissions`

        This example shows removing the `IAMAllowedPrincipals` default security settings and making the caller a Lake Formation admin. Since `create_database_default_permissions` and `create_table_default_permissions` are not set in the `lakeformation.DataLakeSettings` resource, they are cleared.

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        current_get_session_context = aws.iam.get_session_context(arn=current.arn)
        test = aws.lakeformation.DataLakeSettings("test", admins=[current_get_session_context.issuer_arn])
        ```

        To remove existing `IAMAllowedPrincipals` permissions, use the [AWS Lake Formation Console](https://console.aws.amazon.com/lakeformation/) or [AWS CLI](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lakeformation/batch-revoke-permissions.html).

        `IAMAllowedPrincipals` is a hook to maintain backwards compatibility with AWS Glue. `IAMAllowedPrincipals` is a pseudo-entity group that acts like a Lake Formation principal. The group includes any IAM users and roles that are allowed access to your Data Catalog resources by your IAM policies.

        This is Lake Formation's default behavior:

        * Lake Formation grants `Super` permission to `IAMAllowedPrincipals` on all existing AWS Glue Data Catalog resources.
        * Lake Formation enables "Use only IAM access control" for new Data Catalog resources.

        For more details, see [Changing the Default Security Settings for Your Data Lake](https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html).

        ### Problem Using `IAMAllowedPrincipals`

        AWS does not support combining `IAMAllowedPrincipals` permissions and non-`IAMAllowedPrincipals` permissions. Doing so results in unexpected permissions and behaviors. For example, this configuration grants a user `SELECT` on a column in a table.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.CatalogDatabase("example", name="sadabate")
        example_catalog_table = aws.glue.CatalogTable("example",
            name="abelt",
            database_name=test["name"],
            storage_descriptor={
                "columns": [{
                    "name": "event",
                    "type": "string",
                }],
            })
        example_permissions = aws.lakeformation.Permissions("example",
            permissions=["SELECT"],
            principal="arn:aws:iam:us-east-1:123456789012:user/SanHolo",
            table_with_columns={
                "database_name": example_catalog_table.database_name,
                "name": example_catalog_table.name,
                "column_names": ["event"],
            })
        ```

        The resulting permissions depend on whether the table had `IAMAllowedPrincipals` (IAP) permissions or not.

        | Result With IAP | Result Without IAP |
        | ---- | ---- |
        | `SELECT` column wildcard (i.e., all columns) | `SELECT` on `"event"` (as expected) |

        ## `ALLIAMPrincipals` group

        AllIAMPrincipals is a pseudo-entity group that acts like a Lake Formation principal. The group includes all IAMs in the account that is defined.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lakeformation.Permissions("example",
            permissions=["SELECT"],
            principal="123456789012:IAMPrincipals",
            table_with_columns={
                "database_name": example_aws_glue_catalog_table["databaseName"],
                "name": example_aws_glue_catalog_table["name"],
                "column_names": ["event"],
            })
        ```

        ## Using Lake Formation Permissions

        Lake Formation grants implicit permissions to data lake administrators, database creators, and table creators. These implicit permissions cannot be revoked _per se_. If this resource reads implicit permissions, it will attempt to revoke them, which causes an error when the resource is destroyed.

        There are two ways to avoid these errors. First, and the way we recommend, is to avoid using this resource with principals that have implicit permissions. A second, error-prone option, is to grant explicit permissions (and `permissions_with_grant_option`) to "overwrite" a principal's implicit permissions, which you can then revoke with this resource. For more information, see [Implicit Lake Formation Permissions](https://docs.aws.amazon.com/lake-formation/latest/dg/implicit-permissions.html).

        If the `principal` is also a data lake administrator, AWS grants implicit permissions that can cause errors using this resource. For example, AWS implicitly grants a `principal`/administrator `permissions` and `permissions_with_grant_option` of `ALL`, `ALTER`, `DELETE`, `DESCRIBE`, `DROP`, `INSERT`, and `SELECT` on a table. If you use this resource to explicitly grant the `principal`/administrator `permissions` but _not_ `permissions_with_grant_option` of `ALL`, `ALTER`, `DELETE`, `DESCRIBE`, `DROP`, `INSERT`, and `SELECT` on the table, this resource will read the implicit `permissions_with_grant_option` and attempt to revoke them when the resource is destroyed. Doing so will cause an `InvalidInputException: No permissions revoked` error because you cannot revoke implicit permissions _per se_. To workaround this problem, explicitly grant the `principal`/administrator `permissions` _and_ `permissions_with_grant_option`, which can then be revoked. Similarly, granting a `principal`/administrator permissions on a table with columns and providing `column_names`, will result in a `InvalidInputException: Permissions modification is invalid` error because you are narrowing the implicit permissions. Instead, set `wildcard` to `true` and remove the `column_names`.

        ## Example Usage

        ### Grant Permissions For A Lake Formation S3 Resource

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lakeformation.Permissions("example",
            principal=workflow_role["arn"],
            permissions=["DATA_LOCATION_ACCESS"],
            data_location={
                "arn": example_aws_lakeformation_resource["arn"],
            })
        ```

        ### Grant Permissions For A Glue Catalog Database

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lakeformation.Permissions("example",
            principal=workflow_role["arn"],
            permissions=[
                "CREATE_TABLE",
                "ALTER",
                "DROP",
            ],
            database={
                "name": example_aws_glue_catalog_database["name"],
                "catalog_id": "110376042874",
            })
        ```

        ### Grant Permissions Using Tag-Based Access Control

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.lakeformation.Permissions("test",
            principal=sales_role["arn"],
            permissions=[
                "CREATE_TABLE",
                "ALTER",
                "DROP",
            ],
            lf_tag_policy={
                "resource_type": "DATABASE",
                "expressions": [
                    {
                        "key": "Team",
                        "values": ["Sales"],
                    },
                    {
                        "key": "Environment",
                        "values": [
                            "Dev",
                            "Production",
                        ],
                    },
                ],
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] catalog_id: Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
        :param pulumi.Input[_builtins.bool] catalog_resource: Whether the permissions are to be granted for the Data Catalog. Defaults to `false`.
        :param pulumi.Input[Union['PermissionsDataCellsFilterArgs', 'PermissionsDataCellsFilterArgsDict']] data_cells_filter: Configuration block for a data cells filter resource. Detailed below.
        :param pulumi.Input[Union['PermissionsDataLocationArgs', 'PermissionsDataLocationArgsDict']] data_location: Configuration block for a data location resource. Detailed below.
        :param pulumi.Input[Union['PermissionsDatabaseArgs', 'PermissionsDatabaseArgsDict']] database: Configuration block for a database resource. Detailed below.
        :param pulumi.Input[Union['PermissionsLfTagArgs', 'PermissionsLfTagArgsDict']] lf_tag: Configuration block for an LF-tag resource. Detailed below.
        :param pulumi.Input[Union['PermissionsLfTagPolicyArgs', 'PermissionsLfTagPolicyArgsDict']] lf_tag_policy: Configuration block for an LF-tag policy resource. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permissions: List of permissions granted to the principal. Valid values may include `ALL`, `ALTER`, `ASSOCIATE`, `CREATE_DATABASE`, `CREATE_TABLE`, `DATA_LOCATION_ACCESS`, `DELETE`, `DESCRIBE`, `DROP`, `INSERT`, and `SELECT`. For details on each permission, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permissions_with_grant_options: Subset of `permissions` which the principal can pass.
        :param pulumi.Input[_builtins.str] principal: Principal to be granted the permissions on the resource. Supported principals include `IAM_ALLOWED_PRINCIPALS` (see Default Behavior and `IAMAllowedPrincipals` above), IAM roles, users, groups, Federated Users, SAML groups and users, QuickSight groups, OUs, and organizations as well as AWS account IDs for cross-account permissions. For more information, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
               
               > **NOTE:** We highly recommend that the `principal` _NOT_ be a Lake Formation administrator (granted using `lakeformation.DataLakeSettings`). The entity (e.g., IAM role) running the deployment will most likely need to be a Lake Formation administrator. As such, the entity will have implicit permissions and does not need permissions granted through this resource.
               
               One of the following is required:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['PermissionsTableArgs', 'PermissionsTableArgsDict']] table: Configuration block for a table resource. Detailed below.
        :param pulumi.Input[Union['PermissionsTableWithColumnsArgs', 'PermissionsTableWithColumnsArgsDict']] table_with_columns: Configuration block for a table with columns resource. Detailed below.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PermissionsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Grants permissions to the principal to access metadata in the Data Catalog and data organized in underlying data storage such as Amazon S3. Permissions are granted to a principal, in a Data Catalog, relative to a Lake Formation resource, which includes the Data Catalog, databases, tables, LF-tags, and LF-tag policies. For more information, see [Security and Access Control to Metadata and Data in Lake Formation](https://docs.aws.amazon.com/lake-formation/latest/dg/security-data-access.html).

        !> **WARNING:** Lake Formation permissions are not in effect by default within AWS. Using this resource will not secure your data and will result in errors if you do not change the security settings for existing resources and the default security settings for new resources. See Default Behavior and `IAMAllowedPrincipals` for additional details.

        > **NOTE:** In general, the `principal` should _NOT_ be a Lake Formation administrator or the entity (e.g., IAM role) that is running the deployment. Administrators have implicit permissions. These should be managed by granting or not granting administrator rights using `lakeformation.DataLakeSettings`, _not_ with this resource.

        ## Default Behavior and `IAMAllowedPrincipals`

        **_Lake Formation permissions are not in effect by default within AWS._** `IAMAllowedPrincipals` (i.e., `IAM_ALLOWED_PRINCIPALS`) conflicts with individual Lake Formation permissions (i.e., non-`IAMAllowedPrincipals` permissions), will cause unexpected behavior, and may result in errors.

        When using Lake Formation, choose ONE of the following options as they are mutually exclusive:

        1. Use this resource (`lakeformation.Permissions`), change the default security settings using `lakeformation.DataLakeSettings`, and remove existing `IAMAllowedPrincipals` permissions
        2. Use `IAMAllowedPrincipals` without `lakeformation.Permissions`

        This example shows removing the `IAMAllowedPrincipals` default security settings and making the caller a Lake Formation admin. Since `create_database_default_permissions` and `create_table_default_permissions` are not set in the `lakeformation.DataLakeSettings` resource, they are cleared.

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        current_get_session_context = aws.iam.get_session_context(arn=current.arn)
        test = aws.lakeformation.DataLakeSettings("test", admins=[current_get_session_context.issuer_arn])
        ```

        To remove existing `IAMAllowedPrincipals` permissions, use the [AWS Lake Formation Console](https://console.aws.amazon.com/lakeformation/) or [AWS CLI](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lakeformation/batch-revoke-permissions.html).

        `IAMAllowedPrincipals` is a hook to maintain backwards compatibility with AWS Glue. `IAMAllowedPrincipals` is a pseudo-entity group that acts like a Lake Formation principal. The group includes any IAM users and roles that are allowed access to your Data Catalog resources by your IAM policies.

        This is Lake Formation's default behavior:

        * Lake Formation grants `Super` permission to `IAMAllowedPrincipals` on all existing AWS Glue Data Catalog resources.
        * Lake Formation enables "Use only IAM access control" for new Data Catalog resources.

        For more details, see [Changing the Default Security Settings for Your Data Lake](https://docs.aws.amazon.com/lake-formation/latest/dg/change-settings.html).

        ### Problem Using `IAMAllowedPrincipals`

        AWS does not support combining `IAMAllowedPrincipals` permissions and non-`IAMAllowedPrincipals` permissions. Doing so results in unexpected permissions and behaviors. For example, this configuration grants a user `SELECT` on a column in a table.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.glue.CatalogDatabase("example", name="sadabate")
        example_catalog_table = aws.glue.CatalogTable("example",
            name="abelt",
            database_name=test["name"],
            storage_descriptor={
                "columns": [{
                    "name": "event",
                    "type": "string",
                }],
            })
        example_permissions = aws.lakeformation.Permissions("example",
            permissions=["SELECT"],
            principal="arn:aws:iam:us-east-1:123456789012:user/SanHolo",
            table_with_columns={
                "database_name": example_catalog_table.database_name,
                "name": example_catalog_table.name,
                "column_names": ["event"],
            })
        ```

        The resulting permissions depend on whether the table had `IAMAllowedPrincipals` (IAP) permissions or not.

        | Result With IAP | Result Without IAP |
        | ---- | ---- |
        | `SELECT` column wildcard (i.e., all columns) | `SELECT` on `"event"` (as expected) |

        ## `ALLIAMPrincipals` group

        AllIAMPrincipals is a pseudo-entity group that acts like a Lake Formation principal. The group includes all IAMs in the account that is defined.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lakeformation.Permissions("example",
            permissions=["SELECT"],
            principal="123456789012:IAMPrincipals",
            table_with_columns={
                "database_name": example_aws_glue_catalog_table["databaseName"],
                "name": example_aws_glue_catalog_table["name"],
                "column_names": ["event"],
            })
        ```

        ## Using Lake Formation Permissions

        Lake Formation grants implicit permissions to data lake administrators, database creators, and table creators. These implicit permissions cannot be revoked _per se_. If this resource reads implicit permissions, it will attempt to revoke them, which causes an error when the resource is destroyed.

        There are two ways to avoid these errors. First, and the way we recommend, is to avoid using this resource with principals that have implicit permissions. A second, error-prone option, is to grant explicit permissions (and `permissions_with_grant_option`) to "overwrite" a principal's implicit permissions, which you can then revoke with this resource. For more information, see [Implicit Lake Formation Permissions](https://docs.aws.amazon.com/lake-formation/latest/dg/implicit-permissions.html).

        If the `principal` is also a data lake administrator, AWS grants implicit permissions that can cause errors using this resource. For example, AWS implicitly grants a `principal`/administrator `permissions` and `permissions_with_grant_option` of `ALL`, `ALTER`, `DELETE`, `DESCRIBE`, `DROP`, `INSERT`, and `SELECT` on a table. If you use this resource to explicitly grant the `principal`/administrator `permissions` but _not_ `permissions_with_grant_option` of `ALL`, `ALTER`, `DELETE`, `DESCRIBE`, `DROP`, `INSERT`, and `SELECT` on the table, this resource will read the implicit `permissions_with_grant_option` and attempt to revoke them when the resource is destroyed. Doing so will cause an `InvalidInputException: No permissions revoked` error because you cannot revoke implicit permissions _per se_. To workaround this problem, explicitly grant the `principal`/administrator `permissions` _and_ `permissions_with_grant_option`, which can then be revoked. Similarly, granting a `principal`/administrator permissions on a table with columns and providing `column_names`, will result in a `InvalidInputException: Permissions modification is invalid` error because you are narrowing the implicit permissions. Instead, set `wildcard` to `true` and remove the `column_names`.

        ## Example Usage

        ### Grant Permissions For A Lake Formation S3 Resource

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lakeformation.Permissions("example",
            principal=workflow_role["arn"],
            permissions=["DATA_LOCATION_ACCESS"],
            data_location={
                "arn": example_aws_lakeformation_resource["arn"],
            })
        ```

        ### Grant Permissions For A Glue Catalog Database

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lakeformation.Permissions("example",
            principal=workflow_role["arn"],
            permissions=[
                "CREATE_TABLE",
                "ALTER",
                "DROP",
            ],
            database={
                "name": example_aws_glue_catalog_database["name"],
                "catalog_id": "110376042874",
            })
        ```

        ### Grant Permissions Using Tag-Based Access Control

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.lakeformation.Permissions("test",
            principal=sales_role["arn"],
            permissions=[
                "CREATE_TABLE",
                "ALTER",
                "DROP",
            ],
            lf_tag_policy={
                "resource_type": "DATABASE",
                "expressions": [
                    {
                        "key": "Team",
                        "values": ["Sales"],
                    },
                    {
                        "key": "Environment",
                        "values": [
                            "Dev",
                            "Production",
                        ],
                    },
                ],
            })
        ```

        :param str resource_name: The name of the resource.
        :param PermissionsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PermissionsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 catalog_resource: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_cells_filter: Optional[pulumi.Input[Union['PermissionsDataCellsFilterArgs', 'PermissionsDataCellsFilterArgsDict']]] = None,
                 data_location: Optional[pulumi.Input[Union['PermissionsDataLocationArgs', 'PermissionsDataLocationArgsDict']]] = None,
                 database: Optional[pulumi.Input[Union['PermissionsDatabaseArgs', 'PermissionsDatabaseArgsDict']]] = None,
                 lf_tag: Optional[pulumi.Input[Union['PermissionsLfTagArgs', 'PermissionsLfTagArgsDict']]] = None,
                 lf_tag_policy: Optional[pulumi.Input[Union['PermissionsLfTagPolicyArgs', 'PermissionsLfTagPolicyArgsDict']]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 permissions_with_grant_options: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 table: Optional[pulumi.Input[Union['PermissionsTableArgs', 'PermissionsTableArgsDict']]] = None,
                 table_with_columns: Optional[pulumi.Input[Union['PermissionsTableWithColumnsArgs', 'PermissionsTableWithColumnsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PermissionsArgs.__new__(PermissionsArgs)

            __props__.__dict__["catalog_id"] = catalog_id
            __props__.__dict__["catalog_resource"] = catalog_resource
            __props__.__dict__["data_cells_filter"] = data_cells_filter
            __props__.__dict__["data_location"] = data_location
            __props__.__dict__["database"] = database
            __props__.__dict__["lf_tag"] = lf_tag
            __props__.__dict__["lf_tag_policy"] = lf_tag_policy
            if permissions is None and not opts.urn:
                raise TypeError("Missing required property 'permissions'")
            __props__.__dict__["permissions"] = permissions
            __props__.__dict__["permissions_with_grant_options"] = permissions_with_grant_options
            if principal is None and not opts.urn:
                raise TypeError("Missing required property 'principal'")
            __props__.__dict__["principal"] = principal
            __props__.__dict__["region"] = region
            __props__.__dict__["table"] = table
            __props__.__dict__["table_with_columns"] = table_with_columns
        super(Permissions, __self__).__init__(
            'aws:lakeformation/permissions:Permissions',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
            catalog_resource: Optional[pulumi.Input[_builtins.bool]] = None,
            data_cells_filter: Optional[pulumi.Input[Union['PermissionsDataCellsFilterArgs', 'PermissionsDataCellsFilterArgsDict']]] = None,
            data_location: Optional[pulumi.Input[Union['PermissionsDataLocationArgs', 'PermissionsDataLocationArgsDict']]] = None,
            database: Optional[pulumi.Input[Union['PermissionsDatabaseArgs', 'PermissionsDatabaseArgsDict']]] = None,
            lf_tag: Optional[pulumi.Input[Union['PermissionsLfTagArgs', 'PermissionsLfTagArgsDict']]] = None,
            lf_tag_policy: Optional[pulumi.Input[Union['PermissionsLfTagPolicyArgs', 'PermissionsLfTagPolicyArgsDict']]] = None,
            permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            permissions_with_grant_options: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            principal: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            table: Optional[pulumi.Input[Union['PermissionsTableArgs', 'PermissionsTableArgsDict']]] = None,
            table_with_columns: Optional[pulumi.Input[Union['PermissionsTableWithColumnsArgs', 'PermissionsTableWithColumnsArgsDict']]] = None) -> 'Permissions':
        """
        Get an existing Permissions resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] catalog_id: Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
        :param pulumi.Input[_builtins.bool] catalog_resource: Whether the permissions are to be granted for the Data Catalog. Defaults to `false`.
        :param pulumi.Input[Union['PermissionsDataCellsFilterArgs', 'PermissionsDataCellsFilterArgsDict']] data_cells_filter: Configuration block for a data cells filter resource. Detailed below.
        :param pulumi.Input[Union['PermissionsDataLocationArgs', 'PermissionsDataLocationArgsDict']] data_location: Configuration block for a data location resource. Detailed below.
        :param pulumi.Input[Union['PermissionsDatabaseArgs', 'PermissionsDatabaseArgsDict']] database: Configuration block for a database resource. Detailed below.
        :param pulumi.Input[Union['PermissionsLfTagArgs', 'PermissionsLfTagArgsDict']] lf_tag: Configuration block for an LF-tag resource. Detailed below.
        :param pulumi.Input[Union['PermissionsLfTagPolicyArgs', 'PermissionsLfTagPolicyArgsDict']] lf_tag_policy: Configuration block for an LF-tag policy resource. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permissions: List of permissions granted to the principal. Valid values may include `ALL`, `ALTER`, `ASSOCIATE`, `CREATE_DATABASE`, `CREATE_TABLE`, `DATA_LOCATION_ACCESS`, `DELETE`, `DESCRIBE`, `DROP`, `INSERT`, and `SELECT`. For details on each permission, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permissions_with_grant_options: Subset of `permissions` which the principal can pass.
        :param pulumi.Input[_builtins.str] principal: Principal to be granted the permissions on the resource. Supported principals include `IAM_ALLOWED_PRINCIPALS` (see Default Behavior and `IAMAllowedPrincipals` above), IAM roles, users, groups, Federated Users, SAML groups and users, QuickSight groups, OUs, and organizations as well as AWS account IDs for cross-account permissions. For more information, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
               
               > **NOTE:** We highly recommend that the `principal` _NOT_ be a Lake Formation administrator (granted using `lakeformation.DataLakeSettings`). The entity (e.g., IAM role) running the deployment will most likely need to be a Lake Formation administrator. As such, the entity will have implicit permissions and does not need permissions granted through this resource.
               
               One of the following is required:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['PermissionsTableArgs', 'PermissionsTableArgsDict']] table: Configuration block for a table resource. Detailed below.
        :param pulumi.Input[Union['PermissionsTableWithColumnsArgs', 'PermissionsTableWithColumnsArgsDict']] table_with_columns: Configuration block for a table with columns resource. Detailed below.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PermissionsState.__new__(_PermissionsState)

        __props__.__dict__["catalog_id"] = catalog_id
        __props__.__dict__["catalog_resource"] = catalog_resource
        __props__.__dict__["data_cells_filter"] = data_cells_filter
        __props__.__dict__["data_location"] = data_location
        __props__.__dict__["database"] = database
        __props__.__dict__["lf_tag"] = lf_tag
        __props__.__dict__["lf_tag_policy"] = lf_tag_policy
        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["permissions_with_grant_options"] = permissions_with_grant_options
        __props__.__dict__["principal"] = principal
        __props__.__dict__["region"] = region
        __props__.__dict__["table"] = table
        __props__.__dict__["table_with_columns"] = table_with_columns
        return Permissions(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your Lake Formation environment.
        """
        return pulumi.get(self, "catalog_id")

    @_builtins.property
    @pulumi.getter(name="catalogResource")
    def catalog_resource(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the permissions are to be granted for the Data Catalog. Defaults to `false`.
        """
        return pulumi.get(self, "catalog_resource")

    @_builtins.property
    @pulumi.getter(name="dataCellsFilter")
    def data_cells_filter(self) -> pulumi.Output[Optional['outputs.PermissionsDataCellsFilter']]:
        """
        Configuration block for a data cells filter resource. Detailed below.
        """
        return pulumi.get(self, "data_cells_filter")

    @_builtins.property
    @pulumi.getter(name="dataLocation")
    def data_location(self) -> pulumi.Output['outputs.PermissionsDataLocation']:
        """
        Configuration block for a data location resource. Detailed below.
        """
        return pulumi.get(self, "data_location")

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Output['outputs.PermissionsDatabase']:
        """
        Configuration block for a database resource. Detailed below.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter(name="lfTag")
    def lf_tag(self) -> pulumi.Output['outputs.PermissionsLfTag']:
        """
        Configuration block for an LF-tag resource. Detailed below.
        """
        return pulumi.get(self, "lf_tag")

    @_builtins.property
    @pulumi.getter(name="lfTagPolicy")
    def lf_tag_policy(self) -> pulumi.Output['outputs.PermissionsLfTagPolicy']:
        """
        Configuration block for an LF-tag policy resource. Detailed below.
        """
        return pulumi.get(self, "lf_tag_policy")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of permissions granted to the principal. Valid values may include `ALL`, `ALTER`, `ASSOCIATE`, `CREATE_DATABASE`, `CREATE_TABLE`, `DATA_LOCATION_ACCESS`, `DELETE`, `DESCRIBE`, `DROP`, `INSERT`, and `SELECT`. For details on each permission, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter(name="permissionsWithGrantOptions")
    def permissions_with_grant_options(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Subset of `permissions` which the principal can pass.
        """
        return pulumi.get(self, "permissions_with_grant_options")

    @_builtins.property
    @pulumi.getter
    def principal(self) -> pulumi.Output[_builtins.str]:
        """
        Principal to be granted the permissions on the resource. Supported principals include `IAM_ALLOWED_PRINCIPALS` (see Default Behavior and `IAMAllowedPrincipals` above), IAM roles, users, groups, Federated Users, SAML groups and users, QuickSight groups, OUs, and organizations as well as AWS account IDs for cross-account permissions. For more information, see [Lake Formation Permissions Reference](https://docs.aws.amazon.com/lake-formation/latest/dg/lf-permissions-reference.html).

        > **NOTE:** We highly recommend that the `principal` _NOT_ be a Lake Formation administrator (granted using `lakeformation.DataLakeSettings`). The entity (e.g., IAM role) running the deployment will most likely need to be a Lake Formation administrator. As such, the entity will have implicit permissions and does not need permissions granted through this resource.

        One of the following is required:
        """
        return pulumi.get(self, "principal")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def table(self) -> pulumi.Output['outputs.PermissionsTable']:
        """
        Configuration block for a table resource. Detailed below.
        """
        return pulumi.get(self, "table")

    @_builtins.property
    @pulumi.getter(name="tableWithColumns")
    def table_with_columns(self) -> pulumi.Output['outputs.PermissionsTableWithColumns']:
        """
        Configuration block for a table with columns resource. Detailed below.

        The following arguments are optional:
        """
        return pulumi.get(self, "table_with_columns")

