# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FunctionRecursionConfigArgs', 'FunctionRecursionConfig']

@pulumi.input_type
class FunctionRecursionConfigArgs:
    def __init__(__self__, *,
                 function_name: pulumi.Input[_builtins.str],
                 recursive_loop: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FunctionRecursionConfig resource.
        :param pulumi.Input[_builtins.str] function_name: Name of the Lambda function.
        :param pulumi.Input[_builtins.str] recursive_loop: Lambda function recursion configuration. Valid values are `Allow` or `Terminate`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "function_name", function_name)
        pulumi.set(__self__, "recursive_loop", recursive_loop)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the Lambda function.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "function_name", value)

    @_builtins.property
    @pulumi.getter(name="recursiveLoop")
    def recursive_loop(self) -> pulumi.Input[_builtins.str]:
        """
        Lambda function recursion configuration. Valid values are `Allow` or `Terminate`.

        The following arguments are optional:
        """
        return pulumi.get(self, "recursive_loop")

    @recursive_loop.setter
    def recursive_loop(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "recursive_loop", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _FunctionRecursionConfigState:
    def __init__(__self__, *,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 recursive_loop: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FunctionRecursionConfig resources.
        :param pulumi.Input[_builtins.str] function_name: Name of the Lambda function.
        :param pulumi.Input[_builtins.str] recursive_loop: Lambda function recursion configuration. Valid values are `Allow` or `Terminate`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if function_name is not None:
            pulumi.set(__self__, "function_name", function_name)
        if recursive_loop is not None:
            pulumi.set(__self__, "recursive_loop", recursive_loop)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Lambda function.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_name", value)

    @_builtins.property
    @pulumi.getter(name="recursiveLoop")
    def recursive_loop(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Lambda function recursion configuration. Valid values are `Allow` or `Terminate`.

        The following arguments are optional:
        """
        return pulumi.get(self, "recursive_loop")

    @recursive_loop.setter
    def recursive_loop(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recursive_loop", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:lambda/functionRecursionConfig:FunctionRecursionConfig")
class FunctionRecursionConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 recursive_loop: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an AWS Lambda Function Recursion Config. Use this resource to control how Lambda handles recursive function invocations to prevent infinite loops.

        > **Note:** Destruction of this resource will return the `recursive_loop` configuration back to the default value of `Terminate`.

        ## Example Usage

        ### Allow Recursive Invocations

        ```python
        import pulumi
        import pulumi_aws as aws

        # Lambda function that may need to call itself
        example = aws.lambda_.Function("example",
            code=pulumi.FileArchive("function.zip"),
            name="recursive_processor",
            role=lambda_role["arn"],
            handler="index.handler",
            runtime=aws.lambda_.Runtime.PYTHON3D12)
        # Allow the function to invoke itself recursively
        example_function_recursion_config = aws.lambda_.FunctionRecursionConfig("example",
            function_name=example.name,
            recursive_loop="Allow")
        ```

        ### Production Safety Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        # Production function with recursion protection
        production_processor = aws.lambda_.Function("production_processor",
            code=pulumi.FileArchive("processor.zip"),
            name="production-data-processor",
            role=lambda_role["arn"],
            handler="app.handler",
            runtime=aws.lambda_.Runtime.NODE_JS20D_X,
            tags={
                "Environment": "production",
                "Purpose": "data-processing",
            })
        # Prevent infinite loops in production
        example = aws.lambda_.FunctionRecursionConfig("example",
            function_name=production_processor.name,
            recursive_loop="Terminate")
        ```

        ## Import

        For backwards compatibility, the following legacy `pulumi import` command is also supported:

        ```sh
        $ pulumi import aws:lambda/functionRecursionConfig:FunctionRecursionConfig example recursive_processor
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] function_name: Name of the Lambda function.
        :param pulumi.Input[_builtins.str] recursive_loop: Lambda function recursion configuration. Valid values are `Allow` or `Terminate`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FunctionRecursionConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Lambda Function Recursion Config. Use this resource to control how Lambda handles recursive function invocations to prevent infinite loops.

        > **Note:** Destruction of this resource will return the `recursive_loop` configuration back to the default value of `Terminate`.

        ## Example Usage

        ### Allow Recursive Invocations

        ```python
        import pulumi
        import pulumi_aws as aws

        # Lambda function that may need to call itself
        example = aws.lambda_.Function("example",
            code=pulumi.FileArchive("function.zip"),
            name="recursive_processor",
            role=lambda_role["arn"],
            handler="index.handler",
            runtime=aws.lambda_.Runtime.PYTHON3D12)
        # Allow the function to invoke itself recursively
        example_function_recursion_config = aws.lambda_.FunctionRecursionConfig("example",
            function_name=example.name,
            recursive_loop="Allow")
        ```

        ### Production Safety Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        # Production function with recursion protection
        production_processor = aws.lambda_.Function("production_processor",
            code=pulumi.FileArchive("processor.zip"),
            name="production-data-processor",
            role=lambda_role["arn"],
            handler="app.handler",
            runtime=aws.lambda_.Runtime.NODE_JS20D_X,
            tags={
                "Environment": "production",
                "Purpose": "data-processing",
            })
        # Prevent infinite loops in production
        example = aws.lambda_.FunctionRecursionConfig("example",
            function_name=production_processor.name,
            recursive_loop="Terminate")
        ```

        ## Import

        For backwards compatibility, the following legacy `pulumi import` command is also supported:

        ```sh
        $ pulumi import aws:lambda/functionRecursionConfig:FunctionRecursionConfig example recursive_processor
        ```

        :param str resource_name: The name of the resource.
        :param FunctionRecursionConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionRecursionConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 recursive_loop: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionRecursionConfigArgs.__new__(FunctionRecursionConfigArgs)

            if function_name is None and not opts.urn:
                raise TypeError("Missing required property 'function_name'")
            __props__.__dict__["function_name"] = function_name
            if recursive_loop is None and not opts.urn:
                raise TypeError("Missing required property 'recursive_loop'")
            __props__.__dict__["recursive_loop"] = recursive_loop
            __props__.__dict__["region"] = region
        super(FunctionRecursionConfig, __self__).__init__(
            'aws:lambda/functionRecursionConfig:FunctionRecursionConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            function_name: Optional[pulumi.Input[_builtins.str]] = None,
            recursive_loop: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'FunctionRecursionConfig':
        """
        Get an existing FunctionRecursionConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] function_name: Name of the Lambda function.
        :param pulumi.Input[_builtins.str] recursive_loop: Lambda function recursion configuration. Valid values are `Allow` or `Terminate`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionRecursionConfigState.__new__(_FunctionRecursionConfigState)

        __props__.__dict__["function_name"] = function_name
        __props__.__dict__["recursive_loop"] = recursive_loop
        __props__.__dict__["region"] = region
        return FunctionRecursionConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Lambda function.
        """
        return pulumi.get(self, "function_name")

    @_builtins.property
    @pulumi.getter(name="recursiveLoop")
    def recursive_loop(self) -> pulumi.Output[_builtins.str]:
        """
        Lambda function recursion configuration. Valid values are `Allow` or `Terminate`.

        The following arguments are optional:
        """
        return pulumi.get(self, "recursive_loop")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

