# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCodeSigningConfigResult',
    'AwaitableGetCodeSigningConfigResult',
    'get_code_signing_config',
    'get_code_signing_config_output',
]

@pulumi.output_type
class GetCodeSigningConfigResult:
    """
    A collection of values returned by getCodeSigningConfig.
    """
    def __init__(__self__, allowed_publishers=None, arn=None, config_id=None, description=None, id=None, last_modified=None, policies=None, region=None):
        if allowed_publishers and not isinstance(allowed_publishers, list):
            raise TypeError("Expected argument 'allowed_publishers' to be a list")
        pulumi.set(__self__, "allowed_publishers", allowed_publishers)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if config_id and not isinstance(config_id, str):
            raise TypeError("Expected argument 'config_id' to be a str")
        pulumi.set(__self__, "config_id", config_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_modified and not isinstance(last_modified, str):
            raise TypeError("Expected argument 'last_modified' to be a str")
        pulumi.set(__self__, "last_modified", last_modified)
        if policies and not isinstance(policies, list):
            raise TypeError("Expected argument 'policies' to be a list")
        pulumi.set(__self__, "policies", policies)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="allowedPublishers")
    def allowed_publishers(self) -> Sequence['outputs.GetCodeSigningConfigAllowedPublisherResult']:
        """
        List of allowed publishers as signing profiles for this code signing configuration. See below.
        """
        return pulumi.get(self, "allowed_publishers")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> _builtins.str:
        """
        Unique identifier for the code signing configuration.
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Code signing configuration description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> _builtins.str:
        """
        Date and time that the code signing configuration was last modified.
        """
        return pulumi.get(self, "last_modified")

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Sequence['outputs.GetCodeSigningConfigPolicyResult']:
        """
        List of code signing policies that control the validation failure action for signature mismatch or expiry. See below.
        """
        return pulumi.get(self, "policies")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetCodeSigningConfigResult(GetCodeSigningConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCodeSigningConfigResult(
            allowed_publishers=self.allowed_publishers,
            arn=self.arn,
            config_id=self.config_id,
            description=self.description,
            id=self.id,
            last_modified=self.last_modified,
            policies=self.policies,
            region=self.region)


def get_code_signing_config(arn: Optional[_builtins.str] = None,
                            region: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCodeSigningConfigResult:
    """
    Provides details about an AWS Lambda Code Signing Config. Use this data source to retrieve information about an existing code signing configuration for Lambda functions to ensure code integrity and authenticity.

    For information about Lambda code signing configurations and how to use them, see [configuring code signing for Lambda functions](https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html).

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.lambda.get_code_signing_config(arn="arn:aws:lambda:us-west-2:123456789012:code-signing-config:csc-0f6c334abcdea4d8b")
    pulumi.export("configDetails", {
        "configId": example.config_id,
        "description": example.description,
        "policy": example.policies[0].untrusted_artifact_on_deployment,
    })
    ```

    ### Use in Lambda Function

    ```python
    import pulumi
    import pulumi_aws as aws

    # Get existing code signing configuration
    security_config = aws.lambda.get_code_signing_config(arn=code_signing_config_arn)
    # Create Lambda function with code signing
    example = aws.lambda_.Function("example",
        code=pulumi.FileArchive("function.zip"),
        name="secure-function",
        role=lambda_role["arn"],
        handler="index.handler",
        runtime=aws.lambda_.Runtime.NODE_JS20D_X,
        code_signing_config_arn=security_config.arn,
        tags={
            "Environment": "production",
            "Security": "code-signed",
        })
    ```

    ### Multi-Environment Configuration

    ```python
    import pulumi
    import pulumi_aws as aws

    # Production code signing config
    prod = aws.lambda.get_code_signing_config(arn="arn:aws:lambda:us-west-2:123456789012:code-signing-config:csc-prod-123")
    # Development code signing config
    dev = aws.lambda.get_code_signing_config(arn="arn:aws:lambda:us-west-2:123456789012:code-signing-config:csc-dev-456")
    prod_policy = prod.policies[0].untrusted_artifact_on_deployment
    dev_policy = dev.policies[0].untrusted_artifact_on_deployment
    config_comparison = {
        "prodEnforcement": prod_policy,
        "devEnforcement": dev_policy,
        "policiesMatch": prod_policy == dev_policy,
    }
    pulumi.export("environmentComparison", config_comparison)
    ```


    :param _builtins.str arn: ARN of the code signing configuration.
           
           The following arguments are optional:
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:lambda/getCodeSigningConfig:getCodeSigningConfig', __args__, opts=opts, typ=GetCodeSigningConfigResult).value

    return AwaitableGetCodeSigningConfigResult(
        allowed_publishers=pulumi.get(__ret__, 'allowed_publishers'),
        arn=pulumi.get(__ret__, 'arn'),
        config_id=pulumi.get(__ret__, 'config_id'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        last_modified=pulumi.get(__ret__, 'last_modified'),
        policies=pulumi.get(__ret__, 'policies'),
        region=pulumi.get(__ret__, 'region'))
def get_code_signing_config_output(arn: Optional[pulumi.Input[_builtins.str]] = None,
                                   region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCodeSigningConfigResult]:
    """
    Provides details about an AWS Lambda Code Signing Config. Use this data source to retrieve information about an existing code signing configuration for Lambda functions to ensure code integrity and authenticity.

    For information about Lambda code signing configurations and how to use them, see [configuring code signing for Lambda functions](https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html).

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.lambda.get_code_signing_config(arn="arn:aws:lambda:us-west-2:123456789012:code-signing-config:csc-0f6c334abcdea4d8b")
    pulumi.export("configDetails", {
        "configId": example.config_id,
        "description": example.description,
        "policy": example.policies[0].untrusted_artifact_on_deployment,
    })
    ```

    ### Use in Lambda Function

    ```python
    import pulumi
    import pulumi_aws as aws

    # Get existing code signing configuration
    security_config = aws.lambda.get_code_signing_config(arn=code_signing_config_arn)
    # Create Lambda function with code signing
    example = aws.lambda_.Function("example",
        code=pulumi.FileArchive("function.zip"),
        name="secure-function",
        role=lambda_role["arn"],
        handler="index.handler",
        runtime=aws.lambda_.Runtime.NODE_JS20D_X,
        code_signing_config_arn=security_config.arn,
        tags={
            "Environment": "production",
            "Security": "code-signed",
        })
    ```

    ### Multi-Environment Configuration

    ```python
    import pulumi
    import pulumi_aws as aws

    # Production code signing config
    prod = aws.lambda.get_code_signing_config(arn="arn:aws:lambda:us-west-2:123456789012:code-signing-config:csc-prod-123")
    # Development code signing config
    dev = aws.lambda.get_code_signing_config(arn="arn:aws:lambda:us-west-2:123456789012:code-signing-config:csc-dev-456")
    prod_policy = prod.policies[0].untrusted_artifact_on_deployment
    dev_policy = dev.policies[0].untrusted_artifact_on_deployment
    config_comparison = {
        "prodEnforcement": prod_policy,
        "devEnforcement": dev_policy,
        "policiesMatch": prod_policy == dev_policy,
    }
    pulumi.export("environmentComparison", config_comparison)
    ```


    :param _builtins.str arn: ARN of the code signing configuration.
           
           The following arguments are optional:
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:lambda/getCodeSigningConfig:getCodeSigningConfig', __args__, opts=opts, typ=GetCodeSigningConfigResult)
    return __ret__.apply(lambda __response__: GetCodeSigningConfigResult(
        allowed_publishers=pulumi.get(__response__, 'allowed_publishers'),
        arn=pulumi.get(__response__, 'arn'),
        config_id=pulumi.get(__response__, 'config_id'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        last_modified=pulumi.get(__response__, 'last_modified'),
        policies=pulumi.get(__response__, 'policies'),
        region=pulumi.get(__response__, 'region')))
