# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetInvocationResult',
    'AwaitableGetInvocationResult',
    'get_invocation',
    'get_invocation_output',
]

@pulumi.output_type
class GetInvocationResult:
    """
    A collection of values returned by getInvocation.
    """
    def __init__(__self__, function_name=None, id=None, input=None, qualifier=None, region=None, result=None):
        if function_name and not isinstance(function_name, str):
            raise TypeError("Expected argument 'function_name' to be a str")
        pulumi.set(__self__, "function_name", function_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if input and not isinstance(input, str):
            raise TypeError("Expected argument 'input' to be a str")
        pulumi.set(__self__, "input", input)
        if qualifier and not isinstance(qualifier, str):
            raise TypeError("Expected argument 'qualifier' to be a str")
        pulumi.set(__self__, "qualifier", qualifier)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if result and not isinstance(result, str):
            raise TypeError("Expected argument 'result' to be a str")
        pulumi.set(__self__, "result", result)

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> _builtins.str:
        return pulumi.get(self, "function_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def input(self) -> _builtins.str:
        return pulumi.get(self, "input")

    @_builtins.property
    @pulumi.getter
    def qualifier(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "qualifier")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def result(self) -> _builtins.str:
        """
        String result of the Lambda function invocation.
        """
        return pulumi.get(self, "result")


class AwaitableGetInvocationResult(GetInvocationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInvocationResult(
            function_name=self.function_name,
            id=self.id,
            input=self.input,
            qualifier=self.qualifier,
            region=self.region,
            result=self.result)


def get_invocation(function_name: Optional[_builtins.str] = None,
                   input: Optional[_builtins.str] = None,
                   qualifier: Optional[_builtins.str] = None,
                   region: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInvocationResult:
    """
    Invokes an AWS Lambda Function and returns its results. Use this data source to execute Lambda functions during Pulumi operations and use their results in other resources or outputs.

    The Lambda function is invoked with [RequestResponse](https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax) invocation type.

    > **Note:** The `lambda.Invocation` data source invokes the function during the first `apply` and every subsequent `plan` when the function is known.

    > **Note:** If you get a `KMSAccessDeniedException: Lambda was unable to decrypt the environment variables because KMS access was denied` error when invoking a Lambda function with environment variables, the IAM role associated with the function may have been deleted and recreated after the function was created. You can fix the problem two ways: 1) updating the function's role to another role and then updating it back again to the recreated role. (When you create a function, Lambda grants permissions on the KMS key to the function's IAM role. If the IAM role is recreated, the grant is no longer valid. Changing the function's role or recreating the function causes Lambda to update the grant.)

    ## Example Usage


    :param _builtins.str function_name: Name of the Lambda function.
    :param _builtins.str input: String in JSON format that is passed as payload to the Lambda function.
           
           The following arguments are optional:
    :param _builtins.str qualifier: Qualifier (a.k.a version) of the Lambda function. Defaults to `$LATEST`.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['functionName'] = function_name
    __args__['input'] = input
    __args__['qualifier'] = qualifier
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:lambda/getInvocation:getInvocation', __args__, opts=opts, typ=GetInvocationResult).value

    return AwaitableGetInvocationResult(
        function_name=pulumi.get(__ret__, 'function_name'),
        id=pulumi.get(__ret__, 'id'),
        input=pulumi.get(__ret__, 'input'),
        qualifier=pulumi.get(__ret__, 'qualifier'),
        region=pulumi.get(__ret__, 'region'),
        result=pulumi.get(__ret__, 'result'))
def get_invocation_output(function_name: Optional[pulumi.Input[_builtins.str]] = None,
                          input: Optional[pulumi.Input[_builtins.str]] = None,
                          qualifier: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInvocationResult]:
    """
    Invokes an AWS Lambda Function and returns its results. Use this data source to execute Lambda functions during Pulumi operations and use their results in other resources or outputs.

    The Lambda function is invoked with [RequestResponse](https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax) invocation type.

    > **Note:** The `lambda.Invocation` data source invokes the function during the first `apply` and every subsequent `plan` when the function is known.

    > **Note:** If you get a `KMSAccessDeniedException: Lambda was unable to decrypt the environment variables because KMS access was denied` error when invoking a Lambda function with environment variables, the IAM role associated with the function may have been deleted and recreated after the function was created. You can fix the problem two ways: 1) updating the function's role to another role and then updating it back again to the recreated role. (When you create a function, Lambda grants permissions on the KMS key to the function's IAM role. If the IAM role is recreated, the grant is no longer valid. Changing the function's role or recreating the function causes Lambda to update the grant.)

    ## Example Usage


    :param _builtins.str function_name: Name of the Lambda function.
    :param _builtins.str input: String in JSON format that is passed as payload to the Lambda function.
           
           The following arguments are optional:
    :param _builtins.str qualifier: Qualifier (a.k.a version) of the Lambda function. Defaults to `$LATEST`.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['functionName'] = function_name
    __args__['input'] = input
    __args__['qualifier'] = qualifier
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:lambda/getInvocation:getInvocation', __args__, opts=opts, typ=GetInvocationResult)
    return __ret__.apply(lambda __response__: GetInvocationResult(
        function_name=pulumi.get(__response__, 'function_name'),
        id=pulumi.get(__response__, 'id'),
        input=pulumi.get(__response__, 'input'),
        qualifier=pulumi.get(__response__, 'qualifier'),
        region=pulumi.get(__response__, 'region'),
        result=pulumi.get(__response__, 'result')))
