# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadBalancerArgs', 'LoadBalancer']

@pulumi.input_type
class LoadBalancerArgs:
    def __init__(__self__, *,
                 access_logs: Optional[pulumi.Input['LoadBalancerAccessLogsArgs']] = None,
                 client_keep_alive: Optional[pulumi.Input[_builtins.int]] = None,
                 connection_logs: Optional[pulumi.Input['LoadBalancerConnectionLogsArgs']] = None,
                 customer_owned_ipv4_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 desync_mitigation_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_record_client_routing_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 drop_invalid_header_fields: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_cross_zone_load_balancing: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_http2: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_tls_version_and_cipher_suite_headers: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_waf_fail_open: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_xff_client_port: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_zonal_shift: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_security_group_inbound_rules_on_private_link_traffic: Optional[pulumi.Input[_builtins.str]] = None,
                 idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 internal: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_pools: Optional[pulumi.Input['LoadBalancerIpamPoolsArgs']] = None,
                 load_balancer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_load_balancer_capacity: Optional[pulumi.Input['LoadBalancerMinimumLoadBalancerCapacityArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 preserve_host_header: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_ips_auto_assigned_per_subnet: Optional[pulumi.Input[_builtins.int]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subnet_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerSubnetMappingArgs']]]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 xff_header_processing_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LoadBalancer resource.
        :param pulumi.Input['LoadBalancerAccessLogsArgs'] access_logs: Access Logs block. See below.
        :param pulumi.Input[_builtins.int] client_keep_alive: Client keep alive value in seconds. The valid range is 60-604800 seconds. The default is 3600 seconds.
        :param pulumi.Input['LoadBalancerConnectionLogsArgs'] connection_logs: Connection Logs block. See below. Only valid for Load Balancers of type `application`.
        :param pulumi.Input[_builtins.str] customer_owned_ipv4_pool: ID of the customer owned ipv4 pool to use for this load balancer.
        :param pulumi.Input[_builtins.str] desync_mitigation_mode: How the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
        :param pulumi.Input[_builtins.str] dns_record_client_routing_policy: How traffic is distributed among the load balancer Availability Zones. Possible values are `any_availability_zone` (default), `availability_zone_affinity`, or `partial_availability_zone_affinity`. See   [Availability Zone DNS affinity](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#zonal-dns-affinity) for additional details. Only valid for `network` type load balancers.
        :param pulumi.Input[_builtins.bool] drop_invalid_header_fields: Whether HTTP headers with header fields that are not valid are removed by the load balancer (true) or routed to targets (false). The default is false. Elastic Load Balancing requires that message header names contain only alphanumeric characters and hyphens. Only valid for Load Balancers of type `application`.
        :param pulumi.Input[_builtins.bool] enable_cross_zone_load_balancing: If true, cross-zone load balancing of the load balancer will be enabled. For `network` and `gateway` type load balancers, this feature is disabled by default (`false`). For `application` load balancer this feature is always enabled (`true`) and cannot be disabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] enable_deletion_protection: If true, deletion of the load balancer will be disabled via the AWS API. This will prevent this provider from deleting the load balancer. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] enable_http2: Whether HTTP/2 is enabled in `application` load balancers. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] enable_tls_version_and_cipher_suite_headers: Whether the two headers (`x-amzn-tls-version` and `x-amzn-tls-cipher-suite`), which contain information about the negotiated TLS version and cipher suite, are added to the client request before sending it to the target. Only valid for Load Balancers of type `application`. Defaults to `false`
        :param pulumi.Input[_builtins.bool] enable_waf_fail_open: Whether to allow a WAF-enabled load balancer to route requests to targets if it is unable to forward the request to AWS WAF. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] enable_xff_client_port: Whether the X-Forwarded-For header should preserve the source port that the client used to connect to the load balancer in `application` load balancers. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] enable_zonal_shift: Whether zonal shift is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.str] enforce_security_group_inbound_rules_on_private_link_traffic: Whether inbound security group rules are enforced for traffic originating from a PrivateLink. Only valid for Load Balancers of type `network`. The possible values are `on` and `off`.
        :param pulumi.Input[_builtins.int] idle_timeout: Time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`. Default: 60.
        :param pulumi.Input[_builtins.bool] internal: If true, the LB will be internal. Defaults to `false`.
        :param pulumi.Input[_builtins.str] ip_address_type: Type of IP addresses used by the subnets for your load balancer. The possible values depend upon the load balancer type: `ipv4` (all load balancer types), `dualstack` (all load balancer types), and `dualstack-without-public-ipv4` (type `application` only).
        :param pulumi.Input['LoadBalancerIpamPoolsArgs'] ipam_pools: . The IPAM pools to use with the load balancer.  Only valid for Load Balancers of type `application`. See ipam_pools for more information.
        :param pulumi.Input[_builtins.str] load_balancer_type: Type of load balancer to create. Possible values are `application`, `gateway`, or `network`. The default value is `application`.
        :param pulumi.Input['LoadBalancerMinimumLoadBalancerCapacityArgs'] minimum_load_balancer_capacity: Minimum capacity for a load balancer. Only valid for Load Balancers of type `application` or `network`.
        :param pulumi.Input[_builtins.str] name: Name of the LB. This name must be unique within your AWS account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen. If not specified, this provider will autogenerate a name beginning with `tf-lb`.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[_builtins.bool] preserve_host_header: Whether the Application Load Balancer should preserve the Host header in the HTTP request and send it to the target without any change. Defaults to `false`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] secondary_ips_auto_assigned_per_subnet: The number of secondary IP addresses to configure for your load balancer nodes. Only valid for Load Balancers of type `network`. The valid range is 0-7. When decreased, this will force a recreation of the resource. Default: `0`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: List of security group IDs to assign to the LB. Only valid for Load Balancers of type `application` or `network`. For load balancers of type `network` security groups cannot be added if none are currently present, and cannot all be removed once added. If either of these conditions are met, this will force a recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerSubnetMappingArgs']]] subnet_mappings: Subnet mapping block. See below. For Load Balancers of type `network` subnet mappings can only be added.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnets: List of subnet IDs to attach to the LB. For Load Balancers of type `network` subnets can only be added (see [Availability Zones](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#availability-zones)), deleting a subnet for load balancers of type `network` will force a recreation of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] xff_header_processing_mode: Determines how the load balancer modifies the `X-Forwarded-For` header in the HTTP request before sending the request to the target. The possible values are `append`, `preserve`, and `remove`. Only valid for Load Balancers of type `application`. The default is `append`.
               
               > **NOTE:** Please note that internal LBs can only use `ipv4` as the `ip_address_type`. You can only change to `dualstack` `ip_address_type` if the selected subnets are IPv6 enabled.
               
               > **NOTE:** Please note that one of either `subnets` or `subnet_mapping` is required.
        """
        if access_logs is not None:
            pulumi.set(__self__, "access_logs", access_logs)
        if client_keep_alive is not None:
            pulumi.set(__self__, "client_keep_alive", client_keep_alive)
        if connection_logs is not None:
            pulumi.set(__self__, "connection_logs", connection_logs)
        if customer_owned_ipv4_pool is not None:
            pulumi.set(__self__, "customer_owned_ipv4_pool", customer_owned_ipv4_pool)
        if desync_mitigation_mode is not None:
            pulumi.set(__self__, "desync_mitigation_mode", desync_mitigation_mode)
        if dns_record_client_routing_policy is not None:
            pulumi.set(__self__, "dns_record_client_routing_policy", dns_record_client_routing_policy)
        if drop_invalid_header_fields is not None:
            pulumi.set(__self__, "drop_invalid_header_fields", drop_invalid_header_fields)
        if enable_cross_zone_load_balancing is not None:
            pulumi.set(__self__, "enable_cross_zone_load_balancing", enable_cross_zone_load_balancing)
        if enable_deletion_protection is not None:
            pulumi.set(__self__, "enable_deletion_protection", enable_deletion_protection)
        if enable_http2 is not None:
            pulumi.set(__self__, "enable_http2", enable_http2)
        if enable_tls_version_and_cipher_suite_headers is not None:
            pulumi.set(__self__, "enable_tls_version_and_cipher_suite_headers", enable_tls_version_and_cipher_suite_headers)
        if enable_waf_fail_open is not None:
            pulumi.set(__self__, "enable_waf_fail_open", enable_waf_fail_open)
        if enable_xff_client_port is not None:
            pulumi.set(__self__, "enable_xff_client_port", enable_xff_client_port)
        if enable_zonal_shift is not None:
            pulumi.set(__self__, "enable_zonal_shift", enable_zonal_shift)
        if enforce_security_group_inbound_rules_on_private_link_traffic is not None:
            pulumi.set(__self__, "enforce_security_group_inbound_rules_on_private_link_traffic", enforce_security_group_inbound_rules_on_private_link_traffic)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if internal is not None:
            pulumi.set(__self__, "internal", internal)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if ipam_pools is not None:
            pulumi.set(__self__, "ipam_pools", ipam_pools)
        if load_balancer_type is not None:
            pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        if minimum_load_balancer_capacity is not None:
            pulumi.set(__self__, "minimum_load_balancer_capacity", minimum_load_balancer_capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if preserve_host_header is not None:
            pulumi.set(__self__, "preserve_host_header", preserve_host_header)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secondary_ips_auto_assigned_per_subnet is not None:
            pulumi.set(__self__, "secondary_ips_auto_assigned_per_subnet", secondary_ips_auto_assigned_per_subnet)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if subnet_mappings is not None:
            pulumi.set(__self__, "subnet_mappings", subnet_mappings)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if xff_header_processing_mode is not None:
            pulumi.set(__self__, "xff_header_processing_mode", xff_header_processing_mode)

    @_builtins.property
    @pulumi.getter(name="accessLogs")
    def access_logs(self) -> Optional[pulumi.Input['LoadBalancerAccessLogsArgs']]:
        """
        Access Logs block. See below.
        """
        return pulumi.get(self, "access_logs")

    @access_logs.setter
    def access_logs(self, value: Optional[pulumi.Input['LoadBalancerAccessLogsArgs']]):
        pulumi.set(self, "access_logs", value)

    @_builtins.property
    @pulumi.getter(name="clientKeepAlive")
    def client_keep_alive(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Client keep alive value in seconds. The valid range is 60-604800 seconds. The default is 3600 seconds.
        """
        return pulumi.get(self, "client_keep_alive")

    @client_keep_alive.setter
    def client_keep_alive(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "client_keep_alive", value)

    @_builtins.property
    @pulumi.getter(name="connectionLogs")
    def connection_logs(self) -> Optional[pulumi.Input['LoadBalancerConnectionLogsArgs']]:
        """
        Connection Logs block. See below. Only valid for Load Balancers of type `application`.
        """
        return pulumi.get(self, "connection_logs")

    @connection_logs.setter
    def connection_logs(self, value: Optional[pulumi.Input['LoadBalancerConnectionLogsArgs']]):
        pulumi.set(self, "connection_logs", value)

    @_builtins.property
    @pulumi.getter(name="customerOwnedIpv4Pool")
    def customer_owned_ipv4_pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the customer owned ipv4 pool to use for this load balancer.
        """
        return pulumi.get(self, "customer_owned_ipv4_pool")

    @customer_owned_ipv4_pool.setter
    def customer_owned_ipv4_pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_owned_ipv4_pool", value)

    @_builtins.property
    @pulumi.getter(name="desyncMitigationMode")
    def desync_mitigation_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
        """
        return pulumi.get(self, "desync_mitigation_mode")

    @desync_mitigation_mode.setter
    def desync_mitigation_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desync_mitigation_mode", value)

    @_builtins.property
    @pulumi.getter(name="dnsRecordClientRoutingPolicy")
    def dns_record_client_routing_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How traffic is distributed among the load balancer Availability Zones. Possible values are `any_availability_zone` (default), `availability_zone_affinity`, or `partial_availability_zone_affinity`. See   [Availability Zone DNS affinity](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#zonal-dns-affinity) for additional details. Only valid for `network` type load balancers.
        """
        return pulumi.get(self, "dns_record_client_routing_policy")

    @dns_record_client_routing_policy.setter
    def dns_record_client_routing_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_record_client_routing_policy", value)

    @_builtins.property
    @pulumi.getter(name="dropInvalidHeaderFields")
    def drop_invalid_header_fields(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether HTTP headers with header fields that are not valid are removed by the load balancer (true) or routed to targets (false). The default is false. Elastic Load Balancing requires that message header names contain only alphanumeric characters and hyphens. Only valid for Load Balancers of type `application`.
        """
        return pulumi.get(self, "drop_invalid_header_fields")

    @drop_invalid_header_fields.setter
    def drop_invalid_header_fields(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "drop_invalid_header_fields", value)

    @_builtins.property
    @pulumi.getter(name="enableCrossZoneLoadBalancing")
    def enable_cross_zone_load_balancing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, cross-zone load balancing of the load balancer will be enabled. For `network` and `gateway` type load balancers, this feature is disabled by default (`false`). For `application` load balancer this feature is always enabled (`true`) and cannot be disabled. Defaults to `false`.
        """
        return pulumi.get(self, "enable_cross_zone_load_balancing")

    @enable_cross_zone_load_balancing.setter
    def enable_cross_zone_load_balancing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_cross_zone_load_balancing", value)

    @_builtins.property
    @pulumi.getter(name="enableDeletionProtection")
    def enable_deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, deletion of the load balancer will be disabled via the AWS API. This will prevent this provider from deleting the load balancer. Defaults to `false`.
        """
        return pulumi.get(self, "enable_deletion_protection")

    @enable_deletion_protection.setter
    def enable_deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="enableHttp2")
    def enable_http2(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether HTTP/2 is enabled in `application` load balancers. Defaults to `true`.
        """
        return pulumi.get(self, "enable_http2")

    @enable_http2.setter
    def enable_http2(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_http2", value)

    @_builtins.property
    @pulumi.getter(name="enableTlsVersionAndCipherSuiteHeaders")
    def enable_tls_version_and_cipher_suite_headers(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the two headers (`x-amzn-tls-version` and `x-amzn-tls-cipher-suite`), which contain information about the negotiated TLS version and cipher suite, are added to the client request before sending it to the target. Only valid for Load Balancers of type `application`. Defaults to `false`
        """
        return pulumi.get(self, "enable_tls_version_and_cipher_suite_headers")

    @enable_tls_version_and_cipher_suite_headers.setter
    def enable_tls_version_and_cipher_suite_headers(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_tls_version_and_cipher_suite_headers", value)

    @_builtins.property
    @pulumi.getter(name="enableWafFailOpen")
    def enable_waf_fail_open(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow a WAF-enabled load balancer to route requests to targets if it is unable to forward the request to AWS WAF. Defaults to `false`.
        """
        return pulumi.get(self, "enable_waf_fail_open")

    @enable_waf_fail_open.setter
    def enable_waf_fail_open(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_waf_fail_open", value)

    @_builtins.property
    @pulumi.getter(name="enableXffClientPort")
    def enable_xff_client_port(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the X-Forwarded-For header should preserve the source port that the client used to connect to the load balancer in `application` load balancers. Defaults to `false`.
        """
        return pulumi.get(self, "enable_xff_client_port")

    @enable_xff_client_port.setter
    def enable_xff_client_port(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_xff_client_port", value)

    @_builtins.property
    @pulumi.getter(name="enableZonalShift")
    def enable_zonal_shift(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether zonal shift is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "enable_zonal_shift")

    @enable_zonal_shift.setter
    def enable_zonal_shift(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_zonal_shift", value)

    @_builtins.property
    @pulumi.getter(name="enforceSecurityGroupInboundRulesOnPrivateLinkTraffic")
    def enforce_security_group_inbound_rules_on_private_link_traffic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether inbound security group rules are enforced for traffic originating from a PrivateLink. Only valid for Load Balancers of type `network`. The possible values are `on` and `off`.
        """
        return pulumi.get(self, "enforce_security_group_inbound_rules_on_private_link_traffic")

    @enforce_security_group_inbound_rules_on_private_link_traffic.setter
    def enforce_security_group_inbound_rules_on_private_link_traffic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enforce_security_group_inbound_rules_on_private_link_traffic", value)

    @_builtins.property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`. Default: 60.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "idle_timeout", value)

    @_builtins.property
    @pulumi.getter
    def internal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the LB will be internal. Defaults to `false`.
        """
        return pulumi.get(self, "internal")

    @internal.setter
    def internal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "internal", value)

    @_builtins.property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of IP addresses used by the subnets for your load balancer. The possible values depend upon the load balancer type: `ipv4` (all load balancer types), `dualstack` (all load balancer types), and `dualstack-without-public-ipv4` (type `application` only).
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address_type", value)

    @_builtins.property
    @pulumi.getter(name="ipamPools")
    def ipam_pools(self) -> Optional[pulumi.Input['LoadBalancerIpamPoolsArgs']]:
        """
        . The IPAM pools to use with the load balancer.  Only valid for Load Balancers of type `application`. See ipam_pools for more information.
        """
        return pulumi.get(self, "ipam_pools")

    @ipam_pools.setter
    def ipam_pools(self, value: Optional[pulumi.Input['LoadBalancerIpamPoolsArgs']]):
        pulumi.set(self, "ipam_pools", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of load balancer to create. Possible values are `application`, `gateway`, or `network`. The default value is `application`.
        """
        return pulumi.get(self, "load_balancer_type")

    @load_balancer_type.setter
    def load_balancer_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_type", value)

    @_builtins.property
    @pulumi.getter(name="minimumLoadBalancerCapacity")
    def minimum_load_balancer_capacity(self) -> Optional[pulumi.Input['LoadBalancerMinimumLoadBalancerCapacityArgs']]:
        """
        Minimum capacity for a load balancer. Only valid for Load Balancers of type `application` or `network`.
        """
        return pulumi.get(self, "minimum_load_balancer_capacity")

    @minimum_load_balancer_capacity.setter
    def minimum_load_balancer_capacity(self, value: Optional[pulumi.Input['LoadBalancerMinimumLoadBalancerCapacityArgs']]):
        pulumi.set(self, "minimum_load_balancer_capacity", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the LB. This name must be unique within your AWS account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen. If not specified, this provider will autogenerate a name beginning with `tf-lb`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="preserveHostHeader")
    def preserve_host_header(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the Application Load Balancer should preserve the Host header in the HTTP request and send it to the target without any change. Defaults to `false`.
        """
        return pulumi.get(self, "preserve_host_header")

    @preserve_host_header.setter
    def preserve_host_header(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "preserve_host_header", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secondaryIpsAutoAssignedPerSubnet")
    def secondary_ips_auto_assigned_per_subnet(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of secondary IP addresses to configure for your load balancer nodes. Only valid for Load Balancers of type `network`. The valid range is 0-7. When decreased, this will force a recreation of the resource. Default: `0`.
        """
        return pulumi.get(self, "secondary_ips_auto_assigned_per_subnet")

    @secondary_ips_auto_assigned_per_subnet.setter
    def secondary_ips_auto_assigned_per_subnet(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "secondary_ips_auto_assigned_per_subnet", value)

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of security group IDs to assign to the LB. Only valid for Load Balancers of type `application` or `network`. For load balancers of type `network` security groups cannot be added if none are currently present, and cannot all be removed once added. If either of these conditions are met, this will force a recreation of the resource.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @_builtins.property
    @pulumi.getter(name="subnetMappings")
    def subnet_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerSubnetMappingArgs']]]]:
        """
        Subnet mapping block. See below. For Load Balancers of type `network` subnet mappings can only be added.
        """
        return pulumi.get(self, "subnet_mappings")

    @subnet_mappings.setter
    def subnet_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerSubnetMappingArgs']]]]):
        pulumi.set(self, "subnet_mappings", value)

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of subnet IDs to attach to the LB. For Load Balancers of type `network` subnets can only be added (see [Availability Zones](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#availability-zones)), deleting a subnet for load balancers of type `network` will force a recreation of the resource.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subnets", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="xffHeaderProcessingMode")
    def xff_header_processing_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines how the load balancer modifies the `X-Forwarded-For` header in the HTTP request before sending the request to the target. The possible values are `append`, `preserve`, and `remove`. Only valid for Load Balancers of type `application`. The default is `append`.

        > **NOTE:** Please note that internal LBs can only use `ipv4` as the `ip_address_type`. You can only change to `dualstack` `ip_address_type` if the selected subnets are IPv6 enabled.

        > **NOTE:** Please note that one of either `subnets` or `subnet_mapping` is required.
        """
        return pulumi.get(self, "xff_header_processing_mode")

    @xff_header_processing_mode.setter
    def xff_header_processing_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xff_header_processing_mode", value)


@pulumi.input_type
class _LoadBalancerState:
    def __init__(__self__, *,
                 access_logs: Optional[pulumi.Input['LoadBalancerAccessLogsArgs']] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 arn_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 client_keep_alive: Optional[pulumi.Input[_builtins.int]] = None,
                 connection_logs: Optional[pulumi.Input['LoadBalancerConnectionLogsArgs']] = None,
                 customer_owned_ipv4_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 desync_mitigation_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_record_client_routing_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 drop_invalid_header_fields: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_cross_zone_load_balancing: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_http2: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_tls_version_and_cipher_suite_headers: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_waf_fail_open: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_xff_client_port: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_zonal_shift: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_security_group_inbound_rules_on_private_link_traffic: Optional[pulumi.Input[_builtins.str]] = None,
                 idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 internal: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_pools: Optional[pulumi.Input['LoadBalancerIpamPoolsArgs']] = None,
                 load_balancer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_load_balancer_capacity: Optional[pulumi.Input['LoadBalancerMinimumLoadBalancerCapacityArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 preserve_host_header: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_ips_auto_assigned_per_subnet: Optional[pulumi.Input[_builtins.int]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subnet_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerSubnetMappingArgs']]]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 xff_header_processing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LoadBalancer resources.
        :param pulumi.Input['LoadBalancerAccessLogsArgs'] access_logs: Access Logs block. See below.
        :param pulumi.Input[_builtins.str] arn: ARN of the load balancer.
        :param pulumi.Input[_builtins.str] arn_suffix: ARN suffix for use with CloudWatch Metrics.
        :param pulumi.Input[_builtins.int] client_keep_alive: Client keep alive value in seconds. The valid range is 60-604800 seconds. The default is 3600 seconds.
        :param pulumi.Input['LoadBalancerConnectionLogsArgs'] connection_logs: Connection Logs block. See below. Only valid for Load Balancers of type `application`.
        :param pulumi.Input[_builtins.str] customer_owned_ipv4_pool: ID of the customer owned ipv4 pool to use for this load balancer.
        :param pulumi.Input[_builtins.str] desync_mitigation_mode: How the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
        :param pulumi.Input[_builtins.str] dns_name: DNS name of the load balancer.
               * `subnet_mapping.*.outpost_id` - ID of the Outpost containing the load balancer.
        :param pulumi.Input[_builtins.str] dns_record_client_routing_policy: How traffic is distributed among the load balancer Availability Zones. Possible values are `any_availability_zone` (default), `availability_zone_affinity`, or `partial_availability_zone_affinity`. See   [Availability Zone DNS affinity](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#zonal-dns-affinity) for additional details. Only valid for `network` type load balancers.
        :param pulumi.Input[_builtins.bool] drop_invalid_header_fields: Whether HTTP headers with header fields that are not valid are removed by the load balancer (true) or routed to targets (false). The default is false. Elastic Load Balancing requires that message header names contain only alphanumeric characters and hyphens. Only valid for Load Balancers of type `application`.
        :param pulumi.Input[_builtins.bool] enable_cross_zone_load_balancing: If true, cross-zone load balancing of the load balancer will be enabled. For `network` and `gateway` type load balancers, this feature is disabled by default (`false`). For `application` load balancer this feature is always enabled (`true`) and cannot be disabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] enable_deletion_protection: If true, deletion of the load balancer will be disabled via the AWS API. This will prevent this provider from deleting the load balancer. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] enable_http2: Whether HTTP/2 is enabled in `application` load balancers. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] enable_tls_version_and_cipher_suite_headers: Whether the two headers (`x-amzn-tls-version` and `x-amzn-tls-cipher-suite`), which contain information about the negotiated TLS version and cipher suite, are added to the client request before sending it to the target. Only valid for Load Balancers of type `application`. Defaults to `false`
        :param pulumi.Input[_builtins.bool] enable_waf_fail_open: Whether to allow a WAF-enabled load balancer to route requests to targets if it is unable to forward the request to AWS WAF. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] enable_xff_client_port: Whether the X-Forwarded-For header should preserve the source port that the client used to connect to the load balancer in `application` load balancers. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] enable_zonal_shift: Whether zonal shift is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.str] enforce_security_group_inbound_rules_on_private_link_traffic: Whether inbound security group rules are enforced for traffic originating from a PrivateLink. Only valid for Load Balancers of type `network`. The possible values are `on` and `off`.
        :param pulumi.Input[_builtins.int] idle_timeout: Time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`. Default: 60.
        :param pulumi.Input[_builtins.bool] internal: If true, the LB will be internal. Defaults to `false`.
        :param pulumi.Input[_builtins.str] ip_address_type: Type of IP addresses used by the subnets for your load balancer. The possible values depend upon the load balancer type: `ipv4` (all load balancer types), `dualstack` (all load balancer types), and `dualstack-without-public-ipv4` (type `application` only).
        :param pulumi.Input['LoadBalancerIpamPoolsArgs'] ipam_pools: . The IPAM pools to use with the load balancer.  Only valid for Load Balancers of type `application`. See ipam_pools for more information.
        :param pulumi.Input[_builtins.str] load_balancer_type: Type of load balancer to create. Possible values are `application`, `gateway`, or `network`. The default value is `application`.
        :param pulumi.Input['LoadBalancerMinimumLoadBalancerCapacityArgs'] minimum_load_balancer_capacity: Minimum capacity for a load balancer. Only valid for Load Balancers of type `application` or `network`.
        :param pulumi.Input[_builtins.str] name: Name of the LB. This name must be unique within your AWS account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen. If not specified, this provider will autogenerate a name beginning with `tf-lb`.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[_builtins.bool] preserve_host_header: Whether the Application Load Balancer should preserve the Host header in the HTTP request and send it to the target without any change. Defaults to `false`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] secondary_ips_auto_assigned_per_subnet: The number of secondary IP addresses to configure for your load balancer nodes. Only valid for Load Balancers of type `network`. The valid range is 0-7. When decreased, this will force a recreation of the resource. Default: `0`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: List of security group IDs to assign to the LB. Only valid for Load Balancers of type `application` or `network`. For load balancers of type `network` security groups cannot be added if none are currently present, and cannot all be removed once added. If either of these conditions are met, this will force a recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerSubnetMappingArgs']]] subnet_mappings: Subnet mapping block. See below. For Load Balancers of type `network` subnet mappings can only be added.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnets: List of subnet IDs to attach to the LB. For Load Balancers of type `network` subnets can only be added (see [Availability Zones](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#availability-zones)), deleting a subnet for load balancers of type `network` will force a recreation of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] xff_header_processing_mode: Determines how the load balancer modifies the `X-Forwarded-For` header in the HTTP request before sending the request to the target. The possible values are `append`, `preserve`, and `remove`. Only valid for Load Balancers of type `application`. The default is `append`.
               
               > **NOTE:** Please note that internal LBs can only use `ipv4` as the `ip_address_type`. You can only change to `dualstack` `ip_address_type` if the selected subnets are IPv6 enabled.
               
               > **NOTE:** Please note that one of either `subnets` or `subnet_mapping` is required.
        :param pulumi.Input[_builtins.str] zone_id: Canonical hosted zone ID of the load balancer (to be used in a Route 53 Alias record).
        """
        if access_logs is not None:
            pulumi.set(__self__, "access_logs", access_logs)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if arn_suffix is not None:
            pulumi.set(__self__, "arn_suffix", arn_suffix)
        if client_keep_alive is not None:
            pulumi.set(__self__, "client_keep_alive", client_keep_alive)
        if connection_logs is not None:
            pulumi.set(__self__, "connection_logs", connection_logs)
        if customer_owned_ipv4_pool is not None:
            pulumi.set(__self__, "customer_owned_ipv4_pool", customer_owned_ipv4_pool)
        if desync_mitigation_mode is not None:
            pulumi.set(__self__, "desync_mitigation_mode", desync_mitigation_mode)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if dns_record_client_routing_policy is not None:
            pulumi.set(__self__, "dns_record_client_routing_policy", dns_record_client_routing_policy)
        if drop_invalid_header_fields is not None:
            pulumi.set(__self__, "drop_invalid_header_fields", drop_invalid_header_fields)
        if enable_cross_zone_load_balancing is not None:
            pulumi.set(__self__, "enable_cross_zone_load_balancing", enable_cross_zone_load_balancing)
        if enable_deletion_protection is not None:
            pulumi.set(__self__, "enable_deletion_protection", enable_deletion_protection)
        if enable_http2 is not None:
            pulumi.set(__self__, "enable_http2", enable_http2)
        if enable_tls_version_and_cipher_suite_headers is not None:
            pulumi.set(__self__, "enable_tls_version_and_cipher_suite_headers", enable_tls_version_and_cipher_suite_headers)
        if enable_waf_fail_open is not None:
            pulumi.set(__self__, "enable_waf_fail_open", enable_waf_fail_open)
        if enable_xff_client_port is not None:
            pulumi.set(__self__, "enable_xff_client_port", enable_xff_client_port)
        if enable_zonal_shift is not None:
            pulumi.set(__self__, "enable_zonal_shift", enable_zonal_shift)
        if enforce_security_group_inbound_rules_on_private_link_traffic is not None:
            pulumi.set(__self__, "enforce_security_group_inbound_rules_on_private_link_traffic", enforce_security_group_inbound_rules_on_private_link_traffic)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if internal is not None:
            pulumi.set(__self__, "internal", internal)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if ipam_pools is not None:
            pulumi.set(__self__, "ipam_pools", ipam_pools)
        if load_balancer_type is not None:
            pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        if minimum_load_balancer_capacity is not None:
            pulumi.set(__self__, "minimum_load_balancer_capacity", minimum_load_balancer_capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if preserve_host_header is not None:
            pulumi.set(__self__, "preserve_host_header", preserve_host_header)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secondary_ips_auto_assigned_per_subnet is not None:
            pulumi.set(__self__, "secondary_ips_auto_assigned_per_subnet", secondary_ips_auto_assigned_per_subnet)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if subnet_mappings is not None:
            pulumi.set(__self__, "subnet_mappings", subnet_mappings)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if xff_header_processing_mode is not None:
            pulumi.set(__self__, "xff_header_processing_mode", xff_header_processing_mode)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="accessLogs")
    def access_logs(self) -> Optional[pulumi.Input['LoadBalancerAccessLogsArgs']]:
        """
        Access Logs block. See below.
        """
        return pulumi.get(self, "access_logs")

    @access_logs.setter
    def access_logs(self, value: Optional[pulumi.Input['LoadBalancerAccessLogsArgs']]):
        pulumi.set(self, "access_logs", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the load balancer.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="arnSuffix")
    def arn_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN suffix for use with CloudWatch Metrics.
        """
        return pulumi.get(self, "arn_suffix")

    @arn_suffix.setter
    def arn_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn_suffix", value)

    @_builtins.property
    @pulumi.getter(name="clientKeepAlive")
    def client_keep_alive(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Client keep alive value in seconds. The valid range is 60-604800 seconds. The default is 3600 seconds.
        """
        return pulumi.get(self, "client_keep_alive")

    @client_keep_alive.setter
    def client_keep_alive(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "client_keep_alive", value)

    @_builtins.property
    @pulumi.getter(name="connectionLogs")
    def connection_logs(self) -> Optional[pulumi.Input['LoadBalancerConnectionLogsArgs']]:
        """
        Connection Logs block. See below. Only valid for Load Balancers of type `application`.
        """
        return pulumi.get(self, "connection_logs")

    @connection_logs.setter
    def connection_logs(self, value: Optional[pulumi.Input['LoadBalancerConnectionLogsArgs']]):
        pulumi.set(self, "connection_logs", value)

    @_builtins.property
    @pulumi.getter(name="customerOwnedIpv4Pool")
    def customer_owned_ipv4_pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the customer owned ipv4 pool to use for this load balancer.
        """
        return pulumi.get(self, "customer_owned_ipv4_pool")

    @customer_owned_ipv4_pool.setter
    def customer_owned_ipv4_pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_owned_ipv4_pool", value)

    @_builtins.property
    @pulumi.getter(name="desyncMitigationMode")
    def desync_mitigation_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
        """
        return pulumi.get(self, "desync_mitigation_mode")

    @desync_mitigation_mode.setter
    def desync_mitigation_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desync_mitigation_mode", value)

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DNS name of the load balancer.
        * `subnet_mapping.*.outpost_id` - ID of the Outpost containing the load balancer.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_name", value)

    @_builtins.property
    @pulumi.getter(name="dnsRecordClientRoutingPolicy")
    def dns_record_client_routing_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How traffic is distributed among the load balancer Availability Zones. Possible values are `any_availability_zone` (default), `availability_zone_affinity`, or `partial_availability_zone_affinity`. See   [Availability Zone DNS affinity](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#zonal-dns-affinity) for additional details. Only valid for `network` type load balancers.
        """
        return pulumi.get(self, "dns_record_client_routing_policy")

    @dns_record_client_routing_policy.setter
    def dns_record_client_routing_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_record_client_routing_policy", value)

    @_builtins.property
    @pulumi.getter(name="dropInvalidHeaderFields")
    def drop_invalid_header_fields(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether HTTP headers with header fields that are not valid are removed by the load balancer (true) or routed to targets (false). The default is false. Elastic Load Balancing requires that message header names contain only alphanumeric characters and hyphens. Only valid for Load Balancers of type `application`.
        """
        return pulumi.get(self, "drop_invalid_header_fields")

    @drop_invalid_header_fields.setter
    def drop_invalid_header_fields(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "drop_invalid_header_fields", value)

    @_builtins.property
    @pulumi.getter(name="enableCrossZoneLoadBalancing")
    def enable_cross_zone_load_balancing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, cross-zone load balancing of the load balancer will be enabled. For `network` and `gateway` type load balancers, this feature is disabled by default (`false`). For `application` load balancer this feature is always enabled (`true`) and cannot be disabled. Defaults to `false`.
        """
        return pulumi.get(self, "enable_cross_zone_load_balancing")

    @enable_cross_zone_load_balancing.setter
    def enable_cross_zone_load_balancing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_cross_zone_load_balancing", value)

    @_builtins.property
    @pulumi.getter(name="enableDeletionProtection")
    def enable_deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, deletion of the load balancer will be disabled via the AWS API. This will prevent this provider from deleting the load balancer. Defaults to `false`.
        """
        return pulumi.get(self, "enable_deletion_protection")

    @enable_deletion_protection.setter
    def enable_deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="enableHttp2")
    def enable_http2(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether HTTP/2 is enabled in `application` load balancers. Defaults to `true`.
        """
        return pulumi.get(self, "enable_http2")

    @enable_http2.setter
    def enable_http2(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_http2", value)

    @_builtins.property
    @pulumi.getter(name="enableTlsVersionAndCipherSuiteHeaders")
    def enable_tls_version_and_cipher_suite_headers(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the two headers (`x-amzn-tls-version` and `x-amzn-tls-cipher-suite`), which contain information about the negotiated TLS version and cipher suite, are added to the client request before sending it to the target. Only valid for Load Balancers of type `application`. Defaults to `false`
        """
        return pulumi.get(self, "enable_tls_version_and_cipher_suite_headers")

    @enable_tls_version_and_cipher_suite_headers.setter
    def enable_tls_version_and_cipher_suite_headers(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_tls_version_and_cipher_suite_headers", value)

    @_builtins.property
    @pulumi.getter(name="enableWafFailOpen")
    def enable_waf_fail_open(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow a WAF-enabled load balancer to route requests to targets if it is unable to forward the request to AWS WAF. Defaults to `false`.
        """
        return pulumi.get(self, "enable_waf_fail_open")

    @enable_waf_fail_open.setter
    def enable_waf_fail_open(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_waf_fail_open", value)

    @_builtins.property
    @pulumi.getter(name="enableXffClientPort")
    def enable_xff_client_port(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the X-Forwarded-For header should preserve the source port that the client used to connect to the load balancer in `application` load balancers. Defaults to `false`.
        """
        return pulumi.get(self, "enable_xff_client_port")

    @enable_xff_client_port.setter
    def enable_xff_client_port(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_xff_client_port", value)

    @_builtins.property
    @pulumi.getter(name="enableZonalShift")
    def enable_zonal_shift(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether zonal shift is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "enable_zonal_shift")

    @enable_zonal_shift.setter
    def enable_zonal_shift(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_zonal_shift", value)

    @_builtins.property
    @pulumi.getter(name="enforceSecurityGroupInboundRulesOnPrivateLinkTraffic")
    def enforce_security_group_inbound_rules_on_private_link_traffic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether inbound security group rules are enforced for traffic originating from a PrivateLink. Only valid for Load Balancers of type `network`. The possible values are `on` and `off`.
        """
        return pulumi.get(self, "enforce_security_group_inbound_rules_on_private_link_traffic")

    @enforce_security_group_inbound_rules_on_private_link_traffic.setter
    def enforce_security_group_inbound_rules_on_private_link_traffic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enforce_security_group_inbound_rules_on_private_link_traffic", value)

    @_builtins.property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`. Default: 60.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "idle_timeout", value)

    @_builtins.property
    @pulumi.getter
    def internal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the LB will be internal. Defaults to `false`.
        """
        return pulumi.get(self, "internal")

    @internal.setter
    def internal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "internal", value)

    @_builtins.property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of IP addresses used by the subnets for your load balancer. The possible values depend upon the load balancer type: `ipv4` (all load balancer types), `dualstack` (all load balancer types), and `dualstack-without-public-ipv4` (type `application` only).
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address_type", value)

    @_builtins.property
    @pulumi.getter(name="ipamPools")
    def ipam_pools(self) -> Optional[pulumi.Input['LoadBalancerIpamPoolsArgs']]:
        """
        . The IPAM pools to use with the load balancer.  Only valid for Load Balancers of type `application`. See ipam_pools for more information.
        """
        return pulumi.get(self, "ipam_pools")

    @ipam_pools.setter
    def ipam_pools(self, value: Optional[pulumi.Input['LoadBalancerIpamPoolsArgs']]):
        pulumi.set(self, "ipam_pools", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of load balancer to create. Possible values are `application`, `gateway`, or `network`. The default value is `application`.
        """
        return pulumi.get(self, "load_balancer_type")

    @load_balancer_type.setter
    def load_balancer_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_type", value)

    @_builtins.property
    @pulumi.getter(name="minimumLoadBalancerCapacity")
    def minimum_load_balancer_capacity(self) -> Optional[pulumi.Input['LoadBalancerMinimumLoadBalancerCapacityArgs']]:
        """
        Minimum capacity for a load balancer. Only valid for Load Balancers of type `application` or `network`.
        """
        return pulumi.get(self, "minimum_load_balancer_capacity")

    @minimum_load_balancer_capacity.setter
    def minimum_load_balancer_capacity(self, value: Optional[pulumi.Input['LoadBalancerMinimumLoadBalancerCapacityArgs']]):
        pulumi.set(self, "minimum_load_balancer_capacity", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the LB. This name must be unique within your AWS account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen. If not specified, this provider will autogenerate a name beginning with `tf-lb`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="preserveHostHeader")
    def preserve_host_header(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the Application Load Balancer should preserve the Host header in the HTTP request and send it to the target without any change. Defaults to `false`.
        """
        return pulumi.get(self, "preserve_host_header")

    @preserve_host_header.setter
    def preserve_host_header(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "preserve_host_header", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secondaryIpsAutoAssignedPerSubnet")
    def secondary_ips_auto_assigned_per_subnet(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of secondary IP addresses to configure for your load balancer nodes. Only valid for Load Balancers of type `network`. The valid range is 0-7. When decreased, this will force a recreation of the resource. Default: `0`.
        """
        return pulumi.get(self, "secondary_ips_auto_assigned_per_subnet")

    @secondary_ips_auto_assigned_per_subnet.setter
    def secondary_ips_auto_assigned_per_subnet(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "secondary_ips_auto_assigned_per_subnet", value)

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of security group IDs to assign to the LB. Only valid for Load Balancers of type `application` or `network`. For load balancers of type `network` security groups cannot be added if none are currently present, and cannot all be removed once added. If either of these conditions are met, this will force a recreation of the resource.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @_builtins.property
    @pulumi.getter(name="subnetMappings")
    def subnet_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerSubnetMappingArgs']]]]:
        """
        Subnet mapping block. See below. For Load Balancers of type `network` subnet mappings can only be added.
        """
        return pulumi.get(self, "subnet_mappings")

    @subnet_mappings.setter
    def subnet_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerSubnetMappingArgs']]]]):
        pulumi.set(self, "subnet_mappings", value)

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of subnet IDs to attach to the LB. For Load Balancers of type `network` subnets can only be added (see [Availability Zones](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#availability-zones)), deleting a subnet for load balancers of type `network` will force a recreation of the resource.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subnets", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="xffHeaderProcessingMode")
    def xff_header_processing_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines how the load balancer modifies the `X-Forwarded-For` header in the HTTP request before sending the request to the target. The possible values are `append`, `preserve`, and `remove`. Only valid for Load Balancers of type `application`. The default is `append`.

        > **NOTE:** Please note that internal LBs can only use `ipv4` as the `ip_address_type`. You can only change to `dualstack` `ip_address_type` if the selected subnets are IPv6 enabled.

        > **NOTE:** Please note that one of either `subnets` or `subnet_mapping` is required.
        """
        return pulumi.get(self, "xff_header_processing_mode")

    @xff_header_processing_mode.setter
    def xff_header_processing_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xff_header_processing_mode", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Canonical hosted zone ID of the load balancer (to be used in a Route 53 Alias record).
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("aws:lb/loadBalancer:LoadBalancer")
class LoadBalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_logs: Optional[pulumi.Input[Union['LoadBalancerAccessLogsArgs', 'LoadBalancerAccessLogsArgsDict']]] = None,
                 client_keep_alive: Optional[pulumi.Input[_builtins.int]] = None,
                 connection_logs: Optional[pulumi.Input[Union['LoadBalancerConnectionLogsArgs', 'LoadBalancerConnectionLogsArgsDict']]] = None,
                 customer_owned_ipv4_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 desync_mitigation_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_record_client_routing_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 drop_invalid_header_fields: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_cross_zone_load_balancing: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_http2: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_tls_version_and_cipher_suite_headers: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_waf_fail_open: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_xff_client_port: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_zonal_shift: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_security_group_inbound_rules_on_private_link_traffic: Optional[pulumi.Input[_builtins.str]] = None,
                 idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 internal: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_pools: Optional[pulumi.Input[Union['LoadBalancerIpamPoolsArgs', 'LoadBalancerIpamPoolsArgsDict']]] = None,
                 load_balancer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_load_balancer_capacity: Optional[pulumi.Input[Union['LoadBalancerMinimumLoadBalancerCapacityArgs', 'LoadBalancerMinimumLoadBalancerCapacityArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 preserve_host_header: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_ips_auto_assigned_per_subnet: Optional[pulumi.Input[_builtins.int]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subnet_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerSubnetMappingArgs', 'LoadBalancerSubnetMappingArgsDict']]]]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 xff_header_processing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Load Balancer resource.

        > **Note:** `alb.LoadBalancer` is known as `lb.LoadBalancer`. The functionality is identical.

        ## Example Usage

        ### Application Load Balancer

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.lb.LoadBalancer("test",
            name="test-lb-tf",
            internal=False,
            load_balancer_type="application",
            security_groups=[lb_sg["id"]],
            subnets=[subnet["id"] for subnet in public],
            enable_deletion_protection=True,
            access_logs={
                "bucket": lb_logs["id"],
                "prefix": "test-lb",
                "enabled": True,
            },
            tags={
                "Environment": "production",
            })
        ```

        ### Network Load Balancer

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.lb.LoadBalancer("test",
            name="test-lb-tf",
            internal=False,
            load_balancer_type="network",
            subnets=[subnet["id"] for subnet in public],
            enable_deletion_protection=True,
            tags={
                "Environment": "production",
            })
        ```

        ### Specifying Elastic IPs

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lb.LoadBalancer("example",
            name="example",
            load_balancer_type="network",
            subnet_mappings=[
                {
                    "subnet_id": example1_aws_subnet["id"],
                    "allocation_id": example1["id"],
                },
                {
                    "subnet_id": example2_aws_subnet["id"],
                    "allocation_id": example2["id"],
                },
            ])
        ```

        ### Specifying private IP addresses for an internal-facing load balancer

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lb.LoadBalancer("example",
            name="example",
            load_balancer_type="network",
            subnet_mappings=[
                {
                    "subnet_id": example1["id"],
                    "private_ipv4_address": "10.0.1.15",
                },
                {
                    "subnet_id": example2["id"],
                    "private_ipv4_address": "10.0.2.15",
                },
            ])
        ```

        ## Import

        ### Identity Schema

        #### Required

        - `arn` (String) Amazon Resource Name (ARN) of the load balancer.

        Using `pulumi import`, import LBs using their ARN. For example:

        console

        % pulumi import aws_lb.bar arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LoadBalancerAccessLogsArgs', 'LoadBalancerAccessLogsArgsDict']] access_logs: Access Logs block. See below.
        :param pulumi.Input[_builtins.int] client_keep_alive: Client keep alive value in seconds. The valid range is 60-604800 seconds. The default is 3600 seconds.
        :param pulumi.Input[Union['LoadBalancerConnectionLogsArgs', 'LoadBalancerConnectionLogsArgsDict']] connection_logs: Connection Logs block. See below. Only valid for Load Balancers of type `application`.
        :param pulumi.Input[_builtins.str] customer_owned_ipv4_pool: ID of the customer owned ipv4 pool to use for this load balancer.
        :param pulumi.Input[_builtins.str] desync_mitigation_mode: How the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
        :param pulumi.Input[_builtins.str] dns_record_client_routing_policy: How traffic is distributed among the load balancer Availability Zones. Possible values are `any_availability_zone` (default), `availability_zone_affinity`, or `partial_availability_zone_affinity`. See   [Availability Zone DNS affinity](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#zonal-dns-affinity) for additional details. Only valid for `network` type load balancers.
        :param pulumi.Input[_builtins.bool] drop_invalid_header_fields: Whether HTTP headers with header fields that are not valid are removed by the load balancer (true) or routed to targets (false). The default is false. Elastic Load Balancing requires that message header names contain only alphanumeric characters and hyphens. Only valid for Load Balancers of type `application`.
        :param pulumi.Input[_builtins.bool] enable_cross_zone_load_balancing: If true, cross-zone load balancing of the load balancer will be enabled. For `network` and `gateway` type load balancers, this feature is disabled by default (`false`). For `application` load balancer this feature is always enabled (`true`) and cannot be disabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] enable_deletion_protection: If true, deletion of the load balancer will be disabled via the AWS API. This will prevent this provider from deleting the load balancer. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] enable_http2: Whether HTTP/2 is enabled in `application` load balancers. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] enable_tls_version_and_cipher_suite_headers: Whether the two headers (`x-amzn-tls-version` and `x-amzn-tls-cipher-suite`), which contain information about the negotiated TLS version and cipher suite, are added to the client request before sending it to the target. Only valid for Load Balancers of type `application`. Defaults to `false`
        :param pulumi.Input[_builtins.bool] enable_waf_fail_open: Whether to allow a WAF-enabled load balancer to route requests to targets if it is unable to forward the request to AWS WAF. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] enable_xff_client_port: Whether the X-Forwarded-For header should preserve the source port that the client used to connect to the load balancer in `application` load balancers. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] enable_zonal_shift: Whether zonal shift is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.str] enforce_security_group_inbound_rules_on_private_link_traffic: Whether inbound security group rules are enforced for traffic originating from a PrivateLink. Only valid for Load Balancers of type `network`. The possible values are `on` and `off`.
        :param pulumi.Input[_builtins.int] idle_timeout: Time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`. Default: 60.
        :param pulumi.Input[_builtins.bool] internal: If true, the LB will be internal. Defaults to `false`.
        :param pulumi.Input[_builtins.str] ip_address_type: Type of IP addresses used by the subnets for your load balancer. The possible values depend upon the load balancer type: `ipv4` (all load balancer types), `dualstack` (all load balancer types), and `dualstack-without-public-ipv4` (type `application` only).
        :param pulumi.Input[Union['LoadBalancerIpamPoolsArgs', 'LoadBalancerIpamPoolsArgsDict']] ipam_pools: . The IPAM pools to use with the load balancer.  Only valid for Load Balancers of type `application`. See ipam_pools for more information.
        :param pulumi.Input[_builtins.str] load_balancer_type: Type of load balancer to create. Possible values are `application`, `gateway`, or `network`. The default value is `application`.
        :param pulumi.Input[Union['LoadBalancerMinimumLoadBalancerCapacityArgs', 'LoadBalancerMinimumLoadBalancerCapacityArgsDict']] minimum_load_balancer_capacity: Minimum capacity for a load balancer. Only valid for Load Balancers of type `application` or `network`.
        :param pulumi.Input[_builtins.str] name: Name of the LB. This name must be unique within your AWS account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen. If not specified, this provider will autogenerate a name beginning with `tf-lb`.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[_builtins.bool] preserve_host_header: Whether the Application Load Balancer should preserve the Host header in the HTTP request and send it to the target without any change. Defaults to `false`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] secondary_ips_auto_assigned_per_subnet: The number of secondary IP addresses to configure for your load balancer nodes. Only valid for Load Balancers of type `network`. The valid range is 0-7. When decreased, this will force a recreation of the resource. Default: `0`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: List of security group IDs to assign to the LB. Only valid for Load Balancers of type `application` or `network`. For load balancers of type `network` security groups cannot be added if none are currently present, and cannot all be removed once added. If either of these conditions are met, this will force a recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerSubnetMappingArgs', 'LoadBalancerSubnetMappingArgsDict']]]] subnet_mappings: Subnet mapping block. See below. For Load Balancers of type `network` subnet mappings can only be added.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnets: List of subnet IDs to attach to the LB. For Load Balancers of type `network` subnets can only be added (see [Availability Zones](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#availability-zones)), deleting a subnet for load balancers of type `network` will force a recreation of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] xff_header_processing_mode: Determines how the load balancer modifies the `X-Forwarded-For` header in the HTTP request before sending the request to the target. The possible values are `append`, `preserve`, and `remove`. Only valid for Load Balancers of type `application`. The default is `append`.
               
               > **NOTE:** Please note that internal LBs can only use `ipv4` as the `ip_address_type`. You can only change to `dualstack` `ip_address_type` if the selected subnets are IPv6 enabled.
               
               > **NOTE:** Please note that one of either `subnets` or `subnet_mapping` is required.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[LoadBalancerArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Load Balancer resource.

        > **Note:** `alb.LoadBalancer` is known as `lb.LoadBalancer`. The functionality is identical.

        ## Example Usage

        ### Application Load Balancer

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.lb.LoadBalancer("test",
            name="test-lb-tf",
            internal=False,
            load_balancer_type="application",
            security_groups=[lb_sg["id"]],
            subnets=[subnet["id"] for subnet in public],
            enable_deletion_protection=True,
            access_logs={
                "bucket": lb_logs["id"],
                "prefix": "test-lb",
                "enabled": True,
            },
            tags={
                "Environment": "production",
            })
        ```

        ### Network Load Balancer

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.lb.LoadBalancer("test",
            name="test-lb-tf",
            internal=False,
            load_balancer_type="network",
            subnets=[subnet["id"] for subnet in public],
            enable_deletion_protection=True,
            tags={
                "Environment": "production",
            })
        ```

        ### Specifying Elastic IPs

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lb.LoadBalancer("example",
            name="example",
            load_balancer_type="network",
            subnet_mappings=[
                {
                    "subnet_id": example1_aws_subnet["id"],
                    "allocation_id": example1["id"],
                },
                {
                    "subnet_id": example2_aws_subnet["id"],
                    "allocation_id": example2["id"],
                },
            ])
        ```

        ### Specifying private IP addresses for an internal-facing load balancer

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lb.LoadBalancer("example",
            name="example",
            load_balancer_type="network",
            subnet_mappings=[
                {
                    "subnet_id": example1["id"],
                    "private_ipv4_address": "10.0.1.15",
                },
                {
                    "subnet_id": example2["id"],
                    "private_ipv4_address": "10.0.2.15",
                },
            ])
        ```

        ## Import

        ### Identity Schema

        #### Required

        - `arn` (String) Amazon Resource Name (ARN) of the load balancer.

        Using `pulumi import`, import LBs using their ARN. For example:

        console

        % pulumi import aws_lb.bar arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188

        :param str resource_name: The name of the resource.
        :param LoadBalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_logs: Optional[pulumi.Input[Union['LoadBalancerAccessLogsArgs', 'LoadBalancerAccessLogsArgsDict']]] = None,
                 client_keep_alive: Optional[pulumi.Input[_builtins.int]] = None,
                 connection_logs: Optional[pulumi.Input[Union['LoadBalancerConnectionLogsArgs', 'LoadBalancerConnectionLogsArgsDict']]] = None,
                 customer_owned_ipv4_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 desync_mitigation_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_record_client_routing_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 drop_invalid_header_fields: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_cross_zone_load_balancing: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_http2: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_tls_version_and_cipher_suite_headers: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_waf_fail_open: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_xff_client_port: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_zonal_shift: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_security_group_inbound_rules_on_private_link_traffic: Optional[pulumi.Input[_builtins.str]] = None,
                 idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 internal: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_pools: Optional[pulumi.Input[Union['LoadBalancerIpamPoolsArgs', 'LoadBalancerIpamPoolsArgsDict']]] = None,
                 load_balancer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 minimum_load_balancer_capacity: Optional[pulumi.Input[Union['LoadBalancerMinimumLoadBalancerCapacityArgs', 'LoadBalancerMinimumLoadBalancerCapacityArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 preserve_host_header: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_ips_auto_assigned_per_subnet: Optional[pulumi.Input[_builtins.int]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subnet_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerSubnetMappingArgs', 'LoadBalancerSubnetMappingArgsDict']]]]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 xff_header_processing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerArgs.__new__(LoadBalancerArgs)

            __props__.__dict__["access_logs"] = access_logs
            __props__.__dict__["client_keep_alive"] = client_keep_alive
            __props__.__dict__["connection_logs"] = connection_logs
            __props__.__dict__["customer_owned_ipv4_pool"] = customer_owned_ipv4_pool
            __props__.__dict__["desync_mitigation_mode"] = desync_mitigation_mode
            __props__.__dict__["dns_record_client_routing_policy"] = dns_record_client_routing_policy
            __props__.__dict__["drop_invalid_header_fields"] = drop_invalid_header_fields
            __props__.__dict__["enable_cross_zone_load_balancing"] = enable_cross_zone_load_balancing
            __props__.__dict__["enable_deletion_protection"] = enable_deletion_protection
            __props__.__dict__["enable_http2"] = enable_http2
            __props__.__dict__["enable_tls_version_and_cipher_suite_headers"] = enable_tls_version_and_cipher_suite_headers
            __props__.__dict__["enable_waf_fail_open"] = enable_waf_fail_open
            __props__.__dict__["enable_xff_client_port"] = enable_xff_client_port
            __props__.__dict__["enable_zonal_shift"] = enable_zonal_shift
            __props__.__dict__["enforce_security_group_inbound_rules_on_private_link_traffic"] = enforce_security_group_inbound_rules_on_private_link_traffic
            __props__.__dict__["idle_timeout"] = idle_timeout
            __props__.__dict__["internal"] = internal
            __props__.__dict__["ip_address_type"] = ip_address_type
            __props__.__dict__["ipam_pools"] = ipam_pools
            __props__.__dict__["load_balancer_type"] = load_balancer_type
            __props__.__dict__["minimum_load_balancer_capacity"] = minimum_load_balancer_capacity
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["preserve_host_header"] = preserve_host_header
            __props__.__dict__["region"] = region
            __props__.__dict__["secondary_ips_auto_assigned_per_subnet"] = secondary_ips_auto_assigned_per_subnet
            __props__.__dict__["security_groups"] = security_groups
            __props__.__dict__["subnet_mappings"] = subnet_mappings
            __props__.__dict__["subnets"] = subnets
            __props__.__dict__["tags"] = tags
            __props__.__dict__["xff_header_processing_mode"] = xff_header_processing_mode
            __props__.__dict__["arn"] = None
            __props__.__dict__["arn_suffix"] = None
            __props__.__dict__["dns_name"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["vpc_id"] = None
            __props__.__dict__["zone_id"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="aws:elasticloadbalancingv2/loadBalancer:LoadBalancer")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(LoadBalancer, __self__).__init__(
            'aws:lb/loadBalancer:LoadBalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_logs: Optional[pulumi.Input[Union['LoadBalancerAccessLogsArgs', 'LoadBalancerAccessLogsArgsDict']]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            arn_suffix: Optional[pulumi.Input[_builtins.str]] = None,
            client_keep_alive: Optional[pulumi.Input[_builtins.int]] = None,
            connection_logs: Optional[pulumi.Input[Union['LoadBalancerConnectionLogsArgs', 'LoadBalancerConnectionLogsArgsDict']]] = None,
            customer_owned_ipv4_pool: Optional[pulumi.Input[_builtins.str]] = None,
            desync_mitigation_mode: Optional[pulumi.Input[_builtins.str]] = None,
            dns_name: Optional[pulumi.Input[_builtins.str]] = None,
            dns_record_client_routing_policy: Optional[pulumi.Input[_builtins.str]] = None,
            drop_invalid_header_fields: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_cross_zone_load_balancing: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_http2: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_tls_version_and_cipher_suite_headers: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_waf_fail_open: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_xff_client_port: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_zonal_shift: Optional[pulumi.Input[_builtins.bool]] = None,
            enforce_security_group_inbound_rules_on_private_link_traffic: Optional[pulumi.Input[_builtins.str]] = None,
            idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            internal: Optional[pulumi.Input[_builtins.bool]] = None,
            ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
            ipam_pools: Optional[pulumi.Input[Union['LoadBalancerIpamPoolsArgs', 'LoadBalancerIpamPoolsArgsDict']]] = None,
            load_balancer_type: Optional[pulumi.Input[_builtins.str]] = None,
            minimum_load_balancer_capacity: Optional[pulumi.Input[Union['LoadBalancerMinimumLoadBalancerCapacityArgs', 'LoadBalancerMinimumLoadBalancerCapacityArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            preserve_host_header: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_ips_auto_assigned_per_subnet: Optional[pulumi.Input[_builtins.int]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            subnet_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerSubnetMappingArgs', 'LoadBalancerSubnetMappingArgsDict']]]]] = None,
            subnets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            xff_header_processing_mode: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'LoadBalancer':
        """
        Get an existing LoadBalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LoadBalancerAccessLogsArgs', 'LoadBalancerAccessLogsArgsDict']] access_logs: Access Logs block. See below.
        :param pulumi.Input[_builtins.str] arn: ARN of the load balancer.
        :param pulumi.Input[_builtins.str] arn_suffix: ARN suffix for use with CloudWatch Metrics.
        :param pulumi.Input[_builtins.int] client_keep_alive: Client keep alive value in seconds. The valid range is 60-604800 seconds. The default is 3600 seconds.
        :param pulumi.Input[Union['LoadBalancerConnectionLogsArgs', 'LoadBalancerConnectionLogsArgsDict']] connection_logs: Connection Logs block. See below. Only valid for Load Balancers of type `application`.
        :param pulumi.Input[_builtins.str] customer_owned_ipv4_pool: ID of the customer owned ipv4 pool to use for this load balancer.
        :param pulumi.Input[_builtins.str] desync_mitigation_mode: How the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
        :param pulumi.Input[_builtins.str] dns_name: DNS name of the load balancer.
               * `subnet_mapping.*.outpost_id` - ID of the Outpost containing the load balancer.
        :param pulumi.Input[_builtins.str] dns_record_client_routing_policy: How traffic is distributed among the load balancer Availability Zones. Possible values are `any_availability_zone` (default), `availability_zone_affinity`, or `partial_availability_zone_affinity`. See   [Availability Zone DNS affinity](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#zonal-dns-affinity) for additional details. Only valid for `network` type load balancers.
        :param pulumi.Input[_builtins.bool] drop_invalid_header_fields: Whether HTTP headers with header fields that are not valid are removed by the load balancer (true) or routed to targets (false). The default is false. Elastic Load Balancing requires that message header names contain only alphanumeric characters and hyphens. Only valid for Load Balancers of type `application`.
        :param pulumi.Input[_builtins.bool] enable_cross_zone_load_balancing: If true, cross-zone load balancing of the load balancer will be enabled. For `network` and `gateway` type load balancers, this feature is disabled by default (`false`). For `application` load balancer this feature is always enabled (`true`) and cannot be disabled. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] enable_deletion_protection: If true, deletion of the load balancer will be disabled via the AWS API. This will prevent this provider from deleting the load balancer. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] enable_http2: Whether HTTP/2 is enabled in `application` load balancers. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] enable_tls_version_and_cipher_suite_headers: Whether the two headers (`x-amzn-tls-version` and `x-amzn-tls-cipher-suite`), which contain information about the negotiated TLS version and cipher suite, are added to the client request before sending it to the target. Only valid for Load Balancers of type `application`. Defaults to `false`
        :param pulumi.Input[_builtins.bool] enable_waf_fail_open: Whether to allow a WAF-enabled load balancer to route requests to targets if it is unable to forward the request to AWS WAF. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] enable_xff_client_port: Whether the X-Forwarded-For header should preserve the source port that the client used to connect to the load balancer in `application` load balancers. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] enable_zonal_shift: Whether zonal shift is enabled. Defaults to `false`.
        :param pulumi.Input[_builtins.str] enforce_security_group_inbound_rules_on_private_link_traffic: Whether inbound security group rules are enforced for traffic originating from a PrivateLink. Only valid for Load Balancers of type `network`. The possible values are `on` and `off`.
        :param pulumi.Input[_builtins.int] idle_timeout: Time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`. Default: 60.
        :param pulumi.Input[_builtins.bool] internal: If true, the LB will be internal. Defaults to `false`.
        :param pulumi.Input[_builtins.str] ip_address_type: Type of IP addresses used by the subnets for your load balancer. The possible values depend upon the load balancer type: `ipv4` (all load balancer types), `dualstack` (all load balancer types), and `dualstack-without-public-ipv4` (type `application` only).
        :param pulumi.Input[Union['LoadBalancerIpamPoolsArgs', 'LoadBalancerIpamPoolsArgsDict']] ipam_pools: . The IPAM pools to use with the load balancer.  Only valid for Load Balancers of type `application`. See ipam_pools for more information.
        :param pulumi.Input[_builtins.str] load_balancer_type: Type of load balancer to create. Possible values are `application`, `gateway`, or `network`. The default value is `application`.
        :param pulumi.Input[Union['LoadBalancerMinimumLoadBalancerCapacityArgs', 'LoadBalancerMinimumLoadBalancerCapacityArgsDict']] minimum_load_balancer_capacity: Minimum capacity for a load balancer. Only valid for Load Balancers of type `application` or `network`.
        :param pulumi.Input[_builtins.str] name: Name of the LB. This name must be unique within your AWS account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen. If not specified, this provider will autogenerate a name beginning with `tf-lb`.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[_builtins.bool] preserve_host_header: Whether the Application Load Balancer should preserve the Host header in the HTTP request and send it to the target without any change. Defaults to `false`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] secondary_ips_auto_assigned_per_subnet: The number of secondary IP addresses to configure for your load balancer nodes. Only valid for Load Balancers of type `network`. The valid range is 0-7. When decreased, this will force a recreation of the resource. Default: `0`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: List of security group IDs to assign to the LB. Only valid for Load Balancers of type `application` or `network`. For load balancers of type `network` security groups cannot be added if none are currently present, and cannot all be removed once added. If either of these conditions are met, this will force a recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerSubnetMappingArgs', 'LoadBalancerSubnetMappingArgsDict']]]] subnet_mappings: Subnet mapping block. See below. For Load Balancers of type `network` subnet mappings can only be added.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnets: List of subnet IDs to attach to the LB. For Load Balancers of type `network` subnets can only be added (see [Availability Zones](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#availability-zones)), deleting a subnet for load balancers of type `network` will force a recreation of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] xff_header_processing_mode: Determines how the load balancer modifies the `X-Forwarded-For` header in the HTTP request before sending the request to the target. The possible values are `append`, `preserve`, and `remove`. Only valid for Load Balancers of type `application`. The default is `append`.
               
               > **NOTE:** Please note that internal LBs can only use `ipv4` as the `ip_address_type`. You can only change to `dualstack` `ip_address_type` if the selected subnets are IPv6 enabled.
               
               > **NOTE:** Please note that one of either `subnets` or `subnet_mapping` is required.
        :param pulumi.Input[_builtins.str] zone_id: Canonical hosted zone ID of the load balancer (to be used in a Route 53 Alias record).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerState.__new__(_LoadBalancerState)

        __props__.__dict__["access_logs"] = access_logs
        __props__.__dict__["arn"] = arn
        __props__.__dict__["arn_suffix"] = arn_suffix
        __props__.__dict__["client_keep_alive"] = client_keep_alive
        __props__.__dict__["connection_logs"] = connection_logs
        __props__.__dict__["customer_owned_ipv4_pool"] = customer_owned_ipv4_pool
        __props__.__dict__["desync_mitigation_mode"] = desync_mitigation_mode
        __props__.__dict__["dns_name"] = dns_name
        __props__.__dict__["dns_record_client_routing_policy"] = dns_record_client_routing_policy
        __props__.__dict__["drop_invalid_header_fields"] = drop_invalid_header_fields
        __props__.__dict__["enable_cross_zone_load_balancing"] = enable_cross_zone_load_balancing
        __props__.__dict__["enable_deletion_protection"] = enable_deletion_protection
        __props__.__dict__["enable_http2"] = enable_http2
        __props__.__dict__["enable_tls_version_and_cipher_suite_headers"] = enable_tls_version_and_cipher_suite_headers
        __props__.__dict__["enable_waf_fail_open"] = enable_waf_fail_open
        __props__.__dict__["enable_xff_client_port"] = enable_xff_client_port
        __props__.__dict__["enable_zonal_shift"] = enable_zonal_shift
        __props__.__dict__["enforce_security_group_inbound_rules_on_private_link_traffic"] = enforce_security_group_inbound_rules_on_private_link_traffic
        __props__.__dict__["idle_timeout"] = idle_timeout
        __props__.__dict__["internal"] = internal
        __props__.__dict__["ip_address_type"] = ip_address_type
        __props__.__dict__["ipam_pools"] = ipam_pools
        __props__.__dict__["load_balancer_type"] = load_balancer_type
        __props__.__dict__["minimum_load_balancer_capacity"] = minimum_load_balancer_capacity
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["preserve_host_header"] = preserve_host_header
        __props__.__dict__["region"] = region
        __props__.__dict__["secondary_ips_auto_assigned_per_subnet"] = secondary_ips_auto_assigned_per_subnet
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["subnet_mappings"] = subnet_mappings
        __props__.__dict__["subnets"] = subnets
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["xff_header_processing_mode"] = xff_header_processing_mode
        __props__.__dict__["zone_id"] = zone_id
        return LoadBalancer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessLogs")
    def access_logs(self) -> pulumi.Output[Optional['outputs.LoadBalancerAccessLogs']]:
        """
        Access Logs block. See below.
        """
        return pulumi.get(self, "access_logs")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the load balancer.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="arnSuffix")
    def arn_suffix(self) -> pulumi.Output[_builtins.str]:
        """
        ARN suffix for use with CloudWatch Metrics.
        """
        return pulumi.get(self, "arn_suffix")

    @_builtins.property
    @pulumi.getter(name="clientKeepAlive")
    def client_keep_alive(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Client keep alive value in seconds. The valid range is 60-604800 seconds. The default is 3600 seconds.
        """
        return pulumi.get(self, "client_keep_alive")

    @_builtins.property
    @pulumi.getter(name="connectionLogs")
    def connection_logs(self) -> pulumi.Output[Optional['outputs.LoadBalancerConnectionLogs']]:
        """
        Connection Logs block. See below. Only valid for Load Balancers of type `application`.
        """
        return pulumi.get(self, "connection_logs")

    @_builtins.property
    @pulumi.getter(name="customerOwnedIpv4Pool")
    def customer_owned_ipv4_pool(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the customer owned ipv4 pool to use for this load balancer.
        """
        return pulumi.get(self, "customer_owned_ipv4_pool")

    @_builtins.property
    @pulumi.getter(name="desyncMitigationMode")
    def desync_mitigation_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        How the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
        """
        return pulumi.get(self, "desync_mitigation_mode")

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[_builtins.str]:
        """
        DNS name of the load balancer.
        * `subnet_mapping.*.outpost_id` - ID of the Outpost containing the load balancer.
        """
        return pulumi.get(self, "dns_name")

    @_builtins.property
    @pulumi.getter(name="dnsRecordClientRoutingPolicy")
    def dns_record_client_routing_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        How traffic is distributed among the load balancer Availability Zones. Possible values are `any_availability_zone` (default), `availability_zone_affinity`, or `partial_availability_zone_affinity`. See   [Availability Zone DNS affinity](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#zonal-dns-affinity) for additional details. Only valid for `network` type load balancers.
        """
        return pulumi.get(self, "dns_record_client_routing_policy")

    @_builtins.property
    @pulumi.getter(name="dropInvalidHeaderFields")
    def drop_invalid_header_fields(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether HTTP headers with header fields that are not valid are removed by the load balancer (true) or routed to targets (false). The default is false. Elastic Load Balancing requires that message header names contain only alphanumeric characters and hyphens. Only valid for Load Balancers of type `application`.
        """
        return pulumi.get(self, "drop_invalid_header_fields")

    @_builtins.property
    @pulumi.getter(name="enableCrossZoneLoadBalancing")
    def enable_cross_zone_load_balancing(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, cross-zone load balancing of the load balancer will be enabled. For `network` and `gateway` type load balancers, this feature is disabled by default (`false`). For `application` load balancer this feature is always enabled (`true`) and cannot be disabled. Defaults to `false`.
        """
        return pulumi.get(self, "enable_cross_zone_load_balancing")

    @_builtins.property
    @pulumi.getter(name="enableDeletionProtection")
    def enable_deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, deletion of the load balancer will be disabled via the AWS API. This will prevent this provider from deleting the load balancer. Defaults to `false`.
        """
        return pulumi.get(self, "enable_deletion_protection")

    @_builtins.property
    @pulumi.getter(name="enableHttp2")
    def enable_http2(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether HTTP/2 is enabled in `application` load balancers. Defaults to `true`.
        """
        return pulumi.get(self, "enable_http2")

    @_builtins.property
    @pulumi.getter(name="enableTlsVersionAndCipherSuiteHeaders")
    def enable_tls_version_and_cipher_suite_headers(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the two headers (`x-amzn-tls-version` and `x-amzn-tls-cipher-suite`), which contain information about the negotiated TLS version and cipher suite, are added to the client request before sending it to the target. Only valid for Load Balancers of type `application`. Defaults to `false`
        """
        return pulumi.get(self, "enable_tls_version_and_cipher_suite_headers")

    @_builtins.property
    @pulumi.getter(name="enableWafFailOpen")
    def enable_waf_fail_open(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to allow a WAF-enabled load balancer to route requests to targets if it is unable to forward the request to AWS WAF. Defaults to `false`.
        """
        return pulumi.get(self, "enable_waf_fail_open")

    @_builtins.property
    @pulumi.getter(name="enableXffClientPort")
    def enable_xff_client_port(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the X-Forwarded-For header should preserve the source port that the client used to connect to the load balancer in `application` load balancers. Defaults to `false`.
        """
        return pulumi.get(self, "enable_xff_client_port")

    @_builtins.property
    @pulumi.getter(name="enableZonalShift")
    def enable_zonal_shift(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether zonal shift is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "enable_zonal_shift")

    @_builtins.property
    @pulumi.getter(name="enforceSecurityGroupInboundRulesOnPrivateLinkTraffic")
    def enforce_security_group_inbound_rules_on_private_link_traffic(self) -> pulumi.Output[_builtins.str]:
        """
        Whether inbound security group rules are enforced for traffic originating from a PrivateLink. Only valid for Load Balancers of type `network`. The possible values are `on` and `off`.
        """
        return pulumi.get(self, "enforce_security_group_inbound_rules_on_private_link_traffic")

    @_builtins.property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`. Default: 60.
        """
        return pulumi.get(self, "idle_timeout")

    @_builtins.property
    @pulumi.getter
    def internal(self) -> pulumi.Output[_builtins.bool]:
        """
        If true, the LB will be internal. Defaults to `false`.
        """
        return pulumi.get(self, "internal")

    @_builtins.property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of IP addresses used by the subnets for your load balancer. The possible values depend upon the load balancer type: `ipv4` (all load balancer types), `dualstack` (all load balancer types), and `dualstack-without-public-ipv4` (type `application` only).
        """
        return pulumi.get(self, "ip_address_type")

    @_builtins.property
    @pulumi.getter(name="ipamPools")
    def ipam_pools(self) -> pulumi.Output[Optional['outputs.LoadBalancerIpamPools']]:
        """
        . The IPAM pools to use with the load balancer.  Only valid for Load Balancers of type `application`. See ipam_pools for more information.
        """
        return pulumi.get(self, "ipam_pools")

    @_builtins.property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Type of load balancer to create. Possible values are `application`, `gateway`, or `network`. The default value is `application`.
        """
        return pulumi.get(self, "load_balancer_type")

    @_builtins.property
    @pulumi.getter(name="minimumLoadBalancerCapacity")
    def minimum_load_balancer_capacity(self) -> pulumi.Output[Optional['outputs.LoadBalancerMinimumLoadBalancerCapacity']]:
        """
        Minimum capacity for a load balancer. Only valid for Load Balancers of type `application` or `network`.
        """
        return pulumi.get(self, "minimum_load_balancer_capacity")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the LB. This name must be unique within your AWS account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen. If not specified, this provider will autogenerate a name beginning with `tf-lb`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @_builtins.property
    @pulumi.getter(name="preserveHostHeader")
    def preserve_host_header(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the Application Load Balancer should preserve the Host header in the HTTP request and send it to the target without any change. Defaults to `false`.
        """
        return pulumi.get(self, "preserve_host_header")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secondaryIpsAutoAssignedPerSubnet")
    def secondary_ips_auto_assigned_per_subnet(self) -> pulumi.Output[_builtins.int]:
        """
        The number of secondary IP addresses to configure for your load balancer nodes. Only valid for Load Balancers of type `network`. The valid range is 0-7. When decreased, this will force a recreation of the resource. Default: `0`.
        """
        return pulumi.get(self, "secondary_ips_auto_assigned_per_subnet")

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of security group IDs to assign to the LB. Only valid for Load Balancers of type `application` or `network`. For load balancers of type `network` security groups cannot be added if none are currently present, and cannot all be removed once added. If either of these conditions are met, this will force a recreation of the resource.
        """
        return pulumi.get(self, "security_groups")

    @_builtins.property
    @pulumi.getter(name="subnetMappings")
    def subnet_mappings(self) -> pulumi.Output[Sequence['outputs.LoadBalancerSubnetMapping']]:
        """
        Subnet mapping block. See below. For Load Balancers of type `network` subnet mappings can only be added.
        """
        return pulumi.get(self, "subnet_mappings")

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of subnet IDs to attach to the LB. For Load Balancers of type `network` subnets can only be added (see [Availability Zones](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#availability-zones)), deleting a subnet for load balancers of type `network` will force a recreation of the resource.
        """
        return pulumi.get(self, "subnets")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="xffHeaderProcessingMode")
    def xff_header_processing_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Determines how the load balancer modifies the `X-Forwarded-For` header in the HTTP request before sending the request to the target. The possible values are `append`, `preserve`, and `remove`. Only valid for Load Balancers of type `application`. The default is `append`.

        > **NOTE:** Please note that internal LBs can only use `ipv4` as the `ip_address_type`. You can only change to `dualstack` `ip_address_type` if the selected subnets are IPv6 enabled.

        > **NOTE:** Please note that one of either `subnets` or `subnet_mapping` is required.
        """
        return pulumi.get(self, "xff_header_processing_mode")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Canonical hosted zone ID of the load balancer (to be used in a Route 53 Alias record).
        """
        return pulumi.get(self, "zone_id")

