# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BotArgs', 'Bot']

@pulumi.input_type
class BotArgs:
    def __init__(__self__, *,
                 abort_statement: pulumi.Input['BotAbortStatementArgs'],
                 child_directed: pulumi.Input[_builtins.bool],
                 intents: pulumi.Input[Sequence[pulumi.Input['BotIntentArgs']]],
                 clarification_prompt: Optional[pulumi.Input['BotClarificationPromptArgs']] = None,
                 create_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detect_sentiment: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_model_improvements: Optional[pulumi.Input[_builtins.bool]] = None,
                 idle_session_ttl_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 locale: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nlu_intent_confidence_threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 process_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 voice_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Bot resource.
        :param pulumi.Input['BotAbortStatementArgs'] abort_statement: The message that Amazon Lex uses to abort a conversation. Attributes are documented under statement.
        :param pulumi.Input[_builtins.bool] child_directed: By specifying true, you confirm that your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. For more information see the [Amazon Lex FAQ](https://aws.amazon.com/lex/faqs#data-security) and the [Amazon Lex PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-childDirected).
        :param pulumi.Input[Sequence[pulumi.Input['BotIntentArgs']]] intents: A set of Intent objects. Each intent represents a command that a user can express. Attributes are documented under intent. Can have up to 250 Intent objects.
        :param pulumi.Input['BotClarificationPromptArgs'] clarification_prompt: The message that Amazon Lex uses when it doesn't understand the user's request. Attributes are documented under prompt.
        :param pulumi.Input[_builtins.bool] create_version: Determines if a new bot version is created when the initial resource is created and on each update. Defaults to `false`.
        :param pulumi.Input[_builtins.str] description: A description of the bot. Must be less than or equal to 200 characters in length.
        :param pulumi.Input[_builtins.bool] detect_sentiment: When set to true user utterances are sent to Amazon Comprehend for sentiment analysis. If you don't specify detectSentiment, the default is `false`.
        :param pulumi.Input[_builtins.bool] enable_model_improvements: Set to `true` to enable access to natural language understanding improvements. When you set the `enable_model_improvements` parameter to true you can use the `nlu_intent_confidence_threshold` parameter to configure confidence scores. For more information, see [Confidence Scores](https://docs.aws.amazon.com/lex/latest/dg/confidence-scores.html). You can only set the `enable_model_improvements` parameter in certain Regions. If you set the parameter to true, your bot has access to accuracy improvements. For more information see the [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-enableModelImprovements).
        :param pulumi.Input[_builtins.int] idle_session_ttl_in_seconds: The maximum time in seconds that Amazon Lex retains the data gathered in a conversation. Default is `300`. Must be a number between 60 and 86400 (inclusive).
        :param pulumi.Input[_builtins.str] locale: Specifies the target locale for the bot. Any intent used in the bot must be compatible with the locale of the bot. For available locales, see [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-locale). Default is `en-US`.
        :param pulumi.Input[_builtins.str] name: The name of the bot that you want to create, case sensitive. Must be between 2 and 50 characters in length.
        :param pulumi.Input[_builtins.float] nlu_intent_confidence_threshold: Determines the threshold where Amazon Lex will insert the AMAZON.FallbackIntent, AMAZON.KendraSearchIntent, or both when returning alternative intents in a PostContent or PostText response. AMAZON.FallbackIntent and AMAZON.KendraSearchIntent are only inserted if they are configured for the bot. For more information see [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-nluIntentConfidenceThreshold) This value requires `enable_model_improvements` to be set to `true` and the default is `0`. Must be a float between 0 and 1.
        :param pulumi.Input[_builtins.str] process_behavior: If you set the `process_behavior` element to `BUILD`, Amazon Lex builds the bot so that it can be run. If you set the element to `SAVE` Amazon Lex saves the bot, but doesn't build it. Default is `SAVE`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] voice_id: The Amazon Polly voice ID that you want Amazon Lex to use for voice interactions with the user. The locale configured for the voice must match the locale of the bot. For more information, see [Available Voices](http://docs.aws.amazon.com/polly/latest/dg/voicelist.html) in the Amazon Polly Developer Guide.
        """
        pulumi.set(__self__, "abort_statement", abort_statement)
        pulumi.set(__self__, "child_directed", child_directed)
        pulumi.set(__self__, "intents", intents)
        if clarification_prompt is not None:
            pulumi.set(__self__, "clarification_prompt", clarification_prompt)
        if create_version is not None:
            pulumi.set(__self__, "create_version", create_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if detect_sentiment is not None:
            pulumi.set(__self__, "detect_sentiment", detect_sentiment)
        if enable_model_improvements is not None:
            pulumi.set(__self__, "enable_model_improvements", enable_model_improvements)
        if idle_session_ttl_in_seconds is not None:
            pulumi.set(__self__, "idle_session_ttl_in_seconds", idle_session_ttl_in_seconds)
        if locale is not None:
            pulumi.set(__self__, "locale", locale)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nlu_intent_confidence_threshold is not None:
            pulumi.set(__self__, "nlu_intent_confidence_threshold", nlu_intent_confidence_threshold)
        if process_behavior is not None:
            pulumi.set(__self__, "process_behavior", process_behavior)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if voice_id is not None:
            pulumi.set(__self__, "voice_id", voice_id)

    @_builtins.property
    @pulumi.getter(name="abortStatement")
    def abort_statement(self) -> pulumi.Input['BotAbortStatementArgs']:
        """
        The message that Amazon Lex uses to abort a conversation. Attributes are documented under statement.
        """
        return pulumi.get(self, "abort_statement")

    @abort_statement.setter
    def abort_statement(self, value: pulumi.Input['BotAbortStatementArgs']):
        pulumi.set(self, "abort_statement", value)

    @_builtins.property
    @pulumi.getter(name="childDirected")
    def child_directed(self) -> pulumi.Input[_builtins.bool]:
        """
        By specifying true, you confirm that your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. For more information see the [Amazon Lex FAQ](https://aws.amazon.com/lex/faqs#data-security) and the [Amazon Lex PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-childDirected).
        """
        return pulumi.get(self, "child_directed")

    @child_directed.setter
    def child_directed(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "child_directed", value)

    @_builtins.property
    @pulumi.getter
    def intents(self) -> pulumi.Input[Sequence[pulumi.Input['BotIntentArgs']]]:
        """
        A set of Intent objects. Each intent represents a command that a user can express. Attributes are documented under intent. Can have up to 250 Intent objects.
        """
        return pulumi.get(self, "intents")

    @intents.setter
    def intents(self, value: pulumi.Input[Sequence[pulumi.Input['BotIntentArgs']]]):
        pulumi.set(self, "intents", value)

    @_builtins.property
    @pulumi.getter(name="clarificationPrompt")
    def clarification_prompt(self) -> Optional[pulumi.Input['BotClarificationPromptArgs']]:
        """
        The message that Amazon Lex uses when it doesn't understand the user's request. Attributes are documented under prompt.
        """
        return pulumi.get(self, "clarification_prompt")

    @clarification_prompt.setter
    def clarification_prompt(self, value: Optional[pulumi.Input['BotClarificationPromptArgs']]):
        pulumi.set(self, "clarification_prompt", value)

    @_builtins.property
    @pulumi.getter(name="createVersion")
    def create_version(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines if a new bot version is created when the initial resource is created and on each update. Defaults to `false`.
        """
        return pulumi.get(self, "create_version")

    @create_version.setter
    def create_version(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "create_version", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the bot. Must be less than or equal to 200 characters in length.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="detectSentiment")
    def detect_sentiment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When set to true user utterances are sent to Amazon Comprehend for sentiment analysis. If you don't specify detectSentiment, the default is `false`.
        """
        return pulumi.get(self, "detect_sentiment")

    @detect_sentiment.setter
    def detect_sentiment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "detect_sentiment", value)

    @_builtins.property
    @pulumi.getter(name="enableModelImprovements")
    def enable_model_improvements(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to `true` to enable access to natural language understanding improvements. When you set the `enable_model_improvements` parameter to true you can use the `nlu_intent_confidence_threshold` parameter to configure confidence scores. For more information, see [Confidence Scores](https://docs.aws.amazon.com/lex/latest/dg/confidence-scores.html). You can only set the `enable_model_improvements` parameter in certain Regions. If you set the parameter to true, your bot has access to accuracy improvements. For more information see the [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-enableModelImprovements).
        """
        return pulumi.get(self, "enable_model_improvements")

    @enable_model_improvements.setter
    def enable_model_improvements(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_model_improvements", value)

    @_builtins.property
    @pulumi.getter(name="idleSessionTtlInSeconds")
    def idle_session_ttl_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum time in seconds that Amazon Lex retains the data gathered in a conversation. Default is `300`. Must be a number between 60 and 86400 (inclusive).
        """
        return pulumi.get(self, "idle_session_ttl_in_seconds")

    @idle_session_ttl_in_seconds.setter
    def idle_session_ttl_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "idle_session_ttl_in_seconds", value)

    @_builtins.property
    @pulumi.getter
    def locale(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the target locale for the bot. Any intent used in the bot must be compatible with the locale of the bot. For available locales, see [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-locale). Default is `en-US`.
        """
        return pulumi.get(self, "locale")

    @locale.setter
    def locale(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locale", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the bot that you want to create, case sensitive. Must be between 2 and 50 characters in length.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nluIntentConfidenceThreshold")
    def nlu_intent_confidence_threshold(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Determines the threshold where Amazon Lex will insert the AMAZON.FallbackIntent, AMAZON.KendraSearchIntent, or both when returning alternative intents in a PostContent or PostText response. AMAZON.FallbackIntent and AMAZON.KendraSearchIntent are only inserted if they are configured for the bot. For more information see [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-nluIntentConfidenceThreshold) This value requires `enable_model_improvements` to be set to `true` and the default is `0`. Must be a float between 0 and 1.
        """
        return pulumi.get(self, "nlu_intent_confidence_threshold")

    @nlu_intent_confidence_threshold.setter
    def nlu_intent_confidence_threshold(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "nlu_intent_confidence_threshold", value)

    @_builtins.property
    @pulumi.getter(name="processBehavior")
    def process_behavior(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If you set the `process_behavior` element to `BUILD`, Amazon Lex builds the bot so that it can be run. If you set the element to `SAVE` Amazon Lex saves the bot, but doesn't build it. Default is `SAVE`.
        """
        return pulumi.get(self, "process_behavior")

    @process_behavior.setter
    def process_behavior(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "process_behavior", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="voiceId")
    def voice_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Polly voice ID that you want Amazon Lex to use for voice interactions with the user. The locale configured for the voice must match the locale of the bot. For more information, see [Available Voices](http://docs.aws.amazon.com/polly/latest/dg/voicelist.html) in the Amazon Polly Developer Guide.
        """
        return pulumi.get(self, "voice_id")

    @voice_id.setter
    def voice_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "voice_id", value)


@pulumi.input_type
class _BotState:
    def __init__(__self__, *,
                 abort_statement: Optional[pulumi.Input['BotAbortStatementArgs']] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 checksum: Optional[pulumi.Input[_builtins.str]] = None,
                 child_directed: Optional[pulumi.Input[_builtins.bool]] = None,
                 clarification_prompt: Optional[pulumi.Input['BotClarificationPromptArgs']] = None,
                 create_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 created_date: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detect_sentiment: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_model_improvements: Optional[pulumi.Input[_builtins.bool]] = None,
                 failure_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 idle_session_ttl_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 intents: Optional[pulumi.Input[Sequence[pulumi.Input['BotIntentArgs']]]] = None,
                 last_updated_date: Optional[pulumi.Input[_builtins.str]] = None,
                 locale: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nlu_intent_confidence_threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 process_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 voice_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Bot resources.
        :param pulumi.Input['BotAbortStatementArgs'] abort_statement: The message that Amazon Lex uses to abort a conversation. Attributes are documented under statement.
        :param pulumi.Input[_builtins.str] checksum: Checksum identifying the version of the bot that was created. The checksum is not
               included as an argument because the resource will add it automatically when updating the bot.
        :param pulumi.Input[_builtins.bool] child_directed: By specifying true, you confirm that your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. For more information see the [Amazon Lex FAQ](https://aws.amazon.com/lex/faqs#data-security) and the [Amazon Lex PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-childDirected).
        :param pulumi.Input['BotClarificationPromptArgs'] clarification_prompt: The message that Amazon Lex uses when it doesn't understand the user's request. Attributes are documented under prompt.
        :param pulumi.Input[_builtins.bool] create_version: Determines if a new bot version is created when the initial resource is created and on each update. Defaults to `false`.
        :param pulumi.Input[_builtins.str] created_date: The date when the bot version was created.
        :param pulumi.Input[_builtins.str] description: A description of the bot. Must be less than or equal to 200 characters in length.
        :param pulumi.Input[_builtins.bool] detect_sentiment: When set to true user utterances are sent to Amazon Comprehend for sentiment analysis. If you don't specify detectSentiment, the default is `false`.
        :param pulumi.Input[_builtins.bool] enable_model_improvements: Set to `true` to enable access to natural language understanding improvements. When you set the `enable_model_improvements` parameter to true you can use the `nlu_intent_confidence_threshold` parameter to configure confidence scores. For more information, see [Confidence Scores](https://docs.aws.amazon.com/lex/latest/dg/confidence-scores.html). You can only set the `enable_model_improvements` parameter in certain Regions. If you set the parameter to true, your bot has access to accuracy improvements. For more information see the [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-enableModelImprovements).
        :param pulumi.Input[_builtins.str] failure_reason: If status is FAILED, Amazon Lex provides the reason that it failed to build the bot.
        :param pulumi.Input[_builtins.int] idle_session_ttl_in_seconds: The maximum time in seconds that Amazon Lex retains the data gathered in a conversation. Default is `300`. Must be a number between 60 and 86400 (inclusive).
        :param pulumi.Input[Sequence[pulumi.Input['BotIntentArgs']]] intents: A set of Intent objects. Each intent represents a command that a user can express. Attributes are documented under intent. Can have up to 250 Intent objects.
        :param pulumi.Input[_builtins.str] last_updated_date: The date when the $LATEST version of this bot was updated.
        :param pulumi.Input[_builtins.str] locale: Specifies the target locale for the bot. Any intent used in the bot must be compatible with the locale of the bot. For available locales, see [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-locale). Default is `en-US`.
        :param pulumi.Input[_builtins.str] name: The name of the bot that you want to create, case sensitive. Must be between 2 and 50 characters in length.
        :param pulumi.Input[_builtins.float] nlu_intent_confidence_threshold: Determines the threshold where Amazon Lex will insert the AMAZON.FallbackIntent, AMAZON.KendraSearchIntent, or both when returning alternative intents in a PostContent or PostText response. AMAZON.FallbackIntent and AMAZON.KendraSearchIntent are only inserted if they are configured for the bot. For more information see [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-nluIntentConfidenceThreshold) This value requires `enable_model_improvements` to be set to `true` and the default is `0`. Must be a float between 0 and 1.
        :param pulumi.Input[_builtins.str] process_behavior: If you set the `process_behavior` element to `BUILD`, Amazon Lex builds the bot so that it can be run. If you set the element to `SAVE` Amazon Lex saves the bot, but doesn't build it. Default is `SAVE`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] status: When you send a request to create or update a bot, Amazon Lex sets the status response
               element to BUILDING. After Amazon Lex builds the bot, it sets status to READY. If Amazon Lex can't
               build the bot, it sets status to FAILED. Amazon Lex returns the reason for the failure in the
               failure_reason response element.
        :param pulumi.Input[_builtins.str] version: The version of the bot.
        :param pulumi.Input[_builtins.str] voice_id: The Amazon Polly voice ID that you want Amazon Lex to use for voice interactions with the user. The locale configured for the voice must match the locale of the bot. For more information, see [Available Voices](http://docs.aws.amazon.com/polly/latest/dg/voicelist.html) in the Amazon Polly Developer Guide.
        """
        if abort_statement is not None:
            pulumi.set(__self__, "abort_statement", abort_statement)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if checksum is not None:
            pulumi.set(__self__, "checksum", checksum)
        if child_directed is not None:
            pulumi.set(__self__, "child_directed", child_directed)
        if clarification_prompt is not None:
            pulumi.set(__self__, "clarification_prompt", clarification_prompt)
        if create_version is not None:
            pulumi.set(__self__, "create_version", create_version)
        if created_date is not None:
            pulumi.set(__self__, "created_date", created_date)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if detect_sentiment is not None:
            pulumi.set(__self__, "detect_sentiment", detect_sentiment)
        if enable_model_improvements is not None:
            pulumi.set(__self__, "enable_model_improvements", enable_model_improvements)
        if failure_reason is not None:
            pulumi.set(__self__, "failure_reason", failure_reason)
        if idle_session_ttl_in_seconds is not None:
            pulumi.set(__self__, "idle_session_ttl_in_seconds", idle_session_ttl_in_seconds)
        if intents is not None:
            pulumi.set(__self__, "intents", intents)
        if last_updated_date is not None:
            pulumi.set(__self__, "last_updated_date", last_updated_date)
        if locale is not None:
            pulumi.set(__self__, "locale", locale)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nlu_intent_confidence_threshold is not None:
            pulumi.set(__self__, "nlu_intent_confidence_threshold", nlu_intent_confidence_threshold)
        if process_behavior is not None:
            pulumi.set(__self__, "process_behavior", process_behavior)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if voice_id is not None:
            pulumi.set(__self__, "voice_id", voice_id)

    @_builtins.property
    @pulumi.getter(name="abortStatement")
    def abort_statement(self) -> Optional[pulumi.Input['BotAbortStatementArgs']]:
        """
        The message that Amazon Lex uses to abort a conversation. Attributes are documented under statement.
        """
        return pulumi.get(self, "abort_statement")

    @abort_statement.setter
    def abort_statement(self, value: Optional[pulumi.Input['BotAbortStatementArgs']]):
        pulumi.set(self, "abort_statement", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def checksum(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Checksum identifying the version of the bot that was created. The checksum is not
        included as an argument because the resource will add it automatically when updating the bot.
        """
        return pulumi.get(self, "checksum")

    @checksum.setter
    def checksum(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "checksum", value)

    @_builtins.property
    @pulumi.getter(name="childDirected")
    def child_directed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        By specifying true, you confirm that your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. For more information see the [Amazon Lex FAQ](https://aws.amazon.com/lex/faqs#data-security) and the [Amazon Lex PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-childDirected).
        """
        return pulumi.get(self, "child_directed")

    @child_directed.setter
    def child_directed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "child_directed", value)

    @_builtins.property
    @pulumi.getter(name="clarificationPrompt")
    def clarification_prompt(self) -> Optional[pulumi.Input['BotClarificationPromptArgs']]:
        """
        The message that Amazon Lex uses when it doesn't understand the user's request. Attributes are documented under prompt.
        """
        return pulumi.get(self, "clarification_prompt")

    @clarification_prompt.setter
    def clarification_prompt(self, value: Optional[pulumi.Input['BotClarificationPromptArgs']]):
        pulumi.set(self, "clarification_prompt", value)

    @_builtins.property
    @pulumi.getter(name="createVersion")
    def create_version(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines if a new bot version is created when the initial resource is created and on each update. Defaults to `false`.
        """
        return pulumi.get(self, "create_version")

    @create_version.setter
    def create_version(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "create_version", value)

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date when the bot version was created.
        """
        return pulumi.get(self, "created_date")

    @created_date.setter
    def created_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_date", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the bot. Must be less than or equal to 200 characters in length.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="detectSentiment")
    def detect_sentiment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When set to true user utterances are sent to Amazon Comprehend for sentiment analysis. If you don't specify detectSentiment, the default is `false`.
        """
        return pulumi.get(self, "detect_sentiment")

    @detect_sentiment.setter
    def detect_sentiment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "detect_sentiment", value)

    @_builtins.property
    @pulumi.getter(name="enableModelImprovements")
    def enable_model_improvements(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to `true` to enable access to natural language understanding improvements. When you set the `enable_model_improvements` parameter to true you can use the `nlu_intent_confidence_threshold` parameter to configure confidence scores. For more information, see [Confidence Scores](https://docs.aws.amazon.com/lex/latest/dg/confidence-scores.html). You can only set the `enable_model_improvements` parameter in certain Regions. If you set the parameter to true, your bot has access to accuracy improvements. For more information see the [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-enableModelImprovements).
        """
        return pulumi.get(self, "enable_model_improvements")

    @enable_model_improvements.setter
    def enable_model_improvements(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_model_improvements", value)

    @_builtins.property
    @pulumi.getter(name="failureReason")
    def failure_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If status is FAILED, Amazon Lex provides the reason that it failed to build the bot.
        """
        return pulumi.get(self, "failure_reason")

    @failure_reason.setter
    def failure_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "failure_reason", value)

    @_builtins.property
    @pulumi.getter(name="idleSessionTtlInSeconds")
    def idle_session_ttl_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum time in seconds that Amazon Lex retains the data gathered in a conversation. Default is `300`. Must be a number between 60 and 86400 (inclusive).
        """
        return pulumi.get(self, "idle_session_ttl_in_seconds")

    @idle_session_ttl_in_seconds.setter
    def idle_session_ttl_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "idle_session_ttl_in_seconds", value)

    @_builtins.property
    @pulumi.getter
    def intents(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BotIntentArgs']]]]:
        """
        A set of Intent objects. Each intent represents a command that a user can express. Attributes are documented under intent. Can have up to 250 Intent objects.
        """
        return pulumi.get(self, "intents")

    @intents.setter
    def intents(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BotIntentArgs']]]]):
        pulumi.set(self, "intents", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedDate")
    def last_updated_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date when the $LATEST version of this bot was updated.
        """
        return pulumi.get(self, "last_updated_date")

    @last_updated_date.setter
    def last_updated_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_date", value)

    @_builtins.property
    @pulumi.getter
    def locale(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the target locale for the bot. Any intent used in the bot must be compatible with the locale of the bot. For available locales, see [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-locale). Default is `en-US`.
        """
        return pulumi.get(self, "locale")

    @locale.setter
    def locale(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locale", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the bot that you want to create, case sensitive. Must be between 2 and 50 characters in length.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nluIntentConfidenceThreshold")
    def nlu_intent_confidence_threshold(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Determines the threshold where Amazon Lex will insert the AMAZON.FallbackIntent, AMAZON.KendraSearchIntent, or both when returning alternative intents in a PostContent or PostText response. AMAZON.FallbackIntent and AMAZON.KendraSearchIntent are only inserted if they are configured for the bot. For more information see [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-nluIntentConfidenceThreshold) This value requires `enable_model_improvements` to be set to `true` and the default is `0`. Must be a float between 0 and 1.
        """
        return pulumi.get(self, "nlu_intent_confidence_threshold")

    @nlu_intent_confidence_threshold.setter
    def nlu_intent_confidence_threshold(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "nlu_intent_confidence_threshold", value)

    @_builtins.property
    @pulumi.getter(name="processBehavior")
    def process_behavior(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If you set the `process_behavior` element to `BUILD`, Amazon Lex builds the bot so that it can be run. If you set the element to `SAVE` Amazon Lex saves the bot, but doesn't build it. Default is `SAVE`.
        """
        return pulumi.get(self, "process_behavior")

    @process_behavior.setter
    def process_behavior(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "process_behavior", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When you send a request to create or update a bot, Amazon Lex sets the status response
        element to BUILDING. After Amazon Lex builds the bot, it sets status to READY. If Amazon Lex can't
        build the bot, it sets status to FAILED. Amazon Lex returns the reason for the failure in the
        failure_reason response element.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the bot.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="voiceId")
    def voice_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Polly voice ID that you want Amazon Lex to use for voice interactions with the user. The locale configured for the voice must match the locale of the bot. For more information, see [Available Voices](http://docs.aws.amazon.com/polly/latest/dg/voicelist.html) in the Amazon Polly Developer Guide.
        """
        return pulumi.get(self, "voice_id")

    @voice_id.setter
    def voice_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "voice_id", value)


@pulumi.type_token("aws:lex/bot:Bot")
class Bot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 abort_statement: Optional[pulumi.Input[Union['BotAbortStatementArgs', 'BotAbortStatementArgsDict']]] = None,
                 child_directed: Optional[pulumi.Input[_builtins.bool]] = None,
                 clarification_prompt: Optional[pulumi.Input[Union['BotClarificationPromptArgs', 'BotClarificationPromptArgsDict']]] = None,
                 create_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detect_sentiment: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_model_improvements: Optional[pulumi.Input[_builtins.bool]] = None,
                 idle_session_ttl_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 intents: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BotIntentArgs', 'BotIntentArgsDict']]]]] = None,
                 locale: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nlu_intent_confidence_threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 process_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 voice_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an Amazon Lex Bot resource. For more information see
        [Amazon Lex: How It Works](https://docs.aws.amazon.com/lex/latest/dg/how-it-works.html)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        order_flowers_bot = aws.lex.Bot("order_flowers_bot",
            abort_statement={
                "messages": [{
                    "content": "Sorry, I am not able to assist at this time",
                    "content_type": "PlainText",
                }],
            },
            child_directed=False,
            clarification_prompt={
                "max_attempts": 2,
                "messages": [{
                    "content": "I didn't understand you, what would you like to do?",
                    "content_type": "PlainText",
                }],
            },
            create_version=False,
            description="Bot to order flowers on the behalf of a user",
            idle_session_ttl_in_seconds=600,
            intents=[{
                "intent_name": "OrderFlowers",
                "intent_version": "1",
            }],
            locale="en-US",
            name="OrderFlowers",
            process_behavior="BUILD",
            voice_id="Salli")
        ```

        ## Import

        Using `pulumi import`, import bots using their name. For example:

        ```sh
        $ pulumi import aws:lex/bot:Bot order_flowers_bot OrderFlowers
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BotAbortStatementArgs', 'BotAbortStatementArgsDict']] abort_statement: The message that Amazon Lex uses to abort a conversation. Attributes are documented under statement.
        :param pulumi.Input[_builtins.bool] child_directed: By specifying true, you confirm that your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. For more information see the [Amazon Lex FAQ](https://aws.amazon.com/lex/faqs#data-security) and the [Amazon Lex PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-childDirected).
        :param pulumi.Input[Union['BotClarificationPromptArgs', 'BotClarificationPromptArgsDict']] clarification_prompt: The message that Amazon Lex uses when it doesn't understand the user's request. Attributes are documented under prompt.
        :param pulumi.Input[_builtins.bool] create_version: Determines if a new bot version is created when the initial resource is created and on each update. Defaults to `false`.
        :param pulumi.Input[_builtins.str] description: A description of the bot. Must be less than or equal to 200 characters in length.
        :param pulumi.Input[_builtins.bool] detect_sentiment: When set to true user utterances are sent to Amazon Comprehend for sentiment analysis. If you don't specify detectSentiment, the default is `false`.
        :param pulumi.Input[_builtins.bool] enable_model_improvements: Set to `true` to enable access to natural language understanding improvements. When you set the `enable_model_improvements` parameter to true you can use the `nlu_intent_confidence_threshold` parameter to configure confidence scores. For more information, see [Confidence Scores](https://docs.aws.amazon.com/lex/latest/dg/confidence-scores.html). You can only set the `enable_model_improvements` parameter in certain Regions. If you set the parameter to true, your bot has access to accuracy improvements. For more information see the [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-enableModelImprovements).
        :param pulumi.Input[_builtins.int] idle_session_ttl_in_seconds: The maximum time in seconds that Amazon Lex retains the data gathered in a conversation. Default is `300`. Must be a number between 60 and 86400 (inclusive).
        :param pulumi.Input[Sequence[pulumi.Input[Union['BotIntentArgs', 'BotIntentArgsDict']]]] intents: A set of Intent objects. Each intent represents a command that a user can express. Attributes are documented under intent. Can have up to 250 Intent objects.
        :param pulumi.Input[_builtins.str] locale: Specifies the target locale for the bot. Any intent used in the bot must be compatible with the locale of the bot. For available locales, see [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-locale). Default is `en-US`.
        :param pulumi.Input[_builtins.str] name: The name of the bot that you want to create, case sensitive. Must be between 2 and 50 characters in length.
        :param pulumi.Input[_builtins.float] nlu_intent_confidence_threshold: Determines the threshold where Amazon Lex will insert the AMAZON.FallbackIntent, AMAZON.KendraSearchIntent, or both when returning alternative intents in a PostContent or PostText response. AMAZON.FallbackIntent and AMAZON.KendraSearchIntent are only inserted if they are configured for the bot. For more information see [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-nluIntentConfidenceThreshold) This value requires `enable_model_improvements` to be set to `true` and the default is `0`. Must be a float between 0 and 1.
        :param pulumi.Input[_builtins.str] process_behavior: If you set the `process_behavior` element to `BUILD`, Amazon Lex builds the bot so that it can be run. If you set the element to `SAVE` Amazon Lex saves the bot, but doesn't build it. Default is `SAVE`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] voice_id: The Amazon Polly voice ID that you want Amazon Lex to use for voice interactions with the user. The locale configured for the voice must match the locale of the bot. For more information, see [Available Voices](http://docs.aws.amazon.com/polly/latest/dg/voicelist.html) in the Amazon Polly Developer Guide.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BotArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Amazon Lex Bot resource. For more information see
        [Amazon Lex: How It Works](https://docs.aws.amazon.com/lex/latest/dg/how-it-works.html)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        order_flowers_bot = aws.lex.Bot("order_flowers_bot",
            abort_statement={
                "messages": [{
                    "content": "Sorry, I am not able to assist at this time",
                    "content_type": "PlainText",
                }],
            },
            child_directed=False,
            clarification_prompt={
                "max_attempts": 2,
                "messages": [{
                    "content": "I didn't understand you, what would you like to do?",
                    "content_type": "PlainText",
                }],
            },
            create_version=False,
            description="Bot to order flowers on the behalf of a user",
            idle_session_ttl_in_seconds=600,
            intents=[{
                "intent_name": "OrderFlowers",
                "intent_version": "1",
            }],
            locale="en-US",
            name="OrderFlowers",
            process_behavior="BUILD",
            voice_id="Salli")
        ```

        ## Import

        Using `pulumi import`, import bots using their name. For example:

        ```sh
        $ pulumi import aws:lex/bot:Bot order_flowers_bot OrderFlowers
        ```

        :param str resource_name: The name of the resource.
        :param BotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 abort_statement: Optional[pulumi.Input[Union['BotAbortStatementArgs', 'BotAbortStatementArgsDict']]] = None,
                 child_directed: Optional[pulumi.Input[_builtins.bool]] = None,
                 clarification_prompt: Optional[pulumi.Input[Union['BotClarificationPromptArgs', 'BotClarificationPromptArgsDict']]] = None,
                 create_version: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 detect_sentiment: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_model_improvements: Optional[pulumi.Input[_builtins.bool]] = None,
                 idle_session_ttl_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 intents: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BotIntentArgs', 'BotIntentArgsDict']]]]] = None,
                 locale: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nlu_intent_confidence_threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 process_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 voice_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BotArgs.__new__(BotArgs)

            if abort_statement is None and not opts.urn:
                raise TypeError("Missing required property 'abort_statement'")
            __props__.__dict__["abort_statement"] = abort_statement
            if child_directed is None and not opts.urn:
                raise TypeError("Missing required property 'child_directed'")
            __props__.__dict__["child_directed"] = child_directed
            __props__.__dict__["clarification_prompt"] = clarification_prompt
            __props__.__dict__["create_version"] = create_version
            __props__.__dict__["description"] = description
            __props__.__dict__["detect_sentiment"] = detect_sentiment
            __props__.__dict__["enable_model_improvements"] = enable_model_improvements
            __props__.__dict__["idle_session_ttl_in_seconds"] = idle_session_ttl_in_seconds
            if intents is None and not opts.urn:
                raise TypeError("Missing required property 'intents'")
            __props__.__dict__["intents"] = intents
            __props__.__dict__["locale"] = locale
            __props__.__dict__["name"] = name
            __props__.__dict__["nlu_intent_confidence_threshold"] = nlu_intent_confidence_threshold
            __props__.__dict__["process_behavior"] = process_behavior
            __props__.__dict__["region"] = region
            __props__.__dict__["voice_id"] = voice_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["checksum"] = None
            __props__.__dict__["created_date"] = None
            __props__.__dict__["failure_reason"] = None
            __props__.__dict__["last_updated_date"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["version"] = None
        super(Bot, __self__).__init__(
            'aws:lex/bot:Bot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            abort_statement: Optional[pulumi.Input[Union['BotAbortStatementArgs', 'BotAbortStatementArgsDict']]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            checksum: Optional[pulumi.Input[_builtins.str]] = None,
            child_directed: Optional[pulumi.Input[_builtins.bool]] = None,
            clarification_prompt: Optional[pulumi.Input[Union['BotClarificationPromptArgs', 'BotClarificationPromptArgsDict']]] = None,
            create_version: Optional[pulumi.Input[_builtins.bool]] = None,
            created_date: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            detect_sentiment: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_model_improvements: Optional[pulumi.Input[_builtins.bool]] = None,
            failure_reason: Optional[pulumi.Input[_builtins.str]] = None,
            idle_session_ttl_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            intents: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BotIntentArgs', 'BotIntentArgsDict']]]]] = None,
            last_updated_date: Optional[pulumi.Input[_builtins.str]] = None,
            locale: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nlu_intent_confidence_threshold: Optional[pulumi.Input[_builtins.float]] = None,
            process_behavior: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            voice_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Bot':
        """
        Get an existing Bot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BotAbortStatementArgs', 'BotAbortStatementArgsDict']] abort_statement: The message that Amazon Lex uses to abort a conversation. Attributes are documented under statement.
        :param pulumi.Input[_builtins.str] checksum: Checksum identifying the version of the bot that was created. The checksum is not
               included as an argument because the resource will add it automatically when updating the bot.
        :param pulumi.Input[_builtins.bool] child_directed: By specifying true, you confirm that your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. For more information see the [Amazon Lex FAQ](https://aws.amazon.com/lex/faqs#data-security) and the [Amazon Lex PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-childDirected).
        :param pulumi.Input[Union['BotClarificationPromptArgs', 'BotClarificationPromptArgsDict']] clarification_prompt: The message that Amazon Lex uses when it doesn't understand the user's request. Attributes are documented under prompt.
        :param pulumi.Input[_builtins.bool] create_version: Determines if a new bot version is created when the initial resource is created and on each update. Defaults to `false`.
        :param pulumi.Input[_builtins.str] created_date: The date when the bot version was created.
        :param pulumi.Input[_builtins.str] description: A description of the bot. Must be less than or equal to 200 characters in length.
        :param pulumi.Input[_builtins.bool] detect_sentiment: When set to true user utterances are sent to Amazon Comprehend for sentiment analysis. If you don't specify detectSentiment, the default is `false`.
        :param pulumi.Input[_builtins.bool] enable_model_improvements: Set to `true` to enable access to natural language understanding improvements. When you set the `enable_model_improvements` parameter to true you can use the `nlu_intent_confidence_threshold` parameter to configure confidence scores. For more information, see [Confidence Scores](https://docs.aws.amazon.com/lex/latest/dg/confidence-scores.html). You can only set the `enable_model_improvements` parameter in certain Regions. If you set the parameter to true, your bot has access to accuracy improvements. For more information see the [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-enableModelImprovements).
        :param pulumi.Input[_builtins.str] failure_reason: If status is FAILED, Amazon Lex provides the reason that it failed to build the bot.
        :param pulumi.Input[_builtins.int] idle_session_ttl_in_seconds: The maximum time in seconds that Amazon Lex retains the data gathered in a conversation. Default is `300`. Must be a number between 60 and 86400 (inclusive).
        :param pulumi.Input[Sequence[pulumi.Input[Union['BotIntentArgs', 'BotIntentArgsDict']]]] intents: A set of Intent objects. Each intent represents a command that a user can express. Attributes are documented under intent. Can have up to 250 Intent objects.
        :param pulumi.Input[_builtins.str] last_updated_date: The date when the $LATEST version of this bot was updated.
        :param pulumi.Input[_builtins.str] locale: Specifies the target locale for the bot. Any intent used in the bot must be compatible with the locale of the bot. For available locales, see [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-locale). Default is `en-US`.
        :param pulumi.Input[_builtins.str] name: The name of the bot that you want to create, case sensitive. Must be between 2 and 50 characters in length.
        :param pulumi.Input[_builtins.float] nlu_intent_confidence_threshold: Determines the threshold where Amazon Lex will insert the AMAZON.FallbackIntent, AMAZON.KendraSearchIntent, or both when returning alternative intents in a PostContent or PostText response. AMAZON.FallbackIntent and AMAZON.KendraSearchIntent are only inserted if they are configured for the bot. For more information see [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-nluIntentConfidenceThreshold) This value requires `enable_model_improvements` to be set to `true` and the default is `0`. Must be a float between 0 and 1.
        :param pulumi.Input[_builtins.str] process_behavior: If you set the `process_behavior` element to `BUILD`, Amazon Lex builds the bot so that it can be run. If you set the element to `SAVE` Amazon Lex saves the bot, but doesn't build it. Default is `SAVE`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] status: When you send a request to create or update a bot, Amazon Lex sets the status response
               element to BUILDING. After Amazon Lex builds the bot, it sets status to READY. If Amazon Lex can't
               build the bot, it sets status to FAILED. Amazon Lex returns the reason for the failure in the
               failure_reason response element.
        :param pulumi.Input[_builtins.str] version: The version of the bot.
        :param pulumi.Input[_builtins.str] voice_id: The Amazon Polly voice ID that you want Amazon Lex to use for voice interactions with the user. The locale configured for the voice must match the locale of the bot. For more information, see [Available Voices](http://docs.aws.amazon.com/polly/latest/dg/voicelist.html) in the Amazon Polly Developer Guide.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BotState.__new__(_BotState)

        __props__.__dict__["abort_statement"] = abort_statement
        __props__.__dict__["arn"] = arn
        __props__.__dict__["checksum"] = checksum
        __props__.__dict__["child_directed"] = child_directed
        __props__.__dict__["clarification_prompt"] = clarification_prompt
        __props__.__dict__["create_version"] = create_version
        __props__.__dict__["created_date"] = created_date
        __props__.__dict__["description"] = description
        __props__.__dict__["detect_sentiment"] = detect_sentiment
        __props__.__dict__["enable_model_improvements"] = enable_model_improvements
        __props__.__dict__["failure_reason"] = failure_reason
        __props__.__dict__["idle_session_ttl_in_seconds"] = idle_session_ttl_in_seconds
        __props__.__dict__["intents"] = intents
        __props__.__dict__["last_updated_date"] = last_updated_date
        __props__.__dict__["locale"] = locale
        __props__.__dict__["name"] = name
        __props__.__dict__["nlu_intent_confidence_threshold"] = nlu_intent_confidence_threshold
        __props__.__dict__["process_behavior"] = process_behavior
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["version"] = version
        __props__.__dict__["voice_id"] = voice_id
        return Bot(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="abortStatement")
    def abort_statement(self) -> pulumi.Output['outputs.BotAbortStatement']:
        """
        The message that Amazon Lex uses to abort a conversation. Attributes are documented under statement.
        """
        return pulumi.get(self, "abort_statement")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def checksum(self) -> pulumi.Output[_builtins.str]:
        """
        Checksum identifying the version of the bot that was created. The checksum is not
        included as an argument because the resource will add it automatically when updating the bot.
        """
        return pulumi.get(self, "checksum")

    @_builtins.property
    @pulumi.getter(name="childDirected")
    def child_directed(self) -> pulumi.Output[_builtins.bool]:
        """
        By specifying true, you confirm that your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. For more information see the [Amazon Lex FAQ](https://aws.amazon.com/lex/faqs#data-security) and the [Amazon Lex PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-childDirected).
        """
        return pulumi.get(self, "child_directed")

    @_builtins.property
    @pulumi.getter(name="clarificationPrompt")
    def clarification_prompt(self) -> pulumi.Output[Optional['outputs.BotClarificationPrompt']]:
        """
        The message that Amazon Lex uses when it doesn't understand the user's request. Attributes are documented under prompt.
        """
        return pulumi.get(self, "clarification_prompt")

    @_builtins.property
    @pulumi.getter(name="createVersion")
    def create_version(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Determines if a new bot version is created when the initial resource is created and on each update. Defaults to `false`.
        """
        return pulumi.get(self, "create_version")

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> pulumi.Output[_builtins.str]:
        """
        The date when the bot version was created.
        """
        return pulumi.get(self, "created_date")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of the bot. Must be less than or equal to 200 characters in length.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="detectSentiment")
    def detect_sentiment(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When set to true user utterances are sent to Amazon Comprehend for sentiment analysis. If you don't specify detectSentiment, the default is `false`.
        """
        return pulumi.get(self, "detect_sentiment")

    @_builtins.property
    @pulumi.getter(name="enableModelImprovements")
    def enable_model_improvements(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to `true` to enable access to natural language understanding improvements. When you set the `enable_model_improvements` parameter to true you can use the `nlu_intent_confidence_threshold` parameter to configure confidence scores. For more information, see [Confidence Scores](https://docs.aws.amazon.com/lex/latest/dg/confidence-scores.html). You can only set the `enable_model_improvements` parameter in certain Regions. If you set the parameter to true, your bot has access to accuracy improvements. For more information see the [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-enableModelImprovements).
        """
        return pulumi.get(self, "enable_model_improvements")

    @_builtins.property
    @pulumi.getter(name="failureReason")
    def failure_reason(self) -> pulumi.Output[_builtins.str]:
        """
        If status is FAILED, Amazon Lex provides the reason that it failed to build the bot.
        """
        return pulumi.get(self, "failure_reason")

    @_builtins.property
    @pulumi.getter(name="idleSessionTtlInSeconds")
    def idle_session_ttl_in_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum time in seconds that Amazon Lex retains the data gathered in a conversation. Default is `300`. Must be a number between 60 and 86400 (inclusive).
        """
        return pulumi.get(self, "idle_session_ttl_in_seconds")

    @_builtins.property
    @pulumi.getter
    def intents(self) -> pulumi.Output[Sequence['outputs.BotIntent']]:
        """
        A set of Intent objects. Each intent represents a command that a user can express. Attributes are documented under intent. Can have up to 250 Intent objects.
        """
        return pulumi.get(self, "intents")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedDate")
    def last_updated_date(self) -> pulumi.Output[_builtins.str]:
        """
        The date when the $LATEST version of this bot was updated.
        """
        return pulumi.get(self, "last_updated_date")

    @_builtins.property
    @pulumi.getter
    def locale(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the target locale for the bot. Any intent used in the bot must be compatible with the locale of the bot. For available locales, see [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-locale). Default is `en-US`.
        """
        return pulumi.get(self, "locale")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the bot that you want to create, case sensitive. Must be between 2 and 50 characters in length.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nluIntentConfidenceThreshold")
    def nlu_intent_confidence_threshold(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        Determines the threshold where Amazon Lex will insert the AMAZON.FallbackIntent, AMAZON.KendraSearchIntent, or both when returning alternative intents in a PostContent or PostText response. AMAZON.FallbackIntent and AMAZON.KendraSearchIntent are only inserted if they are configured for the bot. For more information see [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-nluIntentConfidenceThreshold) This value requires `enable_model_improvements` to be set to `true` and the default is `0`. Must be a float between 0 and 1.
        """
        return pulumi.get(self, "nlu_intent_confidence_threshold")

    @_builtins.property
    @pulumi.getter(name="processBehavior")
    def process_behavior(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If you set the `process_behavior` element to `BUILD`, Amazon Lex builds the bot so that it can be run. If you set the element to `SAVE` Amazon Lex saves the bot, but doesn't build it. Default is `SAVE`.
        """
        return pulumi.get(self, "process_behavior")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        When you send a request to create or update a bot, Amazon Lex sets the status response
        element to BUILDING. After Amazon Lex builds the bot, it sets status to READY. If Amazon Lex can't
        build the bot, it sets status to FAILED. Amazon Lex returns the reason for the failure in the
        failure_reason response element.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the bot.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="voiceId")
    def voice_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Polly voice ID that you want Amazon Lex to use for voice interactions with the user. The locale configured for the voice must match the locale of the bot. For more information, see [Available Voices](http://docs.aws.amazon.com/polly/latest/dg/voicelist.html) in the Amazon Polly Developer Guide.
        """
        return pulumi.get(self, "voice_id")

