# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSlotTypeResult',
    'AwaitableGetSlotTypeResult',
    'get_slot_type',
    'get_slot_type_output',
]

@pulumi.output_type
class GetSlotTypeResult:
    """
    A collection of values returned by getSlotType.
    """
    def __init__(__self__, checksum=None, created_date=None, description=None, enumeration_values=None, id=None, last_updated_date=None, name=None, region=None, value_selection_strategy=None, version=None):
        if checksum and not isinstance(checksum, str):
            raise TypeError("Expected argument 'checksum' to be a str")
        pulumi.set(__self__, "checksum", checksum)
        if created_date and not isinstance(created_date, str):
            raise TypeError("Expected argument 'created_date' to be a str")
        pulumi.set(__self__, "created_date", created_date)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enumeration_values and not isinstance(enumeration_values, list):
            raise TypeError("Expected argument 'enumeration_values' to be a list")
        pulumi.set(__self__, "enumeration_values", enumeration_values)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated_date and not isinstance(last_updated_date, str):
            raise TypeError("Expected argument 'last_updated_date' to be a str")
        pulumi.set(__self__, "last_updated_date", last_updated_date)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if value_selection_strategy and not isinstance(value_selection_strategy, str):
            raise TypeError("Expected argument 'value_selection_strategy' to be a str")
        pulumi.set(__self__, "value_selection_strategy", value_selection_strategy)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def checksum(self) -> _builtins.str:
        """
        Checksum identifying the version of the slot type that was created. The checksum is
        not included as an argument because the resource will add it automatically when updating the slot type.
        """
        return pulumi.get(self, "checksum")

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> _builtins.str:
        """
        Date when the slot type version was created.
        """
        return pulumi.get(self, "created_date")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the slot type.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enumerationValues")
    def enumeration_values(self) -> Sequence['outputs.GetSlotTypeEnumerationValueResult']:
        """
        Set of EnumerationValue objects that defines the values that
        the slot type can take. Each value can have a set of synonyms, which are additional values that help
        train the machine learning model about the values that it resolves for a slot.
        """
        return pulumi.get(self, "enumeration_values")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedDate")
    def last_updated_date(self) -> _builtins.str:
        """
        Date when the $LATEST version of this slot type was updated.
        """
        return pulumi.get(self, "last_updated_date")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the slot type. The name is not case sensitive.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="valueSelectionStrategy")
    def value_selection_strategy(self) -> _builtins.str:
        """
        Determines the slot resolution strategy that Amazon Lex
        uses to return slot type values. `ORIGINAL_VALUE` returns the value entered by the user if the user
        value is similar to the slot value. `TOP_RESOLUTION` returns the first value in the resolution list
        if there is a resolution list for the slot, otherwise null is returned.
        """
        return pulumi.get(self, "value_selection_strategy")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        Version of the slot type.
        """
        return pulumi.get(self, "version")


class AwaitableGetSlotTypeResult(GetSlotTypeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSlotTypeResult(
            checksum=self.checksum,
            created_date=self.created_date,
            description=self.description,
            enumeration_values=self.enumeration_values,
            id=self.id,
            last_updated_date=self.last_updated_date,
            name=self.name,
            region=self.region,
            value_selection_strategy=self.value_selection_strategy,
            version=self.version)


def get_slot_type(name: Optional[_builtins.str] = None,
                  region: Optional[_builtins.str] = None,
                  version: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSlotTypeResult:
    """
    Provides details about a specific Amazon Lex Slot Type.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    flower_types = aws.lex.get_slot_type(name="FlowerTypes",
        version="1")
    ```


    :param _builtins.str name: Name of the slot type. The name is case sensitive.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str version: Version of the slot type.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:lex/getSlotType:getSlotType', __args__, opts=opts, typ=GetSlotTypeResult).value

    return AwaitableGetSlotTypeResult(
        checksum=pulumi.get(__ret__, 'checksum'),
        created_date=pulumi.get(__ret__, 'created_date'),
        description=pulumi.get(__ret__, 'description'),
        enumeration_values=pulumi.get(__ret__, 'enumeration_values'),
        id=pulumi.get(__ret__, 'id'),
        last_updated_date=pulumi.get(__ret__, 'last_updated_date'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        value_selection_strategy=pulumi.get(__ret__, 'value_selection_strategy'),
        version=pulumi.get(__ret__, 'version'))
def get_slot_type_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                         region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         version: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSlotTypeResult]:
    """
    Provides details about a specific Amazon Lex Slot Type.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    flower_types = aws.lex.get_slot_type(name="FlowerTypes",
        version="1")
    ```


    :param _builtins.str name: Name of the slot type. The name is case sensitive.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str version: Version of the slot type.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['version'] = version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:lex/getSlotType:getSlotType', __args__, opts=opts, typ=GetSlotTypeResult)
    return __ret__.apply(lambda __response__: GetSlotTypeResult(
        checksum=pulumi.get(__response__, 'checksum'),
        created_date=pulumi.get(__response__, 'created_date'),
        description=pulumi.get(__response__, 'description'),
        enumeration_values=pulumi.get(__response__, 'enumeration_values'),
        id=pulumi.get(__response__, 'id'),
        last_updated_date=pulumi.get(__response__, 'last_updated_date'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        value_selection_strategy=pulumi.get(__response__, 'value_selection_strategy'),
        version=pulumi.get(__response__, 'version')))
