# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['V2modelsSlotTypeArgs', 'V2modelsSlotType']

@pulumi.input_type
class V2modelsSlotTypeArgs:
    def __init__(__self__, *,
                 bot_id: pulumi.Input[_builtins.str],
                 bot_version: pulumi.Input[_builtins.str],
                 locale_id: pulumi.Input[_builtins.str],
                 composite_slot_type_settings: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotTypeCompositeSlotTypeSettingArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_source_settings: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotTypeExternalSourceSettingArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_slot_type_signature: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 slot_type_values: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotTypeSlotTypeValueArgs']]]] = None,
                 timeouts: Optional[pulumi.Input['V2modelsSlotTypeTimeoutsArgs']] = None,
                 value_selection_setting: Optional[pulumi.Input['V2modelsSlotTypeValueSelectionSettingArgs']] = None):
        """
        The set of arguments for constructing a V2modelsSlotType resource.
        :param pulumi.Input[_builtins.str] bot_id: Identifier of the bot associated with this slot type.
        :param pulumi.Input[_builtins.str] bot_version: Version of the bot associated with this slot type.
        :param pulumi.Input[_builtins.str] locale_id: Identifier of the language and locale where this slot type is used.
               All of the bots, slot types, and slots used by the intent must have the same locale.
        :param pulumi.Input[Sequence[pulumi.Input['V2modelsSlotTypeCompositeSlotTypeSettingArgs']]] composite_slot_type_settings: Specifications for a composite slot type.
               See `composite_slot_type_setting` argument reference below.
        :param pulumi.Input[_builtins.str] description: Description of the slot type.
        :param pulumi.Input[Sequence[pulumi.Input['V2modelsSlotTypeExternalSourceSettingArgs']]] external_source_settings: Type of external information used to create the slot type.
               See `external_source_setting` argument reference below.
        :param pulumi.Input[_builtins.str] name: Name of the slot type.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] parent_slot_type_signature: Built-in slot type used as a parent of this slot type.
               When you define a parent slot type, the new slot type has the configuration of the parent slot type.
               Only `AMAZON.AlphaNumeric` is supported.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['V2modelsSlotTypeSlotTypeValueArgs']]] slot_type_values: List of SlotTypeValue objects that defines the values that the slot type can take.
               Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot.
               See `slot_type_values` argument reference below.
        :param pulumi.Input['V2modelsSlotTypeValueSelectionSettingArgs'] value_selection_setting: Determines the strategy that Amazon Lex uses to select a value from the list of possible values.
               See `value_selection_setting` argument reference below.
        """
        pulumi.set(__self__, "bot_id", bot_id)
        pulumi.set(__self__, "bot_version", bot_version)
        pulumi.set(__self__, "locale_id", locale_id)
        if composite_slot_type_settings is not None:
            pulumi.set(__self__, "composite_slot_type_settings", composite_slot_type_settings)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_source_settings is not None:
            pulumi.set(__self__, "external_source_settings", external_source_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_slot_type_signature is not None:
            pulumi.set(__self__, "parent_slot_type_signature", parent_slot_type_signature)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if slot_type_values is not None:
            pulumi.set(__self__, "slot_type_values", slot_type_values)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if value_selection_setting is not None:
            pulumi.set(__self__, "value_selection_setting", value_selection_setting)

    @_builtins.property
    @pulumi.getter(name="botId")
    def bot_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier of the bot associated with this slot type.
        """
        return pulumi.get(self, "bot_id")

    @bot_id.setter
    def bot_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bot_id", value)

    @_builtins.property
    @pulumi.getter(name="botVersion")
    def bot_version(self) -> pulumi.Input[_builtins.str]:
        """
        Version of the bot associated with this slot type.
        """
        return pulumi.get(self, "bot_version")

    @bot_version.setter
    def bot_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bot_version", value)

    @_builtins.property
    @pulumi.getter(name="localeId")
    def locale_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier of the language and locale where this slot type is used.
        All of the bots, slot types, and slots used by the intent must have the same locale.
        """
        return pulumi.get(self, "locale_id")

    @locale_id.setter
    def locale_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "locale_id", value)

    @_builtins.property
    @pulumi.getter(name="compositeSlotTypeSettings")
    def composite_slot_type_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotTypeCompositeSlotTypeSettingArgs']]]]:
        """
        Specifications for a composite slot type.
        See `composite_slot_type_setting` argument reference below.
        """
        return pulumi.get(self, "composite_slot_type_settings")

    @composite_slot_type_settings.setter
    def composite_slot_type_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotTypeCompositeSlotTypeSettingArgs']]]]):
        pulumi.set(self, "composite_slot_type_settings", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the slot type.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="externalSourceSettings")
    def external_source_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotTypeExternalSourceSettingArgs']]]]:
        """
        Type of external information used to create the slot type.
        See `external_source_setting` argument reference below.
        """
        return pulumi.get(self, "external_source_settings")

    @external_source_settings.setter
    def external_source_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotTypeExternalSourceSettingArgs']]]]):
        pulumi.set(self, "external_source_settings", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the slot type.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parentSlotTypeSignature")
    def parent_slot_type_signature(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Built-in slot type used as a parent of this slot type.
        When you define a parent slot type, the new slot type has the configuration of the parent slot type.
        Only `AMAZON.AlphaNumeric` is supported.
        """
        return pulumi.get(self, "parent_slot_type_signature")

    @parent_slot_type_signature.setter
    def parent_slot_type_signature(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_slot_type_signature", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="slotTypeValues")
    def slot_type_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotTypeSlotTypeValueArgs']]]]:
        """
        List of SlotTypeValue objects that defines the values that the slot type can take.
        Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot.
        See `slot_type_values` argument reference below.
        """
        return pulumi.get(self, "slot_type_values")

    @slot_type_values.setter
    def slot_type_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotTypeSlotTypeValueArgs']]]]):
        pulumi.set(self, "slot_type_values", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['V2modelsSlotTypeTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['V2modelsSlotTypeTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="valueSelectionSetting")
    def value_selection_setting(self) -> Optional[pulumi.Input['V2modelsSlotTypeValueSelectionSettingArgs']]:
        """
        Determines the strategy that Amazon Lex uses to select a value from the list of possible values.
        See `value_selection_setting` argument reference below.
        """
        return pulumi.get(self, "value_selection_setting")

    @value_selection_setting.setter
    def value_selection_setting(self, value: Optional[pulumi.Input['V2modelsSlotTypeValueSelectionSettingArgs']]):
        pulumi.set(self, "value_selection_setting", value)


@pulumi.input_type
class _V2modelsSlotTypeState:
    def __init__(__self__, *,
                 bot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bot_version: Optional[pulumi.Input[_builtins.str]] = None,
                 composite_slot_type_settings: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotTypeCompositeSlotTypeSettingArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_source_settings: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotTypeExternalSourceSettingArgs']]]] = None,
                 locale_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_slot_type_signature: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 slot_type_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slot_type_values: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotTypeSlotTypeValueArgs']]]] = None,
                 timeouts: Optional[pulumi.Input['V2modelsSlotTypeTimeoutsArgs']] = None,
                 value_selection_setting: Optional[pulumi.Input['V2modelsSlotTypeValueSelectionSettingArgs']] = None):
        """
        Input properties used for looking up and filtering V2modelsSlotType resources.
        :param pulumi.Input[_builtins.str] bot_id: Identifier of the bot associated with this slot type.
        :param pulumi.Input[_builtins.str] bot_version: Version of the bot associated with this slot type.
        :param pulumi.Input[Sequence[pulumi.Input['V2modelsSlotTypeCompositeSlotTypeSettingArgs']]] composite_slot_type_settings: Specifications for a composite slot type.
               See `composite_slot_type_setting` argument reference below.
        :param pulumi.Input[_builtins.str] description: Description of the slot type.
        :param pulumi.Input[Sequence[pulumi.Input['V2modelsSlotTypeExternalSourceSettingArgs']]] external_source_settings: Type of external information used to create the slot type.
               See `external_source_setting` argument reference below.
        :param pulumi.Input[_builtins.str] locale_id: Identifier of the language and locale where this slot type is used.
               All of the bots, slot types, and slots used by the intent must have the same locale.
        :param pulumi.Input[_builtins.str] name: Name of the slot type.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] parent_slot_type_signature: Built-in slot type used as a parent of this slot type.
               When you define a parent slot type, the new slot type has the configuration of the parent slot type.
               Only `AMAZON.AlphaNumeric` is supported.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] slot_type_id: Unique identifier for the slot type.
        :param pulumi.Input[Sequence[pulumi.Input['V2modelsSlotTypeSlotTypeValueArgs']]] slot_type_values: List of SlotTypeValue objects that defines the values that the slot type can take.
               Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot.
               See `slot_type_values` argument reference below.
        :param pulumi.Input['V2modelsSlotTypeValueSelectionSettingArgs'] value_selection_setting: Determines the strategy that Amazon Lex uses to select a value from the list of possible values.
               See `value_selection_setting` argument reference below.
        """
        if bot_id is not None:
            pulumi.set(__self__, "bot_id", bot_id)
        if bot_version is not None:
            pulumi.set(__self__, "bot_version", bot_version)
        if composite_slot_type_settings is not None:
            pulumi.set(__self__, "composite_slot_type_settings", composite_slot_type_settings)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_source_settings is not None:
            pulumi.set(__self__, "external_source_settings", external_source_settings)
        if locale_id is not None:
            pulumi.set(__self__, "locale_id", locale_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_slot_type_signature is not None:
            pulumi.set(__self__, "parent_slot_type_signature", parent_slot_type_signature)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if slot_type_id is not None:
            pulumi.set(__self__, "slot_type_id", slot_type_id)
        if slot_type_values is not None:
            pulumi.set(__self__, "slot_type_values", slot_type_values)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if value_selection_setting is not None:
            pulumi.set(__self__, "value_selection_setting", value_selection_setting)

    @_builtins.property
    @pulumi.getter(name="botId")
    def bot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the bot associated with this slot type.
        """
        return pulumi.get(self, "bot_id")

    @bot_id.setter
    def bot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bot_id", value)

    @_builtins.property
    @pulumi.getter(name="botVersion")
    def bot_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the bot associated with this slot type.
        """
        return pulumi.get(self, "bot_version")

    @bot_version.setter
    def bot_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bot_version", value)

    @_builtins.property
    @pulumi.getter(name="compositeSlotTypeSettings")
    def composite_slot_type_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotTypeCompositeSlotTypeSettingArgs']]]]:
        """
        Specifications for a composite slot type.
        See `composite_slot_type_setting` argument reference below.
        """
        return pulumi.get(self, "composite_slot_type_settings")

    @composite_slot_type_settings.setter
    def composite_slot_type_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotTypeCompositeSlotTypeSettingArgs']]]]):
        pulumi.set(self, "composite_slot_type_settings", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the slot type.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="externalSourceSettings")
    def external_source_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotTypeExternalSourceSettingArgs']]]]:
        """
        Type of external information used to create the slot type.
        See `external_source_setting` argument reference below.
        """
        return pulumi.get(self, "external_source_settings")

    @external_source_settings.setter
    def external_source_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotTypeExternalSourceSettingArgs']]]]):
        pulumi.set(self, "external_source_settings", value)

    @_builtins.property
    @pulumi.getter(name="localeId")
    def locale_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the language and locale where this slot type is used.
        All of the bots, slot types, and slots used by the intent must have the same locale.
        """
        return pulumi.get(self, "locale_id")

    @locale_id.setter
    def locale_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locale_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the slot type.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parentSlotTypeSignature")
    def parent_slot_type_signature(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Built-in slot type used as a parent of this slot type.
        When you define a parent slot type, the new slot type has the configuration of the parent slot type.
        Only `AMAZON.AlphaNumeric` is supported.
        """
        return pulumi.get(self, "parent_slot_type_signature")

    @parent_slot_type_signature.setter
    def parent_slot_type_signature(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_slot_type_signature", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="slotTypeId")
    def slot_type_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier for the slot type.
        """
        return pulumi.get(self, "slot_type_id")

    @slot_type_id.setter
    def slot_type_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slot_type_id", value)

    @_builtins.property
    @pulumi.getter(name="slotTypeValues")
    def slot_type_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotTypeSlotTypeValueArgs']]]]:
        """
        List of SlotTypeValue objects that defines the values that the slot type can take.
        Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot.
        See `slot_type_values` argument reference below.
        """
        return pulumi.get(self, "slot_type_values")

    @slot_type_values.setter
    def slot_type_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotTypeSlotTypeValueArgs']]]]):
        pulumi.set(self, "slot_type_values", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['V2modelsSlotTypeTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['V2modelsSlotTypeTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="valueSelectionSetting")
    def value_selection_setting(self) -> Optional[pulumi.Input['V2modelsSlotTypeValueSelectionSettingArgs']]:
        """
        Determines the strategy that Amazon Lex uses to select a value from the list of possible values.
        See `value_selection_setting` argument reference below.
        """
        return pulumi.get(self, "value_selection_setting")

    @value_selection_setting.setter
    def value_selection_setting(self, value: Optional[pulumi.Input['V2modelsSlotTypeValueSelectionSettingArgs']]):
        pulumi.set(self, "value_selection_setting", value)


@pulumi.type_token("aws:lex/v2modelsSlotType:V2modelsSlotType")
class V2modelsSlotType(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bot_version: Optional[pulumi.Input[_builtins.str]] = None,
                 composite_slot_type_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotTypeCompositeSlotTypeSettingArgs', 'V2modelsSlotTypeCompositeSlotTypeSettingArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_source_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotTypeExternalSourceSettingArgs', 'V2modelsSlotTypeExternalSourceSettingArgsDict']]]]] = None,
                 locale_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_slot_type_signature: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 slot_type_values: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotTypeSlotTypeValueArgs', 'V2modelsSlotTypeSlotTypeValueArgsDict']]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['V2modelsSlotTypeTimeoutsArgs', 'V2modelsSlotTypeTimeoutsArgsDict']]] = None,
                 value_selection_setting: Optional[pulumi.Input[Union['V2modelsSlotTypeValueSelectionSettingArgs', 'V2modelsSlotTypeValueSelectionSettingArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Lex V2 Models Slot Type.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lex.V2modelsBot("example",
            name="example",
            idle_session_ttl_in_seconds=60,
            role_arn=example_aws_iam_role["arn"],
            data_privacies=[{
                "child_directed": True,
            }])
        example_v2models_bot_locale = aws.lex.V2modelsBotLocale("example",
            locale_id="en_US",
            bot_id=example.id,
            bot_version="DRAFT",
            n_lu_intent_confidence_threshold=0.7)
        example_v2models_bot_version = aws.lex.V2modelsBotVersion("example",
            bot_id=example.id,
            locale_specification=example_v2models_bot_locale.locale_id.apply(lambda locale_id: {
                locale_id: {
                    "sourceBotVersion": "DRAFT",
                },
            }))
        example_v2models_slot_type = aws.lex.V2modelsSlotType("example",
            bot_id=example.id,
            bot_version=example_v2models_bot_locale.bot_version,
            name="example",
            locale_id=example_v2models_bot_locale.locale_id)
        ```

        ### value_selection_setting Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lex.V2modelsSlotType("example",
            bot_id=example_aws_lexv2models_bot["id"],
            bot_version=example_aws_lexv2models_bot_locale["botVersion"],
            name="example",
            locale_id=example_aws_lexv2models_bot_locale["localeId"],
            value_selection_setting={
                "resolution_strategy": "OriginalValue",
                "advanced_recognition_settings": [{
                    "audio_recognition_strategy": "UseSlotValuesAsCustomVocabulary",
                }],
            },
            slot_type_values=[{
                "sample_values": [{
                    "value": "exampleValue",
                }],
            }])
        ```

        ## Import

        Using `pulumi import`, import Lex V2 Models Slot Type using using a comma-delimited string concatenating `bot_id`, `bot_version`, `locale_id`, and `slot_type_id`. For example:

        ```sh
        $ pulumi import aws:lex/v2modelsSlotType:V2modelsSlotType example bot-1234,DRAFT,en_US,slot_type-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bot_id: Identifier of the bot associated with this slot type.
        :param pulumi.Input[_builtins.str] bot_version: Version of the bot associated with this slot type.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotTypeCompositeSlotTypeSettingArgs', 'V2modelsSlotTypeCompositeSlotTypeSettingArgsDict']]]] composite_slot_type_settings: Specifications for a composite slot type.
               See `composite_slot_type_setting` argument reference below.
        :param pulumi.Input[_builtins.str] description: Description of the slot type.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotTypeExternalSourceSettingArgs', 'V2modelsSlotTypeExternalSourceSettingArgsDict']]]] external_source_settings: Type of external information used to create the slot type.
               See `external_source_setting` argument reference below.
        :param pulumi.Input[_builtins.str] locale_id: Identifier of the language and locale where this slot type is used.
               All of the bots, slot types, and slots used by the intent must have the same locale.
        :param pulumi.Input[_builtins.str] name: Name of the slot type.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] parent_slot_type_signature: Built-in slot type used as a parent of this slot type.
               When you define a parent slot type, the new slot type has the configuration of the parent slot type.
               Only `AMAZON.AlphaNumeric` is supported.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotTypeSlotTypeValueArgs', 'V2modelsSlotTypeSlotTypeValueArgsDict']]]] slot_type_values: List of SlotTypeValue objects that defines the values that the slot type can take.
               Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot.
               See `slot_type_values` argument reference below.
        :param pulumi.Input[Union['V2modelsSlotTypeValueSelectionSettingArgs', 'V2modelsSlotTypeValueSelectionSettingArgsDict']] value_selection_setting: Determines the strategy that Amazon Lex uses to select a value from the list of possible values.
               See `value_selection_setting` argument reference below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: V2modelsSlotTypeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Lex V2 Models Slot Type.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lex.V2modelsBot("example",
            name="example",
            idle_session_ttl_in_seconds=60,
            role_arn=example_aws_iam_role["arn"],
            data_privacies=[{
                "child_directed": True,
            }])
        example_v2models_bot_locale = aws.lex.V2modelsBotLocale("example",
            locale_id="en_US",
            bot_id=example.id,
            bot_version="DRAFT",
            n_lu_intent_confidence_threshold=0.7)
        example_v2models_bot_version = aws.lex.V2modelsBotVersion("example",
            bot_id=example.id,
            locale_specification=example_v2models_bot_locale.locale_id.apply(lambda locale_id: {
                locale_id: {
                    "sourceBotVersion": "DRAFT",
                },
            }))
        example_v2models_slot_type = aws.lex.V2modelsSlotType("example",
            bot_id=example.id,
            bot_version=example_v2models_bot_locale.bot_version,
            name="example",
            locale_id=example_v2models_bot_locale.locale_id)
        ```

        ### value_selection_setting Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lex.V2modelsSlotType("example",
            bot_id=example_aws_lexv2models_bot["id"],
            bot_version=example_aws_lexv2models_bot_locale["botVersion"],
            name="example",
            locale_id=example_aws_lexv2models_bot_locale["localeId"],
            value_selection_setting={
                "resolution_strategy": "OriginalValue",
                "advanced_recognition_settings": [{
                    "audio_recognition_strategy": "UseSlotValuesAsCustomVocabulary",
                }],
            },
            slot_type_values=[{
                "sample_values": [{
                    "value": "exampleValue",
                }],
            }])
        ```

        ## Import

        Using `pulumi import`, import Lex V2 Models Slot Type using using a comma-delimited string concatenating `bot_id`, `bot_version`, `locale_id`, and `slot_type_id`. For example:

        ```sh
        $ pulumi import aws:lex/v2modelsSlotType:V2modelsSlotType example bot-1234,DRAFT,en_US,slot_type-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param V2modelsSlotTypeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(V2modelsSlotTypeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bot_version: Optional[pulumi.Input[_builtins.str]] = None,
                 composite_slot_type_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotTypeCompositeSlotTypeSettingArgs', 'V2modelsSlotTypeCompositeSlotTypeSettingArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 external_source_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotTypeExternalSourceSettingArgs', 'V2modelsSlotTypeExternalSourceSettingArgsDict']]]]] = None,
                 locale_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_slot_type_signature: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 slot_type_values: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotTypeSlotTypeValueArgs', 'V2modelsSlotTypeSlotTypeValueArgsDict']]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['V2modelsSlotTypeTimeoutsArgs', 'V2modelsSlotTypeTimeoutsArgsDict']]] = None,
                 value_selection_setting: Optional[pulumi.Input[Union['V2modelsSlotTypeValueSelectionSettingArgs', 'V2modelsSlotTypeValueSelectionSettingArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = V2modelsSlotTypeArgs.__new__(V2modelsSlotTypeArgs)

            if bot_id is None and not opts.urn:
                raise TypeError("Missing required property 'bot_id'")
            __props__.__dict__["bot_id"] = bot_id
            if bot_version is None and not opts.urn:
                raise TypeError("Missing required property 'bot_version'")
            __props__.__dict__["bot_version"] = bot_version
            __props__.__dict__["composite_slot_type_settings"] = composite_slot_type_settings
            __props__.__dict__["description"] = description
            __props__.__dict__["external_source_settings"] = external_source_settings
            if locale_id is None and not opts.urn:
                raise TypeError("Missing required property 'locale_id'")
            __props__.__dict__["locale_id"] = locale_id
            __props__.__dict__["name"] = name
            __props__.__dict__["parent_slot_type_signature"] = parent_slot_type_signature
            __props__.__dict__["region"] = region
            __props__.__dict__["slot_type_values"] = slot_type_values
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["value_selection_setting"] = value_selection_setting
            __props__.__dict__["slot_type_id"] = None
        super(V2modelsSlotType, __self__).__init__(
            'aws:lex/v2modelsSlotType:V2modelsSlotType',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bot_id: Optional[pulumi.Input[_builtins.str]] = None,
            bot_version: Optional[pulumi.Input[_builtins.str]] = None,
            composite_slot_type_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotTypeCompositeSlotTypeSettingArgs', 'V2modelsSlotTypeCompositeSlotTypeSettingArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            external_source_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotTypeExternalSourceSettingArgs', 'V2modelsSlotTypeExternalSourceSettingArgsDict']]]]] = None,
            locale_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent_slot_type_signature: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            slot_type_id: Optional[pulumi.Input[_builtins.str]] = None,
            slot_type_values: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotTypeSlotTypeValueArgs', 'V2modelsSlotTypeSlotTypeValueArgsDict']]]]] = None,
            timeouts: Optional[pulumi.Input[Union['V2modelsSlotTypeTimeoutsArgs', 'V2modelsSlotTypeTimeoutsArgsDict']]] = None,
            value_selection_setting: Optional[pulumi.Input[Union['V2modelsSlotTypeValueSelectionSettingArgs', 'V2modelsSlotTypeValueSelectionSettingArgsDict']]] = None) -> 'V2modelsSlotType':
        """
        Get an existing V2modelsSlotType resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bot_id: Identifier of the bot associated with this slot type.
        :param pulumi.Input[_builtins.str] bot_version: Version of the bot associated with this slot type.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotTypeCompositeSlotTypeSettingArgs', 'V2modelsSlotTypeCompositeSlotTypeSettingArgsDict']]]] composite_slot_type_settings: Specifications for a composite slot type.
               See `composite_slot_type_setting` argument reference below.
        :param pulumi.Input[_builtins.str] description: Description of the slot type.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotTypeExternalSourceSettingArgs', 'V2modelsSlotTypeExternalSourceSettingArgsDict']]]] external_source_settings: Type of external information used to create the slot type.
               See `external_source_setting` argument reference below.
        :param pulumi.Input[_builtins.str] locale_id: Identifier of the language and locale where this slot type is used.
               All of the bots, slot types, and slots used by the intent must have the same locale.
        :param pulumi.Input[_builtins.str] name: Name of the slot type.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] parent_slot_type_signature: Built-in slot type used as a parent of this slot type.
               When you define a parent slot type, the new slot type has the configuration of the parent slot type.
               Only `AMAZON.AlphaNumeric` is supported.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] slot_type_id: Unique identifier for the slot type.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotTypeSlotTypeValueArgs', 'V2modelsSlotTypeSlotTypeValueArgsDict']]]] slot_type_values: List of SlotTypeValue objects that defines the values that the slot type can take.
               Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot.
               See `slot_type_values` argument reference below.
        :param pulumi.Input[Union['V2modelsSlotTypeValueSelectionSettingArgs', 'V2modelsSlotTypeValueSelectionSettingArgsDict']] value_selection_setting: Determines the strategy that Amazon Lex uses to select a value from the list of possible values.
               See `value_selection_setting` argument reference below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _V2modelsSlotTypeState.__new__(_V2modelsSlotTypeState)

        __props__.__dict__["bot_id"] = bot_id
        __props__.__dict__["bot_version"] = bot_version
        __props__.__dict__["composite_slot_type_settings"] = composite_slot_type_settings
        __props__.__dict__["description"] = description
        __props__.__dict__["external_source_settings"] = external_source_settings
        __props__.__dict__["locale_id"] = locale_id
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_slot_type_signature"] = parent_slot_type_signature
        __props__.__dict__["region"] = region
        __props__.__dict__["slot_type_id"] = slot_type_id
        __props__.__dict__["slot_type_values"] = slot_type_values
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["value_selection_setting"] = value_selection_setting
        return V2modelsSlotType(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="botId")
    def bot_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the bot associated with this slot type.
        """
        return pulumi.get(self, "bot_id")

    @_builtins.property
    @pulumi.getter(name="botVersion")
    def bot_version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of the bot associated with this slot type.
        """
        return pulumi.get(self, "bot_version")

    @_builtins.property
    @pulumi.getter(name="compositeSlotTypeSettings")
    def composite_slot_type_settings(self) -> pulumi.Output[Optional[Sequence['outputs.V2modelsSlotTypeCompositeSlotTypeSetting']]]:
        """
        Specifications for a composite slot type.
        See `composite_slot_type_setting` argument reference below.
        """
        return pulumi.get(self, "composite_slot_type_settings")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the slot type.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="externalSourceSettings")
    def external_source_settings(self) -> pulumi.Output[Optional[Sequence['outputs.V2modelsSlotTypeExternalSourceSetting']]]:
        """
        Type of external information used to create the slot type.
        See `external_source_setting` argument reference below.
        """
        return pulumi.get(self, "external_source_settings")

    @_builtins.property
    @pulumi.getter(name="localeId")
    def locale_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the language and locale where this slot type is used.
        All of the bots, slot types, and slots used by the intent must have the same locale.
        """
        return pulumi.get(self, "locale_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the slot type.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="parentSlotTypeSignature")
    def parent_slot_type_signature(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Built-in slot type used as a parent of this slot type.
        When you define a parent slot type, the new slot type has the configuration of the parent slot type.
        Only `AMAZON.AlphaNumeric` is supported.
        """
        return pulumi.get(self, "parent_slot_type_signature")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="slotTypeId")
    def slot_type_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier for the slot type.
        """
        return pulumi.get(self, "slot_type_id")

    @_builtins.property
    @pulumi.getter(name="slotTypeValues")
    def slot_type_values(self) -> pulumi.Output[Optional[Sequence['outputs.V2modelsSlotTypeSlotTypeValue']]]:
        """
        List of SlotTypeValue objects that defines the values that the slot type can take.
        Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot.
        See `slot_type_values` argument reference below.
        """
        return pulumi.get(self, "slot_type_values")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.V2modelsSlotTypeTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="valueSelectionSetting")
    def value_selection_setting(self) -> pulumi.Output[Optional['outputs.V2modelsSlotTypeValueSelectionSetting']]:
        """
        Determines the strategy that Amazon Lex uses to select a value from the list of possible values.
        See `value_selection_setting` argument reference below.
        """
        return pulumi.get(self, "value_selection_setting")

