# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'CertificateDomainValidationOption',
    'ContainerServiceDeploymentVersionContainer',
    'ContainerServiceDeploymentVersionPublicEndpoint',
    'ContainerServiceDeploymentVersionPublicEndpointHealthCheck',
    'ContainerServicePrivateRegistryAccess',
    'ContainerServicePrivateRegistryAccessEcrImagePullerRole',
    'ContainerServicePublicDomainNames',
    'ContainerServicePublicDomainNamesCertificate',
    'DistributionCacheBehavior',
    'DistributionCacheBehaviorSettings',
    'DistributionCacheBehaviorSettingsForwardedCookies',
    'DistributionCacheBehaviorSettingsForwardedHeaders',
    'DistributionCacheBehaviorSettingsForwardedQueryStrings',
    'DistributionDefaultCacheBehavior',
    'DistributionLocation',
    'DistributionOrigin',
    'InstanceAddOn',
    'InstancePublicPortsPortInfo',
    'LbCertificateDomainValidationRecord',
]

@pulumi.output_type
class CertificateDomainValidationOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "resourceRecordName":
            suggest = "resource_record_name"
        elif key == "resourceRecordType":
            suggest = "resource_record_type"
        elif key == "resourceRecordValue":
            suggest = "resource_record_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateDomainValidationOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateDomainValidationOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateDomainValidationOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[_builtins.str] = None,
                 resource_record_name: Optional[_builtins.str] = None,
                 resource_record_type: Optional[_builtins.str] = None,
                 resource_record_value: Optional[_builtins.str] = None):
        """
        :param _builtins.str domain_name: Domain name for which the certificate should be issued.
        :param _builtins.str resource_record_name: Name of the DNS record to create to validate the certificate.
        :param _builtins.str resource_record_type: Type of DNS record to create to validate the certificate.
        :param _builtins.str resource_record_value: Value of the DNS record to create to validate the certificate.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if resource_record_name is not None:
            pulumi.set(__self__, "resource_record_name", resource_record_name)
        if resource_record_type is not None:
            pulumi.set(__self__, "resource_record_type", resource_record_type)
        if resource_record_value is not None:
            pulumi.set(__self__, "resource_record_value", resource_record_value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[_builtins.str]:
        """
        Domain name for which the certificate should be issued.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="resourceRecordName")
    def resource_record_name(self) -> Optional[_builtins.str]:
        """
        Name of the DNS record to create to validate the certificate.
        """
        return pulumi.get(self, "resource_record_name")

    @_builtins.property
    @pulumi.getter(name="resourceRecordType")
    def resource_record_type(self) -> Optional[_builtins.str]:
        """
        Type of DNS record to create to validate the certificate.
        """
        return pulumi.get(self, "resource_record_type")

    @_builtins.property
    @pulumi.getter(name="resourceRecordValue")
    def resource_record_value(self) -> Optional[_builtins.str]:
        """
        Value of the DNS record to create to validate the certificate.
        """
        return pulumi.get(self, "resource_record_value")


@pulumi.output_type
class ContainerServiceDeploymentVersionContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerServiceDeploymentVersionContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerServiceDeploymentVersionContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerServiceDeploymentVersionContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: _builtins.str,
                 image: _builtins.str,
                 commands: Optional[Sequence[_builtins.str]] = None,
                 environment: Optional[Mapping[str, _builtins.str]] = None,
                 ports: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str container_name: Name of the container.
        :param _builtins.str image: Name of the image used for the container. Container images sourced from your Lightsail container service, that are registered and stored on your service, start with a colon (`:`). For example, `:container-service-1.mystaticwebsite.1`. Container images sourced from a public registry like Docker Hub don't start with a colon. For example, `nginx:latest` or `nginx`.
        :param Sequence[_builtins.str] commands: Launch command for the container. A list of strings.
        :param Mapping[str, _builtins.str] environment: Key-value map of the environment variables of the container.
        :param Mapping[str, _builtins.str] ports: Key-value map of the open firewall ports of the container. Valid values: `HTTP`, `HTTPS`, `TCP`, `UDP`.
        """
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "image", image)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @_builtins.property
    @pulumi.getter(name="containerName")
    def container_name(self) -> _builtins.str:
        """
        Name of the container.
        """
        return pulumi.get(self, "container_name")

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        Name of the image used for the container. Container images sourced from your Lightsail container service, that are registered and stored on your service, start with a colon (`:`). For example, `:container-service-1.mystaticwebsite.1`. Container images sourced from a public registry like Docker Hub don't start with a colon. For example, `nginx:latest` or `nginx`.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[_builtins.str]]:
        """
        Launch command for the container. A list of strings.
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Key-value map of the environment variables of the container.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Key-value map of the open firewall ports of the container. Valid values: `HTTP`, `HTTPS`, `TCP`, `UDP`.
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class ContainerServiceDeploymentVersionPublicEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"
        elif key == "containerPort":
            suggest = "container_port"
        elif key == "healthCheck":
            suggest = "health_check"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerServiceDeploymentVersionPublicEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerServiceDeploymentVersionPublicEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerServiceDeploymentVersionPublicEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: _builtins.str,
                 container_port: _builtins.int,
                 health_check: 'outputs.ContainerServiceDeploymentVersionPublicEndpointHealthCheck'):
        """
        :param _builtins.str container_name: Name of the container for the endpoint.
        :param _builtins.int container_port: Port of the container to which traffic is forwarded to.
        :param 'ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgs' health_check: Configuration block that describes the health check configuration of the container. See below.
        """
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "container_port", container_port)
        pulumi.set(__self__, "health_check", health_check)

    @_builtins.property
    @pulumi.getter(name="containerName")
    def container_name(self) -> _builtins.str:
        """
        Name of the container for the endpoint.
        """
        return pulumi.get(self, "container_name")

    @_builtins.property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> _builtins.int:
        """
        Port of the container to which traffic is forwarded to.
        """
        return pulumi.get(self, "container_port")

    @_builtins.property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> 'outputs.ContainerServiceDeploymentVersionPublicEndpointHealthCheck':
        """
        Configuration block that describes the health check configuration of the container. See below.
        """
        return pulumi.get(self, "health_check")


@pulumi.output_type
class ContainerServiceDeploymentVersionPublicEndpointHealthCheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthyThreshold":
            suggest = "healthy_threshold"
        elif key == "intervalSeconds":
            suggest = "interval_seconds"
        elif key == "successCodes":
            suggest = "success_codes"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"
        elif key == "unhealthyThreshold":
            suggest = "unhealthy_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerServiceDeploymentVersionPublicEndpointHealthCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerServiceDeploymentVersionPublicEndpointHealthCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerServiceDeploymentVersionPublicEndpointHealthCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 healthy_threshold: Optional[_builtins.int] = None,
                 interval_seconds: Optional[_builtins.int] = None,
                 path: Optional[_builtins.str] = None,
                 success_codes: Optional[_builtins.str] = None,
                 timeout_seconds: Optional[_builtins.int] = None,
                 unhealthy_threshold: Optional[_builtins.int] = None):
        """
        :param _builtins.int healthy_threshold: Number of consecutive health check successes required before moving the container to the Healthy state. Defaults to 2.
        :param _builtins.int interval_seconds: Approximate interval, in seconds, between health checks of an individual container. You can specify between 5 and 300 seconds. Defaults to 5.
        :param _builtins.str path: Path on the container on which to perform the health check. Defaults to "/".
        :param _builtins.str success_codes: HTTP codes to use when checking for a successful response from a container. You can specify values between 200 and 499. Defaults to "200-499".
        :param _builtins.int timeout_seconds: Amount of time, in seconds, during which no response means a failed health check. You can specify between 2 and 60 seconds. Defaults to 2.
        :param _builtins.int unhealthy_threshold: Number of consecutive health check failures required before moving the container to the Unhealthy state. Defaults to 2.
        """
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if interval_seconds is not None:
            pulumi.set(__self__, "interval_seconds", interval_seconds)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if success_codes is not None:
            pulumi.set(__self__, "success_codes", success_codes)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @_builtins.property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[_builtins.int]:
        """
        Number of consecutive health check successes required before moving the container to the Healthy state. Defaults to 2.
        """
        return pulumi.get(self, "healthy_threshold")

    @_builtins.property
    @pulumi.getter(name="intervalSeconds")
    def interval_seconds(self) -> Optional[_builtins.int]:
        """
        Approximate interval, in seconds, between health checks of an individual container. You can specify between 5 and 300 seconds. Defaults to 5.
        """
        return pulumi.get(self, "interval_seconds")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path on the container on which to perform the health check. Defaults to "/".
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="successCodes")
    def success_codes(self) -> Optional[_builtins.str]:
        """
        HTTP codes to use when checking for a successful response from a container. You can specify values between 200 and 499. Defaults to "200-499".
        """
        return pulumi.get(self, "success_codes")

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[_builtins.int]:
        """
        Amount of time, in seconds, during which no response means a failed health check. You can specify between 2 and 60 seconds. Defaults to 2.
        """
        return pulumi.get(self, "timeout_seconds")

    @_builtins.property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[_builtins.int]:
        """
        Number of consecutive health check failures required before moving the container to the Unhealthy state. Defaults to 2.
        """
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class ContainerServicePrivateRegistryAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ecrImagePullerRole":
            suggest = "ecr_image_puller_role"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerServicePrivateRegistryAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerServicePrivateRegistryAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerServicePrivateRegistryAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ecr_image_puller_role: Optional['outputs.ContainerServicePrivateRegistryAccessEcrImagePullerRole'] = None):
        """
        :param 'ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgs' ecr_image_puller_role: Configuration to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See below.
        """
        if ecr_image_puller_role is not None:
            pulumi.set(__self__, "ecr_image_puller_role", ecr_image_puller_role)

    @_builtins.property
    @pulumi.getter(name="ecrImagePullerRole")
    def ecr_image_puller_role(self) -> Optional['outputs.ContainerServicePrivateRegistryAccessEcrImagePullerRole']:
        """
        Configuration to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See below.
        """
        return pulumi.get(self, "ecr_image_puller_role")


@pulumi.output_type
class ContainerServicePrivateRegistryAccessEcrImagePullerRole(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isActive":
            suggest = "is_active"
        elif key == "principalArn":
            suggest = "principal_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerServicePrivateRegistryAccessEcrImagePullerRole. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerServicePrivateRegistryAccessEcrImagePullerRole.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerServicePrivateRegistryAccessEcrImagePullerRole.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_active: Optional[_builtins.bool] = None,
                 principal_arn: Optional[_builtins.str] = None):
        """
        :param _builtins.bool is_active: Whether to activate the role. Defaults to `false`.
        :param _builtins.str principal_arn: Principal ARN of the container service. The principal ARN can be used to create a trust relationship between your standard AWS account and your Lightsail container service.
        """
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if principal_arn is not None:
            pulumi.set(__self__, "principal_arn", principal_arn)

    @_builtins.property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[_builtins.bool]:
        """
        Whether to activate the role. Defaults to `false`.
        """
        return pulumi.get(self, "is_active")

    @_builtins.property
    @pulumi.getter(name="principalArn")
    def principal_arn(self) -> Optional[_builtins.str]:
        """
        Principal ARN of the container service. The principal ARN can be used to create a trust relationship between your standard AWS account and your Lightsail container service.
        """
        return pulumi.get(self, "principal_arn")


@pulumi.output_type
class ContainerServicePublicDomainNames(dict):
    def __init__(__self__, *,
                 certificates: Sequence['outputs.ContainerServicePublicDomainNamesCertificate']):
        """
        :param Sequence['ContainerServicePublicDomainNamesCertificateArgs'] certificates: Set of certificate configurations for the public domain names. Each element contains the following attributes:
        """
        pulumi.set(__self__, "certificates", certificates)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Sequence['outputs.ContainerServicePublicDomainNamesCertificate']:
        """
        Set of certificate configurations for the public domain names. Each element contains the following attributes:
        """
        return pulumi.get(self, "certificates")


@pulumi.output_type
class ContainerServicePublicDomainNamesCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateName":
            suggest = "certificate_name"
        elif key == "domainNames":
            suggest = "domain_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerServicePublicDomainNamesCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerServicePublicDomainNamesCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerServicePublicDomainNamesCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_name: _builtins.str,
                 domain_names: Sequence[_builtins.str]):
        """
        :param _builtins.str certificate_name: Name of the certificate.
        :param Sequence[_builtins.str] domain_names: List of domain names for the certificate.
        """
        pulumi.set(__self__, "certificate_name", certificate_name)
        pulumi.set(__self__, "domain_names", domain_names)

    @_builtins.property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> _builtins.str:
        """
        Name of the certificate.
        """
        return pulumi.get(self, "certificate_name")

    @_builtins.property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> Sequence[_builtins.str]:
        """
        List of domain names for the certificate.
        """
        return pulumi.get(self, "domain_names")


@pulumi.output_type
class DistributionCacheBehavior(dict):
    def __init__(__self__, *,
                 behavior: _builtins.str,
                 path: _builtins.str):
        """
        :param _builtins.str behavior: Cache behavior for the specified path. Valid values: `cache`, `dont-cache`.
        :param _builtins.str path: Path to a directory or file to cache, or not cache. Use an asterisk symbol to specify wildcard directories (`path/to/assets/*`), and file types (`*.html`, `*.jpg`, `*.js`). Directories and file paths are case-sensitive.
        """
        pulumi.set(__self__, "behavior", behavior)
        pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def behavior(self) -> _builtins.str:
        """
        Cache behavior for the specified path. Valid values: `cache`, `dont-cache`.
        """
        return pulumi.get(self, "behavior")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path to a directory or file to cache, or not cache. Use an asterisk symbol to specify wildcard directories (`path/to/assets/*`), and file types (`*.html`, `*.jpg`, `*.js`). Directories and file paths are case-sensitive.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class DistributionCacheBehaviorSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedHttpMethods":
            suggest = "allowed_http_methods"
        elif key == "cachedHttpMethods":
            suggest = "cached_http_methods"
        elif key == "defaultTtl":
            suggest = "default_ttl"
        elif key == "forwardedCookies":
            suggest = "forwarded_cookies"
        elif key == "forwardedHeaders":
            suggest = "forwarded_headers"
        elif key == "forwardedQueryStrings":
            suggest = "forwarded_query_strings"
        elif key == "maximumTtl":
            suggest = "maximum_ttl"
        elif key == "minimumTtl":
            suggest = "minimum_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionCacheBehaviorSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionCacheBehaviorSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionCacheBehaviorSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_http_methods: Optional[_builtins.str] = None,
                 cached_http_methods: Optional[_builtins.str] = None,
                 default_ttl: Optional[_builtins.int] = None,
                 forwarded_cookies: Optional['outputs.DistributionCacheBehaviorSettingsForwardedCookies'] = None,
                 forwarded_headers: Optional['outputs.DistributionCacheBehaviorSettingsForwardedHeaders'] = None,
                 forwarded_query_strings: Optional['outputs.DistributionCacheBehaviorSettingsForwardedQueryStrings'] = None,
                 maximum_ttl: Optional[_builtins.int] = None,
                 minimum_ttl: Optional[_builtins.int] = None):
        """
        :param _builtins.str allowed_http_methods: HTTP methods that are processed and forwarded to the distribution's origin.
        :param _builtins.str cached_http_methods: HTTP method responses that are cached by your distribution.
        :param _builtins.int default_ttl: Default amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the content has been updated.
        :param 'DistributionCacheBehaviorSettingsForwardedCookiesArgs' forwarded_cookies: Cookies that are forwarded to the origin. Your content is cached based on the cookies that are forwarded. See below.
        :param 'DistributionCacheBehaviorSettingsForwardedHeadersArgs' forwarded_headers: Headers that are forwarded to the origin. Your content is cached based on the headers that are forwarded. See below.
        :param 'DistributionCacheBehaviorSettingsForwardedQueryStringsArgs' forwarded_query_strings: Query strings that are forwarded to the origin. Your content is cached based on the query strings that are forwarded. See below.
        :param _builtins.int maximum_ttl: Maximum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
        :param _builtins.int minimum_ttl: Minimum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
        """
        if allowed_http_methods is not None:
            pulumi.set(__self__, "allowed_http_methods", allowed_http_methods)
        if cached_http_methods is not None:
            pulumi.set(__self__, "cached_http_methods", cached_http_methods)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if forwarded_cookies is not None:
            pulumi.set(__self__, "forwarded_cookies", forwarded_cookies)
        if forwarded_headers is not None:
            pulumi.set(__self__, "forwarded_headers", forwarded_headers)
        if forwarded_query_strings is not None:
            pulumi.set(__self__, "forwarded_query_strings", forwarded_query_strings)
        if maximum_ttl is not None:
            pulumi.set(__self__, "maximum_ttl", maximum_ttl)
        if minimum_ttl is not None:
            pulumi.set(__self__, "minimum_ttl", minimum_ttl)

    @_builtins.property
    @pulumi.getter(name="allowedHttpMethods")
    def allowed_http_methods(self) -> Optional[_builtins.str]:
        """
        HTTP methods that are processed and forwarded to the distribution's origin.
        """
        return pulumi.get(self, "allowed_http_methods")

    @_builtins.property
    @pulumi.getter(name="cachedHttpMethods")
    def cached_http_methods(self) -> Optional[_builtins.str]:
        """
        HTTP method responses that are cached by your distribution.
        """
        return pulumi.get(self, "cached_http_methods")

    @_builtins.property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[_builtins.int]:
        """
        Default amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the content has been updated.
        """
        return pulumi.get(self, "default_ttl")

    @_builtins.property
    @pulumi.getter(name="forwardedCookies")
    def forwarded_cookies(self) -> Optional['outputs.DistributionCacheBehaviorSettingsForwardedCookies']:
        """
        Cookies that are forwarded to the origin. Your content is cached based on the cookies that are forwarded. See below.
        """
        return pulumi.get(self, "forwarded_cookies")

    @_builtins.property
    @pulumi.getter(name="forwardedHeaders")
    def forwarded_headers(self) -> Optional['outputs.DistributionCacheBehaviorSettingsForwardedHeaders']:
        """
        Headers that are forwarded to the origin. Your content is cached based on the headers that are forwarded. See below.
        """
        return pulumi.get(self, "forwarded_headers")

    @_builtins.property
    @pulumi.getter(name="forwardedQueryStrings")
    def forwarded_query_strings(self) -> Optional['outputs.DistributionCacheBehaviorSettingsForwardedQueryStrings']:
        """
        Query strings that are forwarded to the origin. Your content is cached based on the query strings that are forwarded. See below.
        """
        return pulumi.get(self, "forwarded_query_strings")

    @_builtins.property
    @pulumi.getter(name="maximumTtl")
    def maximum_ttl(self) -> Optional[_builtins.int]:
        """
        Maximum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
        """
        return pulumi.get(self, "maximum_ttl")

    @_builtins.property
    @pulumi.getter(name="minimumTtl")
    def minimum_ttl(self) -> Optional[_builtins.int]:
        """
        Minimum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
        """
        return pulumi.get(self, "minimum_ttl")


@pulumi.output_type
class DistributionCacheBehaviorSettingsForwardedCookies(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookiesAllowLists":
            suggest = "cookies_allow_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionCacheBehaviorSettingsForwardedCookies. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionCacheBehaviorSettingsForwardedCookies.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionCacheBehaviorSettingsForwardedCookies.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cookies_allow_lists: Optional[Sequence[_builtins.str]] = None,
                 option: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] cookies_allow_lists: Specific cookies to forward to your distribution's origin.
        :param _builtins.str option: Which cookies to forward to the distribution's origin for a cache behavior. Valid values: `all`, `none`, `allow-list`.
        """
        if cookies_allow_lists is not None:
            pulumi.set(__self__, "cookies_allow_lists", cookies_allow_lists)
        if option is not None:
            pulumi.set(__self__, "option", option)

    @_builtins.property
    @pulumi.getter(name="cookiesAllowLists")
    def cookies_allow_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specific cookies to forward to your distribution's origin.
        """
        return pulumi.get(self, "cookies_allow_lists")

    @_builtins.property
    @pulumi.getter
    def option(self) -> Optional[_builtins.str]:
        """
        Which cookies to forward to the distribution's origin for a cache behavior. Valid values: `all`, `none`, `allow-list`.
        """
        return pulumi.get(self, "option")


@pulumi.output_type
class DistributionCacheBehaviorSettingsForwardedHeaders(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headersAllowLists":
            suggest = "headers_allow_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionCacheBehaviorSettingsForwardedHeaders. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionCacheBehaviorSettingsForwardedHeaders.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionCacheBehaviorSettingsForwardedHeaders.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 headers_allow_lists: Optional[Sequence[_builtins.str]] = None,
                 option: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] headers_allow_lists: Specific headers to forward to your distribution's origin.
        :param _builtins.str option: Headers that you want your distribution to forward to your origin and base caching on. Valid values: `default`, `allow-list`, `all`.
        """
        if headers_allow_lists is not None:
            pulumi.set(__self__, "headers_allow_lists", headers_allow_lists)
        if option is not None:
            pulumi.set(__self__, "option", option)

    @_builtins.property
    @pulumi.getter(name="headersAllowLists")
    def headers_allow_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specific headers to forward to your distribution's origin.
        """
        return pulumi.get(self, "headers_allow_lists")

    @_builtins.property
    @pulumi.getter
    def option(self) -> Optional[_builtins.str]:
        """
        Headers that you want your distribution to forward to your origin and base caching on. Valid values: `default`, `allow-list`, `all`.
        """
        return pulumi.get(self, "option")


@pulumi.output_type
class DistributionCacheBehaviorSettingsForwardedQueryStrings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryStringsAllowedLists":
            suggest = "query_strings_allowed_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionCacheBehaviorSettingsForwardedQueryStrings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionCacheBehaviorSettingsForwardedQueryStrings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionCacheBehaviorSettingsForwardedQueryStrings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 option: Optional[_builtins.bool] = None,
                 query_strings_allowed_lists: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.bool option: Whether the distribution forwards and caches based on query strings.
        :param Sequence[_builtins.str] query_strings_allowed_lists: Specific query strings that the distribution forwards to the origin.
        """
        if option is not None:
            pulumi.set(__self__, "option", option)
        if query_strings_allowed_lists is not None:
            pulumi.set(__self__, "query_strings_allowed_lists", query_strings_allowed_lists)

    @_builtins.property
    @pulumi.getter
    def option(self) -> Optional[_builtins.bool]:
        """
        Whether the distribution forwards and caches based on query strings.
        """
        return pulumi.get(self, "option")

    @_builtins.property
    @pulumi.getter(name="queryStringsAllowedLists")
    def query_strings_allowed_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specific query strings that the distribution forwards to the origin.
        """
        return pulumi.get(self, "query_strings_allowed_lists")


@pulumi.output_type
class DistributionDefaultCacheBehavior(dict):
    def __init__(__self__, *,
                 behavior: _builtins.str):
        """
        :param _builtins.str behavior: Cache behavior of the distribution. Valid values: `cache`, `dont-cache`.
        """
        pulumi.set(__self__, "behavior", behavior)

    @_builtins.property
    @pulumi.getter
    def behavior(self) -> _builtins.str:
        """
        Cache behavior of the distribution. Valid values: `cache`, `dont-cache`.
        """
        return pulumi.get(self, "behavior")


@pulumi.output_type
class DistributionLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZone":
            suggest = "availability_zone"
        elif key == "regionName":
            suggest = "region_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zone: _builtins.str,
                 region_name: _builtins.str):
        """
        :param _builtins.str availability_zone: Availability Zone. Follows the format us-east-2a (case-sensitive).
        :param _builtins.str region_name: AWS Region name.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "region_name", region_name)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        Availability Zone. Follows the format us-east-2a (case-sensitive).
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="regionName")
    def region_name(self) -> _builtins.str:
        """
        AWS Region name.
        """
        return pulumi.get(self, "region_name")


@pulumi.output_type
class DistributionOrigin(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regionName":
            suggest = "region_name"
        elif key == "protocolPolicy":
            suggest = "protocol_policy"
        elif key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionOrigin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionOrigin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionOrigin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 region_name: _builtins.str,
                 protocol_policy: Optional[_builtins.str] = None,
                 resource_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name of the origin resource. Your origin can be an instance with an attached static IP, a bucket, or a load balancer that has at least one instance attached to it.
        :param _builtins.str region_name: AWS Region name of the origin resource.
        :param _builtins.str protocol_policy: Protocol that your Amazon Lightsail distribution uses when establishing a connection with your origin to pull content.
        :param _builtins.str resource_type: Lightsail resource type (e.g., Distribution).
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region_name", region_name)
        if protocol_policy is not None:
            pulumi.set(__self__, "protocol_policy", protocol_policy)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the origin resource. Your origin can be an instance with an attached static IP, a bucket, or a load balancer that has at least one instance attached to it.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="regionName")
    def region_name(self) -> _builtins.str:
        """
        AWS Region name of the origin resource.
        """
        return pulumi.get(self, "region_name")

    @_builtins.property
    @pulumi.getter(name="protocolPolicy")
    def protocol_policy(self) -> Optional[_builtins.str]:
        """
        Protocol that your Amazon Lightsail distribution uses when establishing a connection with your origin to pull content.
        """
        return pulumi.get(self, "protocol_policy")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[_builtins.str]:
        """
        Lightsail resource type (e.g., Distribution).
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class InstanceAddOn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotTime":
            suggest = "snapshot_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceAddOn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceAddOn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceAddOn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshot_time: _builtins.str,
                 status: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str snapshot_time: Daily time when an automatic snapshot will be created. Must be in HH:00 format, and in an hourly increment and specified in Coordinated Universal Time (UTC). The snapshot will be automatically created between the time specified and up to 45 minutes after.
        :param _builtins.str status: Status of the add-on. Valid values: `Enabled`, `Disabled`.
        :param _builtins.str type: Add-on type. There is currently only one valid type `AutoSnapshot`.
        """
        pulumi.set(__self__, "snapshot_time", snapshot_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="snapshotTime")
    def snapshot_time(self) -> _builtins.str:
        """
        Daily time when an automatic snapshot will be created. Must be in HH:00 format, and in an hourly increment and specified in Coordinated Universal Time (UTC). The snapshot will be automatically created between the time specified and up to 45 minutes after.
        """
        return pulumi.get(self, "snapshot_time")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the add-on. Valid values: `Enabled`, `Disabled`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Add-on type. There is currently only one valid type `AutoSnapshot`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class InstancePublicPortsPortInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fromPort":
            suggest = "from_port"
        elif key == "toPort":
            suggest = "to_port"
        elif key == "cidrListAliases":
            suggest = "cidr_list_aliases"
        elif key == "ipv6Cidrs":
            suggest = "ipv6_cidrs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePublicPortsPortInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePublicPortsPortInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePublicPortsPortInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_port: _builtins.int,
                 protocol: _builtins.str,
                 to_port: _builtins.int,
                 cidr_list_aliases: Optional[Sequence[_builtins.str]] = None,
                 cidrs: Optional[Sequence[_builtins.str]] = None,
                 ipv6_cidrs: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.int from_port: First port in a range of open ports on an instance. See [PortInfo](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_PortInfo.html) for details.
        :param _builtins.str protocol: IP protocol name. Valid values: `tcp`, `all`, `udp`, `icmp`, `icmpv6`. See [PortInfo](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_PortInfo.html) for details.
        :param _builtins.int to_port: Last port in a range of open ports on an instance. See [PortInfo](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_PortInfo.html) for details.
        :param Sequence[_builtins.str] cidr_list_aliases: Set of CIDR aliases that define access for a preconfigured range of IP addresses.
        :param Sequence[_builtins.str] cidrs: Set of IPv4 addresses or ranges of IPv4 addresses (in CIDR notation) that are allowed to connect to an instance through the ports, and the protocol.
        :param Sequence[_builtins.str] ipv6_cidrs: Set of IPv6 addresses or ranges of IPv6 addresses (in CIDR notation) that are allowed to connect to an instance through the ports, and the protocol.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "to_port", to_port)
        if cidr_list_aliases is not None:
            pulumi.set(__self__, "cidr_list_aliases", cidr_list_aliases)
        if cidrs is not None:
            pulumi.set(__self__, "cidrs", cidrs)
        if ipv6_cidrs is not None:
            pulumi.set(__self__, "ipv6_cidrs", ipv6_cidrs)

    @_builtins.property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> _builtins.int:
        """
        First port in a range of open ports on an instance. See [PortInfo](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_PortInfo.html) for details.
        """
        return pulumi.get(self, "from_port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        IP protocol name. Valid values: `tcp`, `all`, `udp`, `icmp`, `icmpv6`. See [PortInfo](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_PortInfo.html) for details.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="toPort")
    def to_port(self) -> _builtins.int:
        """
        Last port in a range of open ports on an instance. See [PortInfo](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_PortInfo.html) for details.
        """
        return pulumi.get(self, "to_port")

    @_builtins.property
    @pulumi.getter(name="cidrListAliases")
    def cidr_list_aliases(self) -> Optional[Sequence[_builtins.str]]:
        """
        Set of CIDR aliases that define access for a preconfigured range of IP addresses.
        """
        return pulumi.get(self, "cidr_list_aliases")

    @_builtins.property
    @pulumi.getter
    def cidrs(self) -> Optional[Sequence[_builtins.str]]:
        """
        Set of IPv4 addresses or ranges of IPv4 addresses (in CIDR notation) that are allowed to connect to an instance through the ports, and the protocol.
        """
        return pulumi.get(self, "cidrs")

    @_builtins.property
    @pulumi.getter(name="ipv6Cidrs")
    def ipv6_cidrs(self) -> Optional[Sequence[_builtins.str]]:
        """
        Set of IPv6 addresses or ranges of IPv6 addresses (in CIDR notation) that are allowed to connect to an instance through the ports, and the protocol.
        """
        return pulumi.get(self, "ipv6_cidrs")


@pulumi.output_type
class LbCertificateDomainValidationRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "resourceRecordName":
            suggest = "resource_record_name"
        elif key == "resourceRecordType":
            suggest = "resource_record_type"
        elif key == "resourceRecordValue":
            suggest = "resource_record_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LbCertificateDomainValidationRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LbCertificateDomainValidationRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LbCertificateDomainValidationRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[_builtins.str] = None,
                 resource_record_name: Optional[_builtins.str] = None,
                 resource_record_type: Optional[_builtins.str] = None,
                 resource_record_value: Optional[_builtins.str] = None):
        """
        :param _builtins.str domain_name: Domain name (e.g., example.com) for your SSL/TLS certificate.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if resource_record_name is not None:
            pulumi.set(__self__, "resource_record_name", resource_record_name)
        if resource_record_type is not None:
            pulumi.set(__self__, "resource_record_type", resource_record_type)
        if resource_record_value is not None:
            pulumi.set(__self__, "resource_record_value", resource_record_value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[_builtins.str]:
        """
        Domain name (e.g., example.com) for your SSL/TLS certificate.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="resourceRecordName")
    def resource_record_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resource_record_name")

    @_builtins.property
    @pulumi.getter(name="resourceRecordType")
    def resource_record_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resource_record_type")

    @_builtins.property
    @pulumi.getter(name="resourceRecordValue")
    def resource_record_value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resource_record_value")


