# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetUserResult',
    'AwaitableGetUserResult',
    'get_user',
    'get_user_output',
]

@pulumi.output_type
class GetUserResult:
    """
    A collection of values returned by getUser.
    """
    def __init__(__self__, access_string=None, arn=None, authentication_modes=None, id=None, minimum_engine_version=None, region=None, tags=None, user_name=None):
        if access_string and not isinstance(access_string, str):
            raise TypeError("Expected argument 'access_string' to be a str")
        pulumi.set(__self__, "access_string", access_string)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if authentication_modes and not isinstance(authentication_modes, list):
            raise TypeError("Expected argument 'authentication_modes' to be a list")
        pulumi.set(__self__, "authentication_modes", authentication_modes)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if minimum_engine_version and not isinstance(minimum_engine_version, str):
            raise TypeError("Expected argument 'minimum_engine_version' to be a str")
        pulumi.set(__self__, "minimum_engine_version", minimum_engine_version)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if user_name and not isinstance(user_name, str):
            raise TypeError("Expected argument 'user_name' to be a str")
        pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="accessString")
    def access_string(self) -> _builtins.str:
        """
        Access permissions string used for this user.
        """
        return pulumi.get(self, "access_string")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the user.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="authenticationModes")
    def authentication_modes(self) -> Sequence['outputs.GetUserAuthenticationModeResult']:
        """
        Denotes the user's authentication properties.
        """
        return pulumi.get(self, "authentication_modes")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="minimumEngineVersion")
    def minimum_engine_version(self) -> _builtins.str:
        """
        Minimum engine version supported for the user.
        """
        return pulumi.get(self, "minimum_engine_version")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Map of tags assigned to the user.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> _builtins.str:
        return pulumi.get(self, "user_name")


class AwaitableGetUserResult(GetUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserResult(
            access_string=self.access_string,
            arn=self.arn,
            authentication_modes=self.authentication_modes,
            id=self.id,
            minimum_engine_version=self.minimum_engine_version,
            region=self.region,
            tags=self.tags,
            user_name=self.user_name)


def get_user(region: Optional[_builtins.str] = None,
             tags: Optional[Mapping[str, _builtins.str]] = None,
             user_name: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserResult:
    """
    Provides information about a MemoryDB User.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.memorydb.get_user(user_name="my-user")
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Map of tags assigned to the user.
    :param _builtins.str user_name: Name of the user.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['tags'] = tags
    __args__['userName'] = user_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:memorydb/getUser:getUser', __args__, opts=opts, typ=GetUserResult).value

    return AwaitableGetUserResult(
        access_string=pulumi.get(__ret__, 'access_string'),
        arn=pulumi.get(__ret__, 'arn'),
        authentication_modes=pulumi.get(__ret__, 'authentication_modes'),
        id=pulumi.get(__ret__, 'id'),
        minimum_engine_version=pulumi.get(__ret__, 'minimum_engine_version'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'),
        user_name=pulumi.get(__ret__, 'user_name'))
def get_user_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                    user_name: Optional[pulumi.Input[_builtins.str]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserResult]:
    """
    Provides information about a MemoryDB User.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.memorydb.get_user(user_name="my-user")
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Map of tags assigned to the user.
    :param _builtins.str user_name: Name of the user.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['tags'] = tags
    __args__['userName'] = user_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:memorydb/getUser:getUser', __args__, opts=opts, typ=GetUserResult)
    return __ret__.apply(lambda __response__: GetUserResult(
        access_string=pulumi.get(__response__, 'access_string'),
        arn=pulumi.get(__response__, 'arn'),
        authentication_modes=pulumi.get(__response__, 'authentication_modes'),
        id=pulumi.get(__response__, 'id'),
        minimum_engine_version=pulumi.get(__response__, 'minimum_engine_version'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags'),
        user_name=pulumi.get(__response__, 'user_name')))
