# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MultiRegionClusterArgs', 'MultiRegionCluster']

@pulumi.input_type
class MultiRegionClusterArgs:
    def __init__(__self__, *,
                 multi_region_cluster_name_suffix: pulumi.Input[_builtins.str],
                 node_type: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_region_parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 num_shards: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['MultiRegionClusterTimeoutsArgs']] = None,
                 tls_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 update_strategy: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MultiRegionCluster resource.
        :param pulumi.Input[_builtins.str] multi_region_cluster_name_suffix: A suffix to be added to the multi-region cluster name. An AWS generated prefix is automatically applied to the multi-region cluster name when it is created.
        :param pulumi.Input[_builtins.str] node_type: The node type to be used for the multi-region cluster.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] description: description for the multi-region cluster.
        :param pulumi.Input[_builtins.str] engine: The name of the engine to be used for the multi-region cluster. Valid values are `redis` and `valkey`.
        :param pulumi.Input[_builtins.str] engine_version: The version of the engine to be used for the multi-region cluster. Downgrades are not supported.
        :param pulumi.Input[_builtins.str] multi_region_parameter_group_name: The name of the multi-region parameter group to be associated with the cluster.
        :param pulumi.Input[_builtins.int] num_shards: The number of shards for the multi-region cluster.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.bool] tls_enabled: A flag to enable in-transit encryption on the cluster.
        """
        pulumi.set(__self__, "multi_region_cluster_name_suffix", multi_region_cluster_name_suffix)
        pulumi.set(__self__, "node_type", node_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if multi_region_parameter_group_name is not None:
            pulumi.set(__self__, "multi_region_parameter_group_name", multi_region_parameter_group_name)
        if num_shards is not None:
            pulumi.set(__self__, "num_shards", num_shards)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if tls_enabled is not None:
            pulumi.set(__self__, "tls_enabled", tls_enabled)
        if update_strategy is not None:
            pulumi.set(__self__, "update_strategy", update_strategy)

    @_builtins.property
    @pulumi.getter(name="multiRegionClusterNameSuffix")
    def multi_region_cluster_name_suffix(self) -> pulumi.Input[_builtins.str]:
        """
        A suffix to be added to the multi-region cluster name. An AWS generated prefix is automatically applied to the multi-region cluster name when it is created.
        """
        return pulumi.get(self, "multi_region_cluster_name_suffix")

    @multi_region_cluster_name_suffix.setter
    def multi_region_cluster_name_suffix(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "multi_region_cluster_name_suffix", value)

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Input[_builtins.str]:
        """
        The node type to be used for the multi-region cluster.

        The following arguments are optional:
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "node_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        description for the multi-region cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the engine to be used for the multi-region cluster. Valid values are `redis` and `valkey`.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the engine to be used for the multi-region cluster. Downgrades are not supported.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="multiRegionParameterGroupName")
    def multi_region_parameter_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the multi-region parameter group to be associated with the cluster.
        """
        return pulumi.get(self, "multi_region_parameter_group_name")

    @multi_region_parameter_group_name.setter
    def multi_region_parameter_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "multi_region_parameter_group_name", value)

    @_builtins.property
    @pulumi.getter(name="numShards")
    def num_shards(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of shards for the multi-region cluster.
        """
        return pulumi.get(self, "num_shards")

    @num_shards.setter
    def num_shards(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_shards", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['MultiRegionClusterTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['MultiRegionClusterTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A flag to enable in-transit encryption on the cluster.
        """
        return pulumi.get(self, "tls_enabled")

    @tls_enabled.setter
    def tls_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tls_enabled", value)

    @_builtins.property
    @pulumi.getter(name="updateStrategy")
    def update_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "update_strategy")

    @update_strategy.setter
    def update_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_strategy", value)


@pulumi.input_type
class _MultiRegionClusterState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_region_cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_region_cluster_name_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_region_parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 num_shards: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['MultiRegionClusterTimeoutsArgs']] = None,
                 tls_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 update_strategy: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MultiRegionCluster resources.
        :param pulumi.Input[_builtins.str] arn: The ARN of the multi-region cluster.
        :param pulumi.Input[_builtins.str] description: description for the multi-region cluster.
        :param pulumi.Input[_builtins.str] engine: The name of the engine to be used for the multi-region cluster. Valid values are `redis` and `valkey`.
        :param pulumi.Input[_builtins.str] engine_version: The version of the engine to be used for the multi-region cluster. Downgrades are not supported.
        :param pulumi.Input[_builtins.str] multi_region_cluster_name: The name of the multi-region cluster.
        :param pulumi.Input[_builtins.str] multi_region_cluster_name_suffix: A suffix to be added to the multi-region cluster name. An AWS generated prefix is automatically applied to the multi-region cluster name when it is created.
        :param pulumi.Input[_builtins.str] multi_region_parameter_group_name: The name of the multi-region parameter group to be associated with the cluster.
        :param pulumi.Input[_builtins.str] node_type: The node type to be used for the multi-region cluster.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.int] num_shards: The number of shards for the multi-region cluster.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.bool] tls_enabled: A flag to enable in-transit encryption on the cluster.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if multi_region_cluster_name is not None:
            pulumi.set(__self__, "multi_region_cluster_name", multi_region_cluster_name)
        if multi_region_cluster_name_suffix is not None:
            pulumi.set(__self__, "multi_region_cluster_name_suffix", multi_region_cluster_name_suffix)
        if multi_region_parameter_group_name is not None:
            pulumi.set(__self__, "multi_region_parameter_group_name", multi_region_parameter_group_name)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if num_shards is not None:
            pulumi.set(__self__, "num_shards", num_shards)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if tls_enabled is not None:
            pulumi.set(__self__, "tls_enabled", tls_enabled)
        if update_strategy is not None:
            pulumi.set(__self__, "update_strategy", update_strategy)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the multi-region cluster.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        description for the multi-region cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the engine to be used for the multi-region cluster. Valid values are `redis` and `valkey`.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the engine to be used for the multi-region cluster. Downgrades are not supported.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="multiRegionClusterName")
    def multi_region_cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the multi-region cluster.
        """
        return pulumi.get(self, "multi_region_cluster_name")

    @multi_region_cluster_name.setter
    def multi_region_cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "multi_region_cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="multiRegionClusterNameSuffix")
    def multi_region_cluster_name_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A suffix to be added to the multi-region cluster name. An AWS generated prefix is automatically applied to the multi-region cluster name when it is created.
        """
        return pulumi.get(self, "multi_region_cluster_name_suffix")

    @multi_region_cluster_name_suffix.setter
    def multi_region_cluster_name_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "multi_region_cluster_name_suffix", value)

    @_builtins.property
    @pulumi.getter(name="multiRegionParameterGroupName")
    def multi_region_parameter_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the multi-region parameter group to be associated with the cluster.
        """
        return pulumi.get(self, "multi_region_parameter_group_name")

    @multi_region_parameter_group_name.setter
    def multi_region_parameter_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "multi_region_parameter_group_name", value)

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The node type to be used for the multi-region cluster.

        The following arguments are optional:
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_type", value)

    @_builtins.property
    @pulumi.getter(name="numShards")
    def num_shards(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of shards for the multi-region cluster.
        """
        return pulumi.get(self, "num_shards")

    @num_shards.setter
    def num_shards(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_shards", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['MultiRegionClusterTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['MultiRegionClusterTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A flag to enable in-transit encryption on the cluster.
        """
        return pulumi.get(self, "tls_enabled")

    @tls_enabled.setter
    def tls_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tls_enabled", value)

    @_builtins.property
    @pulumi.getter(name="updateStrategy")
    def update_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "update_strategy")

    @update_strategy.setter
    def update_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_strategy", value)


@pulumi.type_token("aws:memorydb/multiRegionCluster:MultiRegionCluster")
class MultiRegionCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_region_cluster_name_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_region_parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 num_shards: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['MultiRegionClusterTimeoutsArgs', 'MultiRegionClusterTimeoutsArgsDict']]] = None,
                 tls_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 update_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a MemoryDB Multi Region Cluster.

        More information about MemoryDB can be found in the [Developer Guide](https://docs.aws.amazon.com/memorydb/latest/devguide/what-is-memorydb-for-redis.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.memorydb.MultiRegionCluster("example",
            multi_region_cluster_name_suffix="example",
            node_type="db.r7g.xlarge")
        example_cluster = aws.memorydb.Cluster("example",
            acl_name=example_aws_memorydb_acl["id"],
            auto_minor_version_upgrade=False,
            name="example",
            node_type="db.t4g.small",
            num_shards=2,
            security_group_ids=[example_aws_security_group["id"]],
            snapshot_retention_limit=7,
            subnet_group_name=example_aws_memorydb_subnet_group["id"],
            multi_region_cluster_name=example.multi_region_cluster_name)
        ```

        ## Import

        Using `pulumi import`, import a cluster using the `multi_region_cluster_name`. For example:

        ```sh
        $ pulumi import aws:memorydb/multiRegionCluster:MultiRegionCluster example virxk-example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: description for the multi-region cluster.
        :param pulumi.Input[_builtins.str] engine: The name of the engine to be used for the multi-region cluster. Valid values are `redis` and `valkey`.
        :param pulumi.Input[_builtins.str] engine_version: The version of the engine to be used for the multi-region cluster. Downgrades are not supported.
        :param pulumi.Input[_builtins.str] multi_region_cluster_name_suffix: A suffix to be added to the multi-region cluster name. An AWS generated prefix is automatically applied to the multi-region cluster name when it is created.
        :param pulumi.Input[_builtins.str] multi_region_parameter_group_name: The name of the multi-region parameter group to be associated with the cluster.
        :param pulumi.Input[_builtins.str] node_type: The node type to be used for the multi-region cluster.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.int] num_shards: The number of shards for the multi-region cluster.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.bool] tls_enabled: A flag to enable in-transit encryption on the cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MultiRegionClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a MemoryDB Multi Region Cluster.

        More information about MemoryDB can be found in the [Developer Guide](https://docs.aws.amazon.com/memorydb/latest/devguide/what-is-memorydb-for-redis.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.memorydb.MultiRegionCluster("example",
            multi_region_cluster_name_suffix="example",
            node_type="db.r7g.xlarge")
        example_cluster = aws.memorydb.Cluster("example",
            acl_name=example_aws_memorydb_acl["id"],
            auto_minor_version_upgrade=False,
            name="example",
            node_type="db.t4g.small",
            num_shards=2,
            security_group_ids=[example_aws_security_group["id"]],
            snapshot_retention_limit=7,
            subnet_group_name=example_aws_memorydb_subnet_group["id"],
            multi_region_cluster_name=example.multi_region_cluster_name)
        ```

        ## Import

        Using `pulumi import`, import a cluster using the `multi_region_cluster_name`. For example:

        ```sh
        $ pulumi import aws:memorydb/multiRegionCluster:MultiRegionCluster example virxk-example
        ```

        :param str resource_name: The name of the resource.
        :param MultiRegionClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MultiRegionClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_region_cluster_name_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_region_parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 num_shards: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['MultiRegionClusterTimeoutsArgs', 'MultiRegionClusterTimeoutsArgsDict']]] = None,
                 tls_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 update_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MultiRegionClusterArgs.__new__(MultiRegionClusterArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["engine"] = engine
            __props__.__dict__["engine_version"] = engine_version
            if multi_region_cluster_name_suffix is None and not opts.urn:
                raise TypeError("Missing required property 'multi_region_cluster_name_suffix'")
            __props__.__dict__["multi_region_cluster_name_suffix"] = multi_region_cluster_name_suffix
            __props__.__dict__["multi_region_parameter_group_name"] = multi_region_parameter_group_name
            if node_type is None and not opts.urn:
                raise TypeError("Missing required property 'node_type'")
            __props__.__dict__["node_type"] = node_type
            __props__.__dict__["num_shards"] = num_shards
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["tls_enabled"] = tls_enabled
            __props__.__dict__["update_strategy"] = update_strategy
            __props__.__dict__["arn"] = None
            __props__.__dict__["multi_region_cluster_name"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
        super(MultiRegionCluster, __self__).__init__(
            'aws:memorydb/multiRegionCluster:MultiRegionCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            engine: Optional[pulumi.Input[_builtins.str]] = None,
            engine_version: Optional[pulumi.Input[_builtins.str]] = None,
            multi_region_cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            multi_region_cluster_name_suffix: Optional[pulumi.Input[_builtins.str]] = None,
            multi_region_parameter_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            node_type: Optional[pulumi.Input[_builtins.str]] = None,
            num_shards: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['MultiRegionClusterTimeoutsArgs', 'MultiRegionClusterTimeoutsArgsDict']]] = None,
            tls_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            update_strategy: Optional[pulumi.Input[_builtins.str]] = None) -> 'MultiRegionCluster':
        """
        Get an existing MultiRegionCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The ARN of the multi-region cluster.
        :param pulumi.Input[_builtins.str] description: description for the multi-region cluster.
        :param pulumi.Input[_builtins.str] engine: The name of the engine to be used for the multi-region cluster. Valid values are `redis` and `valkey`.
        :param pulumi.Input[_builtins.str] engine_version: The version of the engine to be used for the multi-region cluster. Downgrades are not supported.
        :param pulumi.Input[_builtins.str] multi_region_cluster_name: The name of the multi-region cluster.
        :param pulumi.Input[_builtins.str] multi_region_cluster_name_suffix: A suffix to be added to the multi-region cluster name. An AWS generated prefix is automatically applied to the multi-region cluster name when it is created.
        :param pulumi.Input[_builtins.str] multi_region_parameter_group_name: The name of the multi-region parameter group to be associated with the cluster.
        :param pulumi.Input[_builtins.str] node_type: The node type to be used for the multi-region cluster.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.int] num_shards: The number of shards for the multi-region cluster.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.bool] tls_enabled: A flag to enable in-transit encryption on the cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MultiRegionClusterState.__new__(_MultiRegionClusterState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["description"] = description
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["multi_region_cluster_name"] = multi_region_cluster_name
        __props__.__dict__["multi_region_cluster_name_suffix"] = multi_region_cluster_name_suffix
        __props__.__dict__["multi_region_parameter_group_name"] = multi_region_parameter_group_name
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["num_shards"] = num_shards
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["tls_enabled"] = tls_enabled
        __props__.__dict__["update_strategy"] = update_strategy
        return MultiRegionCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the multi-region cluster.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        description for the multi-region cluster.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the engine to be used for the multi-region cluster. Valid values are `redis` and `valkey`.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the engine to be used for the multi-region cluster. Downgrades are not supported.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="multiRegionClusterName")
    def multi_region_cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the multi-region cluster.
        """
        return pulumi.get(self, "multi_region_cluster_name")

    @_builtins.property
    @pulumi.getter(name="multiRegionClusterNameSuffix")
    def multi_region_cluster_name_suffix(self) -> pulumi.Output[_builtins.str]:
        """
        A suffix to be added to the multi-region cluster name. An AWS generated prefix is automatically applied to the multi-region cluster name when it is created.
        """
        return pulumi.get(self, "multi_region_cluster_name_suffix")

    @_builtins.property
    @pulumi.getter(name="multiRegionParameterGroupName")
    def multi_region_parameter_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the multi-region parameter group to be associated with the cluster.
        """
        return pulumi.get(self, "multi_region_parameter_group_name")

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[_builtins.str]:
        """
        The node type to be used for the multi-region cluster.

        The following arguments are optional:
        """
        return pulumi.get(self, "node_type")

    @_builtins.property
    @pulumi.getter(name="numShards")
    def num_shards(self) -> pulumi.Output[_builtins.int]:
        """
        The number of shards for the multi-region cluster.
        """
        return pulumi.get(self, "num_shards")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.MultiRegionClusterTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        A flag to enable in-transit encryption on the cluster.
        """
        return pulumi.get(self, "tls_enabled")

    @_builtins.property
    @pulumi.getter(name="updateStrategy")
    def update_strategy(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "update_strategy")

