# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterBrokerNodeGroupInfo',
    'ClusterBrokerNodeGroupInfoConnectivityInfo',
    'ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccess',
    'ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivity',
    'ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthentication',
    'ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationSasl',
    'ClusterBrokerNodeGroupInfoStorageInfo',
    'ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfo',
    'ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughput',
    'ClusterClientAuthentication',
    'ClusterClientAuthenticationSasl',
    'ClusterClientAuthenticationTls',
    'ClusterConfigurationInfo',
    'ClusterEncryptionInfo',
    'ClusterEncryptionInfoEncryptionInTransit',
    'ClusterLoggingInfo',
    'ClusterLoggingInfoBrokerLogs',
    'ClusterLoggingInfoBrokerLogsCloudwatchLogs',
    'ClusterLoggingInfoBrokerLogsFirehose',
    'ClusterLoggingInfoBrokerLogsS3',
    'ClusterOpenMonitoring',
    'ClusterOpenMonitoringPrometheus',
    'ClusterOpenMonitoringPrometheusJmxExporter',
    'ClusterOpenMonitoringPrometheusNodeExporter',
    'ReplicatorKafkaCluster',
    'ReplicatorKafkaClusterAmazonMskCluster',
    'ReplicatorKafkaClusterVpcConfig',
    'ReplicatorReplicationInfoList',
    'ReplicatorReplicationInfoListConsumerGroupReplication',
    'ReplicatorReplicationInfoListTopicReplication',
    'ReplicatorReplicationInfoListTopicReplicationStartingPosition',
    'ReplicatorReplicationInfoListTopicReplicationTopicNameConfiguration',
    'ServerlessClusterClientAuthentication',
    'ServerlessClusterClientAuthenticationSasl',
    'ServerlessClusterClientAuthenticationSaslIam',
    'ServerlessClusterVpcConfig',
    'GetBrokerNodesNodeInfoListResult',
    'GetClusterBrokerNodeGroupInfoResult',
    'GetClusterBrokerNodeGroupInfoConnectivityInfoResult',
    'GetClusterBrokerNodeGroupInfoConnectivityInfoPublicAccessResult',
    'GetClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityResult',
    'GetClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationResult',
    'GetClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationSaslResult',
    'GetClusterBrokerNodeGroupInfoStorageInfoResult',
    'GetClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoResult',
    'GetClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputResult',
]

@pulumi.output_type
class ClusterBrokerNodeGroupInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientSubnets":
            suggest = "client_subnets"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "securityGroups":
            suggest = "security_groups"
        elif key == "azDistribution":
            suggest = "az_distribution"
        elif key == "connectivityInfo":
            suggest = "connectivity_info"
        elif key == "storageInfo":
            suggest = "storage_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBrokerNodeGroupInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBrokerNodeGroupInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBrokerNodeGroupInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_subnets: Sequence[_builtins.str],
                 instance_type: _builtins.str,
                 security_groups: Sequence[_builtins.str],
                 az_distribution: Optional[_builtins.str] = None,
                 connectivity_info: Optional['outputs.ClusterBrokerNodeGroupInfoConnectivityInfo'] = None,
                 storage_info: Optional['outputs.ClusterBrokerNodeGroupInfoStorageInfo'] = None):
        """
        :param Sequence[_builtins.str] client_subnets: A list of subnets to connect to in client VPC ([documentation](https://docs.aws.amazon.com/msk/1.0/apireference/clusters.html#clusters-prop-brokernodegroupinfo-clientsubnets)).
        :param _builtins.str instance_type: Specify the instance type to use for the kafka brokersE.g., kafka.m5.large. ([Pricing info](https://aws.amazon.com/msk/pricing/))
        :param Sequence[_builtins.str] security_groups: A list of the security groups to associate with the elastic network interfaces to control who can communicate with the cluster.
        :param _builtins.str az_distribution: The distribution of broker nodes across availability zones ([documentation](https://docs.aws.amazon.com/msk/1.0/apireference/clusters.html#clusters-model-brokerazdistribution)). Currently, the only valid value is `DEFAULT`.
        :param 'ClusterBrokerNodeGroupInfoConnectivityInfoArgs' connectivity_info: Information about the cluster access configuration. See broker_node_group_info connectivity_info Argument Reference below. For security reasons, you can't turn on public access while creating an MSK cluster. However, you can update an existing cluster to make it publicly accessible. You can also create a new cluster and then update it to make it publicly accessible ([documentation](https://docs.aws.amazon.com/msk/latest/developerguide/public-access.html)).
        :param 'ClusterBrokerNodeGroupInfoStorageInfoArgs' storage_info: A block that contains information about storage volumes attached to MSK broker nodes. See broker_node_group_info storage_info Argument Reference below.
        """
        pulumi.set(__self__, "client_subnets", client_subnets)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "security_groups", security_groups)
        if az_distribution is not None:
            pulumi.set(__self__, "az_distribution", az_distribution)
        if connectivity_info is not None:
            pulumi.set(__self__, "connectivity_info", connectivity_info)
        if storage_info is not None:
            pulumi.set(__self__, "storage_info", storage_info)

    @_builtins.property
    @pulumi.getter(name="clientSubnets")
    def client_subnets(self) -> Sequence[_builtins.str]:
        """
        A list of subnets to connect to in client VPC ([documentation](https://docs.aws.amazon.com/msk/1.0/apireference/clusters.html#clusters-prop-brokernodegroupinfo-clientsubnets)).
        """
        return pulumi.get(self, "client_subnets")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> _builtins.str:
        """
        Specify the instance type to use for the kafka brokersE.g., kafka.m5.large. ([Pricing info](https://aws.amazon.com/msk/pricing/))
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Sequence[_builtins.str]:
        """
        A list of the security groups to associate with the elastic network interfaces to control who can communicate with the cluster.
        """
        return pulumi.get(self, "security_groups")

    @_builtins.property
    @pulumi.getter(name="azDistribution")
    def az_distribution(self) -> Optional[_builtins.str]:
        """
        The distribution of broker nodes across availability zones ([documentation](https://docs.aws.amazon.com/msk/1.0/apireference/clusters.html#clusters-model-brokerazdistribution)). Currently, the only valid value is `DEFAULT`.
        """
        return pulumi.get(self, "az_distribution")

    @_builtins.property
    @pulumi.getter(name="connectivityInfo")
    def connectivity_info(self) -> Optional['outputs.ClusterBrokerNodeGroupInfoConnectivityInfo']:
        """
        Information about the cluster access configuration. See broker_node_group_info connectivity_info Argument Reference below. For security reasons, you can't turn on public access while creating an MSK cluster. However, you can update an existing cluster to make it publicly accessible. You can also create a new cluster and then update it to make it publicly accessible ([documentation](https://docs.aws.amazon.com/msk/latest/developerguide/public-access.html)).
        """
        return pulumi.get(self, "connectivity_info")

    @_builtins.property
    @pulumi.getter(name="storageInfo")
    def storage_info(self) -> Optional['outputs.ClusterBrokerNodeGroupInfoStorageInfo']:
        """
        A block that contains information about storage volumes attached to MSK broker nodes. See broker_node_group_info storage_info Argument Reference below.
        """
        return pulumi.get(self, "storage_info")


@pulumi.output_type
class ClusterBrokerNodeGroupInfoConnectivityInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicAccess":
            suggest = "public_access"
        elif key == "vpcConnectivity":
            suggest = "vpc_connectivity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBrokerNodeGroupInfoConnectivityInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBrokerNodeGroupInfoConnectivityInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBrokerNodeGroupInfoConnectivityInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_access: Optional['outputs.ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccess'] = None,
                 vpc_connectivity: Optional['outputs.ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivity'] = None):
        """
        :param 'ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccessArgs' public_access: Access control settings for brokers. See connectivity_info public_access Argument Reference below.
        :param 'ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityArgs' vpc_connectivity: VPC connectivity access control for brokers. See connectivity_info vpc_connectivity Argument Reference below.
        """
        if public_access is not None:
            pulumi.set(__self__, "public_access", public_access)
        if vpc_connectivity is not None:
            pulumi.set(__self__, "vpc_connectivity", vpc_connectivity)

    @_builtins.property
    @pulumi.getter(name="publicAccess")
    def public_access(self) -> Optional['outputs.ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccess']:
        """
        Access control settings for brokers. See connectivity_info public_access Argument Reference below.
        """
        return pulumi.get(self, "public_access")

    @_builtins.property
    @pulumi.getter(name="vpcConnectivity")
    def vpc_connectivity(self) -> Optional['outputs.ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivity']:
        """
        VPC connectivity access control for brokers. See connectivity_info vpc_connectivity Argument Reference below.
        """
        return pulumi.get(self, "vpc_connectivity")


@pulumi.output_type
class ClusterBrokerNodeGroupInfoConnectivityInfoPublicAccess(dict):
    def __init__(__self__, *,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Public access type. Valid values: `DISABLED`, `SERVICE_PROVIDED_EIPS`.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Public access type. Valid values: `DISABLED`, `SERVICE_PROVIDED_EIPS`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientAuthentication":
            suggest = "client_authentication"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_authentication: Optional['outputs.ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthentication'] = None):
        """
        :param 'ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationArgs' client_authentication: Configuration block for specifying a client authentication. See client_authentication Argument Reference below.
        """
        if client_authentication is not None:
            pulumi.set(__self__, "client_authentication", client_authentication)

    @_builtins.property
    @pulumi.getter(name="clientAuthentication")
    def client_authentication(self) -> Optional['outputs.ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthentication']:
        """
        Configuration block for specifying a client authentication. See client_authentication Argument Reference below.
        """
        return pulumi.get(self, "client_authentication")


@pulumi.output_type
class ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthentication(dict):
    def __init__(__self__, *,
                 sasl: Optional['outputs.ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationSasl'] = None,
                 tls: Optional[_builtins.bool] = None):
        """
        :param 'ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationSaslArgs' sasl: Configuration block for specifying SASL client authentication. See client_authentication sasl Argument Reference below.
        :param _builtins.bool tls: Configuration block for specifying TLS client authentication. See client_authentication tls Argument Reference below.
        """
        if sasl is not None:
            pulumi.set(__self__, "sasl", sasl)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)

    @_builtins.property
    @pulumi.getter
    def sasl(self) -> Optional['outputs.ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationSasl']:
        """
        Configuration block for specifying SASL client authentication. See client_authentication sasl Argument Reference below.
        """
        return pulumi.get(self, "sasl")

    @_builtins.property
    @pulumi.getter
    def tls(self) -> Optional[_builtins.bool]:
        """
        Configuration block for specifying TLS client authentication. See client_authentication tls Argument Reference below.
        """
        return pulumi.get(self, "tls")


@pulumi.output_type
class ClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationSasl(dict):
    def __init__(__self__, *,
                 iam: Optional[_builtins.bool] = None,
                 scram: Optional[_builtins.bool] = None):
        if iam is not None:
            pulumi.set(__self__, "iam", iam)
        if scram is not None:
            pulumi.set(__self__, "scram", scram)

    @_builtins.property
    @pulumi.getter
    def iam(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "iam")

    @_builtins.property
    @pulumi.getter
    def scram(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "scram")


@pulumi.output_type
class ClusterBrokerNodeGroupInfoStorageInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ebsStorageInfo":
            suggest = "ebs_storage_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBrokerNodeGroupInfoStorageInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBrokerNodeGroupInfoStorageInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBrokerNodeGroupInfoStorageInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ebs_storage_info: Optional['outputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfo'] = None):
        """
        :param 'ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoArgs' ebs_storage_info: A block that contains EBS volume information. See storage_info ebs_storage_info Argument Reference below.
        """
        if ebs_storage_info is not None:
            pulumi.set(__self__, "ebs_storage_info", ebs_storage_info)

    @_builtins.property
    @pulumi.getter(name="ebsStorageInfo")
    def ebs_storage_info(self) -> Optional['outputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfo']:
        """
        A block that contains EBS volume information. See storage_info ebs_storage_info Argument Reference below.
        """
        return pulumi.get(self, "ebs_storage_info")


@pulumi.output_type
class ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisionedThroughput":
            suggest = "provisioned_throughput"
        elif key == "volumeSize":
            suggest = "volume_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioned_throughput: Optional['outputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughput'] = None,
                 volume_size: Optional[_builtins.int] = None):
        """
        :param 'ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputArgs' provisioned_throughput: A block that contains EBS volume provisioned throughput information. To provision storage throughput, you must choose broker type kafka.m5.4xlarge or larger. See ebs_storage_info provisioned_throughput Argument Reference below.
        :param _builtins.int volume_size: The size in GiB of the EBS volume for the data drive on each broker node. Minimum value of `1` and maximum value of `16384`.
        """
        if provisioned_throughput is not None:
            pulumi.set(__self__, "provisioned_throughput", provisioned_throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)

    @_builtins.property
    @pulumi.getter(name="provisionedThroughput")
    def provisioned_throughput(self) -> Optional['outputs.ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughput']:
        """
        A block that contains EBS volume provisioned throughput information. To provision storage throughput, you must choose broker type kafka.m5.4xlarge or larger. See ebs_storage_info provisioned_throughput Argument Reference below.
        """
        return pulumi.get(self, "provisioned_throughput")

    @_builtins.property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[_builtins.int]:
        """
        The size in GiB of the EBS volume for the data drive on each broker node. Minimum value of `1` and maximum value of `16384`.
        """
        return pulumi.get(self, "volume_size")


@pulumi.output_type
class ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeThroughput":
            suggest = "volume_throughput"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 volume_throughput: Optional[_builtins.int] = None):
        """
        :param _builtins.int volume_throughput: Throughput value of the EBS volumes for the data drive on each kafka broker node in MiB per second. The minimum value is `250`. The maximum value varies between broker type. You can refer to the valid values for the maximum volume throughput at the following [documentation on throughput bottlenecks](https://docs.aws.amazon.com/msk/latest/developerguide/msk-provision-throughput.html#throughput-bottlenecks)
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if volume_throughput is not None:
            pulumi.set(__self__, "volume_throughput", volume_throughput)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="volumeThroughput")
    def volume_throughput(self) -> Optional[_builtins.int]:
        """
        Throughput value of the EBS volumes for the data drive on each kafka broker node in MiB per second. The minimum value is `250`. The maximum value varies between broker type. You can refer to the valid values for the maximum volume throughput at the following [documentation on throughput bottlenecks](https://docs.aws.amazon.com/msk/latest/developerguide/msk-provision-throughput.html#throughput-bottlenecks)
        """
        return pulumi.get(self, "volume_throughput")


@pulumi.output_type
class ClusterClientAuthentication(dict):
    def __init__(__self__, *,
                 sasl: Optional['outputs.ClusterClientAuthenticationSasl'] = None,
                 tls: Optional['outputs.ClusterClientAuthenticationTls'] = None,
                 unauthenticated: Optional[_builtins.bool] = None):
        """
        :param 'ClusterClientAuthenticationSaslArgs' sasl: Configuration block for specifying SASL client authentication. See client_authentication sasl Argument Reference below.
        :param 'ClusterClientAuthenticationTlsArgs' tls: Configuration block for specifying TLS client authentication. See client_authentication tls Argument Reference below.
        :param _builtins.bool unauthenticated: Enables unauthenticated access.
        """
        if sasl is not None:
            pulumi.set(__self__, "sasl", sasl)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if unauthenticated is not None:
            pulumi.set(__self__, "unauthenticated", unauthenticated)

    @_builtins.property
    @pulumi.getter
    def sasl(self) -> Optional['outputs.ClusterClientAuthenticationSasl']:
        """
        Configuration block for specifying SASL client authentication. See client_authentication sasl Argument Reference below.
        """
        return pulumi.get(self, "sasl")

    @_builtins.property
    @pulumi.getter
    def tls(self) -> Optional['outputs.ClusterClientAuthenticationTls']:
        """
        Configuration block for specifying TLS client authentication. See client_authentication tls Argument Reference below.
        """
        return pulumi.get(self, "tls")

    @_builtins.property
    @pulumi.getter
    def unauthenticated(self) -> Optional[_builtins.bool]:
        """
        Enables unauthenticated access.
        """
        return pulumi.get(self, "unauthenticated")


@pulumi.output_type
class ClusterClientAuthenticationSasl(dict):
    def __init__(__self__, *,
                 iam: Optional[_builtins.bool] = None,
                 scram: Optional[_builtins.bool] = None):
        if iam is not None:
            pulumi.set(__self__, "iam", iam)
        if scram is not None:
            pulumi.set(__self__, "scram", scram)

    @_builtins.property
    @pulumi.getter
    def iam(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "iam")

    @_builtins.property
    @pulumi.getter
    def scram(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "scram")


@pulumi.output_type
class ClusterClientAuthenticationTls(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateAuthorityArns":
            suggest = "certificate_authority_arns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClientAuthenticationTls. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClientAuthenticationTls.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClientAuthenticationTls.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_authority_arns: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] certificate_authority_arns: List of ACM Certificate Authority Amazon Resource Names (ARNs).
        """
        if certificate_authority_arns is not None:
            pulumi.set(__self__, "certificate_authority_arns", certificate_authority_arns)

    @_builtins.property
    @pulumi.getter(name="certificateAuthorityArns")
    def certificate_authority_arns(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of ACM Certificate Authority Amazon Resource Names (ARNs).
        """
        return pulumi.get(self, "certificate_authority_arns")


@pulumi.output_type
class ClusterConfigurationInfo(dict):
    def __init__(__self__, *,
                 arn: _builtins.str,
                 revision: _builtins.int):
        """
        :param _builtins.str arn: Amazon Resource Name (ARN) of the MSK Configuration to use in the cluster.
        :param _builtins.int revision: Revision of the MSK Configuration to use in the cluster.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "revision", revision)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        Amazon Resource Name (ARN) of the MSK Configuration to use in the cluster.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> _builtins.int:
        """
        Revision of the MSK Configuration to use in the cluster.
        """
        return pulumi.get(self, "revision")


@pulumi.output_type
class ClusterEncryptionInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionAtRestKmsKeyArn":
            suggest = "encryption_at_rest_kms_key_arn"
        elif key == "encryptionInTransit":
            suggest = "encryption_in_transit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEncryptionInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEncryptionInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEncryptionInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_at_rest_kms_key_arn: Optional[_builtins.str] = None,
                 encryption_in_transit: Optional['outputs.ClusterEncryptionInfoEncryptionInTransit'] = None):
        """
        :param _builtins.str encryption_at_rest_kms_key_arn: You may specify a KMS key short ID or ARN (it will always output an ARN) to use for encrypting your data at rest.  If no key is specified, an AWS managed KMS ('aws/msk' managed service) key will be used for encrypting the data at rest.
        :param 'ClusterEncryptionInfoEncryptionInTransitArgs' encryption_in_transit: Configuration block to specify encryption in transit. See encryption_info encryption_in_transit Argument Reference below.
        """
        if encryption_at_rest_kms_key_arn is not None:
            pulumi.set(__self__, "encryption_at_rest_kms_key_arn", encryption_at_rest_kms_key_arn)
        if encryption_in_transit is not None:
            pulumi.set(__self__, "encryption_in_transit", encryption_in_transit)

    @_builtins.property
    @pulumi.getter(name="encryptionAtRestKmsKeyArn")
    def encryption_at_rest_kms_key_arn(self) -> Optional[_builtins.str]:
        """
        You may specify a KMS key short ID or ARN (it will always output an ARN) to use for encrypting your data at rest.  If no key is specified, an AWS managed KMS ('aws/msk' managed service) key will be used for encrypting the data at rest.
        """
        return pulumi.get(self, "encryption_at_rest_kms_key_arn")

    @_builtins.property
    @pulumi.getter(name="encryptionInTransit")
    def encryption_in_transit(self) -> Optional['outputs.ClusterEncryptionInfoEncryptionInTransit']:
        """
        Configuration block to specify encryption in transit. See encryption_info encryption_in_transit Argument Reference below.
        """
        return pulumi.get(self, "encryption_in_transit")


@pulumi.output_type
class ClusterEncryptionInfoEncryptionInTransit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientBroker":
            suggest = "client_broker"
        elif key == "inCluster":
            suggest = "in_cluster"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEncryptionInfoEncryptionInTransit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEncryptionInfoEncryptionInTransit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEncryptionInfoEncryptionInTransit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_broker: Optional[_builtins.str] = None,
                 in_cluster: Optional[_builtins.bool] = None):
        """
        :param _builtins.str client_broker: Encryption setting for data in transit between clients and brokers. Valid values: `TLS`, `TLS_PLAINTEXT`, and `PLAINTEXT`. Default value is `TLS`.
        :param _builtins.bool in_cluster: Whether data communication among broker nodes is encrypted. Default value: `true`.
        """
        if client_broker is not None:
            pulumi.set(__self__, "client_broker", client_broker)
        if in_cluster is not None:
            pulumi.set(__self__, "in_cluster", in_cluster)

    @_builtins.property
    @pulumi.getter(name="clientBroker")
    def client_broker(self) -> Optional[_builtins.str]:
        """
        Encryption setting for data in transit between clients and brokers. Valid values: `TLS`, `TLS_PLAINTEXT`, and `PLAINTEXT`. Default value is `TLS`.
        """
        return pulumi.get(self, "client_broker")

    @_builtins.property
    @pulumi.getter(name="inCluster")
    def in_cluster(self) -> Optional[_builtins.bool]:
        """
        Whether data communication among broker nodes is encrypted. Default value: `true`.
        """
        return pulumi.get(self, "in_cluster")


@pulumi.output_type
class ClusterLoggingInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "brokerLogs":
            suggest = "broker_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterLoggingInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterLoggingInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterLoggingInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 broker_logs: 'outputs.ClusterLoggingInfoBrokerLogs'):
        """
        :param 'ClusterLoggingInfoBrokerLogsArgs' broker_logs: Configuration block for Broker Logs settings for logging info. See logging_info broker_logs Argument Reference below.
        """
        pulumi.set(__self__, "broker_logs", broker_logs)

    @_builtins.property
    @pulumi.getter(name="brokerLogs")
    def broker_logs(self) -> 'outputs.ClusterLoggingInfoBrokerLogs':
        """
        Configuration block for Broker Logs settings for logging info. See logging_info broker_logs Argument Reference below.
        """
        return pulumi.get(self, "broker_logs")


@pulumi.output_type
class ClusterLoggingInfoBrokerLogs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudwatchLogs":
            suggest = "cloudwatch_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterLoggingInfoBrokerLogs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterLoggingInfoBrokerLogs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterLoggingInfoBrokerLogs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloudwatch_logs: Optional['outputs.ClusterLoggingInfoBrokerLogsCloudwatchLogs'] = None,
                 firehose: Optional['outputs.ClusterLoggingInfoBrokerLogsFirehose'] = None,
                 s3: Optional['outputs.ClusterLoggingInfoBrokerLogsS3'] = None):
        """
        :param 'ClusterLoggingInfoBrokerLogsCloudwatchLogsArgs' cloudwatch_logs: Configuration block for Cloudwatch Logs settings. See logging_info broker_logs cloudwatch_logs Argument Reference below.
        :param 'ClusterLoggingInfoBrokerLogsFirehoseArgs' firehose: Configuration block for Kinesis Data Firehose settings. See logging_info broker_logs firehose Argument Reference below.
        :param 'ClusterLoggingInfoBrokerLogsS3Args' s3: Configuration block for S3 settings. See logging_info broker_logs s3 Argument Reference below.
        """
        if cloudwatch_logs is not None:
            pulumi.set(__self__, "cloudwatch_logs", cloudwatch_logs)
        if firehose is not None:
            pulumi.set(__self__, "firehose", firehose)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)

    @_builtins.property
    @pulumi.getter(name="cloudwatchLogs")
    def cloudwatch_logs(self) -> Optional['outputs.ClusterLoggingInfoBrokerLogsCloudwatchLogs']:
        """
        Configuration block for Cloudwatch Logs settings. See logging_info broker_logs cloudwatch_logs Argument Reference below.
        """
        return pulumi.get(self, "cloudwatch_logs")

    @_builtins.property
    @pulumi.getter
    def firehose(self) -> Optional['outputs.ClusterLoggingInfoBrokerLogsFirehose']:
        """
        Configuration block for Kinesis Data Firehose settings. See logging_info broker_logs firehose Argument Reference below.
        """
        return pulumi.get(self, "firehose")

    @_builtins.property
    @pulumi.getter
    def s3(self) -> Optional['outputs.ClusterLoggingInfoBrokerLogsS3']:
        """
        Configuration block for S3 settings. See logging_info broker_logs s3 Argument Reference below.
        """
        return pulumi.get(self, "s3")


@pulumi.output_type
class ClusterLoggingInfoBrokerLogsCloudwatchLogs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroup":
            suggest = "log_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterLoggingInfoBrokerLogsCloudwatchLogs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterLoggingInfoBrokerLogsCloudwatchLogs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterLoggingInfoBrokerLogsCloudwatchLogs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 log_group: Optional[_builtins.str] = None):
        """
        :param _builtins.str log_group: Name of the Cloudwatch Log Group to deliver logs to.
        """
        pulumi.set(__self__, "enabled", enabled)
        if log_group is not None:
            pulumi.set(__self__, "log_group", log_group)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> Optional[_builtins.str]:
        """
        Name of the Cloudwatch Log Group to deliver logs to.
        """
        return pulumi.get(self, "log_group")


@pulumi.output_type
class ClusterLoggingInfoBrokerLogsFirehose(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deliveryStream":
            suggest = "delivery_stream"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterLoggingInfoBrokerLogsFirehose. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterLoggingInfoBrokerLogsFirehose.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterLoggingInfoBrokerLogsFirehose.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 delivery_stream: Optional[_builtins.str] = None):
        """
        :param _builtins.str delivery_stream: Name of the Kinesis Data Firehose delivery stream to deliver logs to.
        """
        pulumi.set(__self__, "enabled", enabled)
        if delivery_stream is not None:
            pulumi.set(__self__, "delivery_stream", delivery_stream)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="deliveryStream")
    def delivery_stream(self) -> Optional[_builtins.str]:
        """
        Name of the Kinesis Data Firehose delivery stream to deliver logs to.
        """
        return pulumi.get(self, "delivery_stream")


@pulumi.output_type
class ClusterLoggingInfoBrokerLogsS3(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 bucket: Optional[_builtins.str] = None,
                 prefix: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket: Name of the S3 bucket to deliver logs to.
        :param _builtins.str prefix: Prefix to append to the folder name.
        """
        pulumi.set(__self__, "enabled", enabled)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[_builtins.str]:
        """
        Name of the S3 bucket to deliver logs to.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[_builtins.str]:
        """
        Prefix to append to the folder name.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class ClusterOpenMonitoring(dict):
    def __init__(__self__, *,
                 prometheus: 'outputs.ClusterOpenMonitoringPrometheus'):
        """
        :param 'ClusterOpenMonitoringPrometheusArgs' prometheus: Configuration block for Prometheus settings for open monitoring. See open_monitoring prometheus Argument Reference below.
        """
        pulumi.set(__self__, "prometheus", prometheus)

    @_builtins.property
    @pulumi.getter
    def prometheus(self) -> 'outputs.ClusterOpenMonitoringPrometheus':
        """
        Configuration block for Prometheus settings for open monitoring. See open_monitoring prometheus Argument Reference below.
        """
        return pulumi.get(self, "prometheus")


@pulumi.output_type
class ClusterOpenMonitoringPrometheus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jmxExporter":
            suggest = "jmx_exporter"
        elif key == "nodeExporter":
            suggest = "node_exporter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOpenMonitoringPrometheus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOpenMonitoringPrometheus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOpenMonitoringPrometheus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 jmx_exporter: Optional['outputs.ClusterOpenMonitoringPrometheusJmxExporter'] = None,
                 node_exporter: Optional['outputs.ClusterOpenMonitoringPrometheusNodeExporter'] = None):
        """
        :param 'ClusterOpenMonitoringPrometheusJmxExporterArgs' jmx_exporter: Configuration block for JMX Exporter. See open_monitoring prometheus jmx_exporter Argument Reference below.
        :param 'ClusterOpenMonitoringPrometheusNodeExporterArgs' node_exporter: Configuration block for Node Exporter. See open_monitoring prometheus node_exporter Argument Reference below.
        """
        if jmx_exporter is not None:
            pulumi.set(__self__, "jmx_exporter", jmx_exporter)
        if node_exporter is not None:
            pulumi.set(__self__, "node_exporter", node_exporter)

    @_builtins.property
    @pulumi.getter(name="jmxExporter")
    def jmx_exporter(self) -> Optional['outputs.ClusterOpenMonitoringPrometheusJmxExporter']:
        """
        Configuration block for JMX Exporter. See open_monitoring prometheus jmx_exporter Argument Reference below.
        """
        return pulumi.get(self, "jmx_exporter")

    @_builtins.property
    @pulumi.getter(name="nodeExporter")
    def node_exporter(self) -> Optional['outputs.ClusterOpenMonitoringPrometheusNodeExporter']:
        """
        Configuration block for Node Exporter. See open_monitoring prometheus node_exporter Argument Reference below.
        """
        return pulumi.get(self, "node_exporter")


@pulumi.output_type
class ClusterOpenMonitoringPrometheusJmxExporter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enabledInBroker":
            suggest = "enabled_in_broker"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOpenMonitoringPrometheusJmxExporter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOpenMonitoringPrometheusJmxExporter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOpenMonitoringPrometheusJmxExporter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled_in_broker: _builtins.bool):
        """
        :param _builtins.bool enabled_in_broker: Indicates whether you want to enable or disable the Node Exporter.
        """
        pulumi.set(__self__, "enabled_in_broker", enabled_in_broker)

    @_builtins.property
    @pulumi.getter(name="enabledInBroker")
    def enabled_in_broker(self) -> _builtins.bool:
        """
        Indicates whether you want to enable or disable the Node Exporter.
        """
        return pulumi.get(self, "enabled_in_broker")


@pulumi.output_type
class ClusterOpenMonitoringPrometheusNodeExporter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enabledInBroker":
            suggest = "enabled_in_broker"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOpenMonitoringPrometheusNodeExporter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOpenMonitoringPrometheusNodeExporter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOpenMonitoringPrometheusNodeExporter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled_in_broker: _builtins.bool):
        """
        :param _builtins.bool enabled_in_broker: Indicates whether you want to enable or disable the Node Exporter.
        """
        pulumi.set(__self__, "enabled_in_broker", enabled_in_broker)

    @_builtins.property
    @pulumi.getter(name="enabledInBroker")
    def enabled_in_broker(self) -> _builtins.bool:
        """
        Indicates whether you want to enable or disable the Node Exporter.
        """
        return pulumi.get(self, "enabled_in_broker")


@pulumi.output_type
class ReplicatorKafkaCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "amazonMskCluster":
            suggest = "amazon_msk_cluster"
        elif key == "vpcConfig":
            suggest = "vpc_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatorKafkaCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatorKafkaCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatorKafkaCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 amazon_msk_cluster: 'outputs.ReplicatorKafkaClusterAmazonMskCluster',
                 vpc_config: 'outputs.ReplicatorKafkaClusterVpcConfig'):
        """
        :param 'ReplicatorKafkaClusterAmazonMskClusterArgs' amazon_msk_cluster: Details of an Amazon MSK cluster.
        :param 'ReplicatorKafkaClusterVpcConfigArgs' vpc_config: Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
        """
        pulumi.set(__self__, "amazon_msk_cluster", amazon_msk_cluster)
        pulumi.set(__self__, "vpc_config", vpc_config)

    @_builtins.property
    @pulumi.getter(name="amazonMskCluster")
    def amazon_msk_cluster(self) -> 'outputs.ReplicatorKafkaClusterAmazonMskCluster':
        """
        Details of an Amazon MSK cluster.
        """
        return pulumi.get(self, "amazon_msk_cluster")

    @_builtins.property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> 'outputs.ReplicatorKafkaClusterVpcConfig':
        """
        Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
        """
        return pulumi.get(self, "vpc_config")


@pulumi.output_type
class ReplicatorKafkaClusterAmazonMskCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mskClusterArn":
            suggest = "msk_cluster_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatorKafkaClusterAmazonMskCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatorKafkaClusterAmazonMskCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatorKafkaClusterAmazonMskCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 msk_cluster_arn: _builtins.str):
        """
        :param _builtins.str msk_cluster_arn: The ARN of an Amazon MSK cluster.
        """
        pulumi.set(__self__, "msk_cluster_arn", msk_cluster_arn)

    @_builtins.property
    @pulumi.getter(name="mskClusterArn")
    def msk_cluster_arn(self) -> _builtins.str:
        """
        The ARN of an Amazon MSK cluster.
        """
        return pulumi.get(self, "msk_cluster_arn")


@pulumi.output_type
class ReplicatorKafkaClusterVpcConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "securityGroupsIds":
            suggest = "security_groups_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatorKafkaClusterVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatorKafkaClusterVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatorKafkaClusterVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_ids: Sequence[_builtins.str],
                 security_groups_ids: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] subnet_ids: The list of subnets to connect to in the virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets to allow communication between your Kafka Cluster and the replicator.
        :param Sequence[_builtins.str] security_groups_ids: The AWS security groups to associate with the ENIs used by the replicator. If a security group is not specified, the default security group associated with the VPC is used.
        """
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if security_groups_ids is not None:
            pulumi.set(__self__, "security_groups_ids", security_groups_ids)

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[_builtins.str]:
        """
        The list of subnets to connect to in the virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets to allow communication between your Kafka Cluster and the replicator.
        """
        return pulumi.get(self, "subnet_ids")

    @_builtins.property
    @pulumi.getter(name="securityGroupsIds")
    def security_groups_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        The AWS security groups to associate with the ENIs used by the replicator. If a security group is not specified, the default security group associated with the VPC is used.
        """
        return pulumi.get(self, "security_groups_ids")


@pulumi.output_type
class ReplicatorReplicationInfoList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumerGroupReplications":
            suggest = "consumer_group_replications"
        elif key == "sourceKafkaClusterArn":
            suggest = "source_kafka_cluster_arn"
        elif key == "targetCompressionType":
            suggest = "target_compression_type"
        elif key == "targetKafkaClusterArn":
            suggest = "target_kafka_cluster_arn"
        elif key == "topicReplications":
            suggest = "topic_replications"
        elif key == "sourceKafkaClusterAlias":
            suggest = "source_kafka_cluster_alias"
        elif key == "targetKafkaClusterAlias":
            suggest = "target_kafka_cluster_alias"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatorReplicationInfoList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatorReplicationInfoList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatorReplicationInfoList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumer_group_replications: Sequence['outputs.ReplicatorReplicationInfoListConsumerGroupReplication'],
                 source_kafka_cluster_arn: _builtins.str,
                 target_compression_type: _builtins.str,
                 target_kafka_cluster_arn: _builtins.str,
                 topic_replications: Sequence['outputs.ReplicatorReplicationInfoListTopicReplication'],
                 source_kafka_cluster_alias: Optional[_builtins.str] = None,
                 target_kafka_cluster_alias: Optional[_builtins.str] = None):
        """
        :param Sequence['ReplicatorReplicationInfoListConsumerGroupReplicationArgs'] consumer_group_replications: Configuration relating to consumer group replication.
        :param _builtins.str source_kafka_cluster_arn: The ARN of the source Kafka cluster.
        :param _builtins.str target_compression_type: The type of compression to use writing records to target Kafka cluster.
        :param _builtins.str target_kafka_cluster_arn: The ARN of the target Kafka cluster.
        :param Sequence['ReplicatorReplicationInfoListTopicReplicationArgs'] topic_replications: Configuration relating to topic replication.
        """
        pulumi.set(__self__, "consumer_group_replications", consumer_group_replications)
        pulumi.set(__self__, "source_kafka_cluster_arn", source_kafka_cluster_arn)
        pulumi.set(__self__, "target_compression_type", target_compression_type)
        pulumi.set(__self__, "target_kafka_cluster_arn", target_kafka_cluster_arn)
        pulumi.set(__self__, "topic_replications", topic_replications)
        if source_kafka_cluster_alias is not None:
            pulumi.set(__self__, "source_kafka_cluster_alias", source_kafka_cluster_alias)
        if target_kafka_cluster_alias is not None:
            pulumi.set(__self__, "target_kafka_cluster_alias", target_kafka_cluster_alias)

    @_builtins.property
    @pulumi.getter(name="consumerGroupReplications")
    def consumer_group_replications(self) -> Sequence['outputs.ReplicatorReplicationInfoListConsumerGroupReplication']:
        """
        Configuration relating to consumer group replication.
        """
        return pulumi.get(self, "consumer_group_replications")

    @_builtins.property
    @pulumi.getter(name="sourceKafkaClusterArn")
    def source_kafka_cluster_arn(self) -> _builtins.str:
        """
        The ARN of the source Kafka cluster.
        """
        return pulumi.get(self, "source_kafka_cluster_arn")

    @_builtins.property
    @pulumi.getter(name="targetCompressionType")
    def target_compression_type(self) -> _builtins.str:
        """
        The type of compression to use writing records to target Kafka cluster.
        """
        return pulumi.get(self, "target_compression_type")

    @_builtins.property
    @pulumi.getter(name="targetKafkaClusterArn")
    def target_kafka_cluster_arn(self) -> _builtins.str:
        """
        The ARN of the target Kafka cluster.
        """
        return pulumi.get(self, "target_kafka_cluster_arn")

    @_builtins.property
    @pulumi.getter(name="topicReplications")
    def topic_replications(self) -> Sequence['outputs.ReplicatorReplicationInfoListTopicReplication']:
        """
        Configuration relating to topic replication.
        """
        return pulumi.get(self, "topic_replications")

    @_builtins.property
    @pulumi.getter(name="sourceKafkaClusterAlias")
    def source_kafka_cluster_alias(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "source_kafka_cluster_alias")

    @_builtins.property
    @pulumi.getter(name="targetKafkaClusterAlias")
    def target_kafka_cluster_alias(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "target_kafka_cluster_alias")


@pulumi.output_type
class ReplicatorReplicationInfoListConsumerGroupReplication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumerGroupsToReplicates":
            suggest = "consumer_groups_to_replicates"
        elif key == "consumerGroupsToExcludes":
            suggest = "consumer_groups_to_excludes"
        elif key == "detectAndCopyNewConsumerGroups":
            suggest = "detect_and_copy_new_consumer_groups"
        elif key == "synchroniseConsumerGroupOffsets":
            suggest = "synchronise_consumer_group_offsets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatorReplicationInfoListConsumerGroupReplication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatorReplicationInfoListConsumerGroupReplication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatorReplicationInfoListConsumerGroupReplication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumer_groups_to_replicates: Sequence[_builtins.str],
                 consumer_groups_to_excludes: Optional[Sequence[_builtins.str]] = None,
                 detect_and_copy_new_consumer_groups: Optional[_builtins.bool] = None,
                 synchronise_consumer_group_offsets: Optional[_builtins.bool] = None):
        """
        :param Sequence[_builtins.str] consumer_groups_to_replicates: List of regular expression patterns indicating the consumer groups to copy.
        :param Sequence[_builtins.str] consumer_groups_to_excludes: List of regular expression patterns indicating the consumer groups that should not be replicated.
        :param _builtins.bool detect_and_copy_new_consumer_groups: Whether to periodically check for new consumer groups.
        :param _builtins.bool synchronise_consumer_group_offsets: Whether to periodically write the translated offsets to __consumer_offsets topic in target cluster.
        """
        pulumi.set(__self__, "consumer_groups_to_replicates", consumer_groups_to_replicates)
        if consumer_groups_to_excludes is not None:
            pulumi.set(__self__, "consumer_groups_to_excludes", consumer_groups_to_excludes)
        if detect_and_copy_new_consumer_groups is not None:
            pulumi.set(__self__, "detect_and_copy_new_consumer_groups", detect_and_copy_new_consumer_groups)
        if synchronise_consumer_group_offsets is not None:
            pulumi.set(__self__, "synchronise_consumer_group_offsets", synchronise_consumer_group_offsets)

    @_builtins.property
    @pulumi.getter(name="consumerGroupsToReplicates")
    def consumer_groups_to_replicates(self) -> Sequence[_builtins.str]:
        """
        List of regular expression patterns indicating the consumer groups to copy.
        """
        return pulumi.get(self, "consumer_groups_to_replicates")

    @_builtins.property
    @pulumi.getter(name="consumerGroupsToExcludes")
    def consumer_groups_to_excludes(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of regular expression patterns indicating the consumer groups that should not be replicated.
        """
        return pulumi.get(self, "consumer_groups_to_excludes")

    @_builtins.property
    @pulumi.getter(name="detectAndCopyNewConsumerGroups")
    def detect_and_copy_new_consumer_groups(self) -> Optional[_builtins.bool]:
        """
        Whether to periodically check for new consumer groups.
        """
        return pulumi.get(self, "detect_and_copy_new_consumer_groups")

    @_builtins.property
    @pulumi.getter(name="synchroniseConsumerGroupOffsets")
    def synchronise_consumer_group_offsets(self) -> Optional[_builtins.bool]:
        """
        Whether to periodically write the translated offsets to __consumer_offsets topic in target cluster.
        """
        return pulumi.get(self, "synchronise_consumer_group_offsets")


@pulumi.output_type
class ReplicatorReplicationInfoListTopicReplication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topicsToReplicates":
            suggest = "topics_to_replicates"
        elif key == "copyAccessControlListsForTopics":
            suggest = "copy_access_control_lists_for_topics"
        elif key == "copyTopicConfigurations":
            suggest = "copy_topic_configurations"
        elif key == "detectAndCopyNewTopics":
            suggest = "detect_and_copy_new_topics"
        elif key == "startingPosition":
            suggest = "starting_position"
        elif key == "topicNameConfiguration":
            suggest = "topic_name_configuration"
        elif key == "topicsToExcludes":
            suggest = "topics_to_excludes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicatorReplicationInfoListTopicReplication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicatorReplicationInfoListTopicReplication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicatorReplicationInfoListTopicReplication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 topics_to_replicates: Sequence[_builtins.str],
                 copy_access_control_lists_for_topics: Optional[_builtins.bool] = None,
                 copy_topic_configurations: Optional[_builtins.bool] = None,
                 detect_and_copy_new_topics: Optional[_builtins.bool] = None,
                 starting_position: Optional['outputs.ReplicatorReplicationInfoListTopicReplicationStartingPosition'] = None,
                 topic_name_configuration: Optional['outputs.ReplicatorReplicationInfoListTopicReplicationTopicNameConfiguration'] = None,
                 topics_to_excludes: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] topics_to_replicates: List of regular expression patterns indicating the topics to copy.
        :param _builtins.bool copy_access_control_lists_for_topics: Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.
        :param _builtins.bool copy_topic_configurations: Whether to periodically configure remote topics to match their corresponding upstream topics.
        :param _builtins.bool detect_and_copy_new_topics: Whether to periodically check for new topics and partitions.
        :param 'ReplicatorReplicationInfoListTopicReplicationStartingPositionArgs' starting_position: Configuration for specifying the position in the topics to start replicating from.
        :param 'ReplicatorReplicationInfoListTopicReplicationTopicNameConfigurationArgs' topic_name_configuration: Configuration for specifying replicated topic names should be the same as their corresponding upstream topics or prefixed with source cluster alias.
        :param Sequence[_builtins.str] topics_to_excludes: List of regular expression patterns indicating the topics that should not be replica.
        """
        pulumi.set(__self__, "topics_to_replicates", topics_to_replicates)
        if copy_access_control_lists_for_topics is not None:
            pulumi.set(__self__, "copy_access_control_lists_for_topics", copy_access_control_lists_for_topics)
        if copy_topic_configurations is not None:
            pulumi.set(__self__, "copy_topic_configurations", copy_topic_configurations)
        if detect_and_copy_new_topics is not None:
            pulumi.set(__self__, "detect_and_copy_new_topics", detect_and_copy_new_topics)
        if starting_position is not None:
            pulumi.set(__self__, "starting_position", starting_position)
        if topic_name_configuration is not None:
            pulumi.set(__self__, "topic_name_configuration", topic_name_configuration)
        if topics_to_excludes is not None:
            pulumi.set(__self__, "topics_to_excludes", topics_to_excludes)

    @_builtins.property
    @pulumi.getter(name="topicsToReplicates")
    def topics_to_replicates(self) -> Sequence[_builtins.str]:
        """
        List of regular expression patterns indicating the topics to copy.
        """
        return pulumi.get(self, "topics_to_replicates")

    @_builtins.property
    @pulumi.getter(name="copyAccessControlListsForTopics")
    def copy_access_control_lists_for_topics(self) -> Optional[_builtins.bool]:
        """
        Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.
        """
        return pulumi.get(self, "copy_access_control_lists_for_topics")

    @_builtins.property
    @pulumi.getter(name="copyTopicConfigurations")
    def copy_topic_configurations(self) -> Optional[_builtins.bool]:
        """
        Whether to periodically configure remote topics to match their corresponding upstream topics.
        """
        return pulumi.get(self, "copy_topic_configurations")

    @_builtins.property
    @pulumi.getter(name="detectAndCopyNewTopics")
    def detect_and_copy_new_topics(self) -> Optional[_builtins.bool]:
        """
        Whether to periodically check for new topics and partitions.
        """
        return pulumi.get(self, "detect_and_copy_new_topics")

    @_builtins.property
    @pulumi.getter(name="startingPosition")
    def starting_position(self) -> Optional['outputs.ReplicatorReplicationInfoListTopicReplicationStartingPosition']:
        """
        Configuration for specifying the position in the topics to start replicating from.
        """
        return pulumi.get(self, "starting_position")

    @_builtins.property
    @pulumi.getter(name="topicNameConfiguration")
    def topic_name_configuration(self) -> Optional['outputs.ReplicatorReplicationInfoListTopicReplicationTopicNameConfiguration']:
        """
        Configuration for specifying replicated topic names should be the same as their corresponding upstream topics or prefixed with source cluster alias.
        """
        return pulumi.get(self, "topic_name_configuration")

    @_builtins.property
    @pulumi.getter(name="topicsToExcludes")
    def topics_to_excludes(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of regular expression patterns indicating the topics that should not be replica.
        """
        return pulumi.get(self, "topics_to_excludes")


@pulumi.output_type
class ReplicatorReplicationInfoListTopicReplicationStartingPosition(dict):
    def __init__(__self__, *,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The type of replication starting position. Supports `LATEST` and `EARLIEST`.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of replication starting position. Supports `LATEST` and `EARLIEST`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ReplicatorReplicationInfoListTopicReplicationTopicNameConfiguration(dict):
    def __init__(__self__, *,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The type of topic configuration name. Supports `PREFIXED_WITH_SOURCE_CLUSTER_ALIAS` and `IDENTICAL`.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of topic configuration name. Supports `PREFIXED_WITH_SOURCE_CLUSTER_ALIAS` and `IDENTICAL`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServerlessClusterClientAuthentication(dict):
    def __init__(__self__, *,
                 sasl: 'outputs.ServerlessClusterClientAuthenticationSasl'):
        """
        :param 'ServerlessClusterClientAuthenticationSaslArgs' sasl: Details for client authentication using SASL. See below.
        """
        pulumi.set(__self__, "sasl", sasl)

    @_builtins.property
    @pulumi.getter
    def sasl(self) -> 'outputs.ServerlessClusterClientAuthenticationSasl':
        """
        Details for client authentication using SASL. See below.
        """
        return pulumi.get(self, "sasl")


@pulumi.output_type
class ServerlessClusterClientAuthenticationSasl(dict):
    def __init__(__self__, *,
                 iam: 'outputs.ServerlessClusterClientAuthenticationSaslIam'):
        """
        :param 'ServerlessClusterClientAuthenticationSaslIamArgs' iam: Details for client authentication using IAM. See below.
        """
        pulumi.set(__self__, "iam", iam)

    @_builtins.property
    @pulumi.getter
    def iam(self) -> 'outputs.ServerlessClusterClientAuthenticationSaslIam':
        """
        Details for client authentication using IAM. See below.
        """
        return pulumi.get(self, "iam")


@pulumi.output_type
class ServerlessClusterClientAuthenticationSaslIam(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool):
        """
        :param _builtins.bool enabled: Whether SASL/IAM authentication is enabled or not.
        """
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether SASL/IAM authentication is enabled or not.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ServerlessClusterVpcConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerlessClusterVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerlessClusterVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerlessClusterVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_ids: Sequence[_builtins.str],
                 security_group_ids: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] subnet_ids: A list of subnets in at least two different Availability Zones that host your client applications.
        :param Sequence[_builtins.str] security_group_ids: Specifies up to five security groups that control inbound and outbound traffic for the serverless cluster.
        """
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[_builtins.str]:
        """
        A list of subnets in at least two different Availability Zones that host your client applications.
        """
        return pulumi.get(self, "subnet_ids")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies up to five security groups that control inbound and outbound traffic for the serverless cluster.
        """
        return pulumi.get(self, "security_group_ids")


@pulumi.output_type
class GetBrokerNodesNodeInfoListResult(dict):
    def __init__(__self__, *,
                 attached_eni_id: _builtins.str,
                 broker_id: _builtins.float,
                 client_subnet: _builtins.str,
                 client_vpc_ip_address: _builtins.str,
                 endpoints: Sequence[_builtins.str],
                 node_arn: _builtins.str):
        """
        :param _builtins.str attached_eni_id: Attached elastic network interface of the broker
        :param _builtins.float broker_id: ID of the broker
        :param _builtins.str client_subnet: Client subnet to which this broker node belongs
        :param _builtins.str client_vpc_ip_address: The client virtual private cloud (VPC) IP address
        :param Sequence[_builtins.str] endpoints: Set of endpoints for accessing the broker. This does not include ports
        :param _builtins.str node_arn: ARN of the node
        """
        pulumi.set(__self__, "attached_eni_id", attached_eni_id)
        pulumi.set(__self__, "broker_id", broker_id)
        pulumi.set(__self__, "client_subnet", client_subnet)
        pulumi.set(__self__, "client_vpc_ip_address", client_vpc_ip_address)
        pulumi.set(__self__, "endpoints", endpoints)
        pulumi.set(__self__, "node_arn", node_arn)

    @_builtins.property
    @pulumi.getter(name="attachedEniId")
    def attached_eni_id(self) -> _builtins.str:
        """
        Attached elastic network interface of the broker
        """
        return pulumi.get(self, "attached_eni_id")

    @_builtins.property
    @pulumi.getter(name="brokerId")
    def broker_id(self) -> _builtins.float:
        """
        ID of the broker
        """
        return pulumi.get(self, "broker_id")

    @_builtins.property
    @pulumi.getter(name="clientSubnet")
    def client_subnet(self) -> _builtins.str:
        """
        Client subnet to which this broker node belongs
        """
        return pulumi.get(self, "client_subnet")

    @_builtins.property
    @pulumi.getter(name="clientVpcIpAddress")
    def client_vpc_ip_address(self) -> _builtins.str:
        """
        The client virtual private cloud (VPC) IP address
        """
        return pulumi.get(self, "client_vpc_ip_address")

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Sequence[_builtins.str]:
        """
        Set of endpoints for accessing the broker. This does not include ports
        """
        return pulumi.get(self, "endpoints")

    @_builtins.property
    @pulumi.getter(name="nodeArn")
    def node_arn(self) -> _builtins.str:
        """
        ARN of the node
        """
        return pulumi.get(self, "node_arn")


@pulumi.output_type
class GetClusterBrokerNodeGroupInfoResult(dict):
    def __init__(__self__, *,
                 az_distribution: _builtins.str,
                 client_subnets: Sequence[_builtins.str],
                 connectivity_infos: Sequence['outputs.GetClusterBrokerNodeGroupInfoConnectivityInfoResult'],
                 instance_type: _builtins.str,
                 security_groups: Sequence[_builtins.str],
                 storage_infos: Sequence['outputs.GetClusterBrokerNodeGroupInfoStorageInfoResult']):
        pulumi.set(__self__, "az_distribution", az_distribution)
        pulumi.set(__self__, "client_subnets", client_subnets)
        pulumi.set(__self__, "connectivity_infos", connectivity_infos)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "security_groups", security_groups)
        pulumi.set(__self__, "storage_infos", storage_infos)

    @_builtins.property
    @pulumi.getter(name="azDistribution")
    def az_distribution(self) -> _builtins.str:
        return pulumi.get(self, "az_distribution")

    @_builtins.property
    @pulumi.getter(name="clientSubnets")
    def client_subnets(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "client_subnets")

    @_builtins.property
    @pulumi.getter(name="connectivityInfos")
    def connectivity_infos(self) -> Sequence['outputs.GetClusterBrokerNodeGroupInfoConnectivityInfoResult']:
        return pulumi.get(self, "connectivity_infos")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> _builtins.str:
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "security_groups")

    @_builtins.property
    @pulumi.getter(name="storageInfos")
    def storage_infos(self) -> Sequence['outputs.GetClusterBrokerNodeGroupInfoStorageInfoResult']:
        return pulumi.get(self, "storage_infos")


@pulumi.output_type
class GetClusterBrokerNodeGroupInfoConnectivityInfoResult(dict):
    def __init__(__self__, *,
                 public_accesses: Sequence['outputs.GetClusterBrokerNodeGroupInfoConnectivityInfoPublicAccessResult'],
                 vpc_connectivities: Sequence['outputs.GetClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityResult']):
        pulumi.set(__self__, "public_accesses", public_accesses)
        pulumi.set(__self__, "vpc_connectivities", vpc_connectivities)

    @_builtins.property
    @pulumi.getter(name="publicAccesses")
    def public_accesses(self) -> Sequence['outputs.GetClusterBrokerNodeGroupInfoConnectivityInfoPublicAccessResult']:
        return pulumi.get(self, "public_accesses")

    @_builtins.property
    @pulumi.getter(name="vpcConnectivities")
    def vpc_connectivities(self) -> Sequence['outputs.GetClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityResult']:
        return pulumi.get(self, "vpc_connectivities")


@pulumi.output_type
class GetClusterBrokerNodeGroupInfoConnectivityInfoPublicAccessResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str):
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityResult(dict):
    def __init__(__self__, *,
                 client_authentications: Sequence['outputs.GetClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationResult']):
        pulumi.set(__self__, "client_authentications", client_authentications)

    @_builtins.property
    @pulumi.getter(name="clientAuthentications")
    def client_authentications(self) -> Sequence['outputs.GetClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationResult']:
        return pulumi.get(self, "client_authentications")


@pulumi.output_type
class GetClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationResult(dict):
    def __init__(__self__, *,
                 sasls: Sequence['outputs.GetClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationSaslResult'],
                 tls: _builtins.bool):
        pulumi.set(__self__, "sasls", sasls)
        pulumi.set(__self__, "tls", tls)

    @_builtins.property
    @pulumi.getter
    def sasls(self) -> Sequence['outputs.GetClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationSaslResult']:
        return pulumi.get(self, "sasls")

    @_builtins.property
    @pulumi.getter
    def tls(self) -> _builtins.bool:
        return pulumi.get(self, "tls")


@pulumi.output_type
class GetClusterBrokerNodeGroupInfoConnectivityInfoVpcConnectivityClientAuthenticationSaslResult(dict):
    def __init__(__self__, *,
                 iam: _builtins.bool,
                 scram: _builtins.bool):
        pulumi.set(__self__, "iam", iam)
        pulumi.set(__self__, "scram", scram)

    @_builtins.property
    @pulumi.getter
    def iam(self) -> _builtins.bool:
        return pulumi.get(self, "iam")

    @_builtins.property
    @pulumi.getter
    def scram(self) -> _builtins.bool:
        return pulumi.get(self, "scram")


@pulumi.output_type
class GetClusterBrokerNodeGroupInfoStorageInfoResult(dict):
    def __init__(__self__, *,
                 ebs_storage_infos: Sequence['outputs.GetClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoResult']):
        pulumi.set(__self__, "ebs_storage_infos", ebs_storage_infos)

    @_builtins.property
    @pulumi.getter(name="ebsStorageInfos")
    def ebs_storage_infos(self) -> Sequence['outputs.GetClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoResult']:
        return pulumi.get(self, "ebs_storage_infos")


@pulumi.output_type
class GetClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoResult(dict):
    def __init__(__self__, *,
                 provisioned_throughputs: Sequence['outputs.GetClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputResult'],
                 volume_size: _builtins.int):
        pulumi.set(__self__, "provisioned_throughputs", provisioned_throughputs)
        pulumi.set(__self__, "volume_size", volume_size)

    @_builtins.property
    @pulumi.getter(name="provisionedThroughputs")
    def provisioned_throughputs(self) -> Sequence['outputs.GetClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputResult']:
        return pulumi.get(self, "provisioned_throughputs")

    @_builtins.property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> _builtins.int:
        return pulumi.get(self, "volume_size")


@pulumi.output_type
class GetClusterBrokerNodeGroupInfoStorageInfoEbsStorageInfoProvisionedThroughputResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 volume_throughput: _builtins.int):
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "volume_throughput", volume_throughput)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="volumeThroughput")
    def volume_throughput(self) -> _builtins.int:
        return pulumi.get(self, "volume_throughput")


