# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FirewallArgs', 'Firewall']

@pulumi.input_type
class FirewallArgs:
    def __init__(__self__, *,
                 firewall_policy_arn: pulumi.Input[_builtins.str],
                 availability_zone_change_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zone_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallAvailabilityZoneMappingArgs']]]] = None,
                 delete_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled_analysis_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 encryption_configuration: Optional[pulumi.Input['FirewallEncryptionConfigurationArgs']] = None,
                 firewall_policy_change_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_change_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnet_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallSubnetMappingArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Firewall resource.
        :param pulumi.Input[_builtins.str] firewall_policy_arn: The Amazon Resource Name (ARN) of the VPC Firewall policy.
        :param pulumi.Input[_builtins.bool] availability_zone_change_protection: A setting indicating whether the firewall is protected against changes to its Availability Zone configuration. When set to `true`, you must first disable this protection before adding or removing Availability Zones.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallAvailabilityZoneMappingArgs']]] availability_zone_mappings: Required when creating a transit gateway-attached firewall. Set of configuration blocks describing the avaiability availability where you want to create firewall endpoints for a transit gateway-attached firewall.
        :param pulumi.Input[_builtins.bool] delete_protection: A flag indicating whether the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. Defaults to `false`.
        :param pulumi.Input[_builtins.str] description: A friendly description of the firewall.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_analysis_types: Set of types for which to collect analysis metrics. See [Reporting on network traffic in Network Firewall](https://docs.aws.amazon.com/network-firewall/latest/developerguide/reporting.html) for details on how to use the data. Valid values: `TLS_SNI`, `HTTP_HOST`. Defaults to `[]`.
        :param pulumi.Input['FirewallEncryptionConfigurationArgs'] encryption_configuration: KMS encryption configuration settings. See Encryption Configuration below for details.
        :param pulumi.Input[_builtins.bool] firewall_policy_change_protection: A flag indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: A friendly name of the firewall.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] subnet_change_protection: A flag indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallSubnetMappingArgs']]] subnet_mappings: Required when creating a VPC attached firewall. Set of configuration blocks describing the public subnets. Each subnet must belong to a different Availability Zone in the VPC. AWS Network Firewall creates a firewall endpoint in each subnet. See Subnet Mapping below for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] transit_gateway_id: . Required when creating a transit gateway-attached firewall. The unique identifier of the transit gateway to attach to this firewall. You can provide either a transit gateway from your account or one that has been shared with you through AWS Resource Access Manager
        :param pulumi.Input[_builtins.str] vpc_id: Required when creating a VPC attached firewall. The unique identifier of the VPC where AWS Network Firewall should create the firewall.
        """
        pulumi.set(__self__, "firewall_policy_arn", firewall_policy_arn)
        if availability_zone_change_protection is not None:
            pulumi.set(__self__, "availability_zone_change_protection", availability_zone_change_protection)
        if availability_zone_mappings is not None:
            pulumi.set(__self__, "availability_zone_mappings", availability_zone_mappings)
        if delete_protection is not None:
            pulumi.set(__self__, "delete_protection", delete_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled_analysis_types is not None:
            pulumi.set(__self__, "enabled_analysis_types", enabled_analysis_types)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if firewall_policy_change_protection is not None:
            pulumi.set(__self__, "firewall_policy_change_protection", firewall_policy_change_protection)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if subnet_change_protection is not None:
            pulumi.set(__self__, "subnet_change_protection", subnet_change_protection)
        if subnet_mappings is not None:
            pulumi.set(__self__, "subnet_mappings", subnet_mappings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transit_gateway_id is not None:
            pulumi.set(__self__, "transit_gateway_id", transit_gateway_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="firewallPolicyArn")
    def firewall_policy_arn(self) -> pulumi.Input[_builtins.str]:
        """
        The Amazon Resource Name (ARN) of the VPC Firewall policy.
        """
        return pulumi.get(self, "firewall_policy_arn")

    @firewall_policy_arn.setter
    def firewall_policy_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "firewall_policy_arn", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneChangeProtection")
    def availability_zone_change_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A setting indicating whether the firewall is protected against changes to its Availability Zone configuration. When set to `true`, you must first disable this protection before adding or removing Availability Zones.
        """
        return pulumi.get(self, "availability_zone_change_protection")

    @availability_zone_change_protection.setter
    def availability_zone_change_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "availability_zone_change_protection", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneMappings")
    def availability_zone_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallAvailabilityZoneMappingArgs']]]]:
        """
        Required when creating a transit gateway-attached firewall. Set of configuration blocks describing the avaiability availability where you want to create firewall endpoints for a transit gateway-attached firewall.
        """
        return pulumi.get(self, "availability_zone_mappings")

    @availability_zone_mappings.setter
    def availability_zone_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallAvailabilityZoneMappingArgs']]]]):
        pulumi.set(self, "availability_zone_mappings", value)

    @_builtins.property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A flag indicating whether the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. Defaults to `false`.
        """
        return pulumi.get(self, "delete_protection")

    @delete_protection.setter
    def delete_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A friendly description of the firewall.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enabledAnalysisTypes")
    def enabled_analysis_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of types for which to collect analysis metrics. See [Reporting on network traffic in Network Firewall](https://docs.aws.amazon.com/network-firewall/latest/developerguide/reporting.html) for details on how to use the data. Valid values: `TLS_SNI`, `HTTP_HOST`. Defaults to `[]`.
        """
        return pulumi.get(self, "enabled_analysis_types")

    @enabled_analysis_types.setter
    def enabled_analysis_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enabled_analysis_types", value)

    @_builtins.property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional[pulumi.Input['FirewallEncryptionConfigurationArgs']]:
        """
        KMS encryption configuration settings. See Encryption Configuration below for details.
        """
        return pulumi.get(self, "encryption_configuration")

    @encryption_configuration.setter
    def encryption_configuration(self, value: Optional[pulumi.Input['FirewallEncryptionConfigurationArgs']]):
        pulumi.set(self, "encryption_configuration", value)

    @_builtins.property
    @pulumi.getter(name="firewallPolicyChangeProtection")
    def firewall_policy_change_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A flag indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. Defaults to `false`.
        """
        return pulumi.get(self, "firewall_policy_change_protection")

    @firewall_policy_change_protection.setter
    def firewall_policy_change_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "firewall_policy_change_protection", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A friendly name of the firewall.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="subnetChangeProtection")
    def subnet_change_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A flag indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. Defaults to `false`.
        """
        return pulumi.get(self, "subnet_change_protection")

    @subnet_change_protection.setter
    def subnet_change_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "subnet_change_protection", value)

    @_builtins.property
    @pulumi.getter(name="subnetMappings")
    def subnet_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallSubnetMappingArgs']]]]:
        """
        Required when creating a VPC attached firewall. Set of configuration blocks describing the public subnets. Each subnet must belong to a different Availability Zone in the VPC. AWS Network Firewall creates a firewall endpoint in each subnet. See Subnet Mapping below for details.
        """
        return pulumi.get(self, "subnet_mappings")

    @subnet_mappings.setter
    def subnet_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallSubnetMappingArgs']]]]):
        pulumi.set(self, "subnet_mappings", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="transitGatewayId")
    def transit_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Required when creating a transit gateway-attached firewall. The unique identifier of the transit gateway to attach to this firewall. You can provide either a transit gateway from your account or one that has been shared with you through AWS Resource Access Manager
        """
        return pulumi.get(self, "transit_gateway_id")

    @transit_gateway_id.setter
    def transit_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required when creating a VPC attached firewall. The unique identifier of the VPC where AWS Network Firewall should create the firewall.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class _FirewallState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone_change_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zone_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallAvailabilityZoneMappingArgs']]]] = None,
                 delete_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled_analysis_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 encryption_configuration: Optional[pulumi.Input['FirewallEncryptionConfigurationArgs']] = None,
                 firewall_policy_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_policy_change_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 firewall_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallFirewallStatusArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_change_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnet_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallSubnetMappingArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_gateway_owner_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 update_token: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Firewall resources.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) that identifies the firewall.
        :param pulumi.Input[_builtins.bool] availability_zone_change_protection: A setting indicating whether the firewall is protected against changes to its Availability Zone configuration. When set to `true`, you must first disable this protection before adding or removing Availability Zones.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallAvailabilityZoneMappingArgs']]] availability_zone_mappings: Required when creating a transit gateway-attached firewall. Set of configuration blocks describing the avaiability availability where you want to create firewall endpoints for a transit gateway-attached firewall.
        :param pulumi.Input[_builtins.bool] delete_protection: A flag indicating whether the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. Defaults to `false`.
        :param pulumi.Input[_builtins.str] description: A friendly description of the firewall.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_analysis_types: Set of types for which to collect analysis metrics. See [Reporting on network traffic in Network Firewall](https://docs.aws.amazon.com/network-firewall/latest/developerguide/reporting.html) for details on how to use the data. Valid values: `TLS_SNI`, `HTTP_HOST`. Defaults to `[]`.
        :param pulumi.Input['FirewallEncryptionConfigurationArgs'] encryption_configuration: KMS encryption configuration settings. See Encryption Configuration below for details.
        :param pulumi.Input[_builtins.str] firewall_policy_arn: The Amazon Resource Name (ARN) of the VPC Firewall policy.
        :param pulumi.Input[_builtins.bool] firewall_policy_change_protection: A flag indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallFirewallStatusArgs']]] firewall_statuses: Nested list of information about the current status of the firewall.
        :param pulumi.Input[_builtins.str] name: A friendly name of the firewall.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] subnet_change_protection: A flag indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallSubnetMappingArgs']]] subnet_mappings: Required when creating a VPC attached firewall. Set of configuration blocks describing the public subnets. Each subnet must belong to a different Availability Zone in the VPC. AWS Network Firewall creates a firewall endpoint in each subnet. See Subnet Mapping below for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] transit_gateway_id: . Required when creating a transit gateway-attached firewall. The unique identifier of the transit gateway to attach to this firewall. You can provide either a transit gateway from your account or one that has been shared with you through AWS Resource Access Manager
        :param pulumi.Input[_builtins.str] transit_gateway_owner_account_id: The AWS account ID that owns the transit gateway.
        :param pulumi.Input[_builtins.str] update_token: A string token used when updating a firewall.
        :param pulumi.Input[_builtins.str] vpc_id: Required when creating a VPC attached firewall. The unique identifier of the VPC where AWS Network Firewall should create the firewall.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if availability_zone_change_protection is not None:
            pulumi.set(__self__, "availability_zone_change_protection", availability_zone_change_protection)
        if availability_zone_mappings is not None:
            pulumi.set(__self__, "availability_zone_mappings", availability_zone_mappings)
        if delete_protection is not None:
            pulumi.set(__self__, "delete_protection", delete_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled_analysis_types is not None:
            pulumi.set(__self__, "enabled_analysis_types", enabled_analysis_types)
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if firewall_policy_arn is not None:
            pulumi.set(__self__, "firewall_policy_arn", firewall_policy_arn)
        if firewall_policy_change_protection is not None:
            pulumi.set(__self__, "firewall_policy_change_protection", firewall_policy_change_protection)
        if firewall_statuses is not None:
            pulumi.set(__self__, "firewall_statuses", firewall_statuses)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if subnet_change_protection is not None:
            pulumi.set(__self__, "subnet_change_protection", subnet_change_protection)
        if subnet_mappings is not None:
            pulumi.set(__self__, "subnet_mappings", subnet_mappings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if transit_gateway_id is not None:
            pulumi.set(__self__, "transit_gateway_id", transit_gateway_id)
        if transit_gateway_owner_account_id is not None:
            pulumi.set(__self__, "transit_gateway_owner_account_id", transit_gateway_owner_account_id)
        if update_token is not None:
            pulumi.set(__self__, "update_token", update_token)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) that identifies the firewall.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneChangeProtection")
    def availability_zone_change_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A setting indicating whether the firewall is protected against changes to its Availability Zone configuration. When set to `true`, you must first disable this protection before adding or removing Availability Zones.
        """
        return pulumi.get(self, "availability_zone_change_protection")

    @availability_zone_change_protection.setter
    def availability_zone_change_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "availability_zone_change_protection", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneMappings")
    def availability_zone_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallAvailabilityZoneMappingArgs']]]]:
        """
        Required when creating a transit gateway-attached firewall. Set of configuration blocks describing the avaiability availability where you want to create firewall endpoints for a transit gateway-attached firewall.
        """
        return pulumi.get(self, "availability_zone_mappings")

    @availability_zone_mappings.setter
    def availability_zone_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallAvailabilityZoneMappingArgs']]]]):
        pulumi.set(self, "availability_zone_mappings", value)

    @_builtins.property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A flag indicating whether the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. Defaults to `false`.
        """
        return pulumi.get(self, "delete_protection")

    @delete_protection.setter
    def delete_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A friendly description of the firewall.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enabledAnalysisTypes")
    def enabled_analysis_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of types for which to collect analysis metrics. See [Reporting on network traffic in Network Firewall](https://docs.aws.amazon.com/network-firewall/latest/developerguide/reporting.html) for details on how to use the data. Valid values: `TLS_SNI`, `HTTP_HOST`. Defaults to `[]`.
        """
        return pulumi.get(self, "enabled_analysis_types")

    @enabled_analysis_types.setter
    def enabled_analysis_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enabled_analysis_types", value)

    @_builtins.property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional[pulumi.Input['FirewallEncryptionConfigurationArgs']]:
        """
        KMS encryption configuration settings. See Encryption Configuration below for details.
        """
        return pulumi.get(self, "encryption_configuration")

    @encryption_configuration.setter
    def encryption_configuration(self, value: Optional[pulumi.Input['FirewallEncryptionConfigurationArgs']]):
        pulumi.set(self, "encryption_configuration", value)

    @_builtins.property
    @pulumi.getter(name="firewallPolicyArn")
    def firewall_policy_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the VPC Firewall policy.
        """
        return pulumi.get(self, "firewall_policy_arn")

    @firewall_policy_arn.setter
    def firewall_policy_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "firewall_policy_arn", value)

    @_builtins.property
    @pulumi.getter(name="firewallPolicyChangeProtection")
    def firewall_policy_change_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A flag indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. Defaults to `false`.
        """
        return pulumi.get(self, "firewall_policy_change_protection")

    @firewall_policy_change_protection.setter
    def firewall_policy_change_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "firewall_policy_change_protection", value)

    @_builtins.property
    @pulumi.getter(name="firewallStatuses")
    def firewall_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallFirewallStatusArgs']]]]:
        """
        Nested list of information about the current status of the firewall.
        """
        return pulumi.get(self, "firewall_statuses")

    @firewall_statuses.setter
    def firewall_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallFirewallStatusArgs']]]]):
        pulumi.set(self, "firewall_statuses", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A friendly name of the firewall.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="subnetChangeProtection")
    def subnet_change_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A flag indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. Defaults to `false`.
        """
        return pulumi.get(self, "subnet_change_protection")

    @subnet_change_protection.setter
    def subnet_change_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "subnet_change_protection", value)

    @_builtins.property
    @pulumi.getter(name="subnetMappings")
    def subnet_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallSubnetMappingArgs']]]]:
        """
        Required when creating a VPC attached firewall. Set of configuration blocks describing the public subnets. Each subnet must belong to a different Availability Zone in the VPC. AWS Network Firewall creates a firewall endpoint in each subnet. See Subnet Mapping below for details.
        """
        return pulumi.get(self, "subnet_mappings")

    @subnet_mappings.setter
    def subnet_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallSubnetMappingArgs']]]]):
        pulumi.set(self, "subnet_mappings", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="transitGatewayId")
    def transit_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Required when creating a transit gateway-attached firewall. The unique identifier of the transit gateway to attach to this firewall. You can provide either a transit gateway from your account or one that has been shared with you through AWS Resource Access Manager
        """
        return pulumi.get(self, "transit_gateway_id")

    @transit_gateway_id.setter
    def transit_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="transitGatewayOwnerAccountId")
    def transit_gateway_owner_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS account ID that owns the transit gateway.
        """
        return pulumi.get(self, "transit_gateway_owner_account_id")

    @transit_gateway_owner_account_id.setter
    def transit_gateway_owner_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_gateway_owner_account_id", value)

    @_builtins.property
    @pulumi.getter(name="updateToken")
    def update_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A string token used when updating a firewall.
        """
        return pulumi.get(self, "update_token")

    @update_token.setter
    def update_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_token", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required when creating a VPC attached firewall. The unique identifier of the VPC where AWS Network Firewall should create the firewall.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("aws:networkfirewall/firewall:Firewall")
class Firewall(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone_change_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zone_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallAvailabilityZoneMappingArgs', 'FirewallAvailabilityZoneMappingArgsDict']]]]] = None,
                 delete_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled_analysis_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 encryption_configuration: Optional[pulumi.Input[Union['FirewallEncryptionConfigurationArgs', 'FirewallEncryptionConfigurationArgsDict']]] = None,
                 firewall_policy_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_policy_change_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_change_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnet_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallSubnetMappingArgs', 'FirewallSubnetMappingArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an AWS Network Firewall Firewall Resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkfirewall.Firewall("example",
            name="example",
            firewall_policy_arn=example_aws_networkfirewall_firewall_policy["arn"],
            vpc_id=example_aws_vpc["id"],
            enabled_analysis_types=[
                "TLS_SNI",
                "HTTP_HOST",
            ],
            subnet_mappings=[{
                "subnet_id": example_aws_subnet["id"],
            }],
            tags={
                "Tag1": "Value1",
                "Tag2": "Value2",
            })
        ```

        ### Transit Gateway Attached Firewall

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.get_availability_zones(state="available")
        example_firewall = aws.networkfirewall.Firewall("example",
            name="example",
            firewall_policy_arn=example_aws_networkfirewall_firewall_policy["arn"],
            transit_gateway_id=example_aws_ec2_transit_gateway["id"],
            availability_zone_mappings=[
                {
                    "availability_zone_id": example.zone_ids[0],
                },
                {
                    "availability_zone_id": example.zone_ids[1],
                },
            ])
        ```

        ### Transit Gateway Attached Firewall (Cross Account)

        A full example of how to create a Transit Gateway in one AWS account, share it with a second AWS account, and create Network Firewall in the second account to the Transit Gateway via the `networkfirewall.Firewall` and `aws_networkfirewall_network_firewall_transit_gateway_attachment_accepter` resources can be found in the `./examples/network-firewall-cross-account-transit-gateway` directory within the Github Repository

        ## Import

        Using `pulumi import`, import Network Firewall Firewalls using their `arn`. For example:

        ```sh
        $ pulumi import aws:networkfirewall/firewall:Firewall example arn:aws:network-firewall:us-west-1:123456789012:firewall/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] availability_zone_change_protection: A setting indicating whether the firewall is protected against changes to its Availability Zone configuration. When set to `true`, you must first disable this protection before adding or removing Availability Zones.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallAvailabilityZoneMappingArgs', 'FirewallAvailabilityZoneMappingArgsDict']]]] availability_zone_mappings: Required when creating a transit gateway-attached firewall. Set of configuration blocks describing the avaiability availability where you want to create firewall endpoints for a transit gateway-attached firewall.
        :param pulumi.Input[_builtins.bool] delete_protection: A flag indicating whether the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. Defaults to `false`.
        :param pulumi.Input[_builtins.str] description: A friendly description of the firewall.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_analysis_types: Set of types for which to collect analysis metrics. See [Reporting on network traffic in Network Firewall](https://docs.aws.amazon.com/network-firewall/latest/developerguide/reporting.html) for details on how to use the data. Valid values: `TLS_SNI`, `HTTP_HOST`. Defaults to `[]`.
        :param pulumi.Input[Union['FirewallEncryptionConfigurationArgs', 'FirewallEncryptionConfigurationArgsDict']] encryption_configuration: KMS encryption configuration settings. See Encryption Configuration below for details.
        :param pulumi.Input[_builtins.str] firewall_policy_arn: The Amazon Resource Name (ARN) of the VPC Firewall policy.
        :param pulumi.Input[_builtins.bool] firewall_policy_change_protection: A flag indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: A friendly name of the firewall.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] subnet_change_protection: A flag indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallSubnetMappingArgs', 'FirewallSubnetMappingArgsDict']]]] subnet_mappings: Required when creating a VPC attached firewall. Set of configuration blocks describing the public subnets. Each subnet must belong to a different Availability Zone in the VPC. AWS Network Firewall creates a firewall endpoint in each subnet. See Subnet Mapping below for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] transit_gateway_id: . Required when creating a transit gateway-attached firewall. The unique identifier of the transit gateway to attach to this firewall. You can provide either a transit gateway from your account or one that has been shared with you through AWS Resource Access Manager
        :param pulumi.Input[_builtins.str] vpc_id: Required when creating a VPC attached firewall. The unique identifier of the VPC where AWS Network Firewall should create the firewall.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FirewallArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AWS Network Firewall Firewall Resource

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkfirewall.Firewall("example",
            name="example",
            firewall_policy_arn=example_aws_networkfirewall_firewall_policy["arn"],
            vpc_id=example_aws_vpc["id"],
            enabled_analysis_types=[
                "TLS_SNI",
                "HTTP_HOST",
            ],
            subnet_mappings=[{
                "subnet_id": example_aws_subnet["id"],
            }],
            tags={
                "Tag1": "Value1",
                "Tag2": "Value2",
            })
        ```

        ### Transit Gateway Attached Firewall

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.get_availability_zones(state="available")
        example_firewall = aws.networkfirewall.Firewall("example",
            name="example",
            firewall_policy_arn=example_aws_networkfirewall_firewall_policy["arn"],
            transit_gateway_id=example_aws_ec2_transit_gateway["id"],
            availability_zone_mappings=[
                {
                    "availability_zone_id": example.zone_ids[0],
                },
                {
                    "availability_zone_id": example.zone_ids[1],
                },
            ])
        ```

        ### Transit Gateway Attached Firewall (Cross Account)

        A full example of how to create a Transit Gateway in one AWS account, share it with a second AWS account, and create Network Firewall in the second account to the Transit Gateway via the `networkfirewall.Firewall` and `aws_networkfirewall_network_firewall_transit_gateway_attachment_accepter` resources can be found in the `./examples/network-firewall-cross-account-transit-gateway` directory within the Github Repository

        ## Import

        Using `pulumi import`, import Network Firewall Firewalls using their `arn`. For example:

        ```sh
        $ pulumi import aws:networkfirewall/firewall:Firewall example arn:aws:network-firewall:us-west-1:123456789012:firewall/example
        ```

        :param str resource_name: The name of the resource.
        :param FirewallArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FirewallArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone_change_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zone_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallAvailabilityZoneMappingArgs', 'FirewallAvailabilityZoneMappingArgsDict']]]]] = None,
                 delete_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled_analysis_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 encryption_configuration: Optional[pulumi.Input[Union['FirewallEncryptionConfigurationArgs', 'FirewallEncryptionConfigurationArgsDict']]] = None,
                 firewall_policy_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_policy_change_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_change_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnet_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallSubnetMappingArgs', 'FirewallSubnetMappingArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FirewallArgs.__new__(FirewallArgs)

            __props__.__dict__["availability_zone_change_protection"] = availability_zone_change_protection
            __props__.__dict__["availability_zone_mappings"] = availability_zone_mappings
            __props__.__dict__["delete_protection"] = delete_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["enabled_analysis_types"] = enabled_analysis_types
            __props__.__dict__["encryption_configuration"] = encryption_configuration
            if firewall_policy_arn is None and not opts.urn:
                raise TypeError("Missing required property 'firewall_policy_arn'")
            __props__.__dict__["firewall_policy_arn"] = firewall_policy_arn
            __props__.__dict__["firewall_policy_change_protection"] = firewall_policy_change_protection
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["subnet_change_protection"] = subnet_change_protection
            __props__.__dict__["subnet_mappings"] = subnet_mappings
            __props__.__dict__["tags"] = tags
            __props__.__dict__["transit_gateway_id"] = transit_gateway_id
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["firewall_statuses"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["transit_gateway_owner_account_id"] = None
            __props__.__dict__["update_token"] = None
        super(Firewall, __self__).__init__(
            'aws:networkfirewall/firewall:Firewall',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zone_change_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            availability_zone_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallAvailabilityZoneMappingArgs', 'FirewallAvailabilityZoneMappingArgsDict']]]]] = None,
            delete_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enabled_analysis_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            encryption_configuration: Optional[pulumi.Input[Union['FirewallEncryptionConfigurationArgs', 'FirewallEncryptionConfigurationArgsDict']]] = None,
            firewall_policy_arn: Optional[pulumi.Input[_builtins.str]] = None,
            firewall_policy_change_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            firewall_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallFirewallStatusArgs', 'FirewallFirewallStatusArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_change_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            subnet_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallSubnetMappingArgs', 'FirewallSubnetMappingArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            transit_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            transit_gateway_owner_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            update_token: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Firewall':
        """
        Get an existing Firewall resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) that identifies the firewall.
        :param pulumi.Input[_builtins.bool] availability_zone_change_protection: A setting indicating whether the firewall is protected against changes to its Availability Zone configuration. When set to `true`, you must first disable this protection before adding or removing Availability Zones.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallAvailabilityZoneMappingArgs', 'FirewallAvailabilityZoneMappingArgsDict']]]] availability_zone_mappings: Required when creating a transit gateway-attached firewall. Set of configuration blocks describing the avaiability availability where you want to create firewall endpoints for a transit gateway-attached firewall.
        :param pulumi.Input[_builtins.bool] delete_protection: A flag indicating whether the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. Defaults to `false`.
        :param pulumi.Input[_builtins.str] description: A friendly description of the firewall.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_analysis_types: Set of types for which to collect analysis metrics. See [Reporting on network traffic in Network Firewall](https://docs.aws.amazon.com/network-firewall/latest/developerguide/reporting.html) for details on how to use the data. Valid values: `TLS_SNI`, `HTTP_HOST`. Defaults to `[]`.
        :param pulumi.Input[Union['FirewallEncryptionConfigurationArgs', 'FirewallEncryptionConfigurationArgsDict']] encryption_configuration: KMS encryption configuration settings. See Encryption Configuration below for details.
        :param pulumi.Input[_builtins.str] firewall_policy_arn: The Amazon Resource Name (ARN) of the VPC Firewall policy.
        :param pulumi.Input[_builtins.bool] firewall_policy_change_protection: A flag indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallFirewallStatusArgs', 'FirewallFirewallStatusArgsDict']]]] firewall_statuses: Nested list of information about the current status of the firewall.
        :param pulumi.Input[_builtins.str] name: A friendly name of the firewall.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] subnet_change_protection: A flag indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallSubnetMappingArgs', 'FirewallSubnetMappingArgsDict']]]] subnet_mappings: Required when creating a VPC attached firewall. Set of configuration blocks describing the public subnets. Each subnet must belong to a different Availability Zone in the VPC. AWS Network Firewall creates a firewall endpoint in each subnet. See Subnet Mapping below for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] transit_gateway_id: . Required when creating a transit gateway-attached firewall. The unique identifier of the transit gateway to attach to this firewall. You can provide either a transit gateway from your account or one that has been shared with you through AWS Resource Access Manager
        :param pulumi.Input[_builtins.str] transit_gateway_owner_account_id: The AWS account ID that owns the transit gateway.
        :param pulumi.Input[_builtins.str] update_token: A string token used when updating a firewall.
        :param pulumi.Input[_builtins.str] vpc_id: Required when creating a VPC attached firewall. The unique identifier of the VPC where AWS Network Firewall should create the firewall.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FirewallState.__new__(_FirewallState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["availability_zone_change_protection"] = availability_zone_change_protection
        __props__.__dict__["availability_zone_mappings"] = availability_zone_mappings
        __props__.__dict__["delete_protection"] = delete_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled_analysis_types"] = enabled_analysis_types
        __props__.__dict__["encryption_configuration"] = encryption_configuration
        __props__.__dict__["firewall_policy_arn"] = firewall_policy_arn
        __props__.__dict__["firewall_policy_change_protection"] = firewall_policy_change_protection
        __props__.__dict__["firewall_statuses"] = firewall_statuses
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["subnet_change_protection"] = subnet_change_protection
        __props__.__dict__["subnet_mappings"] = subnet_mappings
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["transit_gateway_id"] = transit_gateway_id
        __props__.__dict__["transit_gateway_owner_account_id"] = transit_gateway_owner_account_id
        __props__.__dict__["update_token"] = update_token
        __props__.__dict__["vpc_id"] = vpc_id
        return Firewall(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) that identifies the firewall.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="availabilityZoneChangeProtection")
    def availability_zone_change_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A setting indicating whether the firewall is protected against changes to its Availability Zone configuration. When set to `true`, you must first disable this protection before adding or removing Availability Zones.
        """
        return pulumi.get(self, "availability_zone_change_protection")

    @_builtins.property
    @pulumi.getter(name="availabilityZoneMappings")
    def availability_zone_mappings(self) -> pulumi.Output[Sequence['outputs.FirewallAvailabilityZoneMapping']]:
        """
        Required when creating a transit gateway-attached firewall. Set of configuration blocks describing the avaiability availability where you want to create firewall endpoints for a transit gateway-attached firewall.
        """
        return pulumi.get(self, "availability_zone_mappings")

    @_builtins.property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A flag indicating whether the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. Defaults to `false`.
        """
        return pulumi.get(self, "delete_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A friendly description of the firewall.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enabledAnalysisTypes")
    def enabled_analysis_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Set of types for which to collect analysis metrics. See [Reporting on network traffic in Network Firewall](https://docs.aws.amazon.com/network-firewall/latest/developerguide/reporting.html) for details on how to use the data. Valid values: `TLS_SNI`, `HTTP_HOST`. Defaults to `[]`.
        """
        return pulumi.get(self, "enabled_analysis_types")

    @_builtins.property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> pulumi.Output[Optional['outputs.FirewallEncryptionConfiguration']]:
        """
        KMS encryption configuration settings. See Encryption Configuration below for details.
        """
        return pulumi.get(self, "encryption_configuration")

    @_builtins.property
    @pulumi.getter(name="firewallPolicyArn")
    def firewall_policy_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) of the VPC Firewall policy.
        """
        return pulumi.get(self, "firewall_policy_arn")

    @_builtins.property
    @pulumi.getter(name="firewallPolicyChangeProtection")
    def firewall_policy_change_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A flag indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. Defaults to `false`.
        """
        return pulumi.get(self, "firewall_policy_change_protection")

    @_builtins.property
    @pulumi.getter(name="firewallStatuses")
    def firewall_statuses(self) -> pulumi.Output[Sequence['outputs.FirewallFirewallStatus']]:
        """
        Nested list of information about the current status of the firewall.
        """
        return pulumi.get(self, "firewall_statuses")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A friendly name of the firewall.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="subnetChangeProtection")
    def subnet_change_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A flag indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. Defaults to `false`.
        """
        return pulumi.get(self, "subnet_change_protection")

    @_builtins.property
    @pulumi.getter(name="subnetMappings")
    def subnet_mappings(self) -> pulumi.Output[Optional[Sequence['outputs.FirewallSubnetMapping']]]:
        """
        Required when creating a VPC attached firewall. Set of configuration blocks describing the public subnets. Each subnet must belong to a different Availability Zone in the VPC. AWS Network Firewall creates a firewall endpoint in each subnet. See Subnet Mapping below for details.
        """
        return pulumi.get(self, "subnet_mappings")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="transitGatewayId")
    def transit_gateway_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        . Required when creating a transit gateway-attached firewall. The unique identifier of the transit gateway to attach to this firewall. You can provide either a transit gateway from your account or one that has been shared with you through AWS Resource Access Manager
        """
        return pulumi.get(self, "transit_gateway_id")

    @_builtins.property
    @pulumi.getter(name="transitGatewayOwnerAccountId")
    def transit_gateway_owner_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The AWS account ID that owns the transit gateway.
        """
        return pulumi.get(self, "transit_gateway_owner_account_id")

    @_builtins.property
    @pulumi.getter(name="updateToken")
    def update_token(self) -> pulumi.Output[_builtins.str]:
        """
        A string token used when updating a firewall.
        """
        return pulumi.get(self, "update_token")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Required when creating a VPC attached firewall. The unique identifier of the VPC where AWS Network Firewall should create the firewall.
        """
        return pulumi.get(self, "vpc_id")

