# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpcEndpointAssociationArgs', 'VpcEndpointAssociation']

@pulumi.input_type
class VpcEndpointAssociationArgs:
    def __init__(__self__, *,
                 firewall_arn: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_mapping: Optional[pulumi.Input['VpcEndpointAssociationSubnetMappingArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['VpcEndpointAssociationTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a VpcEndpointAssociation resource.
        :param pulumi.Input[_builtins.str] firewall_arn: The Amazon Resource Name (ARN) that identifies the firewall.
        :param pulumi.Input[_builtins.str] vpc_id: The unique identifier of the VPC for the endpoint association.
        :param pulumi.Input[_builtins.str] description: A description of the VPC endpoint association.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['VpcEndpointAssociationSubnetMappingArgs'] subnet_mapping: The ID for a subnet that's used in an association with a firewall. See Subnet Mapping below for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "firewall_arn", firewall_arn)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if subnet_mapping is not None:
            pulumi.set(__self__, "subnet_mapping", subnet_mapping)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="firewallArn")
    def firewall_arn(self) -> pulumi.Input[_builtins.str]:
        """
        The Amazon Resource Name (ARN) that identifies the firewall.
        """
        return pulumi.get(self, "firewall_arn")

    @firewall_arn.setter
    def firewall_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "firewall_arn", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique identifier of the VPC for the endpoint association.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the VPC endpoint association.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="subnetMapping")
    def subnet_mapping(self) -> Optional[pulumi.Input['VpcEndpointAssociationSubnetMappingArgs']]:
        """
        The ID for a subnet that's used in an association with a firewall. See Subnet Mapping below for details.
        """
        return pulumi.get(self, "subnet_mapping")

    @subnet_mapping.setter
    def subnet_mapping(self, value: Optional[pulumi.Input['VpcEndpointAssociationSubnetMappingArgs']]):
        pulumi.set(self, "subnet_mapping", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['VpcEndpointAssociationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['VpcEndpointAssociationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _VpcEndpointAssociationState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_mapping: Optional[pulumi.Input['VpcEndpointAssociationSubnetMappingArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['VpcEndpointAssociationTimeoutsArgs']] = None,
                 vpc_endpoint_association_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_endpoint_association_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_endpoint_association_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['VpcEndpointAssociationVpcEndpointAssociationStatusArgs']]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VpcEndpointAssociation resources.
        :param pulumi.Input[_builtins.str] description: A description of the VPC endpoint association.
        :param pulumi.Input[_builtins.str] firewall_arn: The Amazon Resource Name (ARN) that identifies the firewall.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['VpcEndpointAssociationSubnetMappingArgs'] subnet_mapping: The ID for a subnet that's used in an association with a firewall. See Subnet Mapping below for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] vpc_endpoint_association_arn: ARN of the VPC Endpoint Association.
        :param pulumi.Input[_builtins.str] vpc_endpoint_association_id: The unique identifier of the VPC endpoint association.
        :param pulumi.Input[Sequence[pulumi.Input['VpcEndpointAssociationVpcEndpointAssociationStatusArgs']]] vpc_endpoint_association_statuses: Nested list of information about the current status of the VPC Endpoint Association.
        :param pulumi.Input[_builtins.str] vpc_id: The unique identifier of the VPC for the endpoint association.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if firewall_arn is not None:
            pulumi.set(__self__, "firewall_arn", firewall_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if subnet_mapping is not None:
            pulumi.set(__self__, "subnet_mapping", subnet_mapping)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if vpc_endpoint_association_arn is not None:
            pulumi.set(__self__, "vpc_endpoint_association_arn", vpc_endpoint_association_arn)
        if vpc_endpoint_association_id is not None:
            pulumi.set(__self__, "vpc_endpoint_association_id", vpc_endpoint_association_id)
        if vpc_endpoint_association_statuses is not None:
            pulumi.set(__self__, "vpc_endpoint_association_statuses", vpc_endpoint_association_statuses)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the VPC endpoint association.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="firewallArn")
    def firewall_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) that identifies the firewall.
        """
        return pulumi.get(self, "firewall_arn")

    @firewall_arn.setter
    def firewall_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "firewall_arn", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="subnetMapping")
    def subnet_mapping(self) -> Optional[pulumi.Input['VpcEndpointAssociationSubnetMappingArgs']]:
        """
        The ID for a subnet that's used in an association with a firewall. See Subnet Mapping below for details.
        """
        return pulumi.get(self, "subnet_mapping")

    @subnet_mapping.setter
    def subnet_mapping(self, value: Optional[pulumi.Input['VpcEndpointAssociationSubnetMappingArgs']]):
        pulumi.set(self, "subnet_mapping", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['VpcEndpointAssociationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['VpcEndpointAssociationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="vpcEndpointAssociationArn")
    def vpc_endpoint_association_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the VPC Endpoint Association.
        """
        return pulumi.get(self, "vpc_endpoint_association_arn")

    @vpc_endpoint_association_arn.setter
    def vpc_endpoint_association_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_endpoint_association_arn", value)

    @_builtins.property
    @pulumi.getter(name="vpcEndpointAssociationId")
    def vpc_endpoint_association_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the VPC endpoint association.
        """
        return pulumi.get(self, "vpc_endpoint_association_id")

    @vpc_endpoint_association_id.setter
    def vpc_endpoint_association_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_endpoint_association_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcEndpointAssociationStatuses")
    def vpc_endpoint_association_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcEndpointAssociationVpcEndpointAssociationStatusArgs']]]]:
        """
        Nested list of information about the current status of the VPC Endpoint Association.
        """
        return pulumi.get(self, "vpc_endpoint_association_statuses")

    @vpc_endpoint_association_statuses.setter
    def vpc_endpoint_association_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcEndpointAssociationVpcEndpointAssociationStatusArgs']]]]):
        pulumi.set(self, "vpc_endpoint_association_statuses", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the VPC for the endpoint association.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("aws:networkfirewall/vpcEndpointAssociation:VpcEndpointAssociation")
class VpcEndpointAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_mapping: Optional[pulumi.Input[Union['VpcEndpointAssociationSubnetMappingArgs', 'VpcEndpointAssociationSubnetMappingArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['VpcEndpointAssociationTimeoutsArgs', 'VpcEndpointAssociationTimeoutsArgsDict']]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a firewall endpoint for an AWS Network Firewall firewall.

        Use `networkfirewall.VpcEndpointAssociation` to establish new firewall endpoints in any Availability Zone where the firewall is already being used. The first use of a firewall in an Availability Zone must be defined by `networkfirewall.Firewall` resource and `subnet_mapping` argument.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkfirewall.VpcEndpointAssociation("example",
            firewall_arn=example_aws_networkfirewall_firewall["arn"],
            vpc_id=example_aws_vpc["id"],
            subnet_mapping={
                "subnet_id": example_two["id"],
            },
            tags={
                "Name": "example endpoint",
            })
        ```

        ## Import

        Using `pulumi import`, import Network Firewall VPC Endpoint Association using the `vpc_endpoint_association_arn`. For example:

        ```sh
        $ pulumi import aws:networkfirewall/vpcEndpointAssociation:VpcEndpointAssociation example arn:aws:network-firewall:us-west-1:123456789012:vpc-endpoint-association/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description of the VPC endpoint association.
        :param pulumi.Input[_builtins.str] firewall_arn: The Amazon Resource Name (ARN) that identifies the firewall.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['VpcEndpointAssociationSubnetMappingArgs', 'VpcEndpointAssociationSubnetMappingArgsDict']] subnet_mapping: The ID for a subnet that's used in an association with a firewall. See Subnet Mapping below for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] vpc_id: The unique identifier of the VPC for the endpoint association.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcEndpointAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a firewall endpoint for an AWS Network Firewall firewall.

        Use `networkfirewall.VpcEndpointAssociation` to establish new firewall endpoints in any Availability Zone where the firewall is already being used. The first use of a firewall in an Availability Zone must be defined by `networkfirewall.Firewall` resource and `subnet_mapping` argument.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkfirewall.VpcEndpointAssociation("example",
            firewall_arn=example_aws_networkfirewall_firewall["arn"],
            vpc_id=example_aws_vpc["id"],
            subnet_mapping={
                "subnet_id": example_two["id"],
            },
            tags={
                "Name": "example endpoint",
            })
        ```

        ## Import

        Using `pulumi import`, import Network Firewall VPC Endpoint Association using the `vpc_endpoint_association_arn`. For example:

        ```sh
        $ pulumi import aws:networkfirewall/vpcEndpointAssociation:VpcEndpointAssociation example arn:aws:network-firewall:us-west-1:123456789012:vpc-endpoint-association/example
        ```

        :param str resource_name: The name of the resource.
        :param VpcEndpointAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcEndpointAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_mapping: Optional[pulumi.Input[Union['VpcEndpointAssociationSubnetMappingArgs', 'VpcEndpointAssociationSubnetMappingArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['VpcEndpointAssociationTimeoutsArgs', 'VpcEndpointAssociationTimeoutsArgsDict']]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcEndpointAssociationArgs.__new__(VpcEndpointAssociationArgs)

            __props__.__dict__["description"] = description
            if firewall_arn is None and not opts.urn:
                raise TypeError("Missing required property 'firewall_arn'")
            __props__.__dict__["firewall_arn"] = firewall_arn
            __props__.__dict__["region"] = region
            __props__.__dict__["subnet_mapping"] = subnet_mapping
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["vpc_endpoint_association_arn"] = None
            __props__.__dict__["vpc_endpoint_association_id"] = None
            __props__.__dict__["vpc_endpoint_association_statuses"] = None
        super(VpcEndpointAssociation, __self__).__init__(
            'aws:networkfirewall/vpcEndpointAssociation:VpcEndpointAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            firewall_arn: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_mapping: Optional[pulumi.Input[Union['VpcEndpointAssociationSubnetMappingArgs', 'VpcEndpointAssociationSubnetMappingArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['VpcEndpointAssociationTimeoutsArgs', 'VpcEndpointAssociationTimeoutsArgsDict']]] = None,
            vpc_endpoint_association_arn: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_endpoint_association_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_endpoint_association_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpcEndpointAssociationVpcEndpointAssociationStatusArgs', 'VpcEndpointAssociationVpcEndpointAssociationStatusArgsDict']]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VpcEndpointAssociation':
        """
        Get an existing VpcEndpointAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description of the VPC endpoint association.
        :param pulumi.Input[_builtins.str] firewall_arn: The Amazon Resource Name (ARN) that identifies the firewall.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['VpcEndpointAssociationSubnetMappingArgs', 'VpcEndpointAssociationSubnetMappingArgsDict']] subnet_mapping: The ID for a subnet that's used in an association with a firewall. See Subnet Mapping below for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] vpc_endpoint_association_arn: ARN of the VPC Endpoint Association.
        :param pulumi.Input[_builtins.str] vpc_endpoint_association_id: The unique identifier of the VPC endpoint association.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpcEndpointAssociationVpcEndpointAssociationStatusArgs', 'VpcEndpointAssociationVpcEndpointAssociationStatusArgsDict']]]] vpc_endpoint_association_statuses: Nested list of information about the current status of the VPC Endpoint Association.
        :param pulumi.Input[_builtins.str] vpc_id: The unique identifier of the VPC for the endpoint association.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcEndpointAssociationState.__new__(_VpcEndpointAssociationState)

        __props__.__dict__["description"] = description
        __props__.__dict__["firewall_arn"] = firewall_arn
        __props__.__dict__["region"] = region
        __props__.__dict__["subnet_mapping"] = subnet_mapping
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["vpc_endpoint_association_arn"] = vpc_endpoint_association_arn
        __props__.__dict__["vpc_endpoint_association_id"] = vpc_endpoint_association_id
        __props__.__dict__["vpc_endpoint_association_statuses"] = vpc_endpoint_association_statuses
        __props__.__dict__["vpc_id"] = vpc_id
        return VpcEndpointAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of the VPC endpoint association.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="firewallArn")
    def firewall_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) that identifies the firewall.
        """
        return pulumi.get(self, "firewall_arn")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="subnetMapping")
    def subnet_mapping(self) -> pulumi.Output[Optional['outputs.VpcEndpointAssociationSubnetMapping']]:
        """
        The ID for a subnet that's used in an association with a firewall. See Subnet Mapping below for details.
        """
        return pulumi.get(self, "subnet_mapping")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.VpcEndpointAssociationTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="vpcEndpointAssociationArn")
    def vpc_endpoint_association_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the VPC Endpoint Association.
        """
        return pulumi.get(self, "vpc_endpoint_association_arn")

    @_builtins.property
    @pulumi.getter(name="vpcEndpointAssociationId")
    def vpc_endpoint_association_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the VPC endpoint association.
        """
        return pulumi.get(self, "vpc_endpoint_association_id")

    @_builtins.property
    @pulumi.getter(name="vpcEndpointAssociationStatuses")
    def vpc_endpoint_association_statuses(self) -> pulumi.Output[Sequence['outputs.VpcEndpointAssociationVpcEndpointAssociationStatus']]:
        """
        Nested list of information about the current status of the VPC Endpoint Association.
        """
        return pulumi.get(self, "vpc_endpoint_association_statuses")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the VPC for the endpoint association.
        """
        return pulumi.get(self, "vpc_id")

