# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TransitGatewayPeeringArgs', 'TransitGatewayPeering']

@pulumi.input_type
class TransitGatewayPeeringArgs:
    def __init__(__self__, *,
                 core_network_id: pulumi.Input[_builtins.str],
                 transit_gateway_arn: pulumi.Input[_builtins.str],
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a TransitGatewayPeering resource.
        :param pulumi.Input[_builtins.str] core_network_id: ID of a core network.
        :param pulumi.Input[_builtins.str] transit_gateway_arn: ARN of the transit gateway for the peering request.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value tags for the peering. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "core_network_id", core_network_id)
        pulumi.set(__self__, "transit_gateway_arn", transit_gateway_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="coreNetworkId")
    def core_network_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of a core network.
        """
        return pulumi.get(self, "core_network_id")

    @core_network_id.setter
    def core_network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "core_network_id", value)

    @_builtins.property
    @pulumi.getter(name="transitGatewayArn")
    def transit_gateway_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN of the transit gateway for the peering request.

        The following arguments are optional:
        """
        return pulumi.get(self, "transit_gateway_arn")

    @transit_gateway_arn.setter
    def transit_gateway_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "transit_gateway_arn", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value tags for the peering. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _TransitGatewayPeeringState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 core_network_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 core_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_location: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peering_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_gateway_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_gateway_peering_attachment_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TransitGatewayPeering resources.
        :param pulumi.Input[_builtins.str] arn: Peering ARN.
        :param pulumi.Input[_builtins.str] core_network_arn: ARN of the core network.
        :param pulumi.Input[_builtins.str] core_network_id: ID of a core network.
        :param pulumi.Input[_builtins.str] edge_location: Edge location for the peer.
        :param pulumi.Input[_builtins.str] owner_account_id: ID of the account owner.
        :param pulumi.Input[_builtins.str] peering_type: Type of peering. This will be `TRANSIT_GATEWAY`.
        :param pulumi.Input[_builtins.str] resource_arn: Resource ARN of the peer.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value tags for the peering. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] transit_gateway_arn: ARN of the transit gateway for the peering request.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] transit_gateway_peering_attachment_id: ID of the transit gateway peering attachment.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if core_network_arn is not None:
            pulumi.set(__self__, "core_network_arn", core_network_arn)
        if core_network_id is not None:
            pulumi.set(__self__, "core_network_id", core_network_id)
        if edge_location is not None:
            pulumi.set(__self__, "edge_location", edge_location)
        if owner_account_id is not None:
            pulumi.set(__self__, "owner_account_id", owner_account_id)
        if peering_type is not None:
            pulumi.set(__self__, "peering_type", peering_type)
        if resource_arn is not None:
            pulumi.set(__self__, "resource_arn", resource_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if transit_gateway_arn is not None:
            pulumi.set(__self__, "transit_gateway_arn", transit_gateway_arn)
        if transit_gateway_peering_attachment_id is not None:
            pulumi.set(__self__, "transit_gateway_peering_attachment_id", transit_gateway_peering_attachment_id)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Peering ARN.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="coreNetworkArn")
    def core_network_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the core network.
        """
        return pulumi.get(self, "core_network_arn")

    @core_network_arn.setter
    def core_network_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "core_network_arn", value)

    @_builtins.property
    @pulumi.getter(name="coreNetworkId")
    def core_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of a core network.
        """
        return pulumi.get(self, "core_network_id")

    @core_network_id.setter
    def core_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "core_network_id", value)

    @_builtins.property
    @pulumi.getter(name="edgeLocation")
    def edge_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Edge location for the peer.
        """
        return pulumi.get(self, "edge_location")

    @edge_location.setter
    def edge_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_location", value)

    @_builtins.property
    @pulumi.getter(name="ownerAccountId")
    def owner_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the account owner.
        """
        return pulumi.get(self, "owner_account_id")

    @owner_account_id.setter
    def owner_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_account_id", value)

    @_builtins.property
    @pulumi.getter(name="peeringType")
    def peering_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of peering. This will be `TRANSIT_GATEWAY`.
        """
        return pulumi.get(self, "peering_type")

    @peering_type.setter
    def peering_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peering_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ARN of the peer.
        """
        return pulumi.get(self, "resource_arn")

    @resource_arn.setter
    def resource_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_arn", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value tags for the peering. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="transitGatewayArn")
    def transit_gateway_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the transit gateway for the peering request.

        The following arguments are optional:
        """
        return pulumi.get(self, "transit_gateway_arn")

    @transit_gateway_arn.setter
    def transit_gateway_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_gateway_arn", value)

    @_builtins.property
    @pulumi.getter(name="transitGatewayPeeringAttachmentId")
    def transit_gateway_peering_attachment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the transit gateway peering attachment.
        """
        return pulumi.get(self, "transit_gateway_peering_attachment_id")

    @transit_gateway_peering_attachment_id.setter
    def transit_gateway_peering_attachment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_gateway_peering_attachment_id", value)


@pulumi.type_token("aws:networkmanager/transitGatewayPeering:TransitGatewayPeering")
class TransitGatewayPeering(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 core_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_gateway_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Network Manager transit gateway peering connection. Creates a peering connection between an AWS Cloud WAN core network and an AWS Transit Gateway.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkmanager.TransitGatewayPeering("example",
            core_network_id=example_awscc_networkmanager_core_network["id"],
            transit_gateway_arn=example_aws_ec2_transit_gateway["arn"],
            opts = pulumi.ResourceOptions(depends_on=[
                    example_aws_ec2_transit_gateway_policy_table,
                    example_aws_networkmanager_core_network_policy_attachment,
                ]))
        ```

        ## Import

        Using `pulumi import`, import `aws_networkmanager_transit_gateway_peering` using the peering ID. For example:

        ```sh
        $ pulumi import aws:networkmanager/transitGatewayPeering:TransitGatewayPeering example peering-444555aaabbb11223
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] core_network_id: ID of a core network.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value tags for the peering. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] transit_gateway_arn: ARN of the transit gateway for the peering request.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TransitGatewayPeeringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Network Manager transit gateway peering connection. Creates a peering connection between an AWS Cloud WAN core network and an AWS Transit Gateway.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkmanager.TransitGatewayPeering("example",
            core_network_id=example_awscc_networkmanager_core_network["id"],
            transit_gateway_arn=example_aws_ec2_transit_gateway["arn"],
            opts = pulumi.ResourceOptions(depends_on=[
                    example_aws_ec2_transit_gateway_policy_table,
                    example_aws_networkmanager_core_network_policy_attachment,
                ]))
        ```

        ## Import

        Using `pulumi import`, import `aws_networkmanager_transit_gateway_peering` using the peering ID. For example:

        ```sh
        $ pulumi import aws:networkmanager/transitGatewayPeering:TransitGatewayPeering example peering-444555aaabbb11223
        ```

        :param str resource_name: The name of the resource.
        :param TransitGatewayPeeringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransitGatewayPeeringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 core_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_gateway_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransitGatewayPeeringArgs.__new__(TransitGatewayPeeringArgs)

            if core_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'core_network_id'")
            __props__.__dict__["core_network_id"] = core_network_id
            __props__.__dict__["tags"] = tags
            if transit_gateway_arn is None and not opts.urn:
                raise TypeError("Missing required property 'transit_gateway_arn'")
            __props__.__dict__["transit_gateway_arn"] = transit_gateway_arn
            __props__.__dict__["arn"] = None
            __props__.__dict__["core_network_arn"] = None
            __props__.__dict__["edge_location"] = None
            __props__.__dict__["owner_account_id"] = None
            __props__.__dict__["peering_type"] = None
            __props__.__dict__["resource_arn"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["transit_gateway_peering_attachment_id"] = None
        super(TransitGatewayPeering, __self__).__init__(
            'aws:networkmanager/transitGatewayPeering:TransitGatewayPeering',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            core_network_arn: Optional[pulumi.Input[_builtins.str]] = None,
            core_network_id: Optional[pulumi.Input[_builtins.str]] = None,
            edge_location: Optional[pulumi.Input[_builtins.str]] = None,
            owner_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            peering_type: Optional[pulumi.Input[_builtins.str]] = None,
            resource_arn: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            transit_gateway_arn: Optional[pulumi.Input[_builtins.str]] = None,
            transit_gateway_peering_attachment_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'TransitGatewayPeering':
        """
        Get an existing TransitGatewayPeering resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: Peering ARN.
        :param pulumi.Input[_builtins.str] core_network_arn: ARN of the core network.
        :param pulumi.Input[_builtins.str] core_network_id: ID of a core network.
        :param pulumi.Input[_builtins.str] edge_location: Edge location for the peer.
        :param pulumi.Input[_builtins.str] owner_account_id: ID of the account owner.
        :param pulumi.Input[_builtins.str] peering_type: Type of peering. This will be `TRANSIT_GATEWAY`.
        :param pulumi.Input[_builtins.str] resource_arn: Resource ARN of the peer.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value tags for the peering. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] transit_gateway_arn: ARN of the transit gateway for the peering request.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] transit_gateway_peering_attachment_id: ID of the transit gateway peering attachment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TransitGatewayPeeringState.__new__(_TransitGatewayPeeringState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["core_network_arn"] = core_network_arn
        __props__.__dict__["core_network_id"] = core_network_id
        __props__.__dict__["edge_location"] = edge_location
        __props__.__dict__["owner_account_id"] = owner_account_id
        __props__.__dict__["peering_type"] = peering_type
        __props__.__dict__["resource_arn"] = resource_arn
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["transit_gateway_arn"] = transit_gateway_arn
        __props__.__dict__["transit_gateway_peering_attachment_id"] = transit_gateway_peering_attachment_id
        return TransitGatewayPeering(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        Peering ARN.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="coreNetworkArn")
    def core_network_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the core network.
        """
        return pulumi.get(self, "core_network_arn")

    @_builtins.property
    @pulumi.getter(name="coreNetworkId")
    def core_network_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of a core network.
        """
        return pulumi.get(self, "core_network_id")

    @_builtins.property
    @pulumi.getter(name="edgeLocation")
    def edge_location(self) -> pulumi.Output[_builtins.str]:
        """
        Edge location for the peer.
        """
        return pulumi.get(self, "edge_location")

    @_builtins.property
    @pulumi.getter(name="ownerAccountId")
    def owner_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the account owner.
        """
        return pulumi.get(self, "owner_account_id")

    @_builtins.property
    @pulumi.getter(name="peeringType")
    def peering_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of peering. This will be `TRANSIT_GATEWAY`.
        """
        return pulumi.get(self, "peering_type")

    @_builtins.property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ARN of the peer.
        """
        return pulumi.get(self, "resource_arn")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value tags for the peering. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="transitGatewayArn")
    def transit_gateway_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the transit gateway for the peering request.

        The following arguments are optional:
        """
        return pulumi.get(self, "transit_gateway_arn")

    @_builtins.property
    @pulumi.getter(name="transitGatewayPeeringAttachmentId")
    def transit_gateway_peering_attachment_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the transit gateway peering attachment.
        """
        return pulumi.get(self, "transit_gateway_peering_attachment_id")

