# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NotificationHubArgs', 'NotificationHub']

@pulumi.input_type
class NotificationHubArgs:
    def __init__(__self__, *,
                 notification_hub_region: pulumi.Input[_builtins.str],
                 timeouts: Optional[pulumi.Input['NotificationHubTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a NotificationHub resource.
        :param pulumi.Input[_builtins.str] notification_hub_region: Notification Hub region.
        """
        pulumi.set(__self__, "notification_hub_region", notification_hub_region)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="notificationHubRegion")
    def notification_hub_region(self) -> pulumi.Input[_builtins.str]:
        """
        Notification Hub region.
        """
        return pulumi.get(self, "notification_hub_region")

    @notification_hub_region.setter
    def notification_hub_region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "notification_hub_region", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['NotificationHubTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['NotificationHubTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _NotificationHubState:
    def __init__(__self__, *,
                 notification_hub_region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['NotificationHubTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering NotificationHub resources.
        :param pulumi.Input[_builtins.str] notification_hub_region: Notification Hub region.
        """
        if notification_hub_region is not None:
            pulumi.set(__self__, "notification_hub_region", notification_hub_region)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="notificationHubRegion")
    def notification_hub_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Notification Hub region.
        """
        return pulumi.get(self, "notification_hub_region")

    @notification_hub_region.setter
    def notification_hub_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notification_hub_region", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['NotificationHubTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['NotificationHubTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:notifications/notificationHub:NotificationHub")
class NotificationHub(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 notification_hub_region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['NotificationHubTimeoutsArgs', 'NotificationHubTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS User Notifications Notification Hub.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.notifications.NotificationHub("example", notification_hub_region="us-west-2")
        ```

        ## Import

        Using `pulumi import`, import User Notifications Notification Hub using the `notification_hub_region`. For example:

        ```sh
        $ pulumi import aws:notifications/notificationHub:NotificationHub example us-west-2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] notification_hub_region: Notification Hub region.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NotificationHubArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS User Notifications Notification Hub.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.notifications.NotificationHub("example", notification_hub_region="us-west-2")
        ```

        ## Import

        Using `pulumi import`, import User Notifications Notification Hub using the `notification_hub_region`. For example:

        ```sh
        $ pulumi import aws:notifications/notificationHub:NotificationHub example us-west-2
        ```

        :param str resource_name: The name of the resource.
        :param NotificationHubArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NotificationHubArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 notification_hub_region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['NotificationHubTimeoutsArgs', 'NotificationHubTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NotificationHubArgs.__new__(NotificationHubArgs)

            if notification_hub_region is None and not opts.urn:
                raise TypeError("Missing required property 'notification_hub_region'")
            __props__.__dict__["notification_hub_region"] = notification_hub_region
            __props__.__dict__["timeouts"] = timeouts
        super(NotificationHub, __self__).__init__(
            'aws:notifications/notificationHub:NotificationHub',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            notification_hub_region: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['NotificationHubTimeoutsArgs', 'NotificationHubTimeoutsArgsDict']]] = None) -> 'NotificationHub':
        """
        Get an existing NotificationHub resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] notification_hub_region: Notification Hub region.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NotificationHubState.__new__(_NotificationHubState)

        __props__.__dict__["notification_hub_region"] = notification_hub_region
        __props__.__dict__["timeouts"] = timeouts
        return NotificationHub(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="notificationHubRegion")
    def notification_hub_region(self) -> pulumi.Output[_builtins.str]:
        """
        Notification Hub region.
        """
        return pulumi.get(self, "notification_hub_region")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.NotificationHubTimeouts']]:
        return pulumi.get(self, "timeouts")

