# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCloudAutonomousVmClustersResult',
    'AwaitableGetCloudAutonomousVmClustersResult',
    'get_cloud_autonomous_vm_clusters',
    'get_cloud_autonomous_vm_clusters_output',
]

@pulumi.output_type
class GetCloudAutonomousVmClustersResult:
    """
    A collection of values returned by getCloudAutonomousVmClusters.
    """
    def __init__(__self__, cloud_autonomous_vm_clusters=None, id=None, region=None):
        if cloud_autonomous_vm_clusters and not isinstance(cloud_autonomous_vm_clusters, list):
            raise TypeError("Expected argument 'cloud_autonomous_vm_clusters' to be a list")
        pulumi.set(__self__, "cloud_autonomous_vm_clusters", cloud_autonomous_vm_clusters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="cloudAutonomousVmClusters")
    def cloud_autonomous_vm_clusters(self) -> Sequence['outputs.GetCloudAutonomousVmClustersCloudAutonomousVmClusterResult']:
        """
        List of Cloud Autonomous VM Clusters. The list going to contain basic information about the cloud autonomous VM clusters.
        """
        return pulumi.get(self, "cloud_autonomous_vm_clusters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetCloudAutonomousVmClustersResult(GetCloudAutonomousVmClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudAutonomousVmClustersResult(
            cloud_autonomous_vm_clusters=self.cloud_autonomous_vm_clusters,
            id=self.id,
            region=self.region)


def get_cloud_autonomous_vm_clusters(region: Optional[_builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudAutonomousVmClustersResult:
    """
    Data source for managing cloud autonomous vm clusters in AWS for Oracle Database@AWS.

    You can find out more about Oracle Database@AWS from [User Guide](https://docs.aws.amazon.com/odb/latest/UserGuide/what-is-odb.html).

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.odb.get_cloud_autonomous_vm_clusters()
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:odb/getCloudAutonomousVmClusters:getCloudAutonomousVmClusters', __args__, opts=opts, typ=GetCloudAutonomousVmClustersResult).value

    return AwaitableGetCloudAutonomousVmClustersResult(
        cloud_autonomous_vm_clusters=pulumi.get(__ret__, 'cloud_autonomous_vm_clusters'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'))
def get_cloud_autonomous_vm_clusters_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudAutonomousVmClustersResult]:
    """
    Data source for managing cloud autonomous vm clusters in AWS for Oracle Database@AWS.

    You can find out more about Oracle Database@AWS from [User Guide](https://docs.aws.amazon.com/odb/latest/UserGuide/what-is-odb.html).

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.odb.get_cloud_autonomous_vm_clusters()
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:odb/getCloudAutonomousVmClusters:getCloudAutonomousVmClusters', __args__, opts=opts, typ=GetCloudAutonomousVmClustersResult)
    return __ret__.apply(lambda __response__: GetCloudAutonomousVmClustersResult(
        cloud_autonomous_vm_clusters=pulumi.get(__response__, 'cloud_autonomous_vm_clusters'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region')))
