# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCloudVmClusterResult',
    'AwaitableGetCloudVmClusterResult',
    'get_cloud_vm_cluster',
    'get_cloud_vm_cluster_output',
]

@pulumi.output_type
class GetCloudVmClusterResult:
    """
    A collection of values returned by getCloudVmCluster.
    """
    def __init__(__self__, arn=None, cloud_exadata_infrastructure_id=None, cluster_name=None, compute_model=None, cpu_core_count=None, created_at=None, data_collection_options=None, data_storage_size_in_tbs=None, db_node_storage_size_in_gbs=None, db_servers=None, disk_redundancy=None, display_name=None, domain=None, gi_version=None, hostname_prefix_computed=None, id=None, iorm_config_caches=None, is_local_backup_enabled=None, is_sparse_disk_group_enabled=None, last_update_history_entry_id=None, license_model=None, listener_port=None, memory_size_in_gbs=None, node_count=None, oci_resource_anchor_name=None, oci_url=None, ocid=None, odb_network_id=None, percent_progress=None, region=None, scan_dns_name=None, scan_dns_record_id=None, scan_ip_ids=None, shape=None, ssh_public_keys=None, status=None, status_reason=None, storage_size_in_gbs=None, system_version=None, tags=None, timezone=None, vip_ids=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if cloud_exadata_infrastructure_id and not isinstance(cloud_exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'cloud_exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "cloud_exadata_infrastructure_id", cloud_exadata_infrastructure_id)
        if cluster_name and not isinstance(cluster_name, str):
            raise TypeError("Expected argument 'cluster_name' to be a str")
        pulumi.set(__self__, "cluster_name", cluster_name)
        if compute_model and not isinstance(compute_model, str):
            raise TypeError("Expected argument 'compute_model' to be a str")
        pulumi.set(__self__, "compute_model", compute_model)
        if cpu_core_count and not isinstance(cpu_core_count, int):
            raise TypeError("Expected argument 'cpu_core_count' to be a int")
        pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if data_collection_options and not isinstance(data_collection_options, list):
            raise TypeError("Expected argument 'data_collection_options' to be a list")
        pulumi.set(__self__, "data_collection_options", data_collection_options)
        if data_storage_size_in_tbs and not isinstance(data_storage_size_in_tbs, float):
            raise TypeError("Expected argument 'data_storage_size_in_tbs' to be a float")
        pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        if db_node_storage_size_in_gbs and not isinstance(db_node_storage_size_in_gbs, int):
            raise TypeError("Expected argument 'db_node_storage_size_in_gbs' to be a int")
        pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_servers and not isinstance(db_servers, list):
            raise TypeError("Expected argument 'db_servers' to be a list")
        pulumi.set(__self__, "db_servers", db_servers)
        if disk_redundancy and not isinstance(disk_redundancy, str):
            raise TypeError("Expected argument 'disk_redundancy' to be a str")
        pulumi.set(__self__, "disk_redundancy", disk_redundancy)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if gi_version and not isinstance(gi_version, str):
            raise TypeError("Expected argument 'gi_version' to be a str")
        pulumi.set(__self__, "gi_version", gi_version)
        if hostname_prefix_computed and not isinstance(hostname_prefix_computed, str):
            raise TypeError("Expected argument 'hostname_prefix_computed' to be a str")
        pulumi.set(__self__, "hostname_prefix_computed", hostname_prefix_computed)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if iorm_config_caches and not isinstance(iorm_config_caches, list):
            raise TypeError("Expected argument 'iorm_config_caches' to be a list")
        pulumi.set(__self__, "iorm_config_caches", iorm_config_caches)
        if is_local_backup_enabled and not isinstance(is_local_backup_enabled, bool):
            raise TypeError("Expected argument 'is_local_backup_enabled' to be a bool")
        pulumi.set(__self__, "is_local_backup_enabled", is_local_backup_enabled)
        if is_sparse_disk_group_enabled and not isinstance(is_sparse_disk_group_enabled, bool):
            raise TypeError("Expected argument 'is_sparse_disk_group_enabled' to be a bool")
        pulumi.set(__self__, "is_sparse_disk_group_enabled", is_sparse_disk_group_enabled)
        if last_update_history_entry_id and not isinstance(last_update_history_entry_id, str):
            raise TypeError("Expected argument 'last_update_history_entry_id' to be a str")
        pulumi.set(__self__, "last_update_history_entry_id", last_update_history_entry_id)
        if license_model and not isinstance(license_model, str):
            raise TypeError("Expected argument 'license_model' to be a str")
        pulumi.set(__self__, "license_model", license_model)
        if listener_port and not isinstance(listener_port, int):
            raise TypeError("Expected argument 'listener_port' to be a int")
        pulumi.set(__self__, "listener_port", listener_port)
        if memory_size_in_gbs and not isinstance(memory_size_in_gbs, int):
            raise TypeError("Expected argument 'memory_size_in_gbs' to be a int")
        pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if node_count and not isinstance(node_count, int):
            raise TypeError("Expected argument 'node_count' to be a int")
        pulumi.set(__self__, "node_count", node_count)
        if oci_resource_anchor_name and not isinstance(oci_resource_anchor_name, str):
            raise TypeError("Expected argument 'oci_resource_anchor_name' to be a str")
        pulumi.set(__self__, "oci_resource_anchor_name", oci_resource_anchor_name)
        if oci_url and not isinstance(oci_url, str):
            raise TypeError("Expected argument 'oci_url' to be a str")
        pulumi.set(__self__, "oci_url", oci_url)
        if ocid and not isinstance(ocid, str):
            raise TypeError("Expected argument 'ocid' to be a str")
        pulumi.set(__self__, "ocid", ocid)
        if odb_network_id and not isinstance(odb_network_id, str):
            raise TypeError("Expected argument 'odb_network_id' to be a str")
        pulumi.set(__self__, "odb_network_id", odb_network_id)
        if percent_progress and not isinstance(percent_progress, float):
            raise TypeError("Expected argument 'percent_progress' to be a float")
        pulumi.set(__self__, "percent_progress", percent_progress)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if scan_dns_name and not isinstance(scan_dns_name, str):
            raise TypeError("Expected argument 'scan_dns_name' to be a str")
        pulumi.set(__self__, "scan_dns_name", scan_dns_name)
        if scan_dns_record_id and not isinstance(scan_dns_record_id, str):
            raise TypeError("Expected argument 'scan_dns_record_id' to be a str")
        pulumi.set(__self__, "scan_dns_record_id", scan_dns_record_id)
        if scan_ip_ids and not isinstance(scan_ip_ids, list):
            raise TypeError("Expected argument 'scan_ip_ids' to be a list")
        pulumi.set(__self__, "scan_ip_ids", scan_ip_ids)
        if shape and not isinstance(shape, str):
            raise TypeError("Expected argument 'shape' to be a str")
        pulumi.set(__self__, "shape", shape)
        if ssh_public_keys and not isinstance(ssh_public_keys, list):
            raise TypeError("Expected argument 'ssh_public_keys' to be a list")
        pulumi.set(__self__, "ssh_public_keys", ssh_public_keys)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_reason and not isinstance(status_reason, str):
            raise TypeError("Expected argument 'status_reason' to be a str")
        pulumi.set(__self__, "status_reason", status_reason)
        if storage_size_in_gbs and not isinstance(storage_size_in_gbs, int):
            raise TypeError("Expected argument 'storage_size_in_gbs' to be a int")
        pulumi.set(__self__, "storage_size_in_gbs", storage_size_in_gbs)
        if system_version and not isinstance(system_version, str):
            raise TypeError("Expected argument 'system_version' to be a str")
        pulumi.set(__self__, "system_version", system_version)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if timezone and not isinstance(timezone, str):
            raise TypeError("Expected argument 'timezone' to be a str")
        pulumi.set(__self__, "timezone", timezone)
        if vip_ids and not isinstance(vip_ids, list):
            raise TypeError("Expected argument 'vip_ids' to be a list")
        pulumi.set(__self__, "vip_ids", vip_ids)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        The Amazon Resource Name (ARN) for the cloud vm cluster.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> _builtins.str:
        """
        The ID of the Cloud Exadata Infrastructure.
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> _builtins.str:
        """
        The name of the Grid Infrastructure (GI) cluster.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> _builtins.str:
        """
        The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an abstracted measure of compute resources. ECPUs are based on the number of cores elastically allocated from a pool of compute and storage servers. An OCPU is a legacy physical measure of compute resources. OCPUs are based on the physical core of a processor with hyper-threading enabled.
        """
        return pulumi.get(self, "compute_model")

    @_builtins.property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> _builtins.int:
        """
        The number of CPU cores enabled on the VM cluster.
        """
        return pulumi.get(self, "cpu_core_count")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The time when the VM cluster was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> Sequence['outputs.GetCloudVmClusterDataCollectionOptionResult']:
        """
        The set of diagnostic collection options enabled for the VM cluster.
        """
        return pulumi.get(self, "data_collection_options")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> _builtins.float:
        """
        The size of the data disk group, in terabytes (TB), that's allocated for the VM cluster.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @_builtins.property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> _builtins.int:
        """
        The amount of local node storage, in gigabytes (GB), that's allocated for the VM cluster.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> Sequence[_builtins.str]:
        """
        The list of database servers for the VM cluster.
        """
        return pulumi.get(self, "db_servers")

    @_builtins.property
    @pulumi.getter(name="diskRedundancy")
    def disk_redundancy(self) -> _builtins.str:
        """
        The type of redundancy configured for the VM cluster. NORMAL is 2-way redundancy. HIGH is 3-way redundancy.
        """
        return pulumi.get(self, "disk_redundancy")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the VM cluster.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        The domain name of the VM cluster.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="giVersion")
    def gi_version(self) -> _builtins.str:
        """
        The software version of the Oracle Grid Infrastructure (GI) for the VM cluster.
        """
        return pulumi.get(self, "gi_version")

    @_builtins.property
    @pulumi.getter(name="hostnamePrefixComputed")
    def hostname_prefix_computed(self) -> _builtins.str:
        """
        The computed hostname prefix for the VM cluster.
        """
        return pulumi.get(self, "hostname_prefix_computed")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="iormConfigCaches")
    def iorm_config_caches(self) -> Sequence['outputs.GetCloudVmClusterIormConfigCachResult']:
        """
        The ExadataIormConfig cache details for the VM cluster.
        """
        return pulumi.get(self, "iorm_config_caches")

    @_builtins.property
    @pulumi.getter(name="isLocalBackupEnabled")
    def is_local_backup_enabled(self) -> _builtins.bool:
        """
        Indicates whether database backups to local Exadata storage is enabled for the VM cluster.
        """
        return pulumi.get(self, "is_local_backup_enabled")

    @_builtins.property
    @pulumi.getter(name="isSparseDiskGroupEnabled")
    def is_sparse_disk_group_enabled(self) -> _builtins.bool:
        """
        Indicates whether the VM cluster is configured with a sparse disk group.
        """
        return pulumi.get(self, "is_sparse_disk_group_enabled")

    @_builtins.property
    @pulumi.getter(name="lastUpdateHistoryEntryId")
    def last_update_history_entry_id(self) -> _builtins.str:
        """
        The Oracle Cloud ID (OCID) of the last maintenance update history entry.
        """
        return pulumi.get(self, "last_update_history_entry_id")

    @_builtins.property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> _builtins.str:
        """
        The Oracle license model applied to the VM cluster.
        """
        return pulumi.get(self, "license_model")

    @_builtins.property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> _builtins.int:
        """
        The port number configured for the listener on the VM cluster.
        """
        return pulumi.get(self, "listener_port")

    @_builtins.property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> _builtins.int:
        """
        The amount of memory, in gigabytes (GB), that's allocated for the VM cluster.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> _builtins.int:
        """
        The number of nodes in the VM cluster.
        """
        return pulumi.get(self, "node_count")

    @_builtins.property
    @pulumi.getter(name="ociResourceAnchorName")
    def oci_resource_anchor_name(self) -> _builtins.str:
        """
        The name of the OCI Resource Anchor.
        """
        return pulumi.get(self, "oci_resource_anchor_name")

    @_builtins.property
    @pulumi.getter(name="ociUrl")
    def oci_url(self) -> _builtins.str:
        """
        The HTTPS link to the VM cluster in OCI.
        """
        return pulumi.get(self, "oci_url")

    @_builtins.property
    @pulumi.getter
    def ocid(self) -> _builtins.str:
        """
        The OCID of the VM cluster.
        """
        return pulumi.get(self, "ocid")

    @_builtins.property
    @pulumi.getter(name="odbNetworkId")
    def odb_network_id(self) -> _builtins.str:
        """
        The ID of the ODB network.
        """
        return pulumi.get(self, "odb_network_id")

    @_builtins.property
    @pulumi.getter(name="percentProgress")
    def percent_progress(self) -> _builtins.float:
        """
        The amount of progress made on the current operation on the VM cluster, expressed as a percentage.
        """
        return pulumi.get(self, "percent_progress")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="scanDnsName")
    def scan_dns_name(self) -> _builtins.str:
        """
        The FQDN of the DNS record for the Single Client Access Name (SCAN) IP addresses that are associated with the VM cluster.
        """
        return pulumi.get(self, "scan_dns_name")

    @_builtins.property
    @pulumi.getter(name="scanDnsRecordId")
    def scan_dns_record_id(self) -> _builtins.str:
        """
        The OCID of the DNS record for the SCAN IP addresses that are associated with the VM cluster.
        """
        return pulumi.get(self, "scan_dns_record_id")

    @_builtins.property
    @pulumi.getter(name="scanIpIds")
    def scan_ip_ids(self) -> Sequence[_builtins.str]:
        """
        The OCID of the SCAN IP addresses that are associated with the VM cluster.
        """
        return pulumi.get(self, "scan_ip_ids")

    @_builtins.property
    @pulumi.getter
    def shape(self) -> _builtins.str:
        """
        The hardware model name of the Exadata infrastructure that's running the VM cluster.
        """
        return pulumi.get(self, "shape")

    @_builtins.property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> Sequence[_builtins.str]:
        """
        The public key portion of one or more key pairs used for SSH access to the VM cluster.
        """
        return pulumi.get(self, "ssh_public_keys")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the VM cluster.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> _builtins.str:
        """
        Additional information about the status of the VM cluster.
        """
        return pulumi.get(self, "status_reason")

    @_builtins.property
    @pulumi.getter(name="storageSizeInGbs")
    def storage_size_in_gbs(self) -> _builtins.int:
        """
        The amount of local node storage, in gigabytes (GB), that's allocated to the VM cluster.
        """
        return pulumi.get(self, "storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="systemVersion")
    def system_version(self) -> _builtins.str:
        """
        The operating system version of the image chosen for the VM cluster.
        """
        return pulumi.get(self, "system_version")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> _builtins.str:
        """
        The time zone of the VM cluster.
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="vipIds")
    def vip_ids(self) -> Sequence[_builtins.str]:
        """
        The virtual IP (VIP) addresses that are associated with the VM cluster. Oracle's Cluster Ready Services (CRS) creates and maintains one VIP address for each node in the VM cluster to enable failover. If one node fails, the VIP is reassigned to another active node in the cluster.
        """
        return pulumi.get(self, "vip_ids")


class AwaitableGetCloudVmClusterResult(GetCloudVmClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudVmClusterResult(
            arn=self.arn,
            cloud_exadata_infrastructure_id=self.cloud_exadata_infrastructure_id,
            cluster_name=self.cluster_name,
            compute_model=self.compute_model,
            cpu_core_count=self.cpu_core_count,
            created_at=self.created_at,
            data_collection_options=self.data_collection_options,
            data_storage_size_in_tbs=self.data_storage_size_in_tbs,
            db_node_storage_size_in_gbs=self.db_node_storage_size_in_gbs,
            db_servers=self.db_servers,
            disk_redundancy=self.disk_redundancy,
            display_name=self.display_name,
            domain=self.domain,
            gi_version=self.gi_version,
            hostname_prefix_computed=self.hostname_prefix_computed,
            id=self.id,
            iorm_config_caches=self.iorm_config_caches,
            is_local_backup_enabled=self.is_local_backup_enabled,
            is_sparse_disk_group_enabled=self.is_sparse_disk_group_enabled,
            last_update_history_entry_id=self.last_update_history_entry_id,
            license_model=self.license_model,
            listener_port=self.listener_port,
            memory_size_in_gbs=self.memory_size_in_gbs,
            node_count=self.node_count,
            oci_resource_anchor_name=self.oci_resource_anchor_name,
            oci_url=self.oci_url,
            ocid=self.ocid,
            odb_network_id=self.odb_network_id,
            percent_progress=self.percent_progress,
            region=self.region,
            scan_dns_name=self.scan_dns_name,
            scan_dns_record_id=self.scan_dns_record_id,
            scan_ip_ids=self.scan_ip_ids,
            shape=self.shape,
            ssh_public_keys=self.ssh_public_keys,
            status=self.status,
            status_reason=self.status_reason,
            storage_size_in_gbs=self.storage_size_in_gbs,
            system_version=self.system_version,
            tags=self.tags,
            timezone=self.timezone,
            vip_ids=self.vip_ids)


def get_cloud_vm_cluster(id: Optional[_builtins.str] = None,
                         region: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudVmClusterResult:
    """
    Data source for cloud vm cluster in AWS for Oracle Database@AWS.

    You can find out more about Oracle Database@AWS from [User Guide](https://docs.aws.amazon.com/odb/latest/UserGuide/what-is-odb.html).

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.odb.get_cloud_vm_cluster(id="example-id")
    ```


    :param _builtins.str id: The unique identifier of the cloud vm cluster.
           
           The following arguments are optional:
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:odb/getCloudVmCluster:getCloudVmCluster', __args__, opts=opts, typ=GetCloudVmClusterResult).value

    return AwaitableGetCloudVmClusterResult(
        arn=pulumi.get(__ret__, 'arn'),
        cloud_exadata_infrastructure_id=pulumi.get(__ret__, 'cloud_exadata_infrastructure_id'),
        cluster_name=pulumi.get(__ret__, 'cluster_name'),
        compute_model=pulumi.get(__ret__, 'compute_model'),
        cpu_core_count=pulumi.get(__ret__, 'cpu_core_count'),
        created_at=pulumi.get(__ret__, 'created_at'),
        data_collection_options=pulumi.get(__ret__, 'data_collection_options'),
        data_storage_size_in_tbs=pulumi.get(__ret__, 'data_storage_size_in_tbs'),
        db_node_storage_size_in_gbs=pulumi.get(__ret__, 'db_node_storage_size_in_gbs'),
        db_servers=pulumi.get(__ret__, 'db_servers'),
        disk_redundancy=pulumi.get(__ret__, 'disk_redundancy'),
        display_name=pulumi.get(__ret__, 'display_name'),
        domain=pulumi.get(__ret__, 'domain'),
        gi_version=pulumi.get(__ret__, 'gi_version'),
        hostname_prefix_computed=pulumi.get(__ret__, 'hostname_prefix_computed'),
        id=pulumi.get(__ret__, 'id'),
        iorm_config_caches=pulumi.get(__ret__, 'iorm_config_caches'),
        is_local_backup_enabled=pulumi.get(__ret__, 'is_local_backup_enabled'),
        is_sparse_disk_group_enabled=pulumi.get(__ret__, 'is_sparse_disk_group_enabled'),
        last_update_history_entry_id=pulumi.get(__ret__, 'last_update_history_entry_id'),
        license_model=pulumi.get(__ret__, 'license_model'),
        listener_port=pulumi.get(__ret__, 'listener_port'),
        memory_size_in_gbs=pulumi.get(__ret__, 'memory_size_in_gbs'),
        node_count=pulumi.get(__ret__, 'node_count'),
        oci_resource_anchor_name=pulumi.get(__ret__, 'oci_resource_anchor_name'),
        oci_url=pulumi.get(__ret__, 'oci_url'),
        ocid=pulumi.get(__ret__, 'ocid'),
        odb_network_id=pulumi.get(__ret__, 'odb_network_id'),
        percent_progress=pulumi.get(__ret__, 'percent_progress'),
        region=pulumi.get(__ret__, 'region'),
        scan_dns_name=pulumi.get(__ret__, 'scan_dns_name'),
        scan_dns_record_id=pulumi.get(__ret__, 'scan_dns_record_id'),
        scan_ip_ids=pulumi.get(__ret__, 'scan_ip_ids'),
        shape=pulumi.get(__ret__, 'shape'),
        ssh_public_keys=pulumi.get(__ret__, 'ssh_public_keys'),
        status=pulumi.get(__ret__, 'status'),
        status_reason=pulumi.get(__ret__, 'status_reason'),
        storage_size_in_gbs=pulumi.get(__ret__, 'storage_size_in_gbs'),
        system_version=pulumi.get(__ret__, 'system_version'),
        tags=pulumi.get(__ret__, 'tags'),
        timezone=pulumi.get(__ret__, 'timezone'),
        vip_ids=pulumi.get(__ret__, 'vip_ids'))
def get_cloud_vm_cluster_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudVmClusterResult]:
    """
    Data source for cloud vm cluster in AWS for Oracle Database@AWS.

    You can find out more about Oracle Database@AWS from [User Guide](https://docs.aws.amazon.com/odb/latest/UserGuide/what-is-odb.html).

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.odb.get_cloud_vm_cluster(id="example-id")
    ```


    :param _builtins.str id: The unique identifier of the cloud vm cluster.
           
           The following arguments are optional:
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:odb/getCloudVmCluster:getCloudVmCluster', __args__, opts=opts, typ=GetCloudVmClusterResult)
    return __ret__.apply(lambda __response__: GetCloudVmClusterResult(
        arn=pulumi.get(__response__, 'arn'),
        cloud_exadata_infrastructure_id=pulumi.get(__response__, 'cloud_exadata_infrastructure_id'),
        cluster_name=pulumi.get(__response__, 'cluster_name'),
        compute_model=pulumi.get(__response__, 'compute_model'),
        cpu_core_count=pulumi.get(__response__, 'cpu_core_count'),
        created_at=pulumi.get(__response__, 'created_at'),
        data_collection_options=pulumi.get(__response__, 'data_collection_options'),
        data_storage_size_in_tbs=pulumi.get(__response__, 'data_storage_size_in_tbs'),
        db_node_storage_size_in_gbs=pulumi.get(__response__, 'db_node_storage_size_in_gbs'),
        db_servers=pulumi.get(__response__, 'db_servers'),
        disk_redundancy=pulumi.get(__response__, 'disk_redundancy'),
        display_name=pulumi.get(__response__, 'display_name'),
        domain=pulumi.get(__response__, 'domain'),
        gi_version=pulumi.get(__response__, 'gi_version'),
        hostname_prefix_computed=pulumi.get(__response__, 'hostname_prefix_computed'),
        id=pulumi.get(__response__, 'id'),
        iorm_config_caches=pulumi.get(__response__, 'iorm_config_caches'),
        is_local_backup_enabled=pulumi.get(__response__, 'is_local_backup_enabled'),
        is_sparse_disk_group_enabled=pulumi.get(__response__, 'is_sparse_disk_group_enabled'),
        last_update_history_entry_id=pulumi.get(__response__, 'last_update_history_entry_id'),
        license_model=pulumi.get(__response__, 'license_model'),
        listener_port=pulumi.get(__response__, 'listener_port'),
        memory_size_in_gbs=pulumi.get(__response__, 'memory_size_in_gbs'),
        node_count=pulumi.get(__response__, 'node_count'),
        oci_resource_anchor_name=pulumi.get(__response__, 'oci_resource_anchor_name'),
        oci_url=pulumi.get(__response__, 'oci_url'),
        ocid=pulumi.get(__response__, 'ocid'),
        odb_network_id=pulumi.get(__response__, 'odb_network_id'),
        percent_progress=pulumi.get(__response__, 'percent_progress'),
        region=pulumi.get(__response__, 'region'),
        scan_dns_name=pulumi.get(__response__, 'scan_dns_name'),
        scan_dns_record_id=pulumi.get(__response__, 'scan_dns_record_id'),
        scan_ip_ids=pulumi.get(__response__, 'scan_ip_ids'),
        shape=pulumi.get(__response__, 'shape'),
        ssh_public_keys=pulumi.get(__response__, 'ssh_public_keys'),
        status=pulumi.get(__response__, 'status'),
        status_reason=pulumi.get(__response__, 'status_reason'),
        storage_size_in_gbs=pulumi.get(__response__, 'storage_size_in_gbs'),
        system_version=pulumi.get(__response__, 'system_version'),
        tags=pulumi.get(__response__, 'tags'),
        timezone=pulumi.get(__response__, 'timezone'),
        vip_ids=pulumi.get(__response__, 'vip_ids')))
