# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDbNodeResult',
    'AwaitableGetDbNodeResult',
    'get_db_node',
    'get_db_node_output',
]

@pulumi.output_type
class GetDbNodeResult:
    """
    A collection of values returned by getDbNode.
    """
    def __init__(__self__, additional_details=None, arn=None, backup_ip_id=None, backup_vnic2_id=None, backup_vnic_id=None, cloud_vm_cluster_id=None, cpu_core_count=None, created_at=None, db_server_id=None, db_storage_size_in_gbs=None, db_system_id=None, fault_domain=None, floating_ip_address=None, host_ip_id=None, hostname=None, id=None, maintenance_type=None, memory_size_in_gbs=None, oci_resource_anchor_name=None, ocid=None, private_ip_address=None, region=None, software_storage_size_in_gbs=None, status=None, status_reason=None, time_maintenance_window_end=None, time_maintenance_window_start=None, total_cpu_core_count=None, vnic2_id=None, vnic_id=None):
        if additional_details and not isinstance(additional_details, str):
            raise TypeError("Expected argument 'additional_details' to be a str")
        pulumi.set(__self__, "additional_details", additional_details)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if backup_ip_id and not isinstance(backup_ip_id, str):
            raise TypeError("Expected argument 'backup_ip_id' to be a str")
        pulumi.set(__self__, "backup_ip_id", backup_ip_id)
        if backup_vnic2_id and not isinstance(backup_vnic2_id, str):
            raise TypeError("Expected argument 'backup_vnic2_id' to be a str")
        pulumi.set(__self__, "backup_vnic2_id", backup_vnic2_id)
        if backup_vnic_id and not isinstance(backup_vnic_id, str):
            raise TypeError("Expected argument 'backup_vnic_id' to be a str")
        pulumi.set(__self__, "backup_vnic_id", backup_vnic_id)
        if cloud_vm_cluster_id and not isinstance(cloud_vm_cluster_id, str):
            raise TypeError("Expected argument 'cloud_vm_cluster_id' to be a str")
        pulumi.set(__self__, "cloud_vm_cluster_id", cloud_vm_cluster_id)
        if cpu_core_count and not isinstance(cpu_core_count, int):
            raise TypeError("Expected argument 'cpu_core_count' to be a int")
        pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if db_server_id and not isinstance(db_server_id, str):
            raise TypeError("Expected argument 'db_server_id' to be a str")
        pulumi.set(__self__, "db_server_id", db_server_id)
        if db_storage_size_in_gbs and not isinstance(db_storage_size_in_gbs, int):
            raise TypeError("Expected argument 'db_storage_size_in_gbs' to be a int")
        pulumi.set(__self__, "db_storage_size_in_gbs", db_storage_size_in_gbs)
        if db_system_id and not isinstance(db_system_id, str):
            raise TypeError("Expected argument 'db_system_id' to be a str")
        pulumi.set(__self__, "db_system_id", db_system_id)
        if fault_domain and not isinstance(fault_domain, str):
            raise TypeError("Expected argument 'fault_domain' to be a str")
        pulumi.set(__self__, "fault_domain", fault_domain)
        if floating_ip_address and not isinstance(floating_ip_address, str):
            raise TypeError("Expected argument 'floating_ip_address' to be a str")
        pulumi.set(__self__, "floating_ip_address", floating_ip_address)
        if host_ip_id and not isinstance(host_ip_id, str):
            raise TypeError("Expected argument 'host_ip_id' to be a str")
        pulumi.set(__self__, "host_ip_id", host_ip_id)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if maintenance_type and not isinstance(maintenance_type, str):
            raise TypeError("Expected argument 'maintenance_type' to be a str")
        pulumi.set(__self__, "maintenance_type", maintenance_type)
        if memory_size_in_gbs and not isinstance(memory_size_in_gbs, int):
            raise TypeError("Expected argument 'memory_size_in_gbs' to be a int")
        pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if oci_resource_anchor_name and not isinstance(oci_resource_anchor_name, str):
            raise TypeError("Expected argument 'oci_resource_anchor_name' to be a str")
        pulumi.set(__self__, "oci_resource_anchor_name", oci_resource_anchor_name)
        if ocid and not isinstance(ocid, str):
            raise TypeError("Expected argument 'ocid' to be a str")
        pulumi.set(__self__, "ocid", ocid)
        if private_ip_address and not isinstance(private_ip_address, str):
            raise TypeError("Expected argument 'private_ip_address' to be a str")
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if software_storage_size_in_gbs and not isinstance(software_storage_size_in_gbs, int):
            raise TypeError("Expected argument 'software_storage_size_in_gbs' to be a int")
        pulumi.set(__self__, "software_storage_size_in_gbs", software_storage_size_in_gbs)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_reason and not isinstance(status_reason, str):
            raise TypeError("Expected argument 'status_reason' to be a str")
        pulumi.set(__self__, "status_reason", status_reason)
        if time_maintenance_window_end and not isinstance(time_maintenance_window_end, str):
            raise TypeError("Expected argument 'time_maintenance_window_end' to be a str")
        pulumi.set(__self__, "time_maintenance_window_end", time_maintenance_window_end)
        if time_maintenance_window_start and not isinstance(time_maintenance_window_start, str):
            raise TypeError("Expected argument 'time_maintenance_window_start' to be a str")
        pulumi.set(__self__, "time_maintenance_window_start", time_maintenance_window_start)
        if total_cpu_core_count and not isinstance(total_cpu_core_count, int):
            raise TypeError("Expected argument 'total_cpu_core_count' to be a int")
        pulumi.set(__self__, "total_cpu_core_count", total_cpu_core_count)
        if vnic2_id and not isinstance(vnic2_id, str):
            raise TypeError("Expected argument 'vnic2_id' to be a str")
        pulumi.set(__self__, "vnic2_id", vnic2_id)
        if vnic_id and not isinstance(vnic_id, str):
            raise TypeError("Expected argument 'vnic_id' to be a str")
        pulumi.set(__self__, "vnic_id", vnic_id)

    @_builtins.property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> _builtins.str:
        """
        Additional information about the planned maintenance.
        """
        return pulumi.get(self, "additional_details")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="backupIpId")
    def backup_ip_id(self) -> _builtins.str:
        """
        The Oracle Cloud ID (OCID) of the backup IP address that's associated with the DB node.
        """
        return pulumi.get(self, "backup_ip_id")

    @_builtins.property
    @pulumi.getter(name="backupVnic2Id")
    def backup_vnic2_id(self) -> _builtins.str:
        """
        The OCID of the second backup VNIC.
        """
        return pulumi.get(self, "backup_vnic2_id")

    @_builtins.property
    @pulumi.getter(name="backupVnicId")
    def backup_vnic_id(self) -> _builtins.str:
        """
        The OCID of the backup VNIC.
        """
        return pulumi.get(self, "backup_vnic_id")

    @_builtins.property
    @pulumi.getter(name="cloudVmClusterId")
    def cloud_vm_cluster_id(self) -> _builtins.str:
        """
        The ID of the cloud VM cluster.
        """
        return pulumi.get(self, "cloud_vm_cluster_id")

    @_builtins.property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> _builtins.int:
        """
        The number of CPU cores enabled on the DB node.
        """
        return pulumi.get(self, "cpu_core_count")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date and time when the DB node was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="dbServerId")
    def db_server_id(self) -> _builtins.str:
        """
        The unique identifier of the DB server that is associated with the DB node.
        """
        return pulumi.get(self, "db_server_id")

    @_builtins.property
    @pulumi.getter(name="dbStorageSizeInGbs")
    def db_storage_size_in_gbs(self) -> _builtins.int:
        """
        The amount of local node storage, in gigabytes (GB), allocated on the DB node.
        """
        return pulumi.get(self, "db_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> _builtins.str:
        """
        The OCID of the DB system.
        """
        return pulumi.get(self, "db_system_id")

    @_builtins.property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> _builtins.str:
        """
        The name of the fault domain the instance is contained in.
        """
        return pulumi.get(self, "fault_domain")

    @_builtins.property
    @pulumi.getter(name="floatingIpAddress")
    def floating_ip_address(self) -> _builtins.str:
        """
        The floating IP address assigned to the DB node.
        """
        return pulumi.get(self, "floating_ip_address")

    @_builtins.property
    @pulumi.getter(name="hostIpId")
    def host_ip_id(self) -> _builtins.str:
        """
        The OCID of the host IP address that's associated with the DB node.
        """
        return pulumi.get(self, "host_ip_id")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The host name for the DB node.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maintenanceType")
    def maintenance_type(self) -> _builtins.str:
        """
        The type of database node maintenance. Either VMDB_REBOOT_MIGRATION or EXADBXS_REBOOT_MIGRATION.
        """
        return pulumi.get(self, "maintenance_type")

    @_builtins.property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> _builtins.int:
        """
        The allocated memory in GBs on the DB node.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="ociResourceAnchorName")
    def oci_resource_anchor_name(self) -> _builtins.str:
        """
        The name of the OCI resource anchor for the DB node.
        """
        return pulumi.get(self, "oci_resource_anchor_name")

    @_builtins.property
    @pulumi.getter
    def ocid(self) -> _builtins.str:
        """
        The OCID of the DB node.
        """
        return pulumi.get(self, "ocid")

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> _builtins.str:
        """
        The private IP address assigned to the DB node.
        """
        return pulumi.get(self, "private_ip_address")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="softwareStorageSizeInGbs")
    def software_storage_size_in_gbs(self) -> _builtins.int:
        """
        The size (in GB) of the block storage volume allocation for the DB system.
        """
        return pulumi.get(self, "software_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The current status of the DB node.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> _builtins.str:
        """
        Additional information about the status of the DB node.
        """
        return pulumi.get(self, "status_reason")

    @_builtins.property
    @pulumi.getter(name="timeMaintenanceWindowEnd")
    def time_maintenance_window_end(self) -> _builtins.str:
        """
        The end date and time of the maintenance window.
        """
        return pulumi.get(self, "time_maintenance_window_end")

    @_builtins.property
    @pulumi.getter(name="timeMaintenanceWindowStart")
    def time_maintenance_window_start(self) -> _builtins.str:
        """
        The start date and time of the maintenance window.
        """
        return pulumi.get(self, "time_maintenance_window_start")

    @_builtins.property
    @pulumi.getter(name="totalCpuCoreCount")
    def total_cpu_core_count(self) -> _builtins.int:
        """
        The total number of CPU cores reserved on the DB node.
        """
        return pulumi.get(self, "total_cpu_core_count")

    @_builtins.property
    @pulumi.getter(name="vnic2Id")
    def vnic2_id(self) -> _builtins.str:
        """
        The OCID of the second VNIC.
        """
        return pulumi.get(self, "vnic2_id")

    @_builtins.property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> _builtins.str:
        """
        The OCID of the VNIC.
        """
        return pulumi.get(self, "vnic_id")


class AwaitableGetDbNodeResult(GetDbNodeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbNodeResult(
            additional_details=self.additional_details,
            arn=self.arn,
            backup_ip_id=self.backup_ip_id,
            backup_vnic2_id=self.backup_vnic2_id,
            backup_vnic_id=self.backup_vnic_id,
            cloud_vm_cluster_id=self.cloud_vm_cluster_id,
            cpu_core_count=self.cpu_core_count,
            created_at=self.created_at,
            db_server_id=self.db_server_id,
            db_storage_size_in_gbs=self.db_storage_size_in_gbs,
            db_system_id=self.db_system_id,
            fault_domain=self.fault_domain,
            floating_ip_address=self.floating_ip_address,
            host_ip_id=self.host_ip_id,
            hostname=self.hostname,
            id=self.id,
            maintenance_type=self.maintenance_type,
            memory_size_in_gbs=self.memory_size_in_gbs,
            oci_resource_anchor_name=self.oci_resource_anchor_name,
            ocid=self.ocid,
            private_ip_address=self.private_ip_address,
            region=self.region,
            software_storage_size_in_gbs=self.software_storage_size_in_gbs,
            status=self.status,
            status_reason=self.status_reason,
            time_maintenance_window_end=self.time_maintenance_window_end,
            time_maintenance_window_start=self.time_maintenance_window_start,
            total_cpu_core_count=self.total_cpu_core_count,
            vnic2_id=self.vnic2_id,
            vnic_id=self.vnic_id)


def get_db_node(cloud_vm_cluster_id: Optional[_builtins.str] = None,
                id: Optional[_builtins.str] = None,
                region: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbNodeResult:
    """
    Data source for manging db nodes linked to cloud vm cluster of Oracle Database@AWS.

    You can find out more about Oracle Database@AWS from [User Guide](https://docs.aws.amazon.com/odb/latest/UserGuide/what-is-odb.html).

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.odb.get_db_node(cloud_vm_cluster_id="cloud_vm_cluster_id",
        id="db_node_id")
    ```


    :param _builtins.str cloud_vm_cluster_id: The unique identifier of the cloud vm cluster.
    :param _builtins.str id: The unique identifier of db node associated with vm cluster.
           
           The following arguments are optional:
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['cloudVmClusterId'] = cloud_vm_cluster_id
    __args__['id'] = id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:odb/getDbNode:getDbNode', __args__, opts=opts, typ=GetDbNodeResult).value

    return AwaitableGetDbNodeResult(
        additional_details=pulumi.get(__ret__, 'additional_details'),
        arn=pulumi.get(__ret__, 'arn'),
        backup_ip_id=pulumi.get(__ret__, 'backup_ip_id'),
        backup_vnic2_id=pulumi.get(__ret__, 'backup_vnic2_id'),
        backup_vnic_id=pulumi.get(__ret__, 'backup_vnic_id'),
        cloud_vm_cluster_id=pulumi.get(__ret__, 'cloud_vm_cluster_id'),
        cpu_core_count=pulumi.get(__ret__, 'cpu_core_count'),
        created_at=pulumi.get(__ret__, 'created_at'),
        db_server_id=pulumi.get(__ret__, 'db_server_id'),
        db_storage_size_in_gbs=pulumi.get(__ret__, 'db_storage_size_in_gbs'),
        db_system_id=pulumi.get(__ret__, 'db_system_id'),
        fault_domain=pulumi.get(__ret__, 'fault_domain'),
        floating_ip_address=pulumi.get(__ret__, 'floating_ip_address'),
        host_ip_id=pulumi.get(__ret__, 'host_ip_id'),
        hostname=pulumi.get(__ret__, 'hostname'),
        id=pulumi.get(__ret__, 'id'),
        maintenance_type=pulumi.get(__ret__, 'maintenance_type'),
        memory_size_in_gbs=pulumi.get(__ret__, 'memory_size_in_gbs'),
        oci_resource_anchor_name=pulumi.get(__ret__, 'oci_resource_anchor_name'),
        ocid=pulumi.get(__ret__, 'ocid'),
        private_ip_address=pulumi.get(__ret__, 'private_ip_address'),
        region=pulumi.get(__ret__, 'region'),
        software_storage_size_in_gbs=pulumi.get(__ret__, 'software_storage_size_in_gbs'),
        status=pulumi.get(__ret__, 'status'),
        status_reason=pulumi.get(__ret__, 'status_reason'),
        time_maintenance_window_end=pulumi.get(__ret__, 'time_maintenance_window_end'),
        time_maintenance_window_start=pulumi.get(__ret__, 'time_maintenance_window_start'),
        total_cpu_core_count=pulumi.get(__ret__, 'total_cpu_core_count'),
        vnic2_id=pulumi.get(__ret__, 'vnic2_id'),
        vnic_id=pulumi.get(__ret__, 'vnic_id'))
def get_db_node_output(cloud_vm_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                       id: Optional[pulumi.Input[_builtins.str]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbNodeResult]:
    """
    Data source for manging db nodes linked to cloud vm cluster of Oracle Database@AWS.

    You can find out more about Oracle Database@AWS from [User Guide](https://docs.aws.amazon.com/odb/latest/UserGuide/what-is-odb.html).

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.odb.get_db_node(cloud_vm_cluster_id="cloud_vm_cluster_id",
        id="db_node_id")
    ```


    :param _builtins.str cloud_vm_cluster_id: The unique identifier of the cloud vm cluster.
    :param _builtins.str id: The unique identifier of db node associated with vm cluster.
           
           The following arguments are optional:
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['cloudVmClusterId'] = cloud_vm_cluster_id
    __args__['id'] = id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:odb/getDbNode:getDbNode', __args__, opts=opts, typ=GetDbNodeResult)
    return __ret__.apply(lambda __response__: GetDbNodeResult(
        additional_details=pulumi.get(__response__, 'additional_details'),
        arn=pulumi.get(__response__, 'arn'),
        backup_ip_id=pulumi.get(__response__, 'backup_ip_id'),
        backup_vnic2_id=pulumi.get(__response__, 'backup_vnic2_id'),
        backup_vnic_id=pulumi.get(__response__, 'backup_vnic_id'),
        cloud_vm_cluster_id=pulumi.get(__response__, 'cloud_vm_cluster_id'),
        cpu_core_count=pulumi.get(__response__, 'cpu_core_count'),
        created_at=pulumi.get(__response__, 'created_at'),
        db_server_id=pulumi.get(__response__, 'db_server_id'),
        db_storage_size_in_gbs=pulumi.get(__response__, 'db_storage_size_in_gbs'),
        db_system_id=pulumi.get(__response__, 'db_system_id'),
        fault_domain=pulumi.get(__response__, 'fault_domain'),
        floating_ip_address=pulumi.get(__response__, 'floating_ip_address'),
        host_ip_id=pulumi.get(__response__, 'host_ip_id'),
        hostname=pulumi.get(__response__, 'hostname'),
        id=pulumi.get(__response__, 'id'),
        maintenance_type=pulumi.get(__response__, 'maintenance_type'),
        memory_size_in_gbs=pulumi.get(__response__, 'memory_size_in_gbs'),
        oci_resource_anchor_name=pulumi.get(__response__, 'oci_resource_anchor_name'),
        ocid=pulumi.get(__response__, 'ocid'),
        private_ip_address=pulumi.get(__response__, 'private_ip_address'),
        region=pulumi.get(__response__, 'region'),
        software_storage_size_in_gbs=pulumi.get(__response__, 'software_storage_size_in_gbs'),
        status=pulumi.get(__response__, 'status'),
        status_reason=pulumi.get(__response__, 'status_reason'),
        time_maintenance_window_end=pulumi.get(__response__, 'time_maintenance_window_end'),
        time_maintenance_window_start=pulumi.get(__response__, 'time_maintenance_window_start'),
        total_cpu_core_count=pulumi.get(__response__, 'total_cpu_core_count'),
        vnic2_id=pulumi.get(__response__, 'vnic2_id'),
        vnic_id=pulumi.get(__response__, 'vnic_id')))
