# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDbNodesResult',
    'AwaitableGetDbNodesResult',
    'get_db_nodes',
    'get_db_nodes_output',
]

@pulumi.output_type
class GetDbNodesResult:
    """
    A collection of values returned by getDbNodes.
    """
    def __init__(__self__, cloud_vm_cluster_id=None, db_nodes=None, id=None, region=None):
        if cloud_vm_cluster_id and not isinstance(cloud_vm_cluster_id, str):
            raise TypeError("Expected argument 'cloud_vm_cluster_id' to be a str")
        pulumi.set(__self__, "cloud_vm_cluster_id", cloud_vm_cluster_id)
        if db_nodes and not isinstance(db_nodes, list):
            raise TypeError("Expected argument 'db_nodes' to be a list")
        pulumi.set(__self__, "db_nodes", db_nodes)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="cloudVmClusterId")
    def cloud_vm_cluster_id(self) -> _builtins.str:
        return pulumi.get(self, "cloud_vm_cluster_id")

    @_builtins.property
    @pulumi.getter(name="dbNodes")
    def db_nodes(self) -> Sequence['outputs.GetDbNodesDbNodeResult']:
        """
        The list of DB nodes along with their properties.
        """
        return pulumi.get(self, "db_nodes")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetDbNodesResult(GetDbNodesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbNodesResult(
            cloud_vm_cluster_id=self.cloud_vm_cluster_id,
            db_nodes=self.db_nodes,
            id=self.id,
            region=self.region)


def get_db_nodes(cloud_vm_cluster_id: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbNodesResult:
    """
    Data source for manging db nodes linked to cloud vm cluster of Oracle Database@AWS.

    You can find out more about Oracle Database@AWS from [User Guide](https://docs.aws.amazon.com/odb/latest/UserGuide/what-is-odb.html).

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.odb.get_db_nodes(cloud_vm_cluster_id="example")
    ```


    :param _builtins.str cloud_vm_cluster_id: The unique identifier of the cloud vm cluster.
           
           The following arguments are optional:
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['cloudVmClusterId'] = cloud_vm_cluster_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:odb/getDbNodes:getDbNodes', __args__, opts=opts, typ=GetDbNodesResult).value

    return AwaitableGetDbNodesResult(
        cloud_vm_cluster_id=pulumi.get(__ret__, 'cloud_vm_cluster_id'),
        db_nodes=pulumi.get(__ret__, 'db_nodes'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'))
def get_db_nodes_output(cloud_vm_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                        region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbNodesResult]:
    """
    Data source for manging db nodes linked to cloud vm cluster of Oracle Database@AWS.

    You can find out more about Oracle Database@AWS from [User Guide](https://docs.aws.amazon.com/odb/latest/UserGuide/what-is-odb.html).

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.odb.get_db_nodes(cloud_vm_cluster_id="example")
    ```


    :param _builtins.str cloud_vm_cluster_id: The unique identifier of the cloud vm cluster.
           
           The following arguments are optional:
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['cloudVmClusterId'] = cloud_vm_cluster_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:odb/getDbNodes:getDbNodes', __args__, opts=opts, typ=GetDbNodesResult)
    return __ret__.apply(lambda __response__: GetDbNodesResult(
        cloud_vm_cluster_id=pulumi.get(__response__, 'cloud_vm_cluster_id'),
        db_nodes=pulumi.get(__response__, 'db_nodes'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region')))
