# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDbSystemShapesResult',
    'AwaitableGetDbSystemShapesResult',
    'get_db_system_shapes',
    'get_db_system_shapes_output',
]

@pulumi.output_type
class GetDbSystemShapesResult:
    """
    A collection of values returned by getDbSystemShapes.
    """
    def __init__(__self__, availability_zone_id=None, db_system_shapes=None, id=None, region=None):
        if availability_zone_id and not isinstance(availability_zone_id, str):
            raise TypeError("Expected argument 'availability_zone_id' to be a str")
        pulumi.set(__self__, "availability_zone_id", availability_zone_id)
        if db_system_shapes and not isinstance(db_system_shapes, list):
            raise TypeError("Expected argument 'db_system_shapes' to be a list")
        pulumi.set(__self__, "db_system_shapes", db_system_shapes)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "availability_zone_id")

    @_builtins.property
    @pulumi.getter(name="dbSystemShapes")
    def db_system_shapes(self) -> Sequence['outputs.GetDbSystemShapesDbSystemShapeResult']:
        """
        The list of shapes and their properties. Information about a hardware system model (shape) that's available for an Exadata infrastructure. The shape determines resources, such as CPU cores, memory, and storage, to allocate to the Exadata infrastructure.
        """
        return pulumi.get(self, "db_system_shapes")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetDbSystemShapesResult(GetDbSystemShapesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbSystemShapesResult(
            availability_zone_id=self.availability_zone_id,
            db_system_shapes=self.db_system_shapes,
            id=self.id,
            region=self.region)


def get_db_system_shapes(availability_zone_id: Optional[_builtins.str] = None,
                         region: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbSystemShapesResult:
    """
    Data source to retrieve available system shapes Oracle Database@AWS.

    You can find out more about Oracle Database@AWS from [User Guide](https://docs.aws.amazon.com/odb/latest/UserGuide/what-is-odb.html).

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.odb.get_db_system_shapes()
    ```


    :param _builtins.str availability_zone_id: The physical ID of the AZ, for example, use1-az4. This ID persists across accounts.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['availabilityZoneId'] = availability_zone_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:odb/getDbSystemShapes:getDbSystemShapes', __args__, opts=opts, typ=GetDbSystemShapesResult).value

    return AwaitableGetDbSystemShapesResult(
        availability_zone_id=pulumi.get(__ret__, 'availability_zone_id'),
        db_system_shapes=pulumi.get(__ret__, 'db_system_shapes'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'))
def get_db_system_shapes_output(availability_zone_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbSystemShapesResult]:
    """
    Data source to retrieve available system shapes Oracle Database@AWS.

    You can find out more about Oracle Database@AWS from [User Guide](https://docs.aws.amazon.com/odb/latest/UserGuide/what-is-odb.html).

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.odb.get_db_system_shapes()
    ```


    :param _builtins.str availability_zone_id: The physical ID of the AZ, for example, use1-az4. This ID persists across accounts.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['availabilityZoneId'] = availability_zone_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:odb/getDbSystemShapes:getDbSystemShapes', __args__, opts=opts, typ=GetDbSystemShapesResult)
    return __ret__.apply(lambda __response__: GetDbSystemShapesResult(
        availability_zone_id=pulumi.get(__response__, 'availability_zone_id'),
        db_system_shapes=pulumi.get(__response__, 'db_system_shapes'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region')))
