# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetGiVersionsResult',
    'AwaitableGetGiVersionsResult',
    'get_gi_versions',
    'get_gi_versions_output',
]

@pulumi.output_type
class GetGiVersionsResult:
    """
    A collection of values returned by getGiVersions.
    """
    def __init__(__self__, gi_versions=None, id=None, region=None, shape=None):
        if gi_versions and not isinstance(gi_versions, list):
            raise TypeError("Expected argument 'gi_versions' to be a list")
        pulumi.set(__self__, "gi_versions", gi_versions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if shape and not isinstance(shape, str):
            raise TypeError("Expected argument 'shape' to be a str")
        pulumi.set(__self__, "shape", shape)

    @_builtins.property
    @pulumi.getter(name="giVersions")
    def gi_versions(self) -> Sequence['outputs.GetGiVersionsGiVersionResult']:
        """
        Information about a specific version of Oracle Grid Infrastructure (GI) software that can be installed on a VM cluster.
        """
        return pulumi.get(self, "gi_versions")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def shape(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "shape")


class AwaitableGetGiVersionsResult(GetGiVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGiVersionsResult(
            gi_versions=self.gi_versions,
            id=self.id,
            region=self.region,
            shape=self.shape)


def get_gi_versions(region: Optional[_builtins.str] = None,
                    shape: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGiVersionsResult:
    """
    Data source to retrieve available Grid Infrastructure versions of Oracle Database@AWS.

    You can find out more about Oracle Database@AWS from [User Guide](https://docs.aws.amazon.com/odb/latest/UserGuide/what-is-odb.html).

    ## Example Usage


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str shape: The system shape.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['shape'] = shape
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:odb/getGiVersions:getGiVersions', __args__, opts=opts, typ=GetGiVersionsResult).value

    return AwaitableGetGiVersionsResult(
        gi_versions=pulumi.get(__ret__, 'gi_versions'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        shape=pulumi.get(__ret__, 'shape'))
def get_gi_versions_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           shape: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGiVersionsResult]:
    """
    Data source to retrieve available Grid Infrastructure versions of Oracle Database@AWS.

    You can find out more about Oracle Database@AWS from [User Guide](https://docs.aws.amazon.com/odb/latest/UserGuide/what-is-odb.html).

    ## Example Usage


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str shape: The system shape.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['shape'] = shape
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:odb/getGiVersions:getGiVersions', __args__, opts=opts, typ=GetGiVersionsResult)
    return __ret__.apply(lambda __response__: GetGiVersionsResult(
        gi_versions=pulumi.get(__response__, 'gi_versions'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        shape=pulumi.get(__response__, 'shape')))
