# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNetworkResult',
    'AwaitableGetNetworkResult',
    'get_network',
    'get_network_output',
]

@pulumi.output_type
class GetNetworkResult:
    """
    A collection of values returned by getNetwork.
    """
    def __init__(__self__, arn=None, availability_zone=None, availability_zone_id=None, backup_subnet_cidr=None, client_subnet_cidr=None, created_at=None, custom_domain_name=None, default_dns_prefix=None, display_name=None, id=None, managed_services=None, oci_dns_forwarding_configs=None, oci_network_anchor_id=None, oci_network_anchor_url=None, oci_resource_anchor_name=None, oci_vcn_id=None, oci_vcn_url=None, peered_cidrs=None, percent_progress=None, region=None, status=None, status_reason=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if availability_zone_id and not isinstance(availability_zone_id, str):
            raise TypeError("Expected argument 'availability_zone_id' to be a str")
        pulumi.set(__self__, "availability_zone_id", availability_zone_id)
        if backup_subnet_cidr and not isinstance(backup_subnet_cidr, str):
            raise TypeError("Expected argument 'backup_subnet_cidr' to be a str")
        pulumi.set(__self__, "backup_subnet_cidr", backup_subnet_cidr)
        if client_subnet_cidr and not isinstance(client_subnet_cidr, str):
            raise TypeError("Expected argument 'client_subnet_cidr' to be a str")
        pulumi.set(__self__, "client_subnet_cidr", client_subnet_cidr)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if custom_domain_name and not isinstance(custom_domain_name, str):
            raise TypeError("Expected argument 'custom_domain_name' to be a str")
        pulumi.set(__self__, "custom_domain_name", custom_domain_name)
        if default_dns_prefix and not isinstance(default_dns_prefix, str):
            raise TypeError("Expected argument 'default_dns_prefix' to be a str")
        pulumi.set(__self__, "default_dns_prefix", default_dns_prefix)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_services and not isinstance(managed_services, list):
            raise TypeError("Expected argument 'managed_services' to be a list")
        pulumi.set(__self__, "managed_services", managed_services)
        if oci_dns_forwarding_configs and not isinstance(oci_dns_forwarding_configs, list):
            raise TypeError("Expected argument 'oci_dns_forwarding_configs' to be a list")
        pulumi.set(__self__, "oci_dns_forwarding_configs", oci_dns_forwarding_configs)
        if oci_network_anchor_id and not isinstance(oci_network_anchor_id, str):
            raise TypeError("Expected argument 'oci_network_anchor_id' to be a str")
        pulumi.set(__self__, "oci_network_anchor_id", oci_network_anchor_id)
        if oci_network_anchor_url and not isinstance(oci_network_anchor_url, str):
            raise TypeError("Expected argument 'oci_network_anchor_url' to be a str")
        pulumi.set(__self__, "oci_network_anchor_url", oci_network_anchor_url)
        if oci_resource_anchor_name and not isinstance(oci_resource_anchor_name, str):
            raise TypeError("Expected argument 'oci_resource_anchor_name' to be a str")
        pulumi.set(__self__, "oci_resource_anchor_name", oci_resource_anchor_name)
        if oci_vcn_id and not isinstance(oci_vcn_id, str):
            raise TypeError("Expected argument 'oci_vcn_id' to be a str")
        pulumi.set(__self__, "oci_vcn_id", oci_vcn_id)
        if oci_vcn_url and not isinstance(oci_vcn_url, str):
            raise TypeError("Expected argument 'oci_vcn_url' to be a str")
        pulumi.set(__self__, "oci_vcn_url", oci_vcn_url)
        if peered_cidrs and not isinstance(peered_cidrs, list):
            raise TypeError("Expected argument 'peered_cidrs' to be a list")
        pulumi.set(__self__, "peered_cidrs", peered_cidrs)
        if percent_progress and not isinstance(percent_progress, float):
            raise TypeError("Expected argument 'percent_progress' to be a float")
        pulumi.set(__self__, "percent_progress", percent_progress)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_reason and not isinstance(status_reason, str):
            raise TypeError("Expected argument 'status_reason' to be a str")
        pulumi.set(__self__, "status_reason", status_reason)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        Amazon Resource Name (ARN) of the odb network resource.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        The availability zone where the ODB network is located.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> _builtins.str:
        """
        The AZ ID of the AZ where the ODB network is located.
        """
        return pulumi.get(self, "availability_zone_id")

    @_builtins.property
    @pulumi.getter(name="backupSubnetCidr")
    def backup_subnet_cidr(self) -> _builtins.str:
        """
        The CIDR range of the backup subnet for the ODB network.
        """
        return pulumi.get(self, "backup_subnet_cidr")

    @_builtins.property
    @pulumi.getter(name="clientSubnetCidr")
    def client_subnet_cidr(self) -> _builtins.str:
        """
        The CIDR notation for the network resource.
        """
        return pulumi.get(self, "client_subnet_cidr")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date and time when the ODB network was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="customDomainName")
    def custom_domain_name(self) -> _builtins.str:
        """
        The name of the custom domain that the network is located.
        """
        return pulumi.get(self, "custom_domain_name")

    @_builtins.property
    @pulumi.getter(name="defaultDnsPrefix")
    def default_dns_prefix(self) -> _builtins.str:
        """
        The default DNS prefix for the network resource.
        """
        return pulumi.get(self, "default_dns_prefix")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Display name for the network resource.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique identifier of the odb network resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="managedServices")
    def managed_services(self) -> Sequence['outputs.GetNetworkManagedServiceResult']:
        """
        The managed services configuration for the ODB network.
        """
        return pulumi.get(self, "managed_services")

    @_builtins.property
    @pulumi.getter(name="ociDnsForwardingConfigs")
    def oci_dns_forwarding_configs(self) -> Sequence['outputs.GetNetworkOciDnsForwardingConfigResult']:
        return pulumi.get(self, "oci_dns_forwarding_configs")

    @_builtins.property
    @pulumi.getter(name="ociNetworkAnchorId")
    def oci_network_anchor_id(self) -> _builtins.str:
        """
        The unique identifier of the OCI network anchor for the ODB network.
        """
        return pulumi.get(self, "oci_network_anchor_id")

    @_builtins.property
    @pulumi.getter(name="ociNetworkAnchorUrl")
    def oci_network_anchor_url(self) -> _builtins.str:
        """
        The URL of the OCI network anchor for the ODB network.
        """
        return pulumi.get(self, "oci_network_anchor_url")

    @_builtins.property
    @pulumi.getter(name="ociResourceAnchorName")
    def oci_resource_anchor_name(self) -> _builtins.str:
        """
        The name of the OCI resource anchor for the ODB network.
        """
        return pulumi.get(self, "oci_resource_anchor_name")

    @_builtins.property
    @pulumi.getter(name="ociVcnId")
    def oci_vcn_id(self) -> _builtins.str:
        """
        The unique identifier  Oracle Cloud ID (OCID) of the OCI VCN for the ODB network.
        """
        return pulumi.get(self, "oci_vcn_id")

    @_builtins.property
    @pulumi.getter(name="ociVcnUrl")
    def oci_vcn_url(self) -> _builtins.str:
        """
        The URL of the OCI VCN for the ODB network.
        """
        return pulumi.get(self, "oci_vcn_url")

    @_builtins.property
    @pulumi.getter(name="peeredCidrs")
    def peered_cidrs(self) -> Sequence[_builtins.str]:
        """
        The list of CIDR ranges from the peered VPC that are allowed access to the ODB network. Please refer odb network peering documentation.
        """
        return pulumi.get(self, "peered_cidrs")

    @_builtins.property
    @pulumi.getter(name="percentProgress")
    def percent_progress(self) -> _builtins.float:
        """
        The amount of progress made on the current operation on the ODB network, expressed as a percentage.
        """
        return pulumi.get(self, "percent_progress")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the network resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> _builtins.str:
        """
        Additional information about the current status of the ODB network.
        """
        return pulumi.get(self, "status_reason")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "tags")


class AwaitableGetNetworkResult(GetNetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkResult(
            arn=self.arn,
            availability_zone=self.availability_zone,
            availability_zone_id=self.availability_zone_id,
            backup_subnet_cidr=self.backup_subnet_cidr,
            client_subnet_cidr=self.client_subnet_cidr,
            created_at=self.created_at,
            custom_domain_name=self.custom_domain_name,
            default_dns_prefix=self.default_dns_prefix,
            display_name=self.display_name,
            id=self.id,
            managed_services=self.managed_services,
            oci_dns_forwarding_configs=self.oci_dns_forwarding_configs,
            oci_network_anchor_id=self.oci_network_anchor_id,
            oci_network_anchor_url=self.oci_network_anchor_url,
            oci_resource_anchor_name=self.oci_resource_anchor_name,
            oci_vcn_id=self.oci_vcn_id,
            oci_vcn_url=self.oci_vcn_url,
            peered_cidrs=self.peered_cidrs,
            percent_progress=self.percent_progress,
            region=self.region,
            status=self.status,
            status_reason=self.status_reason,
            tags=self.tags)


def get_network(id: Optional[_builtins.str] = None,
                region: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkResult:
    """
    Data source for to retrieve network resource in AWS for Oracle Database@AWS.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.odb.get_network(id="example")
    ```


    :param _builtins.str id: Unique identifier of the odb network resource.
           
           The following arguments are optional:
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:odb/getNetwork:getNetwork', __args__, opts=opts, typ=GetNetworkResult).value

    return AwaitableGetNetworkResult(
        arn=pulumi.get(__ret__, 'arn'),
        availability_zone=pulumi.get(__ret__, 'availability_zone'),
        availability_zone_id=pulumi.get(__ret__, 'availability_zone_id'),
        backup_subnet_cidr=pulumi.get(__ret__, 'backup_subnet_cidr'),
        client_subnet_cidr=pulumi.get(__ret__, 'client_subnet_cidr'),
        created_at=pulumi.get(__ret__, 'created_at'),
        custom_domain_name=pulumi.get(__ret__, 'custom_domain_name'),
        default_dns_prefix=pulumi.get(__ret__, 'default_dns_prefix'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        managed_services=pulumi.get(__ret__, 'managed_services'),
        oci_dns_forwarding_configs=pulumi.get(__ret__, 'oci_dns_forwarding_configs'),
        oci_network_anchor_id=pulumi.get(__ret__, 'oci_network_anchor_id'),
        oci_network_anchor_url=pulumi.get(__ret__, 'oci_network_anchor_url'),
        oci_resource_anchor_name=pulumi.get(__ret__, 'oci_resource_anchor_name'),
        oci_vcn_id=pulumi.get(__ret__, 'oci_vcn_id'),
        oci_vcn_url=pulumi.get(__ret__, 'oci_vcn_url'),
        peered_cidrs=pulumi.get(__ret__, 'peered_cidrs'),
        percent_progress=pulumi.get(__ret__, 'percent_progress'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'),
        status_reason=pulumi.get(__ret__, 'status_reason'),
        tags=pulumi.get(__ret__, 'tags'))
def get_network_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkResult]:
    """
    Data source for to retrieve network resource in AWS for Oracle Database@AWS.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.odb.get_network(id="example")
    ```


    :param _builtins.str id: Unique identifier of the odb network resource.
           
           The following arguments are optional:
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:odb/getNetwork:getNetwork', __args__, opts=opts, typ=GetNetworkResult)
    return __ret__.apply(lambda __response__: GetNetworkResult(
        arn=pulumi.get(__response__, 'arn'),
        availability_zone=pulumi.get(__response__, 'availability_zone'),
        availability_zone_id=pulumi.get(__response__, 'availability_zone_id'),
        backup_subnet_cidr=pulumi.get(__response__, 'backup_subnet_cidr'),
        client_subnet_cidr=pulumi.get(__response__, 'client_subnet_cidr'),
        created_at=pulumi.get(__response__, 'created_at'),
        custom_domain_name=pulumi.get(__response__, 'custom_domain_name'),
        default_dns_prefix=pulumi.get(__response__, 'default_dns_prefix'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        managed_services=pulumi.get(__response__, 'managed_services'),
        oci_dns_forwarding_configs=pulumi.get(__response__, 'oci_dns_forwarding_configs'),
        oci_network_anchor_id=pulumi.get(__response__, 'oci_network_anchor_id'),
        oci_network_anchor_url=pulumi.get(__response__, 'oci_network_anchor_url'),
        oci_resource_anchor_name=pulumi.get(__response__, 'oci_resource_anchor_name'),
        oci_vcn_id=pulumi.get(__response__, 'oci_vcn_id'),
        oci_vcn_url=pulumi.get(__response__, 'oci_vcn_url'),
        peered_cidrs=pulumi.get(__response__, 'peered_cidrs'),
        percent_progress=pulumi.get(__response__, 'percent_progress'),
        region=pulumi.get(__response__, 'region'),
        status=pulumi.get(__response__, 'status'),
        status_reason=pulumi.get(__response__, 'status_reason'),
        tags=pulumi.get(__response__, 'tags')))
