# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetNetworkPeeringConnectionResult',
    'AwaitableGetNetworkPeeringConnectionResult',
    'get_network_peering_connection',
    'get_network_peering_connection_output',
]

@pulumi.output_type
class GetNetworkPeeringConnectionResult:
    """
    A collection of values returned by getNetworkPeeringConnection.
    """
    def __init__(__self__, arn=None, created_at=None, display_name=None, id=None, odb_network_arn=None, odb_peering_connection_type=None, peer_network_arn=None, percent_progress=None, region=None, status=None, status_reason=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if odb_network_arn and not isinstance(odb_network_arn, str):
            raise TypeError("Expected argument 'odb_network_arn' to be a str")
        pulumi.set(__self__, "odb_network_arn", odb_network_arn)
        if odb_peering_connection_type and not isinstance(odb_peering_connection_type, str):
            raise TypeError("Expected argument 'odb_peering_connection_type' to be a str")
        pulumi.set(__self__, "odb_peering_connection_type", odb_peering_connection_type)
        if peer_network_arn and not isinstance(peer_network_arn, str):
            raise TypeError("Expected argument 'peer_network_arn' to be a str")
        pulumi.set(__self__, "peer_network_arn", peer_network_arn)
        if percent_progress and not isinstance(percent_progress, float):
            raise TypeError("Expected argument 'percent_progress' to be a float")
        pulumi.set(__self__, "percent_progress", percent_progress)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_reason and not isinstance(status_reason, str):
            raise TypeError("Expected argument 'status_reason' to be a str")
        pulumi.set(__self__, "status_reason", status_reason)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        The Amazon Resource Name (ARN) for the  ODB network peering connection.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Created time of the ODB network peering connection.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Display name of the ODB network peering connection.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="odbNetworkArn")
    def odb_network_arn(self) -> _builtins.str:
        """
        ARN of the ODB network peering connection.
        """
        return pulumi.get(self, "odb_network_arn")

    @_builtins.property
    @pulumi.getter(name="odbPeeringConnectionType")
    def odb_peering_connection_type(self) -> _builtins.str:
        """
        Type of the ODB peering connection.
        """
        return pulumi.get(self, "odb_peering_connection_type")

    @_builtins.property
    @pulumi.getter(name="peerNetworkArn")
    def peer_network_arn(self) -> _builtins.str:
        """
        ARN of the peer network peering connection.
        """
        return pulumi.get(self, "peer_network_arn")

    @_builtins.property
    @pulumi.getter(name="percentProgress")
    def percent_progress(self) -> _builtins.float:
        """
        Progress of the ODB network peering connection.
        """
        return pulumi.get(self, "percent_progress")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the ODB network peering connection.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> _builtins.str:
        """
        Status of the ODB network peering connection.
        """
        return pulumi.get(self, "status_reason")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Tags applied to the resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetNetworkPeeringConnectionResult(GetNetworkPeeringConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkPeeringConnectionResult(
            arn=self.arn,
            created_at=self.created_at,
            display_name=self.display_name,
            id=self.id,
            odb_network_arn=self.odb_network_arn,
            odb_peering_connection_type=self.odb_peering_connection_type,
            peer_network_arn=self.peer_network_arn,
            percent_progress=self.percent_progress,
            region=self.region,
            status=self.status,
            status_reason=self.status_reason,
            tags=self.tags)


def get_network_peering_connection(id: Optional[_builtins.str] = None,
                                   region: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkPeeringConnectionResult:
    """
    Data source for managing oracle database network peering resource in AWS.

    You can find out more about Oracle Database@AWS from [User Guide](https://docs.aws.amazon.com/odb/latest/UserGuide/what-is-odb.html).

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.odb.get_network_peering_connection(id="example")
    ```


    :param _builtins.str id: The unique identifier of the ODB network peering connection.
           
           The following arguments are optional:
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:odb/getNetworkPeeringConnection:getNetworkPeeringConnection', __args__, opts=opts, typ=GetNetworkPeeringConnectionResult).value

    return AwaitableGetNetworkPeeringConnectionResult(
        arn=pulumi.get(__ret__, 'arn'),
        created_at=pulumi.get(__ret__, 'created_at'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        odb_network_arn=pulumi.get(__ret__, 'odb_network_arn'),
        odb_peering_connection_type=pulumi.get(__ret__, 'odb_peering_connection_type'),
        peer_network_arn=pulumi.get(__ret__, 'peer_network_arn'),
        percent_progress=pulumi.get(__ret__, 'percent_progress'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'),
        status_reason=pulumi.get(__ret__, 'status_reason'),
        tags=pulumi.get(__ret__, 'tags'))
def get_network_peering_connection_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                          region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkPeeringConnectionResult]:
    """
    Data source for managing oracle database network peering resource in AWS.

    You can find out more about Oracle Database@AWS from [User Guide](https://docs.aws.amazon.com/odb/latest/UserGuide/what-is-odb.html).

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.odb.get_network_peering_connection(id="example")
    ```


    :param _builtins.str id: The unique identifier of the ODB network peering connection.
           
           The following arguments are optional:
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:odb/getNetworkPeeringConnection:getNetworkPeeringConnection', __args__, opts=opts, typ=GetNetworkPeeringConnectionResult)
    return __ret__.apply(lambda __response__: GetNetworkPeeringConnectionResult(
        arn=pulumi.get(__response__, 'arn'),
        created_at=pulumi.get(__response__, 'created_at'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        odb_network_arn=pulumi.get(__response__, 'odb_network_arn'),
        odb_peering_connection_type=pulumi.get(__response__, 'odb_peering_connection_type'),
        peer_network_arn=pulumi.get(__response__, 'peer_network_arn'),
        percent_progress=pulumi.get(__response__, 'percent_progress'),
        region=pulumi.get(__response__, 'region'),
        status=pulumi.get(__response__, 'status'),
        status_reason=pulumi.get(__response__, 'status_reason'),
        tags=pulumi.get(__response__, 'tags')))
