# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkArgs', 'Network']

@pulumi.input_type
class NetworkArgs:
    def __init__(__self__, *,
                 availability_zone_id: pulumi.Input[_builtins.str],
                 backup_subnet_cidr: pulumi.Input[_builtins.str],
                 client_subnet_cidr: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 s3_access: pulumi.Input[_builtins.str],
                 zero_etl_access: pulumi.Input[_builtins.str],
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 default_dns_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_associated_resources: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['NetworkTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a Network resource.
        :param pulumi.Input[_builtins.str] s3_access: Specifies the configuration for Amazon S3 access from the ODB network.
        :param pulumi.Input[_builtins.str] zero_etl_access: Specifies the configuration for Zero-ETL access from the ODB network.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] custom_domain_name: The name of the custom domain that the network is located. custom_domain_name and default_dns_prefix both can't be given.
        :param pulumi.Input[_builtins.bool] delete_associated_resources: If set to true deletes associated OCI resources. Default false.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] s3_policy_document: Specifies the endpoint policy for Amazon S3 access from the ODB network.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "availability_zone_id", availability_zone_id)
        pulumi.set(__self__, "backup_subnet_cidr", backup_subnet_cidr)
        pulumi.set(__self__, "client_subnet_cidr", client_subnet_cidr)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "s3_access", s3_access)
        pulumi.set(__self__, "zero_etl_access", zero_etl_access)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if custom_domain_name is not None:
            pulumi.set(__self__, "custom_domain_name", custom_domain_name)
        if default_dns_prefix is not None:
            pulumi.set(__self__, "default_dns_prefix", default_dns_prefix)
        if delete_associated_resources is not None:
            pulumi.set(__self__, "delete_associated_resources", delete_associated_resources)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if s3_policy_document is not None:
            pulumi.set(__self__, "s3_policy_document", s3_policy_document)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "availability_zone_id")

    @availability_zone_id.setter
    def availability_zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "availability_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="backupSubnetCidr")
    def backup_subnet_cidr(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "backup_subnet_cidr")

    @backup_subnet_cidr.setter
    def backup_subnet_cidr(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backup_subnet_cidr", value)

    @_builtins.property
    @pulumi.getter(name="clientSubnetCidr")
    def client_subnet_cidr(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "client_subnet_cidr")

    @client_subnet_cidr.setter
    def client_subnet_cidr(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_subnet_cidr", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="s3Access")
    def s3_access(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the configuration for Amazon S3 access from the ODB network.
        """
        return pulumi.get(self, "s3_access")

    @s3_access.setter
    def s3_access(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "s3_access", value)

    @_builtins.property
    @pulumi.getter(name="zeroEtlAccess")
    def zero_etl_access(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the configuration for Zero-ETL access from the ODB network.

        The following arguments are optional:
        """
        return pulumi.get(self, "zero_etl_access")

    @zero_etl_access.setter
    def zero_etl_access(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zero_etl_access", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="customDomainName")
    def custom_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the custom domain that the network is located. custom_domain_name and default_dns_prefix both can't be given.
        """
        return pulumi.get(self, "custom_domain_name")

    @custom_domain_name.setter
    def custom_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_domain_name", value)

    @_builtins.property
    @pulumi.getter(name="defaultDnsPrefix")
    def default_dns_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "default_dns_prefix")

    @default_dns_prefix.setter
    def default_dns_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_dns_prefix", value)

    @_builtins.property
    @pulumi.getter(name="deleteAssociatedResources")
    def delete_associated_resources(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true deletes associated OCI resources. Default false.
        """
        return pulumi.get(self, "delete_associated_resources")

    @delete_associated_resources.setter
    def delete_associated_resources(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_associated_resources", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="s3PolicyDocument")
    def s3_policy_document(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the endpoint policy for Amazon S3 access from the ODB network.
        """
        return pulumi.get(self, "s3_policy_document")

    @s3_policy_document.setter
    def s3_policy_document(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "s3_policy_document", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['NetworkTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['NetworkTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _NetworkState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 client_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 default_dns_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_associated_resources: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_services: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkManagedServiceArgs']]]] = None,
                 oci_dns_forwarding_configs: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkOciDnsForwardingConfigArgs']]]] = None,
                 oci_network_anchor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_network_anchor_url: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_resource_anchor_name: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_vcn_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_vcn_url: Optional[pulumi.Input[_builtins.str]] = None,
                 peered_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 percent_progress: Optional[pulumi.Input[_builtins.float]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_access: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 status_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['NetworkTimeoutsArgs']] = None,
                 zero_etl_access: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Network resources.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of the odb network resource.
        :param pulumi.Input[_builtins.str] created_at: The date and time when the ODB network was created.
        :param pulumi.Input[_builtins.str] custom_domain_name: The name of the custom domain that the network is located. custom_domain_name and default_dns_prefix both can't be given.
        :param pulumi.Input[_builtins.bool] delete_associated_resources: If set to true deletes associated OCI resources. Default false.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkManagedServiceArgs']]] managed_services: The name of the OCI resource anchor for the Exadata infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkOciDnsForwardingConfigArgs']]] oci_dns_forwarding_configs: The number of storage servers requested for the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] oci_network_anchor_id: The unique identifier of the OCI network anchor for the ODB network.
        :param pulumi.Input[_builtins.str] oci_network_anchor_url: The URL of the OCI network anchor for the ODB network.
        :param pulumi.Input[_builtins.str] oci_resource_anchor_name: The name of the OCI resource anchor for the ODB network.
        :param pulumi.Input[_builtins.str] oci_vcn_id: The unique identifier  Oracle Cloud ID (OCID) of the OCI VCN for the ODB network.
        :param pulumi.Input[_builtins.str] oci_vcn_url: The URL of the OCI VCN for the ODB network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] peered_cidrs: The list of CIDR ranges from the peered VPC that are allowed access to the ODB network. Please refer odb network peering documentation.
        :param pulumi.Input[_builtins.float] percent_progress: The amount of progress made on the current operation on the ODB network, expressed as a percentage.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] s3_access: Specifies the configuration for Amazon S3 access from the ODB network.
        :param pulumi.Input[_builtins.str] s3_policy_document: Specifies the endpoint policy for Amazon S3 access from the ODB network.
        :param pulumi.Input[_builtins.str] status: The status of the network resource.
        :param pulumi.Input[_builtins.str] status_reason: Additional information about the current status of the ODB network.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] zero_etl_access: Specifies the configuration for Zero-ETL access from the ODB network.
               
               The following arguments are optional:
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if availability_zone_id is not None:
            pulumi.set(__self__, "availability_zone_id", availability_zone_id)
        if backup_subnet_cidr is not None:
            pulumi.set(__self__, "backup_subnet_cidr", backup_subnet_cidr)
        if client_subnet_cidr is not None:
            pulumi.set(__self__, "client_subnet_cidr", client_subnet_cidr)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if custom_domain_name is not None:
            pulumi.set(__self__, "custom_domain_name", custom_domain_name)
        if default_dns_prefix is not None:
            pulumi.set(__self__, "default_dns_prefix", default_dns_prefix)
        if delete_associated_resources is not None:
            pulumi.set(__self__, "delete_associated_resources", delete_associated_resources)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if managed_services is not None:
            pulumi.set(__self__, "managed_services", managed_services)
        if oci_dns_forwarding_configs is not None:
            pulumi.set(__self__, "oci_dns_forwarding_configs", oci_dns_forwarding_configs)
        if oci_network_anchor_id is not None:
            pulumi.set(__self__, "oci_network_anchor_id", oci_network_anchor_id)
        if oci_network_anchor_url is not None:
            pulumi.set(__self__, "oci_network_anchor_url", oci_network_anchor_url)
        if oci_resource_anchor_name is not None:
            pulumi.set(__self__, "oci_resource_anchor_name", oci_resource_anchor_name)
        if oci_vcn_id is not None:
            pulumi.set(__self__, "oci_vcn_id", oci_vcn_id)
        if oci_vcn_url is not None:
            pulumi.set(__self__, "oci_vcn_url", oci_vcn_url)
        if peered_cidrs is not None:
            pulumi.set(__self__, "peered_cidrs", peered_cidrs)
        if percent_progress is not None:
            pulumi.set(__self__, "percent_progress", percent_progress)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if s3_access is not None:
            pulumi.set(__self__, "s3_access", s3_access)
        if s3_policy_document is not None:
            pulumi.set(__self__, "s3_policy_document", s3_policy_document)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_reason is not None:
            pulumi.set(__self__, "status_reason", status_reason)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if zero_etl_access is not None:
            pulumi.set(__self__, "zero_etl_access", zero_etl_access)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of the odb network resource.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "availability_zone_id")

    @availability_zone_id.setter
    def availability_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="backupSubnetCidr")
    def backup_subnet_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "backup_subnet_cidr")

    @backup_subnet_cidr.setter
    def backup_subnet_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_subnet_cidr", value)

    @_builtins.property
    @pulumi.getter(name="clientSubnetCidr")
    def client_subnet_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "client_subnet_cidr")

    @client_subnet_cidr.setter
    def client_subnet_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_subnet_cidr", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the ODB network was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="customDomainName")
    def custom_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the custom domain that the network is located. custom_domain_name and default_dns_prefix both can't be given.
        """
        return pulumi.get(self, "custom_domain_name")

    @custom_domain_name.setter
    def custom_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_domain_name", value)

    @_builtins.property
    @pulumi.getter(name="defaultDnsPrefix")
    def default_dns_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "default_dns_prefix")

    @default_dns_prefix.setter
    def default_dns_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_dns_prefix", value)

    @_builtins.property
    @pulumi.getter(name="deleteAssociatedResources")
    def delete_associated_resources(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true deletes associated OCI resources. Default false.
        """
        return pulumi.get(self, "delete_associated_resources")

    @delete_associated_resources.setter
    def delete_associated_resources(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_associated_resources", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="managedServices")
    def managed_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkManagedServiceArgs']]]]:
        """
        The name of the OCI resource anchor for the Exadata infrastructure.
        """
        return pulumi.get(self, "managed_services")

    @managed_services.setter
    def managed_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkManagedServiceArgs']]]]):
        pulumi.set(self, "managed_services", value)

    @_builtins.property
    @pulumi.getter(name="ociDnsForwardingConfigs")
    def oci_dns_forwarding_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkOciDnsForwardingConfigArgs']]]]:
        """
        The number of storage servers requested for the Exadata infrastructure.
        """
        return pulumi.get(self, "oci_dns_forwarding_configs")

    @oci_dns_forwarding_configs.setter
    def oci_dns_forwarding_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkOciDnsForwardingConfigArgs']]]]):
        pulumi.set(self, "oci_dns_forwarding_configs", value)

    @_builtins.property
    @pulumi.getter(name="ociNetworkAnchorId")
    def oci_network_anchor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the OCI network anchor for the ODB network.
        """
        return pulumi.get(self, "oci_network_anchor_id")

    @oci_network_anchor_id.setter
    def oci_network_anchor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oci_network_anchor_id", value)

    @_builtins.property
    @pulumi.getter(name="ociNetworkAnchorUrl")
    def oci_network_anchor_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the OCI network anchor for the ODB network.
        """
        return pulumi.get(self, "oci_network_anchor_url")

    @oci_network_anchor_url.setter
    def oci_network_anchor_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oci_network_anchor_url", value)

    @_builtins.property
    @pulumi.getter(name="ociResourceAnchorName")
    def oci_resource_anchor_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the OCI resource anchor for the ODB network.
        """
        return pulumi.get(self, "oci_resource_anchor_name")

    @oci_resource_anchor_name.setter
    def oci_resource_anchor_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oci_resource_anchor_name", value)

    @_builtins.property
    @pulumi.getter(name="ociVcnId")
    def oci_vcn_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier  Oracle Cloud ID (OCID) of the OCI VCN for the ODB network.
        """
        return pulumi.get(self, "oci_vcn_id")

    @oci_vcn_id.setter
    def oci_vcn_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oci_vcn_id", value)

    @_builtins.property
    @pulumi.getter(name="ociVcnUrl")
    def oci_vcn_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the OCI VCN for the ODB network.
        """
        return pulumi.get(self, "oci_vcn_url")

    @oci_vcn_url.setter
    def oci_vcn_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oci_vcn_url", value)

    @_builtins.property
    @pulumi.getter(name="peeredCidrs")
    def peered_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of CIDR ranges from the peered VPC that are allowed access to the ODB network. Please refer odb network peering documentation.
        """
        return pulumi.get(self, "peered_cidrs")

    @peered_cidrs.setter
    def peered_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "peered_cidrs", value)

    @_builtins.property
    @pulumi.getter(name="percentProgress")
    def percent_progress(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The amount of progress made on the current operation on the ODB network, expressed as a percentage.
        """
        return pulumi.get(self, "percent_progress")

    @percent_progress.setter
    def percent_progress(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "percent_progress", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="s3Access")
    def s3_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the configuration for Amazon S3 access from the ODB network.
        """
        return pulumi.get(self, "s3_access")

    @s3_access.setter
    def s3_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "s3_access", value)

    @_builtins.property
    @pulumi.getter(name="s3PolicyDocument")
    def s3_policy_document(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the endpoint policy for Amazon S3 access from the ODB network.
        """
        return pulumi.get(self, "s3_policy_document")

    @s3_policy_document.setter
    def s3_policy_document(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "s3_policy_document", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the network resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information about the current status of the ODB network.
        """
        return pulumi.get(self, "status_reason")

    @status_reason.setter
    def status_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status_reason", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['NetworkTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['NetworkTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="zeroEtlAccess")
    def zero_etl_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the configuration for Zero-ETL access from the ODB network.

        The following arguments are optional:
        """
        return pulumi.get(self, "zero_etl_access")

    @zero_etl_access.setter
    def zero_etl_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zero_etl_access", value)


@pulumi.type_token("aws:odb/network:Network")
class Network(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 client_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 default_dns_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_associated_resources: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_access: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['NetworkTimeoutsArgs', 'NetworkTimeoutsArgsDict']]] = None,
                 zero_etl_access: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing odb Network resource in AWS for Oracle Database@AWS.

        ## Example Usage

        ## Import

        Using `pulumi import`, import Odb Network using the `id`. For example:

        ```sh
        $ pulumi import aws:odb/network:Network example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_domain_name: The name of the custom domain that the network is located. custom_domain_name and default_dns_prefix both can't be given.
        :param pulumi.Input[_builtins.bool] delete_associated_resources: If set to true deletes associated OCI resources. Default false.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] s3_access: Specifies the configuration for Amazon S3 access from the ODB network.
        :param pulumi.Input[_builtins.str] s3_policy_document: Specifies the endpoint policy for Amazon S3 access from the ODB network.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] zero_etl_access: Specifies the configuration for Zero-ETL access from the ODB network.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing odb Network resource in AWS for Oracle Database@AWS.

        ## Example Usage

        ## Import

        Using `pulumi import`, import Odb Network using the `id`. For example:

        ```sh
        $ pulumi import aws:odb/network:Network example example
        ```

        :param str resource_name: The name of the resource.
        :param NetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 client_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 default_dns_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_associated_resources: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_access: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['NetworkTimeoutsArgs', 'NetworkTimeoutsArgsDict']]] = None,
                 zero_etl_access: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkArgs.__new__(NetworkArgs)

            __props__.__dict__["availability_zone"] = availability_zone
            if availability_zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone_id'")
            __props__.__dict__["availability_zone_id"] = availability_zone_id
            if backup_subnet_cidr is None and not opts.urn:
                raise TypeError("Missing required property 'backup_subnet_cidr'")
            __props__.__dict__["backup_subnet_cidr"] = backup_subnet_cidr
            if client_subnet_cidr is None and not opts.urn:
                raise TypeError("Missing required property 'client_subnet_cidr'")
            __props__.__dict__["client_subnet_cidr"] = client_subnet_cidr
            __props__.__dict__["custom_domain_name"] = custom_domain_name
            __props__.__dict__["default_dns_prefix"] = default_dns_prefix
            __props__.__dict__["delete_associated_resources"] = delete_associated_resources
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["region"] = region
            if s3_access is None and not opts.urn:
                raise TypeError("Missing required property 's3_access'")
            __props__.__dict__["s3_access"] = s3_access
            __props__.__dict__["s3_policy_document"] = s3_policy_document
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            if zero_etl_access is None and not opts.urn:
                raise TypeError("Missing required property 'zero_etl_access'")
            __props__.__dict__["zero_etl_access"] = zero_etl_access
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["managed_services"] = None
            __props__.__dict__["oci_dns_forwarding_configs"] = None
            __props__.__dict__["oci_network_anchor_id"] = None
            __props__.__dict__["oci_network_anchor_url"] = None
            __props__.__dict__["oci_resource_anchor_name"] = None
            __props__.__dict__["oci_vcn_id"] = None
            __props__.__dict__["oci_vcn_url"] = None
            __props__.__dict__["peered_cidrs"] = None
            __props__.__dict__["percent_progress"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["status_reason"] = None
            __props__.__dict__["tags_all"] = None
        super(Network, __self__).__init__(
            'aws:odb/network:Network',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            backup_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            client_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            custom_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            default_dns_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            delete_associated_resources: Optional[pulumi.Input[_builtins.bool]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            managed_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkManagedServiceArgs', 'NetworkManagedServiceArgsDict']]]]] = None,
            oci_dns_forwarding_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NetworkOciDnsForwardingConfigArgs', 'NetworkOciDnsForwardingConfigArgsDict']]]]] = None,
            oci_network_anchor_id: Optional[pulumi.Input[_builtins.str]] = None,
            oci_network_anchor_url: Optional[pulumi.Input[_builtins.str]] = None,
            oci_resource_anchor_name: Optional[pulumi.Input[_builtins.str]] = None,
            oci_vcn_id: Optional[pulumi.Input[_builtins.str]] = None,
            oci_vcn_url: Optional[pulumi.Input[_builtins.str]] = None,
            peered_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            percent_progress: Optional[pulumi.Input[_builtins.float]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            s3_access: Optional[pulumi.Input[_builtins.str]] = None,
            s3_policy_document: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            status_reason: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['NetworkTimeoutsArgs', 'NetworkTimeoutsArgsDict']]] = None,
            zero_etl_access: Optional[pulumi.Input[_builtins.str]] = None) -> 'Network':
        """
        Get an existing Network resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of the odb network resource.
        :param pulumi.Input[_builtins.str] created_at: The date and time when the ODB network was created.
        :param pulumi.Input[_builtins.str] custom_domain_name: The name of the custom domain that the network is located. custom_domain_name and default_dns_prefix both can't be given.
        :param pulumi.Input[_builtins.bool] delete_associated_resources: If set to true deletes associated OCI resources. Default false.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkManagedServiceArgs', 'NetworkManagedServiceArgsDict']]]] managed_services: The name of the OCI resource anchor for the Exadata infrastructure.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NetworkOciDnsForwardingConfigArgs', 'NetworkOciDnsForwardingConfigArgsDict']]]] oci_dns_forwarding_configs: The number of storage servers requested for the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] oci_network_anchor_id: The unique identifier of the OCI network anchor for the ODB network.
        :param pulumi.Input[_builtins.str] oci_network_anchor_url: The URL of the OCI network anchor for the ODB network.
        :param pulumi.Input[_builtins.str] oci_resource_anchor_name: The name of the OCI resource anchor for the ODB network.
        :param pulumi.Input[_builtins.str] oci_vcn_id: The unique identifier  Oracle Cloud ID (OCID) of the OCI VCN for the ODB network.
        :param pulumi.Input[_builtins.str] oci_vcn_url: The URL of the OCI VCN for the ODB network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] peered_cidrs: The list of CIDR ranges from the peered VPC that are allowed access to the ODB network. Please refer odb network peering documentation.
        :param pulumi.Input[_builtins.float] percent_progress: The amount of progress made on the current operation on the ODB network, expressed as a percentage.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] s3_access: Specifies the configuration for Amazon S3 access from the ODB network.
        :param pulumi.Input[_builtins.str] s3_policy_document: Specifies the endpoint policy for Amazon S3 access from the ODB network.
        :param pulumi.Input[_builtins.str] status: The status of the network resource.
        :param pulumi.Input[_builtins.str] status_reason: Additional information about the current status of the ODB network.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] zero_etl_access: Specifies the configuration for Zero-ETL access from the ODB network.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkState.__new__(_NetworkState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["availability_zone_id"] = availability_zone_id
        __props__.__dict__["backup_subnet_cidr"] = backup_subnet_cidr
        __props__.__dict__["client_subnet_cidr"] = client_subnet_cidr
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["custom_domain_name"] = custom_domain_name
        __props__.__dict__["default_dns_prefix"] = default_dns_prefix
        __props__.__dict__["delete_associated_resources"] = delete_associated_resources
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["managed_services"] = managed_services
        __props__.__dict__["oci_dns_forwarding_configs"] = oci_dns_forwarding_configs
        __props__.__dict__["oci_network_anchor_id"] = oci_network_anchor_id
        __props__.__dict__["oci_network_anchor_url"] = oci_network_anchor_url
        __props__.__dict__["oci_resource_anchor_name"] = oci_resource_anchor_name
        __props__.__dict__["oci_vcn_id"] = oci_vcn_id
        __props__.__dict__["oci_vcn_url"] = oci_vcn_url
        __props__.__dict__["peered_cidrs"] = peered_cidrs
        __props__.__dict__["percent_progress"] = percent_progress
        __props__.__dict__["region"] = region
        __props__.__dict__["s3_access"] = s3_access
        __props__.__dict__["s3_policy_document"] = s3_policy_document
        __props__.__dict__["status"] = status
        __props__.__dict__["status_reason"] = status_reason
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["zero_etl_access"] = zero_etl_access
        return Network(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        Amazon Resource Name (ARN) of the odb network resource.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "availability_zone_id")

    @_builtins.property
    @pulumi.getter(name="backupSubnetCidr")
    def backup_subnet_cidr(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "backup_subnet_cidr")

    @_builtins.property
    @pulumi.getter(name="clientSubnetCidr")
    def client_subnet_cidr(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "client_subnet_cidr")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the ODB network was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="customDomainName")
    def custom_domain_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the custom domain that the network is located. custom_domain_name and default_dns_prefix both can't be given.
        """
        return pulumi.get(self, "custom_domain_name")

    @_builtins.property
    @pulumi.getter(name="defaultDnsPrefix")
    def default_dns_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "default_dns_prefix")

    @_builtins.property
    @pulumi.getter(name="deleteAssociatedResources")
    def delete_associated_resources(self) -> pulumi.Output[_builtins.bool]:
        """
        If set to true deletes associated OCI resources. Default false.
        """
        return pulumi.get(self, "delete_associated_resources")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="managedServices")
    def managed_services(self) -> pulumi.Output[Sequence['outputs.NetworkManagedService']]:
        """
        The name of the OCI resource anchor for the Exadata infrastructure.
        """
        return pulumi.get(self, "managed_services")

    @_builtins.property
    @pulumi.getter(name="ociDnsForwardingConfigs")
    def oci_dns_forwarding_configs(self) -> pulumi.Output[Sequence['outputs.NetworkOciDnsForwardingConfig']]:
        """
        The number of storage servers requested for the Exadata infrastructure.
        """
        return pulumi.get(self, "oci_dns_forwarding_configs")

    @_builtins.property
    @pulumi.getter(name="ociNetworkAnchorId")
    def oci_network_anchor_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the OCI network anchor for the ODB network.
        """
        return pulumi.get(self, "oci_network_anchor_id")

    @_builtins.property
    @pulumi.getter(name="ociNetworkAnchorUrl")
    def oci_network_anchor_url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the OCI network anchor for the ODB network.
        """
        return pulumi.get(self, "oci_network_anchor_url")

    @_builtins.property
    @pulumi.getter(name="ociResourceAnchorName")
    def oci_resource_anchor_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the OCI resource anchor for the ODB network.
        """
        return pulumi.get(self, "oci_resource_anchor_name")

    @_builtins.property
    @pulumi.getter(name="ociVcnId")
    def oci_vcn_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier  Oracle Cloud ID (OCID) of the OCI VCN for the ODB network.
        """
        return pulumi.get(self, "oci_vcn_id")

    @_builtins.property
    @pulumi.getter(name="ociVcnUrl")
    def oci_vcn_url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the OCI VCN for the ODB network.
        """
        return pulumi.get(self, "oci_vcn_url")

    @_builtins.property
    @pulumi.getter(name="peeredCidrs")
    def peered_cidrs(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of CIDR ranges from the peered VPC that are allowed access to the ODB network. Please refer odb network peering documentation.
        """
        return pulumi.get(self, "peered_cidrs")

    @_builtins.property
    @pulumi.getter(name="percentProgress")
    def percent_progress(self) -> pulumi.Output[_builtins.float]:
        """
        The amount of progress made on the current operation on the ODB network, expressed as a percentage.
        """
        return pulumi.get(self, "percent_progress")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="s3Access")
    def s3_access(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the configuration for Amazon S3 access from the ODB network.
        """
        return pulumi.get(self, "s3_access")

    @_builtins.property
    @pulumi.getter(name="s3PolicyDocument")
    def s3_policy_document(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the endpoint policy for Amazon S3 access from the ODB network.
        """
        return pulumi.get(self, "s3_policy_document")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the network resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> pulumi.Output[_builtins.str]:
        """
        Additional information about the current status of the ODB network.
        """
        return pulumi.get(self, "status_reason")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.NetworkTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="zeroEtlAccess")
    def zero_etl_access(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the configuration for Zero-ETL access from the ODB network.

        The following arguments are optional:
        """
        return pulumi.get(self, "zero_etl_access")

