# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkPeeringConnectionArgs', 'NetworkPeeringConnection']

@pulumi.input_type
class NetworkPeeringConnectionArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 odb_network_id: pulumi.Input[_builtins.str],
                 peer_network_id: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['NetworkPeeringConnectionTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a NetworkPeeringConnection resource.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "odb_network_id", odb_network_id)
        pulumi.set(__self__, "peer_network_id", peer_network_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="odbNetworkId")
    def odb_network_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "odb_network_id")

    @odb_network_id.setter
    def odb_network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "odb_network_id", value)

    @_builtins.property
    @pulumi.getter(name="peerNetworkId")
    def peer_network_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "peer_network_id")

    @peer_network_id.setter
    def peer_network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "peer_network_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['NetworkPeeringConnectionTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['NetworkPeeringConnectionTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _NetworkPeeringConnectionState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_network_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_peering_connection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_network_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 percent_progress: Optional[pulumi.Input[_builtins.float]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 status_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['NetworkPeeringConnectionTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering NetworkPeeringConnection resources.
        :param pulumi.Input[_builtins.str] created_at: Created time of the ODB network peering connection.
        :param pulumi.Input[_builtins.str] odb_network_arn: ARN of the ODB network peering connection.
        :param pulumi.Input[_builtins.str] odb_peering_connection_type: Type of the ODB peering connection.
        :param pulumi.Input[_builtins.str] peer_network_arn: ARN of the peer network peering connection.
        :param pulumi.Input[_builtins.float] percent_progress: Progress of the ODB network peering connection.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] status: Status of the ODB network peering connection.
        :param pulumi.Input[_builtins.str] status_reason: The reason for the current status of the ODB peering connection.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including inherited tags.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if odb_network_arn is not None:
            pulumi.set(__self__, "odb_network_arn", odb_network_arn)
        if odb_network_id is not None:
            pulumi.set(__self__, "odb_network_id", odb_network_id)
        if odb_peering_connection_type is not None:
            pulumi.set(__self__, "odb_peering_connection_type", odb_peering_connection_type)
        if peer_network_arn is not None:
            pulumi.set(__self__, "peer_network_arn", peer_network_arn)
        if peer_network_id is not None:
            pulumi.set(__self__, "peer_network_id", peer_network_id)
        if percent_progress is not None:
            pulumi.set(__self__, "percent_progress", percent_progress)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_reason is not None:
            pulumi.set(__self__, "status_reason", status_reason)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Created time of the ODB network peering connection.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="odbNetworkArn")
    def odb_network_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the ODB network peering connection.
        """
        return pulumi.get(self, "odb_network_arn")

    @odb_network_arn.setter
    def odb_network_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "odb_network_arn", value)

    @_builtins.property
    @pulumi.getter(name="odbNetworkId")
    def odb_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "odb_network_id")

    @odb_network_id.setter
    def odb_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "odb_network_id", value)

    @_builtins.property
    @pulumi.getter(name="odbPeeringConnectionType")
    def odb_peering_connection_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the ODB peering connection.
        """
        return pulumi.get(self, "odb_peering_connection_type")

    @odb_peering_connection_type.setter
    def odb_peering_connection_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "odb_peering_connection_type", value)

    @_builtins.property
    @pulumi.getter(name="peerNetworkArn")
    def peer_network_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the peer network peering connection.
        """
        return pulumi.get(self, "peer_network_arn")

    @peer_network_arn.setter
    def peer_network_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_network_arn", value)

    @_builtins.property
    @pulumi.getter(name="peerNetworkId")
    def peer_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "peer_network_id")

    @peer_network_id.setter
    def peer_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_network_id", value)

    @_builtins.property
    @pulumi.getter(name="percentProgress")
    def percent_progress(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Progress of the ODB network peering connection.
        """
        return pulumi.get(self, "percent_progress")

    @percent_progress.setter
    def percent_progress(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "percent_progress", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the ODB network peering connection.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reason for the current status of the ODB peering connection.
        """
        return pulumi.get(self, "status_reason")

    @status_reason.setter
    def status_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status_reason", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including inherited tags.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['NetworkPeeringConnectionTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['NetworkPeeringConnectionTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:odb/networkPeeringConnection:NetworkPeeringConnection")
class NetworkPeeringConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['NetworkPeeringConnectionTimeoutsArgs', 'NetworkPeeringConnectionTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.odb.NetworkPeeringConnection("example",
            display_name="example",
            odb_network_id="my-odb-network-id",
            peer_network_id="my-vpc-id",
            tags={
                "env": "dev",
            })
        ```

        ## Import

        Using `pulumi import`, import odb network peering using the `id`. For example:

        ```sh
        $ pulumi import aws:odb/networkPeeringConnection:NetworkPeeringConnection example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkPeeringConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.odb.NetworkPeeringConnection("example",
            display_name="example",
            odb_network_id="my-odb-network-id",
            peer_network_id="my-vpc-id",
            tags={
                "env": "dev",
            })
        ```

        ## Import

        Using `pulumi import`, import odb network peering using the `id`. For example:

        ```sh
        $ pulumi import aws:odb/networkPeeringConnection:NetworkPeeringConnection example example
        ```

        :param str resource_name: The name of the resource.
        :param NetworkPeeringConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkPeeringConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['NetworkPeeringConnectionTimeoutsArgs', 'NetworkPeeringConnectionTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkPeeringConnectionArgs.__new__(NetworkPeeringConnectionArgs)

            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if odb_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'odb_network_id'")
            __props__.__dict__["odb_network_id"] = odb_network_id
            if peer_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'peer_network_id'")
            __props__.__dict__["peer_network_id"] = peer_network_id
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["odb_network_arn"] = None
            __props__.__dict__["odb_peering_connection_type"] = None
            __props__.__dict__["peer_network_arn"] = None
            __props__.__dict__["percent_progress"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["status_reason"] = None
            __props__.__dict__["tags_all"] = None
        super(NetworkPeeringConnection, __self__).__init__(
            'aws:odb/networkPeeringConnection:NetworkPeeringConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            odb_network_arn: Optional[pulumi.Input[_builtins.str]] = None,
            odb_network_id: Optional[pulumi.Input[_builtins.str]] = None,
            odb_peering_connection_type: Optional[pulumi.Input[_builtins.str]] = None,
            peer_network_arn: Optional[pulumi.Input[_builtins.str]] = None,
            peer_network_id: Optional[pulumi.Input[_builtins.str]] = None,
            percent_progress: Optional[pulumi.Input[_builtins.float]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            status_reason: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['NetworkPeeringConnectionTimeoutsArgs', 'NetworkPeeringConnectionTimeoutsArgsDict']]] = None) -> 'NetworkPeeringConnection':
        """
        Get an existing NetworkPeeringConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: Created time of the ODB network peering connection.
        :param pulumi.Input[_builtins.str] odb_network_arn: ARN of the ODB network peering connection.
        :param pulumi.Input[_builtins.str] odb_peering_connection_type: Type of the ODB peering connection.
        :param pulumi.Input[_builtins.str] peer_network_arn: ARN of the peer network peering connection.
        :param pulumi.Input[_builtins.float] percent_progress: Progress of the ODB network peering connection.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] status: Status of the ODB network peering connection.
        :param pulumi.Input[_builtins.str] status_reason: The reason for the current status of the ODB peering connection.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including inherited tags.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkPeeringConnectionState.__new__(_NetworkPeeringConnectionState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["odb_network_arn"] = odb_network_arn
        __props__.__dict__["odb_network_id"] = odb_network_id
        __props__.__dict__["odb_peering_connection_type"] = odb_peering_connection_type
        __props__.__dict__["peer_network_arn"] = peer_network_arn
        __props__.__dict__["peer_network_id"] = peer_network_id
        __props__.__dict__["percent_progress"] = percent_progress
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["status_reason"] = status_reason
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        return NetworkPeeringConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Created time of the ODB network peering connection.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="odbNetworkArn")
    def odb_network_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the ODB network peering connection.
        """
        return pulumi.get(self, "odb_network_arn")

    @_builtins.property
    @pulumi.getter(name="odbNetworkId")
    def odb_network_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "odb_network_id")

    @_builtins.property
    @pulumi.getter(name="odbPeeringConnectionType")
    def odb_peering_connection_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the ODB peering connection.
        """
        return pulumi.get(self, "odb_peering_connection_type")

    @_builtins.property
    @pulumi.getter(name="peerNetworkArn")
    def peer_network_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the peer network peering connection.
        """
        return pulumi.get(self, "peer_network_arn")

    @_builtins.property
    @pulumi.getter(name="peerNetworkId")
    def peer_network_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "peer_network_id")

    @_builtins.property
    @pulumi.getter(name="percentProgress")
    def percent_progress(self) -> pulumi.Output[_builtins.float]:
        """
        Progress of the ODB network peering connection.
        """
        return pulumi.get(self, "percent_progress")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the ODB network peering connection.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> pulumi.Output[_builtins.str]:
        """
        The reason for the current status of the ODB peering connection.
        """
        return pulumi.get(self, "status_reason")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including inherited tags.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.NetworkPeeringConnectionTimeouts']]:
        return pulumi.get(self, "timeouts")

