# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'CloudAutonomousVmClusterMaintenanceWindow',
    'CloudAutonomousVmClusterMaintenanceWindowDaysOfWeek',
    'CloudAutonomousVmClusterMaintenanceWindowMonth',
    'CloudAutonomousVmClusterTimeouts',
    'CloudExadataInfrastructureCustomerContactsToSendToOci',
    'CloudExadataInfrastructureMaintenanceWindow',
    'CloudExadataInfrastructureMaintenanceWindowDaysOfWeek',
    'CloudExadataInfrastructureMaintenanceWindowMonth',
    'CloudExadataInfrastructureTimeouts',
    'CloudVmClusterDataCollectionOptions',
    'CloudVmClusterIormConfigCach',
    'CloudVmClusterIormConfigCachDbPlan',
    'CloudVmClusterTimeouts',
    'NetworkManagedService',
    'NetworkManagedServiceManagedS3BackupAccess',
    'NetworkManagedServiceS3Access',
    'NetworkManagedServiceServiceNetworkEndpoint',
    'NetworkManagedServiceZeroEtlAccess',
    'NetworkOciDnsForwardingConfig',
    'NetworkPeeringConnectionTimeouts',
    'NetworkTimeouts',
    'GetCloudAutonomousVmClusterMaintenanceWindowResult',
    'GetCloudAutonomousVmClusterMaintenanceWindowDaysOfWeekResult',
    'GetCloudAutonomousVmClusterMaintenanceWindowMonthResult',
    'GetCloudAutonomousVmClustersCloudAutonomousVmClusterResult',
    'GetCloudExadataInfrastructureCustomerContactsToSendToOciResult',
    'GetCloudExadataInfrastructureMaintenanceWindowResult',
    'GetCloudExadataInfrastructureMaintenanceWindowDaysOfWeekResult',
    'GetCloudExadataInfrastructureMaintenanceWindowMonthResult',
    'GetCloudExadataInfrastructuresCloudExadataInfrastructureResult',
    'GetCloudVmClusterDataCollectionOptionResult',
    'GetCloudVmClusterIormConfigCachResult',
    'GetCloudVmClusterIormConfigCachDbPlanResult',
    'GetCloudVmClustersCloudVmClusterResult',
    'GetDbNodesDbNodeResult',
    'GetDbServerDbServerPatchingDetailResult',
    'GetDbServersDbServerResult',
    'GetDbServersDbServerDbServerPatchingDetailResult',
    'GetDbSystemShapesDbSystemShapeResult',
    'GetGiVersionsGiVersionResult',
    'GetNetworkManagedServiceResult',
    'GetNetworkManagedServiceManagedS3BackupAccessResult',
    'GetNetworkManagedServiceS3AccessResult',
    'GetNetworkManagedServiceServiceNetworkEndpointResult',
    'GetNetworkManagedServiceZeroTlAccessResult',
    'GetNetworkOciDnsForwardingConfigResult',
    'GetNetworkPeeringConnectionsOdbPeeringConnectionResult',
    'GetNetworksOdbNetworkResult',
]

@pulumi.output_type
class CloudAutonomousVmClusterMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daysOfWeeks":
            suggest = "days_of_weeks"
        elif key == "hoursOfDays":
            suggest = "hours_of_days"
        elif key == "leadTimeInWeeks":
            suggest = "lead_time_in_weeks"
        elif key == "weeksOfMonths":
            suggest = "weeks_of_months"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudAutonomousVmClusterMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudAutonomousVmClusterMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudAutonomousVmClusterMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 preference: _builtins.str,
                 days_of_weeks: Optional[Sequence['outputs.CloudAutonomousVmClusterMaintenanceWindowDaysOfWeek']] = None,
                 hours_of_days: Optional[Sequence[_builtins.int]] = None,
                 lead_time_in_weeks: Optional[_builtins.int] = None,
                 months: Optional[Sequence['outputs.CloudAutonomousVmClusterMaintenanceWindowMonth']] = None,
                 weeks_of_months: Optional[Sequence[_builtins.int]] = None):
        """
        :param _builtins.str preference: The preference for the maintenance window scheduling.
        :param Sequence['CloudAutonomousVmClusterMaintenanceWindowDaysOfWeekArgs'] days_of_weeks: The days of the week when maintenance can be performed.
        :param Sequence[_builtins.int] hours_of_days: The hours of the day when maintenance can be performed.
        :param _builtins.int lead_time_in_weeks: The lead time in weeks before the maintenance window.
        :param Sequence['CloudAutonomousVmClusterMaintenanceWindowMonthArgs'] months: The months when maintenance can be performed.
        :param Sequence[_builtins.int] weeks_of_months: Indicates whether to skip release updates during maintenance.
        """
        pulumi.set(__self__, "preference", preference)
        if days_of_weeks is not None:
            pulumi.set(__self__, "days_of_weeks", days_of_weeks)
        if hours_of_days is not None:
            pulumi.set(__self__, "hours_of_days", hours_of_days)
        if lead_time_in_weeks is not None:
            pulumi.set(__self__, "lead_time_in_weeks", lead_time_in_weeks)
        if months is not None:
            pulumi.set(__self__, "months", months)
        if weeks_of_months is not None:
            pulumi.set(__self__, "weeks_of_months", weeks_of_months)

    @_builtins.property
    @pulumi.getter
    def preference(self) -> _builtins.str:
        """
        The preference for the maintenance window scheduling.
        """
        return pulumi.get(self, "preference")

    @_builtins.property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Optional[Sequence['outputs.CloudAutonomousVmClusterMaintenanceWindowDaysOfWeek']]:
        """
        The days of the week when maintenance can be performed.
        """
        return pulumi.get(self, "days_of_weeks")

    @_builtins.property
    @pulumi.getter(name="hoursOfDays")
    def hours_of_days(self) -> Optional[Sequence[_builtins.int]]:
        """
        The hours of the day when maintenance can be performed.
        """
        return pulumi.get(self, "hours_of_days")

    @_builtins.property
    @pulumi.getter(name="leadTimeInWeeks")
    def lead_time_in_weeks(self) -> Optional[_builtins.int]:
        """
        The lead time in weeks before the maintenance window.
        """
        return pulumi.get(self, "lead_time_in_weeks")

    @_builtins.property
    @pulumi.getter
    def months(self) -> Optional[Sequence['outputs.CloudAutonomousVmClusterMaintenanceWindowMonth']]:
        """
        The months when maintenance can be performed.
        """
        return pulumi.get(self, "months")

    @_builtins.property
    @pulumi.getter(name="weeksOfMonths")
    def weeks_of_months(self) -> Optional[Sequence[_builtins.int]]:
        """
        Indicates whether to skip release updates during maintenance.
        """
        return pulumi.get(self, "weeks_of_months")


@pulumi.output_type
class CloudAutonomousVmClusterMaintenanceWindowDaysOfWeek(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class CloudAutonomousVmClusterMaintenanceWindowMonth(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class CloudAutonomousVmClusterTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None,
                 update: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param _builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class CloudExadataInfrastructureCustomerContactsToSendToOci(dict):
    def __init__(__self__, *,
                 email: _builtins.str):
        pulumi.set(__self__, "email", email)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        return pulumi.get(self, "email")


@pulumi.output_type
class CloudExadataInfrastructureMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customActionTimeoutInMins":
            suggest = "custom_action_timeout_in_mins"
        elif key == "isCustomActionTimeoutEnabled":
            suggest = "is_custom_action_timeout_enabled"
        elif key == "patchingMode":
            suggest = "patching_mode"
        elif key == "daysOfWeeks":
            suggest = "days_of_weeks"
        elif key == "hoursOfDays":
            suggest = "hours_of_days"
        elif key == "leadTimeInWeeks":
            suggest = "lead_time_in_weeks"
        elif key == "weeksOfMonths":
            suggest = "weeks_of_months"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudExadataInfrastructureMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudExadataInfrastructureMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudExadataInfrastructureMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_action_timeout_in_mins: _builtins.int,
                 is_custom_action_timeout_enabled: _builtins.bool,
                 patching_mode: _builtins.str,
                 preference: _builtins.str,
                 days_of_weeks: Optional[Sequence['outputs.CloudExadataInfrastructureMaintenanceWindowDaysOfWeek']] = None,
                 hours_of_days: Optional[Sequence[_builtins.int]] = None,
                 lead_time_in_weeks: Optional[_builtins.int] = None,
                 months: Optional[Sequence['outputs.CloudExadataInfrastructureMaintenanceWindowMonth']] = None,
                 weeks_of_months: Optional[Sequence[_builtins.int]] = None):
        """
        :param _builtins.int custom_action_timeout_in_mins: The custom action timeout in minutes for the maintenance window.
        :param _builtins.bool is_custom_action_timeout_enabled: ndicates whether custom action timeout is enabled for the maintenance window.
        :param _builtins.str patching_mode: The patching mode for the maintenance window.
        :param _builtins.str preference: The preference for the maintenance window scheduling.
        :param Sequence['CloudExadataInfrastructureMaintenanceWindowDaysOfWeekArgs'] days_of_weeks: The days of the week when maintenance can be performed.
        :param Sequence[_builtins.int] hours_of_days: The hours of the day when maintenance can be performed.
        :param _builtins.int lead_time_in_weeks: The lead time in weeks before the maintenance window.
        :param Sequence['CloudExadataInfrastructureMaintenanceWindowMonthArgs'] months: The months when maintenance can be performed.
        :param Sequence[_builtins.int] weeks_of_months: The weeks of the month when maintenance can be performed.
        """
        pulumi.set(__self__, "custom_action_timeout_in_mins", custom_action_timeout_in_mins)
        pulumi.set(__self__, "is_custom_action_timeout_enabled", is_custom_action_timeout_enabled)
        pulumi.set(__self__, "patching_mode", patching_mode)
        pulumi.set(__self__, "preference", preference)
        if days_of_weeks is not None:
            pulumi.set(__self__, "days_of_weeks", days_of_weeks)
        if hours_of_days is not None:
            pulumi.set(__self__, "hours_of_days", hours_of_days)
        if lead_time_in_weeks is not None:
            pulumi.set(__self__, "lead_time_in_weeks", lead_time_in_weeks)
        if months is not None:
            pulumi.set(__self__, "months", months)
        if weeks_of_months is not None:
            pulumi.set(__self__, "weeks_of_months", weeks_of_months)

    @_builtins.property
    @pulumi.getter(name="customActionTimeoutInMins")
    def custom_action_timeout_in_mins(self) -> _builtins.int:
        """
        The custom action timeout in minutes for the maintenance window.
        """
        return pulumi.get(self, "custom_action_timeout_in_mins")

    @_builtins.property
    @pulumi.getter(name="isCustomActionTimeoutEnabled")
    def is_custom_action_timeout_enabled(self) -> _builtins.bool:
        """
        ndicates whether custom action timeout is enabled for the maintenance window.
        """
        return pulumi.get(self, "is_custom_action_timeout_enabled")

    @_builtins.property
    @pulumi.getter(name="patchingMode")
    def patching_mode(self) -> _builtins.str:
        """
        The patching mode for the maintenance window.
        """
        return pulumi.get(self, "patching_mode")

    @_builtins.property
    @pulumi.getter
    def preference(self) -> _builtins.str:
        """
        The preference for the maintenance window scheduling.
        """
        return pulumi.get(self, "preference")

    @_builtins.property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Optional[Sequence['outputs.CloudExadataInfrastructureMaintenanceWindowDaysOfWeek']]:
        """
        The days of the week when maintenance can be performed.
        """
        return pulumi.get(self, "days_of_weeks")

    @_builtins.property
    @pulumi.getter(name="hoursOfDays")
    def hours_of_days(self) -> Optional[Sequence[_builtins.int]]:
        """
        The hours of the day when maintenance can be performed.
        """
        return pulumi.get(self, "hours_of_days")

    @_builtins.property
    @pulumi.getter(name="leadTimeInWeeks")
    def lead_time_in_weeks(self) -> Optional[_builtins.int]:
        """
        The lead time in weeks before the maintenance window.
        """
        return pulumi.get(self, "lead_time_in_weeks")

    @_builtins.property
    @pulumi.getter
    def months(self) -> Optional[Sequence['outputs.CloudExadataInfrastructureMaintenanceWindowMonth']]:
        """
        The months when maintenance can be performed.
        """
        return pulumi.get(self, "months")

    @_builtins.property
    @pulumi.getter(name="weeksOfMonths")
    def weeks_of_months(self) -> Optional[Sequence[_builtins.int]]:
        """
        The weeks of the month when maintenance can be performed.
        """
        return pulumi.get(self, "weeks_of_months")


@pulumi.output_type
class CloudExadataInfrastructureMaintenanceWindowDaysOfWeek(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class CloudExadataInfrastructureMaintenanceWindowMonth(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class CloudExadataInfrastructureTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None,
                 update: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param _builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class CloudVmClusterDataCollectionOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isDiagnosticsEventsEnabled":
            suggest = "is_diagnostics_events_enabled"
        elif key == "isHealthMonitoringEnabled":
            suggest = "is_health_monitoring_enabled"
        elif key == "isIncidentLogsEnabled":
            suggest = "is_incident_logs_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudVmClusterDataCollectionOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudVmClusterDataCollectionOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudVmClusterDataCollectionOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_diagnostics_events_enabled: _builtins.bool,
                 is_health_monitoring_enabled: _builtins.bool,
                 is_incident_logs_enabled: _builtins.bool):
        pulumi.set(__self__, "is_diagnostics_events_enabled", is_diagnostics_events_enabled)
        pulumi.set(__self__, "is_health_monitoring_enabled", is_health_monitoring_enabled)
        pulumi.set(__self__, "is_incident_logs_enabled", is_incident_logs_enabled)

    @_builtins.property
    @pulumi.getter(name="isDiagnosticsEventsEnabled")
    def is_diagnostics_events_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "is_diagnostics_events_enabled")

    @_builtins.property
    @pulumi.getter(name="isHealthMonitoringEnabled")
    def is_health_monitoring_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "is_health_monitoring_enabled")

    @_builtins.property
    @pulumi.getter(name="isIncidentLogsEnabled")
    def is_incident_logs_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "is_incident_logs_enabled")


@pulumi.output_type
class CloudVmClusterIormConfigCach(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dbPlans":
            suggest = "db_plans"
        elif key == "lifecycleDetails":
            suggest = "lifecycle_details"
        elif key == "lifecycleState":
            suggest = "lifecycle_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudVmClusterIormConfigCach. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudVmClusterIormConfigCach.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudVmClusterIormConfigCach.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 db_plans: Sequence['outputs.CloudVmClusterIormConfigCachDbPlan'],
                 lifecycle_details: _builtins.str,
                 lifecycle_state: _builtins.str,
                 objective: _builtins.str):
        pulumi.set(__self__, "db_plans", db_plans)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "lifecycle_state", lifecycle_state)
        pulumi.set(__self__, "objective", objective)

    @_builtins.property
    @pulumi.getter(name="dbPlans")
    def db_plans(self) -> Sequence['outputs.CloudVmClusterIormConfigCachDbPlan']:
        return pulumi.get(self, "db_plans")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> _builtins.str:
        return pulumi.get(self, "lifecycle_state")

    @_builtins.property
    @pulumi.getter
    def objective(self) -> _builtins.str:
        return pulumi.get(self, "objective")


@pulumi.output_type
class CloudVmClusterIormConfigCachDbPlan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dbName":
            suggest = "db_name"
        elif key == "flashCacheLimit":
            suggest = "flash_cache_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudVmClusterIormConfigCachDbPlan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudVmClusterIormConfigCachDbPlan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudVmClusterIormConfigCachDbPlan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 db_name: _builtins.str,
                 flash_cache_limit: _builtins.str,
                 share: _builtins.int):
        pulumi.set(__self__, "db_name", db_name)
        pulumi.set(__self__, "flash_cache_limit", flash_cache_limit)
        pulumi.set(__self__, "share", share)

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> _builtins.str:
        return pulumi.get(self, "db_name")

    @_builtins.property
    @pulumi.getter(name="flashCacheLimit")
    def flash_cache_limit(self) -> _builtins.str:
        return pulumi.get(self, "flash_cache_limit")

    @_builtins.property
    @pulumi.getter
    def share(self) -> _builtins.int:
        return pulumi.get(self, "share")


@pulumi.output_type
class CloudVmClusterTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None,
                 update: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param _builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class NetworkManagedService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "managedS3BackupAccesses":
            suggest = "managed_s3_backup_accesses"
        elif key == "managedServiceIpv4Cidrs":
            suggest = "managed_service_ipv4_cidrs"
        elif key == "resourceGatewayArn":
            suggest = "resource_gateway_arn"
        elif key == "s3Accesses":
            suggest = "s3_accesses"
        elif key == "serviceNetworkArn":
            suggest = "service_network_arn"
        elif key == "serviceNetworkEndpoints":
            suggest = "service_network_endpoints"
        elif key == "zeroEtlAccesses":
            suggest = "zero_etl_accesses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkManagedService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkManagedService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkManagedService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 managed_s3_backup_accesses: Sequence['outputs.NetworkManagedServiceManagedS3BackupAccess'],
                 managed_service_ipv4_cidrs: Sequence[_builtins.str],
                 resource_gateway_arn: _builtins.str,
                 s3_accesses: Sequence['outputs.NetworkManagedServiceS3Access'],
                 service_network_arn: _builtins.str,
                 service_network_endpoints: Sequence['outputs.NetworkManagedServiceServiceNetworkEndpoint'],
                 zero_etl_accesses: Sequence['outputs.NetworkManagedServiceZeroEtlAccess']):
        """
        :param Sequence['NetworkManagedServiceS3AccessArgs'] s3_accesses: Specifies the configuration for Amazon S3 access from the ODB network.
        :param Sequence['NetworkManagedServiceZeroEtlAccessArgs'] zero_etl_accesses: Specifies the configuration for Zero-ETL access from the ODB network.
               
               The following arguments are optional:
        """
        pulumi.set(__self__, "managed_s3_backup_accesses", managed_s3_backup_accesses)
        pulumi.set(__self__, "managed_service_ipv4_cidrs", managed_service_ipv4_cidrs)
        pulumi.set(__self__, "resource_gateway_arn", resource_gateway_arn)
        pulumi.set(__self__, "s3_accesses", s3_accesses)
        pulumi.set(__self__, "service_network_arn", service_network_arn)
        pulumi.set(__self__, "service_network_endpoints", service_network_endpoints)
        pulumi.set(__self__, "zero_etl_accesses", zero_etl_accesses)

    @_builtins.property
    @pulumi.getter(name="managedS3BackupAccesses")
    def managed_s3_backup_accesses(self) -> Sequence['outputs.NetworkManagedServiceManagedS3BackupAccess']:
        return pulumi.get(self, "managed_s3_backup_accesses")

    @_builtins.property
    @pulumi.getter(name="managedServiceIpv4Cidrs")
    def managed_service_ipv4_cidrs(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "managed_service_ipv4_cidrs")

    @_builtins.property
    @pulumi.getter(name="resourceGatewayArn")
    def resource_gateway_arn(self) -> _builtins.str:
        return pulumi.get(self, "resource_gateway_arn")

    @_builtins.property
    @pulumi.getter(name="s3Accesses")
    def s3_accesses(self) -> Sequence['outputs.NetworkManagedServiceS3Access']:
        """
        Specifies the configuration for Amazon S3 access from the ODB network.
        """
        return pulumi.get(self, "s3_accesses")

    @_builtins.property
    @pulumi.getter(name="serviceNetworkArn")
    def service_network_arn(self) -> _builtins.str:
        return pulumi.get(self, "service_network_arn")

    @_builtins.property
    @pulumi.getter(name="serviceNetworkEndpoints")
    def service_network_endpoints(self) -> Sequence['outputs.NetworkManagedServiceServiceNetworkEndpoint']:
        return pulumi.get(self, "service_network_endpoints")

    @_builtins.property
    @pulumi.getter(name="zeroEtlAccesses")
    def zero_etl_accesses(self) -> Sequence['outputs.NetworkManagedServiceZeroEtlAccess']:
        """
        Specifies the configuration for Zero-ETL access from the ODB network.

        The following arguments are optional:
        """
        return pulumi.get(self, "zero_etl_accesses")


@pulumi.output_type
class NetworkManagedServiceManagedS3BackupAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipv4Addresses":
            suggest = "ipv4_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkManagedServiceManagedS3BackupAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkManagedServiceManagedS3BackupAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkManagedServiceManagedS3BackupAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipv4_addresses: Sequence[_builtins.str],
                 status: _builtins.str):
        """
        :param _builtins.str status: The status of the network resource.
        """
        pulumi.set(__self__, "ipv4_addresses", ipv4_addresses)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="ipv4Addresses")
    def ipv4_addresses(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ipv4_addresses")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the network resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class NetworkManagedServiceS3Access(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "ipv4Addresses":
            suggest = "ipv4_addresses"
        elif key == "s3PolicyDocument":
            suggest = "s3_policy_document"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkManagedServiceS3Access. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkManagedServiceS3Access.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkManagedServiceS3Access.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: _builtins.str,
                 ipv4_addresses: Sequence[_builtins.str],
                 s3_policy_document: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str s3_policy_document: Specifies the endpoint policy for Amazon S3 access from the ODB network.
        :param _builtins.str status: The status of the network resource.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "ipv4_addresses", ipv4_addresses)
        pulumi.set(__self__, "s3_policy_document", s3_policy_document)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="ipv4Addresses")
    def ipv4_addresses(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ipv4_addresses")

    @_builtins.property
    @pulumi.getter(name="s3PolicyDocument")
    def s3_policy_document(self) -> _builtins.str:
        """
        Specifies the endpoint policy for Amazon S3 access from the ODB network.
        """
        return pulumi.get(self, "s3_policy_document")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the network resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class NetworkManagedServiceServiceNetworkEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcEndpointId":
            suggest = "vpc_endpoint_id"
        elif key == "vpcEndpointType":
            suggest = "vpc_endpoint_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkManagedServiceServiceNetworkEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkManagedServiceServiceNetworkEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkManagedServiceServiceNetworkEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_endpoint_id: _builtins.str,
                 vpc_endpoint_type: _builtins.str):
        pulumi.set(__self__, "vpc_endpoint_id", vpc_endpoint_id)
        pulumi.set(__self__, "vpc_endpoint_type", vpc_endpoint_type)

    @_builtins.property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> _builtins.str:
        return pulumi.get(self, "vpc_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="vpcEndpointType")
    def vpc_endpoint_type(self) -> _builtins.str:
        return pulumi.get(self, "vpc_endpoint_type")


@pulumi.output_type
class NetworkManagedServiceZeroEtlAccess(dict):
    def __init__(__self__, *,
                 cidr: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str status: The status of the network resource.
        """
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> _builtins.str:
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the network resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class NetworkOciDnsForwardingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "ociDnsListenerIp":
            suggest = "oci_dns_listener_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkOciDnsForwardingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkOciDnsForwardingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkOciDnsForwardingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: _builtins.str,
                 oci_dns_listener_ip: _builtins.str):
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "oci_dns_listener_ip", oci_dns_listener_ip)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="ociDnsListenerIp")
    def oci_dns_listener_ip(self) -> _builtins.str:
        return pulumi.get(self, "oci_dns_listener_ip")


@pulumi.output_type
class NetworkPeeringConnectionTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None,
                 update: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param _builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class NetworkTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None,
                 update: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param _builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class GetCloudAutonomousVmClusterMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 days_of_weeks: Sequence['outputs.GetCloudAutonomousVmClusterMaintenanceWindowDaysOfWeekResult'],
                 hours_of_days: Sequence[_builtins.int],
                 lead_time_in_weeks: _builtins.int,
                 months: Sequence['outputs.GetCloudAutonomousVmClusterMaintenanceWindowMonthResult'],
                 preference: _builtins.str,
                 weeks_of_months: Sequence[_builtins.int]):
        pulumi.set(__self__, "days_of_weeks", days_of_weeks)
        pulumi.set(__self__, "hours_of_days", hours_of_days)
        pulumi.set(__self__, "lead_time_in_weeks", lead_time_in_weeks)
        pulumi.set(__self__, "months", months)
        pulumi.set(__self__, "preference", preference)
        pulumi.set(__self__, "weeks_of_months", weeks_of_months)

    @_builtins.property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Sequence['outputs.GetCloudAutonomousVmClusterMaintenanceWindowDaysOfWeekResult']:
        return pulumi.get(self, "days_of_weeks")

    @_builtins.property
    @pulumi.getter(name="hoursOfDays")
    def hours_of_days(self) -> Sequence[_builtins.int]:
        return pulumi.get(self, "hours_of_days")

    @_builtins.property
    @pulumi.getter(name="leadTimeInWeeks")
    def lead_time_in_weeks(self) -> _builtins.int:
        return pulumi.get(self, "lead_time_in_weeks")

    @_builtins.property
    @pulumi.getter
    def months(self) -> Sequence['outputs.GetCloudAutonomousVmClusterMaintenanceWindowMonthResult']:
        return pulumi.get(self, "months")

    @_builtins.property
    @pulumi.getter
    def preference(self) -> _builtins.str:
        return pulumi.get(self, "preference")

    @_builtins.property
    @pulumi.getter(name="weeksOfMonths")
    def weeks_of_months(self) -> Sequence[_builtins.int]:
        return pulumi.get(self, "weeks_of_months")


@pulumi.output_type
class GetCloudAutonomousVmClusterMaintenanceWindowDaysOfWeekResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetCloudAutonomousVmClusterMaintenanceWindowMonthResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetCloudAutonomousVmClustersCloudAutonomousVmClusterResult(dict):
    def __init__(__self__, *,
                 arn: _builtins.str,
                 cloud_exadata_infrastructure_id: _builtins.str,
                 display_name: _builtins.str,
                 id: _builtins.str,
                 oci_resource_anchor_name: _builtins.str,
                 oci_url: _builtins.str,
                 ocid: _builtins.str,
                 odb_network_id: _builtins.str):
        """
        :param _builtins.str arn: The Amazon Resource Name (ARN) for the Exadata infrastructure.
        :param _builtins.str cloud_exadata_infrastructure_id: Cloud exadata infrastructure id associated with this cloud autonomous VM cluster.
        :param _builtins.str display_name: The display name of the Autonomous VM cluster.
        :param _builtins.str id: The unique identifier of the cloud autonomous vm cluster.
        :param _builtins.str oci_resource_anchor_name: The name of the OCI resource anchor associated with this Autonomous VM cluster.
        :param _builtins.str oci_url: The URL for accessing the OCI console page for this Autonomous VM cluster.
        :param _builtins.str ocid: The Oracle Cloud Identifier (OCID) of the Autonomous VM cluster.
        :param _builtins.str odb_network_id: The unique identifier of the ODB network associated with this Autonomous VM cluster.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "cloud_exadata_infrastructure_id", cloud_exadata_infrastructure_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "oci_resource_anchor_name", oci_resource_anchor_name)
        pulumi.set(__self__, "oci_url", oci_url)
        pulumi.set(__self__, "ocid", ocid)
        pulumi.set(__self__, "odb_network_id", odb_network_id)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        The Amazon Resource Name (ARN) for the Exadata infrastructure.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> _builtins.str:
        """
        Cloud exadata infrastructure id associated with this cloud autonomous VM cluster.
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the Autonomous VM cluster.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier of the cloud autonomous vm cluster.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ociResourceAnchorName")
    def oci_resource_anchor_name(self) -> _builtins.str:
        """
        The name of the OCI resource anchor associated with this Autonomous VM cluster.
        """
        return pulumi.get(self, "oci_resource_anchor_name")

    @_builtins.property
    @pulumi.getter(name="ociUrl")
    def oci_url(self) -> _builtins.str:
        """
        The URL for accessing the OCI console page for this Autonomous VM cluster.
        """
        return pulumi.get(self, "oci_url")

    @_builtins.property
    @pulumi.getter
    def ocid(self) -> _builtins.str:
        """
        The Oracle Cloud Identifier (OCID) of the Autonomous VM cluster.
        """
        return pulumi.get(self, "ocid")

    @_builtins.property
    @pulumi.getter(name="odbNetworkId")
    def odb_network_id(self) -> _builtins.str:
        """
        The unique identifier of the ODB network associated with this Autonomous VM cluster.
        """
        return pulumi.get(self, "odb_network_id")


@pulumi.output_type
class GetCloudExadataInfrastructureCustomerContactsToSendToOciResult(dict):
    def __init__(__self__, *,
                 email: _builtins.str):
        pulumi.set(__self__, "email", email)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        return pulumi.get(self, "email")


@pulumi.output_type
class GetCloudExadataInfrastructureMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 custom_action_timeout_in_mins: _builtins.int,
                 days_of_weeks: Sequence['outputs.GetCloudExadataInfrastructureMaintenanceWindowDaysOfWeekResult'],
                 hours_of_days: Sequence[_builtins.int],
                 is_custom_action_timeout_enabled: _builtins.bool,
                 lead_time_in_weeks: _builtins.int,
                 months: Sequence['outputs.GetCloudExadataInfrastructureMaintenanceWindowMonthResult'],
                 patching_mode: _builtins.str,
                 preference: _builtins.str,
                 weeks_of_months: Sequence[_builtins.int]):
        pulumi.set(__self__, "custom_action_timeout_in_mins", custom_action_timeout_in_mins)
        pulumi.set(__self__, "days_of_weeks", days_of_weeks)
        pulumi.set(__self__, "hours_of_days", hours_of_days)
        pulumi.set(__self__, "is_custom_action_timeout_enabled", is_custom_action_timeout_enabled)
        pulumi.set(__self__, "lead_time_in_weeks", lead_time_in_weeks)
        pulumi.set(__self__, "months", months)
        pulumi.set(__self__, "patching_mode", patching_mode)
        pulumi.set(__self__, "preference", preference)
        pulumi.set(__self__, "weeks_of_months", weeks_of_months)

    @_builtins.property
    @pulumi.getter(name="customActionTimeoutInMins")
    def custom_action_timeout_in_mins(self) -> _builtins.int:
        return pulumi.get(self, "custom_action_timeout_in_mins")

    @_builtins.property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Sequence['outputs.GetCloudExadataInfrastructureMaintenanceWindowDaysOfWeekResult']:
        return pulumi.get(self, "days_of_weeks")

    @_builtins.property
    @pulumi.getter(name="hoursOfDays")
    def hours_of_days(self) -> Sequence[_builtins.int]:
        return pulumi.get(self, "hours_of_days")

    @_builtins.property
    @pulumi.getter(name="isCustomActionTimeoutEnabled")
    def is_custom_action_timeout_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "is_custom_action_timeout_enabled")

    @_builtins.property
    @pulumi.getter(name="leadTimeInWeeks")
    def lead_time_in_weeks(self) -> _builtins.int:
        return pulumi.get(self, "lead_time_in_weeks")

    @_builtins.property
    @pulumi.getter
    def months(self) -> Sequence['outputs.GetCloudExadataInfrastructureMaintenanceWindowMonthResult']:
        return pulumi.get(self, "months")

    @_builtins.property
    @pulumi.getter(name="patchingMode")
    def patching_mode(self) -> _builtins.str:
        return pulumi.get(self, "patching_mode")

    @_builtins.property
    @pulumi.getter
    def preference(self) -> _builtins.str:
        return pulumi.get(self, "preference")

    @_builtins.property
    @pulumi.getter(name="weeksOfMonths")
    def weeks_of_months(self) -> Sequence[_builtins.int]:
        return pulumi.get(self, "weeks_of_months")


@pulumi.output_type
class GetCloudExadataInfrastructureMaintenanceWindowDaysOfWeekResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetCloudExadataInfrastructureMaintenanceWindowMonthResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetCloudExadataInfrastructuresCloudExadataInfrastructureResult(dict):
    def __init__(__self__, *,
                 arn: _builtins.str,
                 display_name: _builtins.str,
                 id: _builtins.str,
                 oci_resource_anchor_name: _builtins.str,
                 oci_url: _builtins.str,
                 ocid: _builtins.str):
        """
        :param _builtins.str arn: The Amazon Resource Name (ARN) for the Exadata infrastructure.
        :param _builtins.str display_name: The display name of the Exadata infrastructure.
        :param _builtins.str id: The unique identifier of the Exadata infrastructure.
        :param _builtins.str oci_resource_anchor_name: The name of the OCI resource anchor for the Exadata infrastructure.
        :param _builtins.str oci_url: The HTTPS link to the Exadata infrastructure in OCI.
        :param _builtins.str ocid: The OCID of the Exadata infrastructure in OCI.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "oci_resource_anchor_name", oci_resource_anchor_name)
        pulumi.set(__self__, "oci_url", oci_url)
        pulumi.set(__self__, "ocid", ocid)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        The Amazon Resource Name (ARN) for the Exadata infrastructure.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the Exadata infrastructure.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier of the Exadata infrastructure.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ociResourceAnchorName")
    def oci_resource_anchor_name(self) -> _builtins.str:
        """
        The name of the OCI resource anchor for the Exadata infrastructure.
        """
        return pulumi.get(self, "oci_resource_anchor_name")

    @_builtins.property
    @pulumi.getter(name="ociUrl")
    def oci_url(self) -> _builtins.str:
        """
        The HTTPS link to the Exadata infrastructure in OCI.
        """
        return pulumi.get(self, "oci_url")

    @_builtins.property
    @pulumi.getter
    def ocid(self) -> _builtins.str:
        """
        The OCID of the Exadata infrastructure in OCI.
        """
        return pulumi.get(self, "ocid")


@pulumi.output_type
class GetCloudVmClusterDataCollectionOptionResult(dict):
    def __init__(__self__, *,
                 is_diagnostics_events_enabled: _builtins.bool,
                 is_health_monitoring_enabled: _builtins.bool,
                 is_incident_logs_enabled: _builtins.bool):
        pulumi.set(__self__, "is_diagnostics_events_enabled", is_diagnostics_events_enabled)
        pulumi.set(__self__, "is_health_monitoring_enabled", is_health_monitoring_enabled)
        pulumi.set(__self__, "is_incident_logs_enabled", is_incident_logs_enabled)

    @_builtins.property
    @pulumi.getter(name="isDiagnosticsEventsEnabled")
    def is_diagnostics_events_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "is_diagnostics_events_enabled")

    @_builtins.property
    @pulumi.getter(name="isHealthMonitoringEnabled")
    def is_health_monitoring_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "is_health_monitoring_enabled")

    @_builtins.property
    @pulumi.getter(name="isIncidentLogsEnabled")
    def is_incident_logs_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "is_incident_logs_enabled")


@pulumi.output_type
class GetCloudVmClusterIormConfigCachResult(dict):
    def __init__(__self__, *,
                 db_plans: Sequence['outputs.GetCloudVmClusterIormConfigCachDbPlanResult'],
                 lifecycle_details: _builtins.str,
                 lifecycle_state: _builtins.str,
                 objective: _builtins.str):
        pulumi.set(__self__, "db_plans", db_plans)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "lifecycle_state", lifecycle_state)
        pulumi.set(__self__, "objective", objective)

    @_builtins.property
    @pulumi.getter(name="dbPlans")
    def db_plans(self) -> Sequence['outputs.GetCloudVmClusterIormConfigCachDbPlanResult']:
        return pulumi.get(self, "db_plans")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> _builtins.str:
        return pulumi.get(self, "lifecycle_state")

    @_builtins.property
    @pulumi.getter
    def objective(self) -> _builtins.str:
        return pulumi.get(self, "objective")


@pulumi.output_type
class GetCloudVmClusterIormConfigCachDbPlanResult(dict):
    def __init__(__self__, *,
                 db_name: _builtins.str,
                 flash_cache_limit: _builtins.str,
                 share: _builtins.int):
        pulumi.set(__self__, "db_name", db_name)
        pulumi.set(__self__, "flash_cache_limit", flash_cache_limit)
        pulumi.set(__self__, "share", share)

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> _builtins.str:
        return pulumi.get(self, "db_name")

    @_builtins.property
    @pulumi.getter(name="flashCacheLimit")
    def flash_cache_limit(self) -> _builtins.str:
        return pulumi.get(self, "flash_cache_limit")

    @_builtins.property
    @pulumi.getter
    def share(self) -> _builtins.int:
        return pulumi.get(self, "share")


@pulumi.output_type
class GetCloudVmClustersCloudVmClusterResult(dict):
    def __init__(__self__, *,
                 arn: _builtins.str,
                 cloud_exadata_infrastructure_id: _builtins.str,
                 display_name: _builtins.str,
                 id: _builtins.str,
                 oci_resource_anchor_name: _builtins.str,
                 oci_url: _builtins.str,
                 ocid: _builtins.str,
                 odb_network_id: _builtins.str):
        """
        :param _builtins.str arn: The Amazon Resource Name (ARN) for the cloud vm cluster.
        :param _builtins.str cloud_exadata_infrastructure_id: The ID of the Cloud Exadata Infrastructure.
        :param _builtins.str display_name: The display name of the VM cluster.
        :param _builtins.str id: The unique identifier of the cloud vm cluster.
        :param _builtins.str oci_resource_anchor_name: The name of the OCI Resource Anchor.
        :param _builtins.str oci_url: The HTTPS link to the VM cluster in OCI.
        :param _builtins.str ocid: The OCID of the VM cluster.
        :param _builtins.str odb_network_id: The ID of the ODB network.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "cloud_exadata_infrastructure_id", cloud_exadata_infrastructure_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "oci_resource_anchor_name", oci_resource_anchor_name)
        pulumi.set(__self__, "oci_url", oci_url)
        pulumi.set(__self__, "ocid", ocid)
        pulumi.set(__self__, "odb_network_id", odb_network_id)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        The Amazon Resource Name (ARN) for the cloud vm cluster.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> _builtins.str:
        """
        The ID of the Cloud Exadata Infrastructure.
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the VM cluster.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier of the cloud vm cluster.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ociResourceAnchorName")
    def oci_resource_anchor_name(self) -> _builtins.str:
        """
        The name of the OCI Resource Anchor.
        """
        return pulumi.get(self, "oci_resource_anchor_name")

    @_builtins.property
    @pulumi.getter(name="ociUrl")
    def oci_url(self) -> _builtins.str:
        """
        The HTTPS link to the VM cluster in OCI.
        """
        return pulumi.get(self, "oci_url")

    @_builtins.property
    @pulumi.getter
    def ocid(self) -> _builtins.str:
        """
        The OCID of the VM cluster.
        """
        return pulumi.get(self, "ocid")

    @_builtins.property
    @pulumi.getter(name="odbNetworkId")
    def odb_network_id(self) -> _builtins.str:
        """
        The ID of the ODB network.
        """
        return pulumi.get(self, "odb_network_id")


@pulumi.output_type
class GetDbNodesDbNodeResult(dict):
    def __init__(__self__, *,
                 additional_details: _builtins.str,
                 arn: _builtins.str,
                 backup_ip_id: _builtins.str,
                 backup_vnic2_id: _builtins.str,
                 backup_vnic_id: _builtins.str,
                 cpu_core_count: _builtins.int,
                 created_at: _builtins.str,
                 db_node_storage_size: _builtins.int,
                 db_server_id: _builtins.str,
                 db_system_id: _builtins.str,
                 fault_domain: _builtins.str,
                 host_ip_id: _builtins.str,
                 hostname: _builtins.str,
                 id: _builtins.str,
                 maintenance_type: _builtins.str,
                 memory_size: _builtins.int,
                 oci_resource_anchor_name: _builtins.str,
                 ocid: _builtins.str,
                 software_storage_size: _builtins.int,
                 status: _builtins.str,
                 status_reason: _builtins.str,
                 time_maintenance_window_end: _builtins.str,
                 time_maintenance_window_start: _builtins.str,
                 total_cpu_core_count: _builtins.int,
                 vnic2_id: _builtins.str,
                 vnic_id: _builtins.str):
        """
        :param _builtins.str additional_details: Additional information about the planned maintenance.
        :param _builtins.str backup_ip_id: The Oracle Cloud ID (OCID) of the backup IP address that's associated with the DB node.
        :param _builtins.str backup_vnic_id: The OCID of the backup VNIC for the DB node.
        :param _builtins.int cpu_core_count: The number of CPU cores enabled on the DB node.
        :param _builtins.str created_at: The date and time when the DB node was created.
        :param _builtins.str db_server_id: The unique identifier of the database server that's associated with the DB node.
        :param _builtins.str db_system_id: The OCID of the DB system.
        :param _builtins.str fault_domain: The name of the fault domain where the DB node is located.
        :param _builtins.str host_ip_id: The OCID of the host IP address that's associated with the DB node.
        :param _builtins.str hostname: The host name for the DB node.
        :param _builtins.str maintenance_type: The type of maintenance the DB node is undergoing.
        :param _builtins.str oci_resource_anchor_name: The name of the OCI resource anchor for the DB node.
        :param _builtins.str ocid: The OCID of the DB node.
        :param _builtins.str status: The current status of the DB node.
        :param _builtins.str status_reason: Additional information about the status of the DB node.
        :param _builtins.str time_maintenance_window_end: The end date and time of the maintenance window.
        :param _builtins.str time_maintenance_window_start: The start date and time of the maintenance window.
        :param _builtins.int total_cpu_core_count: The total number of CPU cores reserved on the DB node.
        :param _builtins.str vnic_id: The OCID of the VNIC.
        """
        pulumi.set(__self__, "additional_details", additional_details)
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "backup_ip_id", backup_ip_id)
        pulumi.set(__self__, "backup_vnic2_id", backup_vnic2_id)
        pulumi.set(__self__, "backup_vnic_id", backup_vnic_id)
        pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "db_node_storage_size", db_node_storage_size)
        pulumi.set(__self__, "db_server_id", db_server_id)
        pulumi.set(__self__, "db_system_id", db_system_id)
        pulumi.set(__self__, "fault_domain", fault_domain)
        pulumi.set(__self__, "host_ip_id", host_ip_id)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "maintenance_type", maintenance_type)
        pulumi.set(__self__, "memory_size", memory_size)
        pulumi.set(__self__, "oci_resource_anchor_name", oci_resource_anchor_name)
        pulumi.set(__self__, "ocid", ocid)
        pulumi.set(__self__, "software_storage_size", software_storage_size)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_reason", status_reason)
        pulumi.set(__self__, "time_maintenance_window_end", time_maintenance_window_end)
        pulumi.set(__self__, "time_maintenance_window_start", time_maintenance_window_start)
        pulumi.set(__self__, "total_cpu_core_count", total_cpu_core_count)
        pulumi.set(__self__, "vnic2_id", vnic2_id)
        pulumi.set(__self__, "vnic_id", vnic_id)

    @_builtins.property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> _builtins.str:
        """
        Additional information about the planned maintenance.
        """
        return pulumi.get(self, "additional_details")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="backupIpId")
    def backup_ip_id(self) -> _builtins.str:
        """
        The Oracle Cloud ID (OCID) of the backup IP address that's associated with the DB node.
        """
        return pulumi.get(self, "backup_ip_id")

    @_builtins.property
    @pulumi.getter(name="backupVnic2Id")
    def backup_vnic2_id(self) -> _builtins.str:
        return pulumi.get(self, "backup_vnic2_id")

    @_builtins.property
    @pulumi.getter(name="backupVnicId")
    def backup_vnic_id(self) -> _builtins.str:
        """
        The OCID of the backup VNIC for the DB node.
        """
        return pulumi.get(self, "backup_vnic_id")

    @_builtins.property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> _builtins.int:
        """
        The number of CPU cores enabled on the DB node.
        """
        return pulumi.get(self, "cpu_core_count")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date and time when the DB node was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="dbNodeStorageSize")
    def db_node_storage_size(self) -> _builtins.int:
        return pulumi.get(self, "db_node_storage_size")

    @_builtins.property
    @pulumi.getter(name="dbServerId")
    def db_server_id(self) -> _builtins.str:
        """
        The unique identifier of the database server that's associated with the DB node.
        """
        return pulumi.get(self, "db_server_id")

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> _builtins.str:
        """
        The OCID of the DB system.
        """
        return pulumi.get(self, "db_system_id")

    @_builtins.property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> _builtins.str:
        """
        The name of the fault domain where the DB node is located.
        """
        return pulumi.get(self, "fault_domain")

    @_builtins.property
    @pulumi.getter(name="hostIpId")
    def host_ip_id(self) -> _builtins.str:
        """
        The OCID of the host IP address that's associated with the DB node.
        """
        return pulumi.get(self, "host_ip_id")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        The host name for the DB node.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maintenanceType")
    def maintenance_type(self) -> _builtins.str:
        """
        The type of maintenance the DB node is undergoing.
        """
        return pulumi.get(self, "maintenance_type")

    @_builtins.property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> _builtins.int:
        return pulumi.get(self, "memory_size")

    @_builtins.property
    @pulumi.getter(name="ociResourceAnchorName")
    def oci_resource_anchor_name(self) -> _builtins.str:
        """
        The name of the OCI resource anchor for the DB node.
        """
        return pulumi.get(self, "oci_resource_anchor_name")

    @_builtins.property
    @pulumi.getter
    def ocid(self) -> _builtins.str:
        """
        The OCID of the DB node.
        """
        return pulumi.get(self, "ocid")

    @_builtins.property
    @pulumi.getter(name="softwareStorageSize")
    def software_storage_size(self) -> _builtins.int:
        return pulumi.get(self, "software_storage_size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The current status of the DB node.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> _builtins.str:
        """
        Additional information about the status of the DB node.
        """
        return pulumi.get(self, "status_reason")

    @_builtins.property
    @pulumi.getter(name="timeMaintenanceWindowEnd")
    def time_maintenance_window_end(self) -> _builtins.str:
        """
        The end date and time of the maintenance window.
        """
        return pulumi.get(self, "time_maintenance_window_end")

    @_builtins.property
    @pulumi.getter(name="timeMaintenanceWindowStart")
    def time_maintenance_window_start(self) -> _builtins.str:
        """
        The start date and time of the maintenance window.
        """
        return pulumi.get(self, "time_maintenance_window_start")

    @_builtins.property
    @pulumi.getter(name="totalCpuCoreCount")
    def total_cpu_core_count(self) -> _builtins.int:
        """
        The total number of CPU cores reserved on the DB node.
        """
        return pulumi.get(self, "total_cpu_core_count")

    @_builtins.property
    @pulumi.getter(name="vnic2Id")
    def vnic2_id(self) -> _builtins.str:
        return pulumi.get(self, "vnic2_id")

    @_builtins.property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> _builtins.str:
        """
        The OCID of the VNIC.
        """
        return pulumi.get(self, "vnic_id")


@pulumi.output_type
class GetDbServerDbServerPatchingDetailResult(dict):
    def __init__(__self__, *,
                 estimated_patch_duration: _builtins.int,
                 patching_status: _builtins.str,
                 time_patching_ended: _builtins.str,
                 time_patching_started: _builtins.str):
        pulumi.set(__self__, "estimated_patch_duration", estimated_patch_duration)
        pulumi.set(__self__, "patching_status", patching_status)
        pulumi.set(__self__, "time_patching_ended", time_patching_ended)
        pulumi.set(__self__, "time_patching_started", time_patching_started)

    @_builtins.property
    @pulumi.getter(name="estimatedPatchDuration")
    def estimated_patch_duration(self) -> _builtins.int:
        return pulumi.get(self, "estimated_patch_duration")

    @_builtins.property
    @pulumi.getter(name="patchingStatus")
    def patching_status(self) -> _builtins.str:
        return pulumi.get(self, "patching_status")

    @_builtins.property
    @pulumi.getter(name="timePatchingEnded")
    def time_patching_ended(self) -> _builtins.str:
        return pulumi.get(self, "time_patching_ended")

    @_builtins.property
    @pulumi.getter(name="timePatchingStarted")
    def time_patching_started(self) -> _builtins.str:
        return pulumi.get(self, "time_patching_started")


@pulumi.output_type
class GetDbServersDbServerResult(dict):
    def __init__(__self__, *,
                 autonomous_virtual_machine_ids: Sequence[_builtins.str],
                 autonomous_vm_cluster_ids: Sequence[_builtins.str],
                 compute_model: _builtins.str,
                 cpu_core_count: _builtins.int,
                 created_at: _builtins.str,
                 db_node_storage_size_in_gbs: _builtins.int,
                 db_server_patching_details: Sequence['outputs.GetDbServersDbServerDbServerPatchingDetailResult'],
                 display_name: _builtins.str,
                 exadata_infrastructure_id: _builtins.str,
                 id: _builtins.str,
                 max_cpu_count: _builtins.int,
                 max_db_node_storage_in_gbs: _builtins.int,
                 max_memory_in_gbs: _builtins.int,
                 memory_size_in_gbs: _builtins.int,
                 oci_resource_anchor_name: _builtins.str,
                 ocid: _builtins.str,
                 shape: _builtins.str,
                 status: _builtins.str,
                 status_reason: _builtins.str,
                 vm_cluster_ids: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] autonomous_virtual_machine_ids: A list of unique identifiers for the Autonomous VMs.
        :param Sequence[_builtins.str] autonomous_vm_cluster_ids: A list of identifiers for the Autonomous VM clusters.
        :param _builtins.str compute_model: The OCI compute model used when you create or clone an instance: **ECPU** or **OCPU**. ECPUs are based on the number of cores elastically allocated from a pool of compute and storage servers, while OCPUs are based on the physical core of a processor with hyper-threading enabled.
        :param _builtins.int cpu_core_count: The number of CPU cores enabled on the database server.
        :param _builtins.str created_at: The date and time when the database server was created.
        :param _builtins.int db_node_storage_size_in_gbs: The amount of local node storage, in gigabytes (GB), that's allocated on the database server.
        :param Sequence['GetDbServersDbServerDbServerPatchingDetailArgs'] db_server_patching_details: The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param _builtins.str display_name: The user-friendly name of the database server. The name doesn't need to be unique.
        :param _builtins.str exadata_infrastructure_id: The ID of the Exadata infrastructure that hosts the database server.
        :param _builtins.int max_cpu_count: The total number of CPU cores available on the database server.
        :param _builtins.int max_db_node_storage_in_gbs: The total amount of local node storage, in gigabytes (GB), that's available on the database server.
        :param _builtins.int max_memory_in_gbs: The total amount of memory, in gigabytes (GB), that's available on the database server.
        :param _builtins.int memory_size_in_gbs: The amount of memory, in gigabytes (GB), that's allocated on the database server.
        :param _builtins.str oci_resource_anchor_name: The name of the OCI resource anchor for the database server.
        :param _builtins.str ocid: The OCID of the database server.
        :param _builtins.str shape: The hardware system model of the Exadata infrastructure that the database server is hosted on. The shape determines the amount of CPU, storage, and memory resources available.
        :param _builtins.str status: The current status of the database server.
        :param _builtins.str status_reason: Additional information about the status of the database server.
        :param Sequence[_builtins.str] vm_cluster_ids: The IDs of the VM clusters that are associated with the database server.
        """
        pulumi.set(__self__, "autonomous_virtual_machine_ids", autonomous_virtual_machine_ids)
        pulumi.set(__self__, "autonomous_vm_cluster_ids", autonomous_vm_cluster_ids)
        pulumi.set(__self__, "compute_model", compute_model)
        pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        pulumi.set(__self__, "db_server_patching_details", db_server_patching_details)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "max_cpu_count", max_cpu_count)
        pulumi.set(__self__, "max_db_node_storage_in_gbs", max_db_node_storage_in_gbs)
        pulumi.set(__self__, "max_memory_in_gbs", max_memory_in_gbs)
        pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        pulumi.set(__self__, "oci_resource_anchor_name", oci_resource_anchor_name)
        pulumi.set(__self__, "ocid", ocid)
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_reason", status_reason)
        pulumi.set(__self__, "vm_cluster_ids", vm_cluster_ids)

    @_builtins.property
    @pulumi.getter(name="autonomousVirtualMachineIds")
    def autonomous_virtual_machine_ids(self) -> Sequence[_builtins.str]:
        """
        A list of unique identifiers for the Autonomous VMs.
        """
        return pulumi.get(self, "autonomous_virtual_machine_ids")

    @_builtins.property
    @pulumi.getter(name="autonomousVmClusterIds")
    def autonomous_vm_cluster_ids(self) -> Sequence[_builtins.str]:
        """
        A list of identifiers for the Autonomous VM clusters.
        """
        return pulumi.get(self, "autonomous_vm_cluster_ids")

    @_builtins.property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> _builtins.str:
        """
        The OCI compute model used when you create or clone an instance: **ECPU** or **OCPU**. ECPUs are based on the number of cores elastically allocated from a pool of compute and storage servers, while OCPUs are based on the physical core of a processor with hyper-threading enabled.
        """
        return pulumi.get(self, "compute_model")

    @_builtins.property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> _builtins.int:
        """
        The number of CPU cores enabled on the database server.
        """
        return pulumi.get(self, "cpu_core_count")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date and time when the database server was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> _builtins.int:
        """
        The amount of local node storage, in gigabytes (GB), that's allocated on the database server.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="dbServerPatchingDetails")
    def db_server_patching_details(self) -> Sequence['outputs.GetDbServersDbServerDbServerPatchingDetailResult']:
        """
        The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "db_server_patching_details")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The user-friendly name of the database server. The name doesn't need to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> _builtins.str:
        """
        The ID of the Exadata infrastructure that hosts the database server.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maxCpuCount")
    def max_cpu_count(self) -> _builtins.int:
        """
        The total number of CPU cores available on the database server.
        """
        return pulumi.get(self, "max_cpu_count")

    @_builtins.property
    @pulumi.getter(name="maxDbNodeStorageInGbs")
    def max_db_node_storage_in_gbs(self) -> _builtins.int:
        """
        The total amount of local node storage, in gigabytes (GB), that's available on the database server.
        """
        return pulumi.get(self, "max_db_node_storage_in_gbs")

    @_builtins.property
    @pulumi.getter(name="maxMemoryInGbs")
    def max_memory_in_gbs(self) -> _builtins.int:
        """
        The total amount of memory, in gigabytes (GB), that's available on the database server.
        """
        return pulumi.get(self, "max_memory_in_gbs")

    @_builtins.property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> _builtins.int:
        """
        The amount of memory, in gigabytes (GB), that's allocated on the database server.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="ociResourceAnchorName")
    def oci_resource_anchor_name(self) -> _builtins.str:
        """
        The name of the OCI resource anchor for the database server.
        """
        return pulumi.get(self, "oci_resource_anchor_name")

    @_builtins.property
    @pulumi.getter
    def ocid(self) -> _builtins.str:
        """
        The OCID of the database server.
        """
        return pulumi.get(self, "ocid")

    @_builtins.property
    @pulumi.getter
    def shape(self) -> _builtins.str:
        """
        The hardware system model of the Exadata infrastructure that the database server is hosted on. The shape determines the amount of CPU, storage, and memory resources available.
        """
        return pulumi.get(self, "shape")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The current status of the database server.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> _builtins.str:
        """
        Additional information about the status of the database server.
        """
        return pulumi.get(self, "status_reason")

    @_builtins.property
    @pulumi.getter(name="vmClusterIds")
    def vm_cluster_ids(self) -> Sequence[_builtins.str]:
        """
        The IDs of the VM clusters that are associated with the database server.
        """
        return pulumi.get(self, "vm_cluster_ids")


@pulumi.output_type
class GetDbServersDbServerDbServerPatchingDetailResult(dict):
    def __init__(__self__, *,
                 estimated_patch_duration: _builtins.int,
                 patching_status: _builtins.str,
                 time_patching_ended: _builtins.str,
                 time_patching_started: _builtins.str):
        pulumi.set(__self__, "estimated_patch_duration", estimated_patch_duration)
        pulumi.set(__self__, "patching_status", patching_status)
        pulumi.set(__self__, "time_patching_ended", time_patching_ended)
        pulumi.set(__self__, "time_patching_started", time_patching_started)

    @_builtins.property
    @pulumi.getter(name="estimatedPatchDuration")
    def estimated_patch_duration(self) -> _builtins.int:
        return pulumi.get(self, "estimated_patch_duration")

    @_builtins.property
    @pulumi.getter(name="patchingStatus")
    def patching_status(self) -> _builtins.str:
        return pulumi.get(self, "patching_status")

    @_builtins.property
    @pulumi.getter(name="timePatchingEnded")
    def time_patching_ended(self) -> _builtins.str:
        return pulumi.get(self, "time_patching_ended")

    @_builtins.property
    @pulumi.getter(name="timePatchingStarted")
    def time_patching_started(self) -> _builtins.str:
        return pulumi.get(self, "time_patching_started")


@pulumi.output_type
class GetDbSystemShapesDbSystemShapeResult(dict):
    def __init__(__self__, *,
                 available_core_count: _builtins.int,
                 available_core_count_per_node: _builtins.int,
                 available_data_storage_in_tbs: _builtins.int,
                 available_data_storage_per_server_in_tbs: _builtins.int,
                 available_db_node_per_node_in_gbs: _builtins.int,
                 available_db_node_storage_in_gbs: _builtins.int,
                 available_memory_in_gbs: _builtins.int,
                 available_memory_per_node_in_gbs: _builtins.int,
                 core_count_increment: _builtins.int,
                 max_storage_count: _builtins.int,
                 maximum_node_count: _builtins.int,
                 min_core_count_per_node: _builtins.int,
                 min_data_storage_in_tbs: _builtins.int,
                 min_db_node_storage_per_node_in_gbs: _builtins.int,
                 min_memory_per_node_in_gbs: _builtins.int,
                 min_storage_count: _builtins.int,
                 minimum_core_count: _builtins.int,
                 minimum_node_count: _builtins.int,
                 name: _builtins.str,
                 runtime_minimum_core_count: _builtins.int,
                 shape_family: _builtins.str,
                 shape_type: _builtins.str):
        """
        :param _builtins.int available_core_count: The maximum number of CPU cores that can be enabled for the shape.
        :param _builtins.int available_core_count_per_node: The maximum number of CPU cores per DB node that can be enabled for the shape.
        :param _builtins.int available_data_storage_in_tbs: The maximum amount of data storage, in terabytes (TB), that can be enabled for the shape.
        :param _builtins.int available_data_storage_per_server_in_tbs: The maximum amount of data storage, in terabytes (TB), that's available per storage server for the shape.
        :param _builtins.int available_db_node_per_node_in_gbs: The maximum amount of DB node storage, in gigabytes (GB), that's available per DB node for the shape.
        :param _builtins.int available_db_node_storage_in_gbs: The maximum amount of DB node storage, in gigabytes (GB), that can be enabled for the shape.
        :param _builtins.int available_memory_in_gbs: The maximum amount of memory, in gigabytes (GB), that can be enabled for the shape.
        :param _builtins.int available_memory_per_node_in_gbs: The maximum amount of memory, in gigabytes (GB), that's available per DB node for the shape.
        :param _builtins.int core_count_increment: The discrete number by which the CPU core count for the shape can be increased or decreased.
        :param _builtins.int max_storage_count: The maximum number of Exadata storage servers available for the shape.
        :param _builtins.int maximum_node_count: The maximum number of compute servers available for the shape.
        :param _builtins.int min_core_count_per_node: The minimum number of CPU cores that can be enabled per node for the shape.
        :param _builtins.int min_data_storage_in_tbs: The minimum amount of data storage, in terabytes (TB), that must be allocated for the shape.
        :param _builtins.int min_db_node_storage_per_node_in_gbs: The minimum amount of DB node storage, in gigabytes (GB), that must be allocated per DB node for the shape.
        :param _builtins.int min_memory_per_node_in_gbs: The minimum amount of memory, in gigabytes (GB), that must be allocated per DB node for the shape.
        :param _builtins.int min_storage_count: The minimum number of Exadata storage servers available for the shape.
        :param _builtins.int minimum_core_count: The minimum number of CPU cores that can be enabled for the shape.
        :param _builtins.int minimum_node_count: The minimum number of compute servers available for the shape.
        :param _builtins.str name: The name of the shape.
        :param _builtins.int runtime_minimum_core_count: The runtime minimum number of CPU cores that can be enabled for the shape.
        :param _builtins.str shape_family: The family of the shape.
        :param _builtins.str shape_type: The shape type, determined by the CPU hardware.
        """
        pulumi.set(__self__, "available_core_count", available_core_count)
        pulumi.set(__self__, "available_core_count_per_node", available_core_count_per_node)
        pulumi.set(__self__, "available_data_storage_in_tbs", available_data_storage_in_tbs)
        pulumi.set(__self__, "available_data_storage_per_server_in_tbs", available_data_storage_per_server_in_tbs)
        pulumi.set(__self__, "available_db_node_per_node_in_gbs", available_db_node_per_node_in_gbs)
        pulumi.set(__self__, "available_db_node_storage_in_gbs", available_db_node_storage_in_gbs)
        pulumi.set(__self__, "available_memory_in_gbs", available_memory_in_gbs)
        pulumi.set(__self__, "available_memory_per_node_in_gbs", available_memory_per_node_in_gbs)
        pulumi.set(__self__, "core_count_increment", core_count_increment)
        pulumi.set(__self__, "max_storage_count", max_storage_count)
        pulumi.set(__self__, "maximum_node_count", maximum_node_count)
        pulumi.set(__self__, "min_core_count_per_node", min_core_count_per_node)
        pulumi.set(__self__, "min_data_storage_in_tbs", min_data_storage_in_tbs)
        pulumi.set(__self__, "min_db_node_storage_per_node_in_gbs", min_db_node_storage_per_node_in_gbs)
        pulumi.set(__self__, "min_memory_per_node_in_gbs", min_memory_per_node_in_gbs)
        pulumi.set(__self__, "min_storage_count", min_storage_count)
        pulumi.set(__self__, "minimum_core_count", minimum_core_count)
        pulumi.set(__self__, "minimum_node_count", minimum_node_count)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "runtime_minimum_core_count", runtime_minimum_core_count)
        pulumi.set(__self__, "shape_family", shape_family)
        pulumi.set(__self__, "shape_type", shape_type)

    @_builtins.property
    @pulumi.getter(name="availableCoreCount")
    def available_core_count(self) -> _builtins.int:
        """
        The maximum number of CPU cores that can be enabled for the shape.
        """
        return pulumi.get(self, "available_core_count")

    @_builtins.property
    @pulumi.getter(name="availableCoreCountPerNode")
    def available_core_count_per_node(self) -> _builtins.int:
        """
        The maximum number of CPU cores per DB node that can be enabled for the shape.
        """
        return pulumi.get(self, "available_core_count_per_node")

    @_builtins.property
    @pulumi.getter(name="availableDataStorageInTbs")
    def available_data_storage_in_tbs(self) -> _builtins.int:
        """
        The maximum amount of data storage, in terabytes (TB), that can be enabled for the shape.
        """
        return pulumi.get(self, "available_data_storage_in_tbs")

    @_builtins.property
    @pulumi.getter(name="availableDataStoragePerServerInTbs")
    def available_data_storage_per_server_in_tbs(self) -> _builtins.int:
        """
        The maximum amount of data storage, in terabytes (TB), that's available per storage server for the shape.
        """
        return pulumi.get(self, "available_data_storage_per_server_in_tbs")

    @_builtins.property
    @pulumi.getter(name="availableDbNodePerNodeInGbs")
    def available_db_node_per_node_in_gbs(self) -> _builtins.int:
        """
        The maximum amount of DB node storage, in gigabytes (GB), that's available per DB node for the shape.
        """
        return pulumi.get(self, "available_db_node_per_node_in_gbs")

    @_builtins.property
    @pulumi.getter(name="availableDbNodeStorageInGbs")
    def available_db_node_storage_in_gbs(self) -> _builtins.int:
        """
        The maximum amount of DB node storage, in gigabytes (GB), that can be enabled for the shape.
        """
        return pulumi.get(self, "available_db_node_storage_in_gbs")

    @_builtins.property
    @pulumi.getter(name="availableMemoryInGbs")
    def available_memory_in_gbs(self) -> _builtins.int:
        """
        The maximum amount of memory, in gigabytes (GB), that can be enabled for the shape.
        """
        return pulumi.get(self, "available_memory_in_gbs")

    @_builtins.property
    @pulumi.getter(name="availableMemoryPerNodeInGbs")
    def available_memory_per_node_in_gbs(self) -> _builtins.int:
        """
        The maximum amount of memory, in gigabytes (GB), that's available per DB node for the shape.
        """
        return pulumi.get(self, "available_memory_per_node_in_gbs")

    @_builtins.property
    @pulumi.getter(name="coreCountIncrement")
    def core_count_increment(self) -> _builtins.int:
        """
        The discrete number by which the CPU core count for the shape can be increased or decreased.
        """
        return pulumi.get(self, "core_count_increment")

    @_builtins.property
    @pulumi.getter(name="maxStorageCount")
    def max_storage_count(self) -> _builtins.int:
        """
        The maximum number of Exadata storage servers available for the shape.
        """
        return pulumi.get(self, "max_storage_count")

    @_builtins.property
    @pulumi.getter(name="maximumNodeCount")
    def maximum_node_count(self) -> _builtins.int:
        """
        The maximum number of compute servers available for the shape.
        """
        return pulumi.get(self, "maximum_node_count")

    @_builtins.property
    @pulumi.getter(name="minCoreCountPerNode")
    def min_core_count_per_node(self) -> _builtins.int:
        """
        The minimum number of CPU cores that can be enabled per node for the shape.
        """
        return pulumi.get(self, "min_core_count_per_node")

    @_builtins.property
    @pulumi.getter(name="minDataStorageInTbs")
    def min_data_storage_in_tbs(self) -> _builtins.int:
        """
        The minimum amount of data storage, in terabytes (TB), that must be allocated for the shape.
        """
        return pulumi.get(self, "min_data_storage_in_tbs")

    @_builtins.property
    @pulumi.getter(name="minDbNodeStoragePerNodeInGbs")
    def min_db_node_storage_per_node_in_gbs(self) -> _builtins.int:
        """
        The minimum amount of DB node storage, in gigabytes (GB), that must be allocated per DB node for the shape.
        """
        return pulumi.get(self, "min_db_node_storage_per_node_in_gbs")

    @_builtins.property
    @pulumi.getter(name="minMemoryPerNodeInGbs")
    def min_memory_per_node_in_gbs(self) -> _builtins.int:
        """
        The minimum amount of memory, in gigabytes (GB), that must be allocated per DB node for the shape.
        """
        return pulumi.get(self, "min_memory_per_node_in_gbs")

    @_builtins.property
    @pulumi.getter(name="minStorageCount")
    def min_storage_count(self) -> _builtins.int:
        """
        The minimum number of Exadata storage servers available for the shape.
        """
        return pulumi.get(self, "min_storage_count")

    @_builtins.property
    @pulumi.getter(name="minimumCoreCount")
    def minimum_core_count(self) -> _builtins.int:
        """
        The minimum number of CPU cores that can be enabled for the shape.
        """
        return pulumi.get(self, "minimum_core_count")

    @_builtins.property
    @pulumi.getter(name="minimumNodeCount")
    def minimum_node_count(self) -> _builtins.int:
        """
        The minimum number of compute servers available for the shape.
        """
        return pulumi.get(self, "minimum_node_count")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the shape.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="runtimeMinimumCoreCount")
    def runtime_minimum_core_count(self) -> _builtins.int:
        """
        The runtime minimum number of CPU cores that can be enabled for the shape.
        """
        return pulumi.get(self, "runtime_minimum_core_count")

    @_builtins.property
    @pulumi.getter(name="shapeFamily")
    def shape_family(self) -> _builtins.str:
        """
        The family of the shape.
        """
        return pulumi.get(self, "shape_family")

    @_builtins.property
    @pulumi.getter(name="shapeType")
    def shape_type(self) -> _builtins.str:
        """
        The shape type, determined by the CPU hardware.
        """
        return pulumi.get(self, "shape_type")


@pulumi.output_type
class GetGiVersionsGiVersionResult(dict):
    def __init__(__self__, *,
                 version: _builtins.str):
        """
        :param _builtins.str version: The GI software version.
        """
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The GI software version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetNetworkManagedServiceResult(dict):
    def __init__(__self__, *,
                 managed_s3_backup_accesses: Sequence['outputs.GetNetworkManagedServiceManagedS3BackupAccessResult'],
                 managed_service_ipv4_cidrs: Sequence[_builtins.str],
                 resource_gateway_arn: _builtins.str,
                 s3_accesses: Sequence['outputs.GetNetworkManagedServiceS3AccessResult'],
                 service_network_arn: _builtins.str,
                 service_network_endpoints: Sequence['outputs.GetNetworkManagedServiceServiceNetworkEndpointResult'],
                 zero_tl_accesses: Sequence['outputs.GetNetworkManagedServiceZeroTlAccessResult']):
        pulumi.set(__self__, "managed_s3_backup_accesses", managed_s3_backup_accesses)
        pulumi.set(__self__, "managed_service_ipv4_cidrs", managed_service_ipv4_cidrs)
        pulumi.set(__self__, "resource_gateway_arn", resource_gateway_arn)
        pulumi.set(__self__, "s3_accesses", s3_accesses)
        pulumi.set(__self__, "service_network_arn", service_network_arn)
        pulumi.set(__self__, "service_network_endpoints", service_network_endpoints)
        pulumi.set(__self__, "zero_tl_accesses", zero_tl_accesses)

    @_builtins.property
    @pulumi.getter(name="managedS3BackupAccesses")
    def managed_s3_backup_accesses(self) -> Sequence['outputs.GetNetworkManagedServiceManagedS3BackupAccessResult']:
        return pulumi.get(self, "managed_s3_backup_accesses")

    @_builtins.property
    @pulumi.getter(name="managedServiceIpv4Cidrs")
    def managed_service_ipv4_cidrs(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "managed_service_ipv4_cidrs")

    @_builtins.property
    @pulumi.getter(name="resourceGatewayArn")
    def resource_gateway_arn(self) -> _builtins.str:
        return pulumi.get(self, "resource_gateway_arn")

    @_builtins.property
    @pulumi.getter(name="s3Accesses")
    def s3_accesses(self) -> Sequence['outputs.GetNetworkManagedServiceS3AccessResult']:
        return pulumi.get(self, "s3_accesses")

    @_builtins.property
    @pulumi.getter(name="serviceNetworkArn")
    def service_network_arn(self) -> _builtins.str:
        return pulumi.get(self, "service_network_arn")

    @_builtins.property
    @pulumi.getter(name="serviceNetworkEndpoints")
    def service_network_endpoints(self) -> Sequence['outputs.GetNetworkManagedServiceServiceNetworkEndpointResult']:
        return pulumi.get(self, "service_network_endpoints")

    @_builtins.property
    @pulumi.getter(name="zeroTlAccesses")
    def zero_tl_accesses(self) -> Sequence['outputs.GetNetworkManagedServiceZeroTlAccessResult']:
        return pulumi.get(self, "zero_tl_accesses")


@pulumi.output_type
class GetNetworkManagedServiceManagedS3BackupAccessResult(dict):
    def __init__(__self__, *,
                 ipv4_addresses: Sequence[_builtins.str],
                 status: _builtins.str):
        """
        :param _builtins.str status: The status of the network resource.
        """
        pulumi.set(__self__, "ipv4_addresses", ipv4_addresses)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="ipv4Addresses")
    def ipv4_addresses(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ipv4_addresses")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the network resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetNetworkManagedServiceS3AccessResult(dict):
    def __init__(__self__, *,
                 domain_name: _builtins.str,
                 ipv4_addresses: Sequence[_builtins.str],
                 s3_policy_document: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str status: The status of the network resource.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "ipv4_addresses", ipv4_addresses)
        pulumi.set(__self__, "s3_policy_document", s3_policy_document)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="ipv4Addresses")
    def ipv4_addresses(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ipv4_addresses")

    @_builtins.property
    @pulumi.getter(name="s3PolicyDocument")
    def s3_policy_document(self) -> _builtins.str:
        return pulumi.get(self, "s3_policy_document")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the network resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetNetworkManagedServiceServiceNetworkEndpointResult(dict):
    def __init__(__self__, *,
                 vpc_endpoint_id: _builtins.str,
                 vpc_endpoint_type: _builtins.str):
        pulumi.set(__self__, "vpc_endpoint_id", vpc_endpoint_id)
        pulumi.set(__self__, "vpc_endpoint_type", vpc_endpoint_type)

    @_builtins.property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> _builtins.str:
        return pulumi.get(self, "vpc_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="vpcEndpointType")
    def vpc_endpoint_type(self) -> _builtins.str:
        return pulumi.get(self, "vpc_endpoint_type")


@pulumi.output_type
class GetNetworkManagedServiceZeroTlAccessResult(dict):
    def __init__(__self__, *,
                 cidr: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str status: The status of the network resource.
        """
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> _builtins.str:
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the network resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetNetworkOciDnsForwardingConfigResult(dict):
    def __init__(__self__, *,
                 domain_name: _builtins.str,
                 oci_dns_listener_ip: _builtins.str):
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "oci_dns_listener_ip", oci_dns_listener_ip)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="ociDnsListenerIp")
    def oci_dns_listener_ip(self) -> _builtins.str:
        return pulumi.get(self, "oci_dns_listener_ip")


@pulumi.output_type
class GetNetworkPeeringConnectionsOdbPeeringConnectionResult(dict):
    def __init__(__self__, *,
                 arn: _builtins.str,
                 display_name: _builtins.str,
                 id: _builtins.str,
                 odb_network_arn: _builtins.str,
                 peer_network_arn: _builtins.str):
        """
        :param _builtins.str arn: The Amazon Resource Name (ARN) for the  ODB network peering connection.
        :param _builtins.str display_name: Display name of the ODB network peering connection.
        :param _builtins.str id: The unique identifier of the  ODB network peering connection.
        :param _builtins.str odb_network_arn: ARN of the ODB network peering connection.
        :param _builtins.str peer_network_arn: ARN of the peer network peering connection.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "odb_network_arn", odb_network_arn)
        pulumi.set(__self__, "peer_network_arn", peer_network_arn)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        The Amazon Resource Name (ARN) for the  ODB network peering connection.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Display name of the ODB network peering connection.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier of the  ODB network peering connection.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="odbNetworkArn")
    def odb_network_arn(self) -> _builtins.str:
        """
        ARN of the ODB network peering connection.
        """
        return pulumi.get(self, "odb_network_arn")

    @_builtins.property
    @pulumi.getter(name="peerNetworkArn")
    def peer_network_arn(self) -> _builtins.str:
        """
        ARN of the peer network peering connection.
        """
        return pulumi.get(self, "peer_network_arn")


@pulumi.output_type
class GetNetworksOdbNetworkResult(dict):
    def __init__(__self__, *,
                 arn: _builtins.str,
                 display_name: _builtins.str,
                 id: _builtins.str,
                 oci_network_anchor_id: _builtins.str,
                 oci_vcn_id: _builtins.str,
                 oci_vcn_url: _builtins.str):
        """
        :param _builtins.str arn: Amazon Resource Name (ARN) of the odb network resource.
        :param _builtins.str display_name: Display name for the network resource.
        :param _builtins.str id: Unique identifier of the odb network resource.
        :param _builtins.str oci_network_anchor_id: The unique identifier of the OCI network anchor for the ODB network.
        :param _builtins.str oci_vcn_id: The unique identifier  Oracle Cloud ID (OCID) of the OCI VCN for the ODB network.
        :param _builtins.str oci_vcn_url: The URL of the OCI VCN for the ODB network.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "oci_network_anchor_id", oci_network_anchor_id)
        pulumi.set(__self__, "oci_vcn_id", oci_vcn_id)
        pulumi.set(__self__, "oci_vcn_url", oci_vcn_url)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        Amazon Resource Name (ARN) of the odb network resource.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Display name for the network resource.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique identifier of the odb network resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ociNetworkAnchorId")
    def oci_network_anchor_id(self) -> _builtins.str:
        """
        The unique identifier of the OCI network anchor for the ODB network.
        """
        return pulumi.get(self, "oci_network_anchor_id")

    @_builtins.property
    @pulumi.getter(name="ociVcnId")
    def oci_vcn_id(self) -> _builtins.str:
        """
        The unique identifier  Oracle Cloud ID (OCID) of the OCI VCN for the ODB network.
        """
        return pulumi.get(self, "oci_vcn_id")

    @_builtins.property
    @pulumi.getter(name="ociVcnUrl")
    def oci_vcn_url(self) -> _builtins.str:
        """
        The URL of the OCI VCN for the ODB network.
        """
        return pulumi.get(self, "oci_vcn_url")


