# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DomainPolicyArgs', 'DomainPolicy']

@pulumi.input_type
class DomainPolicyArgs:
    def __init__(__self__, *,
                 access_policies: pulumi.Input[_builtins.str],
                 domain_name: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DomainPolicy resource.
        :param pulumi.Input[_builtins.str] access_policies: IAM policy document specifying the access policies for the domain
        :param pulumi.Input[_builtins.str] domain_name: Name of the domain.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "access_policies", access_policies)
        pulumi.set(__self__, "domain_name", domain_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="accessPolicies")
    def access_policies(self) -> pulumi.Input[_builtins.str]:
        """
        IAM policy document specifying the access policies for the domain
        """
        return pulumi.get(self, "access_policies")

    @access_policies.setter
    def access_policies(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_policies", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the domain.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DomainPolicyState:
    def __init__(__self__, *,
                 access_policies: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DomainPolicy resources.
        :param pulumi.Input[_builtins.str] access_policies: IAM policy document specifying the access policies for the domain
        :param pulumi.Input[_builtins.str] domain_name: Name of the domain.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if access_policies is not None:
            pulumi.set(__self__, "access_policies", access_policies)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="accessPolicies")
    def access_policies(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IAM policy document specifying the access policies for the domain
        """
        return pulumi.get(self, "access_policies")

    @access_policies.setter
    def access_policies(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_policies", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the domain.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:opensearch/domainPolicy:DomainPolicy")
class DomainPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policies: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Allows setting policy to an OpenSearch domain while referencing domain attributes (e.g., ARN).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.opensearch.Domain("example",
            domain_name="tf-test",
            engine_version="OpenSearch_1.1")
        main = aws.iam.get_policy_document_output(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "*",
                "identifiers": ["*"],
            }],
            "actions": ["es:*"],
            "resources": [example.arn.apply(lambda arn: f"{arn}/*")],
            "conditions": [{
                "test": "IpAddress",
                "variable": "aws:SourceIp",
                "values": ["127.0.0.1/32"],
            }],
        }])
        main_domain_policy = aws.opensearch.DomainPolicy("main",
            domain_name=example.domain_name,
            access_policies=main.json)
        ```

        ## Import

        Using `pulumi import`, import OpenSearch Domain Policy using `domain_name` prefixed with `esd-policy-`. For example:

        ```sh
        $ pulumi import aws:opensearch/domainPolicy:DomainPolicy example esd-policy-tf-test
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_policies: IAM policy document specifying the access policies for the domain
        :param pulumi.Input[_builtins.str] domain_name: Name of the domain.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows setting policy to an OpenSearch domain while referencing domain attributes (e.g., ARN).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.opensearch.Domain("example",
            domain_name="tf-test",
            engine_version="OpenSearch_1.1")
        main = aws.iam.get_policy_document_output(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "*",
                "identifiers": ["*"],
            }],
            "actions": ["es:*"],
            "resources": [example.arn.apply(lambda arn: f"{arn}/*")],
            "conditions": [{
                "test": "IpAddress",
                "variable": "aws:SourceIp",
                "values": ["127.0.0.1/32"],
            }],
        }])
        main_domain_policy = aws.opensearch.DomainPolicy("main",
            domain_name=example.domain_name,
            access_policies=main.json)
        ```

        ## Import

        Using `pulumi import`, import OpenSearch Domain Policy using `domain_name` prefixed with `esd-policy-`. For example:

        ```sh
        $ pulumi import aws:opensearch/domainPolicy:DomainPolicy example esd-policy-tf-test
        ```

        :param str resource_name: The name of the resource.
        :param DomainPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policies: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainPolicyArgs.__new__(DomainPolicyArgs)

            if access_policies is None and not opts.urn:
                raise TypeError("Missing required property 'access_policies'")
            __props__.__dict__["access_policies"] = access_policies
            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["region"] = region
        super(DomainPolicy, __self__).__init__(
            'aws:opensearch/domainPolicy:DomainPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_policies: Optional[pulumi.Input[_builtins.str]] = None,
            domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'DomainPolicy':
        """
        Get an existing DomainPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_policies: IAM policy document specifying the access policies for the domain
        :param pulumi.Input[_builtins.str] domain_name: Name of the domain.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainPolicyState.__new__(_DomainPolicyState)

        __props__.__dict__["access_policies"] = access_policies
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["region"] = region
        return DomainPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessPolicies")
    def access_policies(self) -> pulumi.Output[_builtins.str]:
        """
        IAM policy document specifying the access policies for the domain
        """
        return pulumi.get(self, "access_policies")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the domain.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

