# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetServerlessCollectionResult',
    'AwaitableGetServerlessCollectionResult',
    'get_serverless_collection',
    'get_serverless_collection_output',
]

@pulumi.output_type
class GetServerlessCollectionResult:
    """
    A collection of values returned by getServerlessCollection.
    """
    def __init__(__self__, arn=None, collection_endpoint=None, created_date=None, dashboard_endpoint=None, description=None, failure_code=None, failure_message=None, id=None, kms_key_arn=None, last_modified_date=None, name=None, region=None, standby_replicas=None, tags=None, type=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if collection_endpoint and not isinstance(collection_endpoint, str):
            raise TypeError("Expected argument 'collection_endpoint' to be a str")
        pulumi.set(__self__, "collection_endpoint", collection_endpoint)
        if created_date and not isinstance(created_date, str):
            raise TypeError("Expected argument 'created_date' to be a str")
        pulumi.set(__self__, "created_date", created_date)
        if dashboard_endpoint and not isinstance(dashboard_endpoint, str):
            raise TypeError("Expected argument 'dashboard_endpoint' to be a str")
        pulumi.set(__self__, "dashboard_endpoint", dashboard_endpoint)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if failure_code and not isinstance(failure_code, str):
            raise TypeError("Expected argument 'failure_code' to be a str")
        pulumi.set(__self__, "failure_code", failure_code)
        if failure_message and not isinstance(failure_message, str):
            raise TypeError("Expected argument 'failure_message' to be a str")
        pulumi.set(__self__, "failure_message", failure_message)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kms_key_arn and not isinstance(kms_key_arn, str):
            raise TypeError("Expected argument 'kms_key_arn' to be a str")
        pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if last_modified_date and not isinstance(last_modified_date, str):
            raise TypeError("Expected argument 'last_modified_date' to be a str")
        pulumi.set(__self__, "last_modified_date", last_modified_date)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if standby_replicas and not isinstance(standby_replicas, str):
            raise TypeError("Expected argument 'standby_replicas' to be a str")
        pulumi.set(__self__, "standby_replicas", standby_replicas)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        Amazon Resource Name (ARN) of the collection.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="collectionEndpoint")
    def collection_endpoint(self) -> _builtins.str:
        """
        Collection-specific endpoint used to submit index, search, and data upload requests to an OpenSearch Serverless collection.
        """
        return pulumi.get(self, "collection_endpoint")

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> _builtins.str:
        """
        Date the Collection was created.
        """
        return pulumi.get(self, "created_date")

    @_builtins.property
    @pulumi.getter(name="dashboardEndpoint")
    def dashboard_endpoint(self) -> _builtins.str:
        """
        Collection-specific endpoint used to access OpenSearch Dashboards.
        """
        return pulumi.get(self, "dashboard_endpoint")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the collection.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="failureCode")
    def failure_code(self) -> _builtins.str:
        """
        A failure code associated with the collection.
        """
        return pulumi.get(self, "failure_code")

    @_builtins.property
    @pulumi.getter(name="failureMessage")
    def failure_message(self) -> _builtins.str:
        return pulumi.get(self, "failure_message")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> _builtins.str:
        """
        The ARN of the Amazon Web Services KMS key used to encrypt the collection.
        """
        return pulumi.get(self, "kms_key_arn")

    @_builtins.property
    @pulumi.getter(name="lastModifiedDate")
    def last_modified_date(self) -> _builtins.str:
        """
        Date the Collection was last modified.
        """
        return pulumi.get(self, "last_modified_date")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="standbyReplicas")
    def standby_replicas(self) -> _builtins.str:
        """
        Indicates whether standby replicas should be used for a collection.
        """
        return pulumi.get(self, "standby_replicas")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A map of tags to assign to the collection.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of collection.
        """
        return pulumi.get(self, "type")


class AwaitableGetServerlessCollectionResult(GetServerlessCollectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerlessCollectionResult(
            arn=self.arn,
            collection_endpoint=self.collection_endpoint,
            created_date=self.created_date,
            dashboard_endpoint=self.dashboard_endpoint,
            description=self.description,
            failure_code=self.failure_code,
            failure_message=self.failure_message,
            id=self.id,
            kms_key_arn=self.kms_key_arn,
            last_modified_date=self.last_modified_date,
            name=self.name,
            region=self.region,
            standby_replicas=self.standby_replicas,
            tags=self.tags,
            type=self.type)


def get_serverless_collection(id: Optional[_builtins.str] = None,
                              name: Optional[_builtins.str] = None,
                              region: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerlessCollectionResult:
    """
    Data source for managing an AWS OpenSearch Serverless Collection.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.opensearch.get_serverless_collection(name="example")
    ```


    :param _builtins.str id: ID of the collection.
    :param _builtins.str name: Name of the collection.
           
           > Exactly one of `id` or `name` is required.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:opensearch/getServerlessCollection:getServerlessCollection', __args__, opts=opts, typ=GetServerlessCollectionResult).value

    return AwaitableGetServerlessCollectionResult(
        arn=pulumi.get(__ret__, 'arn'),
        collection_endpoint=pulumi.get(__ret__, 'collection_endpoint'),
        created_date=pulumi.get(__ret__, 'created_date'),
        dashboard_endpoint=pulumi.get(__ret__, 'dashboard_endpoint'),
        description=pulumi.get(__ret__, 'description'),
        failure_code=pulumi.get(__ret__, 'failure_code'),
        failure_message=pulumi.get(__ret__, 'failure_message'),
        id=pulumi.get(__ret__, 'id'),
        kms_key_arn=pulumi.get(__ret__, 'kms_key_arn'),
        last_modified_date=pulumi.get(__ret__, 'last_modified_date'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        standby_replicas=pulumi.get(__ret__, 'standby_replicas'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'))
def get_serverless_collection_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServerlessCollectionResult]:
    """
    Data source for managing an AWS OpenSearch Serverless Collection.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.opensearch.get_serverless_collection(name="example")
    ```


    :param _builtins.str id: ID of the collection.
    :param _builtins.str name: Name of the collection.
           
           > Exactly one of `id` or `name` is required.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:opensearch/getServerlessCollection:getServerlessCollection', __args__, opts=opts, typ=GetServerlessCollectionResult)
    return __ret__.apply(lambda __response__: GetServerlessCollectionResult(
        arn=pulumi.get(__response__, 'arn'),
        collection_endpoint=pulumi.get(__response__, 'collection_endpoint'),
        created_date=pulumi.get(__response__, 'created_date'),
        dashboard_endpoint=pulumi.get(__response__, 'dashboard_endpoint'),
        description=pulumi.get(__response__, 'description'),
        failure_code=pulumi.get(__response__, 'failure_code'),
        failure_message=pulumi.get(__response__, 'failure_message'),
        id=pulumi.get(__response__, 'id'),
        kms_key_arn=pulumi.get(__response__, 'kms_key_arn'),
        last_modified_date=pulumi.get(__response__, 'last_modified_date'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        standby_replicas=pulumi.get(__response__, 'standby_replicas'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type')))
