# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['Smsvoicev2ConfigurationSetArgs', 'Smsvoicev2ConfigurationSet']

@pulumi.input_type
class Smsvoicev2ConfigurationSetArgs:
    def __init__(__self__, *,
                 default_message_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_sender_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Smsvoicev2ConfigurationSet resource.
        :param pulumi.Input[_builtins.str] default_message_type: The default message type. Must either be "TRANSACTIONAL" or "PROMOTIONAL"
        :param pulumi.Input[_builtins.str] default_sender_id: The default sender ID to use for this configuration set.
        :param pulumi.Input[_builtins.str] name: The name of the configuration set.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if default_message_type is not None:
            pulumi.set(__self__, "default_message_type", default_message_type)
        if default_sender_id is not None:
            pulumi.set(__self__, "default_sender_id", default_sender_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="defaultMessageType")
    def default_message_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default message type. Must either be "TRANSACTIONAL" or "PROMOTIONAL"
        """
        return pulumi.get(self, "default_message_type")

    @default_message_type.setter
    def default_message_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_message_type", value)

    @_builtins.property
    @pulumi.getter(name="defaultSenderId")
    def default_sender_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default sender ID to use for this configuration set.
        """
        return pulumi.get(self, "default_sender_id")

    @default_sender_id.setter
    def default_sender_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_sender_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the configuration set.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _Smsvoicev2ConfigurationSetState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 default_message_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_sender_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Smsvoicev2ConfigurationSet resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the configuration set.
        :param pulumi.Input[_builtins.str] default_message_type: The default message type. Must either be "TRANSACTIONAL" or "PROMOTIONAL"
        :param pulumi.Input[_builtins.str] default_sender_id: The default sender ID to use for this configuration set.
        :param pulumi.Input[_builtins.str] name: The name of the configuration set.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if default_message_type is not None:
            pulumi.set(__self__, "default_message_type", default_message_type)
        if default_sender_id is not None:
            pulumi.set(__self__, "default_sender_id", default_sender_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the configuration set.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="defaultMessageType")
    def default_message_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default message type. Must either be "TRANSACTIONAL" or "PROMOTIONAL"
        """
        return pulumi.get(self, "default_message_type")

    @default_message_type.setter
    def default_message_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_message_type", value)

    @_builtins.property
    @pulumi.getter(name="defaultSenderId")
    def default_sender_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default sender ID to use for this configuration set.
        """
        return pulumi.get(self, "default_sender_id")

    @default_sender_id.setter
    def default_sender_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_sender_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the configuration set.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:pinpoint/smsvoicev2ConfigurationSet:Smsvoicev2ConfigurationSet")
class Smsvoicev2ConfigurationSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_message_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_sender_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an AWS End User Messaging SMS Configuration Set.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.pinpoint.Smsvoicev2ConfigurationSet("example",
            name="example-configuration-set",
            default_sender_id="example",
            default_message_type="TRANSACTIONAL")
        ```

        ## Import

        Using `pulumi import`, import configuration sets using the `name`. For example:

        ```sh
        $ pulumi import aws:pinpoint/smsvoicev2ConfigurationSet:Smsvoicev2ConfigurationSet example example-configuration-set
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] default_message_type: The default message type. Must either be "TRANSACTIONAL" or "PROMOTIONAL"
        :param pulumi.Input[_builtins.str] default_sender_id: The default sender ID to use for this configuration set.
        :param pulumi.Input[_builtins.str] name: The name of the configuration set.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[Smsvoicev2ConfigurationSetArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS End User Messaging SMS Configuration Set.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.pinpoint.Smsvoicev2ConfigurationSet("example",
            name="example-configuration-set",
            default_sender_id="example",
            default_message_type="TRANSACTIONAL")
        ```

        ## Import

        Using `pulumi import`, import configuration sets using the `name`. For example:

        ```sh
        $ pulumi import aws:pinpoint/smsvoicev2ConfigurationSet:Smsvoicev2ConfigurationSet example example-configuration-set
        ```

        :param str resource_name: The name of the resource.
        :param Smsvoicev2ConfigurationSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(Smsvoicev2ConfigurationSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_message_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_sender_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = Smsvoicev2ConfigurationSetArgs.__new__(Smsvoicev2ConfigurationSetArgs)

            __props__.__dict__["default_message_type"] = default_message_type
            __props__.__dict__["default_sender_id"] = default_sender_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(Smsvoicev2ConfigurationSet, __self__).__init__(
            'aws:pinpoint/smsvoicev2ConfigurationSet:Smsvoicev2ConfigurationSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            default_message_type: Optional[pulumi.Input[_builtins.str]] = None,
            default_sender_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Smsvoicev2ConfigurationSet':
        """
        Get an existing Smsvoicev2ConfigurationSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the configuration set.
        :param pulumi.Input[_builtins.str] default_message_type: The default message type. Must either be "TRANSACTIONAL" or "PROMOTIONAL"
        :param pulumi.Input[_builtins.str] default_sender_id: The default sender ID to use for this configuration set.
        :param pulumi.Input[_builtins.str] name: The name of the configuration set.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _Smsvoicev2ConfigurationSetState.__new__(_Smsvoicev2ConfigurationSetState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["default_message_type"] = default_message_type
        __props__.__dict__["default_sender_id"] = default_sender_id
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return Smsvoicev2ConfigurationSet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the configuration set.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="defaultMessageType")
    def default_message_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The default message type. Must either be "TRANSACTIONAL" or "PROMOTIONAL"
        """
        return pulumi.get(self, "default_message_type")

    @_builtins.property
    @pulumi.getter(name="defaultSenderId")
    def default_sender_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The default sender ID to use for this configuration set.
        """
        return pulumi.get(self, "default_sender_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the configuration set.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

