# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from ._inputs import *

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_account_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 assume_role_with_web_identity: Optional[pulumi.Input['ProviderAssumeRoleWithWebIdentityArgs']] = None,
                 assume_roles: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderAssumeRoleArgs']]]] = None,
                 custom_ca_bundle: Optional[pulumi.Input[_builtins.str]] = None,
                 default_tags: Optional[pulumi.Input['ProviderDefaultTagsArgs']] = None,
                 ec2_metadata_service_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 ec2_metadata_service_endpoint_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderEndpointArgs']]]] = None,
                 forbidden_account_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 http_proxy: Optional[pulumi.Input[_builtins.str]] = None,
                 https_proxy: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_tags: Optional[pulumi.Input['ProviderIgnoreTagsArgs']] = None,
                 insecure: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 no_proxy: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_us_east1_regional_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_use_path_style: Optional[pulumi.Input[_builtins.bool]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_config_files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 shared_credentials_files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 skip_credentials_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_metadata_api_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_region_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_requesting_account_id: Optional[pulumi.Input[_builtins.bool]] = None,
                 sts_region: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 token_bucket_rate_limiter_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 use_dualstack_endpoint: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_fips_endpoint: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[_builtins.str] access_key: The access key for API operations. You can retrieve this
               from the 'Security & Credentials' section of the AWS console.
        :param pulumi.Input[_builtins.str] custom_ca_bundle: File containing custom root and intermediate certificates. Can also be configured using the `AWS_CA_BUNDLE` environment variable. (Setting `ca_bundle` in the shared config file is not supported.)
        :param pulumi.Input['ProviderDefaultTagsArgs'] default_tags: Configuration block with settings to default resource tags across all resources.
        :param pulumi.Input[_builtins.str] ec2_metadata_service_endpoint: Address of the EC2 metadata service endpoint to use. Can also be configured using the `AWS_EC2_METADATA_SERVICE_ENDPOINT` environment variable.
        :param pulumi.Input[_builtins.str] ec2_metadata_service_endpoint_mode: Protocol to use with EC2 metadata service endpoint.Valid values are `IPv4` and `IPv6`. Can also be configured using the `AWS_EC2_METADATA_SERVICE_ENDPOINT_MODE` environment variable.
        :param pulumi.Input[_builtins.str] http_proxy: URL of a proxy to use for HTTP requests when accessing the AWS API. Can also be set using the `HTTP_PROXY` or `http_proxy` environment variables.
        :param pulumi.Input[_builtins.str] https_proxy: URL of a proxy to use for HTTPS requests when accessing the AWS API. Can also be set using the `HTTPS_PROXY` or `https_proxy` environment variables.
        :param pulumi.Input['ProviderIgnoreTagsArgs'] ignore_tags: Configuration block with settings to ignore resource tags across all resources.
        :param pulumi.Input[_builtins.bool] insecure: Explicitly allow the provider to perform "insecure" SSL requests. If omitted, default value is `false`
        :param pulumi.Input[_builtins.int] max_retries: The maximum number of times an AWS API request is
               being executed. If the API request still fails, an error is
               thrown.
        :param pulumi.Input[_builtins.str] no_proxy: Comma-separated list of hosts that should not use HTTP or HTTPS proxies. Can also be set using the `NO_PROXY` or `no_proxy` environment variables.
        :param pulumi.Input[_builtins.str] profile: The profile for API operations. If not set, the default profile
               created with `aws configure` will be used.
        :param pulumi.Input[_builtins.str] region: The region where AWS operations will take place. Examples
               are us-east-1, us-west-2, etc.
        :param pulumi.Input[_builtins.str] retry_mode: Specifies how retries are attempted. Valid values are `standard` and `adaptive`. Can also be configured using the `AWS_RETRY_MODE` environment variable.
        :param pulumi.Input[_builtins.str] s3_us_east1_regional_endpoint: Specifies whether S3 API calls in the `us-east-1` region use the legacy global endpoint or a regional endpoint. Valid values are `legacy` or `regional`. Can also be configured using the `AWS_S3_US_EAST_1_REGIONAL_ENDPOINT` environment variable or the `s3_us_east_1_regional_endpoint` shared config file parameter
        :param pulumi.Input[_builtins.bool] s3_use_path_style: Set this to true to enable the request to use path-style addressing,
               i.e., https://s3.amazonaws.com/BUCKET/KEY. By default, the S3 client will
               use virtual hosted bucket addressing when possible
               (https://BUCKET.s3.amazonaws.com/KEY). Specific to the Amazon S3 service.
        :param pulumi.Input[_builtins.str] secret_key: The secret key for API operations. You can retrieve this
               from the 'Security & Credentials' section of the AWS console.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] shared_config_files: List of paths to shared config files. If not set, defaults to [~/.aws/config].
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] shared_credentials_files: List of paths to shared credentials files. If not set, defaults to [~/.aws/credentials].
        :param pulumi.Input[_builtins.bool] skip_credentials_validation: Skip the credentials validation via STS API. Used for AWS API implementations that do not have STS available/implemented.
        :param pulumi.Input[_builtins.bool] skip_metadata_api_check: Skip the AWS Metadata API check. Used for AWS API implementations that do not have a metadata api endpoint.
        :param pulumi.Input[_builtins.bool] skip_region_validation: Skip static validation of region name. Used by users of alternative AWS-like APIs or users w/ access to regions that are not public (yet).
        :param pulumi.Input[_builtins.bool] skip_requesting_account_id: Skip requesting the account ID. Used for AWS API implementations that do not have IAM/STS API and/or metadata API.
        :param pulumi.Input[_builtins.str] sts_region: The region where AWS STS operations will take place. Examples
               are us-east-1 and us-west-2.
        :param pulumi.Input[_builtins.str] token: session token. A session token is only required if you are
               using temporary security credentials.
        :param pulumi.Input[_builtins.int] token_bucket_rate_limiter_capacity: The capacity of the AWS SDK's token bucket rate limiter.
        :param pulumi.Input[_builtins.bool] use_dualstack_endpoint: Resolve an endpoint with DualStack capability
        :param pulumi.Input[_builtins.bool] use_fips_endpoint: Resolve an endpoint with FIPS capability
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if allowed_account_ids is not None:
            pulumi.set(__self__, "allowed_account_ids", allowed_account_ids)
        if assume_role_with_web_identity is not None:
            pulumi.set(__self__, "assume_role_with_web_identity", assume_role_with_web_identity)
        if assume_roles is not None:
            pulumi.set(__self__, "assume_roles", assume_roles)
        if custom_ca_bundle is not None:
            pulumi.set(__self__, "custom_ca_bundle", custom_ca_bundle)
        if default_tags is not None:
            pulumi.set(__self__, "default_tags", default_tags)
        if ec2_metadata_service_endpoint is not None:
            pulumi.set(__self__, "ec2_metadata_service_endpoint", ec2_metadata_service_endpoint)
        if ec2_metadata_service_endpoint_mode is not None:
            pulumi.set(__self__, "ec2_metadata_service_endpoint_mode", ec2_metadata_service_endpoint_mode)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if forbidden_account_ids is not None:
            pulumi.set(__self__, "forbidden_account_ids", forbidden_account_ids)
        if http_proxy is not None:
            pulumi.set(__self__, "http_proxy", http_proxy)
        if https_proxy is not None:
            pulumi.set(__self__, "https_proxy", https_proxy)
        if ignore_tags is not None:
            pulumi.set(__self__, "ignore_tags", ignore_tags)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if no_proxy is not None:
            pulumi.set(__self__, "no_proxy", no_proxy)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if region is None:
            region = _utilities.get_env('AWS_REGION', 'AWS_DEFAULT_REGION')
        if region is not None:
            pulumi.set(__self__, "region", region)
        if retry_mode is not None:
            pulumi.set(__self__, "retry_mode", retry_mode)
        if s3_us_east1_regional_endpoint is not None:
            pulumi.set(__self__, "s3_us_east1_regional_endpoint", s3_us_east1_regional_endpoint)
        if s3_use_path_style is not None:
            pulumi.set(__self__, "s3_use_path_style", s3_use_path_style)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if shared_config_files is not None:
            pulumi.set(__self__, "shared_config_files", shared_config_files)
        if shared_credentials_files is not None:
            pulumi.set(__self__, "shared_credentials_files", shared_credentials_files)
        if skip_credentials_validation is None:
            skip_credentials_validation = False
        if skip_credentials_validation is not None:
            pulumi.set(__self__, "skip_credentials_validation", skip_credentials_validation)
        if skip_metadata_api_check is not None:
            pulumi.set(__self__, "skip_metadata_api_check", skip_metadata_api_check)
        if skip_region_validation is None:
            skip_region_validation = True
        if skip_region_validation is not None:
            pulumi.set(__self__, "skip_region_validation", skip_region_validation)
        if skip_requesting_account_id is not None:
            pulumi.set(__self__, "skip_requesting_account_id", skip_requesting_account_id)
        if sts_region is not None:
            pulumi.set(__self__, "sts_region", sts_region)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if token_bucket_rate_limiter_capacity is not None:
            pulumi.set(__self__, "token_bucket_rate_limiter_capacity", token_bucket_rate_limiter_capacity)
        if use_dualstack_endpoint is not None:
            pulumi.set(__self__, "use_dualstack_endpoint", use_dualstack_endpoint)
        if use_fips_endpoint is not None:
            pulumi.set(__self__, "use_fips_endpoint", use_fips_endpoint)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access key for API operations. You can retrieve this
        from the 'Security & Credentials' section of the AWS console.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter(name="allowedAccountIds")
    def allowed_account_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "allowed_account_ids")

    @allowed_account_ids.setter
    def allowed_account_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_account_ids", value)

    @_builtins.property
    @pulumi.getter(name="assumeRoleWithWebIdentity")
    def assume_role_with_web_identity(self) -> Optional[pulumi.Input['ProviderAssumeRoleWithWebIdentityArgs']]:
        return pulumi.get(self, "assume_role_with_web_identity")

    @assume_role_with_web_identity.setter
    def assume_role_with_web_identity(self, value: Optional[pulumi.Input['ProviderAssumeRoleWithWebIdentityArgs']]):
        pulumi.set(self, "assume_role_with_web_identity", value)

    @_builtins.property
    @pulumi.getter(name="assumeRoles")
    def assume_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProviderAssumeRoleArgs']]]]:
        return pulumi.get(self, "assume_roles")

    @assume_roles.setter
    def assume_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderAssumeRoleArgs']]]]):
        pulumi.set(self, "assume_roles", value)

    @_builtins.property
    @pulumi.getter(name="customCaBundle")
    def custom_ca_bundle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        File containing custom root and intermediate certificates. Can also be configured using the `AWS_CA_BUNDLE` environment variable. (Setting `ca_bundle` in the shared config file is not supported.)
        """
        return pulumi.get(self, "custom_ca_bundle")

    @custom_ca_bundle.setter
    def custom_ca_bundle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_ca_bundle", value)

    @_builtins.property
    @pulumi.getter(name="defaultTags")
    def default_tags(self) -> Optional[pulumi.Input['ProviderDefaultTagsArgs']]:
        """
        Configuration block with settings to default resource tags across all resources.
        """
        return pulumi.get(self, "default_tags")

    @default_tags.setter
    def default_tags(self, value: Optional[pulumi.Input['ProviderDefaultTagsArgs']]):
        pulumi.set(self, "default_tags", value)

    @_builtins.property
    @pulumi.getter(name="ec2MetadataServiceEndpoint")
    def ec2_metadata_service_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Address of the EC2 metadata service endpoint to use. Can also be configured using the `AWS_EC2_METADATA_SERVICE_ENDPOINT` environment variable.
        """
        return pulumi.get(self, "ec2_metadata_service_endpoint")

    @ec2_metadata_service_endpoint.setter
    def ec2_metadata_service_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ec2_metadata_service_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="ec2MetadataServiceEndpointMode")
    def ec2_metadata_service_endpoint_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Protocol to use with EC2 metadata service endpoint.Valid values are `IPv4` and `IPv6`. Can also be configured using the `AWS_EC2_METADATA_SERVICE_ENDPOINT_MODE` environment variable.
        """
        return pulumi.get(self, "ec2_metadata_service_endpoint_mode")

    @ec2_metadata_service_endpoint_mode.setter
    def ec2_metadata_service_endpoint_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ec2_metadata_service_endpoint_mode", value)

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProviderEndpointArgs']]]]:
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @_builtins.property
    @pulumi.getter(name="forbiddenAccountIds")
    def forbidden_account_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "forbidden_account_ids")

    @forbidden_account_ids.setter
    def forbidden_account_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "forbidden_account_ids", value)

    @_builtins.property
    @pulumi.getter(name="httpProxy")
    def http_proxy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of a proxy to use for HTTP requests when accessing the AWS API. Can also be set using the `HTTP_PROXY` or `http_proxy` environment variables.
        """
        return pulumi.get(self, "http_proxy")

    @http_proxy.setter
    def http_proxy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_proxy", value)

    @_builtins.property
    @pulumi.getter(name="httpsProxy")
    def https_proxy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of a proxy to use for HTTPS requests when accessing the AWS API. Can also be set using the `HTTPS_PROXY` or `https_proxy` environment variables.
        """
        return pulumi.get(self, "https_proxy")

    @https_proxy.setter
    def https_proxy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "https_proxy", value)

    @_builtins.property
    @pulumi.getter(name="ignoreTags")
    def ignore_tags(self) -> Optional[pulumi.Input['ProviderIgnoreTagsArgs']]:
        """
        Configuration block with settings to ignore resource tags across all resources.
        """
        return pulumi.get(self, "ignore_tags")

    @ignore_tags.setter
    def ignore_tags(self, value: Optional[pulumi.Input['ProviderIgnoreTagsArgs']]):
        pulumi.set(self, "ignore_tags", value)

    @_builtins.property
    @pulumi.getter
    def insecure(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Explicitly allow the provider to perform "insecure" SSL requests. If omitted, default value is `false`
        """
        return pulumi.get(self, "insecure")

    @insecure.setter
    def insecure(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "insecure", value)

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of times an AWS API request is
        being executed. If the API request still fails, an error is
        thrown.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_retries", value)

    @_builtins.property
    @pulumi.getter(name="noProxy")
    def no_proxy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Comma-separated list of hosts that should not use HTTP or HTTPS proxies. Can also be set using the `NO_PROXY` or `no_proxy` environment variables.
        """
        return pulumi.get(self, "no_proxy")

    @no_proxy.setter
    def no_proxy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "no_proxy", value)

    @_builtins.property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The profile for API operations. If not set, the default profile
        created with `aws configure` will be used.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where AWS operations will take place. Examples
        are us-east-1, us-west-2, etc.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="retryMode")
    def retry_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies how retries are attempted. Valid values are `standard` and `adaptive`. Can also be configured using the `AWS_RETRY_MODE` environment variable.
        """
        return pulumi.get(self, "retry_mode")

    @retry_mode.setter
    def retry_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retry_mode", value)

    @_builtins.property
    @pulumi.getter(name="s3UsEast1RegionalEndpoint")
    def s3_us_east1_regional_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether S3 API calls in the `us-east-1` region use the legacy global endpoint or a regional endpoint. Valid values are `legacy` or `regional`. Can also be configured using the `AWS_S3_US_EAST_1_REGIONAL_ENDPOINT` environment variable or the `s3_us_east_1_regional_endpoint` shared config file parameter
        """
        return pulumi.get(self, "s3_us_east1_regional_endpoint")

    @s3_us_east1_regional_endpoint.setter
    def s3_us_east1_regional_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "s3_us_east1_regional_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="s3UsePathStyle")
    def s3_use_path_style(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set this to true to enable the request to use path-style addressing,
        i.e., https://s3.amazonaws.com/BUCKET/KEY. By default, the S3 client will
        use virtual hosted bucket addressing when possible
        (https://BUCKET.s3.amazonaws.com/KEY). Specific to the Amazon S3 service.
        """
        return pulumi.get(self, "s3_use_path_style")

    @s3_use_path_style.setter
    def s3_use_path_style(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "s3_use_path_style", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secret key for API operations. You can retrieve this
        from the 'Security & Credentials' section of the AWS console.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter(name="sharedConfigFiles")
    def shared_config_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of paths to shared config files. If not set, defaults to [~/.aws/config].
        """
        return pulumi.get(self, "shared_config_files")

    @shared_config_files.setter
    def shared_config_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "shared_config_files", value)

    @_builtins.property
    @pulumi.getter(name="sharedCredentialsFiles")
    def shared_credentials_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of paths to shared credentials files. If not set, defaults to [~/.aws/credentials].
        """
        return pulumi.get(self, "shared_credentials_files")

    @shared_credentials_files.setter
    def shared_credentials_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "shared_credentials_files", value)

    @_builtins.property
    @pulumi.getter(name="skipCredentialsValidation")
    def skip_credentials_validation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Skip the credentials validation via STS API. Used for AWS API implementations that do not have STS available/implemented.
        """
        return pulumi.get(self, "skip_credentials_validation")

    @skip_credentials_validation.setter
    def skip_credentials_validation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_credentials_validation", value)

    @_builtins.property
    @pulumi.getter(name="skipMetadataApiCheck")
    def skip_metadata_api_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Skip the AWS Metadata API check. Used for AWS API implementations that do not have a metadata api endpoint.
        """
        return pulumi.get(self, "skip_metadata_api_check")

    @skip_metadata_api_check.setter
    def skip_metadata_api_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_metadata_api_check", value)

    @_builtins.property
    @pulumi.getter(name="skipRegionValidation")
    def skip_region_validation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Skip static validation of region name. Used by users of alternative AWS-like APIs or users w/ access to regions that are not public (yet).
        """
        return pulumi.get(self, "skip_region_validation")

    @skip_region_validation.setter
    def skip_region_validation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_region_validation", value)

    @_builtins.property
    @pulumi.getter(name="skipRequestingAccountId")
    def skip_requesting_account_id(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Skip requesting the account ID. Used for AWS API implementations that do not have IAM/STS API and/or metadata API.
        """
        return pulumi.get(self, "skip_requesting_account_id")

    @skip_requesting_account_id.setter
    def skip_requesting_account_id(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_requesting_account_id", value)

    @_builtins.property
    @pulumi.getter(name="stsRegion")
    def sts_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where AWS STS operations will take place. Examples
        are us-east-1 and us-west-2.
        """
        return pulumi.get(self, "sts_region")

    @sts_region.setter
    def sts_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sts_region", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        session token. A session token is only required if you are
        using temporary security credentials.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)

    @_builtins.property
    @pulumi.getter(name="tokenBucketRateLimiterCapacity")
    def token_bucket_rate_limiter_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The capacity of the AWS SDK's token bucket rate limiter.
        """
        return pulumi.get(self, "token_bucket_rate_limiter_capacity")

    @token_bucket_rate_limiter_capacity.setter
    def token_bucket_rate_limiter_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "token_bucket_rate_limiter_capacity", value)

    @_builtins.property
    @pulumi.getter(name="useDualstackEndpoint")
    def use_dualstack_endpoint(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Resolve an endpoint with DualStack capability
        """
        return pulumi.get(self, "use_dualstack_endpoint")

    @use_dualstack_endpoint.setter
    def use_dualstack_endpoint(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_dualstack_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="useFipsEndpoint")
    def use_fips_endpoint(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Resolve an endpoint with FIPS capability
        """
        return pulumi.get(self, "use_fips_endpoint")

    @use_fips_endpoint.setter
    def use_fips_endpoint(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_fips_endpoint", value)


@pulumi.type_token("pulumi:providers:aws")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_account_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 assume_role_with_web_identity: Optional[pulumi.Input[Union['ProviderAssumeRoleWithWebIdentityArgs', 'ProviderAssumeRoleWithWebIdentityArgsDict']]] = None,
                 assume_roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProviderAssumeRoleArgs', 'ProviderAssumeRoleArgsDict']]]]] = None,
                 custom_ca_bundle: Optional[pulumi.Input[_builtins.str]] = None,
                 default_tags: Optional[pulumi.Input[Union['ProviderDefaultTagsArgs', 'ProviderDefaultTagsArgsDict']]] = None,
                 ec2_metadata_service_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 ec2_metadata_service_endpoint_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProviderEndpointArgs', 'ProviderEndpointArgsDict']]]]] = None,
                 forbidden_account_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 http_proxy: Optional[pulumi.Input[_builtins.str]] = None,
                 https_proxy: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_tags: Optional[pulumi.Input[Union['ProviderIgnoreTagsArgs', 'ProviderIgnoreTagsArgsDict']]] = None,
                 insecure: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 no_proxy: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_us_east1_regional_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_use_path_style: Optional[pulumi.Input[_builtins.bool]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_config_files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 shared_credentials_files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 skip_credentials_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_metadata_api_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_region_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_requesting_account_id: Optional[pulumi.Input[_builtins.bool]] = None,
                 sts_region: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 token_bucket_rate_limiter_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 use_dualstack_endpoint: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_fips_endpoint: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        The provider type for the aws package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key: The access key for API operations. You can retrieve this
               from the 'Security & Credentials' section of the AWS console.
        :param pulumi.Input[_builtins.str] custom_ca_bundle: File containing custom root and intermediate certificates. Can also be configured using the `AWS_CA_BUNDLE` environment variable. (Setting `ca_bundle` in the shared config file is not supported.)
        :param pulumi.Input[Union['ProviderDefaultTagsArgs', 'ProviderDefaultTagsArgsDict']] default_tags: Configuration block with settings to default resource tags across all resources.
        :param pulumi.Input[_builtins.str] ec2_metadata_service_endpoint: Address of the EC2 metadata service endpoint to use. Can also be configured using the `AWS_EC2_METADATA_SERVICE_ENDPOINT` environment variable.
        :param pulumi.Input[_builtins.str] ec2_metadata_service_endpoint_mode: Protocol to use with EC2 metadata service endpoint.Valid values are `IPv4` and `IPv6`. Can also be configured using the `AWS_EC2_METADATA_SERVICE_ENDPOINT_MODE` environment variable.
        :param pulumi.Input[_builtins.str] http_proxy: URL of a proxy to use for HTTP requests when accessing the AWS API. Can also be set using the `HTTP_PROXY` or `http_proxy` environment variables.
        :param pulumi.Input[_builtins.str] https_proxy: URL of a proxy to use for HTTPS requests when accessing the AWS API. Can also be set using the `HTTPS_PROXY` or `https_proxy` environment variables.
        :param pulumi.Input[Union['ProviderIgnoreTagsArgs', 'ProviderIgnoreTagsArgsDict']] ignore_tags: Configuration block with settings to ignore resource tags across all resources.
        :param pulumi.Input[_builtins.bool] insecure: Explicitly allow the provider to perform "insecure" SSL requests. If omitted, default value is `false`
        :param pulumi.Input[_builtins.int] max_retries: The maximum number of times an AWS API request is
               being executed. If the API request still fails, an error is
               thrown.
        :param pulumi.Input[_builtins.str] no_proxy: Comma-separated list of hosts that should not use HTTP or HTTPS proxies. Can also be set using the `NO_PROXY` or `no_proxy` environment variables.
        :param pulumi.Input[_builtins.str] profile: The profile for API operations. If not set, the default profile
               created with `aws configure` will be used.
        :param pulumi.Input[_builtins.str] region: The region where AWS operations will take place. Examples
               are us-east-1, us-west-2, etc.
        :param pulumi.Input[_builtins.str] retry_mode: Specifies how retries are attempted. Valid values are `standard` and `adaptive`. Can also be configured using the `AWS_RETRY_MODE` environment variable.
        :param pulumi.Input[_builtins.str] s3_us_east1_regional_endpoint: Specifies whether S3 API calls in the `us-east-1` region use the legacy global endpoint or a regional endpoint. Valid values are `legacy` or `regional`. Can also be configured using the `AWS_S3_US_EAST_1_REGIONAL_ENDPOINT` environment variable or the `s3_us_east_1_regional_endpoint` shared config file parameter
        :param pulumi.Input[_builtins.bool] s3_use_path_style: Set this to true to enable the request to use path-style addressing,
               i.e., https://s3.amazonaws.com/BUCKET/KEY. By default, the S3 client will
               use virtual hosted bucket addressing when possible
               (https://BUCKET.s3.amazonaws.com/KEY). Specific to the Amazon S3 service.
        :param pulumi.Input[_builtins.str] secret_key: The secret key for API operations. You can retrieve this
               from the 'Security & Credentials' section of the AWS console.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] shared_config_files: List of paths to shared config files. If not set, defaults to [~/.aws/config].
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] shared_credentials_files: List of paths to shared credentials files. If not set, defaults to [~/.aws/credentials].
        :param pulumi.Input[_builtins.bool] skip_credentials_validation: Skip the credentials validation via STS API. Used for AWS API implementations that do not have STS available/implemented.
        :param pulumi.Input[_builtins.bool] skip_metadata_api_check: Skip the AWS Metadata API check. Used for AWS API implementations that do not have a metadata api endpoint.
        :param pulumi.Input[_builtins.bool] skip_region_validation: Skip static validation of region name. Used by users of alternative AWS-like APIs or users w/ access to regions that are not public (yet).
        :param pulumi.Input[_builtins.bool] skip_requesting_account_id: Skip requesting the account ID. Used for AWS API implementations that do not have IAM/STS API and/or metadata API.
        :param pulumi.Input[_builtins.str] sts_region: The region where AWS STS operations will take place. Examples
               are us-east-1 and us-west-2.
        :param pulumi.Input[_builtins.str] token: session token. A session token is only required if you are
               using temporary security credentials.
        :param pulumi.Input[_builtins.int] token_bucket_rate_limiter_capacity: The capacity of the AWS SDK's token bucket rate limiter.
        :param pulumi.Input[_builtins.bool] use_dualstack_endpoint: Resolve an endpoint with DualStack capability
        :param pulumi.Input[_builtins.bool] use_fips_endpoint: Resolve an endpoint with FIPS capability
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the aws package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 allowed_account_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 assume_role_with_web_identity: Optional[pulumi.Input[Union['ProviderAssumeRoleWithWebIdentityArgs', 'ProviderAssumeRoleWithWebIdentityArgsDict']]] = None,
                 assume_roles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProviderAssumeRoleArgs', 'ProviderAssumeRoleArgsDict']]]]] = None,
                 custom_ca_bundle: Optional[pulumi.Input[_builtins.str]] = None,
                 default_tags: Optional[pulumi.Input[Union['ProviderDefaultTagsArgs', 'ProviderDefaultTagsArgsDict']]] = None,
                 ec2_metadata_service_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 ec2_metadata_service_endpoint_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProviderEndpointArgs', 'ProviderEndpointArgsDict']]]]] = None,
                 forbidden_account_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 http_proxy: Optional[pulumi.Input[_builtins.str]] = None,
                 https_proxy: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_tags: Optional[pulumi.Input[Union['ProviderIgnoreTagsArgs', 'ProviderIgnoreTagsArgsDict']]] = None,
                 insecure: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 no_proxy: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_us_east1_regional_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_use_path_style: Optional[pulumi.Input[_builtins.bool]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_config_files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 shared_credentials_files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 skip_credentials_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_metadata_api_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_region_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_requesting_account_id: Optional[pulumi.Input[_builtins.bool]] = None,
                 sts_region: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 token_bucket_rate_limiter_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 use_dualstack_endpoint: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_fips_endpoint: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["access_key"] = None if access_key is None else pulumi.Output.secret(access_key)
            __props__.__dict__["allowed_account_ids"] = pulumi.Output.from_input(allowed_account_ids).apply(pulumi.runtime.to_json) if allowed_account_ids is not None else None
            __props__.__dict__["assume_role_with_web_identity"] = pulumi.Output.from_input(assume_role_with_web_identity).apply(pulumi.runtime.to_json) if assume_role_with_web_identity is not None else None
            __props__.__dict__["assume_roles"] = pulumi.Output.from_input(assume_roles).apply(pulumi.runtime.to_json) if assume_roles is not None else None
            __props__.__dict__["custom_ca_bundle"] = custom_ca_bundle
            __props__.__dict__["default_tags"] = pulumi.Output.from_input(default_tags).apply(pulumi.runtime.to_json) if default_tags is not None else None
            __props__.__dict__["ec2_metadata_service_endpoint"] = ec2_metadata_service_endpoint
            __props__.__dict__["ec2_metadata_service_endpoint_mode"] = ec2_metadata_service_endpoint_mode
            __props__.__dict__["endpoints"] = pulumi.Output.from_input(endpoints).apply(pulumi.runtime.to_json) if endpoints is not None else None
            __props__.__dict__["forbidden_account_ids"] = pulumi.Output.from_input(forbidden_account_ids).apply(pulumi.runtime.to_json) if forbidden_account_ids is not None else None
            __props__.__dict__["http_proxy"] = http_proxy
            __props__.__dict__["https_proxy"] = https_proxy
            __props__.__dict__["ignore_tags"] = pulumi.Output.from_input(ignore_tags).apply(pulumi.runtime.to_json) if ignore_tags is not None else None
            __props__.__dict__["insecure"] = pulumi.Output.from_input(insecure).apply(pulumi.runtime.to_json) if insecure is not None else None
            __props__.__dict__["max_retries"] = pulumi.Output.from_input(max_retries).apply(pulumi.runtime.to_json) if max_retries is not None else None
            __props__.__dict__["no_proxy"] = no_proxy
            __props__.__dict__["profile"] = profile
            if region is None:
                region = _utilities.get_env('AWS_REGION', 'AWS_DEFAULT_REGION')
            __props__.__dict__["region"] = region
            __props__.__dict__["retry_mode"] = retry_mode
            __props__.__dict__["s3_us_east1_regional_endpoint"] = s3_us_east1_regional_endpoint
            __props__.__dict__["s3_use_path_style"] = pulumi.Output.from_input(s3_use_path_style).apply(pulumi.runtime.to_json) if s3_use_path_style is not None else None
            __props__.__dict__["secret_key"] = None if secret_key is None else pulumi.Output.secret(secret_key)
            __props__.__dict__["shared_config_files"] = pulumi.Output.from_input(shared_config_files).apply(pulumi.runtime.to_json) if shared_config_files is not None else None
            __props__.__dict__["shared_credentials_files"] = pulumi.Output.from_input(shared_credentials_files).apply(pulumi.runtime.to_json) if shared_credentials_files is not None else None
            if skip_credentials_validation is None:
                skip_credentials_validation = False
            __props__.__dict__["skip_credentials_validation"] = pulumi.Output.from_input(skip_credentials_validation).apply(pulumi.runtime.to_json) if skip_credentials_validation is not None else None
            __props__.__dict__["skip_metadata_api_check"] = pulumi.Output.from_input(skip_metadata_api_check).apply(pulumi.runtime.to_json) if skip_metadata_api_check is not None else None
            if skip_region_validation is None:
                skip_region_validation = True
            __props__.__dict__["skip_region_validation"] = pulumi.Output.from_input(skip_region_validation).apply(pulumi.runtime.to_json) if skip_region_validation is not None else None
            __props__.__dict__["skip_requesting_account_id"] = pulumi.Output.from_input(skip_requesting_account_id).apply(pulumi.runtime.to_json) if skip_requesting_account_id is not None else None
            __props__.__dict__["sts_region"] = sts_region
            __props__.__dict__["token"] = None if token is None else pulumi.Output.secret(token)
            __props__.__dict__["token_bucket_rate_limiter_capacity"] = pulumi.Output.from_input(token_bucket_rate_limiter_capacity).apply(pulumi.runtime.to_json) if token_bucket_rate_limiter_capacity is not None else None
            __props__.__dict__["use_dualstack_endpoint"] = pulumi.Output.from_input(use_dualstack_endpoint).apply(pulumi.runtime.to_json) if use_dualstack_endpoint is not None else None
            __props__.__dict__["use_fips_endpoint"] = pulumi.Output.from_input(use_fips_endpoint).apply(pulumi.runtime.to_json) if use_fips_endpoint is not None else None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accessKey", "secretKey", "token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'aws',
            resource_name,
            __props__,
            opts)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The access key for API operations. You can retrieve this
        from the 'Security & Credentials' section of the AWS console.
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="customCaBundle")
    def custom_ca_bundle(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        File containing custom root and intermediate certificates. Can also be configured using the `AWS_CA_BUNDLE` environment variable. (Setting `ca_bundle` in the shared config file is not supported.)
        """
        return pulumi.get(self, "custom_ca_bundle")

    @_builtins.property
    @pulumi.getter(name="ec2MetadataServiceEndpoint")
    def ec2_metadata_service_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Address of the EC2 metadata service endpoint to use. Can also be configured using the `AWS_EC2_METADATA_SERVICE_ENDPOINT` environment variable.
        """
        return pulumi.get(self, "ec2_metadata_service_endpoint")

    @_builtins.property
    @pulumi.getter(name="ec2MetadataServiceEndpointMode")
    def ec2_metadata_service_endpoint_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Protocol to use with EC2 metadata service endpoint.Valid values are `IPv4` and `IPv6`. Can also be configured using the `AWS_EC2_METADATA_SERVICE_ENDPOINT_MODE` environment variable.
        """
        return pulumi.get(self, "ec2_metadata_service_endpoint_mode")

    @_builtins.property
    @pulumi.getter(name="httpProxy")
    def http_proxy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        URL of a proxy to use for HTTP requests when accessing the AWS API. Can also be set using the `HTTP_PROXY` or `http_proxy` environment variables.
        """
        return pulumi.get(self, "http_proxy")

    @_builtins.property
    @pulumi.getter(name="httpsProxy")
    def https_proxy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        URL of a proxy to use for HTTPS requests when accessing the AWS API. Can also be set using the `HTTPS_PROXY` or `https_proxy` environment variables.
        """
        return pulumi.get(self, "https_proxy")

    @_builtins.property
    @pulumi.getter(name="noProxy")
    def no_proxy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Comma-separated list of hosts that should not use HTTP or HTTPS proxies. Can also be set using the `NO_PROXY` or `no_proxy` environment variables.
        """
        return pulumi.get(self, "no_proxy")

    @_builtins.property
    @pulumi.getter
    def profile(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The profile for API operations. If not set, the default profile
        created with `aws configure` will be used.
        """
        return pulumi.get(self, "profile")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The region where AWS operations will take place. Examples
        are us-east-1, us-west-2, etc.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="retryMode")
    def retry_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies how retries are attempted. Valid values are `standard` and `adaptive`. Can also be configured using the `AWS_RETRY_MODE` environment variable.
        """
        return pulumi.get(self, "retry_mode")

    @_builtins.property
    @pulumi.getter(name="s3UsEast1RegionalEndpoint")
    def s3_us_east1_regional_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether S3 API calls in the `us-east-1` region use the legacy global endpoint or a regional endpoint. Valid values are `legacy` or `regional`. Can also be configured using the `AWS_S3_US_EAST_1_REGIONAL_ENDPOINT` environment variable or the `s3_us_east_1_regional_endpoint` shared config file parameter
        """
        return pulumi.get(self, "s3_us_east1_regional_endpoint")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The secret key for API operations. You can retrieve this
        from the 'Security & Credentials' section of the AWS console.
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter(name="stsRegion")
    def sts_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The region where AWS STS operations will take place. Examples
        are us-east-1 and us-west-2.
        """
        return pulumi.get(self, "sts_region")

    @_builtins.property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        session token. A session token is only required if you are
        using temporary security credentials.
        """
        return pulumi.get(self, "token")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @_builtins.property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:aws/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

