# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetThemeResult',
    'AwaitableGetThemeResult',
    'get_theme',
    'get_theme_output',
]

@pulumi.output_type
class GetThemeResult:
    """
    A collection of values returned by getTheme.
    """
    def __init__(__self__, arn=None, aws_account_id=None, base_theme_id=None, configurations=None, created_time=None, id=None, last_updated_time=None, name=None, permissions=None, region=None, status=None, tags=None, theme_id=None, version_description=None, version_number=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if aws_account_id and not isinstance(aws_account_id, str):
            raise TypeError("Expected argument 'aws_account_id' to be a str")
        pulumi.set(__self__, "aws_account_id", aws_account_id)
        if base_theme_id and not isinstance(base_theme_id, str):
            raise TypeError("Expected argument 'base_theme_id' to be a str")
        pulumi.set(__self__, "base_theme_id", base_theme_id)
        if configurations and not isinstance(configurations, list):
            raise TypeError("Expected argument 'configurations' to be a list")
        pulumi.set(__self__, "configurations", configurations)
        if created_time and not isinstance(created_time, str):
            raise TypeError("Expected argument 'created_time' to be a str")
        pulumi.set(__self__, "created_time", created_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated_time and not isinstance(last_updated_time, str):
            raise TypeError("Expected argument 'last_updated_time' to be a str")
        pulumi.set(__self__, "last_updated_time", last_updated_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if permissions and not isinstance(permissions, list):
            raise TypeError("Expected argument 'permissions' to be a list")
        pulumi.set(__self__, "permissions", permissions)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if theme_id and not isinstance(theme_id, str):
            raise TypeError("Expected argument 'theme_id' to be a str")
        pulumi.set(__self__, "theme_id", theme_id)
        if version_description and not isinstance(version_description, str):
            raise TypeError("Expected argument 'version_description' to be a str")
        pulumi.set(__self__, "version_description", version_description)
        if version_number and not isinstance(version_number, int):
            raise TypeError("Expected argument 'version_number' to be a int")
        pulumi.set(__self__, "version_number", version_number)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the theme.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> _builtins.str:
        return pulumi.get(self, "aws_account_id")

    @_builtins.property
    @pulumi.getter(name="baseThemeId")
    def base_theme_id(self) -> _builtins.str:
        """
        The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting themes defined by Amazon QuickSight.
        """
        return pulumi.get(self, "base_theme_id")

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Sequence['outputs.GetThemeConfigurationResult']:
        """
        The theme configuration, which contains the theme display properties. See configuration.
        """
        return pulumi.get(self, "configurations")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> _builtins.str:
        """
        The time that the theme was created.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> _builtins.str:
        """
        The time that the theme was last updated.
        """
        return pulumi.get(self, "last_updated_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Display name of the theme.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Sequence['outputs.GetThemePermissionResult']:
        """
        A set of resource permissions on the theme. See permissions.
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The theme creation status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="themeId")
    def theme_id(self) -> _builtins.str:
        return pulumi.get(self, "theme_id")

    @_builtins.property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> _builtins.str:
        """
        A description of the current theme version being created/updated.
        """
        return pulumi.get(self, "version_description")

    @_builtins.property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> _builtins.int:
        """
        The version number of the theme version.
        """
        return pulumi.get(self, "version_number")


class AwaitableGetThemeResult(GetThemeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetThemeResult(
            arn=self.arn,
            aws_account_id=self.aws_account_id,
            base_theme_id=self.base_theme_id,
            configurations=self.configurations,
            created_time=self.created_time,
            id=self.id,
            last_updated_time=self.last_updated_time,
            name=self.name,
            permissions=self.permissions,
            region=self.region,
            status=self.status,
            tags=self.tags,
            theme_id=self.theme_id,
            version_description=self.version_description,
            version_number=self.version_number)


def get_theme(aws_account_id: Optional[_builtins.str] = None,
              region: Optional[_builtins.str] = None,
              tags: Optional[Mapping[str, _builtins.str]] = None,
              theme_id: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetThemeResult:
    """
    Data source for managing an AWS QuickSight Theme.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.quicksight.get_theme(theme_id="example")
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
    :param _builtins.str theme_id: Identifier of the theme.
           
           The following arguments are optional:
    """
    __args__ = dict()
    __args__['awsAccountId'] = aws_account_id
    __args__['region'] = region
    __args__['tags'] = tags
    __args__['themeId'] = theme_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:quicksight/getTheme:getTheme', __args__, opts=opts, typ=GetThemeResult).value

    return AwaitableGetThemeResult(
        arn=pulumi.get(__ret__, 'arn'),
        aws_account_id=pulumi.get(__ret__, 'aws_account_id'),
        base_theme_id=pulumi.get(__ret__, 'base_theme_id'),
        configurations=pulumi.get(__ret__, 'configurations'),
        created_time=pulumi.get(__ret__, 'created_time'),
        id=pulumi.get(__ret__, 'id'),
        last_updated_time=pulumi.get(__ret__, 'last_updated_time'),
        name=pulumi.get(__ret__, 'name'),
        permissions=pulumi.get(__ret__, 'permissions'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        theme_id=pulumi.get(__ret__, 'theme_id'),
        version_description=pulumi.get(__ret__, 'version_description'),
        version_number=pulumi.get(__ret__, 'version_number'))
def get_theme_output(aws_account_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                     theme_id: Optional[pulumi.Input[_builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetThemeResult]:
    """
    Data source for managing an AWS QuickSight Theme.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.quicksight.get_theme(theme_id="example")
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
    :param _builtins.str theme_id: Identifier of the theme.
           
           The following arguments are optional:
    """
    __args__ = dict()
    __args__['awsAccountId'] = aws_account_id
    __args__['region'] = region
    __args__['tags'] = tags
    __args__['themeId'] = theme_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:quicksight/getTheme:getTheme', __args__, opts=opts, typ=GetThemeResult)
    return __ret__.apply(lambda __response__: GetThemeResult(
        arn=pulumi.get(__response__, 'arn'),
        aws_account_id=pulumi.get(__response__, 'aws_account_id'),
        base_theme_id=pulumi.get(__response__, 'base_theme_id'),
        configurations=pulumi.get(__response__, 'configurations'),
        created_time=pulumi.get(__response__, 'created_time'),
        id=pulumi.get(__response__, 'id'),
        last_updated_time=pulumi.get(__response__, 'last_updated_time'),
        name=pulumi.get(__response__, 'name'),
        permissions=pulumi.get(__response__, 'permissions'),
        region=pulumi.get(__response__, 'region'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        theme_id=pulumi.get(__response__, 'theme_id'),
        version_description=pulumi.get(__response__, 'version_description'),
        version_number=pulumi.get(__response__, 'version_number')))
