# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IpRestrictionArgs', 'IpRestriction']

@pulumi.input_type
class IpRestrictionArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[_builtins.bool],
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_restriction_rule_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_endpoint_id_restriction_rule_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id_restriction_rule_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a IpRestriction resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether IP rules are turned on.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] ip_restriction_rule_map: Map of allowed IPv4 CIDR ranges and descriptions.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] vpc_endpoint_id_restriction_rule_map: Map of allowed VPC endpoint IDs and descriptions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] vpc_id_restriction_rule_map: Map of VPC IDs and descriptions. Traffic from all VPC endpoints that are present in the specified VPC is allowed.
        """
        pulumi.set(__self__, "enabled", enabled)
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if ip_restriction_rule_map is not None:
            pulumi.set(__self__, "ip_restriction_rule_map", ip_restriction_rule_map)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if vpc_endpoint_id_restriction_rule_map is not None:
            pulumi.set(__self__, "vpc_endpoint_id_restriction_rule_map", vpc_endpoint_id_restriction_rule_map)
        if vpc_id_restriction_rule_map is not None:
            pulumi.set(__self__, "vpc_id_restriction_rule_map", vpc_id_restriction_rule_map)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether IP rules are turned on.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_account_id", value)

    @_builtins.property
    @pulumi.getter(name="ipRestrictionRuleMap")
    def ip_restriction_rule_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of allowed IPv4 CIDR ranges and descriptions.
        """
        return pulumi.get(self, "ip_restriction_rule_map")

    @ip_restriction_rule_map.setter
    def ip_restriction_rule_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_restriction_rule_map", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="vpcEndpointIdRestrictionRuleMap")
    def vpc_endpoint_id_restriction_rule_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of allowed VPC endpoint IDs and descriptions.
        """
        return pulumi.get(self, "vpc_endpoint_id_restriction_rule_map")

    @vpc_endpoint_id_restriction_rule_map.setter
    def vpc_endpoint_id_restriction_rule_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vpc_endpoint_id_restriction_rule_map", value)

    @_builtins.property
    @pulumi.getter(name="vpcIdRestrictionRuleMap")
    def vpc_id_restriction_rule_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of VPC IDs and descriptions. Traffic from all VPC endpoints that are present in the specified VPC is allowed.
        """
        return pulumi.get(self, "vpc_id_restriction_rule_map")

    @vpc_id_restriction_rule_map.setter
    def vpc_id_restriction_rule_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vpc_id_restriction_rule_map", value)


@pulumi.input_type
class _IpRestrictionState:
    def __init__(__self__, *,
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_restriction_rule_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_endpoint_id_restriction_rule_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id_restriction_rule_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering IpRestriction resources.
        :param pulumi.Input[_builtins.bool] enabled: Whether IP rules are turned on.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] ip_restriction_rule_map: Map of allowed IPv4 CIDR ranges and descriptions.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] vpc_endpoint_id_restriction_rule_map: Map of allowed VPC endpoint IDs and descriptions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] vpc_id_restriction_rule_map: Map of VPC IDs and descriptions. Traffic from all VPC endpoints that are present in the specified VPC is allowed.
        """
        if aws_account_id is not None:
            pulumi.set(__self__, "aws_account_id", aws_account_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ip_restriction_rule_map is not None:
            pulumi.set(__self__, "ip_restriction_rule_map", ip_restriction_rule_map)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if vpc_endpoint_id_restriction_rule_map is not None:
            pulumi.set(__self__, "vpc_endpoint_id_restriction_rule_map", vpc_endpoint_id_restriction_rule_map)
        if vpc_id_restriction_rule_map is not None:
            pulumi.set(__self__, "vpc_id_restriction_rule_map", vpc_id_restriction_rule_map)

    @_builtins.property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_account_id", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether IP rules are turned on.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="ipRestrictionRuleMap")
    def ip_restriction_rule_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of allowed IPv4 CIDR ranges and descriptions.
        """
        return pulumi.get(self, "ip_restriction_rule_map")

    @ip_restriction_rule_map.setter
    def ip_restriction_rule_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_restriction_rule_map", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="vpcEndpointIdRestrictionRuleMap")
    def vpc_endpoint_id_restriction_rule_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of allowed VPC endpoint IDs and descriptions.
        """
        return pulumi.get(self, "vpc_endpoint_id_restriction_rule_map")

    @vpc_endpoint_id_restriction_rule_map.setter
    def vpc_endpoint_id_restriction_rule_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vpc_endpoint_id_restriction_rule_map", value)

    @_builtins.property
    @pulumi.getter(name="vpcIdRestrictionRuleMap")
    def vpc_id_restriction_rule_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of VPC IDs and descriptions. Traffic from all VPC endpoints that are present in the specified VPC is allowed.
        """
        return pulumi.get(self, "vpc_id_restriction_rule_map")

    @vpc_id_restriction_rule_map.setter
    def vpc_id_restriction_rule_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vpc_id_restriction_rule_map", value)


@pulumi.type_token("aws:quicksight/ipRestriction:IpRestriction")
class IpRestriction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_restriction_rule_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_endpoint_id_restriction_rule_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id_restriction_rule_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages the content and status of IP rules.

        > Deletion of this resource clears all IP restrictions from a QuickSight account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.IpRestriction("example",
            enabled=True,
            ip_restriction_rule_map={
                "108.56.166.202/32": "Allow self",
            },
            vpc_id_restriction_rule_map={
                example_aws_vpc["id"]: "Main VPC",
            })
        ```

        ## Import

        Using `pulumi import`, import QuickSight IP restriction using the AWS account ID. For example:

        ```sh
        $ pulumi import aws:quicksight/ipRestriction:IpRestriction example "012345678901"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether IP rules are turned on.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] ip_restriction_rule_map: Map of allowed IPv4 CIDR ranges and descriptions.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] vpc_endpoint_id_restriction_rule_map: Map of allowed VPC endpoint IDs and descriptions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] vpc_id_restriction_rule_map: Map of VPC IDs and descriptions. Traffic from all VPC endpoints that are present in the specified VPC is allowed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IpRestrictionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the content and status of IP rules.

        > Deletion of this resource clears all IP restrictions from a QuickSight account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.quicksight.IpRestriction("example",
            enabled=True,
            ip_restriction_rule_map={
                "108.56.166.202/32": "Allow self",
            },
            vpc_id_restriction_rule_map={
                example_aws_vpc["id"]: "Main VPC",
            })
        ```

        ## Import

        Using `pulumi import`, import QuickSight IP restriction using the AWS account ID. For example:

        ```sh
        $ pulumi import aws:quicksight/ipRestriction:IpRestriction example "012345678901"
        ```

        :param str resource_name: The name of the resource.
        :param IpRestrictionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpRestrictionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_restriction_rule_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_endpoint_id_restriction_rule_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id_restriction_rule_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpRestrictionArgs.__new__(IpRestrictionArgs)

            __props__.__dict__["aws_account_id"] = aws_account_id
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["ip_restriction_rule_map"] = ip_restriction_rule_map
            __props__.__dict__["region"] = region
            __props__.__dict__["vpc_endpoint_id_restriction_rule_map"] = vpc_endpoint_id_restriction_rule_map
            __props__.__dict__["vpc_id_restriction_rule_map"] = vpc_id_restriction_rule_map
        super(IpRestriction, __self__).__init__(
            'aws:quicksight/ipRestriction:IpRestriction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            ip_restriction_rule_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_endpoint_id_restriction_rule_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_id_restriction_rule_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'IpRestriction':
        """
        Get an existing IpRestriction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether IP rules are turned on.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] ip_restriction_rule_map: Map of allowed IPv4 CIDR ranges and descriptions.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] vpc_endpoint_id_restriction_rule_map: Map of allowed VPC endpoint IDs and descriptions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] vpc_id_restriction_rule_map: Map of VPC IDs and descriptions. Traffic from all VPC endpoints that are present in the specified VPC is allowed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IpRestrictionState.__new__(_IpRestrictionState)

        __props__.__dict__["aws_account_id"] = aws_account_id
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["ip_restriction_rule_map"] = ip_restriction_rule_map
        __props__.__dict__["region"] = region
        __props__.__dict__["vpc_endpoint_id_restriction_rule_map"] = vpc_endpoint_id_restriction_rule_map
        __props__.__dict__["vpc_id_restriction_rule_map"] = vpc_id_restriction_rule_map
        return IpRestriction(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "aws_account_id")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether IP rules are turned on.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="ipRestrictionRuleMap")
    def ip_restriction_rule_map(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of allowed IPv4 CIDR ranges and descriptions.
        """
        return pulumi.get(self, "ip_restriction_rule_map")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="vpcEndpointIdRestrictionRuleMap")
    def vpc_endpoint_id_restriction_rule_map(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of allowed VPC endpoint IDs and descriptions.
        """
        return pulumi.get(self, "vpc_endpoint_id_restriction_rule_map")

    @_builtins.property
    @pulumi.getter(name="vpcIdRestrictionRuleMap")
    def vpc_id_restriction_rule_map(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of VPC IDs and descriptions. Traffic from all VPC endpoints that are present in the specified VPC is allowed.
        """
        return pulumi.get(self, "vpc_id_restriction_rule_map")

