# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetGlobalClusterResult',
    'AwaitableGetGlobalClusterResult',
    'get_global_cluster',
    'get_global_cluster_output',
]

@pulumi.output_type
class GetGlobalClusterResult:
    """
    A collection of values returned by getGlobalCluster.
    """
    def __init__(__self__, arn=None, database_name=None, deletion_protection=None, endpoint=None, engine=None, engine_lifecycle_support=None, engine_version=None, id=None, identifier=None, members=None, region=None, resource_id=None, storage_encrypted=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if database_name and not isinstance(database_name, str):
            raise TypeError("Expected argument 'database_name' to be a str")
        pulumi.set(__self__, "database_name", database_name)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if engine_lifecycle_support and not isinstance(engine_lifecycle_support, str):
            raise TypeError("Expected argument 'engine_lifecycle_support' to be a str")
        pulumi.set(__self__, "engine_lifecycle_support", engine_lifecycle_support)
        if engine_version and not isinstance(engine_version, str):
            raise TypeError("Expected argument 'engine_version' to be a str")
        pulumi.set(__self__, "engine_version", engine_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if members and not isinstance(members, list):
            raise TypeError("Expected argument 'members' to be a list")
        pulumi.set(__self__, "members", members)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if storage_encrypted and not isinstance(storage_encrypted, bool):
            raise TypeError("Expected argument 'storage_encrypted' to be a bool")
        pulumi.set(__self__, "storage_encrypted", storage_encrypted)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        RDS Global Cluster Amazon Resource Name (ARN)
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> _builtins.str:
        """
        Name of the automatically created database on cluster creation.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> _builtins.bool:
        """
        If the Global Cluster should have deletion protection enabled. The database can't be deleted when this value is set to `true`.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        The endpoint for the Global Cluster.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> _builtins.str:
        """
        Name of the database engine.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineLifecycleSupport")
    def engine_lifecycle_support(self) -> _builtins.str:
        """
        The current lifecycle support status of the database engine for this Global Cluster.
        """
        return pulumi.get(self, "engine_lifecycle_support")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> _builtins.str:
        """
        Version of the database engine for this Global Cluster.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> _builtins.str:
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def members(self) -> Sequence['outputs.GetGlobalClusterMemberResult']:
        """
        Set of objects containing Global Cluster members.
        """
        return pulumi.get(self, "members")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        AWS Region-unique, immutable identifier for the global database cluster.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> _builtins.bool:
        """
        Whether the DB cluster is encrypted.
        """
        return pulumi.get(self, "storage_encrypted")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A map of tags to assigned to the Global Cluster.
        """
        return pulumi.get(self, "tags")


class AwaitableGetGlobalClusterResult(GetGlobalClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGlobalClusterResult(
            arn=self.arn,
            database_name=self.database_name,
            deletion_protection=self.deletion_protection,
            endpoint=self.endpoint,
            engine=self.engine,
            engine_lifecycle_support=self.engine_lifecycle_support,
            engine_version=self.engine_version,
            id=self.id,
            identifier=self.identifier,
            members=self.members,
            region=self.region,
            resource_id=self.resource_id,
            storage_encrypted=self.storage_encrypted,
            tags=self.tags)


def get_global_cluster(identifier: Optional[_builtins.str] = None,
                       region: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGlobalClusterResult:
    """
    Data source for managing an AWS RDS (Relational Database) Global Cluster.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.rds.get_global_cluster(identifier=test["globalClusterIdentifier"])
    ```


    :param _builtins.str identifier: The global cluster identifier of the RDS global cluster.
           
           The following arguments are optional:
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:rds/getGlobalCluster:getGlobalCluster', __args__, opts=opts, typ=GetGlobalClusterResult).value

    return AwaitableGetGlobalClusterResult(
        arn=pulumi.get(__ret__, 'arn'),
        database_name=pulumi.get(__ret__, 'database_name'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        engine=pulumi.get(__ret__, 'engine'),
        engine_lifecycle_support=pulumi.get(__ret__, 'engine_lifecycle_support'),
        engine_version=pulumi.get(__ret__, 'engine_version'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        members=pulumi.get(__ret__, 'members'),
        region=pulumi.get(__ret__, 'region'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        storage_encrypted=pulumi.get(__ret__, 'storage_encrypted'),
        tags=pulumi.get(__ret__, 'tags'))
def get_global_cluster_output(identifier: Optional[pulumi.Input[_builtins.str]] = None,
                              region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGlobalClusterResult]:
    """
    Data source for managing an AWS RDS (Relational Database) Global Cluster.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.rds.get_global_cluster(identifier=test["globalClusterIdentifier"])
    ```


    :param _builtins.str identifier: The global cluster identifier of the RDS global cluster.
           
           The following arguments are optional:
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['identifier'] = identifier
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:rds/getGlobalCluster:getGlobalCluster', __args__, opts=opts, typ=GetGlobalClusterResult)
    return __ret__.apply(lambda __response__: GetGlobalClusterResult(
        arn=pulumi.get(__response__, 'arn'),
        database_name=pulumi.get(__response__, 'database_name'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        endpoint=pulumi.get(__response__, 'endpoint'),
        engine=pulumi.get(__response__, 'engine'),
        engine_lifecycle_support=pulumi.get(__response__, 'engine_lifecycle_support'),
        engine_version=pulumi.get(__response__, 'engine_version'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        members=pulumi.get(__response__, 'members'),
        region=pulumi.get(__response__, 'region'),
        resource_id=pulumi.get(__response__, 'resource_id'),
        storage_encrypted=pulumi.get(__response__, 'storage_encrypted'),
        tags=pulumi.get(__response__, 'tags')))
