# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetProducerDataSharesResult',
    'AwaitableGetProducerDataSharesResult',
    'get_producer_data_shares',
    'get_producer_data_shares_output',
]

@pulumi.output_type
class GetProducerDataSharesResult:
    """
    A collection of values returned by getProducerDataShares.
    """
    def __init__(__self__, data_shares=None, id=None, producer_arn=None, region=None, status=None):
        if data_shares and not isinstance(data_shares, list):
            raise TypeError("Expected argument 'data_shares' to be a list")
        pulumi.set(__self__, "data_shares", data_shares)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if producer_arn and not isinstance(producer_arn, str):
            raise TypeError("Expected argument 'producer_arn' to be a str")
        pulumi.set(__self__, "producer_arn", producer_arn)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="dataShares")
    def data_shares(self) -> Sequence['outputs.GetProducerDataSharesDataShareResult']:
        """
        An array of all data shares in the producer. See `data_shares` below.
        """
        return pulumi.get(self, "data_shares")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Producer ARN.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="producerArn")
    def producer_arn(self) -> _builtins.str:
        """
        ARN (Amazon Resource Name) of the producer.
        """
        return pulumi.get(self, "producer_arn")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "status")


class AwaitableGetProducerDataSharesResult(GetProducerDataSharesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProducerDataSharesResult(
            data_shares=self.data_shares,
            id=self.id,
            producer_arn=self.producer_arn,
            region=self.region,
            status=self.status)


def get_producer_data_shares(producer_arn: Optional[_builtins.str] = None,
                             region: Optional[_builtins.str] = None,
                             status: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProducerDataSharesResult:
    """
    Data source for managing AWS Redshift Producer Data Shares.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.redshift.get_producer_data_shares(producer_arn="")
    ```


    :param _builtins.str producer_arn: Amazon Resource Name (ARN) of the producer namespace that returns in the list of datashares.
           
           The following arguments are optional:
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str status: Status of a datashare in the producer. Valid values are `ACTIVE`, `AUTHORIZED`, `PENDING_AUTHORIZATION`, `DEAUTHORIZED`, and `REJECTED`. Omit this argument to return all statuses.
    """
    __args__ = dict()
    __args__['producerArn'] = producer_arn
    __args__['region'] = region
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:redshift/getProducerDataShares:getProducerDataShares', __args__, opts=opts, typ=GetProducerDataSharesResult).value

    return AwaitableGetProducerDataSharesResult(
        data_shares=pulumi.get(__ret__, 'data_shares'),
        id=pulumi.get(__ret__, 'id'),
        producer_arn=pulumi.get(__ret__, 'producer_arn'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'))
def get_producer_data_shares_output(producer_arn: Optional[pulumi.Input[_builtins.str]] = None,
                                    region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProducerDataSharesResult]:
    """
    Data source for managing AWS Redshift Producer Data Shares.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.redshift.get_producer_data_shares(producer_arn="")
    ```


    :param _builtins.str producer_arn: Amazon Resource Name (ARN) of the producer namespace that returns in the list of datashares.
           
           The following arguments are optional:
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str status: Status of a datashare in the producer. Valid values are `ACTIVE`, `AUTHORIZED`, `PENDING_AUTHORIZATION`, `DEAUTHORIZED`, and `REJECTED`. Omit this argument to return all statuses.
    """
    __args__ = dict()
    __args__['producerArn'] = producer_arn
    __args__['region'] = region
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:redshift/getProducerDataShares:getProducerDataShares', __args__, opts=opts, typ=GetProducerDataSharesResult)
    return __ret__.apply(lambda __response__: GetProducerDataSharesResult(
        data_shares=pulumi.get(__response__, 'data_shares'),
        id=pulumi.get(__response__, 'id'),
        producer_arn=pulumi.get(__response__, 'producer_arn'),
        region=pulumi.get(__response__, 'region'),
        status=pulumi.get(__response__, 'status')))
