# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'CollectionTimeouts',
    'ProjectTimeouts',
    'StreamProcessorDataSharingPreference',
    'StreamProcessorInput',
    'StreamProcessorInputKinesisVideoStream',
    'StreamProcessorNotificationChannel',
    'StreamProcessorOutput',
    'StreamProcessorOutputKinesisDataStream',
    'StreamProcessorOutputS3Destination',
    'StreamProcessorRegionsOfInterest',
    'StreamProcessorRegionsOfInterestBoundingBox',
    'StreamProcessorRegionsOfInterestPolygon',
    'StreamProcessorSettings',
    'StreamProcessorSettingsConnectedHome',
    'StreamProcessorSettingsFaceSearch',
    'StreamProcessorTimeouts',
]

@pulumi.output_type
class CollectionTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")


@pulumi.output_type
class ProjectTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")


@pulumi.output_type
class StreamProcessorDataSharingPreference(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "optIn":
            suggest = "opt_in"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamProcessorDataSharingPreference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamProcessorDataSharingPreference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamProcessorDataSharingPreference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 opt_in: _builtins.bool):
        """
        :param _builtins.bool opt_in: Whether you are sharing data with Rekognition to improve model performance.
        """
        pulumi.set(__self__, "opt_in", opt_in)

    @_builtins.property
    @pulumi.getter(name="optIn")
    def opt_in(self) -> _builtins.bool:
        """
        Whether you are sharing data with Rekognition to improve model performance.
        """
        return pulumi.get(self, "opt_in")


@pulumi.output_type
class StreamProcessorInput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kinesisVideoStream":
            suggest = "kinesis_video_stream"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamProcessorInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamProcessorInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamProcessorInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kinesis_video_stream: Optional['outputs.StreamProcessorInputKinesisVideoStream'] = None):
        """
        :param 'StreamProcessorInputKinesisVideoStreamArgs' kinesis_video_stream: Kinesis input stream. See `kinesis_video_stream`.
        """
        if kinesis_video_stream is not None:
            pulumi.set(__self__, "kinesis_video_stream", kinesis_video_stream)

    @_builtins.property
    @pulumi.getter(name="kinesisVideoStream")
    def kinesis_video_stream(self) -> Optional['outputs.StreamProcessorInputKinesisVideoStream']:
        """
        Kinesis input stream. See `kinesis_video_stream`.
        """
        return pulumi.get(self, "kinesis_video_stream")


@pulumi.output_type
class StreamProcessorInputKinesisVideoStream(dict):
    def __init__(__self__, *,
                 arn: _builtins.str):
        """
        :param _builtins.str arn: ARN of the Kinesis video stream stream that streams the source video.
        """
        pulumi.set(__self__, "arn", arn)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the Kinesis video stream stream that streams the source video.
        """
        return pulumi.get(self, "arn")


@pulumi.output_type
class StreamProcessorNotificationChannel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snsTopicArn":
            suggest = "sns_topic_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamProcessorNotificationChannel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamProcessorNotificationChannel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamProcessorNotificationChannel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sns_topic_arn: Optional[_builtins.str] = None):
        """
        :param _builtins.str sns_topic_arn: The Amazon Resource Number (ARN) of the Amazon Amazon Simple Notification Service topic to which Amazon Rekognition posts the completion status.
        """
        if sns_topic_arn is not None:
            pulumi.set(__self__, "sns_topic_arn", sns_topic_arn)

    @_builtins.property
    @pulumi.getter(name="snsTopicArn")
    def sns_topic_arn(self) -> Optional[_builtins.str]:
        """
        The Amazon Resource Number (ARN) of the Amazon Amazon Simple Notification Service topic to which Amazon Rekognition posts the completion status.
        """
        return pulumi.get(self, "sns_topic_arn")


@pulumi.output_type
class StreamProcessorOutput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kinesisDataStream":
            suggest = "kinesis_data_stream"
        elif key == "s3Destination":
            suggest = "s3_destination"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamProcessorOutput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamProcessorOutput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamProcessorOutput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kinesis_data_stream: Optional['outputs.StreamProcessorOutputKinesisDataStream'] = None,
                 s3_destination: Optional['outputs.StreamProcessorOutputS3Destination'] = None):
        """
        :param 'StreamProcessorOutputKinesisDataStreamArgs' kinesis_data_stream: The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream processor streams the analysis results. See `kinesis_data_stream`.
        :param 'StreamProcessorOutputS3DestinationArgs' s3_destination: The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation. See `s3_destination`.
        """
        if kinesis_data_stream is not None:
            pulumi.set(__self__, "kinesis_data_stream", kinesis_data_stream)
        if s3_destination is not None:
            pulumi.set(__self__, "s3_destination", s3_destination)

    @_builtins.property
    @pulumi.getter(name="kinesisDataStream")
    def kinesis_data_stream(self) -> Optional['outputs.StreamProcessorOutputKinesisDataStream']:
        """
        The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream processor streams the analysis results. See `kinesis_data_stream`.
        """
        return pulumi.get(self, "kinesis_data_stream")

    @_builtins.property
    @pulumi.getter(name="s3Destination")
    def s3_destination(self) -> Optional['outputs.StreamProcessorOutputS3Destination']:
        """
        The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation. See `s3_destination`.
        """
        return pulumi.get(self, "s3_destination")


@pulumi.output_type
class StreamProcessorOutputKinesisDataStream(dict):
    def __init__(__self__, *,
                 arn: Optional[_builtins.str] = None):
        """
        :param _builtins.str arn: ARN of the output Amazon Kinesis Data Streams stream.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[_builtins.str]:
        """
        ARN of the output Amazon Kinesis Data Streams stream.
        """
        return pulumi.get(self, "arn")


@pulumi.output_type
class StreamProcessorOutputS3Destination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyPrefix":
            suggest = "key_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamProcessorOutputS3Destination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamProcessorOutputS3Destination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamProcessorOutputS3Destination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: Optional[_builtins.str] = None,
                 key_prefix: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket: Name of the Amazon S3 bucket you want to associate with the streaming video project.
        :param _builtins.str key_prefix: The prefix value of the location within the bucket that you want the information to be published to.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if key_prefix is not None:
            pulumi.set(__self__, "key_prefix", key_prefix)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[_builtins.str]:
        """
        Name of the Amazon S3 bucket you want to associate with the streaming video project.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="keyPrefix")
    def key_prefix(self) -> Optional[_builtins.str]:
        """
        The prefix value of the location within the bucket that you want the information to be published to.
        """
        return pulumi.get(self, "key_prefix")


@pulumi.output_type
class StreamProcessorRegionsOfInterest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "boundingBox":
            suggest = "bounding_box"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamProcessorRegionsOfInterest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamProcessorRegionsOfInterest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamProcessorRegionsOfInterest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bounding_box: 'outputs.StreamProcessorRegionsOfInterestBoundingBox',
                 polygons: Sequence['outputs.StreamProcessorRegionsOfInterestPolygon']):
        """
        :param 'StreamProcessorRegionsOfInterestBoundingBoxArgs' bounding_box: Box representing a region of interest on screen. Only 1 per region is allowed. See `bounding_box`.
        :param Sequence['StreamProcessorRegionsOfInterestPolygonArgs'] polygons: Shape made up of up to 10 Point objects to define a region of interest. See `polygon`.
        """
        pulumi.set(__self__, "bounding_box", bounding_box)
        pulumi.set(__self__, "polygons", polygons)

    @_builtins.property
    @pulumi.getter(name="boundingBox")
    def bounding_box(self) -> 'outputs.StreamProcessorRegionsOfInterestBoundingBox':
        """
        Box representing a region of interest on screen. Only 1 per region is allowed. See `bounding_box`.
        """
        return pulumi.get(self, "bounding_box")

    @_builtins.property
    @pulumi.getter
    def polygons(self) -> Sequence['outputs.StreamProcessorRegionsOfInterestPolygon']:
        """
        Shape made up of up to 10 Point objects to define a region of interest. See `polygon`.
        """
        return pulumi.get(self, "polygons")


@pulumi.output_type
class StreamProcessorRegionsOfInterestBoundingBox(dict):
    def __init__(__self__, *,
                 height: Optional[_builtins.float] = None,
                 left: Optional[_builtins.float] = None,
                 top: Optional[_builtins.float] = None,
                 width: Optional[_builtins.float] = None):
        """
        :param _builtins.float height: Height of the bounding box as a ratio of the overall image height.
        :param _builtins.float left: Left coordinate of the bounding box as a ratio of overall image width.
        :param _builtins.float top: Top coordinate of the bounding box as a ratio of overall image height.
        :param _builtins.float width: Width of the bounding box as a ratio of the overall image width.
        """
        if height is not None:
            pulumi.set(__self__, "height", height)
        if left is not None:
            pulumi.set(__self__, "left", left)
        if top is not None:
            pulumi.set(__self__, "top", top)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @_builtins.property
    @pulumi.getter
    def height(self) -> Optional[_builtins.float]:
        """
        Height of the bounding box as a ratio of the overall image height.
        """
        return pulumi.get(self, "height")

    @_builtins.property
    @pulumi.getter
    def left(self) -> Optional[_builtins.float]:
        """
        Left coordinate of the bounding box as a ratio of overall image width.
        """
        return pulumi.get(self, "left")

    @_builtins.property
    @pulumi.getter
    def top(self) -> Optional[_builtins.float]:
        """
        Top coordinate of the bounding box as a ratio of overall image height.
        """
        return pulumi.get(self, "top")

    @_builtins.property
    @pulumi.getter
    def width(self) -> Optional[_builtins.float]:
        """
        Width of the bounding box as a ratio of the overall image width.
        """
        return pulumi.get(self, "width")


@pulumi.output_type
class StreamProcessorRegionsOfInterestPolygon(dict):
    def __init__(__self__, *,
                 x: Optional[_builtins.float] = None,
                 y: Optional[_builtins.float] = None):
        """
        :param _builtins.float x: The value of the X coordinate for a point on a Polygon.
        :param _builtins.float y: The value of the Y coordinate for a point on a Polygon.
        """
        if x is not None:
            pulumi.set(__self__, "x", x)
        if y is not None:
            pulumi.set(__self__, "y", y)

    @_builtins.property
    @pulumi.getter
    def x(self) -> Optional[_builtins.float]:
        """
        The value of the X coordinate for a point on a Polygon.
        """
        return pulumi.get(self, "x")

    @_builtins.property
    @pulumi.getter
    def y(self) -> Optional[_builtins.float]:
        """
        The value of the Y coordinate for a point on a Polygon.
        """
        return pulumi.get(self, "y")


@pulumi.output_type
class StreamProcessorSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectedHome":
            suggest = "connected_home"
        elif key == "faceSearch":
            suggest = "face_search"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamProcessorSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamProcessorSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamProcessorSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connected_home: Optional['outputs.StreamProcessorSettingsConnectedHome'] = None,
                 face_search: Optional['outputs.StreamProcessorSettingsFaceSearch'] = None):
        """
        :param 'StreamProcessorSettingsConnectedHomeArgs' connected_home: Label detection settings to use on a streaming video. See `connected_home`.
        :param 'StreamProcessorSettingsFaceSearchArgs' face_search: Input face recognition parameters for an Amazon Rekognition stream processor. See `face_search`.
        """
        if connected_home is not None:
            pulumi.set(__self__, "connected_home", connected_home)
        if face_search is not None:
            pulumi.set(__self__, "face_search", face_search)

    @_builtins.property
    @pulumi.getter(name="connectedHome")
    def connected_home(self) -> Optional['outputs.StreamProcessorSettingsConnectedHome']:
        """
        Label detection settings to use on a streaming video. See `connected_home`.
        """
        return pulumi.get(self, "connected_home")

    @_builtins.property
    @pulumi.getter(name="faceSearch")
    def face_search(self) -> Optional['outputs.StreamProcessorSettingsFaceSearch']:
        """
        Input face recognition parameters for an Amazon Rekognition stream processor. See `face_search`.
        """
        return pulumi.get(self, "face_search")


@pulumi.output_type
class StreamProcessorSettingsConnectedHome(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minConfidence":
            suggest = "min_confidence"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamProcessorSettingsConnectedHome. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamProcessorSettingsConnectedHome.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamProcessorSettingsConnectedHome.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 labels: Optional[Sequence[_builtins.str]] = None,
                 min_confidence: Optional[_builtins.float] = None):
        """
        :param Sequence[_builtins.str] labels: Specifies what you want to detect in the video, such as people, packages, or pets. The current valid labels you can include in this list are: `PERSON`, `PET`, `PACKAGE`, and `ALL`.
        :param _builtins.float min_confidence: Minimum confidence required to label an object in the video.
        """
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if min_confidence is not None:
            pulumi.set(__self__, "min_confidence", min_confidence)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies what you want to detect in the video, such as people, packages, or pets. The current valid labels you can include in this list are: `PERSON`, `PET`, `PACKAGE`, and `ALL`.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="minConfidence")
    def min_confidence(self) -> Optional[_builtins.float]:
        """
        Minimum confidence required to label an object in the video.
        """
        return pulumi.get(self, "min_confidence")


@pulumi.output_type
class StreamProcessorSettingsFaceSearch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "collectionId":
            suggest = "collection_id"
        elif key == "faceMatchThreshold":
            suggest = "face_match_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamProcessorSettingsFaceSearch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamProcessorSettingsFaceSearch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamProcessorSettingsFaceSearch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 collection_id: _builtins.str,
                 face_match_threshold: Optional[_builtins.float] = None):
        """
        :param _builtins.str collection_id: ID of a collection that contains faces that you want to search for.
        :param _builtins.float face_match_threshold: Minimum face match confidence score that must be met to return a result for a recognized face.
        """
        pulumi.set(__self__, "collection_id", collection_id)
        if face_match_threshold is not None:
            pulumi.set(__self__, "face_match_threshold", face_match_threshold)

    @_builtins.property
    @pulumi.getter(name="collectionId")
    def collection_id(self) -> _builtins.str:
        """
        ID of a collection that contains faces that you want to search for.
        """
        return pulumi.get(self, "collection_id")

    @_builtins.property
    @pulumi.getter(name="faceMatchThreshold")
    def face_match_threshold(self) -> Optional[_builtins.float]:
        """
        Minimum face match confidence score that must be met to return a result for a recognized face.
        """
        return pulumi.get(self, "face_match_threshold")


@pulumi.output_type
class StreamProcessorTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None,
                 update: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param _builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


