# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetResolverFirewallRuleGroupResult',
    'AwaitableGetResolverFirewallRuleGroupResult',
    'get_resolver_firewall_rule_group',
    'get_resolver_firewall_rule_group_output',
]

@pulumi.output_type
class GetResolverFirewallRuleGroupResult:
    """
    A collection of values returned by getResolverFirewallRuleGroup.
    """
    def __init__(__self__, arn=None, creation_time=None, creator_request_id=None, firewall_rule_group_id=None, id=None, modification_time=None, name=None, owner_id=None, region=None, rule_count=None, share_status=None, status=None, status_message=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if creator_request_id and not isinstance(creator_request_id, str):
            raise TypeError("Expected argument 'creator_request_id' to be a str")
        pulumi.set(__self__, "creator_request_id", creator_request_id)
        if firewall_rule_group_id and not isinstance(firewall_rule_group_id, str):
            raise TypeError("Expected argument 'firewall_rule_group_id' to be a str")
        pulumi.set(__self__, "firewall_rule_group_id", firewall_rule_group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if modification_time and not isinstance(modification_time, str):
            raise TypeError("Expected argument 'modification_time' to be a str")
        pulumi.set(__self__, "modification_time", modification_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owner_id and not isinstance(owner_id, str):
            raise TypeError("Expected argument 'owner_id' to be a str")
        pulumi.set(__self__, "owner_id", owner_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if rule_count and not isinstance(rule_count, int):
            raise TypeError("Expected argument 'rule_count' to be a int")
        pulumi.set(__self__, "rule_count", rule_count)
        if share_status and not isinstance(share_status, str):
            raise TypeError("Expected argument 'share_status' to be a str")
        pulumi.set(__self__, "share_status", share_status)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_message and not isinstance(status_message, str):
            raise TypeError("Expected argument 'status_message' to be a str")
        pulumi.set(__self__, "status_message", status_message)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        The ARN (Amazon Resource Name) of the rule group.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> _builtins.str:
        """
        The date and time that the rule group was created, in Unix time format and Coordinated Universal Time (UTC).
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter(name="creatorRequestId")
    def creator_request_id(self) -> _builtins.str:
        """
        A unique string defined by you to identify the request.
        """
        return pulumi.get(self, "creator_request_id")

    @_builtins.property
    @pulumi.getter(name="firewallRuleGroupId")
    def firewall_rule_group_id(self) -> _builtins.str:
        return pulumi.get(self, "firewall_rule_group_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="modificationTime")
    def modification_time(self) -> _builtins.str:
        """
        The date and time that the rule group was last modified, in Unix time format and Coordinated Universal Time (UTC).
        """
        return pulumi.get(self, "modification_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the rule group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> _builtins.str:
        """
        The Amazon Web Services account ID for the account that created the rule group. When a rule group is shared with your account, this is the account that has shared the rule group with you.
        """
        return pulumi.get(self, "owner_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="ruleCount")
    def rule_count(self) -> _builtins.int:
        """
        The number of rules in the rule group.
        """
        return pulumi.get(self, "rule_count")

    @_builtins.property
    @pulumi.getter(name="shareStatus")
    def share_status(self) -> _builtins.str:
        """
        Whether the rule group is shared with other Amazon Web Services accounts, or was shared with the current account by another Amazon Web Services account.
        """
        return pulumi.get(self, "share_status")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the rule group.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> _builtins.str:
        """
        Additional information about the status of the rule group, if available.
        """
        return pulumi.get(self, "status_message")


class AwaitableGetResolverFirewallRuleGroupResult(GetResolverFirewallRuleGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResolverFirewallRuleGroupResult(
            arn=self.arn,
            creation_time=self.creation_time,
            creator_request_id=self.creator_request_id,
            firewall_rule_group_id=self.firewall_rule_group_id,
            id=self.id,
            modification_time=self.modification_time,
            name=self.name,
            owner_id=self.owner_id,
            region=self.region,
            rule_count=self.rule_count,
            share_status=self.share_status,
            status=self.status,
            status_message=self.status_message)


def get_resolver_firewall_rule_group(firewall_rule_group_id: Optional[_builtins.str] = None,
                                     region: Optional[_builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResolverFirewallRuleGroupResult:
    """
    `route53.ResolverFirewallRuleGroup` Retrieves the specified firewall rule group.

    This data source allows to retrieve details about a specific a Route 53 Resolver DNS Firewall rule group.

    ## Example Usage

    The following example shows how to get a firewall rule group from its ID.

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.route53.get_resolver_firewall_rule_group(firewall_rule_group_id="rslvr-frg-example")
    ```


    :param _builtins.str firewall_rule_group_id: The ID of the rule group.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['firewallRuleGroupId'] = firewall_rule_group_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:route53/getResolverFirewallRuleGroup:getResolverFirewallRuleGroup', __args__, opts=opts, typ=GetResolverFirewallRuleGroupResult).value

    return AwaitableGetResolverFirewallRuleGroupResult(
        arn=pulumi.get(__ret__, 'arn'),
        creation_time=pulumi.get(__ret__, 'creation_time'),
        creator_request_id=pulumi.get(__ret__, 'creator_request_id'),
        firewall_rule_group_id=pulumi.get(__ret__, 'firewall_rule_group_id'),
        id=pulumi.get(__ret__, 'id'),
        modification_time=pulumi.get(__ret__, 'modification_time'),
        name=pulumi.get(__ret__, 'name'),
        owner_id=pulumi.get(__ret__, 'owner_id'),
        region=pulumi.get(__ret__, 'region'),
        rule_count=pulumi.get(__ret__, 'rule_count'),
        share_status=pulumi.get(__ret__, 'share_status'),
        status=pulumi.get(__ret__, 'status'),
        status_message=pulumi.get(__ret__, 'status_message'))
def get_resolver_firewall_rule_group_output(firewall_rule_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                                            region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResolverFirewallRuleGroupResult]:
    """
    `route53.ResolverFirewallRuleGroup` Retrieves the specified firewall rule group.

    This data source allows to retrieve details about a specific a Route 53 Resolver DNS Firewall rule group.

    ## Example Usage

    The following example shows how to get a firewall rule group from its ID.

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.route53.get_resolver_firewall_rule_group(firewall_rule_group_id="rslvr-frg-example")
    ```


    :param _builtins.str firewall_rule_group_id: The ID of the rule group.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['firewallRuleGroupId'] = firewall_rule_group_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:route53/getResolverFirewallRuleGroup:getResolverFirewallRuleGroup', __args__, opts=opts, typ=GetResolverFirewallRuleGroupResult)
    return __ret__.apply(lambda __response__: GetResolverFirewallRuleGroupResult(
        arn=pulumi.get(__response__, 'arn'),
        creation_time=pulumi.get(__response__, 'creation_time'),
        creator_request_id=pulumi.get(__response__, 'creator_request_id'),
        firewall_rule_group_id=pulumi.get(__response__, 'firewall_rule_group_id'),
        id=pulumi.get(__response__, 'id'),
        modification_time=pulumi.get(__response__, 'modification_time'),
        name=pulumi.get(__response__, 'name'),
        owner_id=pulumi.get(__response__, 'owner_id'),
        region=pulumi.get(__response__, 'region'),
        rule_count=pulumi.get(__response__, 'rule_count'),
        share_status=pulumi.get(__response__, 'share_status'),
        status=pulumi.get(__response__, 'status'),
        status_message=pulumi.get(__response__, 'status_message')))
